/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class ResourceConnection {
    private InputStream stream = null;
    private String absuri = null;
    private String redirect = null;
    private int statusCode = -1;
    private String contentType = null;
    private String etag = null;

    public ResourceConnection(String string) {
        try {
            URI uRI = new URI(string);
            URL uRL = uRI.toURL();
            this.absuri = uRL.toString();
            if (this.absuri.startsWith("http:") || this.absuri.startsWith("https:")) {
                HttpClient httpClient = new HttpClient();
                GetMethod getMethod = new GetMethod(this.absuri);
                getMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
                this.statusCode = httpClient.executeMethod((HttpMethod)getMethod);
                this.contentType = this.getHeader(getMethod, "Content-Type", "application/octet-stream");
                this.etag = this.getHeader(getMethod, "Etag", null);
                if (this.statusCode == 200) {
                    this.stream = getMethod.getResponseBodyAsStream();
                    this.redirect = getMethod.getURI().toString();
                    if (this.absuri.equals(this.redirect)) {
                        this.redirect = null;
                    }
                }
            } else {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                this.stream = uRLConnection.getInputStream();
                this.contentType = null;
                this.etag = uRLConnection.getHeaderField("etag");
                this.statusCode = 200;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getURI() {
        return this.absuri;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private String getHeader(GetMethod getMethod, String string, String string2) {
        Header header = getMethod.getResponseHeader(string);
        if (header == null) {
            return string2;
        }
        HeaderElement[] headerElementArray = header.getElements();
        if (headerElementArray == null || headerElementArray.length == 0) {
            return string2;
        }
        return headerElementArray[0].getName();
    }
}

