/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import org.xmlresolver.Catalog;
import org.xmlresolver.NamespaceResolver;
import org.xmlresolver.Resource;
import org.xmlresolver.ResourceResolver;

public class Resolver
implements URIResolver,
EntityResolver,
EntityResolver2,
NamespaceResolver,
LSResourceResolver {
    private static Logger logger = Logger.getLogger(Resolver.class.getName());
    ResourceResolver resolver = null;

    public Resolver() {
        this.resolver = new ResourceResolver();
        this.resolver.setEntityResolver(this);
    }

    public Resolver(Catalog catalog) {
        this.resolver = new ResourceResolver(catalog);
        this.resolver.setEntityResolver(this);
    }

    public Resolver(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public Catalog getCatalog() {
        return this.resolver.getCatalog();
    }

    public Resource resolveResource(String href, String base) {
        if (href == null || "".equals(href)) {
            href = base;
            base = null;
        }
        logger.finer("resolveResource(" + href + "," + base + ")");
        Resource rsrc = this.resolver.resolveURI(href, base);
        logger.finer(href + (base == null ? "" : " (" + base + ")") + " => " + (rsrc == null ? href : rsrc.uri()));
        return rsrc;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        Resource rsrc = this.resolveResource(href, base);
        if (rsrc == null) {
            return null;
        }
        SAXSource source = new SAXSource(new InputSource(rsrc.body()));
        source.setSystemId(rsrc.uri());
        return source;
    }

    @Override
    public Source resolveNamespace(String uri, String nature, String purpose) throws TransformerException {
        logger.finer("resolveNamespace(" + uri + "," + nature + "," + purpose + ")");
        Resource rsrc = this.resolver.resolveNamespaceURI(uri, nature, purpose);
        logger.finer(uri + " (" + nature + "," + purpose + ") => " + (rsrc == null ? uri : rsrc.uri()));
        if (rsrc == null) {
            return null;
        }
        SAXSource source = new SAXSource(new InputSource(rsrc.body()));
        source.setSystemId(rsrc.uri());
        return source;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        logger.finer("resolveEntity(" + publicId + "," + systemId + ")");
        Resource rsrc = this.resolver.resolvePublic(systemId, publicId);
        logger.finer(systemId + (publicId == null ? "" : " (" + publicId + ")") + " => " + (rsrc == null ? systemId : rsrc.uri()));
        if (rsrc == null) {
            return null;
        }
        InputSource source = new InputSource(rsrc.body());
        source.setSystemId(rsrc.uri());
        return source;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        logger.finer("getExternalSubset(" + name + "," + baseURI + ")");
        Resource rsrc = this.resolver.resolveDoctype(name);
        logger.finer(baseURI + (name == null ? "" : " (" + name + ")") + " => " + (rsrc == null ? baseURI : rsrc.uri()));
        if (rsrc == null) {
            return null;
        }
        InputSource source = new InputSource(rsrc.body());
        source.setSystemId(rsrc.uri());
        return source;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        String absSystem = null;
        if (baseURI != null) {
            try {
                URI auri = new URI(baseURI);
                auri = auri.resolve(new URI(systemId));
                absSystem = auri.toURL().toString();
            }
            catch (URISyntaxException use) {
            }
            catch (MalformedURLException mue) {
            }
            catch (IllegalArgumentException iae) {}
        } else {
            try {
                URL url = new URL(systemId);
                absSystem = url.toExternalForm();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        logger.finer("resolveEntity(" + name + "," + publicId + "," + absSystem + ")");
        Resource rsrc = this.resolver.resolveEntity(name, absSystem, publicId);
        logger.finer(absSystem + (publicId == null ? "" : " (" + publicId + ")") + " => " + (rsrc == null ? absSystem : rsrc.uri()));
        if (rsrc == null) {
            return null;
        }
        InputSource source = new InputSource(rsrc.body());
        source.setSystemId(rsrc.uri());
        return source;
    }

    @Override
    public LSInput resolveResource(String type, String namespace, String publicId, String systemId, String baseURI) {
        String absSystem = null;
        if (baseURI != null) {
            try {
                URI auri = new URI(baseURI);
                auri = auri.resolve(new URI(systemId));
                absSystem = auri.toURL().toString();
            }
            catch (URISyntaxException use) {
            }
            catch (MalformedURLException mue) {
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        Resource rsrc = null;
        if ("http://www.w3.org/TR/REC-xml".equals(type)) {
            logger.finer("resolveResource(XML," + publicId + "," + absSystem + ")");
            rsrc = this.resolver.resolvePublic(absSystem, publicId);
        } else if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
            logger.finer("resolveResource(XMLSchema," + namespace + "," + absSystem + ")");
            rsrc = this.resolver.resolveURI(absSystem, baseURI);
        } else {
            return null;
        }
        logger.finer(absSystem + (publicId == null ? "" : " (" + publicId + ")") + (namespace == null ? "" : " (" + namespace + ")") + " => " + (rsrc == null ? absSystem : rsrc.uri()));
        if (rsrc == null) {
            return null;
        }
        return new ResolverLSInput(rsrc, publicId);
    }

    class ResolverLSInput
    implements LSInput {
        Resource rsrc = null;
        String publicId = null;

        public ResolverLSInput(Resource rsrc, String publicId) {
            this.rsrc = rsrc;
            this.publicId = publicId;
        }

        @Override
        public Reader getCharacterStream() {
            return new InputStreamReader(this.rsrc.body());
        }

        @Override
        public void setCharacterStream(Reader reader) {
            throw new UnsupportedOperationException("Can't set character stream on resolver LSInput");
        }

        @Override
        public InputStream getByteStream() {
            return this.rsrc.body();
        }

        @Override
        public void setByteStream(InputStream inputStream) {
            throw new UnsupportedOperationException("Can't set byte stream on resolver LSInput");
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String string) {
            throw new UnsupportedOperationException("Can't set string data on resolver LSInput");
        }

        @Override
        public String getSystemId() {
            return this.rsrc.uri();
        }

        @Override
        public void setSystemId(String string) {
            throw new UnsupportedOperationException("Can't set system ID on resolver LSInput");
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String string) {
            throw new UnsupportedOperationException("Can't set public ID on resolver LSInput");
        }

        @Override
        public String getBaseURI() {
            return this.rsrc.uri();
        }

        @Override
        public void setBaseURI(String string) {
            throw new UnsupportedOperationException("Can't set base URI on resolver LSInput");
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String string) {
            throw new UnsupportedOperationException("Can't set encoding on resolver LSInput");
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean b) {
            throw new UnsupportedOperationException("Can't set certified text on resolver LSInput");
        }
    }
}

