/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xmlresolver.Catalog;

public class Configuration {
    private final Properties properties;
    private final URL propertiesFileUri;

    private static boolean isTrue(String string) {
        return "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "1".equalsIgnoreCase(string);
    }

    public static Configuration create(String string) {
        if (string != null) {
            for (String string2 : string.split(";")) {
                URL uRL;
                if ("".equals(string2) || (uRL = Catalog.class.getResource("/" + string2)) == null) continue;
                InputStream inputStream = Catalog.class.getResourceAsStream("/" + string2);
                if (inputStream == null) {
                    Catalog.logger.warning("Cannot find " + string2);
                    continue;
                }
                Properties properties = new Properties();
                try {
                    properties.load(inputStream);
                    return new Configuration(properties, uRL);
                }
                catch (IOException iOException) {
                    Catalog.logger.warning("I/O error reading " + string2);
                }
            }
        }
        return new Configuration(null, null);
    }

    public Configuration(Properties properties, URL uRL) {
        this.properties = properties;
        this.propertiesFileUri = uRL;
    }

    private String getProperty(String string) {
        return this.properties != null ? this.properties.getProperty(string) : null;
    }

    private String getProperty(String string, String string2) {
        String string3 = System.getProperty(string);
        return string3 != null ? string3 : this.getProperty(string2);
    }

    public Vector<String> queryCatalogFiles() {
        Object object;
        String string = System.getProperty("xml.catalog.files");
        boolean bl = false;
        boolean bl2 = true;
        if (this.properties != null) {
            if (string == null && (string = this.properties.getProperty("catalogs")) != null) {
                bl = true;
            }
            if ((object = this.properties.getProperty("relative-catalogs")) != null) {
                bl2 = Configuration.isTrue((String)object);
            }
        }
        if (string == null) {
            string = "./catalog.xml";
        }
        object = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            URL uRL = null;
            if (bl && !bl2) {
                try {
                    uRL = new URL(this.propertiesFileUri, string2);
                    string2 = uRL.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ((Vector)object).add(string2);
        }
        return object;
    }

    public boolean queryPreferPublic() {
        String string = this.getProperty("xml.catalog.prefer", "prefer");
        return string == null || "public".equalsIgnoreCase(string);
    }

    public String queryCache() {
        String string;
        String string2 = this.getProperty("xml.catalog.cache", "cache");
        if (string2 == null && Configuration.isTrue(this.getProperty("xml.catalog.cacheUnderHome", "cacheUnderHome")) && (string = System.getProperty("user.home")) != null && !"".equals(string)) {
            String string3 = string + "/.xmlresolver/cache";
            File file = new File(string3);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!file.exists() || !file.isDirectory()) {
                Catalog.logger.warning("Could not create default cache directory: " + string3);
            } else {
                string2 = string3;
            }
        }
        return string2;
    }

    public boolean queryCacheSchemeURI(String string) {
        if (string == null) {
            return false;
        }
        String string2 = this.getProperty("xml.catalog.cache." + string, "cache-" + string + "-uri");
        if (string2 == null) {
            return !"file".equals(string);
        }
        return Configuration.isTrue(string2);
    }
}

