/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.parsers;

import com.nwalsh.parsers.CmdLineParser;
import com.nwalsh.parsers.XJParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xmlresolver.Catalog;
import org.xmlresolver.Resolver;

public class XJParse {
    public static final String VERSION = XJParse.initializeVersion();

    public static void main(String[] stringArray) throws FileNotFoundException, IOException {
        XJParse xJParse = new XJParse();
        xJParse.run(stringArray);
    }

    public void run(String[] stringArray) throws FileNotFoundException, IOException {
        String string3;
        CmdLineParser cmdLineParser = new CmdLineParser(stringArray);
        if (cmdLineParser.xmlfile == null && !cmdLineParser.fullChecking) {
            System.out.println("XJParse version " + VERSION);
            System.out.println("Usage: com.nwalsh.parsers.xjparse [opts] xmlfile");
            System.out.println("");
            System.out.println("Where:");
            System.out.println("");
            System.out.println("-c catalogfile   Load a particular catalog file");
            System.out.println("-v               Enable DTD validation");
            System.out.println("-s               Enable W3C XML Schema validation");
            System.out.println("-S schema.xsd    Use schema.xsd for validation (implies -s)");
            System.out.println("-f               Enable full schema checking (implies -s)");
            System.out.println("-n               Perform a namespace-ignorant parse");
            System.out.println("-N               Perform a namespace-aware parse (the default)");
            System.out.println("-E integer       Set the maximum number of errors to display");
            System.out.println("");
            System.out.println("The process ends with error-level 1, if there are errors.");
            System.exit(1);
        }
        XJParser xJParser = new XJParser();
        Hashtable<String, String> hashtable = XJParse.lookupSchemas(cmdLineParser.xsdFiles);
        String string2 = null;
        for (String string3 : cmdLineParser.catalogFiles) {
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            string2 = string2 + ";" + string3;
        }
        Resolver resolver = null;
        if (string2 != null) {
            string3 = new Catalog(string2);
            resolver = new Resolver((Catalog)string3);
        } else {
            resolver = new Resolver();
        }
        xJParser.setDtdValidate(cmdLineParser.validating);
        xJParser.setNamespaceAware(cmdLineParser.nsAware);
        xJParser.setMaxMessages(cmdLineParser.maxErrs);
        xJParser.setXsdValidate(cmdLineParser.useSchema || !cmdLineParser.xsdFiles.isEmpty());
        xJParser.setFullChecking(cmdLineParser.fullChecking);
        xJParser.setResolver(resolver);
        if (hashtable.size() > 0) {
            xJParser.setSchemas(hashtable.values());
        }
        if (cmdLineParser.xmlfile != null) {
            String string4;
            string3 = cmdLineParser.validating ? "validating" : "well-formed";
            String string5 = string4 = cmdLineParser.nsAware ? "namespace-aware" : "namespace-ignorant";
            if (cmdLineParser.maxErrs > 0) {
                System.out.println("Attempting " + string3 + ", " + string4 + " parse");
            }
            xJParser.parse(cmdLineParser.xmlfile);
        } else {
            System.exit(0);
        }
        xJParser.printParseStats();
        if (xJParser.getErrorCount() > 0) {
            System.exit(1);
        }
    }

    private static Hashtable<String, String> lookupSchemas(Vector<String> vector) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            for (String string : vector) {
                string = string.replaceAll(" ", "%20");
                Document document = documentBuilder.parse(string);
                Element element = document.getDocumentElement();
                string = element.getBaseURI();
                String string2 = element.getAttribute("targetNamespace");
                if (string2 == null || "".equals(string2)) {
                    hashtable.put("", string);
                    continue;
                }
                hashtable.put(string2, string);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashtable;
    }

    private static String initializeVersion() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = XJParse.class.getResourceAsStream("/etc/version.properties");
            if (inputStream == null) {
                throw new UnsupportedOperationException("JAR file doesn't contain version.properties file!?");
            }
            properties.load(inputStream);
            String string = properties.getProperty("version.major");
            String string2 = properties.getProperty("version.minor");
            String string3 = properties.getProperty("version.release");
            if (string == null || string2 == null || string3 == null) {
                throw new UnsupportedOperationException("Invalid version.properties in JAR file!?");
            }
            return string + "." + string2 + "." + string3;
        }
        catch (IOException iOException) {
            throw new UnsupportedOperationException("No version.properties in JAR file!?");
        }
    }
}

