/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlresolver.CatalogResult;
import org.xmlresolver.CatalogSource;
import org.xmlresolver.Configuration;
import org.xmlresolver.ResourceCache;
import org.xmlresolver.helpers.DOMUtils;
import org.xmlresolver.helpers.PublicId;
import org.xmlresolver.helpers.URIUtils;

public class Catalog {
    public static final String NS_CATALOG = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final String NS_RDDL = "http://www.rddl.org/";
    public static final String NS_XLINK = "http://www.w3.org/1999/xlink";
    public static final String NS_XMLRESOURCE_EXT = "http://xmlresolver.org/ns/catalog";
    public static Logger logger = Logger.getLogger("org.xmlresolver");
    private Configuration conf;
    private Vector<CatalogSource> catalogList = new Vector();
    private Vector<Document> documentList = new Vector();
    private ResourceCache cache = null;

    private static String defaultPropertiesFiles() {
        String string = System.getProperty("xmlresolver.properties");
        return (string != null ? string + ";" : "") + "XMLResolver.properties;CatalogManager.properties";
    }

    public Catalog() {
        this(Catalog.defaultPropertiesFiles(), (String)null);
    }

    public Catalog(String string) {
        this(Catalog.defaultPropertiesFiles(), string);
    }

    public Catalog(String string, String string2) {
        this(Configuration.create(string), string2);
    }

    public Catalog(Configuration configuration, String string) {
        this(configuration, Catalog.createSources(configuration, string));
    }

    public Catalog(Configuration configuration, Vector<CatalogSource> vector) {
        this.conf = configuration;
        this.catalogList = vector;
        this.setCacheDir(configuration.queryCache());
    }

    public final void setCacheDir(String string) {
        this.cache = string != null && !string.equals("") ? new ResourceCache(string) : null;
    }

    public String catalogList() {
        String string = "";
        for (CatalogSource catalogSource : this.catalogList) {
            if (string.length() > 0) {
                string = string + ";";
            }
            string = string + catalogSource;
        }
        return string;
    }

    public ResourceCache cache() {
        return this.cache;
    }

    public boolean cacheSchemeURI(String string) {
        return this.conf.queryCacheSchemeURI(string);
    }

    private synchronized Document loadCatalog(int n) {
        Element element;
        if (n < this.documentList.size()) {
            return this.documentList.get(n);
        }
        CatalogSource catalogSource = this.catalogList.get(n);
        Document document = catalogSource.parse();
        while (this.documentList.size() <= n) {
            this.documentList.add(null);
        }
        this.documentList.set(n, document);
        int n2 = 1;
        if (document != null && this.catalogElement(element = document.getDocumentElement(), "catalog")) {
            Element element2 = DOMUtils.getFirstElement(element);
            while (element2 != null) {
                if (this.catalogElement(element2, "nextCatalog")) {
                    Element element3 = element2;
                    String string = DOMUtils.makeAbsolute(element3, element3.getAttribute("catalog"));
                    logger.finer("Next catalog: " + element3.getAttribute("catalog") + " (" + string + ")");
                    if (n + n2 >= this.catalogList.size()) {
                        this.catalogList.add(new CatalogSource.UriCatalogSource(string));
                    } else {
                        this.catalogList.insertElementAt(new CatalogSource.UriCatalogSource(string), n + n2);
                    }
                    ++n2;
                }
                element2 = DOMUtils.getNextElement(element2);
            }
        }
        return document;
    }

    private boolean catalogElement(Node node, String string) {
        return node.getNodeType() == 1 && string.equals(node.getLocalName()) && NS_CATALOG.equals(node.getNamespaceURI());
    }

    private Vector<Element> entries(Element element, String string) {
        Vector<Element> vector = new Vector<Element>();
        this.findMatches(vector, element, string, null, null, null, null);
        return vector;
    }

    private Vector<Element> entries(Element element, String string, String string2, String string3, String string4, String string5) {
        Vector<Element> vector = new Vector<Element>();
        this.findMatches(vector, element, string, string2, string3, string4, string5);
        return vector;
    }

    private void findMatches(Vector<Element> vector, Element element, String string, String string2, String string3, String string4, String string5) {
        if (this.catalogElement(element, "group") || this.catalogElement(element, "catalog")) {
            Element element2 = DOMUtils.getFirstElement(element);
            while (element2 != null) {
                if (this.catalogElement(element2, string) && (string2 == null || string3.equals(element2.getAttribute(string2)))) {
                    String string6;
                    String string7 = element2.hasAttributeNS(NS_RDDL, "nature") ? element2.getAttributeNS(NS_RDDL, "nature") : null;
                    String string8 = string6 = element2.hasAttributeNS(NS_RDDL, "purpose") ? element2.getAttributeNS(NS_RDDL, "purpose") : null;
                    if ((string4 == null || string4.equals(string7)) && (string5 == null || string5.equals(string6))) {
                        vector.add(element2);
                    }
                }
                if (this.catalogElement(element2, "group")) {
                    this.findMatches(vector, element2, string, string2, string3, string4, string5);
                }
                element2 = DOMUtils.getNextElement(element2);
            }
        }
    }

    public CatalogResult lookupURI(String string) {
        logger.finer("lookupURI(" + string + ")");
        return this._lookupNamespaceURI(string, null, null);
    }

    public CatalogResult lookupNamespaceURI(String string, String string2, String string3) {
        logger.finer("lookupNamespaceURI(" + string + "," + string2 + "," + string3 + ")");
        return this._lookupNamespaceURI(string, string2, string3);
    }

    private CatalogResult _lookupNamespaceURI(String string, String string2, String string3) {
        Object object;
        if (string == null) {
            throw new NullPointerException("Null uri passed to Catalog.");
        }
        if ((string = URIUtils.normalizeURI(string)).startsWith("urn:publicid:")) {
            return this.lookupPublic(PublicId.decodeURN(string), null);
        }
        for (int i = 0; i < this.catalogList.size(); ++i) {
            this.loadCatalog(i);
            object = this.documentList.get(i);
            if (object == null) continue;
            logger.finer("  Looking in catalog: " + object.getBaseURI());
            CatalogResult catalogResult = this.lookupURI(object.getDocumentElement(), string, string2, string3);
            if (catalogResult == null) continue;
            logger.finer("  Found: " + catalogResult);
            return catalogResult;
        }
        if (this.cache != null && this.cache.catalog() != null) {
            logger.finer("  Looking in cache: " + this.cache.catalog().getBaseURI());
            object = this.lookupURI(this.cache.catalog().getDocumentElement(), string, string2, string3);
            if (object != null) {
                logger.finer("  Found: " + object);
                return object;
            }
        }
        logger.finer("  Not found");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected CatalogResult lookupURI(Element element, String string, String string2, String string3) {
        Iterator<Element> iterator = this.entries(element, "uri", "name", string, string2, string3).iterator();
        if (iterator.hasNext()) {
            void var9_16;
            Element element2 = iterator.next();
            String string4 = element2.getAttribute("uri");
            String string5 = element2.getAttribute("name");
            Object var9_14 = null;
            if (element2.hasAttributeNS(NS_XMLRESOURCE_EXT, "redir")) {
                String string6 = element2.getAttributeNS(NS_XMLRESOURCE_EXT, "redir");
            }
            return new CatalogResult((String)(var9_16 == null ? string5 : var9_16), DOMUtils.makeAbsolute(element2, string4), element2, this.cache);
        }
        iterator = null;
        Element iterator2 = null;
        for (Element object32 : this.entries(element, "rewriteURI", null, string, string2, string3)) {
            String string7 = object32.getAttribute("uriStartString");
            if (string7.length() > string.length() || !string7.equals(string.substring(0, string7.length())) || iterator != null && string7.length() <= ((String)((Object)iterator)).length()) continue;
            iterator = string7;
            iterator2 = object32;
        }
        if (iterator2 != null) {
            return new CatalogResult(string, DOMUtils.makeAbsolute(iterator2, iterator2.getAttribute("rewritePrefix") + string.substring(((String)((Object)iterator)).length())), iterator2, this.cache);
        }
        Object object4 = null;
        iterator2 = null;
        for (Element element2 : this.entries(element, "uriSuffix", null, string, string2, string3)) {
            String string8 = element2.getAttribute("uriSuffix");
            if (string8.length() > string.length() || !string.endsWith(string8) || object4 != null && string8.length() <= ((String)object4).length()) continue;
            object4 = string8;
            iterator2 = element2;
        }
        if (iterator2 != null) {
            return new CatalogResult(string, DOMUtils.makeAbsolute(iterator2, iterator2.getAttribute("uri")), iterator2, this.cache);
        }
        Vector<String> vector = new Vector<String>();
        for (Element element3 : this.entries(element, "delegateURI", null, string, string2, string3)) {
            String string9 = element3.getAttribute("uriStartString");
            if (string9.length() > string.length() || !string9.equals(string.substring(0, string9.length()))) continue;
            vector.add(DOMUtils.makeAbsolute(element3, element3.getAttribute("catalog")));
        }
        if (!vector.isEmpty()) {
            void var10_28;
            Catalog catalog = new Catalog(this.conf, Catalog.toCatalogSources(vector));
            Object var10_25 = null;
            if (string2 != null || string3 != null) {
                CatalogResult catalogResult = catalog.lookupNamespaceURI(string, string2, string3);
            } else {
                CatalogResult catalogResult = catalog.lookupURI(string);
            }
            return var10_28;
        }
        return null;
    }

    public CatalogResult lookupPublic(String string, String string2) {
        Object object;
        logger.finer("lookupPublic(" + string + "," + string2 + ")");
        if (string != null) {
            string = URIUtils.normalizeURI(string);
        }
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
        }
        if (string != null && string.startsWith("urn:publicid:")) {
            string = PublicId.decodeURN(string);
            if (string2 != null && !string2.equals(string)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                string = null;
            } else {
                string2 = string;
                string = null;
            }
        }
        for (int i = 0; i < this.catalogList.size(); ++i) {
            this.loadCatalog(i);
            object = this.documentList.get(i);
            if (object == null) continue;
            logger.finer("  Looking in " + object.getBaseURI());
            CatalogResult catalogResult = this.lookupPublic(object.getDocumentElement(), string, string2);
            if (catalogResult == null) continue;
            logger.finer("  Found: " + catalogResult);
            return catalogResult;
        }
        if (this.cache != null && this.cache.catalog() != null) {
            logger.finer("  Looking in " + this.cache.catalog().getBaseURI());
            object = this.lookupPublic(this.cache.catalog().getDocumentElement(), string, string2);
            if (object != null) {
                logger.finer("  Found: " + object);
                return object;
            }
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupPublic(Element element, String string, String string2) {
        if (this.catalogElement(element, "group") || this.catalogElement(element, "catalog")) {
            CatalogResult catalogResult;
            if (string != null && (catalogResult = this.lookupLocalSystem(element, string)) != null) {
                return catalogResult;
            }
            if (string2 != null && (catalogResult = this.lookupLocalPublic(element, string, string2)) != null) {
                return catalogResult;
            }
        }
        return null;
    }

    protected CatalogResult lookupLocalPublic(Element element, String string, String string2) {
        Object object;
        Vector<String> vector;
        string2 = PublicId.normalize(string2);
        if (string != null && (vector = this.lookupLocalSystem(element, string)) != null) {
            return vector;
        }
        for (Element object2 : this.entries(element, "public", "publicId", string2, null, null)) {
            Object object3;
            boolean element2 = this.conf.queryPreferPublic();
            object = object2;
            while (object != null && object.getNodeType() == 1) {
                object3 = object;
                if (object3.hasAttribute("prefer")) {
                    element2 = "public".equals(object3.getAttribute("prefer"));
                    object = null;
                    continue;
                }
                object = object.getParentNode();
            }
            if (!element2 && string != null) continue;
            object3 = DOMUtils.makeAbsolute(object2, object2.getAttribute("uri"));
            Object object4 = string;
            if (object4 == null) {
                object4 = object3;
            }
            return new CatalogResult((String)object4, (String)object3, object2, this.cache);
        }
        vector = new Vector<String>();
        for (Element element2 : this.entries(element, "delegatePublic", null, null, null, null)) {
            object = element2.getAttribute("publicIdStartString");
            if (((String)object).length() > string.length() || !((String)object).equals(string.substring(0, ((String)object).length()))) continue;
            vector.add(DOMUtils.makeAbsolute(element2, element2.getAttribute("catalog")));
        }
        if (!vector.isEmpty()) {
            Catalog catalog = new Catalog(this.conf, Catalog.toCatalogSources(vector));
            CatalogResult catalogResult = catalog.lookupSystem(string);
            return catalogResult;
        }
        return null;
    }

    public CatalogResult lookupSystem(String string) {
        Object object;
        logger.finer("lookupSystem(" + string + ")");
        string = URIUtils.normalizeURI(string);
        if (string != null && string.startsWith("urn:publicid:")) {
            return this.lookupPublic(PublicId.decodeURN(string), null);
        }
        for (int i = 0; i < this.catalogList.size(); ++i) {
            this.loadCatalog(i);
            object = this.documentList.get(i);
            if (object == null) continue;
            logger.finer("  Looking in " + object.getBaseURI());
            CatalogResult catalogResult = this.lookupLocalSystem(object.getDocumentElement(), string);
            if (catalogResult == null) continue;
            logger.finer("  Found: " + catalogResult);
            return catalogResult;
        }
        if (this.cache != null && this.cache.catalog() != null) {
            logger.finer("  Looking in " + this.cache.catalog().getBaseURI());
            object = this.lookupLocalSystem(this.cache.catalog().getDocumentElement(), string);
            if (object != null) {
                logger.finer("  Found: " + object);
                return object;
            }
        }
        logger.finer("  Not found");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected CatalogResult lookupLocalSystem(Element element, String string) {
        void var6_11;
        void var6_8;
        String string2 = System.getProperty("os.name");
        boolean bl = string2.indexOf("Windows") >= 0;
        for (Element object42 : this.entries(element, "system", null, null, null, null)) {
            if (!string.equals(object42.getAttribute("systemId")) && (!bl || !string.equalsIgnoreCase(object42.getAttribute("systemId")))) continue;
            return new CatalogResult(string, DOMUtils.makeAbsolute(object42, object42.getAttribute("uri")), object42, this.cache);
        }
        Object object5 = null;
        Object var6_7 = null;
        for (Element element2 : this.entries(element, "rewriteSystem", null, null, null, null)) {
            String string3 = element2.getAttribute("uriStartString");
            if (string3.length() > string.length() || !string3.equals(string.substring(0, string3.length())) || object5 != null && string3.length() <= ((String)object5).length()) continue;
            object5 = string3;
            Element element3 = element2;
        }
        if (var6_8 != null) {
            return new CatalogResult(string, DOMUtils.makeAbsolute((Element)var6_8, var6_8.getAttribute("rewritePrefix") + string.substring(((String)object5).length())), (Element)var6_8, this.cache);
        }
        Object object = null;
        Object var6_10 = null;
        for (Element element4 : this.entries(element, "systemSuffix", null, null, null, null)) {
            String string4 = element4.getAttribute("systemIdSuffix");
            if (string4.length() > string.length() || !string.endsWith(string4) || object != null && string4.length() <= ((String)object).length()) continue;
            object = string4;
            Element element5 = element4;
        }
        if (var6_11 != null) {
            return new CatalogResult(string, DOMUtils.makeAbsolute((Element)var6_11, var6_11.getAttribute("uri")), (Element)var6_11, this.cache);
        }
        Vector<String> vector = new Vector<String>();
        for (Element element6 : this.entries(element, "delegateSystem", null, null, null, null)) {
            String string5 = element6.getAttribute("systemIdStartString");
            if (string5.length() > string.length() || !string5.equals(string.substring(0, string5.length()))) continue;
            vector.add(DOMUtils.makeAbsolute(element6, element6.getAttribute("catalog")));
        }
        if (!vector.isEmpty()) {
            Catalog catalog = new Catalog(this.conf, Catalog.toCatalogSources(vector));
            CatalogResult catalogResult = catalog.lookupSystem(string);
            return catalogResult;
        }
        return null;
    }

    public CatalogResult lookupDoctype(String string, String string2, String string3) {
        logger.finer("lookupDoctype(" + string + "," + string3 + "," + string2 + ")");
        string2 = URIUtils.normalizeURI(string2);
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
        }
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
            if (string3 != null && !string3.equals(string2)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                string2 = null;
            } else {
                string3 = string2;
                string2 = null;
            }
        }
        for (int i = 0; i < this.catalogList.size(); ++i) {
            this.loadCatalog(i);
            Document document = this.documentList.get(i);
            if (document == null) continue;
            logger.finer("  Looking in " + document.getBaseURI());
            CatalogResult catalogResult = this.lookupDoctype(document.getDocumentElement(), string, string2, string3);
            if (catalogResult == null) continue;
            logger.finer("  Found: " + catalogResult);
            return catalogResult;
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupDoctype(Element element, String string, String string2, String string3) {
        CatalogResult catalogResult = null;
        if (string2 != null && (catalogResult = this.lookupLocalSystem(element, string2)) != null) {
            return catalogResult;
        }
        if (string3 != null && (catalogResult = this.lookupLocalPublic(element, string2, string3)) != null) {
            return catalogResult;
        }
        for (Element element2 : this.entries(element, "doctype", "name", string, null, null)) {
            Object object;
            boolean bl = this.conf.queryPreferPublic();
            Node node = element2;
            while (node != null && node.getNodeType() == 1) {
                object = node;
                if (object.hasAttribute("prefer")) {
                    bl = "public".equals(object.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!bl && string2 != null) continue;
            object = DOMUtils.makeAbsolute(element2, element2.getAttribute("uri"));
            Object object2 = string2;
            if (object2 == null) {
                object2 = object;
            }
            return new CatalogResult((String)object2, (String)object, element2, this.cache);
        }
        return null;
    }

    public CatalogResult lookupDocument() {
        logger.finer("lookupDocument()");
        for (int i = 0; i < this.catalogList.size(); ++i) {
            this.loadCatalog(i);
            Document document = this.documentList.get(i);
            if (document == null) continue;
            logger.finer("  Looking in " + document.getBaseURI());
            CatalogResult catalogResult = this.lookupDocument(document.getDocumentElement());
            if (catalogResult == null) continue;
            logger.finer("  Found: " + catalogResult);
            return catalogResult;
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupDocument(Element element) {
        Iterator<Element> iterator = this.entries(element, "document", null, null, null, null).iterator();
        if (iterator.hasNext()) {
            Element element2 = iterator.next();
            String string = DOMUtils.makeAbsolute(element2, element2.getAttribute("uri"));
            return new CatalogResult(string, string, element2, this.cache);
        }
        return null;
    }

    public CatalogResult lookupEntity(String string, String string2, String string3) {
        logger.finer("lookupEntity(" + string + "," + string3 + "," + string2 + ")");
        string2 = URIUtils.normalizeURI(string2);
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
        }
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
            if (string3 != null && !string3.equals(string2)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                string2 = null;
            } else {
                string3 = string2;
                string2 = null;
            }
        }
        for (int i = 0; i < this.catalogList.size(); ++i) {
            this.loadCatalog(i);
            Document document = this.documentList.get(i);
            if (document == null) continue;
            logger.finer("  Looking in " + document.getBaseURI());
            CatalogResult catalogResult = this.lookupEntity(document.getDocumentElement(), string, string2, string3);
            if (catalogResult == null) continue;
            logger.finer("  Found: " + catalogResult);
            return catalogResult;
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupEntity(Element element, String string, String string2, String string3) {
        CatalogResult catalogResult = null;
        if (string2 != null && (catalogResult = this.lookupLocalSystem(element, string2)) != null) {
            return catalogResult;
        }
        if (string3 != null && (catalogResult = this.lookupLocalPublic(element, string2, string3)) != null) {
            return catalogResult;
        }
        for (Element element2 : this.entries(element, "entity", "name", string, null, null)) {
            Object object;
            boolean bl = this.conf.queryPreferPublic();
            Node node = element2;
            while (node != null && node.getNodeType() == 1) {
                object = node;
                if (object.hasAttribute("prefer")) {
                    bl = "public".equals(object.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!bl && string2 != null) continue;
            object = DOMUtils.makeAbsolute(element2, element2.getAttribute("uri"));
            Object object2 = string2;
            if (object2 == null) {
                object2 = object;
            }
            return new CatalogResult((String)object2, (String)object, element2, this.cache);
        }
        return null;
    }

    public CatalogResult lookupNotation(String string, String string2, String string3) {
        logger.finer("lookupNotation(" + string + "," + string3 + "," + string2 + ")");
        string2 = URIUtils.normalizeURI(string2);
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
        }
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
            if (string3 != null && !string3.equals(string2)) {
                logger.warning("urn:publicid: system identifier differs from public identifier; using public identifier");
                string2 = null;
            } else {
                string3 = string2;
                string2 = null;
            }
        }
        for (int i = 0; i < this.catalogList.size(); ++i) {
            this.loadCatalog(i);
            Document document = this.documentList.get(i);
            if (document == null) continue;
            logger.finer("  Looking in " + document.getBaseURI());
            CatalogResult catalogResult = this.lookupNotation(document.getDocumentElement(), string, string2, string3);
            if (catalogResult == null) continue;
            logger.finer("  Found: " + catalogResult);
            return catalogResult;
        }
        logger.finer("  Not found");
        return null;
    }

    protected CatalogResult lookupNotation(Element element, String string, String string2, String string3) {
        CatalogResult catalogResult = null;
        if (string2 != null && (catalogResult = this.lookupLocalSystem(element, string2)) != null) {
            return catalogResult;
        }
        if (string3 != null && (catalogResult = this.lookupLocalPublic(element, string2, string3)) != null) {
            return catalogResult;
        }
        for (Element element2 : this.entries(element, "notation", "name", string, null, null)) {
            Object object;
            boolean bl = this.conf.queryPreferPublic();
            Node node = element2;
            while (node != null && node.getNodeType() == 1) {
                object = node;
                if (object.hasAttribute("prefer")) {
                    bl = "public".equals(object.getAttribute("prefer"));
                    node = null;
                    continue;
                }
                node = node.getParentNode();
            }
            if (!bl && string2 != null) continue;
            object = DOMUtils.makeAbsolute(element2, element2.getAttribute("uri"));
            Object object2 = string2;
            if (object2 == null) {
                object2 = object;
            }
            return new CatalogResult((String)object2, (String)object, element2, this.cache);
        }
        return null;
    }

    public synchronized void addSource(CatalogSource catalogSource) {
        this.catalogList.add(catalogSource);
    }

    private static Vector<CatalogSource> createSources(Configuration configuration, String string) {
        Vector<CatalogSource> vector = new Vector<CatalogSource>();
        if (string == null) {
            for (String string2 : configuration.queryCatalogFiles()) {
                vector.add(new CatalogSource.UriCatalogSource(string2));
            }
        } else {
            for (String string3 : string.split(";")) {
                if ("".equals(string3)) continue;
                vector.add(new CatalogSource.UriCatalogSource(string3));
            }
        }
        return vector;
    }

    private static Vector<CatalogSource> toCatalogSources(Vector<String> vector) {
        Vector<CatalogSource> vector2 = new Vector<CatalogSource>();
        for (String string : vector) {
            vector2.add(new CatalogSource.UriCatalogSource(string));
        }
        return vector2;
    }
}

