/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.xmlresolver.Catalog;
import org.xmlresolver.Resolver;
import org.xmlresolver.Resource;
import org.xmlresolver.ResourceResolver;

public class StAXResolver
implements XMLResolver {
    private static Logger logger = Logger.getLogger("org.xmlresolver.StAXResolver");
    ResourceResolver resolver = null;

    public StAXResolver() {
        this.resolver = new ResourceResolver();
        Resolver ordinaryResolver = new Resolver(this.resolver);
        this.resolver.setEntityResolver(ordinaryResolver);
    }

    public StAXResolver(Catalog catalog) {
        this.resolver = new ResourceResolver(catalog);
        Resolver ordinaryResolver = new Resolver(this.resolver);
        this.resolver.setEntityResolver(ordinaryResolver);
    }

    public StAXResolver(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public Catalog getCatalog() {
        return this.resolver.getCatalog();
    }

    @Override
    public Object resolveEntity(String publicId, String systemId, String baseURI, String namespace) throws XMLStreamException {
        String absSystem = null;
        if (baseURI != null) {
            try {
                URI auri = new URI(baseURI);
                auri = auri.resolve(new URI(systemId));
                absSystem = auri.toURL().toString();
            }
            catch (URISyntaxException use) {
            }
            catch (MalformedURLException mue) {
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        logger.finer("resolveEntity(" + publicId + "," + absSystem + "," + namespace + ")");
        Resource rsrc = this.resolver.resolvePublic(publicId, absSystem);
        if (rsrc == null) {
            logger.finer("  not resolved locally");
            return null;
        }
        logger.finer("  resolved locally: " + rsrc.uri());
        return rsrc.body();
    }
}

