/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xmlresolver.Catalog;
import org.xmlresolver.CatalogResult;
import org.xmlresolver.Resource;
import org.xmlresolver.ResourceCache;
import org.xmlresolver.ResourceConnection;
import org.xmlresolver.helpers.DOMUtils;

public class ResourceResolver {
    private static Logger logger = Logger.getLogger("org.xmlresolver");
    private static Catalog staticCatalog = null;
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder builder = null;
    private Catalog catalog = null;
    private ResourceCache cache = null;

    private static synchronized Catalog getStaticCatalog() {
        if (staticCatalog == null) {
            staticCatalog = new Catalog();
        }
        return staticCatalog;
    }

    public ResourceResolver() {
        this.init(ResourceResolver.getStaticCatalog());
    }

    public ResourceResolver(Catalog catalog) {
        this.init(catalog);
    }

    public void setEntityResolver(EntityResolver resolver) {
        builder.setEntityResolver(resolver);
    }

    private void init(Catalog catalog) {
        this.catalog = catalog;
        this.cache = catalog.cache();
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    private Resource streamResult(CatalogResult resolved) {
        try {
            if (resolved.cached()) {
                return new Resource(resolved.body(), resolved.externalURI(), resolved.contentType());
            }
            return new Resource(resolved.body(), resolved.uri(), resolved.contentType());
        }
        catch (MalformedURLException mue) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private Resource cacheStreamURI(String resolved) {
        ResourceConnection conn = new ResourceConnection(resolved);
        if (conn.getStatusCode() == 200) {
            String absuriString = conn.getURI();
            String finalURI = conn.getRedirect();
            if (finalURI == null) {
                finalURI = absuriString;
            }
            if (this.cache != null && this.catalog.cacheSchemeURI(this.getScheme(absuriString)) && this.cache.cacheURI(absuriString)) {
                try {
                    String localName = this.cache.addURI(conn);
                    File localFile = new File(localName);
                    FileInputStream result = new FileInputStream(localFile);
                    return new Resource(result, finalURI);
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            return new Resource(conn.getStream(), finalURI);
        }
        return null;
    }

    private Resource cacheStreamNamespaceURI(String resolved, String nature, String purpose) {
        ResourceConnection conn = new ResourceConnection(resolved);
        if (conn.getStatusCode() == 200) {
            String absuriString = conn.getURI();
            if (this.cache != null && this.catalog.cacheSchemeURI(this.getScheme(absuriString)) && this.cache.cacheURI(absuriString)) {
                try {
                    String localName = this.cache.addNamespaceURI(conn, nature, purpose);
                    File localFile = new File(localName);
                    FileInputStream result = new FileInputStream(localFile);
                    return new Resource(result, absuriString);
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            return new Resource(conn.getStream(), absuriString);
        }
        return null;
    }

    private Resource cacheStreamSystem(String resolved, String publicId) {
        ResourceConnection conn = new ResourceConnection(resolved);
        if (conn.getStatusCode() == 200) {
            String absuriString = conn.getURI();
            if (this.cache != null && this.catalog.cacheSchemeURI(this.getScheme(absuriString)) && this.cache.cacheURI(absuriString)) {
                try {
                    String localName = this.cache.addSystem(conn, publicId);
                    File localFile = new File(localName);
                    FileInputStream result = new FileInputStream(localFile);
                    return new Resource(result, absuriString);
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            return new Resource(conn.getStream(), absuriString);
        }
        return null;
    }

    public Resource resolveURI(String href, String base) {
        logger.finer("resolveURI(" + href + "," + base + ")");
        String uri = href;
        CatalogResult resolved = this.catalog.lookupURI(uri);
        boolean skipCache = false;
        if (resolved == null && base != null) {
            try {
                URI auri = new URI(base);
                auri = auri.resolve(new URI(uri));
                uri = auri.toURL().toString();
                resolved = this.catalog.lookupURI(uri);
            }
            catch (URISyntaxException use) {
                resolved = null;
            }
            catch (MalformedURLException mue) {
                resolved = null;
            }
            catch (IllegalArgumentException iae) {
                resolved = null;
                skipCache = true;
            }
        }
        if (resolved == null) {
            if (skipCache) {
                return null;
            }
            return this.cacheStreamURI(uri);
        }
        if (resolved.expired()) {
            return this.cacheStreamURI(uri);
        }
        return this.streamResult(resolved);
    }

    public Resource resolvePublic(String systemId, String publicId) {
        logger.finer("resolvePublic(" + systemId + "," + publicId + ")");
        CatalogResult resolved = this.catalog.lookupPublic(systemId, publicId);
        if (resolved == null || resolved.expired()) {
            return this.cacheStreamSystem(systemId, publicId);
        }
        return this.streamResult(resolved);
    }

    public Resource resolveEntity(String name, String systemId, String publicId) {
        logger.finer("resolveEntity(" + name + "," + systemId + "," + publicId + ")");
        CatalogResult resolved = this.catalog.lookupEntity(name, systemId, publicId);
        if (resolved == null || resolved.expired()) {
            return this.cacheStreamSystem(systemId, publicId);
        }
        return this.streamResult(resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource resolveNamespaceURI(String uri, String nature, String purpose) {
        logger.finer("resolveNamespaceURI(" + uri + "," + nature + "," + purpose + ")");
        CatalogResult resolved = this.catalog.lookupNamespaceURI(uri, nature, purpose);
        if (resolved != null) {
            return this.streamResult(resolved);
        }
        if (builder == null) {
            return this.streamResult(new CatalogResult(uri, uri));
        }
        Resource nsResult = this.resolveURI(uri, null);
        String rddlURI = null;
        try {
            Document doc;
            DocumentBuilder documentBuilder = builder;
            synchronized (documentBuilder) {
                doc = builder.parse(nsResult.uri());
            }
            NodeList rsrcs = doc.getElementsByTagNameNS("http://www.rddl.org/", "resource");
            for (int pos = 0; rddlURI == null && pos < rsrcs.getLength(); ++pos) {
                Element rsrc = (Element)rsrcs.item(pos);
                String rnature = DOMUtils.attr(rsrc, "http://www.w3.org/1999/xlink", "role");
                String rpurpose = DOMUtils.attr(rsrc, "http://www.w3.org/1999/xlink", "arcrole");
                String rhref = DOMUtils.attr(rsrc, "http://www.w3.org/1999/xlink", "href");
                if (rnature == null || !rnature.equals(nature) || rpurpose == null || !rpurpose.equals(purpose) || rhref == null) continue;
                rddlURI = DOMUtils.makeAbsolute(rsrc, rhref, uri);
            }
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (rddlURI == null) {
            return this.streamResult(new CatalogResult(uri, uri));
        }
        return this.cacheStreamNamespaceURI(rddlURI, nature, purpose);
    }

    public Resource resolveDoctype(String name) {
        logger.finer("resolveDoctype(" + name + ")");
        CatalogResult resolved = this.catalog.lookupDoctype(name, null, null);
        if (resolved == null) {
            return null;
        }
        return this.streamResult(resolved);
    }

    private String getScheme(String uri) {
        int pos = uri.indexOf(":");
        if (pos >= 0) {
            return uri.substring(0, pos);
        }
        return null;
    }

    static {
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }
}

