/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.ReverseListIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceExtent
implements GroundedValue {
    private List<? extends Item> value;

    public SequenceExtent(Item[] items) {
        this.value = Arrays.asList(items);
    }

    public SequenceExtent(SequenceExtent ext, int start, int length) {
        this.value = ext.value.subList(start, start + length);
    }

    public SequenceExtent(List<? extends Item> list) {
        this.value = list;
    }

    public SequenceExtent(SequenceIterator iter) throws XPathException {
        Item it;
        int len = (iter.getProperties() & 2) == 0 ? 20 : ((LastPositionFinder)((Object)iter)).getLength();
        ArrayList<? extends Item> list = new ArrayList<Item>(len);
        while ((it = iter.next()) != null) {
            list.add(it);
        }
        this.value = list;
    }

    public static GroundedValue makeSequenceExtent(SequenceIterator iter) throws XPathException {
        if ((iter.getProperties() & 1) != 0) {
            return ((GroundedIterator)iter).materialize();
        }
        SequenceExtent extent = new SequenceExtent(iter);
        return extent.reduce();
    }

    public static GroundedValue makeResidue(SequenceIterator iter) throws XPathException {
        if ((iter.getProperties() & 1) != 0) {
            return ((GroundedIterator)iter).getResidue();
        }
        SequenceExtent extent = new SequenceExtent(iter);
        return extent.reduce();
    }

    public static <T extends Item> GroundedValue makeSequenceExtent(List<T> input) {
        int len = input.size();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            Item first = (Item)input.get(0);
            if (first instanceof AtomicValue) {
                return (GroundedValue)((Object)first);
            }
            return new One<Item>(first);
        }
        return new SequenceExtent(input);
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public Item head() {
        return this.itemAt(0);
    }

    @Override
    public int getLength() {
        return this.value.size();
    }

    public int getCardinality() {
        switch (this.value.size()) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    @Override
    public Item itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return this.value.get(n);
    }

    @Override
    public ListIterator iterate() {
        return new ListIterator(this.value);
    }

    public UnfailingIterator reverseIterate() {
        return new ReverseListIterator(this.value);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        int len = this.getLength();
        if (len == 0) {
            return false;
        }
        Item first = this.value.get(0);
        if (first instanceof NodeInfo) {
            return true;
        }
        if (len == 1 && first instanceof AtomicValue) {
            return ((AtomicValue)first).effectiveBooleanValue();
        }
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        int newEnd;
        int end = this.value.size();
        if (start < 0) {
            start = 0;
        } else if (start >= end) {
            return EmptySequence.getInstance();
        }
        int newStart = start;
        if (length > end) {
            newEnd = end;
        } else {
            if (length < 0) {
                return EmptySequence.getInstance();
            }
            newEnd = newStart + length;
            if (newEnd > end) {
                newEnd = end;
            }
        }
        return new SequenceExtent(this.value.subList(newStart, newEnd));
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        for (int i = 0; i < this.value.size(); ++i) {
            fsb.append(i == 0 ? "(" : ", ");
            fsb.append(this.value.get(i).toString());
        }
        fsb.append(')');
        return fsb.toString();
    }

    @Override
    public GroundedValue reduce() {
        int len = this.getLength();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            Item item = this.itemAt(0);
            if (item instanceof GroundedValue) {
                return (GroundedValue)((Object)item);
            }
            return new One<Item>(item);
        }
        return this;
    }
}

