/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SimpleType;

public class CharacterMapExpander
extends ProxyReceiver {
    private CharacterMap charMap;
    private boolean useNullMarkers = true;

    public CharacterMapExpander(Receiver next) {
        super(next);
    }

    public void setCharacterMap(CharacterMap map) {
        this.charMap = map;
    }

    public CharacterMap getCharacterMap() {
        return this.charMap;
    }

    public void setUseNullMarkers(boolean use) {
        this.useNullMarkers = use;
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if ((properties & 2) == 0) {
            CharSequence mapped = this.charMap.map(value, this.useNullMarkers);
            if (mapped == value) {
                this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
            } else {
                this.nextReceiver.attribute(nameCode, typeCode, mapped, locationId, (properties | 0x100) & 0xFFFFFFFB);
            }
        } else {
            this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if ((properties & 1) == 0) {
            CharSequence mapped = this.charMap.map(chars, this.useNullMarkers);
            if (mapped != chars) {
                properties = (properties | 0x100) & 0xFFFFFFFB;
            }
            this.nextReceiver.characters(mapped, locationId, properties);
        } else {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }
}

