<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:sch="http://purl.oclc.org/dsdl/schematron"
               xmlns:error="https://doi.org/10.5281/zenodo.1495494#error"
               xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
               xmlns:schxslt-api="https://doi.org/10.5281/zenodo.1495494#api"
               xmlns:schxslt="https://doi.org/10.5281/zenodo.1495494"
               xmlns:xs="http://www.w3.org/2001/XMLSchema"
               xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"
               xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
               version="2.0">
   <rdf:Description xmlns:dct="http://purl.org/dc/terms/"
                    xmlns:dc="http://purl.org/dc/elements/1.1/"
                    xmlns:skos="http://www.w3.org/2004/02/skos/core#">
      <dct:creator>
         <dct:Agent>
            <skos:prefLabel>SchXslt/1.9.4 SAXON/HE 9.8.0.15</skos:prefLabel>
            <schxslt.compile.typed-variables xmlns="https://doi.org/10.5281/zenodo.1495494#">true</schxslt.compile.typed-variables>
         </dct:Agent>
      </dct:creator>
      <dct:created>2025-08-13T23:06:25.645Z</dct:created>
   </rdf:Description>
   <xsl:output indent="yes"/>
   <xsl:template match="root()">
      <xsl:variable name="metadata" as="element()?">
         <svrl:metadata xmlns:dct="http://purl.org/dc/terms/"
                        xmlns:skos="http://www.w3.org/2004/02/skos/core#"
                        xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
            <dct:creator>
               <dct:Agent>
                  <skos:prefLabel>
                     <xsl:value-of separator="/"
                                   select="(system-property('xsl:product-name'), system-property('xsl:product-version'))"/>
                  </skos:prefLabel>
               </dct:Agent>
            </dct:creator>
            <dct:created>
               <xsl:value-of select="current-dateTime()"/>
            </dct:created>
            <dct:source>
               <rdf:Description xmlns:dc="http://purl.org/dc/elements/1.1/">
                  <dct:creator>
                     <dct:Agent>
                        <skos:prefLabel>SchXslt/1.9.4 SAXON/HE 9.8.0.15</skos:prefLabel>
                        <schxslt.compile.typed-variables xmlns="https://doi.org/10.5281/zenodo.1495494#">true</schxslt.compile.typed-variables>
                     </dct:Agent>
                  </dct:creator>
                  <dct:created>2025-08-13T23:06:25.645Z</dct:created>
               </rdf:Description>
            </dct:source>
         </svrl:metadata>
      </xsl:variable>
      <xsl:variable name="report" as="element(schxslt:report)">
         <schxslt:report>
            <xsl:call-template name="d14e64"/>
         </schxslt:report>
      </xsl:variable>
      <xsl:variable name="schxslt:report" as="node()*">
         <xsl:sequence select="$metadata"/>
         <xsl:for-each select="$report/schxslt:document">
            <xsl:for-each select="schxslt:pattern">
               <xsl:sequence select="node()"/>
               <xsl:sequence select="../schxslt:rule[@pattern = current()/@id]/node()"/>
            </xsl:for-each>
         </xsl:for-each>
      </xsl:variable>
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                              title="UBL 2.5 Default Data Type Qualifications">
         <svrl:ns-prefix-in-attribute-values prefix="ext"
                                             uri="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"/>
         <svrl:ns-prefix-in-attribute-values prefix="cbc"
                                             uri="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"/>
         <xsl:sequence select="$schxslt:report"/>
      </svrl:schematron-output>
   </xsl:template>
   <xsl:template match="text() | @*" mode="#all" priority="-10"/>
   <xsl:template match="/" mode="#all" priority="-10">
      <xsl:apply-templates mode="#current" select="node()"/>
   </xsl:template>
   <xsl:template match="*" mode="#all" priority="-10">
      <xsl:apply-templates mode="#current" select="@*"/>
      <xsl:apply-templates mode="#current" select="node()"/>
   </xsl:template>
   <xsl:template name="d14e64">
      <schxslt:document>
         <schxslt:pattern id="d14e64">
            <xsl:if test="exists(base-uri(root()))">
               <xsl:attribute name="documents" select="base-uri(root())"/>
            </xsl:if>
            <xsl:for-each select="root()">
               <svrl:active-pattern xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                    name="UBL-DataTypeQualifications-2.5"
                                    id="UBL-DataTypeQualifications-2.5">
                  <xsl:attribute name="documents" select="base-uri(.)"/>
               </svrl:active-pattern>
            </xsl:for-each>
         </schxslt:pattern>
         <xsl:apply-templates mode="d14e64" select="root()"/>
      </schxslt:document>
   </xsl:template>
   <xsl:template match="@currencyID" priority="23" mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "@currencyID" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">@currencyID</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">@currencyID</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(../@currencyCodeListVersionID!='2001') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AWG&#x7f;AZM&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYR&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;CRC&#x7f;CUP&#x7f;CVE&#x7f;CYP&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EEK&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GEL&#x7f;GHC&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LTL&#x7f;LVL&#x7f;LYD&#x7f;MAD&#x7f;MDL&#x7f;MGF&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRO&#x7f;MTL&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MYR&#x7f;MZM&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;ROL&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDD&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SIT&#x7f;SKK&#x7f;SLL&#x7f;SOS&#x7f;SRG&#x7f;STD&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMM&#x7f;TND&#x7f;TOP&#x7f;TRL&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;UYU&#x7f;UZS&#x7f;VEB&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPT&#x7f;YER&#x7f;YUM&#x7f;ZAR&#x7f;ZMK&#x7f;ZWD&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@currencyCodeListVersionID!='2012-01-12') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYR&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LTL&#x7f;LVL&#x7f;LYD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRO&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STD&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USN&#x7f;USS&#x7f;UYI&#x7f;UYU&#x7f;UZS&#x7f;VEF&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XDR&#x7f;XFU&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZMK&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@currencyCodeListVersionID!='2018-01-01') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UZS&#x7f;VEF&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@currencyCodeListVersionID!='2018-08-29') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UYW&#x7f;UZS&#x7f;VES&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@currencyCodeListVersionID!='2018-08-29') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UYW&#x7f;UZS&#x7f;VES&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(../@currencyCodeListVersionID!='2001') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AWG&#x7f;AZM&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYR&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;CRC&#x7f;CUP&#x7f;CVE&#x7f;CYP&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EEK&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GEL&#x7f;GHC&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LTL&#x7f;LVL&#x7f;LYD&#x7f;MAD&#x7f;MDL&#x7f;MGF&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRO&#x7f;MTL&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MYR&#x7f;MZM&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;ROL&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDD&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SIT&#x7f;SKK&#x7f;SLL&#x7f;SOS&#x7f;SRG&#x7f;STD&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMM&#x7f;TND&#x7f;TOP&#x7f;TRL&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;UYU&#x7f;UZS&#x7f;VEB&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPT&#x7f;YER&#x7f;YUM&#x7f;ZAR&#x7f;ZMK&#x7f;ZWD&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@currencyCodeListVersionID!='2012-01-12') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYR&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LTL&#x7f;LVL&#x7f;LYD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRO&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STD&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USN&#x7f;USS&#x7f;UYI&#x7f;UYU&#x7f;UZS&#x7f;VEF&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XDR&#x7f;XFU&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZMK&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@currencyCodeListVersionID!='2018-01-01') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UZS&#x7f;VEF&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@currencyCodeListVersionID!='2018-08-29') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UYW&#x7f;UZS&#x7f;VES&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@currencyCodeListVersionID!='2018-08-29') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UYW&#x7f;UZS&#x7f;VES&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'Currency-2.0 Currency-2.1 Currency-2.2 Currency-2.3 Currency-2.4' in the context '@currencyID'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="@mimeCode" priority="22" mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "@mimeCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">@mimeCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">@mimeCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( contains('&#x7f;application/CSTAdata+xml&#x7f;application/EDI-Consent&#x7f;application/EDI-X12&#x7f;application/EDIFACT&#x7f;application/activemessage&#x7f;application/andrew-inset&#x7f;application/applefile&#x7f;application/atomicmail&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;application/cals-1840&#x7f;application/cnrp+xml&#x7f;application/commonground&#x7f;application/cpl+xml&#x7f;application/csta+xml&#x7f;application/cybercash&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dns&#x7f;application/dvcs&#x7f;application/epp+xml&#x7f;application/eshop&#x7f;application/fits&#x7f;application/font-tdpfr&#x7f;application/http&#x7f;application/hyperstudio&#x7f;application/iges&#x7f;application/im-iscomposing+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/iotp&#x7f;application/ipp&#x7f;application/isup&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/marc&#x7f;application/mathematica&#x7f;application/mbox&#x7f;application/mikey&#x7f;application/mpeg4-generic&#x7f;application/msword&#x7f;application/news-message-id&#x7f;application/news-transmission&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/oda&#x7f;application/ogg&#x7f;application/parityfec&#x7f;application/pdf&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pkcs10&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkix-cert&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pkixcmp&#x7f;application/postscript&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;application/prs.cww&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;application/qsig&#x7f;application/rdf+xml&#x7f;application/reginfo+xml&#x7f;application/remote-printing&#x7f;application/resource-lists+xml&#x7f;application/riscos&#x7f;application/rls-services+xml&#x7f;application/rtf&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbml+xml&#x7f;application/sdp&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;application/sgml&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/slate&#x7f;application/soap+xml&#x7f;application/spirits-event+xml&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/tve-trigger&#x7f;application/vemmi&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.Kinar&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.anser-web-funds-transfer-initiation&#x7f;application/vnd.audiograph&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bmi&#x7f;application/vnd.businessobjects&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.cinderella&#x7f;application/vnd.claymore&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;application/vnd.cybank&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.dna&#x7f;application/vnd.dpgraph&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.dxr&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.enliven&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;application/vnd.eudora.data&#x7f;application/vnd.fdf&#x7f;application/vnd.ffsns&#x7f;application/vnd.fints&#x7f;application/vnd.framemaker&#x7f;application/vnd.fsc.weblaunch&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.grafeq&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;application/vnd.hbci&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hhe.lesson-player&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.httphone&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.afplinedata&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.modcap&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.informix-visionary&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jisp&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.koan&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;application/vnd.mcd&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.mfmp&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.mozilla.xul+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-lrm&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.mseq&#x7f;application/vnd.msign&#x7f;application/vnd.music-niff&#x7f;application/vnd.musician&#x7f;application/vnd.nervana&#x7f;application/vnd.netfpx&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.obn&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.palm&#x7f;application/vnd.paos.xml&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.picsel&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.rapid&#x7f;application/vnd.s3sms&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;application/vnd.sealed.net&#x7f;application/vnd.sealed.ppt&#x7f;application/vnd.sealed.xls&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.smaf&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.street-stream&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml.+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.triscape.mxs&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.vcx&#x7f;application/vnd.vectorworks&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;application/vnd.vsf&#x7f;application/vnd.wap.sic&#x7f;application/vnd.wap.slc&#x7f;application/vnd.wap.wbxml&#x7f;application/vnd.wap.wmlc&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yellowriver-custom-menu&#x7f;application/watcherinfo+xml&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/wita&#x7f;application/wordperfect5.1&#x7f;application/x400-bp&#x7f;application/xhtml+xml&#x7f;application/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/zip&#x7f;audio/32kadpcm&#x7f;audio/3gpp&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;audio/CN&#x7f;audio/DAT12&#x7f;audio/DVI4&#x7f;audio/EVRC&#x7f;audio/EVRC-QCP&#x7f;audio/EVRC0&#x7f;audio/G.722.1&#x7f;audio/G722&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/L8&#x7f;audio/LPC&#x7f;audio/MP4A-LATM&#x7f;audio/MPA&#x7f;audio/PCMA&#x7f;audio/PCMU&#x7f;audio/QCELP&#x7f;audio/RED&#x7f;audio/SMV&#x7f;audio/SMV-QCP&#x7f;audio/SMV0&#x7f;audio/VDVI&#x7f;audio/basic&#x7f;audio/clearmode&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;audio/iLBC&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;audio/mpeg4-generic&#x7f;audio/parityfec&#x7f;audio/prs.sid&#x7f;audio/telephone-event&#x7f;audio/tone&#x7f;audio/vnd.3gpp.iufp&#x7f;audio/vnd.audiokoz&#x7f;audio/vnd.cisco.nse&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;audio/vnd.digital-winds&#x7f;audio/vnd.everad.plj&#x7f;audio/vnd.lucent.voice&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;audio/vnd.nortel.vbk&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;audio/vnd.octel.sbc&#x7f;audio/vnd.qcelp&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;audio/vnd.vmx.cvsd&#x7f;image/cgm&#x7f;image/fits&#x7f;image/g3fax&#x7f;image/gif&#x7f;image/ief&#x7f;image/jp2&#x7f;image/jpeg&#x7f;image/jpm&#x7f;image/jpx&#x7f;image/naplps&#x7f;image/png&#x7f;image/prs.btif&#x7f;image/prs.pti&#x7f;image/t38&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;image/vnd.cns.inf2&#x7f;image/vnd.djvu&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;image/vnd.fastbidsheet&#x7f;image/vnd.fpx&#x7f;image/vnd.fst&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;image/vnd.globalgraphics.pgb&#x7f;image/vnd.microsoft.icon&#x7f;image/vnd.mix&#x7f;image/vnd.ms-modi&#x7f;image/vnd.net-fpx&#x7f;image/vnd.sealed.png&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;image/vnd.svf&#x7f;image/vnd.wap.wbmp&#x7f;image/vnd.xiff&#x7f;message/CPIM&#x7f;message/delivery-status&#x7f;message/disposition-notification&#x7f;message/external-body&#x7f;message/http&#x7f;message/news&#x7f;message/partial&#x7f;message/rfc822&#x7f;message/s-http&#x7f;message/sip&#x7f;message/sipfrag&#x7f;message/tracking-status&#x7f;model/iges&#x7f;model/mesh&#x7f;model/vnd.dwf&#x7f;model/vnd.flatland.3dml&#x7f;model/vnd.gdl&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;model/vnd.mts&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;model/vnd.vtu&#x7f;model/vrml&#x7f;multipart/alternative&#x7f;multipart/appledouble&#x7f;multipart/byteranges&#x7f;multipart/digest&#x7f;multipart/encrypted&#x7f;multipart/form-data&#x7f;multipart/header-set&#x7f;multipart/mixed&#x7f;multipart/parallel&#x7f;multipart/related&#x7f;multipart/report&#x7f;multipart/signed&#x7f;multipart/voice-message&#x7f;text/RED&#x7f;text/calendar&#x7f;text/css&#x7f;text/csv&#x7f;text/directory&#x7f;text/dns&#x7f;text/enriched&#x7f;text/html&#x7f;text/parityfec&#x7f;text/plain&#x7f;text/prs.fallenstein.rst&#x7f;text/prs.lines.tag&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;text/rtf&#x7f;text/sgml&#x7f;text/t140&#x7f;text/tab-separated-values&#x7f;text/troff&#x7f;text/uri-list&#x7f;text/vnd.DMClientScript&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.IPTC.NewsML&#x7f;text/vnd.abc&#x7f;text/vnd.curl&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;text/vnd.latex-z&#x7f;text/vnd.motorola.reflex&#x7f;text/vnd.ms-mediapackage&#x7f;text/vnd.net2phone.commcenter.command&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;text/vnd.wap.si&#x7f;text/vnd.wap.sl&#x7f;text/vnd.wap.wml&#x7f;text/vnd.wap.wmlscript&#x7f;text/xml&#x7f;text/xml-external-parsed-entity&#x7f;video/3gpp&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;video/CelB&#x7f;video/DV&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/JPEG&#x7f;video/MJ2&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;video/MP4V-ES&#x7f;video/MPV&#x7f;video/SMPTE292M&#x7f;video/mpeg&#x7f;video/mpeg4-generic&#x7f;video/nv&#x7f;video/parityfec&#x7f;video/pointer&#x7f;video/quicktime&#x7f;video/raw&#x7f;video/vnd.fvt&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;video/vnd.mpegurl&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;video/vnd.objectvideo&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;video/vnd.sealed.swf&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;video/vnd.vivo&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( contains('&#x7f;application/1d-interleaved-parityfec&#x7f;application/3gpp-ims+xml&#x7f;application/activemessage&#x7f;application/andrew-inset&#x7f;application/applefile&#x7f;application/atom+xml&#x7f;application/atomicmail&#x7f;application/atomcat+xml&#x7f;application/atomsvc+xml&#x7f;application/auth-policy+xml&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;application/calendar+xml&#x7f;application/cals-1840&#x7f;application/ccmp+xml&#x7f;application/ccxml+xml&#x7f;application/cdmi-capability&#x7f;application/cdmi-container&#x7f;application/cdmi-domain&#x7f;application/cdmi-object&#x7f;application/cdmi-queue&#x7f;application/cea-2018+xml&#x7f;application/cellml+xml&#x7f;application/cfw&#x7f;application/cnrp+xml&#x7f;application/commonground&#x7f;application/conference-info+xml&#x7f;application/cpl+xml&#x7f;application/csta+xml&#x7f;application/CSTAdata+xml&#x7f;application/cybercash&#x7f;application/davmount+xml&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dns&#x7f;application/dskpp+xml&#x7f;application/dssc+der&#x7f;application/dssc+xml&#x7f;application/dvcs&#x7f;application/ecmascript&#x7f;application/EDI-Consent&#x7f;application/EDIFACT&#x7f;application/EDI-X12&#x7f;application/emma+xml&#x7f;application/epp+xml&#x7f;application/eshop&#x7f;application/example&#x7f;application/exi&#x7f;application/fastinfoset&#x7f;application/fastsoap&#x7f;application/fits&#x7f;application/font-tdpfr&#x7f;application/framework-attributes+xml&#x7f;application/H224&#x7f;application/held+xml&#x7f;application/http&#x7f;application/hyperstudio&#x7f;application/ibe-key-request+xml&#x7f;application/ibe-pkg-reply+xml&#x7f;application/ibe-pp-data&#x7f;application/iges&#x7f;application/im-iscomposing+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/inkml+xml&#x7f;application/iotp&#x7f;application/ipfix&#x7f;application/ipp&#x7f;application/isup&#x7f;application/javascript&#x7f;application/json&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;application/lost+xml&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/mads+xml&#x7f;application/marc&#x7f;application/marcxml+xml&#x7f;application/mathematica&#x7f;application/mathml-content+xml&#x7f;application/mathml-presentation+xml&#x7f;application/mathml+xml&#x7f;application/mbms-associated-procedure-description+xml&#x7f;application/mbms-deregister+xml&#x7f;application/mbms-envelope+xml&#x7f;application/mbms-msk-response+xml&#x7f;application/mbms-msk+xml&#x7f;application/mbms-protection-description+xml&#x7f;application/mbms-reception-report+xml&#x7f;application/mbms-register-response+xml&#x7f;application/mbms-register+xml&#x7f;application/mbms-user-service-description+xml&#x7f;application/mbox&#x7f;application/media_control+xml&#x7f;application/mediaservercontrol+xml&#x7f;application/metalink4+xml&#x7f;application/mets+xml&#x7f;application/mikey&#x7f;application/mods+xml&#x7f;application/moss-keys&#x7f;application/moss-signature&#x7f;application/mosskey-data&#x7f;application/mosskey-request&#x7f;application/mp21&#x7f;application/mp4&#x7f;application/mpeg4-generic&#x7f;application/mpeg4-iod&#x7f;application/mpeg4-iod-xmt&#x7f;application/msc-ivr+xml&#x7f;application/msc-mixer+xml&#x7f;application/msword&#x7f;application/mxf&#x7f;application/nasdata&#x7f;application/news-checkgroups&#x7f;application/news-groupinfo&#x7f;application/news-transmission&#x7f;application/nss&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/oda&#x7f;application/oebps-package+xml&#x7f;application/ogg&#x7f;application/oxps&#x7f;application/parityfec&#x7f;application/patch-ops-error+xml&#x7f;application/pdf&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pidf-diff+xml&#x7f;application/pkcs10&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkcs8&#x7f;application/pkix-attr-cert&#x7f;application/pkix-cert&#x7f;application/pkixcmp&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pls+xml&#x7f;application/poc-settings+xml&#x7f;application/postscript&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;application/prs.cww&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;application/prs.rdf-xml-crypt&#x7f;application/prs.xsf+xml&#x7f;application/pskc+xml&#x7f;application/rdf+xml&#x7f;application/qsig&#x7f;application/raptorfec&#x7f;application/reginfo+xml&#x7f;application/relax-ng-compact-syntax&#x7f;application/remote-printing&#x7f;application/resource-lists-diff+xml&#x7f;application/resource-lists+xml&#x7f;application/riscos&#x7f;application/rlmi+xml&#x7f;application/rls-services+xml&#x7f;application/rpki-ghostbusters&#x7f;application/rpki-manifest&#x7f;application/rpki-roa&#x7f;application&#x7f;application/rpki-updown&#x7f;application/rtf&#x7f;application/rtx&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbml+xml&#x7f;application/scvp-cv-request&#x7f;application/scvp-cv-response&#x7f;application/scvp-vp-request&#x7f;application/scvp-vp-response&#x7f;application/sdp&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;application/sgml&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/simpleSymbolContainer&#x7f;application/slate&#x7f;application/smil (OBSOLETE)&#x7f;application/smil+xml&#x7f;application/smpte336m&#x7f;application/soap+fastinfoset&#x7f;application/soap+xml&#x7f;application/sparql-query&#x7f;application/sparql-results+xml&#x7f;application/spirits-event+xml&#x7f;application/srgs&#x7f;application/srgs+xml&#x7f;application/sru+xml&#x7f;application/ssml+xml&#x7f;application/tamp-apex-update&#x7f;application/tamp-apex-update-confirm&#x7f;application/tamp-community-update&#x7f;application/tamp-community-update-confirm&#x7f;application/tamp-error&#x7f;application/tamp-sequence-adjust&#x7f;application/tamp-sequence-adjust-confirm&#x7f;application/tamp-status-query&#x7f;application/tamp-status-response&#x7f;application/tamp-update&#x7f;application/tamp-update-confirm&#x7f;application/tei+xml&#x7f;application/thraud+xml&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/timestamped-data&#x7f;application/tve-trigger&#x7f;application/ulpfec&#x7f;application/vcard+xml&#x7f;application/vemmi&#x7f;application/vnd.3gpp.bsf+xml&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.3gpp2.bcmcsinfo+xml&#x7f;application/vnd.3gpp2.sms&#x7f;application/vnd.3gpp2.tcap&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.formscentral.fcdt&#x7f;application/vnd.adobe.fxp&#x7f;application/vnd.adobe.partial-upload&#x7f;application/vnd.adobe.xdp+xml&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.ah-barcode&#x7f;application/vnd.ahead.space&#x7f;application/vnd.airzip.filesecure.azf&#x7f;application/vnd.airzip.filesecure.azs&#x7f;application/vnd.americandynamics.acc&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.amundsen.maze+xml&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.antix.game-component&#x7f;application/vnd.apple.mpegurl&#x7f;application/vnd.apple.installer+xml&#x7f;application/vnd.arastra.swi (OBSOLETE)&#x7f;application/vnd.aristanetworks.swi&#x7f;application/vnd.astraea-software.iota&#x7f;application/vnd.audiograph&#x7f;application/vnd.autopackage&#x7f;application/vnd.avistar+xml&#x7f;application/vnd.balsamiq.bmml+xml&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bluetooth.ep.oob&#x7f;application/vnd.bmi&#x7f;application/vnd.businessobjects&#x7f;application/vnd.cab-jscript&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.cendio.thinlinc.clientconf&#x7f;application/vnd.chemdraw+xml&#x7f;application/vnd.chipnuts.karaoke-mmd&#x7f;application/vnd.cinderella&#x7f;application/vnd.cirpack.isdn-ext&#x7f;application/vnd.claymore&#x7f;application/vnd.cloanto.rp9&#x7f;application/vnd.clonk.c4group&#x7f;application/vnd.cluetrust.cartomobile-config&#x7f;application/vnd.cluetrust.cartomobile-config-pkg&#x7f;application/vnd.collection+json&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.crick.clicker&#x7f;application/vnd.crick.clicker.keyboard&#x7f;application/vnd.crick.clicker.palette&#x7f;application/vnd.crick.clicker.template&#x7f;application/vnd.crick.clicker.wordbank&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.ctct.ws+xml&#x7f;application/vnd.cups-pdf&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-ppd&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;application/vnd.cybank&#x7f;application/vnd.dart&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.dece.data&#x7f;application/vnd.dece.ttml+xml&#x7f;application/vnd.dece.unspecified&#x7f;application/vnd.dece.zip&#x7f;application/vnd.denovo.fcselayout-link&#x7f;application/vnd.dir-bi.plate-dl-nosuffix&#x7f;application/vnd.dm.delegation+xml&#x7f;application/vnd.dna&#x7f;application/vnd.dolby.mobile.1&#x7f;application/vnd.dolby.mobile.2&#x7f;application/vnd.dpgraph&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.dvb.ait&#x7f;application/vnd.dvb.dvbj&#x7f;application/vnd.dvb.esgcontainer&#x7f;application/vnd.dvb.ipdcdftnotifaccess&#x7f;application/vnd.dvb.ipdcesgaccess&#x7f;application/vnd.dvb.ipdcesgaccess2&#x7f;application/vnd.dvb.ipdcesgpdd&#x7f;application/vnd.dvb.ipdcroaming&#x7f;application/vnd.dvb.iptv.alfec-base&#x7f;application/vnd.dvb.iptv.alfec-enhancement&#x7f;application/vnd.dvb.notif-aggregate-root+xml&#x7f;application/vnd.dvb.notif-container+xml&#x7f;application/vnd.dvb.notif-generic+xml&#x7f;application/vnd.dvb.notif-ia-msglist+xml&#x7f;application/vnd.dvb.notif-ia-registration-request+xml&#x7f;application/vnd.dvb.notif-ia-registration-response+xml&#x7f;application/vnd.dvb.notif-init+xml&#x7f;application/vnd.dvb.pfr&#x7f;application/vnd.dvb.service&#x7f;application/vnd.dxr&#x7f;application/vnd.dynageo&#x7f;application/vnd.easykaraoke.cdgdownload&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.emclient.accessrequest+xml&#x7f;application/vnd.enliven&#x7f;application/vnd.eprints.data+xml&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;application/vnd.eszigno3+xml&#x7f;application/vnd.etsi.aoc+xml&#x7f;application/vnd.etsi.cug+xml&#x7f;application/vnd.etsi.iptvcommand+xml&#x7f;application/vnd.etsi.iptvdiscovery+xml&#x7f;application/vnd.etsi.iptvprofile+xml&#x7f;application/vnd.etsi.iptvsad-bc+xml&#x7f;application/vnd.etsi.iptvsad-cod+xml&#x7f;application/vnd.etsi.iptvsad-npvr+xml&#x7f;application/vnd.etsi.iptvservice+xml&#x7f;application/vnd.etsi.iptvsync+xml&#x7f;application/vnd.etsi.iptvueprofile+xml&#x7f;application/vnd.etsi.mcid+xml&#x7f;application/vnd.etsi.overload-control-policy-dataset+xml&#x7f;application/vnd.etsi.sci+xml&#x7f;application/vnd.etsi.simservs+xml&#x7f;application/vnd.etsi.tsl+xml&#x7f;application/vnd.etsi.tsl.der&#x7f;application/vnd.eudora.data&#x7f;application/vnd.ezpix-album&#x7f;application/vnd.ezpix-package&#x7f;application/vnd.f-secure.mobile&#x7f;application/vnd.fdf&#x7f;application/vnd.fdsn.mseed&#x7f;application/vnd.fdsn.seed&#x7f;application/vnd.ffsns&#x7f;application/vnd.fints&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.fluxtime.clip&#x7f;application/vnd.font-fontforge-sfd&#x7f;application/vnd.framemaker&#x7f;application/vnd.frogans.fnc&#x7f;application/vnd.frogans.ltf&#x7f;application/vnd.fsc.weblaunch&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ART4&#x7f;application/vnd.fujixerox.ART-EX&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fujixerox.HBPL&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.fuzzysheet&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.geocube+xml&#x7f;application/vnd.geogebra.file&#x7f;application/vnd.geogebra.tool&#x7f;application/vnd.geometry-explorer&#x7f;application/vnd.geonext&#x7f;application/vnd.geoplan&#x7f;application/vnd.geospace&#x7f;application/vnd.globalplatform.card-content-mgt&#x7f;application/vnd.globalplatform.card-content-mgt-response&#x7f;application/vnd.gmx (OBSOLETE)&#x7f;application/vnd.google-earth.kml+xml&#x7f;application/vnd.google-earth.kmz&#x7f;application/vnd.grafeq&#x7f;application/vnd.gridmp&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;application/vnd.hal+json&#x7f;application/vnd.hal+xml&#x7f;application/vnd.HandHeld-Entertainment+xml&#x7f;application/vnd.hbci&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hhe.lesson-player&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.hp-jlyt&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.httphone&#x7f;application/vnd.hydrostatix.sof-data&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.afplinedata&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.modcap&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.iccprofile&#x7f;application/vnd.igloader&#x7f;application/vnd.immervision-ivp&#x7f;application/vnd.immervision-ivu&#x7f;application/vnd.informedcontrol.rms+xml&#x7f;application/vnd.infotech.project&#x7f;application/vnd.infotech.project+xml&#x7f;application/vnd.informix-visionary&#x7f;application/vnd.innopath.wamp.notification&#x7f;application/vnd.insors.igm&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intergeo&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.iptc.g2.conceptitem+xml&#x7f;application/vnd.iptc.g2.knowledgeitem+xml&#x7f;application/vnd.iptc.g2.newsitem+xml&#x7f;application/vnd.iptc.g2.newsmessage+xml&#x7f;application/vnd.iptc.g2.packageitem+xml&#x7f;application/vnd.iptc.g2.planningitem+xml&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.isac.fcs&#x7f;application/vnd.jam&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jcp.javame.midlet-rms&#x7f;application/vnd.jisp&#x7f;application/vnd.joost.joda-archive&#x7f;application/vnd.jsk.isdn-ngn&#x7f;application/vnd.kahootz&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.Kinar&#x7f;application/vnd.koan&#x7f;application/vnd.kodak-descriptor&#x7f;application/vnd.las.las+xml&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.marlin.drm.actiontoken+xml&#x7f;application/vnd.marlin.drm.conftoken+xml&#x7f;application/vnd.marlin.drm.license+xml&#x7f;application/vnd.marlin.drm.mdcf&#x7f;application/vnd.mcd&#x7f;application/vnd.medcalcdata&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.MFER&#x7f;application/vnd.mfmp&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.motorola.iprm&#x7f;application/vnd.mozilla.xul+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-cab-compressed&#x7f;application/vnd.mseq&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-excel.addin.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.binary.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.macroEnabled.12&#x7f;application/vnd.ms-excel.template.macroEnabled.12&#x7f;application/vnd.ms-fontobject&#x7f;application/vnd.ms-htmlhelp&#x7f;application/vnd.ms-ims&#x7f;application/vnd.ms-lrm&#x7f;application/vnd.ms-office.activeX+xml&#x7f;application/vnd.ms-officetheme&#x7f;application/vnd.ms-playready.initiator+xml&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-powerpoint.addin.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.presentation.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slide.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slideshow.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.template.macroEnabled.12&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-wmdrm.lic-chlg-req&#x7f;application/vnd.ms-wmdrm.lic-resp&#x7f;application/vnd.ms-wmdrm.meter-chlg-req&#x7f;application/vnd.ms-wmdrm.meter-resp&#x7f;application/vnd.ms-word.document.macroEnabled.12&#x7f;application/vnd.ms-word.template.macroEnabled.12&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.ms-xpsdocument&#x7f;application/vnd.msign&#x7f;application/vnd.multiad.creator&#x7f;application/vnd.multiad.creator.cif&#x7f;application/vnd.musician&#x7f;application/vnd.music-niff&#x7f;application/vnd.muvee.style&#x7f;application/vnd.mynfc&#x7f;application/vnd.ncd.control&#x7f;application/vnd.ncd.reference&#x7f;application/vnd.nervana&#x7f;application/vnd.netfpx&#x7f;application/vnd.neurolanguage.nlu&#x7f;application/vnd.nitf&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.catalogs&#x7f;application/vnd.nokia.conml+wbxml&#x7f;application/vnd.nokia.conml+xml&#x7f;application/vnd.nokia.iptv.config+xml&#x7f;application/vnd.nokia.iSDS-radio-presets&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;application/vnd.nokia.ncd&#x7f;application/vnd.nokia.n-gage.ac+xml&#x7f;application/vnd.nokia.n-gage.data&#x7f;application/vnd.nokia.n-gage.symbian.install&#x7f;application/vnd.nokia.pcd+wbxml&#x7f;application/vnd.nokia.pcd+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.ntt-local.file-transfer&#x7f;application/vnd.ntt-local.sip-ta_remote&#x7f;application/vnd.ntt-local.sip-ta_tcp_stream&#x7f;application/vnd.oasis.opendocument.chart&#x7f;application/vnd.oasis.opendocument.chart-template&#x7f;application/vnd.oasis.opendocument.database&#x7f;application/vnd.oasis.opendocument.formula&#x7f;application/vnd.oasis.opendocument.formula-template&#x7f;application/vnd.oasis.opendocument.graphics&#x7f;application/vnd.oasis.opendocument.graphics-template&#x7f;application/vnd.oasis.opendocument.image&#x7f;application/vnd.oasis.opendocument.image-template&#x7f;application/vnd.oasis.opendocument.presentation&#x7f;application/vnd.oasis.opendocument.presentation-template&#x7f;application/vnd.oasis.opendocument.spreadsheet&#x7f;application/vnd.oasis.opendocument.spreadsheet-template&#x7f;application/vnd.oasis.opendocument.text&#x7f;application/vnd.oasis.opendocument.text-master&#x7f;application/vnd.oasis.opendocument.text-template&#x7f;application/vnd.oasis.opendocument.text-web&#x7f;application/vnd.obn&#x7f;application/vnd.oftn.l10n+json&#x7f;application/vnd.oipf.contentaccessdownload+xml&#x7f;application/vnd.oipf.contentaccessstreaming+xml&#x7f;application/vnd.oipf.cspg-hexbinary&#x7f;application/vnd.oipf.dae.svg+xml&#x7f;application/vnd.oipf.dae.xhtml+xml&#x7f;application/vnd.oipf.mippvcontrolmessage+xml&#x7f;application/vnd.oipf.pae.gem&#x7f;application/vnd.oipf.spdiscovery+xml&#x7f;application/vnd.oipf.spdlist+xml&#x7f;application/vnd.oipf.ueprofile+xml&#x7f;application/vnd.oipf.userprofile+xml&#x7f;application/vnd.olpc-sugar&#x7f;application/vnd.oma.bcast.associated-procedure-parameter+xml&#x7f;application/vnd.oma.bcast.drm-trigger+xml&#x7f;application/vnd.oma.bcast.imd+xml&#x7f;application/vnd.oma.bcast.ltkm&#x7f;application/vnd.oma.bcast.notification+xml&#x7f;application/vnd.oma.bcast.provisioningtrigger&#x7f;application/vnd.oma.bcast.sgboot&#x7f;application/vnd.oma.bcast.sgdd+xml&#x7f;application/vnd.oma.bcast.sgdu&#x7f;application/vnd.oma.bcast.simple-symbol-container&#x7f;application/vnd.oma.bcast.smartcard-trigger+xml&#x7f;application/vnd.oma.bcast.sprov+xml&#x7f;application/vnd.oma.bcast.stkm&#x7f;application/vnd.oma.cab-address-book+xml&#x7f;application/vnd.oma.cab-feature-handler+xml&#x7f;application/vnd.oma.cab-pcc+xml&#x7f;application/vnd.oma.cab-user-prefs+xml&#x7f;application/vnd.oma.dcd&#x7f;application/vnd.oma.dcdc&#x7f;application/vnd.oma.dd2+xml&#x7f;application/vnd.oma.drm.risd+xml&#x7f;application/vnd.oma.group-usage-list+xml&#x7f;application/vnd.oma.pal+xml&#x7f;application/vnd.oma.poc.detailed-progress-report+xml&#x7f;application/vnd.oma.poc.final-report+xml&#x7f;application/vnd.oma.poc.groups+xml&#x7f;application/vnd.oma.poc.invocation-descriptor+xml&#x7f;application/vnd.oma.poc.optimized-progress-report+xml&#x7f;application/vnd.oma.push&#x7f;application/vnd.oma.scidm.messages+xml&#x7f;application/vnd.oma.xcap-directory+xml&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.omaloc-supl-init&#x7f;application/vnd.oma-scws-config&#x7f;application/vnd.oma-scws-http-request&#x7f;application/vnd.oma-scws-http-response&#x7f;application/vnd.openofficeorg.extension&#x7f;application/vnd.openxmlformats-officedocument.custom-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.customXmlProperties+xml&#x7f;application/vnd.openxmlformats-officedocument.drawing+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chart+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml&#x7f;application/vnd.openxmlformats-officedocument.extended-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presProps+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tags+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml&#x7f;application/vnd.openxmlformats-officedocument.theme+xml&#x7f;application/vnd.openxmlformats-officedocument.themeOverride+xml&#x7f;application/vnd.openxmlformats-officedocument.vmlDrawing&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml&#x7f;application/vnd.openxmlformats-package.core-properties+xml&#x7f;application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml&#x7f;application/vnd.openxmlformats-package.relationships+xml&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.osgeo.mapguide.package&#x7f;application/vnd.osgi.bundle&#x7f;application/vnd.osgi.dp&#x7f;application/vnd.osgi.subsystem&#x7f;application/vnd.otps.ct-kip+xml&#x7f;application/vnd.palm&#x7f;application/vnd.paos.xml&#x7f;application/vnd.pawaafile&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.piaccess.application-licence&#x7f;application/vnd.picsel&#x7f;application/vnd.pmi.widget&#x7f;application/vnd.poc.group-advertisement+xml&#x7f;application/vnd.pocketlearn&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.preminet&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.proteus.magazine&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.qualcomm.brew-app-res&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.quobject-quoxdocument&#x7f;application/vnd.radisys.moml+xml&#x7f;application/vnd.radisys.msml-audit-conf+xml&#x7f;application/vnd.radisys.msml-audit-conn+xml&#x7f;application/vnd.radisys.msml-audit-dialog+xml&#x7f;application/vnd.radisys.msml-audit-stream+xml&#x7f;application/vnd.radisys.msml-audit+xml&#x7f;application/vnd.radisys.msml-conf+xml&#x7f;application/vnd.radisys.msml-dialog-base+xml&#x7f;application/vnd.radisys.msml-dialog-fax-detect+xml&#x7f;application/vnd.radisys.msml-dialog-fax-sendrecv+xml&#x7f;application/vnd.radisys.msml-dialog-group+xml&#x7f;application/vnd.radisys.msml-dialog-speech+xml&#x7f;application/vnd.radisys.msml-dialog-transform+xml&#x7f;application/vnd.radisys.msml-dialog+xml&#x7f;application/vnd.radisys.msml+xml&#x7f;application/vnd.rainstor.data&#x7f;application/vnd.rapid&#x7f;application/vnd.realvnc.bed&#x7f;application/vnd.recordare.musicxml&#x7f;application/vnd.recordare.musicxml+xml&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.rig.cryptonote&#x7f;application/vnd.route66.link66+xml&#x7f;application/vnd.rs-274x&#x7f;application/vnd.ruckus.download&#x7f;application/vnd.s3sms&#x7f;application/vnd.sailingtracker.track&#x7f;application/vnd.sbm.cid&#x7f;application/vnd.sbm.mid2&#x7f;application/vnd.scribus&#x7f;application/vnd.sealed.3df&#x7f;application/vnd.sealed.csf&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;application/vnd.sealed.net&#x7f;application/vnd.sealed.ppt&#x7f;application/vnd.sealed.tiff&#x7f;application/vnd.sealed.xls&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.sema&#x7f;application/vnd.semd&#x7f;application/vnd.semf&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.SimTech-MindMapper&#x7f;application/vnd.smaf&#x7f;application/vnd.smart.notebook&#x7f;application/vnd.smart.teacher&#x7f;application/vnd.software602.filler.form+xml&#x7f;application/vnd.software602.filler.form-xml-zip&#x7f;application/vnd.solent.sdkm+xml&#x7f;application/vnd.spotfire.dxp&#x7f;application/vnd.spotfire.sfs&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.stepmania.package&#x7f;application/vnd.stepmania.stepchart&#x7f;application/vnd.street-stream&#x7f;application/vnd.sun.wadl+xml&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml.dm.notification&#x7f;application/vnd.syncml.dm+wbxml&#x7f;application/vnd.syncml.dm+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.syncml+xml&#x7f;application/vnd.tao.intent-module-archive&#x7f;application/vnd.tcpdump.pcap&#x7f;application/vnd.tmobile-livetv&#x7f;application/vnd.trid.tpt&#x7f;application/vnd.triscape.mxs&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ubisoft.webplayer&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.umajin&#x7f;application/vnd.unity&#x7f;application/vnd.uoml+xml&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.vcx&#x7f;application/vnd.vd-study&#x7f;application/vnd.vectorworks&#x7f;application/vnd.verimatrix.vcas&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;application/vnd.vsf&#x7f;application/vnd.wap.sic&#x7f;application/vnd.wap.slc&#x7f;application/vnd.wap.wbxml&#x7f;application/vnd.wap.wmlc&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wfa.wsc&#x7f;application/vnd.wmc&#x7f;application/vnd.wmf.bootstrap&#x7f;application/vnd.wolfram.mathematica&#x7f;application/vnd.wolfram.mathematica.package&#x7f;application/vnd.wolfram.player&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.xfdl.webform&#x7f;application/vnd.xmi+xml&#x7f;application/vnd.xmpie.cpkg&#x7f;application/vnd.xmpie.dpkg&#x7f;application/vnd.xmpie.plan&#x7f;application/vnd.xmpie.ppkg&#x7f;application/vnd.xmpie.xlim&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.openscoreformat.osfpvg+xml&#x7f;application/vnd.yamaha.openscoreformat&#x7f;application/vnd.yamaha.remote-setup&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yamaha.through-ngn&#x7f;application/vnd.yamaha.tunnel-udpencap&#x7f;application/vnd.yellowriver-custom-menu&#x7f;application/vnd.zul&#x7f;application/vnd.zzazz.deck+xml&#x7f;application/voicexml+xml&#x7f;application/vq-rtcpxr&#x7f;application/watcherinfo+xml&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/widget&#x7f;application/wita&#x7f;application/wordperfect5.1&#x7f;application/wsdl+xml&#x7f;application/wspolicy+xml&#x7f;application/x400-bp&#x7f;application/xcap-att+xml&#x7f;application/xcap-caps+xml&#x7f;application/xcap-diff+xml&#x7f;application/xcap-el+xml&#x7f;application/xcap-error+xml&#x7f;application/xcap-ns+xml&#x7f;application/xcon-conference-info-diff+xml&#x7f;application/xcon-conference-info+xml&#x7f;application/xenc+xml&#x7f;application/xhtml-voice+xml (Obsolete)&#x7f;application/xhtml+xml&#x7f;application/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/xslt+xml&#x7f;application/xv+xml&#x7f;application/yang&#x7f;application/yin+xml&#x7f;application/zip&#x7f;audio/1d-interleaved-parityfec&#x7f;audio/32kadpcm&#x7f;audio/3gpp&#x7f;audio/3gpp2&#x7f;audio/ac3&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;audio/amr-wb+&#x7f;audio/asc&#x7f;audio/ATRAC-ADVANCED-LOSSLESS&#x7f;audio/ATRAC-X&#x7f;audio/ATRAC3&#x7f;audio/basic&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;audio/clearmode&#x7f;audio/CN&#x7f;audio/DAT12&#x7f;audio/dls&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;audio/DV&#x7f;audio/DVI4&#x7f;audio/eac3&#x7f;audio/EVRC&#x7f;audio/EVRC0&#x7f;audio/EVRC1&#x7f;audio/EVRCB&#x7f;audio/EVRCB0&#x7f;audio/EVRCB1&#x7f;audio/EVRC-QCP&#x7f;audio/EVRCWB&#x7f;audio/EVRCWB0&#x7f;audio/EVRCWB1&#x7f;audio/fwdred&#x7f;audio/G719&#x7f;audio/G722&#x7f;audio/G7221&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G7291&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/GSM-HR-08&#x7f;audio/iLBC&#x7f;audio/ip-mr_v2.5&#x7f;audio/L8&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/LPC&#x7f;audio/mobile-xmf&#x7f;audio/MPA&#x7f;audio/MP4A-LATM&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;audio/PCMA&#x7f;audio/PCMA-WB&#x7f;audio/PCMU&#x7f;audio/PCMU-WB&#x7f;audio/prs.sid&#x7f;audio/QCELP&#x7f;audio/RED&#x7f;audio/rtp-enc-aescm128&#x7f;audio/rtp-midi&#x7f;audio/SMV&#x7f;audio/SMV0&#x7f;audio/SMV-QCP&#x7f;audio/sp-midi&#x7f;audio/speex&#x7f;audio/t140c&#x7f;audio/t38&#x7f;audio/telephone-event&#x7f;audio/tone&#x7f;audio/UEMCLIP&#x7f;audio/VDVI&#x7f;audio/VMR-WB&#x7f;audio/vnd.3gpp.iufp&#x7f;audio/vnd.4SB&#x7f;audio/vnd.audiokoz&#x7f;audio/vnd.CELP&#x7f;audio/vnd.cisco.nse&#x7f;audio/vnd.cmles.radio-events&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;audio/vnd.dece.audio&#x7f;audio/vnd.digital-winds&#x7f;audio/vnd.dlna.adts&#x7f;audio/vnd.dolby.heaac.1&#x7f;audio/vnd.dolby.heaac.2&#x7f;audio/vnd.dolby.mlp&#x7f;audio/vnd.dolby.mps&#x7f;audio/vnd.dolby.pl2&#x7f;audio/vnd.dolby.pl2x&#x7f;audio/vnd.dolby.pl2z&#x7f;audio/vnd.dolby.pulse.1&#x7f;audio/vnd.dra&#x7f;audio/vnd.dts&#x7f;audio/vnd.dts.hd&#x7f;audio/vnd.dvb.file&#x7f;audio/vnd.everad.plj&#x7f;audio/vnd.hns.audio&#x7f;audio/vnd.lucent.voice&#x7f;audio/vnd.ms-playready.media.pya&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;audio/vnd.nortel.vbk&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;audio/vnd.octel.sbc&#x7f;audio/vnd.qcelp - DEPRECATED - Please use audio/qcelp&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;audio/vnd.rip&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;audio/vnd.vmx.cvsd&#x7f;audio/vorbis&#x7f;audio/vorbis-config&#x7f;image/cgm&#x7f;image/g3fax&#x7f;image/gif&#x7f;image/ief&#x7f;image/jp2&#x7f;image/jpeg&#x7f;image/jpm&#x7f;image/jpx&#x7f;image/ktx&#x7f;image/naplps&#x7f;image/png&#x7f;image/prs.btif&#x7f;image/prs.pti&#x7f;image/svg+xml&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;image/vnd.adobe.photoshop&#x7f;image/vnd.cns.inf2&#x7f;image/vnd.dece.graphic&#x7f;image/vnd.djvu&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;image/vnd.dvb.subtitle&#x7f;image/vnd.fastbidsheet&#x7f;image/vnd.fpx&#x7f;image/vnd.fst&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;image/vnd.globalgraphics.pgb&#x7f;image/vnd.microsoft.icon&#x7f;image/vnd.mix&#x7f;image/vnd.ms-modi&#x7f;image/vnd.net-fpx&#x7f;image/vnd.radiance&#x7f;image/vnd.sealed.png&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;image/vnd.svf&#x7f;image/vnd.wap.wbmp&#x7f;image/vnd.xiff&#x7f;message/CPIM&#x7f;message/delivery-status&#x7f;message/disposition-notification&#x7f;message/external-body&#x7f;message/feedback-report&#x7f;message/global&#x7f;message/global-delivery-status&#x7f;message/global-disposition-notification&#x7f;message/global-headers&#x7f;message/imdn+xml&#x7f;message/news (OBSOLETE)&#x7f;message/partial&#x7f;message/rfc822&#x7f;message/s-http&#x7f;message/sip&#x7f;message/sipfrag&#x7f;message/tracking-status&#x7f;message/vnd.si.simp&#x7f;model/mesh&#x7f;model/vnd.collada+xml&#x7f;model/vnd.dwf&#x7f;model/vnd.flatland.3dml&#x7f;model/vnd.gdl&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;model/vnd.moml+xml&#x7f;model/vnd.mts&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;model/vnd.vtu&#x7f;model/vrml&#x7f;multipart/alternative&#x7f;multipart/appledouble&#x7f;multipart/byteranges&#x7f;multipart/digest&#x7f;multipart/encrypted&#x7f;multipart/form-data&#x7f;multipart/header-set&#x7f;multipart/mixed&#x7f;multipart/parallel&#x7f;multipart/related&#x7f;multipart/report&#x7f;multipart/signed&#x7f;multipart/voice-message&#x7f;text/calendar&#x7f;text/css&#x7f;text/csv&#x7f;text/directory (deprecated)&#x7f;text/ecmascript (obsolete)&#x7f;text/enriched&#x7f;text/html&#x7f;text/javascript (obsolete)&#x7f;text/jcr-cnd&#x7f;text/mizar&#x7f;text/n3&#x7f;text/plain&#x7f;text/prs.fallenstein.rst&#x7f;text/prs.lines.tag&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;text/t140&#x7f;text/tab-separated-values&#x7f;text/troff&#x7f;text/turtle&#x7f;text/uri-list&#x7f;text/vcard&#x7f;text/vnd.abc&#x7f;text/vnd.DMClientScript&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;text/vnd.graphviz&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;text/vnd.IPTC.NewsML&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.latex-z&#x7f;text/vnd.motorola.reflex&#x7f;text/vnd.ms-mediapackage&#x7f;text/vnd.net2phone.commcenter.command&#x7f;text/vnd.radisys.msml-basic-layout&#x7f;text/vnd.si.uricatalogue&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;text/vnd.trolltech.linguist&#x7f;text/vnd.wap.si&#x7f;text/vnd.wap.sl&#x7f;text/vnd.wap.wml&#x7f;text/vnd.wap.wmlscript&#x7f;video/3gpp-tt&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;video/CelB&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/H264-RCDO&#x7f;video/H264-SVC&#x7f;video/jpeg2000&#x7f;video/MJ2&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;video/MP4V-ES&#x7f;video/MPV&#x7f;video/nv&#x7f;video/pointer&#x7f;video/quicktime&#x7f;video/raw&#x7f;video/SMPTE292M&#x7f;video/vc1&#x7f;video/vnd.CCTV&#x7f;video/vnd.dece.hd&#x7f;video/vnd.dece.mobile&#x7f;video/vnd.dece.mp4&#x7f;video/vnd.dece.pd&#x7f;video/vnd.dece.sd&#x7f;video/vnd.dece.video&#x7f;video/vnd.directv.mpeg&#x7f;video/vnd.directv.mpeg-tts&#x7f;video/vnd.dlna.mpeg-tts&#x7f;video/vnd.fvt&#x7f;video/vnd.hns.video&#x7f;video/vnd.iptvforum.1dparityfec-1010&#x7f;video/vnd.iptvforum.1dparityfec-2005&#x7f;video/vnd.iptvforum.2dparityfec-1010&#x7f;video/vnd.iptvforum.2dparityfec-2005&#x7f;video/vnd.iptvforum.ttsavc&#x7f;video/vnd.iptvforum.ttsmpeg2&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;video/vnd.mpegurl&#x7f;video/vnd.ms-playready.media.pyv&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;video/vnd.nokia.videovoip&#x7f;video/vnd.objectvideo&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;video/vnd.sealed.swf&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;video/vnd.uvvu.mp4&#x7f;video/vnd.vivo&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( contains('&#x7f;application/1d-interleaved-parityfec&#x7f;audio/1d-interleaved-parityfec&#x7f;text/1d-interleaved-parityfec&#x7f;video/1d-interleaved-parityfec&#x7f;audio/32kadpcm&#x7f;application/3gpdash-qoe-report+xml&#x7f;audio/3gpp&#x7f;video/3gpp&#x7f;application/3gpp-ims+xml&#x7f;video/3gpp-tt&#x7f;audio/3gpp2&#x7f;video/3gpp2&#x7f;model/3mf&#x7f;application/A2L&#x7f;application/AML&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;application/ATF&#x7f;application/ATFX&#x7f;audio/ATRAC-ADVANCED-LOSSLESS&#x7f;audio/ATRAC-X&#x7f;audio/ATRAC3&#x7f;application/ATXML&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;application/CALS-1840&#x7f;application/CDFX+XML&#x7f;application/CEA&#x7f;audio/CN&#x7f;message/CPIM&#x7f;application/CSTAdata+xml&#x7f;video/CelB&#x7f;audio/DAT12&#x7f;application/DCD&#x7f;application/DII&#x7f;application/DIT&#x7f;audio/DV&#x7f;video/DV&#x7f;audio/DVI4&#x7f;application/EDI-X12&#x7f;application/EDI-consent&#x7f;application/EDIFACT&#x7f;audio/EVRC&#x7f;audio/EVRC-QCP&#x7f;audio/EVRC0&#x7f;audio/EVRC1&#x7f;audio/EVRCB&#x7f;audio/EVRCB0&#x7f;audio/EVRCB1&#x7f;audio/EVRCNW&#x7f;audio/EVRCNW0&#x7f;audio/EVRCNW1&#x7f;audio/EVRCWB&#x7f;audio/EVRCWB0&#x7f;audio/EVRCWB1&#x7f;audio/EVS&#x7f;application/EmergencyCallData.Comment+xml&#x7f;application/EmergencyCallData.Control+xml&#x7f;application/EmergencyCallData.DeviceInfo+xml&#x7f;application/EmergencyCallData.ProviderInfo+xml&#x7f;application/EmergencyCallData.ServiceInfo+xml&#x7f;application/EmergencyCallData.SubscriberInfo+xml&#x7f;application/EmergencyCallData.VEDS+xml&#x7f;application/EmergencyCallData.eCall.MSD&#x7f;audio/G711-0&#x7f;audio/G719&#x7f;audio/G722&#x7f;audio/G7221&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G7291&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/GSM-HR-08&#x7f;application/H224&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/H264-RCDO&#x7f;video/H264-SVC&#x7f;video/H265&#x7f;video/JPEG&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/L8&#x7f;audio/LPC&#x7f;application/LXF&#x7f;audio/MELP&#x7f;audio/MELP1200&#x7f;audio/MELP2400&#x7f;audio/MELP600&#x7f;application/MF4&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;audio/MP4A-LATM&#x7f;video/MP4V-ES&#x7f;audio/MPA&#x7f;video/MPV&#x7f;application/ODX&#x7f;audio/PCMA&#x7f;audio/PCMA-WB&#x7f;audio/PCMU&#x7f;audio/PCMU-WB&#x7f;application/PDX&#x7f;audio/QCELP&#x7f;audio/RED&#x7f;text/RED&#x7f;video/SMPTE292M&#x7f;audio/SMV&#x7f;audio/SMV-QCP&#x7f;audio/SMV0&#x7f;audio/UEMCLIP&#x7f;audio/VDVI&#x7f;audio/VMR-WB&#x7f;video/VP8&#x7f;audio/ac3&#x7f;image/aces&#x7f;application/activemessage&#x7f;application/activemessage&#x7f;multipart/alternative&#x7f;application/alto-costmap+json&#x7f;application/alto-costmapfilter+json&#x7f;application/alto-directory+json&#x7f;application/alto-endpointcost+json&#x7f;application/alto-endpointcostparams+json&#x7f;application/alto-endpointprop+json&#x7f;application/alto-endpointpropparams+json&#x7f;application/alto-error+json&#x7f;application/alto-networkmap+json&#x7f;application/alto-networkmapfilter+json&#x7f;audio/amr-wb+&#x7f;application/andrew-inset&#x7f;multipart/appledouble&#x7f;application/applefile&#x7f;audio/aptx&#x7f;audio/asc&#x7f;application/atom+xml&#x7f;application/atomcat+xml&#x7f;application/atomdeleted+xml&#x7f;application/atomicmail&#x7f;application/atomsvc+xml&#x7f;application/auth-policy+xml&#x7f;application/bacnet-xdd+zip&#x7f;audio/basic&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;image/bmp&#x7f;multipart/byteranges&#x7f;text/cache-manifest&#x7f;text/calendar&#x7f;application/calendar+json&#x7f;application/calendar+xml&#x7f;application/call-completion&#x7f;application/cbor&#x7f;application/cccex&#x7f;application/ccmp+xml&#x7f;application/ccxml+xml&#x7f;application/cdmi-capability&#x7f;application/cdmi-container&#x7f;application/cdmi-domain&#x7f;application/cdmi-object&#x7f;application/cdmi-queue&#x7f;application/cdni&#x7f;application/cea-2018+xml&#x7f;application/cellml+xml&#x7f;application/cfw&#x7f;image/cgm&#x7f;audio/clearmode&#x7f;application/clue_info+xml&#x7f;application/cms&#x7f;application/cnrp+xml&#x7f;application/coap-group+json&#x7f;application/coap-payload&#x7f;font/collection&#x7f;application/commonground&#x7f;application/conference-info+xml&#x7f;application/cose&#x7f;application/cose-key&#x7f;application/cose-key-set&#x7f;application/cpl+xml&#x7f;application/csrattrs&#x7f;text/css&#x7f;application/csta+xml&#x7f;text/csv&#x7f;text/csv-schema&#x7f;application/csvm+json&#x7f;application/cybercash&#x7f;application/dash+xml&#x7f;application/dashdelta&#x7f;application/davmount+xml&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;message/delivery-status&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dicom+json&#x7f;application/dicom+xml&#x7f;image/dicom-rle&#x7f;multipart/digest&#x7f;message/disposition-notification&#x7f;audio/dls&#x7f;application/dns&#x7f;text/dns&#x7f;application/dskpp+xml&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;application/dssc+der&#x7f;application/dssc+xml&#x7f;application/dvcs&#x7f;audio/eac3&#x7f;application/ecmascript&#x7f;application/efi&#x7f;image/emf&#x7f;application/emma+xml&#x7f;application/emotionml+xml&#x7f;application/encaprtp&#x7f;audio/encaprtp&#x7f;text/encaprtp&#x7f;video/encaprtp&#x7f;multipart/encrypted&#x7f;text/enriched&#x7f;application/epp+xml&#x7f;application/epub+zip&#x7f;application/eshop&#x7f;application/example&#x7f;audio/example&#x7f;image/example&#x7f;message/example&#x7f;model/example&#x7f;multipart/example&#x7f;text/example&#x7f;video/example&#x7f;application/exi&#x7f;message/external-body&#x7f;application/fastinfoset&#x7f;application/fastsoap&#x7f;application/fdt+xml&#x7f;message/feedback-report&#x7f;application/fhir+xml&#x7f;application/fits&#x7f;image/fits&#x7f;application/font-tdpfr&#x7f;multipart/form-data&#x7f;application/framework-attributes+xml&#x7f;audio/fwdred&#x7f;text/fwdred&#x7f;image/g3fax&#x7f;application/geo+json&#x7f;application/geo+json-seq&#x7f;application/geoxacml+xml&#x7f;image/gif&#x7f;message/global&#x7f;message/global-delivery-status&#x7f;message/global-disposition-notification&#x7f;message/global-headers&#x7f;model/gltf+json&#x7f;model/gltf-binary&#x7f;application/gml+xml&#x7f;text/grammar-ref-list&#x7f;application/gzip&#x7f;multipart/header-set&#x7f;application/held+xml&#x7f;text/html&#x7f;application/http&#x7f;message/http&#x7f;application/hyperstudio&#x7f;audio/iLBC&#x7f;application/ibe-key-request+xml&#x7f;application/ibe-pkg-reply+xml&#x7f;application/ibe-pp-data&#x7f;image/ief&#x7f;application/iges&#x7f;model/iges&#x7f;application/im-iscomposing+xml&#x7f;message/imdn+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/inkml+xml&#x7f;application/iotp&#x7f;audio/ip-mr_v2.5&#x7f;application/ipfix&#x7f;application/ipp&#x7f;video/iso.segment&#x7f;application/isup&#x7f;application/its+xml&#x7f;application/javascript&#x7f;text/jcr-cnd&#x7f;application/jf2feed+json&#x7f;image/jls&#x7f;application/jose&#x7f;application/jose+json&#x7f;image/jp2&#x7f;image/jpeg&#x7f;video/jpeg2000&#x7f;image/jpm&#x7f;image/jpx&#x7f;application/jrd+json&#x7f;application/json&#x7f;application/json-patch+json&#x7f;application/json-seq&#x7f;application/jwk+json&#x7f;application/jwk-set+json&#x7f;application/jwt&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;image/ktx&#x7f;application/ld+json&#x7f;application/lgr+xml&#x7f;application/link-format&#x7f;application/load-control+xml&#x7f;application/lost+xml&#x7f;application/lostsync+xml&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/mads+xml&#x7f;application/marc&#x7f;application/marcxml+xml&#x7f;text/markdown&#x7f;application/mathematica&#x7f;application/mathml+xml&#x7f;application/mathml-content+xml&#x7f;application/mathml-presentation+xml&#x7f;application/mbms-associated-procedure-description+xml&#x7f;application/mbms-deregister+xml&#x7f;application/mbms-envelope+xml&#x7f;application/mbms-msk+xml&#x7f;application/mbms-msk-response+xml&#x7f;application/mbms-protection-description+xml&#x7f;application/mbms-reception-report+xml&#x7f;application/mbms-register+xml&#x7f;application/mbms-register-response+xml&#x7f;application/mbms-schedule+xml&#x7f;application/mbms-user-service-description+xml&#x7f;application/mbox&#x7f;application/media-policy-dataset+xml&#x7f;application/media_control+xml&#x7f;application/mediaservercontrol+xml&#x7f;application/merge-patch+json&#x7f;model/mesh&#x7f;application/metalink4+xml&#x7f;application/mets+xml&#x7f;application/mikey&#x7f;multipart/mixed&#x7f;text/mizar&#x7f;video/mj2&#x7f;application/mmt-usd+xml&#x7f;audio/mobile-xmf&#x7f;application/mods+xml&#x7f;application/moss-keys&#x7f;application/moss-signature&#x7f;application/mosskey-data&#x7f;application/mosskey-request&#x7f;application/mp21&#x7f;application/mp4&#x7f;audio/mp4&#x7f;video/mp4&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;video/mpeg&#x7f;application/mpeg4-generic&#x7f;audio/mpeg4-generic&#x7f;video/mpeg4-generic&#x7f;application/mpeg4-iod&#x7f;application/mpeg4-iod-xmt&#x7f;application/mrb-consumer+xml&#x7f;application/mrb-publish+xml&#x7f;application/msc-ivr+xml&#x7f;application/msc-mixer+xml&#x7f;application/msword&#x7f;application/mud+json&#x7f;multipart/multilingual&#x7f;application/mxf&#x7f;application/n-quads&#x7f;application/n-triples&#x7f;text/n3&#x7f;image/naplps&#x7f;application/nasdata&#x7f;application/news-checkgroups&#x7f;application/news-groupinfo&#x7f;application/news-transmission&#x7f;application/nlsml+xml&#x7f;application/node&#x7f;application/nss&#x7f;video/nv&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/oda&#x7f;application/oebps-package+xml&#x7f;application/ogg&#x7f;audio/ogg&#x7f;video/ogg&#x7f;audio/opus&#x7f;font/otf&#x7f;application/oxps&#x7f;application/p2p-overlay+xml&#x7f;multipart/parallel&#x7f;text/parameters&#x7f;application/parityfec&#x7f;audio/parityfec&#x7f;text/parityfec&#x7f;video/parityfec&#x7f;message/partial&#x7f;application/passport&#x7f;application/patch-ops-error+xml&#x7f;application/pdf&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pidf-diff+xml&#x7f;application/pkcs10&#x7f;application/pkcs12&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkcs8&#x7f;application/pkcs8-encrypted&#x7f;application/pkix-attr-cert&#x7f;application/pkix-cert&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pkixcmp&#x7f;text/plain&#x7f;application/pls+xml&#x7f;image/png&#x7f;application/poc-settings+xml&#x7f;video/pointer&#x7f;application/postscript&#x7f;application/ppsp-tracker+json&#x7f;application/problem+json&#x7f;application/problem+xml&#x7f;application/provenance+xml&#x7f;text/provenance-notation&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;image/prs.btif&#x7f;application/prs.cww&#x7f;text/prs.fallenstein.rst&#x7f;application/prs.hpub+zip&#x7f;text/prs.lines.tag&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;text/prs.prop.logic&#x7f;image/prs.pti&#x7f;application/prs.rdf-xml-crypt&#x7f;audio/prs.sid&#x7f;application/prs.xsf+xml&#x7f;application/pskc+xml&#x7f;image/pwg-raster&#x7f;application/qsig&#x7f;video/quicktime&#x7f;application/raptorfec&#x7f;audio/raptorfec&#x7f;text/raptorfec&#x7f;video/raptorfec&#x7f;video/raw&#x7f;application/rdap+json&#x7f;application/rdf+xml&#x7f;application/reginfo+xml&#x7f;multipart/related&#x7f;application/relax-ng-compact-syntax&#x7f;application/remote-printing&#x7f;multipart/report&#x7f;application/reputon+json&#x7f;application/resource-lists+xml&#x7f;application/resource-lists-diff+xml&#x7f;application/rfc+xml&#x7f;message/rfc822&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;application/riscos&#x7f;application/rlmi+xml&#x7f;application/rls-services+xml&#x7f;application/route-apd+xml&#x7f;application/route-s-tsid+xml&#x7f;application/route-usd+xml&#x7f;application/rpki-ghostbusters&#x7f;application/rpki-manifest&#x7f;application/rpki-publication&#x7f;application/rpki-roa&#x7f;application/rpki-updown&#x7f;application/rtf&#x7f;text/rtf&#x7f;audio/rtp-enc-aescm128&#x7f;text/rtp-enc-aescm128&#x7f;video/rtp-enc-aescm128&#x7f;audio/rtp-midi&#x7f;application/rtploopback&#x7f;audio/rtploopback&#x7f;text/rtploopback&#x7f;video/rtploopback&#x7f;application/rtx&#x7f;audio/rtx&#x7f;text/rtx&#x7f;video/rtx&#x7f;message/s-http&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbml+xml&#x7f;application/scaip+xml&#x7f;application/scim+json&#x7f;application/scvp-cv-request&#x7f;application/scvp-cv-response&#x7f;application/scvp-vp-request&#x7f;application/scvp-vp-response&#x7f;application/sdp&#x7f;application/sep+xml&#x7f;application/sep-exi&#x7f;application/session-info&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;font/sfnt&#x7f;application/sgml&#x7f;text/sgml&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;multipart/signed&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/simpleSymbolContainer&#x7f;message/sip&#x7f;message/sipfrag&#x7f;application/slate&#x7f;application/smil+xml&#x7f;video/smpte291&#x7f;application/smpte336m&#x7f;application/soap+fastinfoset&#x7f;application/soap+xml&#x7f;audio/sp-midi&#x7f;application/sparql-query&#x7f;application/sparql-results+xml&#x7f;audio/speex&#x7f;application/spirits-event+xml&#x7f;application/sql&#x7f;application/srgs&#x7f;application/srgs+xml&#x7f;application/sru+xml&#x7f;application/ssml+xml&#x7f;text/strings&#x7f;image/svg+xml&#x7f;text/t140&#x7f;audio/t140c&#x7f;audio/t38&#x7f;image/t38&#x7f;text/tab-separated-values&#x7f;application/tamp-apex-update&#x7f;application/tamp-apex-update-confirm&#x7f;application/tamp-community-update&#x7f;application/tamp-community-update-confirm&#x7f;application/tamp-error&#x7f;application/tamp-sequence-adjust&#x7f;application/tamp-sequence-adjust-confirm&#x7f;application/tamp-status-query&#x7f;application/tamp-status-response&#x7f;application/tamp-update&#x7f;application/tamp-update-confirm&#x7f;application/tei+xml&#x7f;audio/telephone-event&#x7f;application/thraud+xml&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/timestamped-data&#x7f;application/tnauthlist&#x7f;audio/tone&#x7f;message/tracking-status&#x7f;application/trig&#x7f;text/troff&#x7f;font/ttf&#x7f;application/ttml+xml&#x7f;text/turtle&#x7f;application/tve-trigger&#x7f;application/ulpfec&#x7f;audio/ulpfec&#x7f;text/ulpfec&#x7f;video/ulpfec&#x7f;application/urc-grpsheet+xml&#x7f;application/urc-ressheet+xml&#x7f;application/urc-targetdesc+xml&#x7f;application/urc-uisocketdesc+xml&#x7f;text/uri-list&#x7f;video/vc1&#x7f;text/vcard&#x7f;application/vcard+json&#x7f;application/vcard+xml&#x7f;application/vemmi&#x7f;application/vnd.1000minds.decision-model+xml&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.3gpp-prose+xml&#x7f;application/vnd.3gpp-prose-pc3ch+xml&#x7f;application/vnd.3gpp-v2x-local-service-information&#x7f;application/vnd.3gpp.GMOP+xml&#x7f;application/vnd.3gpp.SRVCC-info+xml&#x7f;application/vnd.3gpp.access-transfer-events+xml&#x7f;application/vnd.3gpp.bsf+xml&#x7f;audio/vnd.3gpp.iufp&#x7f;application/vnd.3gpp.mcptt-affiliation-command+xml&#x7f;application/vnd.3gpp.mcptt-floor-request+xml&#x7f;application/vnd.3gpp.mcptt-info+xml&#x7f;application/vnd.3gpp.mcptt-location-info+xml&#x7f;application/vnd.3gpp.mcptt-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcptt-signed+xml&#x7f;application/vnd.3gpp.mid-call+xml&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.3gpp.sms+xml&#x7f;application/vnd.3gpp.srvcc-ext+xml&#x7f;application/vnd.3gpp.state-and-event-info+xml&#x7f;application/vnd.3gpp.ussd+xml&#x7f;application/vnd.3gpp2.bcmcsinfo+xml&#x7f;application/vnd.3gpp2.sms&#x7f;application/vnd.3gpp2.tcap&#x7f;application/vnd.3lightssoftware.imagescal&#x7f;audio/vnd.4SB&#x7f;video/vnd.CCTV&#x7f;audio/vnd.CELP&#x7f;text/vnd.DMClientScript&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.HandHeld-Entertainment+xml&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.IPTC.NewsML&#x7f;application/vnd.Kinar&#x7f;application/vnd.MFER&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.SimTech-MindMapper&#x7f;text/vnd.a&#x7f;text/vnd.abc&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.flash.movie&#x7f;application/vnd.adobe.formscentral.fcdt&#x7f;application/vnd.adobe.fxp&#x7f;application/vnd.adobe.partial-upload&#x7f;image/vnd.adobe.photoshop&#x7f;application/vnd.adobe.xdp+xml&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.ah-barcode&#x7f;application/vnd.ahead.space&#x7f;image/vnd.airzip.accelerator.azv&#x7f;application/vnd.airzip.filesecure.azf&#x7f;application/vnd.airzip.filesecure.azs&#x7f;application/vnd.amadeus+json&#x7f;application/vnd.amazon.mobi8-ebook&#x7f;application/vnd.americandynamics.acc&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.amundsen.maze+xml&#x7f;application/vnd.anki&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.antix.game-component&#x7f;application/vnd.apache.thrift.binary&#x7f;application/vnd.apache.thrift.compact&#x7f;application/vnd.apache.thrift.json&#x7f;application/vnd.api+json&#x7f;application/vnd.apothekende.reservation+json&#x7f;application/vnd.apple.installer+xml&#x7f;application/vnd.apple.mpegurl&#x7f;application/vnd.aristanetworks.swi&#x7f;application/vnd.artsquare&#x7f;text/vnd.ascii-art&#x7f;application/vnd.astraea-software.iota&#x7f;application/vnd.audiograph&#x7f;audio/vnd.audiokoz&#x7f;application/vnd.autopackage&#x7f;application/vnd.avalon+json&#x7f;application/vnd.avistar+xml&#x7f;application/vnd.balsamiq.bmml+xml&#x7f;application/vnd.balsamiq.bmpr&#x7f;application/vnd.bbf.usp.msg&#x7f;application/vnd.bbf.usp.msg+json&#x7f;application/vnd.bekitzur-stech+json&#x7f;application/vnd.bint.med-content&#x7f;multipart/vnd.bint.med-plus&#x7f;application/vnd.biopax.rdf+xml&#x7f;application/vnd.blink-idb-value-wrapper&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bluetooth.ep.oob&#x7f;application/vnd.bluetooth.le.oob&#x7f;application/vnd.bmi&#x7f;application/vnd.businessobjects&#x7f;application/vnd.cab-jscript&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.capasystems-pg+json&#x7f;application/vnd.cendio.thinlinc.clientconf&#x7f;application/vnd.century-systems.tcp_stream&#x7f;application/vnd.chemdraw+xml&#x7f;application/vnd.chess-pgn&#x7f;application/vnd.chipnuts.karaoke-mmd&#x7f;application/vnd.cinderella&#x7f;application/vnd.cirpack.isdn-ext&#x7f;audio/vnd.cisco.nse&#x7f;application/vnd.citationstyles.style+xml&#x7f;application/vnd.claymore&#x7f;application/vnd.cloanto.rp9&#x7f;application/vnd.clonk.c4group&#x7f;application/vnd.cluetrust.cartomobile-config&#x7f;application/vnd.cluetrust.cartomobile-config-pkg&#x7f;audio/vnd.cmles.radio-events&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;image/vnd.cns.inf2&#x7f;application/vnd.coffeescript&#x7f;application/vnd.collabio.xodocuments.document&#x7f;application/vnd.collabio.xodocuments.document-template&#x7f;application/vnd.collabio.xodocuments.presentation&#x7f;application/vnd.collabio.xodocuments.presentation-template&#x7f;application/vnd.collabio.xodocuments.spreadsheet&#x7f;application/vnd.collabio.xodocuments.spreadsheet-template&#x7f;model/vnd.collada+xml&#x7f;application/vnd.collection+json&#x7f;application/vnd.collection.doc+json&#x7f;application/vnd.collection.next+json&#x7f;application/vnd.comicbook+zip&#x7f;application/vnd.comicbook-rar&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.coreos.ignition+json&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.crick.clicker&#x7f;application/vnd.crick.clicker.keyboard&#x7f;application/vnd.crick.clicker.palette&#x7f;application/vnd.crick.clicker.template&#x7f;application/vnd.crick.clicker.wordbank&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.ctct.ws+xml&#x7f;application/vnd.cups-pdf&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-ppd&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;text/vnd.curl&#x7f;application/vnd.cyan.dean.root+xml&#x7f;application/vnd.cybank&#x7f;application/vnd.d2l.coursepackage1p0+zip&#x7f;application/vnd.dart&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.datapackage+json&#x7f;application/vnd.dataresource+json&#x7f;application/vnd.debian.binary-package&#x7f;text/vnd.debian.copyright&#x7f;audio/vnd.dece.audio&#x7f;application/vnd.dece.data&#x7f;image/vnd.dece.graphic&#x7f;video/vnd.dece.hd&#x7f;video/vnd.dece.mobile&#x7f;video/vnd.dece.mp4&#x7f;video/vnd.dece.pd&#x7f;video/vnd.dece.sd&#x7f;application/vnd.dece.ttml+xml&#x7f;application/vnd.dece.unspecified&#x7f;video/vnd.dece.video&#x7f;application/vnd.dece.zip&#x7f;application/vnd.denovo.fcselayout-link&#x7f;application/vnd.desmume.movie&#x7f;audio/vnd.digital-winds&#x7f;application/vnd.dir-bi.plate-dl-nosuffix&#x7f;video/vnd.directv.mpeg&#x7f;video/vnd.directv.mpeg-tts&#x7f;image/vnd.djvu&#x7f;audio/vnd.dlna.adts&#x7f;video/vnd.dlna.mpeg-tts&#x7f;application/vnd.dm.delegation+xml&#x7f;application/vnd.dna&#x7f;application/vnd.document+json&#x7f;audio/vnd.dolby.heaac.1&#x7f;audio/vnd.dolby.heaac.2&#x7f;audio/vnd.dolby.mlp&#x7f;application/vnd.dolby.mobile.1&#x7f;application/vnd.dolby.mobile.2&#x7f;audio/vnd.dolby.mps&#x7f;audio/vnd.dolby.pl2&#x7f;audio/vnd.dolby.pl2x&#x7f;audio/vnd.dolby.pl2z&#x7f;audio/vnd.dolby.pulse.1&#x7f;application/vnd.doremir.scorecloud-binary-document&#x7f;application/vnd.dpgraph&#x7f;audio/vnd.dra&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.drive+json&#x7f;application/vnd.dtg.local&#x7f;application/vnd.dtg.local.flash&#x7f;application/vnd.dtg.local.html&#x7f;audio/vnd.dts&#x7f;audio/vnd.dts.hd&#x7f;application/vnd.dvb.ait&#x7f;application/vnd.dvb.dvbj&#x7f;application/vnd.dvb.esgcontainer&#x7f;audio/vnd.dvb.file&#x7f;video/vnd.dvb.file&#x7f;application/vnd.dvb.ipdcdftnotifaccess&#x7f;application/vnd.dvb.ipdcesgaccess&#x7f;application/vnd.dvb.ipdcesgaccess2&#x7f;application/vnd.dvb.ipdcesgpdd&#x7f;application/vnd.dvb.ipdcroaming&#x7f;application/vnd.dvb.iptv.alfec-base&#x7f;application/vnd.dvb.iptv.alfec-enhancement&#x7f;application/vnd.dvb.notif-aggregate-root+xml&#x7f;application/vnd.dvb.notif-container+xml&#x7f;application/vnd.dvb.notif-generic+xml&#x7f;application/vnd.dvb.notif-ia-msglist+xml&#x7f;application/vnd.dvb.notif-ia-registration-request+xml&#x7f;application/vnd.dvb.notif-ia-registration-response+xml&#x7f;application/vnd.dvb.notif-init+xml&#x7f;application/vnd.dvb.pfr&#x7f;application/vnd.dvb.service&#x7f;image/vnd.dvb.subtitle&#x7f;text/vnd.dvb.subtitle&#x7f;model/vnd.dwf&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;application/vnd.dxr&#x7f;application/vnd.dynageo&#x7f;application/vnd.dzr&#x7f;application/vnd.easykaraoke.cdgdownload&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecip.rlp&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.efi.img&#x7f;application/vnd.efi.iso&#x7f;application/vnd.emclient.accessrequest+xml&#x7f;application/vnd.enliven&#x7f;application/vnd.enphase.envoy&#x7f;application/vnd.eprints.data+xml&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;application/vnd.espass-espass+zip&#x7f;application/vnd.eszigno3+xml&#x7f;application/vnd.etsi.aoc+xml&#x7f;application/vnd.etsi.asic-e+zip&#x7f;application/vnd.etsi.asic-s+zip&#x7f;application/vnd.etsi.cug+xml&#x7f;application/vnd.etsi.iptvcommand+xml&#x7f;application/vnd.etsi.iptvdiscovery+xml&#x7f;application/vnd.etsi.iptvprofile+xml&#x7f;application/vnd.etsi.iptvsad-bc+xml&#x7f;application/vnd.etsi.iptvsad-cod+xml&#x7f;application/vnd.etsi.iptvsad-npvr+xml&#x7f;application/vnd.etsi.iptvservice+xml&#x7f;application/vnd.etsi.iptvsync+xml&#x7f;application/vnd.etsi.iptvueprofile+xml&#x7f;application/vnd.etsi.mcid+xml&#x7f;application/vnd.etsi.mheg5&#x7f;application/vnd.etsi.overload-control-policy-dataset+xml&#x7f;application/vnd.etsi.pstn+xml&#x7f;application/vnd.etsi.sci+xml&#x7f;application/vnd.etsi.simservs+xml&#x7f;application/vnd.etsi.timestamp-token&#x7f;application/vnd.etsi.tsl+xml&#x7f;application/vnd.etsi.tsl.der&#x7f;application/vnd.eudora.data&#x7f;audio/vnd.everad.plj&#x7f;application/vnd.evolv.ecig.profile&#x7f;application/vnd.evolv.ecig.settings&#x7f;application/vnd.evolv.ecig.theme&#x7f;application/vnd.ezpix-album&#x7f;application/vnd.ezpix-package&#x7f;application/vnd.f-secure.mobile&#x7f;image/vnd.fastbidsheet&#x7f;application/vnd.fastcopy-disk-image&#x7f;application/vnd.fdf&#x7f;application/vnd.fdsn.mseed&#x7f;application/vnd.fdsn.seed&#x7f;application/vnd.ffsns&#x7f;application/vnd.filmit.zfc&#x7f;application/vnd.fints&#x7f;application/vnd.firemonkeys.cloudcell&#x7f;model/vnd.flatland.3dml&#x7f;application/vnd.fluxtime.clip&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;application/vnd.font-fontforge-sfd&#x7f;image/vnd.fpx&#x7f;application/vnd.framemaker&#x7f;application/vnd.frogans.fnc&#x7f;application/vnd.frogans.ltf&#x7f;application/vnd.fsc.weblaunch&#x7f;image/vnd.fst&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ART-EX&#x7f;application/vnd.fujixerox.ART4&#x7f;application/vnd.fujixerox.HBPL&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fujixerox.docuworks.container&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.fuzzysheet&#x7f;video/vnd.fvt&#x7f;model/vnd.gdl&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.geogebra.file&#x7f;application/vnd.geogebra.tool&#x7f;application/vnd.geometry-explorer&#x7f;application/vnd.geonext&#x7f;application/vnd.geoplan&#x7f;application/vnd.geospace&#x7f;application/vnd.gerber&#x7f;image/vnd.globalgraphics.pgb&#x7f;application/vnd.globalplatform.card-content-mgt&#x7f;application/vnd.globalplatform.card-content-mgt-response&#x7f;application/vnd.google-earth.kml+xml&#x7f;application/vnd.google-earth.kmz&#x7f;application/vnd.gov.sk.e-form+xml&#x7f;application/vnd.gov.sk.e-form+zip&#x7f;application/vnd.gov.sk.xmldatacontainer+xml&#x7f;application/vnd.grafeq&#x7f;text/vnd.graphviz&#x7f;application/vnd.gridmp&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;application/vnd.hal+json&#x7f;application/vnd.hal+xml&#x7f;application/vnd.hbci&#x7f;application/vnd.hc+json&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hdt&#x7f;application/vnd.heroku+json&#x7f;application/vnd.hhe.lesson-player&#x7f;audio/vnd.hns.audio&#x7f;video/vnd.hns.video&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.hp-jlyt&#x7f;application/vnd.httphone&#x7f;application/vnd.hydrostatix.sof-data&#x7f;application/vnd.hyper-item+json&#x7f;application/vnd.hyperdrive+json&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.afplinedata&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.modcap&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.iccprofile&#x7f;application/vnd.ieee.1905&#x7f;application/vnd.igloader&#x7f;application/vnd.imagemeter.folder+zip&#x7f;application/vnd.imagemeter.image+zip&#x7f;application/vnd.immervision-ivp&#x7f;application/vnd.immervision-ivu&#x7f;application/vnd.ims.imsccv1p1&#x7f;application/vnd.ims.imsccv1p2&#x7f;application/vnd.ims.imsccv1p3&#x7f;application/vnd.ims.lis.v2.result+json&#x7f;application/vnd.ims.lti.v2.toolconsumerprofile+json&#x7f;application/vnd.ims.lti.v2.toolproxy+json&#x7f;application/vnd.ims.lti.v2.toolproxy.id+json&#x7f;application/vnd.ims.lti.v2.toolsettings+json&#x7f;application/vnd.ims.lti.v2.toolsettings.simple+json&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;application/vnd.informedcontrol.rms+xml&#x7f;application/vnd.infotech.project&#x7f;application/vnd.infotech.project+xml&#x7f;application/vnd.innopath.wamp.notification&#x7f;application/vnd.insors.igm&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intergeo&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.iptc.g2.catalogitem+xml&#x7f;application/vnd.iptc.g2.conceptitem+xml&#x7f;application/vnd.iptc.g2.knowledgeitem+xml&#x7f;application/vnd.iptc.g2.newsitem+xml&#x7f;application/vnd.iptc.g2.newsmessage+xml&#x7f;application/vnd.iptc.g2.packageitem+xml&#x7f;application/vnd.iptc.g2.planningitem+xml&#x7f;video/vnd.iptvforum.1dparityfec-1010&#x7f;video/vnd.iptvforum.1dparityfec-2005&#x7f;video/vnd.iptvforum.2dparityfec-1010&#x7f;video/vnd.iptvforum.2dparityfec-2005&#x7f;video/vnd.iptvforum.ttsavc&#x7f;video/vnd.iptvforum.ttsmpeg2&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.isac.fcs&#x7f;application/vnd.jam&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jcp.javame.midlet-rms&#x7f;application/vnd.jisp&#x7f;application/vnd.joost.joda-archive&#x7f;application/vnd.jsk.isdn-ngn&#x7f;application/vnd.kahootz&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.koan&#x7f;application/vnd.kodak-descriptor&#x7f;application/vnd.las.las+json&#x7f;application/vnd.las.las+xml&#x7f;text/vnd.latex-z&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;audio/vnd.lucent.voice&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.mapbox-vector-tile&#x7f;application/vnd.marlin.drm.actiontoken+xml&#x7f;application/vnd.marlin.drm.conftoken+xml&#x7f;application/vnd.marlin.drm.license+xml&#x7f;application/vnd.marlin.drm.mdcf&#x7f;application/vnd.mason+json&#x7f;application/vnd.maxmind.maxmind-db&#x7f;application/vnd.mcd&#x7f;application/vnd.medcalcdata&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.mfmp&#x7f;application/vnd.micro+json&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;image/vnd.microsoft.icon&#x7f;application/vnd.microsoft.portable-executable&#x7f;application/vnd.microsoft.windows.thumbnail-cache&#x7f;application/vnd.miele+json&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;image/vnd.mix&#x7f;model/vnd.moml+xml&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.motorola.iprm&#x7f;text/vnd.motorola.reflex&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;image/vnd.mozilla.apng&#x7f;application/vnd.mozilla.xul+xml&#x7f;video/vnd.mpegurl&#x7f;application/vnd.ms-3mfdocument&#x7f;application/vnd.ms-PrintDeviceCapabilities+xml&#x7f;application/vnd.ms-PrintSchemaTicket+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-cab-compressed&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-excel.addin.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.binary.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.macroEnabled.12&#x7f;application/vnd.ms-excel.template.macroEnabled.12&#x7f;application/vnd.ms-fontobject&#x7f;application/vnd.ms-htmlhelp&#x7f;application/vnd.ms-ims&#x7f;application/vnd.ms-lrm&#x7f;text/vnd.ms-mediapackage&#x7f;image/vnd.ms-modi&#x7f;application/vnd.ms-office.activeX+xml&#x7f;application/vnd.ms-officetheme&#x7f;application/vnd.ms-playready.initiator+xml&#x7f;audio/vnd.ms-playready.media.pya&#x7f;video/vnd.ms-playready.media.pyv&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-powerpoint.addin.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.presentation.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slide.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slideshow.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.template.macroEnabled.12&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-windows.devicepairing&#x7f;application/vnd.ms-windows.nwprinting.oob&#x7f;application/vnd.ms-windows.printerpairing&#x7f;application/vnd.ms-windows.wsd.oob&#x7f;application/vnd.ms-wmdrm.lic-chlg-req&#x7f;application/vnd.ms-wmdrm.lic-resp&#x7f;application/vnd.ms-wmdrm.meter-chlg-req&#x7f;application/vnd.ms-wmdrm.meter-resp&#x7f;application/vnd.ms-word.document.macroEnabled.12&#x7f;application/vnd.ms-word.template.macroEnabled.12&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.ms-xpsdocument&#x7f;application/vnd.msa-disk-image&#x7f;application/vnd.mseq&#x7f;application/vnd.msign&#x7f;model/vnd.mts&#x7f;application/vnd.multiad.creator&#x7f;application/vnd.multiad.creator.cif&#x7f;application/vnd.music-niff&#x7f;application/vnd.musician&#x7f;application/vnd.muvee.style&#x7f;application/vnd.mynfc&#x7f;application/vnd.ncd.control&#x7f;application/vnd.ncd.reference&#x7f;application/vnd.nearst.inv+json&#x7f;application/vnd.nervana&#x7f;image/vnd.net-fpx&#x7f;text/vnd.net2phone.commcenter.command&#x7f;application/vnd.netfpx&#x7f;application/vnd.neurolanguage.nlu&#x7f;application/vnd.nintendo.nitro.rom&#x7f;application/vnd.nintendo.snes.rom&#x7f;application/vnd.nitf&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.catalogs&#x7f;application/vnd.nokia.conml+wbxml&#x7f;application/vnd.nokia.conml+xml&#x7f;application/vnd.nokia.iSDS-radio-presets&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;application/vnd.nokia.iptv.config+xml&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;video/vnd.nokia.mp4vr&#x7f;application/vnd.nokia.n-gage.ac+xml&#x7f;application/vnd.nokia.n-gage.data&#x7f;application/vnd.nokia.ncd&#x7f;application/vnd.nokia.pcd+wbxml&#x7f;application/vnd.nokia.pcd+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;video/vnd.nokia.videovoip&#x7f;audio/vnd.nortel.vbk&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.ntt-local.content-share&#x7f;application/vnd.ntt-local.file-transfer&#x7f;application/vnd.ntt-local.ogw_remote-access&#x7f;application/vnd.ntt-local.sip-ta_remote&#x7f;application/vnd.ntt-local.sip-ta_tcp_stream&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;application/vnd.oasis.opendocument.chart&#x7f;application/vnd.oasis.opendocument.chart-template&#x7f;application/vnd.oasis.opendocument.database&#x7f;application/vnd.oasis.opendocument.formula&#x7f;application/vnd.oasis.opendocument.formula-template&#x7f;application/vnd.oasis.opendocument.graphics&#x7f;application/vnd.oasis.opendocument.graphics-template&#x7f;application/vnd.oasis.opendocument.image&#x7f;application/vnd.oasis.opendocument.image-template&#x7f;application/vnd.oasis.opendocument.presentation&#x7f;application/vnd.oasis.opendocument.presentation-template&#x7f;application/vnd.oasis.opendocument.spreadsheet&#x7f;application/vnd.oasis.opendocument.spreadsheet-template&#x7f;application/vnd.oasis.opendocument.text&#x7f;application/vnd.oasis.opendocument.text-master&#x7f;application/vnd.oasis.opendocument.text-template&#x7f;application/vnd.oasis.opendocument.text-web&#x7f;video/vnd.objectvideo&#x7f;application/vnd.obn&#x7f;application/vnd.ocf+cbor&#x7f;audio/vnd.octel.sbc&#x7f;application/vnd.oftn.l10n+json&#x7f;application/vnd.oipf.contentaccessdownload+xml&#x7f;application/vnd.oipf.contentaccessstreaming+xml&#x7f;application/vnd.oipf.cspg-hexbinary&#x7f;application/vnd.oipf.dae.svg+xml&#x7f;application/vnd.oipf.dae.xhtml+xml&#x7f;application/vnd.oipf.mippvcontrolmessage+xml&#x7f;application/vnd.oipf.pae.gem&#x7f;application/vnd.oipf.spdiscovery+xml&#x7f;application/vnd.oipf.spdlist+xml&#x7f;application/vnd.oipf.ueprofile+xml&#x7f;application/vnd.oipf.userprofile+xml&#x7f;application/vnd.olpc-sugar&#x7f;application/vnd.oma-scws-config&#x7f;application/vnd.oma-scws-http-request&#x7f;application/vnd.oma-scws-http-response&#x7f;application/vnd.oma.bcast.associated-procedure-parameter+xml&#x7f;application/vnd.oma.bcast.drm-trigger+xml&#x7f;application/vnd.oma.bcast.imd+xml&#x7f;application/vnd.oma.bcast.ltkm&#x7f;application/vnd.oma.bcast.notification+xml&#x7f;application/vnd.oma.bcast.provisioningtrigger&#x7f;application/vnd.oma.bcast.sgboot&#x7f;application/vnd.oma.bcast.sgdd+xml&#x7f;application/vnd.oma.bcast.sgdu&#x7f;application/vnd.oma.bcast.simple-symbol-container&#x7f;application/vnd.oma.bcast.smartcard-trigger+xml&#x7f;application/vnd.oma.bcast.sprov+xml&#x7f;application/vnd.oma.bcast.stkm&#x7f;application/vnd.oma.cab-address-book+xml&#x7f;application/vnd.oma.cab-feature-handler+xml&#x7f;application/vnd.oma.cab-pcc+xml&#x7f;application/vnd.oma.cab-subs-invite+xml&#x7f;application/vnd.oma.cab-user-prefs+xml&#x7f;application/vnd.oma.dcd&#x7f;application/vnd.oma.dcdc&#x7f;application/vnd.oma.dd2+xml&#x7f;application/vnd.oma.drm.risd+xml&#x7f;application/vnd.oma.group-usage-list+xml&#x7f;application/vnd.oma.lwm2m+json&#x7f;application/vnd.oma.lwm2m+tlv&#x7f;application/vnd.oma.pal+xml&#x7f;application/vnd.oma.poc.detailed-progress-report+xml&#x7f;application/vnd.oma.poc.final-report+xml&#x7f;application/vnd.oma.poc.groups+xml&#x7f;application/vnd.oma.poc.invocation-descriptor+xml&#x7f;application/vnd.oma.poc.optimized-progress-report+xml&#x7f;application/vnd.oma.push&#x7f;application/vnd.oma.scidm.messages+xml&#x7f;application/vnd.oma.xcap-directory+xml&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.omaloc-supl-init&#x7f;application/vnd.onepager&#x7f;application/vnd.onepagertamp&#x7f;application/vnd.onepagertamx&#x7f;application/vnd.onepagertat&#x7f;application/vnd.onepagertatp&#x7f;application/vnd.onepagertatx&#x7f;application/vnd.openblox.game+xml&#x7f;application/vnd.openblox.game-binary&#x7f;application/vnd.openeye.oeb&#x7f;model/vnd.opengex&#x7f;application/vnd.openstreetmap.data+xml&#x7f;application/vnd.openxmlformats-officedocument.custom-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.customXmlProperties+xml&#x7f;application/vnd.openxmlformats-officedocument.drawing+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chart+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml&#x7f;application/vnd.openxmlformats-officedocument.extended-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presProps+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tags+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml&#x7f;application/vnd.openxmlformats-officedocument.theme+xml&#x7f;application/vnd.openxmlformats-officedocument.themeOverride+xml&#x7f;application/vnd.openxmlformats-officedocument.vmlDrawing&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml&#x7f;application/vnd.openxmlformats-package.core-properties+xml&#x7f;application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml&#x7f;application/vnd.openxmlformats-package.relationships+xml&#x7f;application/vnd.oracle.resource+json&#x7f;application/vnd.orange.indata&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.osgeo.mapguide.package&#x7f;application/vnd.osgi.bundle&#x7f;application/vnd.osgi.dp&#x7f;application/vnd.osgi.subsystem&#x7f;application/vnd.otps.ct-kip+xml&#x7f;application/vnd.oxli.countgraph&#x7f;application/vnd.pagerduty+json&#x7f;application/vnd.palm&#x7f;application/vnd.panoply&#x7f;application/vnd.paos.xml&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;application/vnd.patentdive&#x7f;application/vnd.pawaafile&#x7f;application/vnd.pcos&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.piaccess.application-licence&#x7f;application/vnd.picsel&#x7f;application/vnd.pmi.widget&#x7f;application/vnd.poc.group-advertisement+xml&#x7f;application/vnd.pocketlearn&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.preminet&#x7f;audio/vnd.presonus.multitrack&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.proteus.magazine&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.qualcomm.brew-app-res&#x7f;application/vnd.quarantainenet&#x7f;application/vnd.quobject-quoxdocument&#x7f;video/vnd.radgamettools.bink&#x7f;video/vnd.radgamettools.smacker&#x7f;image/vnd.radiance&#x7f;application/vnd.radisys.moml+xml&#x7f;application/vnd.radisys.msml+xml&#x7f;application/vnd.radisys.msml-audit+xml&#x7f;application/vnd.radisys.msml-audit-conf+xml&#x7f;application/vnd.radisys.msml-audit-conn+xml&#x7f;application/vnd.radisys.msml-audit-dialog+xml&#x7f;application/vnd.radisys.msml-audit-stream+xml&#x7f;text/vnd.radisys.msml-basic-layout&#x7f;application/vnd.radisys.msml-conf+xml&#x7f;application/vnd.radisys.msml-dialog+xml&#x7f;application/vnd.radisys.msml-dialog-base+xml&#x7f;application/vnd.radisys.msml-dialog-fax-detect+xml&#x7f;application/vnd.radisys.msml-dialog-fax-sendrecv+xml&#x7f;application/vnd.radisys.msml-dialog-group+xml&#x7f;application/vnd.radisys.msml-dialog-speech+xml&#x7f;application/vnd.radisys.msml-dialog-transform+xml&#x7f;application/vnd.rainstor.data&#x7f;application/vnd.rapid&#x7f;application/vnd.rar&#x7f;application/vnd.realvnc.bed&#x7f;application/vnd.recordare.musicxml&#x7f;application/vnd.recordare.musicxml+xml&#x7f;application/vnd.restful+json&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;application/vnd.rig.cryptonote&#x7f;audio/vnd.rip&#x7f;model/vnd.rosette.annotated-data-model&#x7f;application/vnd.route66.link66+xml&#x7f;application/vnd.rs-274x&#x7f;application/vnd.ruckus.download&#x7f;application/vnd.s3sms&#x7f;application/vnd.sailingtracker.track&#x7f;application/vnd.sbm.cid&#x7f;application/vnd.sbm.mid2&#x7f;application/vnd.scribus&#x7f;application/vnd.sealed.3df&#x7f;application/vnd.sealed.csf&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;application/vnd.sealed.net&#x7f;image/vnd.sealed.png&#x7f;application/vnd.sealed.ppt&#x7f;video/vnd.sealed.swf&#x7f;application/vnd.sealed.tiff&#x7f;application/vnd.sealed.xls&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.sema&#x7f;application/vnd.semd&#x7f;application/vnd.semf&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.sigrok.session&#x7f;application/vnd.siren+json&#x7f;application/vnd.smaf&#x7f;application/vnd.smart.notebook&#x7f;application/vnd.smart.teacher&#x7f;application/vnd.software602.filler.form+xml&#x7f;application/vnd.software602.filler.form-xml-zip&#x7f;application/vnd.solent.sdkm+xml&#x7f;application/vnd.spotfire.dxp&#x7f;application/vnd.spotfire.sfs&#x7f;application/vnd.sqlite3&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.stepmania.package&#x7f;application/vnd.stepmania.stepchart&#x7f;application/vnd.street-stream&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;application/vnd.sun.wadl+xml&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;image/vnd.svf&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml+xml&#x7f;application/vnd.syncml.dm+wbxml&#x7f;application/vnd.syncml.dm+xml&#x7f;application/vnd.syncml.dm.notification&#x7f;application/vnd.syncml.dmddf+wbxml&#x7f;application/vnd.syncml.dmddf+xml&#x7f;application/vnd.syncml.dmtnds+wbxml&#x7f;application/vnd.syncml.dmtnds+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.tableschema+json&#x7f;application/vnd.tao.intent-module-archive&#x7f;application/vnd.tcpdump.pcap&#x7f;image/vnd.tencent.tap&#x7f;application/vnd.tmd.mediaflex.api+xml&#x7f;application/vnd.tml&#x7f;application/vnd.tmobile-livetv&#x7f;application/vnd.tri.onesource&#x7f;application/vnd.trid.tpt&#x7f;application/vnd.triscape.mxs&#x7f;text/vnd.trolltech.linguist&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ubisoft.webplayer&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.umajin&#x7f;application/vnd.unity&#x7f;application/vnd.uoml+xml&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.uri-map&#x7f;video/vnd.uvvu.mp4&#x7f;model/vnd.valve.source.compiled-map&#x7f;application/vnd.valve.source.material&#x7f;image/vnd.valve.source.texture&#x7f;application/vnd.vcx&#x7f;application/vnd.vd-study&#x7f;application/vnd.vectorworks&#x7f;application/vnd.vel+json&#x7f;application/vnd.verimatrix.vcas&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;video/vnd.vivo&#x7f;audio/vnd.vmx.cvsd&#x7f;application/vnd.vsf&#x7f;model/vnd.vtu&#x7f;text/vnd.wap.si&#x7f;application/vnd.wap.sic&#x7f;text/vnd.wap.sl&#x7f;application/vnd.wap.slc&#x7f;image/vnd.wap.wbmp&#x7f;application/vnd.wap.wbxml&#x7f;text/vnd.wap.wml&#x7f;application/vnd.wap.wmlc&#x7f;text/vnd.wap.wmlscript&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wfa.p2p&#x7f;application/vnd.wfa.wsc&#x7f;message/vnd.wfa.wsc&#x7f;application/vnd.windows.devicepairing&#x7f;application/vnd.wmc&#x7f;application/vnd.wmf.bootstrap&#x7f;application/vnd.wolfram.mathematica&#x7f;application/vnd.wolfram.mathematica.package&#x7f;application/vnd.wolfram.player&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xacml+json&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.xfdl.webform&#x7f;image/vnd.xiff&#x7f;application/vnd.xmi+xml&#x7f;application/vnd.xmpie.cpkg&#x7f;application/vnd.xmpie.dpkg&#x7f;application/vnd.xmpie.plan&#x7f;application/vnd.xmpie.ppkg&#x7f;application/vnd.xmpie.xlim&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.openscoreformat&#x7f;application/vnd.yamaha.openscoreformat.osfpvg+xml&#x7f;application/vnd.yamaha.remote-setup&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yamaha.through-ngn&#x7f;application/vnd.yamaha.tunnel-udpencap&#x7f;application/vnd.yaoweme&#x7f;application/vnd.yellowriver-custom-menu&#x7f;application/vnd.youtube.yt&#x7f;image/vnd.zbrush.pcx&#x7f;application/vnd.zul&#x7f;application/vnd.zzazz.deck+xml&#x7f;multipart/voice-message&#x7f;application/voicexml+xml&#x7f;audio/vorbis&#x7f;audio/vorbis-config&#x7f;application/voucher-cms+json&#x7f;application/vq-rtcpxr&#x7f;model/vrml&#x7f;application/watcherinfo+xml&#x7f;application/webpush-options+json&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/widget&#x7f;application/wita&#x7f;image/wmf&#x7f;font/woff&#x7f;font/woff2&#x7f;application/wordperfect5.1&#x7f;application/wsdl+xml&#x7f;application/wspolicy+xml&#x7f;multipart/x-mixed-replace&#x7f;application/x-www-form-urlencoded&#x7f;model/x3d+fastinfoset&#x7f;model/x3d+xml&#x7f;model/x3d-vrml&#x7f;application/x400-bp&#x7f;application/xacml+xml&#x7f;application/xcap-att+xml&#x7f;application/xcap-caps+xml&#x7f;application/xcap-diff+xml&#x7f;application/xcap-el+xml&#x7f;application/xcap-error+xml&#x7f;application/xcap-ns+xml&#x7f;application/xcon-conference-info+xml&#x7f;application/xcon-conference-info-diff+xml&#x7f;application/xenc+xml&#x7f;application/xhtml+xml&#x7f;application/xml&#x7f;text/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;text/xml-external-parsed-entity&#x7f;application/xml-patch+xml&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/xslt+xml&#x7f;application/xv+xml&#x7f;application/yang&#x7f;application/yang-data+json&#x7f;application/yang-data+xml&#x7f;application/yang-patch+json&#x7f;application/yang-patch+xml&#x7f;application/yin+xml&#x7f;application/zip&#x7f;application/zlib&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( contains('&#x7f;application/1d-interleaved-parityfec&#x7f;audio/1d-interleaved-parityfec&#x7f;text/1d-interleaved-parityfec&#x7f;video/1d-interleaved-parityfec&#x7f;audio/32kadpcm&#x7f;application/3gpdash-qoe-report+xml&#x7f;audio/3gpp&#x7f;video/3gpp&#x7f;application/3gpp-ims+xml&#x7f;video/3gpp-tt&#x7f;audio/3gpp2&#x7f;video/3gpp2&#x7f;model/3mf&#x7f;application/A2L&#x7f;application/AML&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;application/ATF&#x7f;application/ATFX&#x7f;audio/ATRAC-ADVANCED-LOSSLESS&#x7f;audio/ATRAC-X&#x7f;audio/ATRAC3&#x7f;application/ATXML&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;application/CALS-1840&#x7f;application/CDFX+XML&#x7f;application/CEA&#x7f;audio/CN&#x7f;message/CPIM&#x7f;application/CSTAdata+xml&#x7f;video/CelB&#x7f;audio/DAT12&#x7f;application/DCD&#x7f;application/DII&#x7f;application/DIT&#x7f;audio/DV&#x7f;video/DV&#x7f;audio/DVI4&#x7f;application/EDI-X12&#x7f;application/EDI-consent&#x7f;application/EDIFACT&#x7f;audio/EVRC&#x7f;audio/EVRC-QCP&#x7f;audio/EVRC0&#x7f;audio/EVRC1&#x7f;audio/EVRCB&#x7f;audio/EVRCB0&#x7f;audio/EVRCB1&#x7f;audio/EVRCNW&#x7f;audio/EVRCNW0&#x7f;audio/EVRCNW1&#x7f;audio/EVRCWB&#x7f;audio/EVRCWB0&#x7f;audio/EVRCWB1&#x7f;audio/EVS&#x7f;application/EmergencyCallData.Comment+xml&#x7f;application/EmergencyCallData.Control+xml&#x7f;application/EmergencyCallData.DeviceInfo+xml&#x7f;application/EmergencyCallData.ProviderInfo+xml&#x7f;application/EmergencyCallData.ServiceInfo+xml&#x7f;application/EmergencyCallData.SubscriberInfo+xml&#x7f;application/EmergencyCallData.VEDS+xml&#x7f;application/EmergencyCallData.eCall.MSD&#x7f;audio/G711-0&#x7f;audio/G719&#x7f;audio/G722&#x7f;audio/G7221&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G7291&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/GSM-HR-08&#x7f;application/H224&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/H264-RCDO&#x7f;video/H264-SVC&#x7f;video/H265&#x7f;application/IOTP&#x7f;application/ISUP&#x7f;video/JPEG&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/L8&#x7f;audio/LPC&#x7f;application/LXF&#x7f;audio/MELP&#x7f;audio/MELP1200&#x7f;audio/MELP2400&#x7f;audio/MELP600&#x7f;application/MF4&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;audio/MP4A-LATM&#x7f;video/MP4V-ES&#x7f;audio/MPA&#x7f;video/MPV&#x7f;application/ODA&#x7f;application/ODX&#x7f;audio/PCMA&#x7f;audio/PCMA-WB&#x7f;audio/PCMU&#x7f;audio/PCMU-WB&#x7f;application/PDX&#x7f;audio/QCELP&#x7f;application/QSIG&#x7f;audio/RED&#x7f;text/RED&#x7f;application/SGML&#x7f;text/SGML&#x7f;video/SMPTE292M&#x7f;audio/SMV&#x7f;audio/SMV-QCP&#x7f;audio/SMV0&#x7f;audio/TETRA_ACELP&#x7f;audio/TETRA_ACELP_BB&#x7f;application/TETRA_ISI&#x7f;audio/UEMCLIP&#x7f;audio/VDVI&#x7f;audio/VMR-WB&#x7f;video/VP8&#x7f;audio/aac&#x7f;audio/ac3&#x7f;image/aces&#x7f;application/activemessage&#x7f;application/activity+json&#x7f;multipart/alternative&#x7f;application/alto-costmap+json&#x7f;application/alto-costmapfilter+json&#x7f;application/alto-directory+json&#x7f;application/alto-endpointcost+json&#x7f;application/alto-endpointcostparams+json&#x7f;application/alto-endpointprop+json&#x7f;application/alto-endpointpropparams+json&#x7f;application/alto-error+json&#x7f;application/alto-networkmap+json&#x7f;application/alto-networkmapfilter+json&#x7f;application/alto-updatestreamcontrol+json&#x7f;application/alto-updatestreamparams+json&#x7f;audio/amr-wb+&#x7f;application/andrew-inset&#x7f;multipart/appledouble&#x7f;application/applefile&#x7f;audio/aptx&#x7f;audio/asc&#x7f;application/atom+xml&#x7f;application/atomcat+xml&#x7f;application/atomdeleted+xml&#x7f;application/atomicmail&#x7f;application/atomsvc+xml&#x7f;application/atsc-dwd+xml&#x7f;application/atsc-dynamic-event-message&#x7f;application/atsc-held+xml&#x7f;application/atsc-rdt+json&#x7f;application/atsc-rsat+xml&#x7f;application/auth-policy+xml&#x7f;image/avci&#x7f;image/avcs&#x7f;application/bacnet-xdd+zip&#x7f;audio/basic&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;image/bmp&#x7f;multipart/byteranges&#x7f;text/cache-manifest&#x7f;text/calendar&#x7f;application/calendar+json&#x7f;application/calendar+xml&#x7f;application/call-completion&#x7f;application/cap+xml&#x7f;application/cbor&#x7f;application/cbor-seq&#x7f;application/cccex&#x7f;application/ccmp+xml&#x7f;application/ccxml+xml&#x7f;application/cdmi-capability&#x7f;application/cdmi-container&#x7f;application/cdmi-domain&#x7f;application/cdmi-object&#x7f;application/cdmi-queue&#x7f;application/cdni&#x7f;application/cea-2018+xml&#x7f;application/cellml+xml&#x7f;application/cfw&#x7f;image/cgm&#x7f;audio/clearmode&#x7f;application/clue+xml&#x7f;application/clue_info+xml&#x7f;application/cms&#x7f;application/cnrp+xml&#x7f;application/coap-group+json&#x7f;application/coap-payload&#x7f;font/collection&#x7f;application/commonground&#x7f;application/conference-info+xml&#x7f;application/cose&#x7f;application/cose-key&#x7f;application/cose-key-set&#x7f;application/cpl+xml&#x7f;application/csrattrs&#x7f;text/css&#x7f;application/csta+xml&#x7f;text/csv&#x7f;text/csv-schema&#x7f;application/csvm+json&#x7f;application/cwt&#x7f;application/cybercash&#x7f;application/dash+xml&#x7f;application/dashdelta&#x7f;application/davmount+xml&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;message/delivery-status&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dicom+json&#x7f;application/dicom+xml&#x7f;image/dicom-rle&#x7f;multipart/digest&#x7f;message/disposition-notification&#x7f;audio/dls&#x7f;application/dns&#x7f;text/dns&#x7f;application/dns+json&#x7f;application/dns-message&#x7f;application/dots+cbor&#x7f;application/dskpp+xml&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;application/dssc+der&#x7f;application/dssc+xml&#x7f;application/dvcs&#x7f;audio/eac3&#x7f;application/ecmascript&#x7f;application/efi&#x7f;image/emf&#x7f;application/emma+xml&#x7f;application/emotionml+xml&#x7f;application/encaprtp&#x7f;audio/encaprtp&#x7f;text/encaprtp&#x7f;video/encaprtp&#x7f;multipart/encrypted&#x7f;text/enriched&#x7f;application/epp+xml&#x7f;application/epub+zip&#x7f;application/eshop&#x7f;application/example&#x7f;audio/example&#x7f;image/example&#x7f;message/example&#x7f;model/example&#x7f;multipart/example&#x7f;text/example&#x7f;video/example&#x7f;application/exi&#x7f;application/expect-ct-report+json&#x7f;message/external-body&#x7f;application/fastinfoset&#x7f;application/fastsoap&#x7f;application/fdt+xml&#x7f;message/feedback-report&#x7f;application/fhir+json&#x7f;application/fhir+xml&#x7f;application/fits&#x7f;image/fits&#x7f;application/flexfec&#x7f;audio/flexfec&#x7f;text/flexfec&#x7f;video/flexfec&#x7f;application/font-tdpfr&#x7f;multipart/form-data&#x7f;application/framework-attributes+xml&#x7f;audio/fwdred&#x7f;text/fwdred&#x7f;image/g3fax&#x7f;application/geo+json&#x7f;application/geo+json-seq&#x7f;application/geopackage+sqlite3&#x7f;application/geoxacml+xml&#x7f;image/gif&#x7f;message/global&#x7f;message/global-delivery-status&#x7f;message/global-disposition-notification&#x7f;message/global-headers&#x7f;model/gltf+json&#x7f;model/gltf-binary&#x7f;application/gltf-buffer&#x7f;application/gml+xml&#x7f;text/grammar-ref-list&#x7f;application/gzip&#x7f;multipart/header-set&#x7f;image/heic&#x7f;image/heic-sequence&#x7f;image/heif&#x7f;image/heif-sequence&#x7f;image/hej2k&#x7f;application/held+xml&#x7f;image/hsj2&#x7f;text/html&#x7f;application/http&#x7f;message/http&#x7f;application/hyperstudio&#x7f;audio/iLBC&#x7f;application/ibe-key-request+xml&#x7f;application/ibe-pkg-reply+xml&#x7f;application/ibe-pp-data&#x7f;image/ief&#x7f;application/iges&#x7f;model/iges&#x7f;application/im-iscomposing+xml&#x7f;message/imdn+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/inkml+xml&#x7f;audio/ip-mr_v2.5&#x7f;application/ipfix&#x7f;application/ipp&#x7f;video/iso.segment&#x7f;application/its+xml&#x7f;application/javascript&#x7f;text/jcr-cnd&#x7f;application/jf2feed+json&#x7f;image/jls&#x7f;application/jose&#x7f;application/jose+json&#x7f;image/jp2&#x7f;image/jpeg&#x7f;video/jpeg2000&#x7f;image/jph&#x7f;image/jphc&#x7f;image/jpm&#x7f;image/jpx&#x7f;application/jrd+json&#x7f;application/json&#x7f;application/json-patch+json&#x7f;application/json-seq&#x7f;application/jwk+json&#x7f;application/jwk-set+json&#x7f;application/jwt&#x7f;image/jxr&#x7f;image/jxrA&#x7f;image/jxrS&#x7f;image/jxs&#x7f;image/jxsc&#x7f;image/jxsi&#x7f;image/jxss&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;image/ktx&#x7f;application/ld+json&#x7f;application/lgr+xml&#x7f;application/link-format&#x7f;application/load-control+xml&#x7f;application/lost+xml&#x7f;application/lostsync+xml&#x7f;application/lpf+zip&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/mads+xml&#x7f;application/marc&#x7f;application/marcxml+xml&#x7f;text/markdown&#x7f;application/mathematica&#x7f;application/mathml+xml&#x7f;application/mathml-content+xml&#x7f;application/mathml-presentation+xml&#x7f;application/mbms-associated-procedure-description+xml&#x7f;application/mbms-deregister+xml&#x7f;application/mbms-envelope+xml&#x7f;application/mbms-msk+xml&#x7f;application/mbms-msk-response+xml&#x7f;application/mbms-protection-description+xml&#x7f;application/mbms-reception-report+xml&#x7f;application/mbms-register+xml&#x7f;application/mbms-register-response+xml&#x7f;application/mbms-schedule+xml&#x7f;application/mbms-user-service-description+xml&#x7f;application/mbox&#x7f;application/media-policy-dataset+xml&#x7f;application/media_control+xml&#x7f;application/mediaservercontrol+xml&#x7f;application/merge-patch+json&#x7f;model/mesh&#x7f;application/metalink4+xml&#x7f;application/mets+xml&#x7f;audio/mhas&#x7f;application/mikey&#x7f;application/mipc&#x7f;multipart/mixed&#x7f;text/mizar&#x7f;video/mj2&#x7f;application/mmt-aei+xml&#x7f;application/mmt-usd+xml&#x7f;audio/mobile-xmf&#x7f;application/mods+xml&#x7f;application/moss-keys&#x7f;application/moss-signature&#x7f;application/mosskey-data&#x7f;application/mosskey-request&#x7f;application/mp21&#x7f;application/mp4&#x7f;audio/mp4&#x7f;video/mp4&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;video/mpeg&#x7f;application/mpeg4-generic&#x7f;audio/mpeg4-generic&#x7f;video/mpeg4-generic&#x7f;application/mpeg4-iod&#x7f;application/mpeg4-iod-xmt&#x7f;application/mrb-consumer+xml&#x7f;application/mrb-publish+xml&#x7f;application/msc-ivr+xml&#x7f;application/msc-mixer+xml&#x7f;application/msword&#x7f;model/mtl&#x7f;application/mud+json&#x7f;multipart/multilingual&#x7f;application/multipart-core&#x7f;application/mxf&#x7f;application/n-quads&#x7f;application/n-triples&#x7f;text/n3&#x7f;image/naplps&#x7f;application/nasdata&#x7f;application/news-checkgroups&#x7f;application/news-groupinfo&#x7f;application/news-transmission&#x7f;application/nlsml+xml&#x7f;application/node&#x7f;application/nss&#x7f;video/nv&#x7f;model/obj&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/odm+xml&#x7f;application/oebps-package+xml&#x7f;application/ogg&#x7f;audio/ogg&#x7f;video/ogg&#x7f;audio/opus&#x7f;application/oscore&#x7f;font/otf&#x7f;application/oxps&#x7f;application/p2p-overlay+xml&#x7f;multipart/parallel&#x7f;text/parameters&#x7f;application/parityfec&#x7f;audio/parityfec&#x7f;text/parityfec&#x7f;video/parityfec&#x7f;message/partial&#x7f;application/passport&#x7f;application/patch-ops-error+xml&#x7f;application/pdf&#x7f;application/pem-certificate-chain&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pidf-diff+xml&#x7f;application/pkcs10&#x7f;application/pkcs12&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkcs8&#x7f;application/pkcs8-encrypted&#x7f;application/pkix-attr-cert&#x7f;application/pkix-cert&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pkixcmp&#x7f;text/plain&#x7f;application/pls+xml&#x7f;image/png&#x7f;application/poc-settings+xml&#x7f;video/pointer&#x7f;application/postscript&#x7f;application/ppsp-tracker+json&#x7f;application/problem+json&#x7f;application/problem+xml&#x7f;application/provenance+xml&#x7f;text/provenance-notation&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;image/prs.btif&#x7f;application/prs.cww&#x7f;text/prs.fallenstein.rst&#x7f;application/prs.hpub+zip&#x7f;text/prs.lines.tag&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;text/prs.prop.logic&#x7f;image/prs.pti&#x7f;application/prs.rdf-xml-crypt&#x7f;audio/prs.sid&#x7f;application/prs.xsf+xml&#x7f;application/pskc+xml&#x7f;application/pvd+json&#x7f;image/pwg-raster&#x7f;video/quicktime&#x7f;application/raptorfec&#x7f;audio/raptorfec&#x7f;text/raptorfec&#x7f;video/raptorfec&#x7f;video/raw&#x7f;application/rdap+json&#x7f;application/rdf+xml&#x7f;application/reginfo+xml&#x7f;multipart/related&#x7f;application/relax-ng-compact-syntax&#x7f;application/remote-printing&#x7f;multipart/report&#x7f;application/reputon+json&#x7f;application/resource-lists+xml&#x7f;application/resource-lists-diff+xml&#x7f;application/rfc+xml&#x7f;message/rfc822&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;application/riscos&#x7f;application/rlmi+xml&#x7f;application/rls-services+xml&#x7f;application/route-apd+xml&#x7f;application/route-s-tsid+xml&#x7f;application/route-usd+xml&#x7f;application/rpki-ghostbusters&#x7f;application/rpki-manifest&#x7f;application/rpki-publication&#x7f;application/rpki-roa&#x7f;application/rpki-updown&#x7f;application/rtf&#x7f;text/rtf&#x7f;audio/rtp-enc-aescm128&#x7f;text/rtp-enc-aescm128&#x7f;video/rtp-enc-aescm128&#x7f;audio/rtp-midi&#x7f;application/rtploopback&#x7f;audio/rtploopback&#x7f;text/rtploopback&#x7f;video/rtploopback&#x7f;application/rtx&#x7f;audio/rtx&#x7f;text/rtx&#x7f;video/rtx&#x7f;message/s-http&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbe&#x7f;application/sbml+xml&#x7f;application/scaip+xml&#x7f;application/scim+json&#x7f;application/scvp-cv-request&#x7f;application/scvp-cv-response&#x7f;application/scvp-vp-request&#x7f;application/scvp-vp-response&#x7f;application/sdp&#x7f;application/secevent+jwt&#x7f;application/senml+cbor&#x7f;application/senml+json&#x7f;application/senml+xml&#x7f;application/senml-etch+cbor&#x7f;application/senml-etch+json&#x7f;application/senml-exi&#x7f;application/sensml+cbor&#x7f;application/sensml+json&#x7f;application/sensml+xml&#x7f;application/sensml-exi&#x7f;application/sep+xml&#x7f;application/sep-exi&#x7f;application/session-info&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;font/sfnt&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;multipart/signed&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/simpleSymbolContainer&#x7f;message/sip&#x7f;application/sipc&#x7f;message/sipfrag&#x7f;application/slate&#x7f;application/smil+xml&#x7f;video/smpte291&#x7f;application/smpte336m&#x7f;application/soap+fastinfoset&#x7f;application/soap+xml&#x7f;audio/sp-midi&#x7f;application/sparql-query&#x7f;application/sparql-results+xml&#x7f;audio/speex&#x7f;application/spirits-event+xml&#x7f;application/sql&#x7f;application/srgs&#x7f;application/srgs+xml&#x7f;application/sru+xml&#x7f;application/ssml+xml&#x7f;application/stix+json&#x7f;model/stl&#x7f;text/strings&#x7f;image/svg+xml&#x7f;application/swid+xml&#x7f;text/t140&#x7f;audio/t140c&#x7f;audio/t38&#x7f;image/t38&#x7f;text/tab-separated-values&#x7f;application/tamp-apex-update&#x7f;application/tamp-apex-update-confirm&#x7f;application/tamp-community-update&#x7f;application/tamp-community-update-confirm&#x7f;application/tamp-error&#x7f;application/tamp-sequence-adjust&#x7f;application/tamp-sequence-adjust-confirm&#x7f;application/tamp-status-query&#x7f;application/tamp-status-response&#x7f;application/tamp-update&#x7f;application/tamp-update-confirm&#x7f;application/taxii+json&#x7f;application/td+json&#x7f;application/tei+xml&#x7f;audio/telephone-event&#x7f;application/thraud+xml&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/timestamped-data&#x7f;application/tlsrpt+gzip&#x7f;application/tlsrpt+json&#x7f;application/tnauthlist&#x7f;audio/tone&#x7f;message/tracking-status&#x7f;application/trickle-ice-sdpfrag&#x7f;application/trig&#x7f;text/troff&#x7f;font/ttf&#x7f;application/ttml+xml&#x7f;text/turtle&#x7f;application/tve-trigger&#x7f;application/tzif&#x7f;application/tzif-leap&#x7f;application/ulpfec&#x7f;audio/ulpfec&#x7f;text/ulpfec&#x7f;video/ulpfec&#x7f;application/urc-grpsheet+xml&#x7f;application/urc-ressheet+xml&#x7f;application/urc-targetdesc+xml&#x7f;application/urc-uisocketdesc+xml&#x7f;text/uri-list&#x7f;audio/usac&#x7f;video/vc1&#x7f;video/vc2&#x7f;text/vcard&#x7f;application/vcard+json&#x7f;application/vcard+xml&#x7f;application/vemmi&#x7f;application/vnd.1000minds.decision-model+xml&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.3gpp-prose+xml&#x7f;application/vnd.3gpp-prose-pc3ch+xml&#x7f;application/vnd.3gpp-v2x-local-service-information&#x7f;application/vnd.3gpp.GMOP+xml&#x7f;application/vnd.3gpp.SRVCC-info+xml&#x7f;application/vnd.3gpp.access-transfer-events+xml&#x7f;application/vnd.3gpp.bsf+xml&#x7f;audio/vnd.3gpp.iufp&#x7f;application/vnd.3gpp.mc-signalling-ear&#x7f;application/vnd.3gpp.mcdata-affiliation-command+xml&#x7f;application/vnd.3gpp.mcdata-info+xml&#x7f;application/vnd.3gpp.mcdata-payload&#x7f;application/vnd.3gpp.mcdata-service-config+xml&#x7f;application/vnd.3gpp.mcdata-signalling&#x7f;application/vnd.3gpp.mcdata-ue-config+xml&#x7f;application/vnd.3gpp.mcdata-user-profile+xml&#x7f;application/vnd.3gpp.mcptt-affiliation-command+xml&#x7f;application/vnd.3gpp.mcptt-floor-request+xml&#x7f;application/vnd.3gpp.mcptt-info+xml&#x7f;application/vnd.3gpp.mcptt-location-info+xml&#x7f;application/vnd.3gpp.mcptt-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcptt-service-config+xml&#x7f;application/vnd.3gpp.mcptt-signed+xml&#x7f;application/vnd.3gpp.mcptt-ue-config+xml&#x7f;application/vnd.3gpp.mcptt-ue-init-config+xml&#x7f;application/vnd.3gpp.mcptt-user-profile+xml&#x7f;application/vnd.3gpp.mcvideo-affiliation-command+xml&#x7f;application/vnd.3gpp.mcvideo-info+xml&#x7f;application/vnd.3gpp.mcvideo-location-info+xml&#x7f;application/vnd.3gpp.mcvideo-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcvideo-service-config+xml&#x7f;application/vnd.3gpp.mcvideo-transmission-request+xml&#x7f;application/vnd.3gpp.mcvideo-ue-config+xml&#x7f;application/vnd.3gpp.mcvideo-user-profile+xml&#x7f;application/vnd.3gpp.mid-call+xml&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.3gpp.sms+xml&#x7f;application/vnd.3gpp.srvcc-ext+xml&#x7f;application/vnd.3gpp.state-and-event-info+xml&#x7f;application/vnd.3gpp.ussd+xml&#x7f;application/vnd.3gpp2.bcmcsinfo+xml&#x7f;application/vnd.3gpp2.sms&#x7f;application/vnd.3gpp2.tcap&#x7f;application/vnd.3lightssoftware.imagescal&#x7f;audio/vnd.4SB&#x7f;video/vnd.CCTV&#x7f;audio/vnd.CELP&#x7f;text/vnd.DMClientScript&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.HandHeld-Entertainment+xml&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.IPTC.NewsML&#x7f;application/vnd.Kinar&#x7f;application/vnd.MFER&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.SimTech-MindMapper&#x7f;text/vnd.a&#x7f;text/vnd.abc&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.flash.movie&#x7f;application/vnd.adobe.formscentral.fcdt&#x7f;application/vnd.adobe.fxp&#x7f;application/vnd.adobe.partial-upload&#x7f;image/vnd.adobe.photoshop&#x7f;application/vnd.adobe.xdp+xml&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.afpc.afplinedata&#x7f;application/vnd.afpc.afplinedata-pagedef&#x7f;application/vnd.afpc.foca-charset&#x7f;application/vnd.afpc.foca-codedfont&#x7f;application/vnd.afpc.foca-codepage&#x7f;application/vnd.afpc.modca&#x7f;application/vnd.afpc.modca-formdef&#x7f;application/vnd.afpc.modca-mediummap&#x7f;application/vnd.afpc.modca-objectcontainer&#x7f;application/vnd.afpc.modca-overlay&#x7f;application/vnd.afpc.modca-pagesegment&#x7f;application/vnd.ah-barcode&#x7f;application/vnd.ahead.space&#x7f;image/vnd.airzip.accelerator.azv&#x7f;application/vnd.airzip.filesecure.azf&#x7f;application/vnd.airzip.filesecure.azs&#x7f;application/vnd.amadeus+json&#x7f;application/vnd.amazon.mobi8-ebook&#x7f;application/vnd.americandynamics.acc&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.amundsen.maze+xml&#x7f;application/vnd.android.ota&#x7f;application/vnd.anki&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.antix.game-component&#x7f;application/vnd.apache.thrift.binary&#x7f;application/vnd.apache.thrift.compact&#x7f;application/vnd.apache.thrift.json&#x7f;application/vnd.api+json&#x7f;application/vnd.aplextor.warrp+json&#x7f;application/vnd.apothekende.reservation+json&#x7f;application/vnd.apple.installer+xml&#x7f;application/vnd.apple.keynote&#x7f;application/vnd.apple.mpegurl&#x7f;application/vnd.apple.numbers&#x7f;application/vnd.apple.pages&#x7f;application/vnd.aristanetworks.swi&#x7f;application/vnd.artisan+json&#x7f;application/vnd.artsquare&#x7f;text/vnd.ascii-art&#x7f;application/vnd.astraea-software.iota&#x7f;application/vnd.audiograph&#x7f;audio/vnd.audiokoz&#x7f;application/vnd.autopackage&#x7f;application/vnd.avalon+json&#x7f;application/vnd.avistar+xml&#x7f;application/vnd.balsamiq.bmml+xml&#x7f;application/vnd.balsamiq.bmpr&#x7f;application/vnd.banana-accounting&#x7f;application/vnd.bbf.usp.error&#x7f;application/vnd.bbf.usp.msg&#x7f;application/vnd.bbf.usp.msg+json&#x7f;application/vnd.bekitzur-stech+json&#x7f;application/vnd.bint.med-content&#x7f;multipart/vnd.bint.med-plus&#x7f;application/vnd.biopax.rdf+xml&#x7f;application/vnd.blink-idb-value-wrapper&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bluetooth.ep.oob&#x7f;application/vnd.bluetooth.le.oob&#x7f;application/vnd.bmi&#x7f;application/vnd.bpf&#x7f;application/vnd.bpf3&#x7f;application/vnd.businessobjects&#x7f;application/vnd.byu.uapi+json&#x7f;application/vnd.cab-jscript&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.capasystems-pg+json&#x7f;application/vnd.cendio.thinlinc.clientconf&#x7f;application/vnd.century-systems.tcp_stream&#x7f;application/vnd.chemdraw+xml&#x7f;application/vnd.chess-pgn&#x7f;application/vnd.chipnuts.karaoke-mmd&#x7f;application/vnd.ciedi&#x7f;application/vnd.cinderella&#x7f;application/vnd.cirpack.isdn-ext&#x7f;audio/vnd.cisco.nse&#x7f;application/vnd.citationstyles.style+xml&#x7f;application/vnd.claymore&#x7f;application/vnd.cloanto.rp9&#x7f;application/vnd.clonk.c4group&#x7f;application/vnd.cluetrust.cartomobile-config&#x7f;application/vnd.cluetrust.cartomobile-config-pkg&#x7f;audio/vnd.cmles.radio-events&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;image/vnd.cns.inf2&#x7f;application/vnd.coffeescript&#x7f;application/vnd.collabio.xodocuments.document&#x7f;application/vnd.collabio.xodocuments.document-template&#x7f;application/vnd.collabio.xodocuments.presentation&#x7f;application/vnd.collabio.xodocuments.presentation-template&#x7f;application/vnd.collabio.xodocuments.spreadsheet&#x7f;application/vnd.collabio.xodocuments.spreadsheet-template&#x7f;model/vnd.collada+xml&#x7f;application/vnd.collection+json&#x7f;application/vnd.collection.doc+json&#x7f;application/vnd.collection.next+json&#x7f;application/vnd.comicbook+zip&#x7f;application/vnd.comicbook-rar&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.coreos.ignition+json&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.crick.clicker&#x7f;application/vnd.crick.clicker.keyboard&#x7f;application/vnd.crick.clicker.palette&#x7f;application/vnd.crick.clicker.template&#x7f;application/vnd.crick.clicker.wordbank&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.cryptii.pipe+json&#x7f;application/vnd.crypto-shade-file&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.ctct.ws+xml&#x7f;application/vnd.cups-pdf&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-ppd&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;text/vnd.curl&#x7f;application/vnd.cyan.dean.root+xml&#x7f;application/vnd.cybank&#x7f;application/vnd.d2l.coursepackage1p0+zip&#x7f;application/vnd.dart&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.datapackage+json&#x7f;application/vnd.dataresource+json&#x7f;application/vnd.dbf&#x7f;application/vnd.debian.binary-package&#x7f;text/vnd.debian.copyright&#x7f;audio/vnd.dece.audio&#x7f;application/vnd.dece.data&#x7f;image/vnd.dece.graphic&#x7f;video/vnd.dece.hd&#x7f;video/vnd.dece.mobile&#x7f;video/vnd.dece.mp4&#x7f;video/vnd.dece.pd&#x7f;video/vnd.dece.sd&#x7f;application/vnd.dece.ttml+xml&#x7f;application/vnd.dece.unspecified&#x7f;video/vnd.dece.video&#x7f;application/vnd.dece.zip&#x7f;application/vnd.denovo.fcselayout-link&#x7f;application/vnd.desmume.movie&#x7f;audio/vnd.digital-winds&#x7f;application/vnd.dir-bi.plate-dl-nosuffix&#x7f;video/vnd.directv.mpeg&#x7f;video/vnd.directv.mpeg-tts&#x7f;image/vnd.djvu&#x7f;audio/vnd.dlna.adts&#x7f;video/vnd.dlna.mpeg-tts&#x7f;application/vnd.dm.delegation+xml&#x7f;application/vnd.dna&#x7f;application/vnd.document+json&#x7f;audio/vnd.dolby.heaac.1&#x7f;audio/vnd.dolby.heaac.2&#x7f;audio/vnd.dolby.mlp&#x7f;application/vnd.dolby.mobile.1&#x7f;application/vnd.dolby.mobile.2&#x7f;audio/vnd.dolby.mps&#x7f;audio/vnd.dolby.pl2&#x7f;audio/vnd.dolby.pl2x&#x7f;audio/vnd.dolby.pl2z&#x7f;audio/vnd.dolby.pulse.1&#x7f;application/vnd.doremir.scorecloud-binary-document&#x7f;application/vnd.dpgraph&#x7f;audio/vnd.dra&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.drive+json&#x7f;application/vnd.dtg.local&#x7f;application/vnd.dtg.local.flash&#x7f;application/vnd.dtg.local.html&#x7f;audio/vnd.dts&#x7f;audio/vnd.dts.hd&#x7f;audio/vnd.dts.uhd&#x7f;application/vnd.dvb.ait&#x7f;application/vnd.dvb.dvbisl+xml&#x7f;application/vnd.dvb.dvbj&#x7f;application/vnd.dvb.esgcontainer&#x7f;audio/vnd.dvb.file&#x7f;video/vnd.dvb.file&#x7f;application/vnd.dvb.ipdcdftnotifaccess&#x7f;application/vnd.dvb.ipdcesgaccess&#x7f;application/vnd.dvb.ipdcesgaccess2&#x7f;application/vnd.dvb.ipdcesgpdd&#x7f;application/vnd.dvb.ipdcroaming&#x7f;application/vnd.dvb.iptv.alfec-base&#x7f;application/vnd.dvb.iptv.alfec-enhancement&#x7f;application/vnd.dvb.notif-aggregate-root+xml&#x7f;application/vnd.dvb.notif-container+xml&#x7f;application/vnd.dvb.notif-generic+xml&#x7f;application/vnd.dvb.notif-ia-msglist+xml&#x7f;application/vnd.dvb.notif-ia-registration-request+xml&#x7f;application/vnd.dvb.notif-ia-registration-response+xml&#x7f;application/vnd.dvb.notif-init+xml&#x7f;application/vnd.dvb.pfr&#x7f;application/vnd.dvb.service&#x7f;image/vnd.dvb.subtitle&#x7f;text/vnd.dvb.subtitle&#x7f;model/vnd.dwf&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;application/vnd.dxr&#x7f;application/vnd.dynageo&#x7f;application/vnd.dzr&#x7f;application/vnd.easykaraoke.cdgdownload&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecip.rlp&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.efi.img&#x7f;application/vnd.efi.iso&#x7f;application/vnd.emclient.accessrequest+xml&#x7f;application/vnd.enliven&#x7f;application/vnd.enphase.envoy&#x7f;application/vnd.eprints.data+xml&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;application/vnd.espass-espass+zip&#x7f;application/vnd.eszigno3+xml&#x7f;application/vnd.etsi.aoc+xml&#x7f;application/vnd.etsi.asic-e+zip&#x7f;application/vnd.etsi.asic-s+zip&#x7f;application/vnd.etsi.cug+xml&#x7f;application/vnd.etsi.iptvcommand+xml&#x7f;application/vnd.etsi.iptvdiscovery+xml&#x7f;application/vnd.etsi.iptvprofile+xml&#x7f;application/vnd.etsi.iptvsad-bc+xml&#x7f;application/vnd.etsi.iptvsad-cod+xml&#x7f;application/vnd.etsi.iptvsad-npvr+xml&#x7f;application/vnd.etsi.iptvservice+xml&#x7f;application/vnd.etsi.iptvsync+xml&#x7f;application/vnd.etsi.iptvueprofile+xml&#x7f;application/vnd.etsi.mcid+xml&#x7f;application/vnd.etsi.mheg5&#x7f;application/vnd.etsi.overload-control-policy-dataset+xml&#x7f;application/vnd.etsi.pstn+xml&#x7f;application/vnd.etsi.sci+xml&#x7f;application/vnd.etsi.simservs+xml&#x7f;application/vnd.etsi.timestamp-token&#x7f;application/vnd.etsi.tsl+xml&#x7f;application/vnd.etsi.tsl.der&#x7f;application/vnd.eudora.data&#x7f;audio/vnd.everad.plj&#x7f;application/vnd.evolv.ecig.profile&#x7f;application/vnd.evolv.ecig.settings&#x7f;application/vnd.evolv.ecig.theme&#x7f;application/vnd.exstream-empower+zip&#x7f;application/vnd.exstream-package&#x7f;application/vnd.ezpix-album&#x7f;application/vnd.ezpix-package&#x7f;application/vnd.f-secure.mobile&#x7f;image/vnd.fastbidsheet&#x7f;application/vnd.fastcopy-disk-image&#x7f;application/vnd.fdf&#x7f;application/vnd.fdsn.mseed&#x7f;application/vnd.fdsn.seed&#x7f;application/vnd.ffsns&#x7f;application/vnd.ficlab.flb+zip&#x7f;text/vnd.ficlab.flt&#x7f;application/vnd.filmit.zfc&#x7f;application/vnd.fints&#x7f;application/vnd.firemonkeys.cloudcell&#x7f;model/vnd.flatland.3dml&#x7f;application/vnd.fluxtime.clip&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;application/vnd.font-fontforge-sfd&#x7f;image/vnd.fpx&#x7f;application/vnd.framemaker&#x7f;application/vnd.frogans.fnc&#x7f;application/vnd.frogans.ltf&#x7f;application/vnd.fsc.weblaunch&#x7f;image/vnd.fst&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ART-EX&#x7f;application/vnd.fujixerox.ART4&#x7f;application/vnd.fujixerox.HBPL&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fujixerox.docuworks.container&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.futoin+cbor&#x7f;application/vnd.futoin+json&#x7f;application/vnd.fuzzysheet&#x7f;video/vnd.fvt&#x7f;model/vnd.gdl&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.gentics.grd+json&#x7f;application/vnd.geogebra.file&#x7f;application/vnd.geogebra.tool&#x7f;application/vnd.geometry-explorer&#x7f;application/vnd.geonext&#x7f;application/vnd.geoplan&#x7f;application/vnd.geospace&#x7f;application/vnd.gerber&#x7f;image/vnd.globalgraphics.pgb&#x7f;application/vnd.globalplatform.card-content-mgt&#x7f;application/vnd.globalplatform.card-content-mgt-response&#x7f;text/vnd.gml&#x7f;application/vnd.google-earth.kml+xml&#x7f;application/vnd.google-earth.kmz&#x7f;application/vnd.gov.sk.e-form+xml&#x7f;application/vnd.gov.sk.e-form+zip&#x7f;application/vnd.gov.sk.xmldatacontainer+xml&#x7f;application/vnd.grafeq&#x7f;text/vnd.graphviz&#x7f;application/vnd.gridmp&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;application/vnd.hal+json&#x7f;application/vnd.hal+xml&#x7f;application/vnd.hbci&#x7f;application/vnd.hc+json&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hdt&#x7f;application/vnd.heroku+json&#x7f;text/vnd.hgl&#x7f;application/vnd.hhe.lesson-player&#x7f;audio/vnd.hns.audio&#x7f;video/vnd.hns.video&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.hp-jlyt&#x7f;application/vnd.httphone&#x7f;application/vnd.hydrostatix.sof-data&#x7f;application/vnd.hyper+json&#x7f;application/vnd.hyper-item+json&#x7f;application/vnd.hyperdrive+json&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.iccprofile&#x7f;application/vnd.ieee.1905&#x7f;application/vnd.igloader&#x7f;application/vnd.imagemeter.folder+zip&#x7f;application/vnd.imagemeter.image+zip&#x7f;application/vnd.immervision-ivp&#x7f;application/vnd.immervision-ivu&#x7f;application/vnd.ims.imsccv1p1&#x7f;application/vnd.ims.imsccv1p2&#x7f;application/vnd.ims.imsccv1p3&#x7f;application/vnd.ims.lis.v2.result+json&#x7f;application/vnd.ims.lti.v2.toolconsumerprofile+json&#x7f;application/vnd.ims.lti.v2.toolproxy+json&#x7f;application/vnd.ims.lti.v2.toolproxy.id+json&#x7f;application/vnd.ims.lti.v2.toolsettings+json&#x7f;application/vnd.ims.lti.v2.toolsettings.simple+json&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;application/vnd.informedcontrol.rms+xml&#x7f;application/vnd.infotech.project&#x7f;application/vnd.infotech.project+xml&#x7f;application/vnd.innopath.wamp.notification&#x7f;application/vnd.insors.igm&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intergeo&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.iptc.g2.catalogitem+xml&#x7f;application/vnd.iptc.g2.conceptitem+xml&#x7f;application/vnd.iptc.g2.knowledgeitem+xml&#x7f;application/vnd.iptc.g2.newsitem+xml&#x7f;application/vnd.iptc.g2.newsmessage+xml&#x7f;application/vnd.iptc.g2.packageitem+xml&#x7f;application/vnd.iptc.g2.planningitem+xml&#x7f;video/vnd.iptvforum.1dparityfec-1010&#x7f;video/vnd.iptvforum.1dparityfec-2005&#x7f;video/vnd.iptvforum.2dparityfec-1010&#x7f;video/vnd.iptvforum.2dparityfec-2005&#x7f;video/vnd.iptvforum.ttsavc&#x7f;video/vnd.iptvforum.ttsmpeg2&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.isac.fcs&#x7f;application/vnd.iso11783-10+zip&#x7f;application/vnd.jam&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jcp.javame.midlet-rms&#x7f;application/vnd.jisp&#x7f;application/vnd.joost.joda-archive&#x7f;application/vnd.jsk.isdn-ngn&#x7f;application/vnd.kahootz&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.koan&#x7f;application/vnd.kodak-descriptor&#x7f;application/vnd.las&#x7f;application/vnd.las.las+json&#x7f;application/vnd.las.las+xml&#x7f;application/vnd.laszip&#x7f;text/vnd.latex-z&#x7f;application/vnd.leap+json&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.logipipe.circuit+zip&#x7f;application/vnd.loom&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;audio/vnd.lucent.voice&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.mapbox-vector-tile&#x7f;application/vnd.marlin.drm.actiontoken+xml&#x7f;application/vnd.marlin.drm.conftoken+xml&#x7f;application/vnd.marlin.drm.license+xml&#x7f;application/vnd.marlin.drm.mdcf&#x7f;application/vnd.mason+json&#x7f;application/vnd.maxmind.maxmind-db&#x7f;application/vnd.mcd&#x7f;application/vnd.medcalcdata&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.mfmp&#x7f;application/vnd.micro+json&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;image/vnd.microsoft.icon&#x7f;application/vnd.microsoft.portable-executable&#x7f;application/vnd.microsoft.windows.thumbnail-cache&#x7f;application/vnd.miele+json&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;image/vnd.mix&#x7f;model/vnd.moml+xml&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.motorola.iprm&#x7f;text/vnd.motorola.reflex&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;image/vnd.mozilla.apng&#x7f;application/vnd.mozilla.xul+xml&#x7f;video/vnd.mpegurl&#x7f;application/vnd.ms-3mfdocument&#x7f;application/vnd.ms-PrintDeviceCapabilities+xml&#x7f;application/vnd.ms-PrintSchemaTicket+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-cab-compressed&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-excel.addin.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.binary.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.macroEnabled.12&#x7f;application/vnd.ms-excel.template.macroEnabled.12&#x7f;application/vnd.ms-fontobject&#x7f;application/vnd.ms-htmlhelp&#x7f;application/vnd.ms-ims&#x7f;application/vnd.ms-lrm&#x7f;text/vnd.ms-mediapackage&#x7f;image/vnd.ms-modi&#x7f;application/vnd.ms-office.activeX+xml&#x7f;application/vnd.ms-officetheme&#x7f;application/vnd.ms-playready.initiator+xml&#x7f;audio/vnd.ms-playready.media.pya&#x7f;video/vnd.ms-playready.media.pyv&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-powerpoint.addin.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.presentation.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slide.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slideshow.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.template.macroEnabled.12&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-windows.devicepairing&#x7f;application/vnd.ms-windows.nwprinting.oob&#x7f;application/vnd.ms-windows.printerpairing&#x7f;application/vnd.ms-windows.wsd.oob&#x7f;application/vnd.ms-wmdrm.lic-chlg-req&#x7f;application/vnd.ms-wmdrm.lic-resp&#x7f;application/vnd.ms-wmdrm.meter-chlg-req&#x7f;application/vnd.ms-wmdrm.meter-resp&#x7f;application/vnd.ms-word.document.macroEnabled.12&#x7f;application/vnd.ms-word.template.macroEnabled.12&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.ms-xpsdocument&#x7f;application/vnd.msa-disk-image&#x7f;application/vnd.mseq&#x7f;application/vnd.msign&#x7f;model/vnd.mts&#x7f;application/vnd.multiad.creator&#x7f;application/vnd.multiad.creator.cif&#x7f;application/vnd.music-niff&#x7f;application/vnd.musician&#x7f;application/vnd.muvee.style&#x7f;application/vnd.mynfc&#x7f;application/vnd.ncd.control&#x7f;application/vnd.ncd.reference&#x7f;application/vnd.nearst.inv+json&#x7f;application/vnd.nervana&#x7f;image/vnd.net-fpx&#x7f;text/vnd.net2phone.commcenter.command&#x7f;application/vnd.netfpx&#x7f;application/vnd.neurolanguage.nlu&#x7f;application/vnd.nimn&#x7f;application/vnd.nintendo.nitro.rom&#x7f;application/vnd.nintendo.snes.rom&#x7f;application/vnd.nitf&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.catalogs&#x7f;application/vnd.nokia.conml+wbxml&#x7f;application/vnd.nokia.conml+xml&#x7f;application/vnd.nokia.iSDS-radio-presets&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;application/vnd.nokia.iptv.config+xml&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;video/vnd.nokia.mp4vr&#x7f;application/vnd.nokia.n-gage.ac+xml&#x7f;application/vnd.nokia.n-gage.data&#x7f;application/vnd.nokia.ncd&#x7f;application/vnd.nokia.pcd+wbxml&#x7f;application/vnd.nokia.pcd+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;video/vnd.nokia.videovoip&#x7f;audio/vnd.nortel.vbk&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.ntt-local.content-share&#x7f;application/vnd.ntt-local.file-transfer&#x7f;application/vnd.ntt-local.ogw_remote-access&#x7f;application/vnd.ntt-local.sip-ta_remote&#x7f;application/vnd.ntt-local.sip-ta_tcp_stream&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;application/vnd.oasis.opendocument.chart&#x7f;application/vnd.oasis.opendocument.chart-template&#x7f;application/vnd.oasis.opendocument.database&#x7f;application/vnd.oasis.opendocument.formula&#x7f;application/vnd.oasis.opendocument.formula-template&#x7f;application/vnd.oasis.opendocument.graphics&#x7f;application/vnd.oasis.opendocument.graphics-template&#x7f;application/vnd.oasis.opendocument.image&#x7f;application/vnd.oasis.opendocument.image-template&#x7f;application/vnd.oasis.opendocument.presentation&#x7f;application/vnd.oasis.opendocument.presentation-template&#x7f;application/vnd.oasis.opendocument.spreadsheet&#x7f;application/vnd.oasis.opendocument.spreadsheet-template&#x7f;application/vnd.oasis.opendocument.text&#x7f;application/vnd.oasis.opendocument.text-master&#x7f;application/vnd.oasis.opendocument.text-template&#x7f;application/vnd.oasis.opendocument.text-web&#x7f;video/vnd.objectvideo&#x7f;application/vnd.obn&#x7f;application/vnd.ocf+cbor&#x7f;application/vnd.oci.image.manifest.v1+json&#x7f;audio/vnd.octel.sbc&#x7f;application/vnd.oftn.l10n+json&#x7f;application/vnd.oipf.contentaccessdownload+xml&#x7f;application/vnd.oipf.contentaccessstreaming+xml&#x7f;application/vnd.oipf.cspg-hexbinary&#x7f;application/vnd.oipf.dae.svg+xml&#x7f;application/vnd.oipf.dae.xhtml+xml&#x7f;application/vnd.oipf.mippvcontrolmessage+xml&#x7f;application/vnd.oipf.pae.gem&#x7f;application/vnd.oipf.spdiscovery+xml&#x7f;application/vnd.oipf.spdlist+xml&#x7f;application/vnd.oipf.ueprofile+xml&#x7f;application/vnd.oipf.userprofile+xml&#x7f;application/vnd.olpc-sugar&#x7f;application/vnd.oma-scws-config&#x7f;application/vnd.oma-scws-http-request&#x7f;application/vnd.oma-scws-http-response&#x7f;application/vnd.oma.bcast.associated-procedure-parameter+xml&#x7f;application/vnd.oma.bcast.drm-trigger+xml&#x7f;application/vnd.oma.bcast.imd+xml&#x7f;application/vnd.oma.bcast.ltkm&#x7f;application/vnd.oma.bcast.notification+xml&#x7f;application/vnd.oma.bcast.provisioningtrigger&#x7f;application/vnd.oma.bcast.sgboot&#x7f;application/vnd.oma.bcast.sgdd+xml&#x7f;application/vnd.oma.bcast.sgdu&#x7f;application/vnd.oma.bcast.simple-symbol-container&#x7f;application/vnd.oma.bcast.smartcard-trigger+xml&#x7f;application/vnd.oma.bcast.sprov+xml&#x7f;application/vnd.oma.bcast.stkm&#x7f;application/vnd.oma.cab-address-book+xml&#x7f;application/vnd.oma.cab-feature-handler+xml&#x7f;application/vnd.oma.cab-pcc+xml&#x7f;application/vnd.oma.cab-subs-invite+xml&#x7f;application/vnd.oma.cab-user-prefs+xml&#x7f;application/vnd.oma.dcd&#x7f;application/vnd.oma.dcdc&#x7f;application/vnd.oma.dd2+xml&#x7f;application/vnd.oma.drm.risd+xml&#x7f;application/vnd.oma.group-usage-list+xml&#x7f;application/vnd.oma.lwm2m+json&#x7f;application/vnd.oma.lwm2m+tlv&#x7f;application/vnd.oma.pal+xml&#x7f;application/vnd.oma.poc.detailed-progress-report+xml&#x7f;application/vnd.oma.poc.final-report+xml&#x7f;application/vnd.oma.poc.groups+xml&#x7f;application/vnd.oma.poc.invocation-descriptor+xml&#x7f;application/vnd.oma.poc.optimized-progress-report+xml&#x7f;application/vnd.oma.push&#x7f;application/vnd.oma.scidm.messages+xml&#x7f;application/vnd.oma.xcap-directory+xml&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.omaloc-supl-init&#x7f;application/vnd.onepager&#x7f;application/vnd.onepagertamp&#x7f;application/vnd.onepagertamx&#x7f;application/vnd.onepagertat&#x7f;application/vnd.onepagertatp&#x7f;application/vnd.onepagertatx&#x7f;application/vnd.openblox.game+xml&#x7f;application/vnd.openblox.game-binary&#x7f;application/vnd.openeye.oeb&#x7f;model/vnd.opengex&#x7f;application/vnd.openstreetmap.data+xml&#x7f;application/vnd.openxmlformats-officedocument.custom-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.customXmlProperties+xml&#x7f;application/vnd.openxmlformats-officedocument.drawing+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chart+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml&#x7f;application/vnd.openxmlformats-officedocument.extended-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presProps+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tags+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml&#x7f;application/vnd.openxmlformats-officedocument.theme+xml&#x7f;application/vnd.openxmlformats-officedocument.themeOverride+xml&#x7f;application/vnd.openxmlformats-officedocument.vmlDrawing&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml&#x7f;application/vnd.openxmlformats-package.core-properties+xml&#x7f;application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml&#x7f;application/vnd.openxmlformats-package.relationships+xml&#x7f;application/vnd.oracle.resource+json&#x7f;application/vnd.orange.indata&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.osgeo.mapguide.package&#x7f;application/vnd.osgi.bundle&#x7f;application/vnd.osgi.dp&#x7f;application/vnd.osgi.subsystem&#x7f;application/vnd.otps.ct-kip+xml&#x7f;application/vnd.oxli.countgraph&#x7f;application/vnd.pagerduty+json&#x7f;application/vnd.palm&#x7f;application/vnd.panoply&#x7f;application/vnd.paos.xml&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;application/vnd.patentdive&#x7f;application/vnd.patientecommsdoc&#x7f;application/vnd.pawaafile&#x7f;application/vnd.pcos&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.piaccess.application-licence&#x7f;application/vnd.picsel&#x7f;application/vnd.pmi.widget&#x7f;application/vnd.poc.group-advertisement+xml&#x7f;application/vnd.pocketlearn&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.preminet&#x7f;audio/vnd.presonus.multitrack&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.proteus.magazine&#x7f;application/vnd.psfs&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.qualcomm.brew-app-res&#x7f;application/vnd.quarantainenet&#x7f;application/vnd.quobject-quoxdocument&#x7f;video/vnd.radgamettools.bink&#x7f;video/vnd.radgamettools.smacker&#x7f;image/vnd.radiance&#x7f;application/vnd.radisys.moml+xml&#x7f;application/vnd.radisys.msml+xml&#x7f;application/vnd.radisys.msml-audit+xml&#x7f;application/vnd.radisys.msml-audit-conf+xml&#x7f;application/vnd.radisys.msml-audit-conn+xml&#x7f;application/vnd.radisys.msml-audit-dialog+xml&#x7f;application/vnd.radisys.msml-audit-stream+xml&#x7f;text/vnd.radisys.msml-basic-layout&#x7f;application/vnd.radisys.msml-conf+xml&#x7f;application/vnd.radisys.msml-dialog+xml&#x7f;application/vnd.radisys.msml-dialog-base+xml&#x7f;application/vnd.radisys.msml-dialog-fax-detect+xml&#x7f;application/vnd.radisys.msml-dialog-fax-sendrecv+xml&#x7f;application/vnd.radisys.msml-dialog-group+xml&#x7f;application/vnd.radisys.msml-dialog-speech+xml&#x7f;application/vnd.radisys.msml-dialog-transform+xml&#x7f;application/vnd.rainstor.data&#x7f;application/vnd.rapid&#x7f;application/vnd.rar&#x7f;application/vnd.realvnc.bed&#x7f;application/vnd.recordare.musicxml&#x7f;application/vnd.recordare.musicxml+xml&#x7f;application/vnd.restful+json&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;application/vnd.rig.cryptonote&#x7f;audio/vnd.rip&#x7f;model/vnd.rosette.annotated-data-model&#x7f;application/vnd.route66.link66+xml&#x7f;application/vnd.rs-274x&#x7f;application/vnd.ruckus.download&#x7f;application/vnd.s3sms&#x7f;application/vnd.sailingtracker.track&#x7f;application/vnd.sar&#x7f;application/vnd.sbm.cid&#x7f;application/vnd.sbm.mid2&#x7f;application/vnd.scribus&#x7f;application/vnd.sealed.3df&#x7f;application/vnd.sealed.csf&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;application/vnd.sealed.net&#x7f;image/vnd.sealed.png&#x7f;application/vnd.sealed.ppt&#x7f;video/vnd.sealed.swf&#x7f;application/vnd.sealed.tiff&#x7f;application/vnd.sealed.xls&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.sema&#x7f;application/vnd.semd&#x7f;application/vnd.semf&#x7f;text/vnd.senx.warpscript&#x7f;application/vnd.shade-save-file&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.shootproof+json&#x7f;application/vnd.shopkick+json&#x7f;application/vnd.shp&#x7f;application/vnd.shx&#x7f;application/vnd.sigrok.session&#x7f;application/vnd.siren+json&#x7f;application/vnd.smaf&#x7f;application/vnd.smart.notebook&#x7f;application/vnd.smart.teacher&#x7f;application/vnd.snesdev-page-table&#x7f;application/vnd.software602.filler.form+xml&#x7f;application/vnd.software602.filler.form-xml-zip&#x7f;application/vnd.solent.sdkm+xml&#x7f;text/vnd.sosi&#x7f;application/vnd.spotfire.dxp&#x7f;application/vnd.spotfire.sfs&#x7f;application/vnd.sqlite3&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.stepmania.package&#x7f;application/vnd.stepmania.stepchart&#x7f;application/vnd.street-stream&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;application/vnd.sun.wadl+xml&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;image/vnd.svf&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml+xml&#x7f;application/vnd.syncml.dm+wbxml&#x7f;application/vnd.syncml.dm+xml&#x7f;application/vnd.syncml.dm.notification&#x7f;application/vnd.syncml.dmddf+wbxml&#x7f;application/vnd.syncml.dmddf+xml&#x7f;application/vnd.syncml.dmtnds+wbxml&#x7f;application/vnd.syncml.dmtnds+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.tableschema+json&#x7f;application/vnd.tao.intent-module-archive&#x7f;application/vnd.tcpdump.pcap&#x7f;image/vnd.tencent.tap&#x7f;application/vnd.think-cell.ppttc+json&#x7f;application/vnd.tmd.mediaflex.api+xml&#x7f;application/vnd.tml&#x7f;application/vnd.tmobile-livetv&#x7f;application/vnd.tri.onesource&#x7f;application/vnd.trid.tpt&#x7f;application/vnd.triscape.mxs&#x7f;text/vnd.trolltech.linguist&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ubisoft.webplayer&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.umajin&#x7f;application/vnd.unity&#x7f;application/vnd.uoml+xml&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.uri-map&#x7f;model/vnd.usdz+zip&#x7f;video/vnd.uvvu.mp4&#x7f;model/vnd.valve.source.compiled-map&#x7f;application/vnd.valve.source.material&#x7f;image/vnd.valve.source.texture&#x7f;application/vnd.vcx&#x7f;application/vnd.vd-study&#x7f;application/vnd.vectorworks&#x7f;application/vnd.vel+json&#x7f;application/vnd.verimatrix.vcas&#x7f;application/vnd.veryant.thin&#x7f;application/vnd.ves.encrypted&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;video/vnd.vivo&#x7f;audio/vnd.vmx.cvsd&#x7f;application/vnd.vsf&#x7f;model/vnd.vtu&#x7f;text/vnd.wap.si&#x7f;application/vnd.wap.sic&#x7f;text/vnd.wap.sl&#x7f;application/vnd.wap.slc&#x7f;image/vnd.wap.wbmp&#x7f;application/vnd.wap.wbxml&#x7f;text/vnd.wap.wml&#x7f;application/vnd.wap.wmlc&#x7f;text/vnd.wap.wmlscript&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wfa.p2p&#x7f;application/vnd.wfa.wsc&#x7f;message/vnd.wfa.wsc&#x7f;application/vnd.windows.devicepairing&#x7f;application/vnd.wmc&#x7f;application/vnd.wmf.bootstrap&#x7f;application/vnd.wolfram.mathematica&#x7f;application/vnd.wolfram.mathematica.package&#x7f;application/vnd.wolfram.player&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xacml+json&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.xfdl.webform&#x7f;image/vnd.xiff&#x7f;application/vnd.xmi+xml&#x7f;application/vnd.xmpie.cpkg&#x7f;application/vnd.xmpie.dpkg&#x7f;application/vnd.xmpie.plan&#x7f;application/vnd.xmpie.ppkg&#x7f;application/vnd.xmpie.xlim&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.openscoreformat&#x7f;application/vnd.yamaha.openscoreformat.osfpvg+xml&#x7f;application/vnd.yamaha.remote-setup&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yamaha.through-ngn&#x7f;application/vnd.yamaha.tunnel-udpencap&#x7f;application/vnd.yaoweme&#x7f;application/vnd.yellowriver-custom-menu&#x7f;video/vnd.youtube.yt&#x7f;image/vnd.zbrush.pcx&#x7f;application/vnd.zul&#x7f;application/vnd.zzazz.deck+xml&#x7f;multipart/voice-message&#x7f;application/voicexml+xml&#x7f;audio/vorbis&#x7f;audio/vorbis-config&#x7f;application/voucher-cms+json&#x7f;application/vq-rtcpxr&#x7f;model/vrml&#x7f;text/vtt&#x7f;application/watcherinfo+xml&#x7f;application/webpush-options+json&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/widget&#x7f;application/wita&#x7f;image/wmf&#x7f;font/woff&#x7f;font/woff2&#x7f;application/wordperfect5.1&#x7f;application/wsdl+xml&#x7f;application/wspolicy+xml&#x7f;multipart/x-mixed-replace&#x7f;application/x-pki-message&#x7f;application/x-www-form-urlencoded&#x7f;application/x-x509-ca-cert&#x7f;application/x-x509-ca-ra-cert&#x7f;application/x-x509-next-ca-cert&#x7f;model/x3d+fastinfoset&#x7f;model/x3d+xml&#x7f;model/x3d-vrml&#x7f;application/x400-bp&#x7f;application/xacml+xml&#x7f;application/xcap-att+xml&#x7f;application/xcap-caps+xml&#x7f;application/xcap-diff+xml&#x7f;application/xcap-el+xml&#x7f;application/xcap-error+xml&#x7f;application/xcap-ns+xml&#x7f;application/xcon-conference-info+xml&#x7f;application/xcon-conference-info-diff+xml&#x7f;application/xenc+xml&#x7f;application/xhtml+xml&#x7f;application/xliff+xml&#x7f;application/xml&#x7f;text/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;text/xml-external-parsed-entity&#x7f;application/xml-patch+xml&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/xslt+xml&#x7f;application/xv+xml&#x7f;application/yang&#x7f;application/yang-data+json&#x7f;application/yang-data+xml&#x7f;application/yang-patch+json&#x7f;application/yang-patch+xml&#x7f;application/yin+xml&#x7f;application/zip&#x7f;application/zlib&#x7f;application/zstd&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( contains('&#x7f;application/1d-interleaved-parityfec&#x7f;audio/1d-interleaved-parityfec&#x7f;text/1d-interleaved-parityfec&#x7f;video/1d-interleaved-parityfec&#x7f;audio/32kadpcm&#x7f;application/3gpdash-qoe-report+xml&#x7f;audio/3gpp&#x7f;video/3gpp&#x7f;application/3gpp-ims+xml&#x7f;video/3gpp-tt&#x7f;audio/3gpp2&#x7f;video/3gpp2&#x7f;model/3mf&#x7f;application/A2L&#x7f;application/AML&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;application/ATF&#x7f;application/ATFX&#x7f;audio/ATRAC-ADVANCED-LOSSLESS&#x7f;audio/ATRAC-X&#x7f;audio/ATRAC3&#x7f;application/ATXML&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;application/CALS-1840&#x7f;application/CDFX+XML&#x7f;application/CEA&#x7f;audio/CN&#x7f;message/CPIM&#x7f;application/CSTAdata+xml&#x7f;video/CelB&#x7f;audio/DAT12&#x7f;application/DCD&#x7f;application/DII&#x7f;application/DIT&#x7f;audio/DV&#x7f;video/DV&#x7f;audio/DVI4&#x7f;application/EDI-X12&#x7f;application/EDI-consent&#x7f;application/EDIFACT&#x7f;audio/EVRC&#x7f;audio/EVRC-QCP&#x7f;audio/EVRC0&#x7f;audio/EVRC1&#x7f;audio/EVRCB&#x7f;audio/EVRCB0&#x7f;audio/EVRCB1&#x7f;audio/EVRCNW&#x7f;audio/EVRCNW0&#x7f;audio/EVRCNW1&#x7f;audio/EVRCWB&#x7f;audio/EVRCWB0&#x7f;audio/EVRCWB1&#x7f;audio/EVS&#x7f;application/EmergencyCallData.Comment+xml&#x7f;application/EmergencyCallData.Control+xml&#x7f;application/EmergencyCallData.DeviceInfo+xml&#x7f;application/EmergencyCallData.ProviderInfo+xml&#x7f;application/EmergencyCallData.ServiceInfo+xml&#x7f;application/EmergencyCallData.SubscriberInfo+xml&#x7f;application/EmergencyCallData.VEDS+xml&#x7f;application/EmergencyCallData.eCall.MSD&#x7f;audio/G711-0&#x7f;audio/G719&#x7f;audio/G722&#x7f;audio/G7221&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G7291&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/GSM-HR-08&#x7f;application/H224&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/H264-RCDO&#x7f;video/H264-SVC&#x7f;video/H265&#x7f;application/IOTP&#x7f;application/ISUP&#x7f;video/JPEG&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/L8&#x7f;audio/LPC&#x7f;application/LXF&#x7f;audio/MELP&#x7f;audio/MELP1200&#x7f;audio/MELP2400&#x7f;audio/MELP600&#x7f;application/MF4&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;audio/MP4A-LATM&#x7f;video/MP4V-ES&#x7f;audio/MPA&#x7f;video/MPV&#x7f;application/ODA&#x7f;application/ODX&#x7f;audio/PCMA&#x7f;audio/PCMA-WB&#x7f;audio/PCMU&#x7f;audio/PCMU-WB&#x7f;application/PDX&#x7f;audio/QCELP&#x7f;application/QSIG&#x7f;audio/RED&#x7f;text/RED&#x7f;application/SGML&#x7f;text/SGML&#x7f;video/SMPTE292M&#x7f;audio/SMV&#x7f;audio/SMV-QCP&#x7f;audio/SMV0&#x7f;audio/TETRA_ACELP&#x7f;audio/TETRA_ACELP_BB&#x7f;application/TETRA_ISI&#x7f;audio/UEMCLIP&#x7f;audio/VDVI&#x7f;audio/VMR-WB&#x7f;video/VP8&#x7f;audio/aac&#x7f;audio/ac3&#x7f;image/aces&#x7f;application/activemessage&#x7f;application/activity+json&#x7f;multipart/alternative&#x7f;application/alto-costmap+json&#x7f;application/alto-costmapfilter+json&#x7f;application/alto-directory+json&#x7f;application/alto-endpointcost+json&#x7f;application/alto-endpointcostparams+json&#x7f;application/alto-endpointprop+json&#x7f;application/alto-endpointpropparams+json&#x7f;application/alto-error+json&#x7f;application/alto-networkmap+json&#x7f;application/alto-networkmapfilter+json&#x7f;application/alto-updatestreamcontrol+json&#x7f;application/alto-updatestreamparams+json&#x7f;audio/amr-wb+&#x7f;application/andrew-inset&#x7f;multipart/appledouble&#x7f;application/applefile&#x7f;audio/aptx&#x7f;audio/asc&#x7f;application/atom+xml&#x7f;application/atomcat+xml&#x7f;application/atomdeleted+xml&#x7f;application/atomicmail&#x7f;application/atomsvc+xml&#x7f;application/atsc-dwd+xml&#x7f;application/atsc-dynamic-event-message&#x7f;application/atsc-held+xml&#x7f;application/atsc-rdt+json&#x7f;application/atsc-rsat+xml&#x7f;application/auth-policy+xml&#x7f;image/avci&#x7f;image/avcs&#x7f;application/bacnet-xdd+zip&#x7f;audio/basic&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;image/bmp&#x7f;multipart/byteranges&#x7f;text/cache-manifest&#x7f;text/calendar&#x7f;application/calendar+json&#x7f;application/calendar+xml&#x7f;application/call-completion&#x7f;application/cap+xml&#x7f;application/cbor&#x7f;application/cbor-seq&#x7f;application/cccex&#x7f;application/ccmp+xml&#x7f;application/ccxml+xml&#x7f;application/cdmi-capability&#x7f;application/cdmi-container&#x7f;application/cdmi-domain&#x7f;application/cdmi-object&#x7f;application/cdmi-queue&#x7f;application/cdni&#x7f;application/cea-2018+xml&#x7f;application/cellml+xml&#x7f;application/cfw&#x7f;image/cgm&#x7f;audio/clearmode&#x7f;application/clue+xml&#x7f;application/clue_info+xml&#x7f;application/cms&#x7f;application/cnrp+xml&#x7f;application/coap-group+json&#x7f;application/coap-payload&#x7f;font/collection&#x7f;application/commonground&#x7f;application/conference-info+xml&#x7f;application/cose&#x7f;application/cose-key&#x7f;application/cose-key-set&#x7f;application/cpl+xml&#x7f;application/csrattrs&#x7f;text/css&#x7f;application/csta+xml&#x7f;text/csv&#x7f;text/csv-schema&#x7f;application/csvm+json&#x7f;application/cwt&#x7f;application/cybercash&#x7f;application/dash+xml&#x7f;application/dashdelta&#x7f;application/davmount+xml&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;message/delivery-status&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dicom+json&#x7f;application/dicom+xml&#x7f;image/dicom-rle&#x7f;multipart/digest&#x7f;message/disposition-notification&#x7f;audio/dls&#x7f;application/dns&#x7f;text/dns&#x7f;application/dns+json&#x7f;application/dns-message&#x7f;application/dots+cbor&#x7f;application/dskpp+xml&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;application/dssc+der&#x7f;application/dssc+xml&#x7f;application/dvcs&#x7f;audio/eac3&#x7f;application/ecmascript&#x7f;application/efi&#x7f;image/emf&#x7f;application/emma+xml&#x7f;application/emotionml+xml&#x7f;application/encaprtp&#x7f;audio/encaprtp&#x7f;text/encaprtp&#x7f;video/encaprtp&#x7f;multipart/encrypted&#x7f;text/enriched&#x7f;application/epp+xml&#x7f;application/epub+zip&#x7f;application/eshop&#x7f;application/example&#x7f;audio/example&#x7f;image/example&#x7f;message/example&#x7f;model/example&#x7f;multipart/example&#x7f;text/example&#x7f;video/example&#x7f;application/exi&#x7f;application/expect-ct-report+json&#x7f;message/external-body&#x7f;application/fastinfoset&#x7f;application/fastsoap&#x7f;application/fdt+xml&#x7f;message/feedback-report&#x7f;application/fhir+json&#x7f;application/fhir+xml&#x7f;application/fits&#x7f;image/fits&#x7f;application/flexfec&#x7f;audio/flexfec&#x7f;text/flexfec&#x7f;video/flexfec&#x7f;application/font-tdpfr&#x7f;multipart/form-data&#x7f;application/framework-attributes+xml&#x7f;audio/fwdred&#x7f;text/fwdred&#x7f;image/g3fax&#x7f;application/geo+json&#x7f;application/geo+json-seq&#x7f;application/geopackage+sqlite3&#x7f;application/geoxacml+xml&#x7f;image/gif&#x7f;message/global&#x7f;message/global-delivery-status&#x7f;message/global-disposition-notification&#x7f;message/global-headers&#x7f;model/gltf+json&#x7f;model/gltf-binary&#x7f;application/gltf-buffer&#x7f;application/gml+xml&#x7f;text/grammar-ref-list&#x7f;application/gzip&#x7f;multipart/header-set&#x7f;image/heic&#x7f;image/heic-sequence&#x7f;image/heif&#x7f;image/heif-sequence&#x7f;image/hej2k&#x7f;application/held+xml&#x7f;image/hsj2&#x7f;text/html&#x7f;application/http&#x7f;message/http&#x7f;application/hyperstudio&#x7f;audio/iLBC&#x7f;application/ibe-key-request+xml&#x7f;application/ibe-pkg-reply+xml&#x7f;application/ibe-pp-data&#x7f;image/ief&#x7f;application/iges&#x7f;model/iges&#x7f;application/im-iscomposing+xml&#x7f;message/imdn+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/inkml+xml&#x7f;audio/ip-mr_v2.5&#x7f;application/ipfix&#x7f;application/ipp&#x7f;video/iso.segment&#x7f;application/its+xml&#x7f;application/javascript&#x7f;text/jcr-cnd&#x7f;application/jf2feed+json&#x7f;image/jls&#x7f;application/jose&#x7f;application/jose+json&#x7f;image/jp2&#x7f;image/jpeg&#x7f;video/jpeg2000&#x7f;image/jph&#x7f;image/jphc&#x7f;image/jpm&#x7f;image/jpx&#x7f;application/jrd+json&#x7f;application/json&#x7f;application/json-patch+json&#x7f;application/json-seq&#x7f;application/jwk+json&#x7f;application/jwk-set+json&#x7f;application/jwt&#x7f;image/jxr&#x7f;image/jxrA&#x7f;image/jxrS&#x7f;image/jxs&#x7f;image/jxsc&#x7f;image/jxsi&#x7f;image/jxss&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;image/ktx&#x7f;application/ld+json&#x7f;application/lgr+xml&#x7f;application/link-format&#x7f;application/load-control+xml&#x7f;application/lost+xml&#x7f;application/lostsync+xml&#x7f;application/lpf+zip&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/mads+xml&#x7f;application/marc&#x7f;application/marcxml+xml&#x7f;text/markdown&#x7f;application/mathematica&#x7f;application/mathml+xml&#x7f;application/mathml-content+xml&#x7f;application/mathml-presentation+xml&#x7f;application/mbms-associated-procedure-description+xml&#x7f;application/mbms-deregister+xml&#x7f;application/mbms-envelope+xml&#x7f;application/mbms-msk+xml&#x7f;application/mbms-msk-response+xml&#x7f;application/mbms-protection-description+xml&#x7f;application/mbms-reception-report+xml&#x7f;application/mbms-register+xml&#x7f;application/mbms-register-response+xml&#x7f;application/mbms-schedule+xml&#x7f;application/mbms-user-service-description+xml&#x7f;application/mbox&#x7f;application/media-policy-dataset+xml&#x7f;application/media_control+xml&#x7f;application/mediaservercontrol+xml&#x7f;application/merge-patch+json&#x7f;model/mesh&#x7f;application/metalink4+xml&#x7f;application/mets+xml&#x7f;audio/mhas&#x7f;application/mikey&#x7f;application/mipc&#x7f;multipart/mixed&#x7f;text/mizar&#x7f;video/mj2&#x7f;application/mmt-aei+xml&#x7f;application/mmt-usd+xml&#x7f;audio/mobile-xmf&#x7f;application/mods+xml&#x7f;application/moss-keys&#x7f;application/moss-signature&#x7f;application/mosskey-data&#x7f;application/mosskey-request&#x7f;application/mp21&#x7f;application/mp4&#x7f;audio/mp4&#x7f;video/mp4&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;video/mpeg&#x7f;application/mpeg4-generic&#x7f;audio/mpeg4-generic&#x7f;video/mpeg4-generic&#x7f;application/mpeg4-iod&#x7f;application/mpeg4-iod-xmt&#x7f;application/mrb-consumer+xml&#x7f;application/mrb-publish+xml&#x7f;application/msc-ivr+xml&#x7f;application/msc-mixer+xml&#x7f;application/msword&#x7f;model/mtl&#x7f;application/mud+json&#x7f;multipart/multilingual&#x7f;application/multipart-core&#x7f;application/mxf&#x7f;application/n-quads&#x7f;application/n-triples&#x7f;text/n3&#x7f;image/naplps&#x7f;application/nasdata&#x7f;application/news-checkgroups&#x7f;application/news-groupinfo&#x7f;application/news-transmission&#x7f;application/nlsml+xml&#x7f;application/node&#x7f;application/nss&#x7f;video/nv&#x7f;model/obj&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/odm+xml&#x7f;application/oebps-package+xml&#x7f;application/ogg&#x7f;audio/ogg&#x7f;video/ogg&#x7f;audio/opus&#x7f;application/oscore&#x7f;font/otf&#x7f;application/oxps&#x7f;application/p2p-overlay+xml&#x7f;multipart/parallel&#x7f;text/parameters&#x7f;application/parityfec&#x7f;audio/parityfec&#x7f;text/parityfec&#x7f;video/parityfec&#x7f;message/partial&#x7f;application/passport&#x7f;application/patch-ops-error+xml&#x7f;application/pdf&#x7f;application/pem-certificate-chain&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pidf-diff+xml&#x7f;application/pkcs10&#x7f;application/pkcs12&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkcs8&#x7f;application/pkcs8-encrypted&#x7f;application/pkix-attr-cert&#x7f;application/pkix-cert&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pkixcmp&#x7f;text/plain&#x7f;application/pls+xml&#x7f;image/png&#x7f;application/poc-settings+xml&#x7f;video/pointer&#x7f;application/postscript&#x7f;application/ppsp-tracker+json&#x7f;application/problem+json&#x7f;application/problem+xml&#x7f;application/provenance+xml&#x7f;text/provenance-notation&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;image/prs.btif&#x7f;application/prs.cww&#x7f;text/prs.fallenstein.rst&#x7f;application/prs.hpub+zip&#x7f;text/prs.lines.tag&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;text/prs.prop.logic&#x7f;image/prs.pti&#x7f;application/prs.rdf-xml-crypt&#x7f;audio/prs.sid&#x7f;application/prs.xsf+xml&#x7f;application/pskc+xml&#x7f;application/pvd+json&#x7f;image/pwg-raster&#x7f;video/quicktime&#x7f;application/raptorfec&#x7f;audio/raptorfec&#x7f;text/raptorfec&#x7f;video/raptorfec&#x7f;video/raw&#x7f;application/rdap+json&#x7f;application/rdf+xml&#x7f;application/reginfo+xml&#x7f;multipart/related&#x7f;application/relax-ng-compact-syntax&#x7f;application/remote-printing&#x7f;multipart/report&#x7f;application/reputon+json&#x7f;application/resource-lists+xml&#x7f;application/resource-lists-diff+xml&#x7f;application/rfc+xml&#x7f;message/rfc822&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;application/riscos&#x7f;application/rlmi+xml&#x7f;application/rls-services+xml&#x7f;application/route-apd+xml&#x7f;application/route-s-tsid+xml&#x7f;application/route-usd+xml&#x7f;application/rpki-ghostbusters&#x7f;application/rpki-manifest&#x7f;application/rpki-publication&#x7f;application/rpki-roa&#x7f;application/rpki-updown&#x7f;application/rtf&#x7f;text/rtf&#x7f;audio/rtp-enc-aescm128&#x7f;text/rtp-enc-aescm128&#x7f;video/rtp-enc-aescm128&#x7f;audio/rtp-midi&#x7f;application/rtploopback&#x7f;audio/rtploopback&#x7f;text/rtploopback&#x7f;video/rtploopback&#x7f;application/rtx&#x7f;audio/rtx&#x7f;text/rtx&#x7f;video/rtx&#x7f;message/s-http&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbe&#x7f;application/sbml+xml&#x7f;application/scaip+xml&#x7f;application/scim+json&#x7f;application/scvp-cv-request&#x7f;application/scvp-cv-response&#x7f;application/scvp-vp-request&#x7f;application/scvp-vp-response&#x7f;application/sdp&#x7f;application/secevent+jwt&#x7f;application/senml+cbor&#x7f;application/senml+json&#x7f;application/senml+xml&#x7f;application/senml-etch+cbor&#x7f;application/senml-etch+json&#x7f;application/senml-exi&#x7f;application/sensml+cbor&#x7f;application/sensml+json&#x7f;application/sensml+xml&#x7f;application/sensml-exi&#x7f;application/sep+xml&#x7f;application/sep-exi&#x7f;application/session-info&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;font/sfnt&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;multipart/signed&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/simpleSymbolContainer&#x7f;message/sip&#x7f;application/sipc&#x7f;message/sipfrag&#x7f;application/slate&#x7f;application/smil+xml&#x7f;video/smpte291&#x7f;application/smpte336m&#x7f;application/soap+fastinfoset&#x7f;application/soap+xml&#x7f;audio/sp-midi&#x7f;application/sparql-query&#x7f;application/sparql-results+xml&#x7f;audio/speex&#x7f;application/spirits-event+xml&#x7f;application/sql&#x7f;application/srgs&#x7f;application/srgs+xml&#x7f;application/sru+xml&#x7f;application/ssml+xml&#x7f;application/stix+json&#x7f;model/stl&#x7f;text/strings&#x7f;image/svg+xml&#x7f;application/swid+xml&#x7f;text/t140&#x7f;audio/t140c&#x7f;audio/t38&#x7f;image/t38&#x7f;text/tab-separated-values&#x7f;application/tamp-apex-update&#x7f;application/tamp-apex-update-confirm&#x7f;application/tamp-community-update&#x7f;application/tamp-community-update-confirm&#x7f;application/tamp-error&#x7f;application/tamp-sequence-adjust&#x7f;application/tamp-sequence-adjust-confirm&#x7f;application/tamp-status-query&#x7f;application/tamp-status-response&#x7f;application/tamp-update&#x7f;application/tamp-update-confirm&#x7f;application/taxii+json&#x7f;application/td+json&#x7f;application/tei+xml&#x7f;audio/telephone-event&#x7f;application/thraud+xml&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/timestamped-data&#x7f;application/tlsrpt+gzip&#x7f;application/tlsrpt+json&#x7f;application/tnauthlist&#x7f;audio/tone&#x7f;message/tracking-status&#x7f;application/trickle-ice-sdpfrag&#x7f;application/trig&#x7f;text/troff&#x7f;font/ttf&#x7f;application/ttml+xml&#x7f;text/turtle&#x7f;application/tve-trigger&#x7f;application/tzif&#x7f;application/tzif-leap&#x7f;application/ulpfec&#x7f;audio/ulpfec&#x7f;text/ulpfec&#x7f;video/ulpfec&#x7f;application/urc-grpsheet+xml&#x7f;application/urc-ressheet+xml&#x7f;application/urc-targetdesc+xml&#x7f;application/urc-uisocketdesc+xml&#x7f;text/uri-list&#x7f;audio/usac&#x7f;video/vc1&#x7f;video/vc2&#x7f;text/vcard&#x7f;application/vcard+json&#x7f;application/vcard+xml&#x7f;application/vemmi&#x7f;application/vnd.1000minds.decision-model+xml&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.3gpp-prose+xml&#x7f;application/vnd.3gpp-prose-pc3ch+xml&#x7f;application/vnd.3gpp-v2x-local-service-information&#x7f;application/vnd.3gpp.GMOP+xml&#x7f;application/vnd.3gpp.SRVCC-info+xml&#x7f;application/vnd.3gpp.access-transfer-events+xml&#x7f;application/vnd.3gpp.bsf+xml&#x7f;audio/vnd.3gpp.iufp&#x7f;application/vnd.3gpp.mc-signalling-ear&#x7f;application/vnd.3gpp.mcdata-affiliation-command+xml&#x7f;application/vnd.3gpp.mcdata-info+xml&#x7f;application/vnd.3gpp.mcdata-payload&#x7f;application/vnd.3gpp.mcdata-service-config+xml&#x7f;application/vnd.3gpp.mcdata-signalling&#x7f;application/vnd.3gpp.mcdata-ue-config+xml&#x7f;application/vnd.3gpp.mcdata-user-profile+xml&#x7f;application/vnd.3gpp.mcptt-affiliation-command+xml&#x7f;application/vnd.3gpp.mcptt-floor-request+xml&#x7f;application/vnd.3gpp.mcptt-info+xml&#x7f;application/vnd.3gpp.mcptt-location-info+xml&#x7f;application/vnd.3gpp.mcptt-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcptt-service-config+xml&#x7f;application/vnd.3gpp.mcptt-signed+xml&#x7f;application/vnd.3gpp.mcptt-ue-config+xml&#x7f;application/vnd.3gpp.mcptt-ue-init-config+xml&#x7f;application/vnd.3gpp.mcptt-user-profile+xml&#x7f;application/vnd.3gpp.mcvideo-affiliation-command+xml&#x7f;application/vnd.3gpp.mcvideo-info+xml&#x7f;application/vnd.3gpp.mcvideo-location-info+xml&#x7f;application/vnd.3gpp.mcvideo-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcvideo-service-config+xml&#x7f;application/vnd.3gpp.mcvideo-transmission-request+xml&#x7f;application/vnd.3gpp.mcvideo-ue-config+xml&#x7f;application/vnd.3gpp.mcvideo-user-profile+xml&#x7f;application/vnd.3gpp.mid-call+xml&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.3gpp.sms+xml&#x7f;application/vnd.3gpp.srvcc-ext+xml&#x7f;application/vnd.3gpp.state-and-event-info+xml&#x7f;application/vnd.3gpp.ussd+xml&#x7f;application/vnd.3gpp2.bcmcsinfo+xml&#x7f;application/vnd.3gpp2.sms&#x7f;application/vnd.3gpp2.tcap&#x7f;application/vnd.3lightssoftware.imagescal&#x7f;audio/vnd.4SB&#x7f;video/vnd.CCTV&#x7f;audio/vnd.CELP&#x7f;text/vnd.DMClientScript&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.HandHeld-Entertainment+xml&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.IPTC.NewsML&#x7f;application/vnd.Kinar&#x7f;application/vnd.MFER&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.SimTech-MindMapper&#x7f;text/vnd.a&#x7f;text/vnd.abc&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.flash.movie&#x7f;application/vnd.adobe.formscentral.fcdt&#x7f;application/vnd.adobe.fxp&#x7f;application/vnd.adobe.partial-upload&#x7f;image/vnd.adobe.photoshop&#x7f;application/vnd.adobe.xdp+xml&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.afpc.afplinedata&#x7f;application/vnd.afpc.afplinedata-pagedef&#x7f;application/vnd.afpc.foca-charset&#x7f;application/vnd.afpc.foca-codedfont&#x7f;application/vnd.afpc.foca-codepage&#x7f;application/vnd.afpc.modca&#x7f;application/vnd.afpc.modca-formdef&#x7f;application/vnd.afpc.modca-mediummap&#x7f;application/vnd.afpc.modca-objectcontainer&#x7f;application/vnd.afpc.modca-overlay&#x7f;application/vnd.afpc.modca-pagesegment&#x7f;application/vnd.ah-barcode&#x7f;application/vnd.ahead.space&#x7f;image/vnd.airzip.accelerator.azv&#x7f;application/vnd.airzip.filesecure.azf&#x7f;application/vnd.airzip.filesecure.azs&#x7f;application/vnd.amadeus+json&#x7f;application/vnd.amazon.mobi8-ebook&#x7f;application/vnd.americandynamics.acc&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.amundsen.maze+xml&#x7f;application/vnd.android.ota&#x7f;application/vnd.anki&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.antix.game-component&#x7f;application/vnd.apache.thrift.binary&#x7f;application/vnd.apache.thrift.compact&#x7f;application/vnd.apache.thrift.json&#x7f;application/vnd.api+json&#x7f;application/vnd.aplextor.warrp+json&#x7f;application/vnd.apothekende.reservation+json&#x7f;application/vnd.apple.installer+xml&#x7f;application/vnd.apple.keynote&#x7f;application/vnd.apple.mpegurl&#x7f;application/vnd.apple.numbers&#x7f;application/vnd.apple.pages&#x7f;application/vnd.aristanetworks.swi&#x7f;application/vnd.artisan+json&#x7f;application/vnd.artsquare&#x7f;text/vnd.ascii-art&#x7f;application/vnd.astraea-software.iota&#x7f;application/vnd.audiograph&#x7f;audio/vnd.audiokoz&#x7f;application/vnd.autopackage&#x7f;application/vnd.avalon+json&#x7f;application/vnd.avistar+xml&#x7f;application/vnd.balsamiq.bmml+xml&#x7f;application/vnd.balsamiq.bmpr&#x7f;application/vnd.banana-accounting&#x7f;application/vnd.bbf.usp.error&#x7f;application/vnd.bbf.usp.msg&#x7f;application/vnd.bbf.usp.msg+json&#x7f;application/vnd.bekitzur-stech+json&#x7f;application/vnd.bint.med-content&#x7f;multipart/vnd.bint.med-plus&#x7f;application/vnd.biopax.rdf+xml&#x7f;application/vnd.blink-idb-value-wrapper&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bluetooth.ep.oob&#x7f;application/vnd.bluetooth.le.oob&#x7f;application/vnd.bmi&#x7f;application/vnd.bpf&#x7f;application/vnd.bpf3&#x7f;application/vnd.businessobjects&#x7f;application/vnd.byu.uapi+json&#x7f;application/vnd.cab-jscript&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.capasystems-pg+json&#x7f;application/vnd.cendio.thinlinc.clientconf&#x7f;application/vnd.century-systems.tcp_stream&#x7f;application/vnd.chemdraw+xml&#x7f;application/vnd.chess-pgn&#x7f;application/vnd.chipnuts.karaoke-mmd&#x7f;application/vnd.ciedi&#x7f;application/vnd.cinderella&#x7f;application/vnd.cirpack.isdn-ext&#x7f;audio/vnd.cisco.nse&#x7f;application/vnd.citationstyles.style+xml&#x7f;application/vnd.claymore&#x7f;application/vnd.cloanto.rp9&#x7f;application/vnd.clonk.c4group&#x7f;application/vnd.cluetrust.cartomobile-config&#x7f;application/vnd.cluetrust.cartomobile-config-pkg&#x7f;audio/vnd.cmles.radio-events&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;image/vnd.cns.inf2&#x7f;application/vnd.coffeescript&#x7f;application/vnd.collabio.xodocuments.document&#x7f;application/vnd.collabio.xodocuments.document-template&#x7f;application/vnd.collabio.xodocuments.presentation&#x7f;application/vnd.collabio.xodocuments.presentation-template&#x7f;application/vnd.collabio.xodocuments.spreadsheet&#x7f;application/vnd.collabio.xodocuments.spreadsheet-template&#x7f;model/vnd.collada+xml&#x7f;application/vnd.collection+json&#x7f;application/vnd.collection.doc+json&#x7f;application/vnd.collection.next+json&#x7f;application/vnd.comicbook+zip&#x7f;application/vnd.comicbook-rar&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.coreos.ignition+json&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.crick.clicker&#x7f;application/vnd.crick.clicker.keyboard&#x7f;application/vnd.crick.clicker.palette&#x7f;application/vnd.crick.clicker.template&#x7f;application/vnd.crick.clicker.wordbank&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.cryptii.pipe+json&#x7f;application/vnd.crypto-shade-file&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.ctct.ws+xml&#x7f;application/vnd.cups-pdf&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-ppd&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;text/vnd.curl&#x7f;application/vnd.cyan.dean.root+xml&#x7f;application/vnd.cybank&#x7f;application/vnd.d2l.coursepackage1p0+zip&#x7f;application/vnd.dart&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.datapackage+json&#x7f;application/vnd.dataresource+json&#x7f;application/vnd.dbf&#x7f;application/vnd.debian.binary-package&#x7f;text/vnd.debian.copyright&#x7f;audio/vnd.dece.audio&#x7f;application/vnd.dece.data&#x7f;image/vnd.dece.graphic&#x7f;video/vnd.dece.hd&#x7f;video/vnd.dece.mobile&#x7f;video/vnd.dece.mp4&#x7f;video/vnd.dece.pd&#x7f;video/vnd.dece.sd&#x7f;application/vnd.dece.ttml+xml&#x7f;application/vnd.dece.unspecified&#x7f;video/vnd.dece.video&#x7f;application/vnd.dece.zip&#x7f;application/vnd.denovo.fcselayout-link&#x7f;application/vnd.desmume.movie&#x7f;audio/vnd.digital-winds&#x7f;application/vnd.dir-bi.plate-dl-nosuffix&#x7f;video/vnd.directv.mpeg&#x7f;video/vnd.directv.mpeg-tts&#x7f;image/vnd.djvu&#x7f;audio/vnd.dlna.adts&#x7f;video/vnd.dlna.mpeg-tts&#x7f;application/vnd.dm.delegation+xml&#x7f;application/vnd.dna&#x7f;application/vnd.document+json&#x7f;audio/vnd.dolby.heaac.1&#x7f;audio/vnd.dolby.heaac.2&#x7f;audio/vnd.dolby.mlp&#x7f;application/vnd.dolby.mobile.1&#x7f;application/vnd.dolby.mobile.2&#x7f;audio/vnd.dolby.mps&#x7f;audio/vnd.dolby.pl2&#x7f;audio/vnd.dolby.pl2x&#x7f;audio/vnd.dolby.pl2z&#x7f;audio/vnd.dolby.pulse.1&#x7f;application/vnd.doremir.scorecloud-binary-document&#x7f;application/vnd.dpgraph&#x7f;audio/vnd.dra&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.drive+json&#x7f;application/vnd.dtg.local&#x7f;application/vnd.dtg.local.flash&#x7f;application/vnd.dtg.local.html&#x7f;audio/vnd.dts&#x7f;audio/vnd.dts.hd&#x7f;audio/vnd.dts.uhd&#x7f;application/vnd.dvb.ait&#x7f;application/vnd.dvb.dvbisl+xml&#x7f;application/vnd.dvb.dvbj&#x7f;application/vnd.dvb.esgcontainer&#x7f;audio/vnd.dvb.file&#x7f;video/vnd.dvb.file&#x7f;application/vnd.dvb.ipdcdftnotifaccess&#x7f;application/vnd.dvb.ipdcesgaccess&#x7f;application/vnd.dvb.ipdcesgaccess2&#x7f;application/vnd.dvb.ipdcesgpdd&#x7f;application/vnd.dvb.ipdcroaming&#x7f;application/vnd.dvb.iptv.alfec-base&#x7f;application/vnd.dvb.iptv.alfec-enhancement&#x7f;application/vnd.dvb.notif-aggregate-root+xml&#x7f;application/vnd.dvb.notif-container+xml&#x7f;application/vnd.dvb.notif-generic+xml&#x7f;application/vnd.dvb.notif-ia-msglist+xml&#x7f;application/vnd.dvb.notif-ia-registration-request+xml&#x7f;application/vnd.dvb.notif-ia-registration-response+xml&#x7f;application/vnd.dvb.notif-init+xml&#x7f;application/vnd.dvb.pfr&#x7f;application/vnd.dvb.service&#x7f;image/vnd.dvb.subtitle&#x7f;text/vnd.dvb.subtitle&#x7f;model/vnd.dwf&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;application/vnd.dxr&#x7f;application/vnd.dynageo&#x7f;application/vnd.dzr&#x7f;application/vnd.easykaraoke.cdgdownload&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecip.rlp&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.efi.img&#x7f;application/vnd.efi.iso&#x7f;application/vnd.emclient.accessrequest+xml&#x7f;application/vnd.enliven&#x7f;application/vnd.enphase.envoy&#x7f;application/vnd.eprints.data+xml&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;application/vnd.espass-espass+zip&#x7f;application/vnd.eszigno3+xml&#x7f;application/vnd.etsi.aoc+xml&#x7f;application/vnd.etsi.asic-e+zip&#x7f;application/vnd.etsi.asic-s+zip&#x7f;application/vnd.etsi.cug+xml&#x7f;application/vnd.etsi.iptvcommand+xml&#x7f;application/vnd.etsi.iptvdiscovery+xml&#x7f;application/vnd.etsi.iptvprofile+xml&#x7f;application/vnd.etsi.iptvsad-bc+xml&#x7f;application/vnd.etsi.iptvsad-cod+xml&#x7f;application/vnd.etsi.iptvsad-npvr+xml&#x7f;application/vnd.etsi.iptvservice+xml&#x7f;application/vnd.etsi.iptvsync+xml&#x7f;application/vnd.etsi.iptvueprofile+xml&#x7f;application/vnd.etsi.mcid+xml&#x7f;application/vnd.etsi.mheg5&#x7f;application/vnd.etsi.overload-control-policy-dataset+xml&#x7f;application/vnd.etsi.pstn+xml&#x7f;application/vnd.etsi.sci+xml&#x7f;application/vnd.etsi.simservs+xml&#x7f;application/vnd.etsi.timestamp-token&#x7f;application/vnd.etsi.tsl+xml&#x7f;application/vnd.etsi.tsl.der&#x7f;application/vnd.eudora.data&#x7f;audio/vnd.everad.plj&#x7f;application/vnd.evolv.ecig.profile&#x7f;application/vnd.evolv.ecig.settings&#x7f;application/vnd.evolv.ecig.theme&#x7f;application/vnd.exstream-empower+zip&#x7f;application/vnd.exstream-package&#x7f;application/vnd.ezpix-album&#x7f;application/vnd.ezpix-package&#x7f;application/vnd.f-secure.mobile&#x7f;image/vnd.fastbidsheet&#x7f;application/vnd.fastcopy-disk-image&#x7f;application/vnd.fdf&#x7f;application/vnd.fdsn.mseed&#x7f;application/vnd.fdsn.seed&#x7f;application/vnd.ffsns&#x7f;application/vnd.ficlab.flb+zip&#x7f;text/vnd.ficlab.flt&#x7f;application/vnd.filmit.zfc&#x7f;application/vnd.fints&#x7f;application/vnd.firemonkeys.cloudcell&#x7f;model/vnd.flatland.3dml&#x7f;application/vnd.fluxtime.clip&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;application/vnd.font-fontforge-sfd&#x7f;image/vnd.fpx&#x7f;application/vnd.framemaker&#x7f;application/vnd.frogans.fnc&#x7f;application/vnd.frogans.ltf&#x7f;application/vnd.fsc.weblaunch&#x7f;image/vnd.fst&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ART-EX&#x7f;application/vnd.fujixerox.ART4&#x7f;application/vnd.fujixerox.HBPL&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fujixerox.docuworks.container&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.futoin+cbor&#x7f;application/vnd.futoin+json&#x7f;application/vnd.fuzzysheet&#x7f;video/vnd.fvt&#x7f;model/vnd.gdl&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.gentics.grd+json&#x7f;application/vnd.geogebra.file&#x7f;application/vnd.geogebra.tool&#x7f;application/vnd.geometry-explorer&#x7f;application/vnd.geonext&#x7f;application/vnd.geoplan&#x7f;application/vnd.geospace&#x7f;application/vnd.gerber&#x7f;image/vnd.globalgraphics.pgb&#x7f;application/vnd.globalplatform.card-content-mgt&#x7f;application/vnd.globalplatform.card-content-mgt-response&#x7f;text/vnd.gml&#x7f;application/vnd.google-earth.kml+xml&#x7f;application/vnd.google-earth.kmz&#x7f;application/vnd.gov.sk.e-form+xml&#x7f;application/vnd.gov.sk.e-form+zip&#x7f;application/vnd.gov.sk.xmldatacontainer+xml&#x7f;application/vnd.grafeq&#x7f;text/vnd.graphviz&#x7f;application/vnd.gridmp&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;application/vnd.hal+json&#x7f;application/vnd.hal+xml&#x7f;application/vnd.hbci&#x7f;application/vnd.hc+json&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hdt&#x7f;application/vnd.heroku+json&#x7f;text/vnd.hgl&#x7f;application/vnd.hhe.lesson-player&#x7f;audio/vnd.hns.audio&#x7f;video/vnd.hns.video&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.hp-jlyt&#x7f;application/vnd.httphone&#x7f;application/vnd.hydrostatix.sof-data&#x7f;application/vnd.hyper+json&#x7f;application/vnd.hyper-item+json&#x7f;application/vnd.hyperdrive+json&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.iccprofile&#x7f;application/vnd.ieee.1905&#x7f;application/vnd.igloader&#x7f;application/vnd.imagemeter.folder+zip&#x7f;application/vnd.imagemeter.image+zip&#x7f;application/vnd.immervision-ivp&#x7f;application/vnd.immervision-ivu&#x7f;application/vnd.ims.imsccv1p1&#x7f;application/vnd.ims.imsccv1p2&#x7f;application/vnd.ims.imsccv1p3&#x7f;application/vnd.ims.lis.v2.result+json&#x7f;application/vnd.ims.lti.v2.toolconsumerprofile+json&#x7f;application/vnd.ims.lti.v2.toolproxy+json&#x7f;application/vnd.ims.lti.v2.toolproxy.id+json&#x7f;application/vnd.ims.lti.v2.toolsettings+json&#x7f;application/vnd.ims.lti.v2.toolsettings.simple+json&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;application/vnd.informedcontrol.rms+xml&#x7f;application/vnd.infotech.project&#x7f;application/vnd.infotech.project+xml&#x7f;application/vnd.innopath.wamp.notification&#x7f;application/vnd.insors.igm&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intergeo&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.iptc.g2.catalogitem+xml&#x7f;application/vnd.iptc.g2.conceptitem+xml&#x7f;application/vnd.iptc.g2.knowledgeitem+xml&#x7f;application/vnd.iptc.g2.newsitem+xml&#x7f;application/vnd.iptc.g2.newsmessage+xml&#x7f;application/vnd.iptc.g2.packageitem+xml&#x7f;application/vnd.iptc.g2.planningitem+xml&#x7f;video/vnd.iptvforum.1dparityfec-1010&#x7f;video/vnd.iptvforum.1dparityfec-2005&#x7f;video/vnd.iptvforum.2dparityfec-1010&#x7f;video/vnd.iptvforum.2dparityfec-2005&#x7f;video/vnd.iptvforum.ttsavc&#x7f;video/vnd.iptvforum.ttsmpeg2&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.isac.fcs&#x7f;application/vnd.iso11783-10+zip&#x7f;application/vnd.jam&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jcp.javame.midlet-rms&#x7f;application/vnd.jisp&#x7f;application/vnd.joost.joda-archive&#x7f;application/vnd.jsk.isdn-ngn&#x7f;application/vnd.kahootz&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.koan&#x7f;application/vnd.kodak-descriptor&#x7f;application/vnd.las&#x7f;application/vnd.las.las+json&#x7f;application/vnd.las.las+xml&#x7f;application/vnd.laszip&#x7f;text/vnd.latex-z&#x7f;application/vnd.leap+json&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.logipipe.circuit+zip&#x7f;application/vnd.loom&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;audio/vnd.lucent.voice&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.mapbox-vector-tile&#x7f;application/vnd.marlin.drm.actiontoken+xml&#x7f;application/vnd.marlin.drm.conftoken+xml&#x7f;application/vnd.marlin.drm.license+xml&#x7f;application/vnd.marlin.drm.mdcf&#x7f;application/vnd.mason+json&#x7f;application/vnd.maxmind.maxmind-db&#x7f;application/vnd.mcd&#x7f;application/vnd.medcalcdata&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.mfmp&#x7f;application/vnd.micro+json&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;image/vnd.microsoft.icon&#x7f;application/vnd.microsoft.portable-executable&#x7f;application/vnd.microsoft.windows.thumbnail-cache&#x7f;application/vnd.miele+json&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;image/vnd.mix&#x7f;model/vnd.moml+xml&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.motorola.iprm&#x7f;text/vnd.motorola.reflex&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;image/vnd.mozilla.apng&#x7f;application/vnd.mozilla.xul+xml&#x7f;video/vnd.mpegurl&#x7f;application/vnd.ms-3mfdocument&#x7f;application/vnd.ms-PrintDeviceCapabilities+xml&#x7f;application/vnd.ms-PrintSchemaTicket+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-cab-compressed&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-excel.addin.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.binary.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.macroEnabled.12&#x7f;application/vnd.ms-excel.template.macroEnabled.12&#x7f;application/vnd.ms-fontobject&#x7f;application/vnd.ms-htmlhelp&#x7f;application/vnd.ms-ims&#x7f;application/vnd.ms-lrm&#x7f;text/vnd.ms-mediapackage&#x7f;image/vnd.ms-modi&#x7f;application/vnd.ms-office.activeX+xml&#x7f;application/vnd.ms-officetheme&#x7f;application/vnd.ms-playready.initiator+xml&#x7f;audio/vnd.ms-playready.media.pya&#x7f;video/vnd.ms-playready.media.pyv&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-powerpoint.addin.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.presentation.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slide.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slideshow.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.template.macroEnabled.12&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-windows.devicepairing&#x7f;application/vnd.ms-windows.nwprinting.oob&#x7f;application/vnd.ms-windows.printerpairing&#x7f;application/vnd.ms-windows.wsd.oob&#x7f;application/vnd.ms-wmdrm.lic-chlg-req&#x7f;application/vnd.ms-wmdrm.lic-resp&#x7f;application/vnd.ms-wmdrm.meter-chlg-req&#x7f;application/vnd.ms-wmdrm.meter-resp&#x7f;application/vnd.ms-word.document.macroEnabled.12&#x7f;application/vnd.ms-word.template.macroEnabled.12&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.ms-xpsdocument&#x7f;application/vnd.msa-disk-image&#x7f;application/vnd.mseq&#x7f;application/vnd.msign&#x7f;model/vnd.mts&#x7f;application/vnd.multiad.creator&#x7f;application/vnd.multiad.creator.cif&#x7f;application/vnd.music-niff&#x7f;application/vnd.musician&#x7f;application/vnd.muvee.style&#x7f;application/vnd.mynfc&#x7f;application/vnd.ncd.control&#x7f;application/vnd.ncd.reference&#x7f;application/vnd.nearst.inv+json&#x7f;application/vnd.nervana&#x7f;image/vnd.net-fpx&#x7f;text/vnd.net2phone.commcenter.command&#x7f;application/vnd.netfpx&#x7f;application/vnd.neurolanguage.nlu&#x7f;application/vnd.nimn&#x7f;application/vnd.nintendo.nitro.rom&#x7f;application/vnd.nintendo.snes.rom&#x7f;application/vnd.nitf&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.catalogs&#x7f;application/vnd.nokia.conml+wbxml&#x7f;application/vnd.nokia.conml+xml&#x7f;application/vnd.nokia.iSDS-radio-presets&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;application/vnd.nokia.iptv.config+xml&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;video/vnd.nokia.mp4vr&#x7f;application/vnd.nokia.n-gage.ac+xml&#x7f;application/vnd.nokia.n-gage.data&#x7f;application/vnd.nokia.ncd&#x7f;application/vnd.nokia.pcd+wbxml&#x7f;application/vnd.nokia.pcd+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;video/vnd.nokia.videovoip&#x7f;audio/vnd.nortel.vbk&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.ntt-local.content-share&#x7f;application/vnd.ntt-local.file-transfer&#x7f;application/vnd.ntt-local.ogw_remote-access&#x7f;application/vnd.ntt-local.sip-ta_remote&#x7f;application/vnd.ntt-local.sip-ta_tcp_stream&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;application/vnd.oasis.opendocument.chart&#x7f;application/vnd.oasis.opendocument.chart-template&#x7f;application/vnd.oasis.opendocument.database&#x7f;application/vnd.oasis.opendocument.formula&#x7f;application/vnd.oasis.opendocument.formula-template&#x7f;application/vnd.oasis.opendocument.graphics&#x7f;application/vnd.oasis.opendocument.graphics-template&#x7f;application/vnd.oasis.opendocument.image&#x7f;application/vnd.oasis.opendocument.image-template&#x7f;application/vnd.oasis.opendocument.presentation&#x7f;application/vnd.oasis.opendocument.presentation-template&#x7f;application/vnd.oasis.opendocument.spreadsheet&#x7f;application/vnd.oasis.opendocument.spreadsheet-template&#x7f;application/vnd.oasis.opendocument.text&#x7f;application/vnd.oasis.opendocument.text-master&#x7f;application/vnd.oasis.opendocument.text-template&#x7f;application/vnd.oasis.opendocument.text-web&#x7f;video/vnd.objectvideo&#x7f;application/vnd.obn&#x7f;application/vnd.ocf+cbor&#x7f;application/vnd.oci.image.manifest.v1+json&#x7f;audio/vnd.octel.sbc&#x7f;application/vnd.oftn.l10n+json&#x7f;application/vnd.oipf.contentaccessdownload+xml&#x7f;application/vnd.oipf.contentaccessstreaming+xml&#x7f;application/vnd.oipf.cspg-hexbinary&#x7f;application/vnd.oipf.dae.svg+xml&#x7f;application/vnd.oipf.dae.xhtml+xml&#x7f;application/vnd.oipf.mippvcontrolmessage+xml&#x7f;application/vnd.oipf.pae.gem&#x7f;application/vnd.oipf.spdiscovery+xml&#x7f;application/vnd.oipf.spdlist+xml&#x7f;application/vnd.oipf.ueprofile+xml&#x7f;application/vnd.oipf.userprofile+xml&#x7f;application/vnd.olpc-sugar&#x7f;application/vnd.oma-scws-config&#x7f;application/vnd.oma-scws-http-request&#x7f;application/vnd.oma-scws-http-response&#x7f;application/vnd.oma.bcast.associated-procedure-parameter+xml&#x7f;application/vnd.oma.bcast.drm-trigger+xml&#x7f;application/vnd.oma.bcast.imd+xml&#x7f;application/vnd.oma.bcast.ltkm&#x7f;application/vnd.oma.bcast.notification+xml&#x7f;application/vnd.oma.bcast.provisioningtrigger&#x7f;application/vnd.oma.bcast.sgboot&#x7f;application/vnd.oma.bcast.sgdd+xml&#x7f;application/vnd.oma.bcast.sgdu&#x7f;application/vnd.oma.bcast.simple-symbol-container&#x7f;application/vnd.oma.bcast.smartcard-trigger+xml&#x7f;application/vnd.oma.bcast.sprov+xml&#x7f;application/vnd.oma.bcast.stkm&#x7f;application/vnd.oma.cab-address-book+xml&#x7f;application/vnd.oma.cab-feature-handler+xml&#x7f;application/vnd.oma.cab-pcc+xml&#x7f;application/vnd.oma.cab-subs-invite+xml&#x7f;application/vnd.oma.cab-user-prefs+xml&#x7f;application/vnd.oma.dcd&#x7f;application/vnd.oma.dcdc&#x7f;application/vnd.oma.dd2+xml&#x7f;application/vnd.oma.drm.risd+xml&#x7f;application/vnd.oma.group-usage-list+xml&#x7f;application/vnd.oma.lwm2m+json&#x7f;application/vnd.oma.lwm2m+tlv&#x7f;application/vnd.oma.pal+xml&#x7f;application/vnd.oma.poc.detailed-progress-report+xml&#x7f;application/vnd.oma.poc.final-report+xml&#x7f;application/vnd.oma.poc.groups+xml&#x7f;application/vnd.oma.poc.invocation-descriptor+xml&#x7f;application/vnd.oma.poc.optimized-progress-report+xml&#x7f;application/vnd.oma.push&#x7f;application/vnd.oma.scidm.messages+xml&#x7f;application/vnd.oma.xcap-directory+xml&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.omaloc-supl-init&#x7f;application/vnd.onepager&#x7f;application/vnd.onepagertamp&#x7f;application/vnd.onepagertamx&#x7f;application/vnd.onepagertat&#x7f;application/vnd.onepagertatp&#x7f;application/vnd.onepagertatx&#x7f;application/vnd.openblox.game+xml&#x7f;application/vnd.openblox.game-binary&#x7f;application/vnd.openeye.oeb&#x7f;model/vnd.opengex&#x7f;application/vnd.openstreetmap.data+xml&#x7f;application/vnd.openxmlformats-officedocument.custom-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.customXmlProperties+xml&#x7f;application/vnd.openxmlformats-officedocument.drawing+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chart+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml&#x7f;application/vnd.openxmlformats-officedocument.extended-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presProps+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tags+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml&#x7f;application/vnd.openxmlformats-officedocument.theme+xml&#x7f;application/vnd.openxmlformats-officedocument.themeOverride+xml&#x7f;application/vnd.openxmlformats-officedocument.vmlDrawing&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml&#x7f;application/vnd.openxmlformats-package.core-properties+xml&#x7f;application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml&#x7f;application/vnd.openxmlformats-package.relationships+xml&#x7f;application/vnd.oracle.resource+json&#x7f;application/vnd.orange.indata&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.osgeo.mapguide.package&#x7f;application/vnd.osgi.bundle&#x7f;application/vnd.osgi.dp&#x7f;application/vnd.osgi.subsystem&#x7f;application/vnd.otps.ct-kip+xml&#x7f;application/vnd.oxli.countgraph&#x7f;application/vnd.pagerduty+json&#x7f;application/vnd.palm&#x7f;application/vnd.panoply&#x7f;application/vnd.paos.xml&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;application/vnd.patentdive&#x7f;application/vnd.patientecommsdoc&#x7f;application/vnd.pawaafile&#x7f;application/vnd.pcos&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.piaccess.application-licence&#x7f;application/vnd.picsel&#x7f;application/vnd.pmi.widget&#x7f;application/vnd.poc.group-advertisement+xml&#x7f;application/vnd.pocketlearn&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.preminet&#x7f;audio/vnd.presonus.multitrack&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.proteus.magazine&#x7f;application/vnd.psfs&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.qualcomm.brew-app-res&#x7f;application/vnd.quarantainenet&#x7f;application/vnd.quobject-quoxdocument&#x7f;video/vnd.radgamettools.bink&#x7f;video/vnd.radgamettools.smacker&#x7f;image/vnd.radiance&#x7f;application/vnd.radisys.moml+xml&#x7f;application/vnd.radisys.msml+xml&#x7f;application/vnd.radisys.msml-audit+xml&#x7f;application/vnd.radisys.msml-audit-conf+xml&#x7f;application/vnd.radisys.msml-audit-conn+xml&#x7f;application/vnd.radisys.msml-audit-dialog+xml&#x7f;application/vnd.radisys.msml-audit-stream+xml&#x7f;text/vnd.radisys.msml-basic-layout&#x7f;application/vnd.radisys.msml-conf+xml&#x7f;application/vnd.radisys.msml-dialog+xml&#x7f;application/vnd.radisys.msml-dialog-base+xml&#x7f;application/vnd.radisys.msml-dialog-fax-detect+xml&#x7f;application/vnd.radisys.msml-dialog-fax-sendrecv+xml&#x7f;application/vnd.radisys.msml-dialog-group+xml&#x7f;application/vnd.radisys.msml-dialog-speech+xml&#x7f;application/vnd.radisys.msml-dialog-transform+xml&#x7f;application/vnd.rainstor.data&#x7f;application/vnd.rapid&#x7f;application/vnd.rar&#x7f;application/vnd.realvnc.bed&#x7f;application/vnd.recordare.musicxml&#x7f;application/vnd.recordare.musicxml+xml&#x7f;application/vnd.restful+json&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;application/vnd.rig.cryptonote&#x7f;audio/vnd.rip&#x7f;model/vnd.rosette.annotated-data-model&#x7f;application/vnd.route66.link66+xml&#x7f;application/vnd.rs-274x&#x7f;application/vnd.ruckus.download&#x7f;application/vnd.s3sms&#x7f;application/vnd.sailingtracker.track&#x7f;application/vnd.sar&#x7f;application/vnd.sbm.cid&#x7f;application/vnd.sbm.mid2&#x7f;application/vnd.scribus&#x7f;application/vnd.sealed.3df&#x7f;application/vnd.sealed.csf&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;application/vnd.sealed.net&#x7f;image/vnd.sealed.png&#x7f;application/vnd.sealed.ppt&#x7f;video/vnd.sealed.swf&#x7f;application/vnd.sealed.tiff&#x7f;application/vnd.sealed.xls&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.sema&#x7f;application/vnd.semd&#x7f;application/vnd.semf&#x7f;text/vnd.senx.warpscript&#x7f;application/vnd.shade-save-file&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.shootproof+json&#x7f;application/vnd.shopkick+json&#x7f;application/vnd.shp&#x7f;application/vnd.shx&#x7f;application/vnd.sigrok.session&#x7f;application/vnd.siren+json&#x7f;application/vnd.smaf&#x7f;application/vnd.smart.notebook&#x7f;application/vnd.smart.teacher&#x7f;application/vnd.snesdev-page-table&#x7f;application/vnd.software602.filler.form+xml&#x7f;application/vnd.software602.filler.form-xml-zip&#x7f;application/vnd.solent.sdkm+xml&#x7f;text/vnd.sosi&#x7f;application/vnd.spotfire.dxp&#x7f;application/vnd.spotfire.sfs&#x7f;application/vnd.sqlite3&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.stepmania.package&#x7f;application/vnd.stepmania.stepchart&#x7f;application/vnd.street-stream&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;application/vnd.sun.wadl+xml&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;image/vnd.svf&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml+xml&#x7f;application/vnd.syncml.dm+wbxml&#x7f;application/vnd.syncml.dm+xml&#x7f;application/vnd.syncml.dm.notification&#x7f;application/vnd.syncml.dmddf+wbxml&#x7f;application/vnd.syncml.dmddf+xml&#x7f;application/vnd.syncml.dmtnds+wbxml&#x7f;application/vnd.syncml.dmtnds+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.tableschema+json&#x7f;application/vnd.tao.intent-module-archive&#x7f;application/vnd.tcpdump.pcap&#x7f;image/vnd.tencent.tap&#x7f;application/vnd.think-cell.ppttc+json&#x7f;application/vnd.tmd.mediaflex.api+xml&#x7f;application/vnd.tml&#x7f;application/vnd.tmobile-livetv&#x7f;application/vnd.tri.onesource&#x7f;application/vnd.trid.tpt&#x7f;application/vnd.triscape.mxs&#x7f;text/vnd.trolltech.linguist&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ubisoft.webplayer&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.umajin&#x7f;application/vnd.unity&#x7f;application/vnd.uoml+xml&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.uri-map&#x7f;model/vnd.usdz+zip&#x7f;video/vnd.uvvu.mp4&#x7f;model/vnd.valve.source.compiled-map&#x7f;application/vnd.valve.source.material&#x7f;image/vnd.valve.source.texture&#x7f;application/vnd.vcx&#x7f;application/vnd.vd-study&#x7f;application/vnd.vectorworks&#x7f;application/vnd.vel+json&#x7f;application/vnd.verimatrix.vcas&#x7f;application/vnd.veryant.thin&#x7f;application/vnd.ves.encrypted&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;video/vnd.vivo&#x7f;audio/vnd.vmx.cvsd&#x7f;application/vnd.vsf&#x7f;model/vnd.vtu&#x7f;text/vnd.wap.si&#x7f;application/vnd.wap.sic&#x7f;text/vnd.wap.sl&#x7f;application/vnd.wap.slc&#x7f;image/vnd.wap.wbmp&#x7f;application/vnd.wap.wbxml&#x7f;text/vnd.wap.wml&#x7f;application/vnd.wap.wmlc&#x7f;text/vnd.wap.wmlscript&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wfa.p2p&#x7f;application/vnd.wfa.wsc&#x7f;message/vnd.wfa.wsc&#x7f;application/vnd.windows.devicepairing&#x7f;application/vnd.wmc&#x7f;application/vnd.wmf.bootstrap&#x7f;application/vnd.wolfram.mathematica&#x7f;application/vnd.wolfram.mathematica.package&#x7f;application/vnd.wolfram.player&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xacml+json&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.xfdl.webform&#x7f;image/vnd.xiff&#x7f;application/vnd.xmi+xml&#x7f;application/vnd.xmpie.cpkg&#x7f;application/vnd.xmpie.dpkg&#x7f;application/vnd.xmpie.plan&#x7f;application/vnd.xmpie.ppkg&#x7f;application/vnd.xmpie.xlim&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.openscoreformat&#x7f;application/vnd.yamaha.openscoreformat.osfpvg+xml&#x7f;application/vnd.yamaha.remote-setup&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yamaha.through-ngn&#x7f;application/vnd.yamaha.tunnel-udpencap&#x7f;application/vnd.yaoweme&#x7f;application/vnd.yellowriver-custom-menu&#x7f;video/vnd.youtube.yt&#x7f;image/vnd.zbrush.pcx&#x7f;application/vnd.zul&#x7f;application/vnd.zzazz.deck+xml&#x7f;multipart/voice-message&#x7f;application/voicexml+xml&#x7f;audio/vorbis&#x7f;audio/vorbis-config&#x7f;application/voucher-cms+json&#x7f;application/vq-rtcpxr&#x7f;model/vrml&#x7f;text/vtt&#x7f;application/watcherinfo+xml&#x7f;application/webpush-options+json&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/widget&#x7f;application/wita&#x7f;image/wmf&#x7f;font/woff&#x7f;font/woff2&#x7f;application/wordperfect5.1&#x7f;application/wsdl+xml&#x7f;application/wspolicy+xml&#x7f;multipart/x-mixed-replace&#x7f;application/x-pki-message&#x7f;application/x-www-form-urlencoded&#x7f;application/x-x509-ca-cert&#x7f;application/x-x509-ca-ra-cert&#x7f;application/x-x509-next-ca-cert&#x7f;model/x3d+fastinfoset&#x7f;model/x3d+xml&#x7f;model/x3d-vrml&#x7f;application/x400-bp&#x7f;application/xacml+xml&#x7f;application/xcap-att+xml&#x7f;application/xcap-caps+xml&#x7f;application/xcap-diff+xml&#x7f;application/xcap-el+xml&#x7f;application/xcap-error+xml&#x7f;application/xcap-ns+xml&#x7f;application/xcon-conference-info+xml&#x7f;application/xcon-conference-info-diff+xml&#x7f;application/xenc+xml&#x7f;application/xhtml+xml&#x7f;application/xliff+xml&#x7f;application/xml&#x7f;text/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;text/xml-external-parsed-entity&#x7f;application/xml-patch+xml&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/xslt+xml&#x7f;application/xv+xml&#x7f;application/yang&#x7f;application/yang-data+json&#x7f;application/yang-data+xml&#x7f;application/yang-patch+json&#x7f;application/yang-patch+xml&#x7f;application/yin+xml&#x7f;application/zip&#x7f;application/zlib&#x7f;application/zstd&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( contains('&#x7f;application/CSTAdata+xml&#x7f;application/EDI-Consent&#x7f;application/EDI-X12&#x7f;application/EDIFACT&#x7f;application/activemessage&#x7f;application/andrew-inset&#x7f;application/applefile&#x7f;application/atomicmail&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;application/cals-1840&#x7f;application/cnrp+xml&#x7f;application/commonground&#x7f;application/cpl+xml&#x7f;application/csta+xml&#x7f;application/cybercash&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dns&#x7f;application/dvcs&#x7f;application/epp+xml&#x7f;application/eshop&#x7f;application/fits&#x7f;application/font-tdpfr&#x7f;application/http&#x7f;application/hyperstudio&#x7f;application/iges&#x7f;application/im-iscomposing+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/iotp&#x7f;application/ipp&#x7f;application/isup&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/marc&#x7f;application/mathematica&#x7f;application/mbox&#x7f;application/mikey&#x7f;application/mpeg4-generic&#x7f;application/msword&#x7f;application/news-message-id&#x7f;application/news-transmission&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/oda&#x7f;application/ogg&#x7f;application/parityfec&#x7f;application/pdf&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pkcs10&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkix-cert&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pkixcmp&#x7f;application/postscript&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;application/prs.cww&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;application/qsig&#x7f;application/rdf+xml&#x7f;application/reginfo+xml&#x7f;application/remote-printing&#x7f;application/resource-lists+xml&#x7f;application/riscos&#x7f;application/rls-services+xml&#x7f;application/rtf&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbml+xml&#x7f;application/sdp&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;application/sgml&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/slate&#x7f;application/soap+xml&#x7f;application/spirits-event+xml&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/tve-trigger&#x7f;application/vemmi&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.Kinar&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.anser-web-funds-transfer-initiation&#x7f;application/vnd.audiograph&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bmi&#x7f;application/vnd.businessobjects&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.cinderella&#x7f;application/vnd.claymore&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;application/vnd.cybank&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.dna&#x7f;application/vnd.dpgraph&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.dxr&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.enliven&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;application/vnd.eudora.data&#x7f;application/vnd.fdf&#x7f;application/vnd.ffsns&#x7f;application/vnd.fints&#x7f;application/vnd.framemaker&#x7f;application/vnd.fsc.weblaunch&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.grafeq&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;application/vnd.hbci&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hhe.lesson-player&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.httphone&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.afplinedata&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.modcap&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.informix-visionary&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jisp&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.koan&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;application/vnd.mcd&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.mfmp&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.mozilla.xul+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-lrm&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.mseq&#x7f;application/vnd.msign&#x7f;application/vnd.music-niff&#x7f;application/vnd.musician&#x7f;application/vnd.nervana&#x7f;application/vnd.netfpx&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.obn&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.palm&#x7f;application/vnd.paos.xml&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.picsel&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.rapid&#x7f;application/vnd.s3sms&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;application/vnd.sealed.net&#x7f;application/vnd.sealed.ppt&#x7f;application/vnd.sealed.xls&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.smaf&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.street-stream&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml.+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.triscape.mxs&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.vcx&#x7f;application/vnd.vectorworks&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;application/vnd.vsf&#x7f;application/vnd.wap.sic&#x7f;application/vnd.wap.slc&#x7f;application/vnd.wap.wbxml&#x7f;application/vnd.wap.wmlc&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yellowriver-custom-menu&#x7f;application/watcherinfo+xml&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/wita&#x7f;application/wordperfect5.1&#x7f;application/x400-bp&#x7f;application/xhtml+xml&#x7f;application/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/zip&#x7f;audio/32kadpcm&#x7f;audio/3gpp&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;audio/CN&#x7f;audio/DAT12&#x7f;audio/DVI4&#x7f;audio/EVRC&#x7f;audio/EVRC-QCP&#x7f;audio/EVRC0&#x7f;audio/G.722.1&#x7f;audio/G722&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/L8&#x7f;audio/LPC&#x7f;audio/MP4A-LATM&#x7f;audio/MPA&#x7f;audio/PCMA&#x7f;audio/PCMU&#x7f;audio/QCELP&#x7f;audio/RED&#x7f;audio/SMV&#x7f;audio/SMV-QCP&#x7f;audio/SMV0&#x7f;audio/VDVI&#x7f;audio/basic&#x7f;audio/clearmode&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;audio/iLBC&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;audio/mpeg4-generic&#x7f;audio/parityfec&#x7f;audio/prs.sid&#x7f;audio/telephone-event&#x7f;audio/tone&#x7f;audio/vnd.3gpp.iufp&#x7f;audio/vnd.audiokoz&#x7f;audio/vnd.cisco.nse&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;audio/vnd.digital-winds&#x7f;audio/vnd.everad.plj&#x7f;audio/vnd.lucent.voice&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;audio/vnd.nortel.vbk&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;audio/vnd.octel.sbc&#x7f;audio/vnd.qcelp&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;audio/vnd.vmx.cvsd&#x7f;image/cgm&#x7f;image/fits&#x7f;image/g3fax&#x7f;image/gif&#x7f;image/ief&#x7f;image/jp2&#x7f;image/jpeg&#x7f;image/jpm&#x7f;image/jpx&#x7f;image/naplps&#x7f;image/png&#x7f;image/prs.btif&#x7f;image/prs.pti&#x7f;image/t38&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;image/vnd.cns.inf2&#x7f;image/vnd.djvu&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;image/vnd.fastbidsheet&#x7f;image/vnd.fpx&#x7f;image/vnd.fst&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;image/vnd.globalgraphics.pgb&#x7f;image/vnd.microsoft.icon&#x7f;image/vnd.mix&#x7f;image/vnd.ms-modi&#x7f;image/vnd.net-fpx&#x7f;image/vnd.sealed.png&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;image/vnd.svf&#x7f;image/vnd.wap.wbmp&#x7f;image/vnd.xiff&#x7f;message/CPIM&#x7f;message/delivery-status&#x7f;message/disposition-notification&#x7f;message/external-body&#x7f;message/http&#x7f;message/news&#x7f;message/partial&#x7f;message/rfc822&#x7f;message/s-http&#x7f;message/sip&#x7f;message/sipfrag&#x7f;message/tracking-status&#x7f;model/iges&#x7f;model/mesh&#x7f;model/vnd.dwf&#x7f;model/vnd.flatland.3dml&#x7f;model/vnd.gdl&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;model/vnd.mts&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;model/vnd.vtu&#x7f;model/vrml&#x7f;multipart/alternative&#x7f;multipart/appledouble&#x7f;multipart/byteranges&#x7f;multipart/digest&#x7f;multipart/encrypted&#x7f;multipart/form-data&#x7f;multipart/header-set&#x7f;multipart/mixed&#x7f;multipart/parallel&#x7f;multipart/related&#x7f;multipart/report&#x7f;multipart/signed&#x7f;multipart/voice-message&#x7f;text/RED&#x7f;text/calendar&#x7f;text/css&#x7f;text/csv&#x7f;text/directory&#x7f;text/dns&#x7f;text/enriched&#x7f;text/html&#x7f;text/parityfec&#x7f;text/plain&#x7f;text/prs.fallenstein.rst&#x7f;text/prs.lines.tag&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;text/rtf&#x7f;text/sgml&#x7f;text/t140&#x7f;text/tab-separated-values&#x7f;text/troff&#x7f;text/uri-list&#x7f;text/vnd.DMClientScript&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.IPTC.NewsML&#x7f;text/vnd.abc&#x7f;text/vnd.curl&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;text/vnd.latex-z&#x7f;text/vnd.motorola.reflex&#x7f;text/vnd.ms-mediapackage&#x7f;text/vnd.net2phone.commcenter.command&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;text/vnd.wap.si&#x7f;text/vnd.wap.sl&#x7f;text/vnd.wap.wml&#x7f;text/vnd.wap.wmlscript&#x7f;text/xml&#x7f;text/xml-external-parsed-entity&#x7f;video/3gpp&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;video/CelB&#x7f;video/DV&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/JPEG&#x7f;video/MJ2&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;video/MP4V-ES&#x7f;video/MPV&#x7f;video/SMPTE292M&#x7f;video/mpeg&#x7f;video/mpeg4-generic&#x7f;video/nv&#x7f;video/parityfec&#x7f;video/pointer&#x7f;video/quicktime&#x7f;video/raw&#x7f;video/vnd.fvt&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;video/vnd.mpegurl&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;video/vnd.objectvideo&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;video/vnd.sealed.swf&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;video/vnd.vivo&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( contains('&#x7f;application/1d-interleaved-parityfec&#x7f;application/3gpp-ims+xml&#x7f;application/activemessage&#x7f;application/andrew-inset&#x7f;application/applefile&#x7f;application/atom+xml&#x7f;application/atomicmail&#x7f;application/atomcat+xml&#x7f;application/atomsvc+xml&#x7f;application/auth-policy+xml&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;application/calendar+xml&#x7f;application/cals-1840&#x7f;application/ccmp+xml&#x7f;application/ccxml+xml&#x7f;application/cdmi-capability&#x7f;application/cdmi-container&#x7f;application/cdmi-domain&#x7f;application/cdmi-object&#x7f;application/cdmi-queue&#x7f;application/cea-2018+xml&#x7f;application/cellml+xml&#x7f;application/cfw&#x7f;application/cnrp+xml&#x7f;application/commonground&#x7f;application/conference-info+xml&#x7f;application/cpl+xml&#x7f;application/csta+xml&#x7f;application/CSTAdata+xml&#x7f;application/cybercash&#x7f;application/davmount+xml&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dns&#x7f;application/dskpp+xml&#x7f;application/dssc+der&#x7f;application/dssc+xml&#x7f;application/dvcs&#x7f;application/ecmascript&#x7f;application/EDI-Consent&#x7f;application/EDIFACT&#x7f;application/EDI-X12&#x7f;application/emma+xml&#x7f;application/epp+xml&#x7f;application/eshop&#x7f;application/example&#x7f;application/exi&#x7f;application/fastinfoset&#x7f;application/fastsoap&#x7f;application/fits&#x7f;application/font-tdpfr&#x7f;application/framework-attributes+xml&#x7f;application/H224&#x7f;application/held+xml&#x7f;application/http&#x7f;application/hyperstudio&#x7f;application/ibe-key-request+xml&#x7f;application/ibe-pkg-reply+xml&#x7f;application/ibe-pp-data&#x7f;application/iges&#x7f;application/im-iscomposing+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/inkml+xml&#x7f;application/iotp&#x7f;application/ipfix&#x7f;application/ipp&#x7f;application/isup&#x7f;application/javascript&#x7f;application/json&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;application/lost+xml&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/mads+xml&#x7f;application/marc&#x7f;application/marcxml+xml&#x7f;application/mathematica&#x7f;application/mathml-content+xml&#x7f;application/mathml-presentation+xml&#x7f;application/mathml+xml&#x7f;application/mbms-associated-procedure-description+xml&#x7f;application/mbms-deregister+xml&#x7f;application/mbms-envelope+xml&#x7f;application/mbms-msk-response+xml&#x7f;application/mbms-msk+xml&#x7f;application/mbms-protection-description+xml&#x7f;application/mbms-reception-report+xml&#x7f;application/mbms-register-response+xml&#x7f;application/mbms-register+xml&#x7f;application/mbms-user-service-description+xml&#x7f;application/mbox&#x7f;application/media_control+xml&#x7f;application/mediaservercontrol+xml&#x7f;application/metalink4+xml&#x7f;application/mets+xml&#x7f;application/mikey&#x7f;application/mods+xml&#x7f;application/moss-keys&#x7f;application/moss-signature&#x7f;application/mosskey-data&#x7f;application/mosskey-request&#x7f;application/mp21&#x7f;application/mp4&#x7f;application/mpeg4-generic&#x7f;application/mpeg4-iod&#x7f;application/mpeg4-iod-xmt&#x7f;application/msc-ivr+xml&#x7f;application/msc-mixer+xml&#x7f;application/msword&#x7f;application/mxf&#x7f;application/nasdata&#x7f;application/news-checkgroups&#x7f;application/news-groupinfo&#x7f;application/news-transmission&#x7f;application/nss&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/oda&#x7f;application/oebps-package+xml&#x7f;application/ogg&#x7f;application/oxps&#x7f;application/parityfec&#x7f;application/patch-ops-error+xml&#x7f;application/pdf&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pidf-diff+xml&#x7f;application/pkcs10&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkcs8&#x7f;application/pkix-attr-cert&#x7f;application/pkix-cert&#x7f;application/pkixcmp&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pls+xml&#x7f;application/poc-settings+xml&#x7f;application/postscript&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;application/prs.cww&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;application/prs.rdf-xml-crypt&#x7f;application/prs.xsf+xml&#x7f;application/pskc+xml&#x7f;application/rdf+xml&#x7f;application/qsig&#x7f;application/raptorfec&#x7f;application/reginfo+xml&#x7f;application/relax-ng-compact-syntax&#x7f;application/remote-printing&#x7f;application/resource-lists-diff+xml&#x7f;application/resource-lists+xml&#x7f;application/riscos&#x7f;application/rlmi+xml&#x7f;application/rls-services+xml&#x7f;application/rpki-ghostbusters&#x7f;application/rpki-manifest&#x7f;application/rpki-roa&#x7f;application&#x7f;application/rpki-updown&#x7f;application/rtf&#x7f;application/rtx&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbml+xml&#x7f;application/scvp-cv-request&#x7f;application/scvp-cv-response&#x7f;application/scvp-vp-request&#x7f;application/scvp-vp-response&#x7f;application/sdp&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;application/sgml&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/simpleSymbolContainer&#x7f;application/slate&#x7f;application/smil (OBSOLETE)&#x7f;application/smil+xml&#x7f;application/smpte336m&#x7f;application/soap+fastinfoset&#x7f;application/soap+xml&#x7f;application/sparql-query&#x7f;application/sparql-results+xml&#x7f;application/spirits-event+xml&#x7f;application/srgs&#x7f;application/srgs+xml&#x7f;application/sru+xml&#x7f;application/ssml+xml&#x7f;application/tamp-apex-update&#x7f;application/tamp-apex-update-confirm&#x7f;application/tamp-community-update&#x7f;application/tamp-community-update-confirm&#x7f;application/tamp-error&#x7f;application/tamp-sequence-adjust&#x7f;application/tamp-sequence-adjust-confirm&#x7f;application/tamp-status-query&#x7f;application/tamp-status-response&#x7f;application/tamp-update&#x7f;application/tamp-update-confirm&#x7f;application/tei+xml&#x7f;application/thraud+xml&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/timestamped-data&#x7f;application/tve-trigger&#x7f;application/ulpfec&#x7f;application/vcard+xml&#x7f;application/vemmi&#x7f;application/vnd.3gpp.bsf+xml&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.3gpp2.bcmcsinfo+xml&#x7f;application/vnd.3gpp2.sms&#x7f;application/vnd.3gpp2.tcap&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.formscentral.fcdt&#x7f;application/vnd.adobe.fxp&#x7f;application/vnd.adobe.partial-upload&#x7f;application/vnd.adobe.xdp+xml&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.ah-barcode&#x7f;application/vnd.ahead.space&#x7f;application/vnd.airzip.filesecure.azf&#x7f;application/vnd.airzip.filesecure.azs&#x7f;application/vnd.americandynamics.acc&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.amundsen.maze+xml&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.antix.game-component&#x7f;application/vnd.apple.mpegurl&#x7f;application/vnd.apple.installer+xml&#x7f;application/vnd.arastra.swi (OBSOLETE)&#x7f;application/vnd.aristanetworks.swi&#x7f;application/vnd.astraea-software.iota&#x7f;application/vnd.audiograph&#x7f;application/vnd.autopackage&#x7f;application/vnd.avistar+xml&#x7f;application/vnd.balsamiq.bmml+xml&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bluetooth.ep.oob&#x7f;application/vnd.bmi&#x7f;application/vnd.businessobjects&#x7f;application/vnd.cab-jscript&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.cendio.thinlinc.clientconf&#x7f;application/vnd.chemdraw+xml&#x7f;application/vnd.chipnuts.karaoke-mmd&#x7f;application/vnd.cinderella&#x7f;application/vnd.cirpack.isdn-ext&#x7f;application/vnd.claymore&#x7f;application/vnd.cloanto.rp9&#x7f;application/vnd.clonk.c4group&#x7f;application/vnd.cluetrust.cartomobile-config&#x7f;application/vnd.cluetrust.cartomobile-config-pkg&#x7f;application/vnd.collection+json&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.crick.clicker&#x7f;application/vnd.crick.clicker.keyboard&#x7f;application/vnd.crick.clicker.palette&#x7f;application/vnd.crick.clicker.template&#x7f;application/vnd.crick.clicker.wordbank&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.ctct.ws+xml&#x7f;application/vnd.cups-pdf&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-ppd&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;application/vnd.cybank&#x7f;application/vnd.dart&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.dece.data&#x7f;application/vnd.dece.ttml+xml&#x7f;application/vnd.dece.unspecified&#x7f;application/vnd.dece.zip&#x7f;application/vnd.denovo.fcselayout-link&#x7f;application/vnd.dir-bi.plate-dl-nosuffix&#x7f;application/vnd.dm.delegation+xml&#x7f;application/vnd.dna&#x7f;application/vnd.dolby.mobile.1&#x7f;application/vnd.dolby.mobile.2&#x7f;application/vnd.dpgraph&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.dvb.ait&#x7f;application/vnd.dvb.dvbj&#x7f;application/vnd.dvb.esgcontainer&#x7f;application/vnd.dvb.ipdcdftnotifaccess&#x7f;application/vnd.dvb.ipdcesgaccess&#x7f;application/vnd.dvb.ipdcesgaccess2&#x7f;application/vnd.dvb.ipdcesgpdd&#x7f;application/vnd.dvb.ipdcroaming&#x7f;application/vnd.dvb.iptv.alfec-base&#x7f;application/vnd.dvb.iptv.alfec-enhancement&#x7f;application/vnd.dvb.notif-aggregate-root+xml&#x7f;application/vnd.dvb.notif-container+xml&#x7f;application/vnd.dvb.notif-generic+xml&#x7f;application/vnd.dvb.notif-ia-msglist+xml&#x7f;application/vnd.dvb.notif-ia-registration-request+xml&#x7f;application/vnd.dvb.notif-ia-registration-response+xml&#x7f;application/vnd.dvb.notif-init+xml&#x7f;application/vnd.dvb.pfr&#x7f;application/vnd.dvb.service&#x7f;application/vnd.dxr&#x7f;application/vnd.dynageo&#x7f;application/vnd.easykaraoke.cdgdownload&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.emclient.accessrequest+xml&#x7f;application/vnd.enliven&#x7f;application/vnd.eprints.data+xml&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;application/vnd.eszigno3+xml&#x7f;application/vnd.etsi.aoc+xml&#x7f;application/vnd.etsi.cug+xml&#x7f;application/vnd.etsi.iptvcommand+xml&#x7f;application/vnd.etsi.iptvdiscovery+xml&#x7f;application/vnd.etsi.iptvprofile+xml&#x7f;application/vnd.etsi.iptvsad-bc+xml&#x7f;application/vnd.etsi.iptvsad-cod+xml&#x7f;application/vnd.etsi.iptvsad-npvr+xml&#x7f;application/vnd.etsi.iptvservice+xml&#x7f;application/vnd.etsi.iptvsync+xml&#x7f;application/vnd.etsi.iptvueprofile+xml&#x7f;application/vnd.etsi.mcid+xml&#x7f;application/vnd.etsi.overload-control-policy-dataset+xml&#x7f;application/vnd.etsi.sci+xml&#x7f;application/vnd.etsi.simservs+xml&#x7f;application/vnd.etsi.tsl+xml&#x7f;application/vnd.etsi.tsl.der&#x7f;application/vnd.eudora.data&#x7f;application/vnd.ezpix-album&#x7f;application/vnd.ezpix-package&#x7f;application/vnd.f-secure.mobile&#x7f;application/vnd.fdf&#x7f;application/vnd.fdsn.mseed&#x7f;application/vnd.fdsn.seed&#x7f;application/vnd.ffsns&#x7f;application/vnd.fints&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.fluxtime.clip&#x7f;application/vnd.font-fontforge-sfd&#x7f;application/vnd.framemaker&#x7f;application/vnd.frogans.fnc&#x7f;application/vnd.frogans.ltf&#x7f;application/vnd.fsc.weblaunch&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ART4&#x7f;application/vnd.fujixerox.ART-EX&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fujixerox.HBPL&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.fuzzysheet&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.geocube+xml&#x7f;application/vnd.geogebra.file&#x7f;application/vnd.geogebra.tool&#x7f;application/vnd.geometry-explorer&#x7f;application/vnd.geonext&#x7f;application/vnd.geoplan&#x7f;application/vnd.geospace&#x7f;application/vnd.globalplatform.card-content-mgt&#x7f;application/vnd.globalplatform.card-content-mgt-response&#x7f;application/vnd.gmx (OBSOLETE)&#x7f;application/vnd.google-earth.kml+xml&#x7f;application/vnd.google-earth.kmz&#x7f;application/vnd.grafeq&#x7f;application/vnd.gridmp&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;application/vnd.hal+json&#x7f;application/vnd.hal+xml&#x7f;application/vnd.HandHeld-Entertainment+xml&#x7f;application/vnd.hbci&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hhe.lesson-player&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.hp-jlyt&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.httphone&#x7f;application/vnd.hydrostatix.sof-data&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.afplinedata&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.modcap&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.iccprofile&#x7f;application/vnd.igloader&#x7f;application/vnd.immervision-ivp&#x7f;application/vnd.immervision-ivu&#x7f;application/vnd.informedcontrol.rms+xml&#x7f;application/vnd.infotech.project&#x7f;application/vnd.infotech.project+xml&#x7f;application/vnd.informix-visionary&#x7f;application/vnd.innopath.wamp.notification&#x7f;application/vnd.insors.igm&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intergeo&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.iptc.g2.conceptitem+xml&#x7f;application/vnd.iptc.g2.knowledgeitem+xml&#x7f;application/vnd.iptc.g2.newsitem+xml&#x7f;application/vnd.iptc.g2.newsmessage+xml&#x7f;application/vnd.iptc.g2.packageitem+xml&#x7f;application/vnd.iptc.g2.planningitem+xml&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.isac.fcs&#x7f;application/vnd.jam&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jcp.javame.midlet-rms&#x7f;application/vnd.jisp&#x7f;application/vnd.joost.joda-archive&#x7f;application/vnd.jsk.isdn-ngn&#x7f;application/vnd.kahootz&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.Kinar&#x7f;application/vnd.koan&#x7f;application/vnd.kodak-descriptor&#x7f;application/vnd.las.las+xml&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.marlin.drm.actiontoken+xml&#x7f;application/vnd.marlin.drm.conftoken+xml&#x7f;application/vnd.marlin.drm.license+xml&#x7f;application/vnd.marlin.drm.mdcf&#x7f;application/vnd.mcd&#x7f;application/vnd.medcalcdata&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.MFER&#x7f;application/vnd.mfmp&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.motorola.iprm&#x7f;application/vnd.mozilla.xul+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-cab-compressed&#x7f;application/vnd.mseq&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-excel.addin.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.binary.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.macroEnabled.12&#x7f;application/vnd.ms-excel.template.macroEnabled.12&#x7f;application/vnd.ms-fontobject&#x7f;application/vnd.ms-htmlhelp&#x7f;application/vnd.ms-ims&#x7f;application/vnd.ms-lrm&#x7f;application/vnd.ms-office.activeX+xml&#x7f;application/vnd.ms-officetheme&#x7f;application/vnd.ms-playready.initiator+xml&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-powerpoint.addin.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.presentation.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slide.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slideshow.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.template.macroEnabled.12&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-wmdrm.lic-chlg-req&#x7f;application/vnd.ms-wmdrm.lic-resp&#x7f;application/vnd.ms-wmdrm.meter-chlg-req&#x7f;application/vnd.ms-wmdrm.meter-resp&#x7f;application/vnd.ms-word.document.macroEnabled.12&#x7f;application/vnd.ms-word.template.macroEnabled.12&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.ms-xpsdocument&#x7f;application/vnd.msign&#x7f;application/vnd.multiad.creator&#x7f;application/vnd.multiad.creator.cif&#x7f;application/vnd.musician&#x7f;application/vnd.music-niff&#x7f;application/vnd.muvee.style&#x7f;application/vnd.mynfc&#x7f;application/vnd.ncd.control&#x7f;application/vnd.ncd.reference&#x7f;application/vnd.nervana&#x7f;application/vnd.netfpx&#x7f;application/vnd.neurolanguage.nlu&#x7f;application/vnd.nitf&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.catalogs&#x7f;application/vnd.nokia.conml+wbxml&#x7f;application/vnd.nokia.conml+xml&#x7f;application/vnd.nokia.iptv.config+xml&#x7f;application/vnd.nokia.iSDS-radio-presets&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;application/vnd.nokia.ncd&#x7f;application/vnd.nokia.n-gage.ac+xml&#x7f;application/vnd.nokia.n-gage.data&#x7f;application/vnd.nokia.n-gage.symbian.install&#x7f;application/vnd.nokia.pcd+wbxml&#x7f;application/vnd.nokia.pcd+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.ntt-local.file-transfer&#x7f;application/vnd.ntt-local.sip-ta_remote&#x7f;application/vnd.ntt-local.sip-ta_tcp_stream&#x7f;application/vnd.oasis.opendocument.chart&#x7f;application/vnd.oasis.opendocument.chart-template&#x7f;application/vnd.oasis.opendocument.database&#x7f;application/vnd.oasis.opendocument.formula&#x7f;application/vnd.oasis.opendocument.formula-template&#x7f;application/vnd.oasis.opendocument.graphics&#x7f;application/vnd.oasis.opendocument.graphics-template&#x7f;application/vnd.oasis.opendocument.image&#x7f;application/vnd.oasis.opendocument.image-template&#x7f;application/vnd.oasis.opendocument.presentation&#x7f;application/vnd.oasis.opendocument.presentation-template&#x7f;application/vnd.oasis.opendocument.spreadsheet&#x7f;application/vnd.oasis.opendocument.spreadsheet-template&#x7f;application/vnd.oasis.opendocument.text&#x7f;application/vnd.oasis.opendocument.text-master&#x7f;application/vnd.oasis.opendocument.text-template&#x7f;application/vnd.oasis.opendocument.text-web&#x7f;application/vnd.obn&#x7f;application/vnd.oftn.l10n+json&#x7f;application/vnd.oipf.contentaccessdownload+xml&#x7f;application/vnd.oipf.contentaccessstreaming+xml&#x7f;application/vnd.oipf.cspg-hexbinary&#x7f;application/vnd.oipf.dae.svg+xml&#x7f;application/vnd.oipf.dae.xhtml+xml&#x7f;application/vnd.oipf.mippvcontrolmessage+xml&#x7f;application/vnd.oipf.pae.gem&#x7f;application/vnd.oipf.spdiscovery+xml&#x7f;application/vnd.oipf.spdlist+xml&#x7f;application/vnd.oipf.ueprofile+xml&#x7f;application/vnd.oipf.userprofile+xml&#x7f;application/vnd.olpc-sugar&#x7f;application/vnd.oma.bcast.associated-procedure-parameter+xml&#x7f;application/vnd.oma.bcast.drm-trigger+xml&#x7f;application/vnd.oma.bcast.imd+xml&#x7f;application/vnd.oma.bcast.ltkm&#x7f;application/vnd.oma.bcast.notification+xml&#x7f;application/vnd.oma.bcast.provisioningtrigger&#x7f;application/vnd.oma.bcast.sgboot&#x7f;application/vnd.oma.bcast.sgdd+xml&#x7f;application/vnd.oma.bcast.sgdu&#x7f;application/vnd.oma.bcast.simple-symbol-container&#x7f;application/vnd.oma.bcast.smartcard-trigger+xml&#x7f;application/vnd.oma.bcast.sprov+xml&#x7f;application/vnd.oma.bcast.stkm&#x7f;application/vnd.oma.cab-address-book+xml&#x7f;application/vnd.oma.cab-feature-handler+xml&#x7f;application/vnd.oma.cab-pcc+xml&#x7f;application/vnd.oma.cab-user-prefs+xml&#x7f;application/vnd.oma.dcd&#x7f;application/vnd.oma.dcdc&#x7f;application/vnd.oma.dd2+xml&#x7f;application/vnd.oma.drm.risd+xml&#x7f;application/vnd.oma.group-usage-list+xml&#x7f;application/vnd.oma.pal+xml&#x7f;application/vnd.oma.poc.detailed-progress-report+xml&#x7f;application/vnd.oma.poc.final-report+xml&#x7f;application/vnd.oma.poc.groups+xml&#x7f;application/vnd.oma.poc.invocation-descriptor+xml&#x7f;application/vnd.oma.poc.optimized-progress-report+xml&#x7f;application/vnd.oma.push&#x7f;application/vnd.oma.scidm.messages+xml&#x7f;application/vnd.oma.xcap-directory+xml&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.omaloc-supl-init&#x7f;application/vnd.oma-scws-config&#x7f;application/vnd.oma-scws-http-request&#x7f;application/vnd.oma-scws-http-response&#x7f;application/vnd.openofficeorg.extension&#x7f;application/vnd.openxmlformats-officedocument.custom-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.customXmlProperties+xml&#x7f;application/vnd.openxmlformats-officedocument.drawing+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chart+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml&#x7f;application/vnd.openxmlformats-officedocument.extended-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presProps+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tags+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml&#x7f;application/vnd.openxmlformats-officedocument.theme+xml&#x7f;application/vnd.openxmlformats-officedocument.themeOverride+xml&#x7f;application/vnd.openxmlformats-officedocument.vmlDrawing&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml&#x7f;application/vnd.openxmlformats-package.core-properties+xml&#x7f;application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml&#x7f;application/vnd.openxmlformats-package.relationships+xml&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.osgeo.mapguide.package&#x7f;application/vnd.osgi.bundle&#x7f;application/vnd.osgi.dp&#x7f;application/vnd.osgi.subsystem&#x7f;application/vnd.otps.ct-kip+xml&#x7f;application/vnd.palm&#x7f;application/vnd.paos.xml&#x7f;application/vnd.pawaafile&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.piaccess.application-licence&#x7f;application/vnd.picsel&#x7f;application/vnd.pmi.widget&#x7f;application/vnd.poc.group-advertisement+xml&#x7f;application/vnd.pocketlearn&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.preminet&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.proteus.magazine&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.qualcomm.brew-app-res&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.quobject-quoxdocument&#x7f;application/vnd.radisys.moml+xml&#x7f;application/vnd.radisys.msml-audit-conf+xml&#x7f;application/vnd.radisys.msml-audit-conn+xml&#x7f;application/vnd.radisys.msml-audit-dialog+xml&#x7f;application/vnd.radisys.msml-audit-stream+xml&#x7f;application/vnd.radisys.msml-audit+xml&#x7f;application/vnd.radisys.msml-conf+xml&#x7f;application/vnd.radisys.msml-dialog-base+xml&#x7f;application/vnd.radisys.msml-dialog-fax-detect+xml&#x7f;application/vnd.radisys.msml-dialog-fax-sendrecv+xml&#x7f;application/vnd.radisys.msml-dialog-group+xml&#x7f;application/vnd.radisys.msml-dialog-speech+xml&#x7f;application/vnd.radisys.msml-dialog-transform+xml&#x7f;application/vnd.radisys.msml-dialog+xml&#x7f;application/vnd.radisys.msml+xml&#x7f;application/vnd.rainstor.data&#x7f;application/vnd.rapid&#x7f;application/vnd.realvnc.bed&#x7f;application/vnd.recordare.musicxml&#x7f;application/vnd.recordare.musicxml+xml&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.rig.cryptonote&#x7f;application/vnd.route66.link66+xml&#x7f;application/vnd.rs-274x&#x7f;application/vnd.ruckus.download&#x7f;application/vnd.s3sms&#x7f;application/vnd.sailingtracker.track&#x7f;application/vnd.sbm.cid&#x7f;application/vnd.sbm.mid2&#x7f;application/vnd.scribus&#x7f;application/vnd.sealed.3df&#x7f;application/vnd.sealed.csf&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;application/vnd.sealed.net&#x7f;application/vnd.sealed.ppt&#x7f;application/vnd.sealed.tiff&#x7f;application/vnd.sealed.xls&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.sema&#x7f;application/vnd.semd&#x7f;application/vnd.semf&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.SimTech-MindMapper&#x7f;application/vnd.smaf&#x7f;application/vnd.smart.notebook&#x7f;application/vnd.smart.teacher&#x7f;application/vnd.software602.filler.form+xml&#x7f;application/vnd.software602.filler.form-xml-zip&#x7f;application/vnd.solent.sdkm+xml&#x7f;application/vnd.spotfire.dxp&#x7f;application/vnd.spotfire.sfs&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.stepmania.package&#x7f;application/vnd.stepmania.stepchart&#x7f;application/vnd.street-stream&#x7f;application/vnd.sun.wadl+xml&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml.dm.notification&#x7f;application/vnd.syncml.dm+wbxml&#x7f;application/vnd.syncml.dm+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.syncml+xml&#x7f;application/vnd.tao.intent-module-archive&#x7f;application/vnd.tcpdump.pcap&#x7f;application/vnd.tmobile-livetv&#x7f;application/vnd.trid.tpt&#x7f;application/vnd.triscape.mxs&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ubisoft.webplayer&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.umajin&#x7f;application/vnd.unity&#x7f;application/vnd.uoml+xml&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.vcx&#x7f;application/vnd.vd-study&#x7f;application/vnd.vectorworks&#x7f;application/vnd.verimatrix.vcas&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;application/vnd.vsf&#x7f;application/vnd.wap.sic&#x7f;application/vnd.wap.slc&#x7f;application/vnd.wap.wbxml&#x7f;application/vnd.wap.wmlc&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wfa.wsc&#x7f;application/vnd.wmc&#x7f;application/vnd.wmf.bootstrap&#x7f;application/vnd.wolfram.mathematica&#x7f;application/vnd.wolfram.mathematica.package&#x7f;application/vnd.wolfram.player&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.xfdl.webform&#x7f;application/vnd.xmi+xml&#x7f;application/vnd.xmpie.cpkg&#x7f;application/vnd.xmpie.dpkg&#x7f;application/vnd.xmpie.plan&#x7f;application/vnd.xmpie.ppkg&#x7f;application/vnd.xmpie.xlim&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.openscoreformat.osfpvg+xml&#x7f;application/vnd.yamaha.openscoreformat&#x7f;application/vnd.yamaha.remote-setup&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yamaha.through-ngn&#x7f;application/vnd.yamaha.tunnel-udpencap&#x7f;application/vnd.yellowriver-custom-menu&#x7f;application/vnd.zul&#x7f;application/vnd.zzazz.deck+xml&#x7f;application/voicexml+xml&#x7f;application/vq-rtcpxr&#x7f;application/watcherinfo+xml&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/widget&#x7f;application/wita&#x7f;application/wordperfect5.1&#x7f;application/wsdl+xml&#x7f;application/wspolicy+xml&#x7f;application/x400-bp&#x7f;application/xcap-att+xml&#x7f;application/xcap-caps+xml&#x7f;application/xcap-diff+xml&#x7f;application/xcap-el+xml&#x7f;application/xcap-error+xml&#x7f;application/xcap-ns+xml&#x7f;application/xcon-conference-info-diff+xml&#x7f;application/xcon-conference-info+xml&#x7f;application/xenc+xml&#x7f;application/xhtml-voice+xml (Obsolete)&#x7f;application/xhtml+xml&#x7f;application/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/xslt+xml&#x7f;application/xv+xml&#x7f;application/yang&#x7f;application/yin+xml&#x7f;application/zip&#x7f;audio/1d-interleaved-parityfec&#x7f;audio/32kadpcm&#x7f;audio/3gpp&#x7f;audio/3gpp2&#x7f;audio/ac3&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;audio/amr-wb+&#x7f;audio/asc&#x7f;audio/ATRAC-ADVANCED-LOSSLESS&#x7f;audio/ATRAC-X&#x7f;audio/ATRAC3&#x7f;audio/basic&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;audio/clearmode&#x7f;audio/CN&#x7f;audio/DAT12&#x7f;audio/dls&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;audio/DV&#x7f;audio/DVI4&#x7f;audio/eac3&#x7f;audio/EVRC&#x7f;audio/EVRC0&#x7f;audio/EVRC1&#x7f;audio/EVRCB&#x7f;audio/EVRCB0&#x7f;audio/EVRCB1&#x7f;audio/EVRC-QCP&#x7f;audio/EVRCWB&#x7f;audio/EVRCWB0&#x7f;audio/EVRCWB1&#x7f;audio/fwdred&#x7f;audio/G719&#x7f;audio/G722&#x7f;audio/G7221&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G7291&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/GSM-HR-08&#x7f;audio/iLBC&#x7f;audio/ip-mr_v2.5&#x7f;audio/L8&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/LPC&#x7f;audio/mobile-xmf&#x7f;audio/MPA&#x7f;audio/MP4A-LATM&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;audio/PCMA&#x7f;audio/PCMA-WB&#x7f;audio/PCMU&#x7f;audio/PCMU-WB&#x7f;audio/prs.sid&#x7f;audio/QCELP&#x7f;audio/RED&#x7f;audio/rtp-enc-aescm128&#x7f;audio/rtp-midi&#x7f;audio/SMV&#x7f;audio/SMV0&#x7f;audio/SMV-QCP&#x7f;audio/sp-midi&#x7f;audio/speex&#x7f;audio/t140c&#x7f;audio/t38&#x7f;audio/telephone-event&#x7f;audio/tone&#x7f;audio/UEMCLIP&#x7f;audio/VDVI&#x7f;audio/VMR-WB&#x7f;audio/vnd.3gpp.iufp&#x7f;audio/vnd.4SB&#x7f;audio/vnd.audiokoz&#x7f;audio/vnd.CELP&#x7f;audio/vnd.cisco.nse&#x7f;audio/vnd.cmles.radio-events&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;audio/vnd.dece.audio&#x7f;audio/vnd.digital-winds&#x7f;audio/vnd.dlna.adts&#x7f;audio/vnd.dolby.heaac.1&#x7f;audio/vnd.dolby.heaac.2&#x7f;audio/vnd.dolby.mlp&#x7f;audio/vnd.dolby.mps&#x7f;audio/vnd.dolby.pl2&#x7f;audio/vnd.dolby.pl2x&#x7f;audio/vnd.dolby.pl2z&#x7f;audio/vnd.dolby.pulse.1&#x7f;audio/vnd.dra&#x7f;audio/vnd.dts&#x7f;audio/vnd.dts.hd&#x7f;audio/vnd.dvb.file&#x7f;audio/vnd.everad.plj&#x7f;audio/vnd.hns.audio&#x7f;audio/vnd.lucent.voice&#x7f;audio/vnd.ms-playready.media.pya&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;audio/vnd.nortel.vbk&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;audio/vnd.octel.sbc&#x7f;audio/vnd.qcelp - DEPRECATED - Please use audio/qcelp&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;audio/vnd.rip&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;audio/vnd.vmx.cvsd&#x7f;audio/vorbis&#x7f;audio/vorbis-config&#x7f;image/cgm&#x7f;image/g3fax&#x7f;image/gif&#x7f;image/ief&#x7f;image/jp2&#x7f;image/jpeg&#x7f;image/jpm&#x7f;image/jpx&#x7f;image/ktx&#x7f;image/naplps&#x7f;image/png&#x7f;image/prs.btif&#x7f;image/prs.pti&#x7f;image/svg+xml&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;image/vnd.adobe.photoshop&#x7f;image/vnd.cns.inf2&#x7f;image/vnd.dece.graphic&#x7f;image/vnd.djvu&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;image/vnd.dvb.subtitle&#x7f;image/vnd.fastbidsheet&#x7f;image/vnd.fpx&#x7f;image/vnd.fst&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;image/vnd.globalgraphics.pgb&#x7f;image/vnd.microsoft.icon&#x7f;image/vnd.mix&#x7f;image/vnd.ms-modi&#x7f;image/vnd.net-fpx&#x7f;image/vnd.radiance&#x7f;image/vnd.sealed.png&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;image/vnd.svf&#x7f;image/vnd.wap.wbmp&#x7f;image/vnd.xiff&#x7f;message/CPIM&#x7f;message/delivery-status&#x7f;message/disposition-notification&#x7f;message/external-body&#x7f;message/feedback-report&#x7f;message/global&#x7f;message/global-delivery-status&#x7f;message/global-disposition-notification&#x7f;message/global-headers&#x7f;message/imdn+xml&#x7f;message/news (OBSOLETE)&#x7f;message/partial&#x7f;message/rfc822&#x7f;message/s-http&#x7f;message/sip&#x7f;message/sipfrag&#x7f;message/tracking-status&#x7f;message/vnd.si.simp&#x7f;model/mesh&#x7f;model/vnd.collada+xml&#x7f;model/vnd.dwf&#x7f;model/vnd.flatland.3dml&#x7f;model/vnd.gdl&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;model/vnd.moml+xml&#x7f;model/vnd.mts&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;model/vnd.vtu&#x7f;model/vrml&#x7f;multipart/alternative&#x7f;multipart/appledouble&#x7f;multipart/byteranges&#x7f;multipart/digest&#x7f;multipart/encrypted&#x7f;multipart/form-data&#x7f;multipart/header-set&#x7f;multipart/mixed&#x7f;multipart/parallel&#x7f;multipart/related&#x7f;multipart/report&#x7f;multipart/signed&#x7f;multipart/voice-message&#x7f;text/calendar&#x7f;text/css&#x7f;text/csv&#x7f;text/directory (deprecated)&#x7f;text/ecmascript (obsolete)&#x7f;text/enriched&#x7f;text/html&#x7f;text/javascript (obsolete)&#x7f;text/jcr-cnd&#x7f;text/mizar&#x7f;text/n3&#x7f;text/plain&#x7f;text/prs.fallenstein.rst&#x7f;text/prs.lines.tag&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;text/t140&#x7f;text/tab-separated-values&#x7f;text/troff&#x7f;text/turtle&#x7f;text/uri-list&#x7f;text/vcard&#x7f;text/vnd.abc&#x7f;text/vnd.DMClientScript&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;text/vnd.graphviz&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;text/vnd.IPTC.NewsML&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.latex-z&#x7f;text/vnd.motorola.reflex&#x7f;text/vnd.ms-mediapackage&#x7f;text/vnd.net2phone.commcenter.command&#x7f;text/vnd.radisys.msml-basic-layout&#x7f;text/vnd.si.uricatalogue&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;text/vnd.trolltech.linguist&#x7f;text/vnd.wap.si&#x7f;text/vnd.wap.sl&#x7f;text/vnd.wap.wml&#x7f;text/vnd.wap.wmlscript&#x7f;video/3gpp-tt&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;video/CelB&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/H264-RCDO&#x7f;video/H264-SVC&#x7f;video/jpeg2000&#x7f;video/MJ2&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;video/MP4V-ES&#x7f;video/MPV&#x7f;video/nv&#x7f;video/pointer&#x7f;video/quicktime&#x7f;video/raw&#x7f;video/SMPTE292M&#x7f;video/vc1&#x7f;video/vnd.CCTV&#x7f;video/vnd.dece.hd&#x7f;video/vnd.dece.mobile&#x7f;video/vnd.dece.mp4&#x7f;video/vnd.dece.pd&#x7f;video/vnd.dece.sd&#x7f;video/vnd.dece.video&#x7f;video/vnd.directv.mpeg&#x7f;video/vnd.directv.mpeg-tts&#x7f;video/vnd.dlna.mpeg-tts&#x7f;video/vnd.fvt&#x7f;video/vnd.hns.video&#x7f;video/vnd.iptvforum.1dparityfec-1010&#x7f;video/vnd.iptvforum.1dparityfec-2005&#x7f;video/vnd.iptvforum.2dparityfec-1010&#x7f;video/vnd.iptvforum.2dparityfec-2005&#x7f;video/vnd.iptvforum.ttsavc&#x7f;video/vnd.iptvforum.ttsmpeg2&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;video/vnd.mpegurl&#x7f;video/vnd.ms-playready.media.pyv&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;video/vnd.nokia.videovoip&#x7f;video/vnd.objectvideo&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;video/vnd.sealed.swf&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;video/vnd.uvvu.mp4&#x7f;video/vnd.vivo&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( contains('&#x7f;application/1d-interleaved-parityfec&#x7f;audio/1d-interleaved-parityfec&#x7f;text/1d-interleaved-parityfec&#x7f;video/1d-interleaved-parityfec&#x7f;audio/32kadpcm&#x7f;application/3gpdash-qoe-report+xml&#x7f;audio/3gpp&#x7f;video/3gpp&#x7f;application/3gpp-ims+xml&#x7f;video/3gpp-tt&#x7f;audio/3gpp2&#x7f;video/3gpp2&#x7f;model/3mf&#x7f;application/A2L&#x7f;application/AML&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;application/ATF&#x7f;application/ATFX&#x7f;audio/ATRAC-ADVANCED-LOSSLESS&#x7f;audio/ATRAC-X&#x7f;audio/ATRAC3&#x7f;application/ATXML&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;application/CALS-1840&#x7f;application/CDFX+XML&#x7f;application/CEA&#x7f;audio/CN&#x7f;message/CPIM&#x7f;application/CSTAdata+xml&#x7f;video/CelB&#x7f;audio/DAT12&#x7f;application/DCD&#x7f;application/DII&#x7f;application/DIT&#x7f;audio/DV&#x7f;video/DV&#x7f;audio/DVI4&#x7f;application/EDI-X12&#x7f;application/EDI-consent&#x7f;application/EDIFACT&#x7f;audio/EVRC&#x7f;audio/EVRC-QCP&#x7f;audio/EVRC0&#x7f;audio/EVRC1&#x7f;audio/EVRCB&#x7f;audio/EVRCB0&#x7f;audio/EVRCB1&#x7f;audio/EVRCNW&#x7f;audio/EVRCNW0&#x7f;audio/EVRCNW1&#x7f;audio/EVRCWB&#x7f;audio/EVRCWB0&#x7f;audio/EVRCWB1&#x7f;audio/EVS&#x7f;application/EmergencyCallData.Comment+xml&#x7f;application/EmergencyCallData.Control+xml&#x7f;application/EmergencyCallData.DeviceInfo+xml&#x7f;application/EmergencyCallData.ProviderInfo+xml&#x7f;application/EmergencyCallData.ServiceInfo+xml&#x7f;application/EmergencyCallData.SubscriberInfo+xml&#x7f;application/EmergencyCallData.VEDS+xml&#x7f;application/EmergencyCallData.eCall.MSD&#x7f;audio/G711-0&#x7f;audio/G719&#x7f;audio/G722&#x7f;audio/G7221&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G7291&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/GSM-HR-08&#x7f;application/H224&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/H264-RCDO&#x7f;video/H264-SVC&#x7f;video/H265&#x7f;video/JPEG&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/L8&#x7f;audio/LPC&#x7f;application/LXF&#x7f;audio/MELP&#x7f;audio/MELP1200&#x7f;audio/MELP2400&#x7f;audio/MELP600&#x7f;application/MF4&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;audio/MP4A-LATM&#x7f;video/MP4V-ES&#x7f;audio/MPA&#x7f;video/MPV&#x7f;application/ODX&#x7f;audio/PCMA&#x7f;audio/PCMA-WB&#x7f;audio/PCMU&#x7f;audio/PCMU-WB&#x7f;application/PDX&#x7f;audio/QCELP&#x7f;audio/RED&#x7f;text/RED&#x7f;video/SMPTE292M&#x7f;audio/SMV&#x7f;audio/SMV-QCP&#x7f;audio/SMV0&#x7f;audio/UEMCLIP&#x7f;audio/VDVI&#x7f;audio/VMR-WB&#x7f;video/VP8&#x7f;audio/ac3&#x7f;image/aces&#x7f;application/activemessage&#x7f;application/activemessage&#x7f;multipart/alternative&#x7f;application/alto-costmap+json&#x7f;application/alto-costmapfilter+json&#x7f;application/alto-directory+json&#x7f;application/alto-endpointcost+json&#x7f;application/alto-endpointcostparams+json&#x7f;application/alto-endpointprop+json&#x7f;application/alto-endpointpropparams+json&#x7f;application/alto-error+json&#x7f;application/alto-networkmap+json&#x7f;application/alto-networkmapfilter+json&#x7f;audio/amr-wb+&#x7f;application/andrew-inset&#x7f;multipart/appledouble&#x7f;application/applefile&#x7f;audio/aptx&#x7f;audio/asc&#x7f;application/atom+xml&#x7f;application/atomcat+xml&#x7f;application/atomdeleted+xml&#x7f;application/atomicmail&#x7f;application/atomsvc+xml&#x7f;application/auth-policy+xml&#x7f;application/bacnet-xdd+zip&#x7f;audio/basic&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;image/bmp&#x7f;multipart/byteranges&#x7f;text/cache-manifest&#x7f;text/calendar&#x7f;application/calendar+json&#x7f;application/calendar+xml&#x7f;application/call-completion&#x7f;application/cbor&#x7f;application/cccex&#x7f;application/ccmp+xml&#x7f;application/ccxml+xml&#x7f;application/cdmi-capability&#x7f;application/cdmi-container&#x7f;application/cdmi-domain&#x7f;application/cdmi-object&#x7f;application/cdmi-queue&#x7f;application/cdni&#x7f;application/cea-2018+xml&#x7f;application/cellml+xml&#x7f;application/cfw&#x7f;image/cgm&#x7f;audio/clearmode&#x7f;application/clue_info+xml&#x7f;application/cms&#x7f;application/cnrp+xml&#x7f;application/coap-group+json&#x7f;application/coap-payload&#x7f;font/collection&#x7f;application/commonground&#x7f;application/conference-info+xml&#x7f;application/cose&#x7f;application/cose-key&#x7f;application/cose-key-set&#x7f;application/cpl+xml&#x7f;application/csrattrs&#x7f;text/css&#x7f;application/csta+xml&#x7f;text/csv&#x7f;text/csv-schema&#x7f;application/csvm+json&#x7f;application/cybercash&#x7f;application/dash+xml&#x7f;application/dashdelta&#x7f;application/davmount+xml&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;message/delivery-status&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dicom+json&#x7f;application/dicom+xml&#x7f;image/dicom-rle&#x7f;multipart/digest&#x7f;message/disposition-notification&#x7f;audio/dls&#x7f;application/dns&#x7f;text/dns&#x7f;application/dskpp+xml&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;application/dssc+der&#x7f;application/dssc+xml&#x7f;application/dvcs&#x7f;audio/eac3&#x7f;application/ecmascript&#x7f;application/efi&#x7f;image/emf&#x7f;application/emma+xml&#x7f;application/emotionml+xml&#x7f;application/encaprtp&#x7f;audio/encaprtp&#x7f;text/encaprtp&#x7f;video/encaprtp&#x7f;multipart/encrypted&#x7f;text/enriched&#x7f;application/epp+xml&#x7f;application/epub+zip&#x7f;application/eshop&#x7f;application/example&#x7f;audio/example&#x7f;image/example&#x7f;message/example&#x7f;model/example&#x7f;multipart/example&#x7f;text/example&#x7f;video/example&#x7f;application/exi&#x7f;message/external-body&#x7f;application/fastinfoset&#x7f;application/fastsoap&#x7f;application/fdt+xml&#x7f;message/feedback-report&#x7f;application/fhir+xml&#x7f;application/fits&#x7f;image/fits&#x7f;application/font-tdpfr&#x7f;multipart/form-data&#x7f;application/framework-attributes+xml&#x7f;audio/fwdred&#x7f;text/fwdred&#x7f;image/g3fax&#x7f;application/geo+json&#x7f;application/geo+json-seq&#x7f;application/geoxacml+xml&#x7f;image/gif&#x7f;message/global&#x7f;message/global-delivery-status&#x7f;message/global-disposition-notification&#x7f;message/global-headers&#x7f;model/gltf+json&#x7f;model/gltf-binary&#x7f;application/gml+xml&#x7f;text/grammar-ref-list&#x7f;application/gzip&#x7f;multipart/header-set&#x7f;application/held+xml&#x7f;text/html&#x7f;application/http&#x7f;message/http&#x7f;application/hyperstudio&#x7f;audio/iLBC&#x7f;application/ibe-key-request+xml&#x7f;application/ibe-pkg-reply+xml&#x7f;application/ibe-pp-data&#x7f;image/ief&#x7f;application/iges&#x7f;model/iges&#x7f;application/im-iscomposing+xml&#x7f;message/imdn+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/inkml+xml&#x7f;application/iotp&#x7f;audio/ip-mr_v2.5&#x7f;application/ipfix&#x7f;application/ipp&#x7f;video/iso.segment&#x7f;application/isup&#x7f;application/its+xml&#x7f;application/javascript&#x7f;text/jcr-cnd&#x7f;application/jf2feed+json&#x7f;image/jls&#x7f;application/jose&#x7f;application/jose+json&#x7f;image/jp2&#x7f;image/jpeg&#x7f;video/jpeg2000&#x7f;image/jpm&#x7f;image/jpx&#x7f;application/jrd+json&#x7f;application/json&#x7f;application/json-patch+json&#x7f;application/json-seq&#x7f;application/jwk+json&#x7f;application/jwk-set+json&#x7f;application/jwt&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;image/ktx&#x7f;application/ld+json&#x7f;application/lgr+xml&#x7f;application/link-format&#x7f;application/load-control+xml&#x7f;application/lost+xml&#x7f;application/lostsync+xml&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/mads+xml&#x7f;application/marc&#x7f;application/marcxml+xml&#x7f;text/markdown&#x7f;application/mathematica&#x7f;application/mathml+xml&#x7f;application/mathml-content+xml&#x7f;application/mathml-presentation+xml&#x7f;application/mbms-associated-procedure-description+xml&#x7f;application/mbms-deregister+xml&#x7f;application/mbms-envelope+xml&#x7f;application/mbms-msk+xml&#x7f;application/mbms-msk-response+xml&#x7f;application/mbms-protection-description+xml&#x7f;application/mbms-reception-report+xml&#x7f;application/mbms-register+xml&#x7f;application/mbms-register-response+xml&#x7f;application/mbms-schedule+xml&#x7f;application/mbms-user-service-description+xml&#x7f;application/mbox&#x7f;application/media-policy-dataset+xml&#x7f;application/media_control+xml&#x7f;application/mediaservercontrol+xml&#x7f;application/merge-patch+json&#x7f;model/mesh&#x7f;application/metalink4+xml&#x7f;application/mets+xml&#x7f;application/mikey&#x7f;multipart/mixed&#x7f;text/mizar&#x7f;video/mj2&#x7f;application/mmt-usd+xml&#x7f;audio/mobile-xmf&#x7f;application/mods+xml&#x7f;application/moss-keys&#x7f;application/moss-signature&#x7f;application/mosskey-data&#x7f;application/mosskey-request&#x7f;application/mp21&#x7f;application/mp4&#x7f;audio/mp4&#x7f;video/mp4&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;video/mpeg&#x7f;application/mpeg4-generic&#x7f;audio/mpeg4-generic&#x7f;video/mpeg4-generic&#x7f;application/mpeg4-iod&#x7f;application/mpeg4-iod-xmt&#x7f;application/mrb-consumer+xml&#x7f;application/mrb-publish+xml&#x7f;application/msc-ivr+xml&#x7f;application/msc-mixer+xml&#x7f;application/msword&#x7f;application/mud+json&#x7f;multipart/multilingual&#x7f;application/mxf&#x7f;application/n-quads&#x7f;application/n-triples&#x7f;text/n3&#x7f;image/naplps&#x7f;application/nasdata&#x7f;application/news-checkgroups&#x7f;application/news-groupinfo&#x7f;application/news-transmission&#x7f;application/nlsml+xml&#x7f;application/node&#x7f;application/nss&#x7f;video/nv&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/oda&#x7f;application/oebps-package+xml&#x7f;application/ogg&#x7f;audio/ogg&#x7f;video/ogg&#x7f;audio/opus&#x7f;font/otf&#x7f;application/oxps&#x7f;application/p2p-overlay+xml&#x7f;multipart/parallel&#x7f;text/parameters&#x7f;application/parityfec&#x7f;audio/parityfec&#x7f;text/parityfec&#x7f;video/parityfec&#x7f;message/partial&#x7f;application/passport&#x7f;application/patch-ops-error+xml&#x7f;application/pdf&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pidf-diff+xml&#x7f;application/pkcs10&#x7f;application/pkcs12&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkcs8&#x7f;application/pkcs8-encrypted&#x7f;application/pkix-attr-cert&#x7f;application/pkix-cert&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pkixcmp&#x7f;text/plain&#x7f;application/pls+xml&#x7f;image/png&#x7f;application/poc-settings+xml&#x7f;video/pointer&#x7f;application/postscript&#x7f;application/ppsp-tracker+json&#x7f;application/problem+json&#x7f;application/problem+xml&#x7f;application/provenance+xml&#x7f;text/provenance-notation&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;image/prs.btif&#x7f;application/prs.cww&#x7f;text/prs.fallenstein.rst&#x7f;application/prs.hpub+zip&#x7f;text/prs.lines.tag&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;text/prs.prop.logic&#x7f;image/prs.pti&#x7f;application/prs.rdf-xml-crypt&#x7f;audio/prs.sid&#x7f;application/prs.xsf+xml&#x7f;application/pskc+xml&#x7f;image/pwg-raster&#x7f;application/qsig&#x7f;video/quicktime&#x7f;application/raptorfec&#x7f;audio/raptorfec&#x7f;text/raptorfec&#x7f;video/raptorfec&#x7f;video/raw&#x7f;application/rdap+json&#x7f;application/rdf+xml&#x7f;application/reginfo+xml&#x7f;multipart/related&#x7f;application/relax-ng-compact-syntax&#x7f;application/remote-printing&#x7f;multipart/report&#x7f;application/reputon+json&#x7f;application/resource-lists+xml&#x7f;application/resource-lists-diff+xml&#x7f;application/rfc+xml&#x7f;message/rfc822&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;application/riscos&#x7f;application/rlmi+xml&#x7f;application/rls-services+xml&#x7f;application/route-apd+xml&#x7f;application/route-s-tsid+xml&#x7f;application/route-usd+xml&#x7f;application/rpki-ghostbusters&#x7f;application/rpki-manifest&#x7f;application/rpki-publication&#x7f;application/rpki-roa&#x7f;application/rpki-updown&#x7f;application/rtf&#x7f;text/rtf&#x7f;audio/rtp-enc-aescm128&#x7f;text/rtp-enc-aescm128&#x7f;video/rtp-enc-aescm128&#x7f;audio/rtp-midi&#x7f;application/rtploopback&#x7f;audio/rtploopback&#x7f;text/rtploopback&#x7f;video/rtploopback&#x7f;application/rtx&#x7f;audio/rtx&#x7f;text/rtx&#x7f;video/rtx&#x7f;message/s-http&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbml+xml&#x7f;application/scaip+xml&#x7f;application/scim+json&#x7f;application/scvp-cv-request&#x7f;application/scvp-cv-response&#x7f;application/scvp-vp-request&#x7f;application/scvp-vp-response&#x7f;application/sdp&#x7f;application/sep+xml&#x7f;application/sep-exi&#x7f;application/session-info&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;font/sfnt&#x7f;application/sgml&#x7f;text/sgml&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;multipart/signed&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/simpleSymbolContainer&#x7f;message/sip&#x7f;message/sipfrag&#x7f;application/slate&#x7f;application/smil+xml&#x7f;video/smpte291&#x7f;application/smpte336m&#x7f;application/soap+fastinfoset&#x7f;application/soap+xml&#x7f;audio/sp-midi&#x7f;application/sparql-query&#x7f;application/sparql-results+xml&#x7f;audio/speex&#x7f;application/spirits-event+xml&#x7f;application/sql&#x7f;application/srgs&#x7f;application/srgs+xml&#x7f;application/sru+xml&#x7f;application/ssml+xml&#x7f;text/strings&#x7f;image/svg+xml&#x7f;text/t140&#x7f;audio/t140c&#x7f;audio/t38&#x7f;image/t38&#x7f;text/tab-separated-values&#x7f;application/tamp-apex-update&#x7f;application/tamp-apex-update-confirm&#x7f;application/tamp-community-update&#x7f;application/tamp-community-update-confirm&#x7f;application/tamp-error&#x7f;application/tamp-sequence-adjust&#x7f;application/tamp-sequence-adjust-confirm&#x7f;application/tamp-status-query&#x7f;application/tamp-status-response&#x7f;application/tamp-update&#x7f;application/tamp-update-confirm&#x7f;application/tei+xml&#x7f;audio/telephone-event&#x7f;application/thraud+xml&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/timestamped-data&#x7f;application/tnauthlist&#x7f;audio/tone&#x7f;message/tracking-status&#x7f;application/trig&#x7f;text/troff&#x7f;font/ttf&#x7f;application/ttml+xml&#x7f;text/turtle&#x7f;application/tve-trigger&#x7f;application/ulpfec&#x7f;audio/ulpfec&#x7f;text/ulpfec&#x7f;video/ulpfec&#x7f;application/urc-grpsheet+xml&#x7f;application/urc-ressheet+xml&#x7f;application/urc-targetdesc+xml&#x7f;application/urc-uisocketdesc+xml&#x7f;text/uri-list&#x7f;video/vc1&#x7f;text/vcard&#x7f;application/vcard+json&#x7f;application/vcard+xml&#x7f;application/vemmi&#x7f;application/vnd.1000minds.decision-model+xml&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.3gpp-prose+xml&#x7f;application/vnd.3gpp-prose-pc3ch+xml&#x7f;application/vnd.3gpp-v2x-local-service-information&#x7f;application/vnd.3gpp.GMOP+xml&#x7f;application/vnd.3gpp.SRVCC-info+xml&#x7f;application/vnd.3gpp.access-transfer-events+xml&#x7f;application/vnd.3gpp.bsf+xml&#x7f;audio/vnd.3gpp.iufp&#x7f;application/vnd.3gpp.mcptt-affiliation-command+xml&#x7f;application/vnd.3gpp.mcptt-floor-request+xml&#x7f;application/vnd.3gpp.mcptt-info+xml&#x7f;application/vnd.3gpp.mcptt-location-info+xml&#x7f;application/vnd.3gpp.mcptt-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcptt-signed+xml&#x7f;application/vnd.3gpp.mid-call+xml&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.3gpp.sms+xml&#x7f;application/vnd.3gpp.srvcc-ext+xml&#x7f;application/vnd.3gpp.state-and-event-info+xml&#x7f;application/vnd.3gpp.ussd+xml&#x7f;application/vnd.3gpp2.bcmcsinfo+xml&#x7f;application/vnd.3gpp2.sms&#x7f;application/vnd.3gpp2.tcap&#x7f;application/vnd.3lightssoftware.imagescal&#x7f;audio/vnd.4SB&#x7f;video/vnd.CCTV&#x7f;audio/vnd.CELP&#x7f;text/vnd.DMClientScript&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.HandHeld-Entertainment+xml&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.IPTC.NewsML&#x7f;application/vnd.Kinar&#x7f;application/vnd.MFER&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.SimTech-MindMapper&#x7f;text/vnd.a&#x7f;text/vnd.abc&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.flash.movie&#x7f;application/vnd.adobe.formscentral.fcdt&#x7f;application/vnd.adobe.fxp&#x7f;application/vnd.adobe.partial-upload&#x7f;image/vnd.adobe.photoshop&#x7f;application/vnd.adobe.xdp+xml&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.ah-barcode&#x7f;application/vnd.ahead.space&#x7f;image/vnd.airzip.accelerator.azv&#x7f;application/vnd.airzip.filesecure.azf&#x7f;application/vnd.airzip.filesecure.azs&#x7f;application/vnd.amadeus+json&#x7f;application/vnd.amazon.mobi8-ebook&#x7f;application/vnd.americandynamics.acc&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.amundsen.maze+xml&#x7f;application/vnd.anki&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.antix.game-component&#x7f;application/vnd.apache.thrift.binary&#x7f;application/vnd.apache.thrift.compact&#x7f;application/vnd.apache.thrift.json&#x7f;application/vnd.api+json&#x7f;application/vnd.apothekende.reservation+json&#x7f;application/vnd.apple.installer+xml&#x7f;application/vnd.apple.mpegurl&#x7f;application/vnd.aristanetworks.swi&#x7f;application/vnd.artsquare&#x7f;text/vnd.ascii-art&#x7f;application/vnd.astraea-software.iota&#x7f;application/vnd.audiograph&#x7f;audio/vnd.audiokoz&#x7f;application/vnd.autopackage&#x7f;application/vnd.avalon+json&#x7f;application/vnd.avistar+xml&#x7f;application/vnd.balsamiq.bmml+xml&#x7f;application/vnd.balsamiq.bmpr&#x7f;application/vnd.bbf.usp.msg&#x7f;application/vnd.bbf.usp.msg+json&#x7f;application/vnd.bekitzur-stech+json&#x7f;application/vnd.bint.med-content&#x7f;multipart/vnd.bint.med-plus&#x7f;application/vnd.biopax.rdf+xml&#x7f;application/vnd.blink-idb-value-wrapper&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bluetooth.ep.oob&#x7f;application/vnd.bluetooth.le.oob&#x7f;application/vnd.bmi&#x7f;application/vnd.businessobjects&#x7f;application/vnd.cab-jscript&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.capasystems-pg+json&#x7f;application/vnd.cendio.thinlinc.clientconf&#x7f;application/vnd.century-systems.tcp_stream&#x7f;application/vnd.chemdraw+xml&#x7f;application/vnd.chess-pgn&#x7f;application/vnd.chipnuts.karaoke-mmd&#x7f;application/vnd.cinderella&#x7f;application/vnd.cirpack.isdn-ext&#x7f;audio/vnd.cisco.nse&#x7f;application/vnd.citationstyles.style+xml&#x7f;application/vnd.claymore&#x7f;application/vnd.cloanto.rp9&#x7f;application/vnd.clonk.c4group&#x7f;application/vnd.cluetrust.cartomobile-config&#x7f;application/vnd.cluetrust.cartomobile-config-pkg&#x7f;audio/vnd.cmles.radio-events&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;image/vnd.cns.inf2&#x7f;application/vnd.coffeescript&#x7f;application/vnd.collabio.xodocuments.document&#x7f;application/vnd.collabio.xodocuments.document-template&#x7f;application/vnd.collabio.xodocuments.presentation&#x7f;application/vnd.collabio.xodocuments.presentation-template&#x7f;application/vnd.collabio.xodocuments.spreadsheet&#x7f;application/vnd.collabio.xodocuments.spreadsheet-template&#x7f;model/vnd.collada+xml&#x7f;application/vnd.collection+json&#x7f;application/vnd.collection.doc+json&#x7f;application/vnd.collection.next+json&#x7f;application/vnd.comicbook+zip&#x7f;application/vnd.comicbook-rar&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.coreos.ignition+json&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.crick.clicker&#x7f;application/vnd.crick.clicker.keyboard&#x7f;application/vnd.crick.clicker.palette&#x7f;application/vnd.crick.clicker.template&#x7f;application/vnd.crick.clicker.wordbank&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.ctct.ws+xml&#x7f;application/vnd.cups-pdf&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-ppd&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;text/vnd.curl&#x7f;application/vnd.cyan.dean.root+xml&#x7f;application/vnd.cybank&#x7f;application/vnd.d2l.coursepackage1p0+zip&#x7f;application/vnd.dart&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.datapackage+json&#x7f;application/vnd.dataresource+json&#x7f;application/vnd.debian.binary-package&#x7f;text/vnd.debian.copyright&#x7f;audio/vnd.dece.audio&#x7f;application/vnd.dece.data&#x7f;image/vnd.dece.graphic&#x7f;video/vnd.dece.hd&#x7f;video/vnd.dece.mobile&#x7f;video/vnd.dece.mp4&#x7f;video/vnd.dece.pd&#x7f;video/vnd.dece.sd&#x7f;application/vnd.dece.ttml+xml&#x7f;application/vnd.dece.unspecified&#x7f;video/vnd.dece.video&#x7f;application/vnd.dece.zip&#x7f;application/vnd.denovo.fcselayout-link&#x7f;application/vnd.desmume.movie&#x7f;audio/vnd.digital-winds&#x7f;application/vnd.dir-bi.plate-dl-nosuffix&#x7f;video/vnd.directv.mpeg&#x7f;video/vnd.directv.mpeg-tts&#x7f;image/vnd.djvu&#x7f;audio/vnd.dlna.adts&#x7f;video/vnd.dlna.mpeg-tts&#x7f;application/vnd.dm.delegation+xml&#x7f;application/vnd.dna&#x7f;application/vnd.document+json&#x7f;audio/vnd.dolby.heaac.1&#x7f;audio/vnd.dolby.heaac.2&#x7f;audio/vnd.dolby.mlp&#x7f;application/vnd.dolby.mobile.1&#x7f;application/vnd.dolby.mobile.2&#x7f;audio/vnd.dolby.mps&#x7f;audio/vnd.dolby.pl2&#x7f;audio/vnd.dolby.pl2x&#x7f;audio/vnd.dolby.pl2z&#x7f;audio/vnd.dolby.pulse.1&#x7f;application/vnd.doremir.scorecloud-binary-document&#x7f;application/vnd.dpgraph&#x7f;audio/vnd.dra&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.drive+json&#x7f;application/vnd.dtg.local&#x7f;application/vnd.dtg.local.flash&#x7f;application/vnd.dtg.local.html&#x7f;audio/vnd.dts&#x7f;audio/vnd.dts.hd&#x7f;application/vnd.dvb.ait&#x7f;application/vnd.dvb.dvbj&#x7f;application/vnd.dvb.esgcontainer&#x7f;audio/vnd.dvb.file&#x7f;video/vnd.dvb.file&#x7f;application/vnd.dvb.ipdcdftnotifaccess&#x7f;application/vnd.dvb.ipdcesgaccess&#x7f;application/vnd.dvb.ipdcesgaccess2&#x7f;application/vnd.dvb.ipdcesgpdd&#x7f;application/vnd.dvb.ipdcroaming&#x7f;application/vnd.dvb.iptv.alfec-base&#x7f;application/vnd.dvb.iptv.alfec-enhancement&#x7f;application/vnd.dvb.notif-aggregate-root+xml&#x7f;application/vnd.dvb.notif-container+xml&#x7f;application/vnd.dvb.notif-generic+xml&#x7f;application/vnd.dvb.notif-ia-msglist+xml&#x7f;application/vnd.dvb.notif-ia-registration-request+xml&#x7f;application/vnd.dvb.notif-ia-registration-response+xml&#x7f;application/vnd.dvb.notif-init+xml&#x7f;application/vnd.dvb.pfr&#x7f;application/vnd.dvb.service&#x7f;image/vnd.dvb.subtitle&#x7f;text/vnd.dvb.subtitle&#x7f;model/vnd.dwf&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;application/vnd.dxr&#x7f;application/vnd.dynageo&#x7f;application/vnd.dzr&#x7f;application/vnd.easykaraoke.cdgdownload&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecip.rlp&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.efi.img&#x7f;application/vnd.efi.iso&#x7f;application/vnd.emclient.accessrequest+xml&#x7f;application/vnd.enliven&#x7f;application/vnd.enphase.envoy&#x7f;application/vnd.eprints.data+xml&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;application/vnd.espass-espass+zip&#x7f;application/vnd.eszigno3+xml&#x7f;application/vnd.etsi.aoc+xml&#x7f;application/vnd.etsi.asic-e+zip&#x7f;application/vnd.etsi.asic-s+zip&#x7f;application/vnd.etsi.cug+xml&#x7f;application/vnd.etsi.iptvcommand+xml&#x7f;application/vnd.etsi.iptvdiscovery+xml&#x7f;application/vnd.etsi.iptvprofile+xml&#x7f;application/vnd.etsi.iptvsad-bc+xml&#x7f;application/vnd.etsi.iptvsad-cod+xml&#x7f;application/vnd.etsi.iptvsad-npvr+xml&#x7f;application/vnd.etsi.iptvservice+xml&#x7f;application/vnd.etsi.iptvsync+xml&#x7f;application/vnd.etsi.iptvueprofile+xml&#x7f;application/vnd.etsi.mcid+xml&#x7f;application/vnd.etsi.mheg5&#x7f;application/vnd.etsi.overload-control-policy-dataset+xml&#x7f;application/vnd.etsi.pstn+xml&#x7f;application/vnd.etsi.sci+xml&#x7f;application/vnd.etsi.simservs+xml&#x7f;application/vnd.etsi.timestamp-token&#x7f;application/vnd.etsi.tsl+xml&#x7f;application/vnd.etsi.tsl.der&#x7f;application/vnd.eudora.data&#x7f;audio/vnd.everad.plj&#x7f;application/vnd.evolv.ecig.profile&#x7f;application/vnd.evolv.ecig.settings&#x7f;application/vnd.evolv.ecig.theme&#x7f;application/vnd.ezpix-album&#x7f;application/vnd.ezpix-package&#x7f;application/vnd.f-secure.mobile&#x7f;image/vnd.fastbidsheet&#x7f;application/vnd.fastcopy-disk-image&#x7f;application/vnd.fdf&#x7f;application/vnd.fdsn.mseed&#x7f;application/vnd.fdsn.seed&#x7f;application/vnd.ffsns&#x7f;application/vnd.filmit.zfc&#x7f;application/vnd.fints&#x7f;application/vnd.firemonkeys.cloudcell&#x7f;model/vnd.flatland.3dml&#x7f;application/vnd.fluxtime.clip&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;application/vnd.font-fontforge-sfd&#x7f;image/vnd.fpx&#x7f;application/vnd.framemaker&#x7f;application/vnd.frogans.fnc&#x7f;application/vnd.frogans.ltf&#x7f;application/vnd.fsc.weblaunch&#x7f;image/vnd.fst&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ART-EX&#x7f;application/vnd.fujixerox.ART4&#x7f;application/vnd.fujixerox.HBPL&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fujixerox.docuworks.container&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.fuzzysheet&#x7f;video/vnd.fvt&#x7f;model/vnd.gdl&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.geogebra.file&#x7f;application/vnd.geogebra.tool&#x7f;application/vnd.geometry-explorer&#x7f;application/vnd.geonext&#x7f;application/vnd.geoplan&#x7f;application/vnd.geospace&#x7f;application/vnd.gerber&#x7f;image/vnd.globalgraphics.pgb&#x7f;application/vnd.globalplatform.card-content-mgt&#x7f;application/vnd.globalplatform.card-content-mgt-response&#x7f;application/vnd.google-earth.kml+xml&#x7f;application/vnd.google-earth.kmz&#x7f;application/vnd.gov.sk.e-form+xml&#x7f;application/vnd.gov.sk.e-form+zip&#x7f;application/vnd.gov.sk.xmldatacontainer+xml&#x7f;application/vnd.grafeq&#x7f;text/vnd.graphviz&#x7f;application/vnd.gridmp&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;application/vnd.hal+json&#x7f;application/vnd.hal+xml&#x7f;application/vnd.hbci&#x7f;application/vnd.hc+json&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hdt&#x7f;application/vnd.heroku+json&#x7f;application/vnd.hhe.lesson-player&#x7f;audio/vnd.hns.audio&#x7f;video/vnd.hns.video&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.hp-jlyt&#x7f;application/vnd.httphone&#x7f;application/vnd.hydrostatix.sof-data&#x7f;application/vnd.hyper-item+json&#x7f;application/vnd.hyperdrive+json&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.afplinedata&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.modcap&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.iccprofile&#x7f;application/vnd.ieee.1905&#x7f;application/vnd.igloader&#x7f;application/vnd.imagemeter.folder+zip&#x7f;application/vnd.imagemeter.image+zip&#x7f;application/vnd.immervision-ivp&#x7f;application/vnd.immervision-ivu&#x7f;application/vnd.ims.imsccv1p1&#x7f;application/vnd.ims.imsccv1p2&#x7f;application/vnd.ims.imsccv1p3&#x7f;application/vnd.ims.lis.v2.result+json&#x7f;application/vnd.ims.lti.v2.toolconsumerprofile+json&#x7f;application/vnd.ims.lti.v2.toolproxy+json&#x7f;application/vnd.ims.lti.v2.toolproxy.id+json&#x7f;application/vnd.ims.lti.v2.toolsettings+json&#x7f;application/vnd.ims.lti.v2.toolsettings.simple+json&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;application/vnd.informedcontrol.rms+xml&#x7f;application/vnd.infotech.project&#x7f;application/vnd.infotech.project+xml&#x7f;application/vnd.innopath.wamp.notification&#x7f;application/vnd.insors.igm&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intergeo&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.iptc.g2.catalogitem+xml&#x7f;application/vnd.iptc.g2.conceptitem+xml&#x7f;application/vnd.iptc.g2.knowledgeitem+xml&#x7f;application/vnd.iptc.g2.newsitem+xml&#x7f;application/vnd.iptc.g2.newsmessage+xml&#x7f;application/vnd.iptc.g2.packageitem+xml&#x7f;application/vnd.iptc.g2.planningitem+xml&#x7f;video/vnd.iptvforum.1dparityfec-1010&#x7f;video/vnd.iptvforum.1dparityfec-2005&#x7f;video/vnd.iptvforum.2dparityfec-1010&#x7f;video/vnd.iptvforum.2dparityfec-2005&#x7f;video/vnd.iptvforum.ttsavc&#x7f;video/vnd.iptvforum.ttsmpeg2&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.isac.fcs&#x7f;application/vnd.jam&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jcp.javame.midlet-rms&#x7f;application/vnd.jisp&#x7f;application/vnd.joost.joda-archive&#x7f;application/vnd.jsk.isdn-ngn&#x7f;application/vnd.kahootz&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.koan&#x7f;application/vnd.kodak-descriptor&#x7f;application/vnd.las.las+json&#x7f;application/vnd.las.las+xml&#x7f;text/vnd.latex-z&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;audio/vnd.lucent.voice&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.mapbox-vector-tile&#x7f;application/vnd.marlin.drm.actiontoken+xml&#x7f;application/vnd.marlin.drm.conftoken+xml&#x7f;application/vnd.marlin.drm.license+xml&#x7f;application/vnd.marlin.drm.mdcf&#x7f;application/vnd.mason+json&#x7f;application/vnd.maxmind.maxmind-db&#x7f;application/vnd.mcd&#x7f;application/vnd.medcalcdata&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.mfmp&#x7f;application/vnd.micro+json&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;image/vnd.microsoft.icon&#x7f;application/vnd.microsoft.portable-executable&#x7f;application/vnd.microsoft.windows.thumbnail-cache&#x7f;application/vnd.miele+json&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;image/vnd.mix&#x7f;model/vnd.moml+xml&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.motorola.iprm&#x7f;text/vnd.motorola.reflex&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;image/vnd.mozilla.apng&#x7f;application/vnd.mozilla.xul+xml&#x7f;video/vnd.mpegurl&#x7f;application/vnd.ms-3mfdocument&#x7f;application/vnd.ms-PrintDeviceCapabilities+xml&#x7f;application/vnd.ms-PrintSchemaTicket+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-cab-compressed&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-excel.addin.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.binary.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.macroEnabled.12&#x7f;application/vnd.ms-excel.template.macroEnabled.12&#x7f;application/vnd.ms-fontobject&#x7f;application/vnd.ms-htmlhelp&#x7f;application/vnd.ms-ims&#x7f;application/vnd.ms-lrm&#x7f;text/vnd.ms-mediapackage&#x7f;image/vnd.ms-modi&#x7f;application/vnd.ms-office.activeX+xml&#x7f;application/vnd.ms-officetheme&#x7f;application/vnd.ms-playready.initiator+xml&#x7f;audio/vnd.ms-playready.media.pya&#x7f;video/vnd.ms-playready.media.pyv&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-powerpoint.addin.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.presentation.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slide.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slideshow.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.template.macroEnabled.12&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-windows.devicepairing&#x7f;application/vnd.ms-windows.nwprinting.oob&#x7f;application/vnd.ms-windows.printerpairing&#x7f;application/vnd.ms-windows.wsd.oob&#x7f;application/vnd.ms-wmdrm.lic-chlg-req&#x7f;application/vnd.ms-wmdrm.lic-resp&#x7f;application/vnd.ms-wmdrm.meter-chlg-req&#x7f;application/vnd.ms-wmdrm.meter-resp&#x7f;application/vnd.ms-word.document.macroEnabled.12&#x7f;application/vnd.ms-word.template.macroEnabled.12&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.ms-xpsdocument&#x7f;application/vnd.msa-disk-image&#x7f;application/vnd.mseq&#x7f;application/vnd.msign&#x7f;model/vnd.mts&#x7f;application/vnd.multiad.creator&#x7f;application/vnd.multiad.creator.cif&#x7f;application/vnd.music-niff&#x7f;application/vnd.musician&#x7f;application/vnd.muvee.style&#x7f;application/vnd.mynfc&#x7f;application/vnd.ncd.control&#x7f;application/vnd.ncd.reference&#x7f;application/vnd.nearst.inv+json&#x7f;application/vnd.nervana&#x7f;image/vnd.net-fpx&#x7f;text/vnd.net2phone.commcenter.command&#x7f;application/vnd.netfpx&#x7f;application/vnd.neurolanguage.nlu&#x7f;application/vnd.nintendo.nitro.rom&#x7f;application/vnd.nintendo.snes.rom&#x7f;application/vnd.nitf&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.catalogs&#x7f;application/vnd.nokia.conml+wbxml&#x7f;application/vnd.nokia.conml+xml&#x7f;application/vnd.nokia.iSDS-radio-presets&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;application/vnd.nokia.iptv.config+xml&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;video/vnd.nokia.mp4vr&#x7f;application/vnd.nokia.n-gage.ac+xml&#x7f;application/vnd.nokia.n-gage.data&#x7f;application/vnd.nokia.ncd&#x7f;application/vnd.nokia.pcd+wbxml&#x7f;application/vnd.nokia.pcd+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;video/vnd.nokia.videovoip&#x7f;audio/vnd.nortel.vbk&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.ntt-local.content-share&#x7f;application/vnd.ntt-local.file-transfer&#x7f;application/vnd.ntt-local.ogw_remote-access&#x7f;application/vnd.ntt-local.sip-ta_remote&#x7f;application/vnd.ntt-local.sip-ta_tcp_stream&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;application/vnd.oasis.opendocument.chart&#x7f;application/vnd.oasis.opendocument.chart-template&#x7f;application/vnd.oasis.opendocument.database&#x7f;application/vnd.oasis.opendocument.formula&#x7f;application/vnd.oasis.opendocument.formula-template&#x7f;application/vnd.oasis.opendocument.graphics&#x7f;application/vnd.oasis.opendocument.graphics-template&#x7f;application/vnd.oasis.opendocument.image&#x7f;application/vnd.oasis.opendocument.image-template&#x7f;application/vnd.oasis.opendocument.presentation&#x7f;application/vnd.oasis.opendocument.presentation-template&#x7f;application/vnd.oasis.opendocument.spreadsheet&#x7f;application/vnd.oasis.opendocument.spreadsheet-template&#x7f;application/vnd.oasis.opendocument.text&#x7f;application/vnd.oasis.opendocument.text-master&#x7f;application/vnd.oasis.opendocument.text-template&#x7f;application/vnd.oasis.opendocument.text-web&#x7f;video/vnd.objectvideo&#x7f;application/vnd.obn&#x7f;application/vnd.ocf+cbor&#x7f;audio/vnd.octel.sbc&#x7f;application/vnd.oftn.l10n+json&#x7f;application/vnd.oipf.contentaccessdownload+xml&#x7f;application/vnd.oipf.contentaccessstreaming+xml&#x7f;application/vnd.oipf.cspg-hexbinary&#x7f;application/vnd.oipf.dae.svg+xml&#x7f;application/vnd.oipf.dae.xhtml+xml&#x7f;application/vnd.oipf.mippvcontrolmessage+xml&#x7f;application/vnd.oipf.pae.gem&#x7f;application/vnd.oipf.spdiscovery+xml&#x7f;application/vnd.oipf.spdlist+xml&#x7f;application/vnd.oipf.ueprofile+xml&#x7f;application/vnd.oipf.userprofile+xml&#x7f;application/vnd.olpc-sugar&#x7f;application/vnd.oma-scws-config&#x7f;application/vnd.oma-scws-http-request&#x7f;application/vnd.oma-scws-http-response&#x7f;application/vnd.oma.bcast.associated-procedure-parameter+xml&#x7f;application/vnd.oma.bcast.drm-trigger+xml&#x7f;application/vnd.oma.bcast.imd+xml&#x7f;application/vnd.oma.bcast.ltkm&#x7f;application/vnd.oma.bcast.notification+xml&#x7f;application/vnd.oma.bcast.provisioningtrigger&#x7f;application/vnd.oma.bcast.sgboot&#x7f;application/vnd.oma.bcast.sgdd+xml&#x7f;application/vnd.oma.bcast.sgdu&#x7f;application/vnd.oma.bcast.simple-symbol-container&#x7f;application/vnd.oma.bcast.smartcard-trigger+xml&#x7f;application/vnd.oma.bcast.sprov+xml&#x7f;application/vnd.oma.bcast.stkm&#x7f;application/vnd.oma.cab-address-book+xml&#x7f;application/vnd.oma.cab-feature-handler+xml&#x7f;application/vnd.oma.cab-pcc+xml&#x7f;application/vnd.oma.cab-subs-invite+xml&#x7f;application/vnd.oma.cab-user-prefs+xml&#x7f;application/vnd.oma.dcd&#x7f;application/vnd.oma.dcdc&#x7f;application/vnd.oma.dd2+xml&#x7f;application/vnd.oma.drm.risd+xml&#x7f;application/vnd.oma.group-usage-list+xml&#x7f;application/vnd.oma.lwm2m+json&#x7f;application/vnd.oma.lwm2m+tlv&#x7f;application/vnd.oma.pal+xml&#x7f;application/vnd.oma.poc.detailed-progress-report+xml&#x7f;application/vnd.oma.poc.final-report+xml&#x7f;application/vnd.oma.poc.groups+xml&#x7f;application/vnd.oma.poc.invocation-descriptor+xml&#x7f;application/vnd.oma.poc.optimized-progress-report+xml&#x7f;application/vnd.oma.push&#x7f;application/vnd.oma.scidm.messages+xml&#x7f;application/vnd.oma.xcap-directory+xml&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.omaloc-supl-init&#x7f;application/vnd.onepager&#x7f;application/vnd.onepagertamp&#x7f;application/vnd.onepagertamx&#x7f;application/vnd.onepagertat&#x7f;application/vnd.onepagertatp&#x7f;application/vnd.onepagertatx&#x7f;application/vnd.openblox.game+xml&#x7f;application/vnd.openblox.game-binary&#x7f;application/vnd.openeye.oeb&#x7f;model/vnd.opengex&#x7f;application/vnd.openstreetmap.data+xml&#x7f;application/vnd.openxmlformats-officedocument.custom-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.customXmlProperties+xml&#x7f;application/vnd.openxmlformats-officedocument.drawing+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chart+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml&#x7f;application/vnd.openxmlformats-officedocument.extended-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presProps+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tags+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml&#x7f;application/vnd.openxmlformats-officedocument.theme+xml&#x7f;application/vnd.openxmlformats-officedocument.themeOverride+xml&#x7f;application/vnd.openxmlformats-officedocument.vmlDrawing&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml&#x7f;application/vnd.openxmlformats-package.core-properties+xml&#x7f;application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml&#x7f;application/vnd.openxmlformats-package.relationships+xml&#x7f;application/vnd.oracle.resource+json&#x7f;application/vnd.orange.indata&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.osgeo.mapguide.package&#x7f;application/vnd.osgi.bundle&#x7f;application/vnd.osgi.dp&#x7f;application/vnd.osgi.subsystem&#x7f;application/vnd.otps.ct-kip+xml&#x7f;application/vnd.oxli.countgraph&#x7f;application/vnd.pagerduty+json&#x7f;application/vnd.palm&#x7f;application/vnd.panoply&#x7f;application/vnd.paos.xml&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;application/vnd.patentdive&#x7f;application/vnd.pawaafile&#x7f;application/vnd.pcos&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.piaccess.application-licence&#x7f;application/vnd.picsel&#x7f;application/vnd.pmi.widget&#x7f;application/vnd.poc.group-advertisement+xml&#x7f;application/vnd.pocketlearn&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.preminet&#x7f;audio/vnd.presonus.multitrack&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.proteus.magazine&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.qualcomm.brew-app-res&#x7f;application/vnd.quarantainenet&#x7f;application/vnd.quobject-quoxdocument&#x7f;video/vnd.radgamettools.bink&#x7f;video/vnd.radgamettools.smacker&#x7f;image/vnd.radiance&#x7f;application/vnd.radisys.moml+xml&#x7f;application/vnd.radisys.msml+xml&#x7f;application/vnd.radisys.msml-audit+xml&#x7f;application/vnd.radisys.msml-audit-conf+xml&#x7f;application/vnd.radisys.msml-audit-conn+xml&#x7f;application/vnd.radisys.msml-audit-dialog+xml&#x7f;application/vnd.radisys.msml-audit-stream+xml&#x7f;text/vnd.radisys.msml-basic-layout&#x7f;application/vnd.radisys.msml-conf+xml&#x7f;application/vnd.radisys.msml-dialog+xml&#x7f;application/vnd.radisys.msml-dialog-base+xml&#x7f;application/vnd.radisys.msml-dialog-fax-detect+xml&#x7f;application/vnd.radisys.msml-dialog-fax-sendrecv+xml&#x7f;application/vnd.radisys.msml-dialog-group+xml&#x7f;application/vnd.radisys.msml-dialog-speech+xml&#x7f;application/vnd.radisys.msml-dialog-transform+xml&#x7f;application/vnd.rainstor.data&#x7f;application/vnd.rapid&#x7f;application/vnd.rar&#x7f;application/vnd.realvnc.bed&#x7f;application/vnd.recordare.musicxml&#x7f;application/vnd.recordare.musicxml+xml&#x7f;application/vnd.restful+json&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;application/vnd.rig.cryptonote&#x7f;audio/vnd.rip&#x7f;model/vnd.rosette.annotated-data-model&#x7f;application/vnd.route66.link66+xml&#x7f;application/vnd.rs-274x&#x7f;application/vnd.ruckus.download&#x7f;application/vnd.s3sms&#x7f;application/vnd.sailingtracker.track&#x7f;application/vnd.sbm.cid&#x7f;application/vnd.sbm.mid2&#x7f;application/vnd.scribus&#x7f;application/vnd.sealed.3df&#x7f;application/vnd.sealed.csf&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;application/vnd.sealed.net&#x7f;image/vnd.sealed.png&#x7f;application/vnd.sealed.ppt&#x7f;video/vnd.sealed.swf&#x7f;application/vnd.sealed.tiff&#x7f;application/vnd.sealed.xls&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.sema&#x7f;application/vnd.semd&#x7f;application/vnd.semf&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.sigrok.session&#x7f;application/vnd.siren+json&#x7f;application/vnd.smaf&#x7f;application/vnd.smart.notebook&#x7f;application/vnd.smart.teacher&#x7f;application/vnd.software602.filler.form+xml&#x7f;application/vnd.software602.filler.form-xml-zip&#x7f;application/vnd.solent.sdkm+xml&#x7f;application/vnd.spotfire.dxp&#x7f;application/vnd.spotfire.sfs&#x7f;application/vnd.sqlite3&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.stepmania.package&#x7f;application/vnd.stepmania.stepchart&#x7f;application/vnd.street-stream&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;application/vnd.sun.wadl+xml&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;image/vnd.svf&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml+xml&#x7f;application/vnd.syncml.dm+wbxml&#x7f;application/vnd.syncml.dm+xml&#x7f;application/vnd.syncml.dm.notification&#x7f;application/vnd.syncml.dmddf+wbxml&#x7f;application/vnd.syncml.dmddf+xml&#x7f;application/vnd.syncml.dmtnds+wbxml&#x7f;application/vnd.syncml.dmtnds+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.tableschema+json&#x7f;application/vnd.tao.intent-module-archive&#x7f;application/vnd.tcpdump.pcap&#x7f;image/vnd.tencent.tap&#x7f;application/vnd.tmd.mediaflex.api+xml&#x7f;application/vnd.tml&#x7f;application/vnd.tmobile-livetv&#x7f;application/vnd.tri.onesource&#x7f;application/vnd.trid.tpt&#x7f;application/vnd.triscape.mxs&#x7f;text/vnd.trolltech.linguist&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ubisoft.webplayer&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.umajin&#x7f;application/vnd.unity&#x7f;application/vnd.uoml+xml&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.uri-map&#x7f;video/vnd.uvvu.mp4&#x7f;model/vnd.valve.source.compiled-map&#x7f;application/vnd.valve.source.material&#x7f;image/vnd.valve.source.texture&#x7f;application/vnd.vcx&#x7f;application/vnd.vd-study&#x7f;application/vnd.vectorworks&#x7f;application/vnd.vel+json&#x7f;application/vnd.verimatrix.vcas&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;video/vnd.vivo&#x7f;audio/vnd.vmx.cvsd&#x7f;application/vnd.vsf&#x7f;model/vnd.vtu&#x7f;text/vnd.wap.si&#x7f;application/vnd.wap.sic&#x7f;text/vnd.wap.sl&#x7f;application/vnd.wap.slc&#x7f;image/vnd.wap.wbmp&#x7f;application/vnd.wap.wbxml&#x7f;text/vnd.wap.wml&#x7f;application/vnd.wap.wmlc&#x7f;text/vnd.wap.wmlscript&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wfa.p2p&#x7f;application/vnd.wfa.wsc&#x7f;message/vnd.wfa.wsc&#x7f;application/vnd.windows.devicepairing&#x7f;application/vnd.wmc&#x7f;application/vnd.wmf.bootstrap&#x7f;application/vnd.wolfram.mathematica&#x7f;application/vnd.wolfram.mathematica.package&#x7f;application/vnd.wolfram.player&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xacml+json&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.xfdl.webform&#x7f;image/vnd.xiff&#x7f;application/vnd.xmi+xml&#x7f;application/vnd.xmpie.cpkg&#x7f;application/vnd.xmpie.dpkg&#x7f;application/vnd.xmpie.plan&#x7f;application/vnd.xmpie.ppkg&#x7f;application/vnd.xmpie.xlim&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.openscoreformat&#x7f;application/vnd.yamaha.openscoreformat.osfpvg+xml&#x7f;application/vnd.yamaha.remote-setup&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yamaha.through-ngn&#x7f;application/vnd.yamaha.tunnel-udpencap&#x7f;application/vnd.yaoweme&#x7f;application/vnd.yellowriver-custom-menu&#x7f;application/vnd.youtube.yt&#x7f;image/vnd.zbrush.pcx&#x7f;application/vnd.zul&#x7f;application/vnd.zzazz.deck+xml&#x7f;multipart/voice-message&#x7f;application/voicexml+xml&#x7f;audio/vorbis&#x7f;audio/vorbis-config&#x7f;application/voucher-cms+json&#x7f;application/vq-rtcpxr&#x7f;model/vrml&#x7f;application/watcherinfo+xml&#x7f;application/webpush-options+json&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/widget&#x7f;application/wita&#x7f;image/wmf&#x7f;font/woff&#x7f;font/woff2&#x7f;application/wordperfect5.1&#x7f;application/wsdl+xml&#x7f;application/wspolicy+xml&#x7f;multipart/x-mixed-replace&#x7f;application/x-www-form-urlencoded&#x7f;model/x3d+fastinfoset&#x7f;model/x3d+xml&#x7f;model/x3d-vrml&#x7f;application/x400-bp&#x7f;application/xacml+xml&#x7f;application/xcap-att+xml&#x7f;application/xcap-caps+xml&#x7f;application/xcap-diff+xml&#x7f;application/xcap-el+xml&#x7f;application/xcap-error+xml&#x7f;application/xcap-ns+xml&#x7f;application/xcon-conference-info+xml&#x7f;application/xcon-conference-info-diff+xml&#x7f;application/xenc+xml&#x7f;application/xhtml+xml&#x7f;application/xml&#x7f;text/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;text/xml-external-parsed-entity&#x7f;application/xml-patch+xml&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/xslt+xml&#x7f;application/xv+xml&#x7f;application/yang&#x7f;application/yang-data+json&#x7f;application/yang-data+xml&#x7f;application/yang-patch+json&#x7f;application/yang-patch+xml&#x7f;application/yin+xml&#x7f;application/zip&#x7f;application/zlib&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( contains('&#x7f;application/1d-interleaved-parityfec&#x7f;audio/1d-interleaved-parityfec&#x7f;text/1d-interleaved-parityfec&#x7f;video/1d-interleaved-parityfec&#x7f;audio/32kadpcm&#x7f;application/3gpdash-qoe-report+xml&#x7f;audio/3gpp&#x7f;video/3gpp&#x7f;application/3gpp-ims+xml&#x7f;video/3gpp-tt&#x7f;audio/3gpp2&#x7f;video/3gpp2&#x7f;model/3mf&#x7f;application/A2L&#x7f;application/AML&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;application/ATF&#x7f;application/ATFX&#x7f;audio/ATRAC-ADVANCED-LOSSLESS&#x7f;audio/ATRAC-X&#x7f;audio/ATRAC3&#x7f;application/ATXML&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;application/CALS-1840&#x7f;application/CDFX+XML&#x7f;application/CEA&#x7f;audio/CN&#x7f;message/CPIM&#x7f;application/CSTAdata+xml&#x7f;video/CelB&#x7f;audio/DAT12&#x7f;application/DCD&#x7f;application/DII&#x7f;application/DIT&#x7f;audio/DV&#x7f;video/DV&#x7f;audio/DVI4&#x7f;application/EDI-X12&#x7f;application/EDI-consent&#x7f;application/EDIFACT&#x7f;audio/EVRC&#x7f;audio/EVRC-QCP&#x7f;audio/EVRC0&#x7f;audio/EVRC1&#x7f;audio/EVRCB&#x7f;audio/EVRCB0&#x7f;audio/EVRCB1&#x7f;audio/EVRCNW&#x7f;audio/EVRCNW0&#x7f;audio/EVRCNW1&#x7f;audio/EVRCWB&#x7f;audio/EVRCWB0&#x7f;audio/EVRCWB1&#x7f;audio/EVS&#x7f;application/EmergencyCallData.Comment+xml&#x7f;application/EmergencyCallData.Control+xml&#x7f;application/EmergencyCallData.DeviceInfo+xml&#x7f;application/EmergencyCallData.ProviderInfo+xml&#x7f;application/EmergencyCallData.ServiceInfo+xml&#x7f;application/EmergencyCallData.SubscriberInfo+xml&#x7f;application/EmergencyCallData.VEDS+xml&#x7f;application/EmergencyCallData.eCall.MSD&#x7f;audio/G711-0&#x7f;audio/G719&#x7f;audio/G722&#x7f;audio/G7221&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G7291&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/GSM-HR-08&#x7f;application/H224&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/H264-RCDO&#x7f;video/H264-SVC&#x7f;video/H265&#x7f;application/IOTP&#x7f;application/ISUP&#x7f;video/JPEG&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/L8&#x7f;audio/LPC&#x7f;application/LXF&#x7f;audio/MELP&#x7f;audio/MELP1200&#x7f;audio/MELP2400&#x7f;audio/MELP600&#x7f;application/MF4&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;audio/MP4A-LATM&#x7f;video/MP4V-ES&#x7f;audio/MPA&#x7f;video/MPV&#x7f;application/ODA&#x7f;application/ODX&#x7f;audio/PCMA&#x7f;audio/PCMA-WB&#x7f;audio/PCMU&#x7f;audio/PCMU-WB&#x7f;application/PDX&#x7f;audio/QCELP&#x7f;application/QSIG&#x7f;audio/RED&#x7f;text/RED&#x7f;application/SGML&#x7f;text/SGML&#x7f;video/SMPTE292M&#x7f;audio/SMV&#x7f;audio/SMV-QCP&#x7f;audio/SMV0&#x7f;audio/TETRA_ACELP&#x7f;audio/TETRA_ACELP_BB&#x7f;application/TETRA_ISI&#x7f;audio/UEMCLIP&#x7f;audio/VDVI&#x7f;audio/VMR-WB&#x7f;video/VP8&#x7f;audio/aac&#x7f;audio/ac3&#x7f;image/aces&#x7f;application/activemessage&#x7f;application/activity+json&#x7f;multipart/alternative&#x7f;application/alto-costmap+json&#x7f;application/alto-costmapfilter+json&#x7f;application/alto-directory+json&#x7f;application/alto-endpointcost+json&#x7f;application/alto-endpointcostparams+json&#x7f;application/alto-endpointprop+json&#x7f;application/alto-endpointpropparams+json&#x7f;application/alto-error+json&#x7f;application/alto-networkmap+json&#x7f;application/alto-networkmapfilter+json&#x7f;application/alto-updatestreamcontrol+json&#x7f;application/alto-updatestreamparams+json&#x7f;audio/amr-wb+&#x7f;application/andrew-inset&#x7f;multipart/appledouble&#x7f;application/applefile&#x7f;audio/aptx&#x7f;audio/asc&#x7f;application/atom+xml&#x7f;application/atomcat+xml&#x7f;application/atomdeleted+xml&#x7f;application/atomicmail&#x7f;application/atomsvc+xml&#x7f;application/atsc-dwd+xml&#x7f;application/atsc-dynamic-event-message&#x7f;application/atsc-held+xml&#x7f;application/atsc-rdt+json&#x7f;application/atsc-rsat+xml&#x7f;application/auth-policy+xml&#x7f;image/avci&#x7f;image/avcs&#x7f;application/bacnet-xdd+zip&#x7f;audio/basic&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;image/bmp&#x7f;multipart/byteranges&#x7f;text/cache-manifest&#x7f;text/calendar&#x7f;application/calendar+json&#x7f;application/calendar+xml&#x7f;application/call-completion&#x7f;application/cap+xml&#x7f;application/cbor&#x7f;application/cbor-seq&#x7f;application/cccex&#x7f;application/ccmp+xml&#x7f;application/ccxml+xml&#x7f;application/cdmi-capability&#x7f;application/cdmi-container&#x7f;application/cdmi-domain&#x7f;application/cdmi-object&#x7f;application/cdmi-queue&#x7f;application/cdni&#x7f;application/cea-2018+xml&#x7f;application/cellml+xml&#x7f;application/cfw&#x7f;image/cgm&#x7f;audio/clearmode&#x7f;application/clue+xml&#x7f;application/clue_info+xml&#x7f;application/cms&#x7f;application/cnrp+xml&#x7f;application/coap-group+json&#x7f;application/coap-payload&#x7f;font/collection&#x7f;application/commonground&#x7f;application/conference-info+xml&#x7f;application/cose&#x7f;application/cose-key&#x7f;application/cose-key-set&#x7f;application/cpl+xml&#x7f;application/csrattrs&#x7f;text/css&#x7f;application/csta+xml&#x7f;text/csv&#x7f;text/csv-schema&#x7f;application/csvm+json&#x7f;application/cwt&#x7f;application/cybercash&#x7f;application/dash+xml&#x7f;application/dashdelta&#x7f;application/davmount+xml&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;message/delivery-status&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dicom+json&#x7f;application/dicom+xml&#x7f;image/dicom-rle&#x7f;multipart/digest&#x7f;message/disposition-notification&#x7f;audio/dls&#x7f;application/dns&#x7f;text/dns&#x7f;application/dns+json&#x7f;application/dns-message&#x7f;application/dots+cbor&#x7f;application/dskpp+xml&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;application/dssc+der&#x7f;application/dssc+xml&#x7f;application/dvcs&#x7f;audio/eac3&#x7f;application/ecmascript&#x7f;application/efi&#x7f;image/emf&#x7f;application/emma+xml&#x7f;application/emotionml+xml&#x7f;application/encaprtp&#x7f;audio/encaprtp&#x7f;text/encaprtp&#x7f;video/encaprtp&#x7f;multipart/encrypted&#x7f;text/enriched&#x7f;application/epp+xml&#x7f;application/epub+zip&#x7f;application/eshop&#x7f;application/example&#x7f;audio/example&#x7f;image/example&#x7f;message/example&#x7f;model/example&#x7f;multipart/example&#x7f;text/example&#x7f;video/example&#x7f;application/exi&#x7f;application/expect-ct-report+json&#x7f;message/external-body&#x7f;application/fastinfoset&#x7f;application/fastsoap&#x7f;application/fdt+xml&#x7f;message/feedback-report&#x7f;application/fhir+json&#x7f;application/fhir+xml&#x7f;application/fits&#x7f;image/fits&#x7f;application/flexfec&#x7f;audio/flexfec&#x7f;text/flexfec&#x7f;video/flexfec&#x7f;application/font-tdpfr&#x7f;multipart/form-data&#x7f;application/framework-attributes+xml&#x7f;audio/fwdred&#x7f;text/fwdred&#x7f;image/g3fax&#x7f;application/geo+json&#x7f;application/geo+json-seq&#x7f;application/geopackage+sqlite3&#x7f;application/geoxacml+xml&#x7f;image/gif&#x7f;message/global&#x7f;message/global-delivery-status&#x7f;message/global-disposition-notification&#x7f;message/global-headers&#x7f;model/gltf+json&#x7f;model/gltf-binary&#x7f;application/gltf-buffer&#x7f;application/gml+xml&#x7f;text/grammar-ref-list&#x7f;application/gzip&#x7f;multipart/header-set&#x7f;image/heic&#x7f;image/heic-sequence&#x7f;image/heif&#x7f;image/heif-sequence&#x7f;image/hej2k&#x7f;application/held+xml&#x7f;image/hsj2&#x7f;text/html&#x7f;application/http&#x7f;message/http&#x7f;application/hyperstudio&#x7f;audio/iLBC&#x7f;application/ibe-key-request+xml&#x7f;application/ibe-pkg-reply+xml&#x7f;application/ibe-pp-data&#x7f;image/ief&#x7f;application/iges&#x7f;model/iges&#x7f;application/im-iscomposing+xml&#x7f;message/imdn+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/inkml+xml&#x7f;audio/ip-mr_v2.5&#x7f;application/ipfix&#x7f;application/ipp&#x7f;video/iso.segment&#x7f;application/its+xml&#x7f;application/javascript&#x7f;text/jcr-cnd&#x7f;application/jf2feed+json&#x7f;image/jls&#x7f;application/jose&#x7f;application/jose+json&#x7f;image/jp2&#x7f;image/jpeg&#x7f;video/jpeg2000&#x7f;image/jph&#x7f;image/jphc&#x7f;image/jpm&#x7f;image/jpx&#x7f;application/jrd+json&#x7f;application/json&#x7f;application/json-patch+json&#x7f;application/json-seq&#x7f;application/jwk+json&#x7f;application/jwk-set+json&#x7f;application/jwt&#x7f;image/jxr&#x7f;image/jxrA&#x7f;image/jxrS&#x7f;image/jxs&#x7f;image/jxsc&#x7f;image/jxsi&#x7f;image/jxss&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;image/ktx&#x7f;application/ld+json&#x7f;application/lgr+xml&#x7f;application/link-format&#x7f;application/load-control+xml&#x7f;application/lost+xml&#x7f;application/lostsync+xml&#x7f;application/lpf+zip&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/mads+xml&#x7f;application/marc&#x7f;application/marcxml+xml&#x7f;text/markdown&#x7f;application/mathematica&#x7f;application/mathml+xml&#x7f;application/mathml-content+xml&#x7f;application/mathml-presentation+xml&#x7f;application/mbms-associated-procedure-description+xml&#x7f;application/mbms-deregister+xml&#x7f;application/mbms-envelope+xml&#x7f;application/mbms-msk+xml&#x7f;application/mbms-msk-response+xml&#x7f;application/mbms-protection-description+xml&#x7f;application/mbms-reception-report+xml&#x7f;application/mbms-register+xml&#x7f;application/mbms-register-response+xml&#x7f;application/mbms-schedule+xml&#x7f;application/mbms-user-service-description+xml&#x7f;application/mbox&#x7f;application/media-policy-dataset+xml&#x7f;application/media_control+xml&#x7f;application/mediaservercontrol+xml&#x7f;application/merge-patch+json&#x7f;model/mesh&#x7f;application/metalink4+xml&#x7f;application/mets+xml&#x7f;audio/mhas&#x7f;application/mikey&#x7f;application/mipc&#x7f;multipart/mixed&#x7f;text/mizar&#x7f;video/mj2&#x7f;application/mmt-aei+xml&#x7f;application/mmt-usd+xml&#x7f;audio/mobile-xmf&#x7f;application/mods+xml&#x7f;application/moss-keys&#x7f;application/moss-signature&#x7f;application/mosskey-data&#x7f;application/mosskey-request&#x7f;application/mp21&#x7f;application/mp4&#x7f;audio/mp4&#x7f;video/mp4&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;video/mpeg&#x7f;application/mpeg4-generic&#x7f;audio/mpeg4-generic&#x7f;video/mpeg4-generic&#x7f;application/mpeg4-iod&#x7f;application/mpeg4-iod-xmt&#x7f;application/mrb-consumer+xml&#x7f;application/mrb-publish+xml&#x7f;application/msc-ivr+xml&#x7f;application/msc-mixer+xml&#x7f;application/msword&#x7f;model/mtl&#x7f;application/mud+json&#x7f;multipart/multilingual&#x7f;application/multipart-core&#x7f;application/mxf&#x7f;application/n-quads&#x7f;application/n-triples&#x7f;text/n3&#x7f;image/naplps&#x7f;application/nasdata&#x7f;application/news-checkgroups&#x7f;application/news-groupinfo&#x7f;application/news-transmission&#x7f;application/nlsml+xml&#x7f;application/node&#x7f;application/nss&#x7f;video/nv&#x7f;model/obj&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/odm+xml&#x7f;application/oebps-package+xml&#x7f;application/ogg&#x7f;audio/ogg&#x7f;video/ogg&#x7f;audio/opus&#x7f;application/oscore&#x7f;font/otf&#x7f;application/oxps&#x7f;application/p2p-overlay+xml&#x7f;multipart/parallel&#x7f;text/parameters&#x7f;application/parityfec&#x7f;audio/parityfec&#x7f;text/parityfec&#x7f;video/parityfec&#x7f;message/partial&#x7f;application/passport&#x7f;application/patch-ops-error+xml&#x7f;application/pdf&#x7f;application/pem-certificate-chain&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pidf-diff+xml&#x7f;application/pkcs10&#x7f;application/pkcs12&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkcs8&#x7f;application/pkcs8-encrypted&#x7f;application/pkix-attr-cert&#x7f;application/pkix-cert&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pkixcmp&#x7f;text/plain&#x7f;application/pls+xml&#x7f;image/png&#x7f;application/poc-settings+xml&#x7f;video/pointer&#x7f;application/postscript&#x7f;application/ppsp-tracker+json&#x7f;application/problem+json&#x7f;application/problem+xml&#x7f;application/provenance+xml&#x7f;text/provenance-notation&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;image/prs.btif&#x7f;application/prs.cww&#x7f;text/prs.fallenstein.rst&#x7f;application/prs.hpub+zip&#x7f;text/prs.lines.tag&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;text/prs.prop.logic&#x7f;image/prs.pti&#x7f;application/prs.rdf-xml-crypt&#x7f;audio/prs.sid&#x7f;application/prs.xsf+xml&#x7f;application/pskc+xml&#x7f;application/pvd+json&#x7f;image/pwg-raster&#x7f;video/quicktime&#x7f;application/raptorfec&#x7f;audio/raptorfec&#x7f;text/raptorfec&#x7f;video/raptorfec&#x7f;video/raw&#x7f;application/rdap+json&#x7f;application/rdf+xml&#x7f;application/reginfo+xml&#x7f;multipart/related&#x7f;application/relax-ng-compact-syntax&#x7f;application/remote-printing&#x7f;multipart/report&#x7f;application/reputon+json&#x7f;application/resource-lists+xml&#x7f;application/resource-lists-diff+xml&#x7f;application/rfc+xml&#x7f;message/rfc822&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;application/riscos&#x7f;application/rlmi+xml&#x7f;application/rls-services+xml&#x7f;application/route-apd+xml&#x7f;application/route-s-tsid+xml&#x7f;application/route-usd+xml&#x7f;application/rpki-ghostbusters&#x7f;application/rpki-manifest&#x7f;application/rpki-publication&#x7f;application/rpki-roa&#x7f;application/rpki-updown&#x7f;application/rtf&#x7f;text/rtf&#x7f;audio/rtp-enc-aescm128&#x7f;text/rtp-enc-aescm128&#x7f;video/rtp-enc-aescm128&#x7f;audio/rtp-midi&#x7f;application/rtploopback&#x7f;audio/rtploopback&#x7f;text/rtploopback&#x7f;video/rtploopback&#x7f;application/rtx&#x7f;audio/rtx&#x7f;text/rtx&#x7f;video/rtx&#x7f;message/s-http&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbe&#x7f;application/sbml+xml&#x7f;application/scaip+xml&#x7f;application/scim+json&#x7f;application/scvp-cv-request&#x7f;application/scvp-cv-response&#x7f;application/scvp-vp-request&#x7f;application/scvp-vp-response&#x7f;application/sdp&#x7f;application/secevent+jwt&#x7f;application/senml+cbor&#x7f;application/senml+json&#x7f;application/senml+xml&#x7f;application/senml-etch+cbor&#x7f;application/senml-etch+json&#x7f;application/senml-exi&#x7f;application/sensml+cbor&#x7f;application/sensml+json&#x7f;application/sensml+xml&#x7f;application/sensml-exi&#x7f;application/sep+xml&#x7f;application/sep-exi&#x7f;application/session-info&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;font/sfnt&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;multipart/signed&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/simpleSymbolContainer&#x7f;message/sip&#x7f;application/sipc&#x7f;message/sipfrag&#x7f;application/slate&#x7f;application/smil+xml&#x7f;video/smpte291&#x7f;application/smpte336m&#x7f;application/soap+fastinfoset&#x7f;application/soap+xml&#x7f;audio/sp-midi&#x7f;application/sparql-query&#x7f;application/sparql-results+xml&#x7f;audio/speex&#x7f;application/spirits-event+xml&#x7f;application/sql&#x7f;application/srgs&#x7f;application/srgs+xml&#x7f;application/sru+xml&#x7f;application/ssml+xml&#x7f;application/stix+json&#x7f;model/stl&#x7f;text/strings&#x7f;image/svg+xml&#x7f;application/swid+xml&#x7f;text/t140&#x7f;audio/t140c&#x7f;audio/t38&#x7f;image/t38&#x7f;text/tab-separated-values&#x7f;application/tamp-apex-update&#x7f;application/tamp-apex-update-confirm&#x7f;application/tamp-community-update&#x7f;application/tamp-community-update-confirm&#x7f;application/tamp-error&#x7f;application/tamp-sequence-adjust&#x7f;application/tamp-sequence-adjust-confirm&#x7f;application/tamp-status-query&#x7f;application/tamp-status-response&#x7f;application/tamp-update&#x7f;application/tamp-update-confirm&#x7f;application/taxii+json&#x7f;application/td+json&#x7f;application/tei+xml&#x7f;audio/telephone-event&#x7f;application/thraud+xml&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/timestamped-data&#x7f;application/tlsrpt+gzip&#x7f;application/tlsrpt+json&#x7f;application/tnauthlist&#x7f;audio/tone&#x7f;message/tracking-status&#x7f;application/trickle-ice-sdpfrag&#x7f;application/trig&#x7f;text/troff&#x7f;font/ttf&#x7f;application/ttml+xml&#x7f;text/turtle&#x7f;application/tve-trigger&#x7f;application/tzif&#x7f;application/tzif-leap&#x7f;application/ulpfec&#x7f;audio/ulpfec&#x7f;text/ulpfec&#x7f;video/ulpfec&#x7f;application/urc-grpsheet+xml&#x7f;application/urc-ressheet+xml&#x7f;application/urc-targetdesc+xml&#x7f;application/urc-uisocketdesc+xml&#x7f;text/uri-list&#x7f;audio/usac&#x7f;video/vc1&#x7f;video/vc2&#x7f;text/vcard&#x7f;application/vcard+json&#x7f;application/vcard+xml&#x7f;application/vemmi&#x7f;application/vnd.1000minds.decision-model+xml&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.3gpp-prose+xml&#x7f;application/vnd.3gpp-prose-pc3ch+xml&#x7f;application/vnd.3gpp-v2x-local-service-information&#x7f;application/vnd.3gpp.GMOP+xml&#x7f;application/vnd.3gpp.SRVCC-info+xml&#x7f;application/vnd.3gpp.access-transfer-events+xml&#x7f;application/vnd.3gpp.bsf+xml&#x7f;audio/vnd.3gpp.iufp&#x7f;application/vnd.3gpp.mc-signalling-ear&#x7f;application/vnd.3gpp.mcdata-affiliation-command+xml&#x7f;application/vnd.3gpp.mcdata-info+xml&#x7f;application/vnd.3gpp.mcdata-payload&#x7f;application/vnd.3gpp.mcdata-service-config+xml&#x7f;application/vnd.3gpp.mcdata-signalling&#x7f;application/vnd.3gpp.mcdata-ue-config+xml&#x7f;application/vnd.3gpp.mcdata-user-profile+xml&#x7f;application/vnd.3gpp.mcptt-affiliation-command+xml&#x7f;application/vnd.3gpp.mcptt-floor-request+xml&#x7f;application/vnd.3gpp.mcptt-info+xml&#x7f;application/vnd.3gpp.mcptt-location-info+xml&#x7f;application/vnd.3gpp.mcptt-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcptt-service-config+xml&#x7f;application/vnd.3gpp.mcptt-signed+xml&#x7f;application/vnd.3gpp.mcptt-ue-config+xml&#x7f;application/vnd.3gpp.mcptt-ue-init-config+xml&#x7f;application/vnd.3gpp.mcptt-user-profile+xml&#x7f;application/vnd.3gpp.mcvideo-affiliation-command+xml&#x7f;application/vnd.3gpp.mcvideo-info+xml&#x7f;application/vnd.3gpp.mcvideo-location-info+xml&#x7f;application/vnd.3gpp.mcvideo-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcvideo-service-config+xml&#x7f;application/vnd.3gpp.mcvideo-transmission-request+xml&#x7f;application/vnd.3gpp.mcvideo-ue-config+xml&#x7f;application/vnd.3gpp.mcvideo-user-profile+xml&#x7f;application/vnd.3gpp.mid-call+xml&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.3gpp.sms+xml&#x7f;application/vnd.3gpp.srvcc-ext+xml&#x7f;application/vnd.3gpp.state-and-event-info+xml&#x7f;application/vnd.3gpp.ussd+xml&#x7f;application/vnd.3gpp2.bcmcsinfo+xml&#x7f;application/vnd.3gpp2.sms&#x7f;application/vnd.3gpp2.tcap&#x7f;application/vnd.3lightssoftware.imagescal&#x7f;audio/vnd.4SB&#x7f;video/vnd.CCTV&#x7f;audio/vnd.CELP&#x7f;text/vnd.DMClientScript&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.HandHeld-Entertainment+xml&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.IPTC.NewsML&#x7f;application/vnd.Kinar&#x7f;application/vnd.MFER&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.SimTech-MindMapper&#x7f;text/vnd.a&#x7f;text/vnd.abc&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.flash.movie&#x7f;application/vnd.adobe.formscentral.fcdt&#x7f;application/vnd.adobe.fxp&#x7f;application/vnd.adobe.partial-upload&#x7f;image/vnd.adobe.photoshop&#x7f;application/vnd.adobe.xdp+xml&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.afpc.afplinedata&#x7f;application/vnd.afpc.afplinedata-pagedef&#x7f;application/vnd.afpc.foca-charset&#x7f;application/vnd.afpc.foca-codedfont&#x7f;application/vnd.afpc.foca-codepage&#x7f;application/vnd.afpc.modca&#x7f;application/vnd.afpc.modca-formdef&#x7f;application/vnd.afpc.modca-mediummap&#x7f;application/vnd.afpc.modca-objectcontainer&#x7f;application/vnd.afpc.modca-overlay&#x7f;application/vnd.afpc.modca-pagesegment&#x7f;application/vnd.ah-barcode&#x7f;application/vnd.ahead.space&#x7f;image/vnd.airzip.accelerator.azv&#x7f;application/vnd.airzip.filesecure.azf&#x7f;application/vnd.airzip.filesecure.azs&#x7f;application/vnd.amadeus+json&#x7f;application/vnd.amazon.mobi8-ebook&#x7f;application/vnd.americandynamics.acc&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.amundsen.maze+xml&#x7f;application/vnd.android.ota&#x7f;application/vnd.anki&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.antix.game-component&#x7f;application/vnd.apache.thrift.binary&#x7f;application/vnd.apache.thrift.compact&#x7f;application/vnd.apache.thrift.json&#x7f;application/vnd.api+json&#x7f;application/vnd.aplextor.warrp+json&#x7f;application/vnd.apothekende.reservation+json&#x7f;application/vnd.apple.installer+xml&#x7f;application/vnd.apple.keynote&#x7f;application/vnd.apple.mpegurl&#x7f;application/vnd.apple.numbers&#x7f;application/vnd.apple.pages&#x7f;application/vnd.aristanetworks.swi&#x7f;application/vnd.artisan+json&#x7f;application/vnd.artsquare&#x7f;text/vnd.ascii-art&#x7f;application/vnd.astraea-software.iota&#x7f;application/vnd.audiograph&#x7f;audio/vnd.audiokoz&#x7f;application/vnd.autopackage&#x7f;application/vnd.avalon+json&#x7f;application/vnd.avistar+xml&#x7f;application/vnd.balsamiq.bmml+xml&#x7f;application/vnd.balsamiq.bmpr&#x7f;application/vnd.banana-accounting&#x7f;application/vnd.bbf.usp.error&#x7f;application/vnd.bbf.usp.msg&#x7f;application/vnd.bbf.usp.msg+json&#x7f;application/vnd.bekitzur-stech+json&#x7f;application/vnd.bint.med-content&#x7f;multipart/vnd.bint.med-plus&#x7f;application/vnd.biopax.rdf+xml&#x7f;application/vnd.blink-idb-value-wrapper&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bluetooth.ep.oob&#x7f;application/vnd.bluetooth.le.oob&#x7f;application/vnd.bmi&#x7f;application/vnd.bpf&#x7f;application/vnd.bpf3&#x7f;application/vnd.businessobjects&#x7f;application/vnd.byu.uapi+json&#x7f;application/vnd.cab-jscript&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.capasystems-pg+json&#x7f;application/vnd.cendio.thinlinc.clientconf&#x7f;application/vnd.century-systems.tcp_stream&#x7f;application/vnd.chemdraw+xml&#x7f;application/vnd.chess-pgn&#x7f;application/vnd.chipnuts.karaoke-mmd&#x7f;application/vnd.ciedi&#x7f;application/vnd.cinderella&#x7f;application/vnd.cirpack.isdn-ext&#x7f;audio/vnd.cisco.nse&#x7f;application/vnd.citationstyles.style+xml&#x7f;application/vnd.claymore&#x7f;application/vnd.cloanto.rp9&#x7f;application/vnd.clonk.c4group&#x7f;application/vnd.cluetrust.cartomobile-config&#x7f;application/vnd.cluetrust.cartomobile-config-pkg&#x7f;audio/vnd.cmles.radio-events&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;image/vnd.cns.inf2&#x7f;application/vnd.coffeescript&#x7f;application/vnd.collabio.xodocuments.document&#x7f;application/vnd.collabio.xodocuments.document-template&#x7f;application/vnd.collabio.xodocuments.presentation&#x7f;application/vnd.collabio.xodocuments.presentation-template&#x7f;application/vnd.collabio.xodocuments.spreadsheet&#x7f;application/vnd.collabio.xodocuments.spreadsheet-template&#x7f;model/vnd.collada+xml&#x7f;application/vnd.collection+json&#x7f;application/vnd.collection.doc+json&#x7f;application/vnd.collection.next+json&#x7f;application/vnd.comicbook+zip&#x7f;application/vnd.comicbook-rar&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.coreos.ignition+json&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.crick.clicker&#x7f;application/vnd.crick.clicker.keyboard&#x7f;application/vnd.crick.clicker.palette&#x7f;application/vnd.crick.clicker.template&#x7f;application/vnd.crick.clicker.wordbank&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.cryptii.pipe+json&#x7f;application/vnd.crypto-shade-file&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.ctct.ws+xml&#x7f;application/vnd.cups-pdf&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-ppd&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;text/vnd.curl&#x7f;application/vnd.cyan.dean.root+xml&#x7f;application/vnd.cybank&#x7f;application/vnd.d2l.coursepackage1p0+zip&#x7f;application/vnd.dart&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.datapackage+json&#x7f;application/vnd.dataresource+json&#x7f;application/vnd.dbf&#x7f;application/vnd.debian.binary-package&#x7f;text/vnd.debian.copyright&#x7f;audio/vnd.dece.audio&#x7f;application/vnd.dece.data&#x7f;image/vnd.dece.graphic&#x7f;video/vnd.dece.hd&#x7f;video/vnd.dece.mobile&#x7f;video/vnd.dece.mp4&#x7f;video/vnd.dece.pd&#x7f;video/vnd.dece.sd&#x7f;application/vnd.dece.ttml+xml&#x7f;application/vnd.dece.unspecified&#x7f;video/vnd.dece.video&#x7f;application/vnd.dece.zip&#x7f;application/vnd.denovo.fcselayout-link&#x7f;application/vnd.desmume.movie&#x7f;audio/vnd.digital-winds&#x7f;application/vnd.dir-bi.plate-dl-nosuffix&#x7f;video/vnd.directv.mpeg&#x7f;video/vnd.directv.mpeg-tts&#x7f;image/vnd.djvu&#x7f;audio/vnd.dlna.adts&#x7f;video/vnd.dlna.mpeg-tts&#x7f;application/vnd.dm.delegation+xml&#x7f;application/vnd.dna&#x7f;application/vnd.document+json&#x7f;audio/vnd.dolby.heaac.1&#x7f;audio/vnd.dolby.heaac.2&#x7f;audio/vnd.dolby.mlp&#x7f;application/vnd.dolby.mobile.1&#x7f;application/vnd.dolby.mobile.2&#x7f;audio/vnd.dolby.mps&#x7f;audio/vnd.dolby.pl2&#x7f;audio/vnd.dolby.pl2x&#x7f;audio/vnd.dolby.pl2z&#x7f;audio/vnd.dolby.pulse.1&#x7f;application/vnd.doremir.scorecloud-binary-document&#x7f;application/vnd.dpgraph&#x7f;audio/vnd.dra&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.drive+json&#x7f;application/vnd.dtg.local&#x7f;application/vnd.dtg.local.flash&#x7f;application/vnd.dtg.local.html&#x7f;audio/vnd.dts&#x7f;audio/vnd.dts.hd&#x7f;audio/vnd.dts.uhd&#x7f;application/vnd.dvb.ait&#x7f;application/vnd.dvb.dvbisl+xml&#x7f;application/vnd.dvb.dvbj&#x7f;application/vnd.dvb.esgcontainer&#x7f;audio/vnd.dvb.file&#x7f;video/vnd.dvb.file&#x7f;application/vnd.dvb.ipdcdftnotifaccess&#x7f;application/vnd.dvb.ipdcesgaccess&#x7f;application/vnd.dvb.ipdcesgaccess2&#x7f;application/vnd.dvb.ipdcesgpdd&#x7f;application/vnd.dvb.ipdcroaming&#x7f;application/vnd.dvb.iptv.alfec-base&#x7f;application/vnd.dvb.iptv.alfec-enhancement&#x7f;application/vnd.dvb.notif-aggregate-root+xml&#x7f;application/vnd.dvb.notif-container+xml&#x7f;application/vnd.dvb.notif-generic+xml&#x7f;application/vnd.dvb.notif-ia-msglist+xml&#x7f;application/vnd.dvb.notif-ia-registration-request+xml&#x7f;application/vnd.dvb.notif-ia-registration-response+xml&#x7f;application/vnd.dvb.notif-init+xml&#x7f;application/vnd.dvb.pfr&#x7f;application/vnd.dvb.service&#x7f;image/vnd.dvb.subtitle&#x7f;text/vnd.dvb.subtitle&#x7f;model/vnd.dwf&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;application/vnd.dxr&#x7f;application/vnd.dynageo&#x7f;application/vnd.dzr&#x7f;application/vnd.easykaraoke.cdgdownload&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecip.rlp&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.efi.img&#x7f;application/vnd.efi.iso&#x7f;application/vnd.emclient.accessrequest+xml&#x7f;application/vnd.enliven&#x7f;application/vnd.enphase.envoy&#x7f;application/vnd.eprints.data+xml&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;application/vnd.espass-espass+zip&#x7f;application/vnd.eszigno3+xml&#x7f;application/vnd.etsi.aoc+xml&#x7f;application/vnd.etsi.asic-e+zip&#x7f;application/vnd.etsi.asic-s+zip&#x7f;application/vnd.etsi.cug+xml&#x7f;application/vnd.etsi.iptvcommand+xml&#x7f;application/vnd.etsi.iptvdiscovery+xml&#x7f;application/vnd.etsi.iptvprofile+xml&#x7f;application/vnd.etsi.iptvsad-bc+xml&#x7f;application/vnd.etsi.iptvsad-cod+xml&#x7f;application/vnd.etsi.iptvsad-npvr+xml&#x7f;application/vnd.etsi.iptvservice+xml&#x7f;application/vnd.etsi.iptvsync+xml&#x7f;application/vnd.etsi.iptvueprofile+xml&#x7f;application/vnd.etsi.mcid+xml&#x7f;application/vnd.etsi.mheg5&#x7f;application/vnd.etsi.overload-control-policy-dataset+xml&#x7f;application/vnd.etsi.pstn+xml&#x7f;application/vnd.etsi.sci+xml&#x7f;application/vnd.etsi.simservs+xml&#x7f;application/vnd.etsi.timestamp-token&#x7f;application/vnd.etsi.tsl+xml&#x7f;application/vnd.etsi.tsl.der&#x7f;application/vnd.eudora.data&#x7f;audio/vnd.everad.plj&#x7f;application/vnd.evolv.ecig.profile&#x7f;application/vnd.evolv.ecig.settings&#x7f;application/vnd.evolv.ecig.theme&#x7f;application/vnd.exstream-empower+zip&#x7f;application/vnd.exstream-package&#x7f;application/vnd.ezpix-album&#x7f;application/vnd.ezpix-package&#x7f;application/vnd.f-secure.mobile&#x7f;image/vnd.fastbidsheet&#x7f;application/vnd.fastcopy-disk-image&#x7f;application/vnd.fdf&#x7f;application/vnd.fdsn.mseed&#x7f;application/vnd.fdsn.seed&#x7f;application/vnd.ffsns&#x7f;application/vnd.ficlab.flb+zip&#x7f;text/vnd.ficlab.flt&#x7f;application/vnd.filmit.zfc&#x7f;application/vnd.fints&#x7f;application/vnd.firemonkeys.cloudcell&#x7f;model/vnd.flatland.3dml&#x7f;application/vnd.fluxtime.clip&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;application/vnd.font-fontforge-sfd&#x7f;image/vnd.fpx&#x7f;application/vnd.framemaker&#x7f;application/vnd.frogans.fnc&#x7f;application/vnd.frogans.ltf&#x7f;application/vnd.fsc.weblaunch&#x7f;image/vnd.fst&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ART-EX&#x7f;application/vnd.fujixerox.ART4&#x7f;application/vnd.fujixerox.HBPL&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fujixerox.docuworks.container&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.futoin+cbor&#x7f;application/vnd.futoin+json&#x7f;application/vnd.fuzzysheet&#x7f;video/vnd.fvt&#x7f;model/vnd.gdl&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.gentics.grd+json&#x7f;application/vnd.geogebra.file&#x7f;application/vnd.geogebra.tool&#x7f;application/vnd.geometry-explorer&#x7f;application/vnd.geonext&#x7f;application/vnd.geoplan&#x7f;application/vnd.geospace&#x7f;application/vnd.gerber&#x7f;image/vnd.globalgraphics.pgb&#x7f;application/vnd.globalplatform.card-content-mgt&#x7f;application/vnd.globalplatform.card-content-mgt-response&#x7f;text/vnd.gml&#x7f;application/vnd.google-earth.kml+xml&#x7f;application/vnd.google-earth.kmz&#x7f;application/vnd.gov.sk.e-form+xml&#x7f;application/vnd.gov.sk.e-form+zip&#x7f;application/vnd.gov.sk.xmldatacontainer+xml&#x7f;application/vnd.grafeq&#x7f;text/vnd.graphviz&#x7f;application/vnd.gridmp&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;application/vnd.hal+json&#x7f;application/vnd.hal+xml&#x7f;application/vnd.hbci&#x7f;application/vnd.hc+json&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hdt&#x7f;application/vnd.heroku+json&#x7f;text/vnd.hgl&#x7f;application/vnd.hhe.lesson-player&#x7f;audio/vnd.hns.audio&#x7f;video/vnd.hns.video&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.hp-jlyt&#x7f;application/vnd.httphone&#x7f;application/vnd.hydrostatix.sof-data&#x7f;application/vnd.hyper+json&#x7f;application/vnd.hyper-item+json&#x7f;application/vnd.hyperdrive+json&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.iccprofile&#x7f;application/vnd.ieee.1905&#x7f;application/vnd.igloader&#x7f;application/vnd.imagemeter.folder+zip&#x7f;application/vnd.imagemeter.image+zip&#x7f;application/vnd.immervision-ivp&#x7f;application/vnd.immervision-ivu&#x7f;application/vnd.ims.imsccv1p1&#x7f;application/vnd.ims.imsccv1p2&#x7f;application/vnd.ims.imsccv1p3&#x7f;application/vnd.ims.lis.v2.result+json&#x7f;application/vnd.ims.lti.v2.toolconsumerprofile+json&#x7f;application/vnd.ims.lti.v2.toolproxy+json&#x7f;application/vnd.ims.lti.v2.toolproxy.id+json&#x7f;application/vnd.ims.lti.v2.toolsettings+json&#x7f;application/vnd.ims.lti.v2.toolsettings.simple+json&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;application/vnd.informedcontrol.rms+xml&#x7f;application/vnd.infotech.project&#x7f;application/vnd.infotech.project+xml&#x7f;application/vnd.innopath.wamp.notification&#x7f;application/vnd.insors.igm&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intergeo&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.iptc.g2.catalogitem+xml&#x7f;application/vnd.iptc.g2.conceptitem+xml&#x7f;application/vnd.iptc.g2.knowledgeitem+xml&#x7f;application/vnd.iptc.g2.newsitem+xml&#x7f;application/vnd.iptc.g2.newsmessage+xml&#x7f;application/vnd.iptc.g2.packageitem+xml&#x7f;application/vnd.iptc.g2.planningitem+xml&#x7f;video/vnd.iptvforum.1dparityfec-1010&#x7f;video/vnd.iptvforum.1dparityfec-2005&#x7f;video/vnd.iptvforum.2dparityfec-1010&#x7f;video/vnd.iptvforum.2dparityfec-2005&#x7f;video/vnd.iptvforum.ttsavc&#x7f;video/vnd.iptvforum.ttsmpeg2&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.isac.fcs&#x7f;application/vnd.iso11783-10+zip&#x7f;application/vnd.jam&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jcp.javame.midlet-rms&#x7f;application/vnd.jisp&#x7f;application/vnd.joost.joda-archive&#x7f;application/vnd.jsk.isdn-ngn&#x7f;application/vnd.kahootz&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.koan&#x7f;application/vnd.kodak-descriptor&#x7f;application/vnd.las&#x7f;application/vnd.las.las+json&#x7f;application/vnd.las.las+xml&#x7f;application/vnd.laszip&#x7f;text/vnd.latex-z&#x7f;application/vnd.leap+json&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.logipipe.circuit+zip&#x7f;application/vnd.loom&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;audio/vnd.lucent.voice&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.mapbox-vector-tile&#x7f;application/vnd.marlin.drm.actiontoken+xml&#x7f;application/vnd.marlin.drm.conftoken+xml&#x7f;application/vnd.marlin.drm.license+xml&#x7f;application/vnd.marlin.drm.mdcf&#x7f;application/vnd.mason+json&#x7f;application/vnd.maxmind.maxmind-db&#x7f;application/vnd.mcd&#x7f;application/vnd.medcalcdata&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.mfmp&#x7f;application/vnd.micro+json&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;image/vnd.microsoft.icon&#x7f;application/vnd.microsoft.portable-executable&#x7f;application/vnd.microsoft.windows.thumbnail-cache&#x7f;application/vnd.miele+json&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;image/vnd.mix&#x7f;model/vnd.moml+xml&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.motorola.iprm&#x7f;text/vnd.motorola.reflex&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;image/vnd.mozilla.apng&#x7f;application/vnd.mozilla.xul+xml&#x7f;video/vnd.mpegurl&#x7f;application/vnd.ms-3mfdocument&#x7f;application/vnd.ms-PrintDeviceCapabilities+xml&#x7f;application/vnd.ms-PrintSchemaTicket+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-cab-compressed&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-excel.addin.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.binary.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.macroEnabled.12&#x7f;application/vnd.ms-excel.template.macroEnabled.12&#x7f;application/vnd.ms-fontobject&#x7f;application/vnd.ms-htmlhelp&#x7f;application/vnd.ms-ims&#x7f;application/vnd.ms-lrm&#x7f;text/vnd.ms-mediapackage&#x7f;image/vnd.ms-modi&#x7f;application/vnd.ms-office.activeX+xml&#x7f;application/vnd.ms-officetheme&#x7f;application/vnd.ms-playready.initiator+xml&#x7f;audio/vnd.ms-playready.media.pya&#x7f;video/vnd.ms-playready.media.pyv&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-powerpoint.addin.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.presentation.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slide.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slideshow.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.template.macroEnabled.12&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-windows.devicepairing&#x7f;application/vnd.ms-windows.nwprinting.oob&#x7f;application/vnd.ms-windows.printerpairing&#x7f;application/vnd.ms-windows.wsd.oob&#x7f;application/vnd.ms-wmdrm.lic-chlg-req&#x7f;application/vnd.ms-wmdrm.lic-resp&#x7f;application/vnd.ms-wmdrm.meter-chlg-req&#x7f;application/vnd.ms-wmdrm.meter-resp&#x7f;application/vnd.ms-word.document.macroEnabled.12&#x7f;application/vnd.ms-word.template.macroEnabled.12&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.ms-xpsdocument&#x7f;application/vnd.msa-disk-image&#x7f;application/vnd.mseq&#x7f;application/vnd.msign&#x7f;model/vnd.mts&#x7f;application/vnd.multiad.creator&#x7f;application/vnd.multiad.creator.cif&#x7f;application/vnd.music-niff&#x7f;application/vnd.musician&#x7f;application/vnd.muvee.style&#x7f;application/vnd.mynfc&#x7f;application/vnd.ncd.control&#x7f;application/vnd.ncd.reference&#x7f;application/vnd.nearst.inv+json&#x7f;application/vnd.nervana&#x7f;image/vnd.net-fpx&#x7f;text/vnd.net2phone.commcenter.command&#x7f;application/vnd.netfpx&#x7f;application/vnd.neurolanguage.nlu&#x7f;application/vnd.nimn&#x7f;application/vnd.nintendo.nitro.rom&#x7f;application/vnd.nintendo.snes.rom&#x7f;application/vnd.nitf&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.catalogs&#x7f;application/vnd.nokia.conml+wbxml&#x7f;application/vnd.nokia.conml+xml&#x7f;application/vnd.nokia.iSDS-radio-presets&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;application/vnd.nokia.iptv.config+xml&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;video/vnd.nokia.mp4vr&#x7f;application/vnd.nokia.n-gage.ac+xml&#x7f;application/vnd.nokia.n-gage.data&#x7f;application/vnd.nokia.ncd&#x7f;application/vnd.nokia.pcd+wbxml&#x7f;application/vnd.nokia.pcd+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;video/vnd.nokia.videovoip&#x7f;audio/vnd.nortel.vbk&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.ntt-local.content-share&#x7f;application/vnd.ntt-local.file-transfer&#x7f;application/vnd.ntt-local.ogw_remote-access&#x7f;application/vnd.ntt-local.sip-ta_remote&#x7f;application/vnd.ntt-local.sip-ta_tcp_stream&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;application/vnd.oasis.opendocument.chart&#x7f;application/vnd.oasis.opendocument.chart-template&#x7f;application/vnd.oasis.opendocument.database&#x7f;application/vnd.oasis.opendocument.formula&#x7f;application/vnd.oasis.opendocument.formula-template&#x7f;application/vnd.oasis.opendocument.graphics&#x7f;application/vnd.oasis.opendocument.graphics-template&#x7f;application/vnd.oasis.opendocument.image&#x7f;application/vnd.oasis.opendocument.image-template&#x7f;application/vnd.oasis.opendocument.presentation&#x7f;application/vnd.oasis.opendocument.presentation-template&#x7f;application/vnd.oasis.opendocument.spreadsheet&#x7f;application/vnd.oasis.opendocument.spreadsheet-template&#x7f;application/vnd.oasis.opendocument.text&#x7f;application/vnd.oasis.opendocument.text-master&#x7f;application/vnd.oasis.opendocument.text-template&#x7f;application/vnd.oasis.opendocument.text-web&#x7f;video/vnd.objectvideo&#x7f;application/vnd.obn&#x7f;application/vnd.ocf+cbor&#x7f;application/vnd.oci.image.manifest.v1+json&#x7f;audio/vnd.octel.sbc&#x7f;application/vnd.oftn.l10n+json&#x7f;application/vnd.oipf.contentaccessdownload+xml&#x7f;application/vnd.oipf.contentaccessstreaming+xml&#x7f;application/vnd.oipf.cspg-hexbinary&#x7f;application/vnd.oipf.dae.svg+xml&#x7f;application/vnd.oipf.dae.xhtml+xml&#x7f;application/vnd.oipf.mippvcontrolmessage+xml&#x7f;application/vnd.oipf.pae.gem&#x7f;application/vnd.oipf.spdiscovery+xml&#x7f;application/vnd.oipf.spdlist+xml&#x7f;application/vnd.oipf.ueprofile+xml&#x7f;application/vnd.oipf.userprofile+xml&#x7f;application/vnd.olpc-sugar&#x7f;application/vnd.oma-scws-config&#x7f;application/vnd.oma-scws-http-request&#x7f;application/vnd.oma-scws-http-response&#x7f;application/vnd.oma.bcast.associated-procedure-parameter+xml&#x7f;application/vnd.oma.bcast.drm-trigger+xml&#x7f;application/vnd.oma.bcast.imd+xml&#x7f;application/vnd.oma.bcast.ltkm&#x7f;application/vnd.oma.bcast.notification+xml&#x7f;application/vnd.oma.bcast.provisioningtrigger&#x7f;application/vnd.oma.bcast.sgboot&#x7f;application/vnd.oma.bcast.sgdd+xml&#x7f;application/vnd.oma.bcast.sgdu&#x7f;application/vnd.oma.bcast.simple-symbol-container&#x7f;application/vnd.oma.bcast.smartcard-trigger+xml&#x7f;application/vnd.oma.bcast.sprov+xml&#x7f;application/vnd.oma.bcast.stkm&#x7f;application/vnd.oma.cab-address-book+xml&#x7f;application/vnd.oma.cab-feature-handler+xml&#x7f;application/vnd.oma.cab-pcc+xml&#x7f;application/vnd.oma.cab-subs-invite+xml&#x7f;application/vnd.oma.cab-user-prefs+xml&#x7f;application/vnd.oma.dcd&#x7f;application/vnd.oma.dcdc&#x7f;application/vnd.oma.dd2+xml&#x7f;application/vnd.oma.drm.risd+xml&#x7f;application/vnd.oma.group-usage-list+xml&#x7f;application/vnd.oma.lwm2m+json&#x7f;application/vnd.oma.lwm2m+tlv&#x7f;application/vnd.oma.pal+xml&#x7f;application/vnd.oma.poc.detailed-progress-report+xml&#x7f;application/vnd.oma.poc.final-report+xml&#x7f;application/vnd.oma.poc.groups+xml&#x7f;application/vnd.oma.poc.invocation-descriptor+xml&#x7f;application/vnd.oma.poc.optimized-progress-report+xml&#x7f;application/vnd.oma.push&#x7f;application/vnd.oma.scidm.messages+xml&#x7f;application/vnd.oma.xcap-directory+xml&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.omaloc-supl-init&#x7f;application/vnd.onepager&#x7f;application/vnd.onepagertamp&#x7f;application/vnd.onepagertamx&#x7f;application/vnd.onepagertat&#x7f;application/vnd.onepagertatp&#x7f;application/vnd.onepagertatx&#x7f;application/vnd.openblox.game+xml&#x7f;application/vnd.openblox.game-binary&#x7f;application/vnd.openeye.oeb&#x7f;model/vnd.opengex&#x7f;application/vnd.openstreetmap.data+xml&#x7f;application/vnd.openxmlformats-officedocument.custom-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.customXmlProperties+xml&#x7f;application/vnd.openxmlformats-officedocument.drawing+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chart+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml&#x7f;application/vnd.openxmlformats-officedocument.extended-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presProps+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tags+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml&#x7f;application/vnd.openxmlformats-officedocument.theme+xml&#x7f;application/vnd.openxmlformats-officedocument.themeOverride+xml&#x7f;application/vnd.openxmlformats-officedocument.vmlDrawing&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml&#x7f;application/vnd.openxmlformats-package.core-properties+xml&#x7f;application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml&#x7f;application/vnd.openxmlformats-package.relationships+xml&#x7f;application/vnd.oracle.resource+json&#x7f;application/vnd.orange.indata&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.osgeo.mapguide.package&#x7f;application/vnd.osgi.bundle&#x7f;application/vnd.osgi.dp&#x7f;application/vnd.osgi.subsystem&#x7f;application/vnd.otps.ct-kip+xml&#x7f;application/vnd.oxli.countgraph&#x7f;application/vnd.pagerduty+json&#x7f;application/vnd.palm&#x7f;application/vnd.panoply&#x7f;application/vnd.paos.xml&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;application/vnd.patentdive&#x7f;application/vnd.patientecommsdoc&#x7f;application/vnd.pawaafile&#x7f;application/vnd.pcos&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.piaccess.application-licence&#x7f;application/vnd.picsel&#x7f;application/vnd.pmi.widget&#x7f;application/vnd.poc.group-advertisement+xml&#x7f;application/vnd.pocketlearn&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.preminet&#x7f;audio/vnd.presonus.multitrack&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.proteus.magazine&#x7f;application/vnd.psfs&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.qualcomm.brew-app-res&#x7f;application/vnd.quarantainenet&#x7f;application/vnd.quobject-quoxdocument&#x7f;video/vnd.radgamettools.bink&#x7f;video/vnd.radgamettools.smacker&#x7f;image/vnd.radiance&#x7f;application/vnd.radisys.moml+xml&#x7f;application/vnd.radisys.msml+xml&#x7f;application/vnd.radisys.msml-audit+xml&#x7f;application/vnd.radisys.msml-audit-conf+xml&#x7f;application/vnd.radisys.msml-audit-conn+xml&#x7f;application/vnd.radisys.msml-audit-dialog+xml&#x7f;application/vnd.radisys.msml-audit-stream+xml&#x7f;text/vnd.radisys.msml-basic-layout&#x7f;application/vnd.radisys.msml-conf+xml&#x7f;application/vnd.radisys.msml-dialog+xml&#x7f;application/vnd.radisys.msml-dialog-base+xml&#x7f;application/vnd.radisys.msml-dialog-fax-detect+xml&#x7f;application/vnd.radisys.msml-dialog-fax-sendrecv+xml&#x7f;application/vnd.radisys.msml-dialog-group+xml&#x7f;application/vnd.radisys.msml-dialog-speech+xml&#x7f;application/vnd.radisys.msml-dialog-transform+xml&#x7f;application/vnd.rainstor.data&#x7f;application/vnd.rapid&#x7f;application/vnd.rar&#x7f;application/vnd.realvnc.bed&#x7f;application/vnd.recordare.musicxml&#x7f;application/vnd.recordare.musicxml+xml&#x7f;application/vnd.restful+json&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;application/vnd.rig.cryptonote&#x7f;audio/vnd.rip&#x7f;model/vnd.rosette.annotated-data-model&#x7f;application/vnd.route66.link66+xml&#x7f;application/vnd.rs-274x&#x7f;application/vnd.ruckus.download&#x7f;application/vnd.s3sms&#x7f;application/vnd.sailingtracker.track&#x7f;application/vnd.sar&#x7f;application/vnd.sbm.cid&#x7f;application/vnd.sbm.mid2&#x7f;application/vnd.scribus&#x7f;application/vnd.sealed.3df&#x7f;application/vnd.sealed.csf&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;application/vnd.sealed.net&#x7f;image/vnd.sealed.png&#x7f;application/vnd.sealed.ppt&#x7f;video/vnd.sealed.swf&#x7f;application/vnd.sealed.tiff&#x7f;application/vnd.sealed.xls&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.sema&#x7f;application/vnd.semd&#x7f;application/vnd.semf&#x7f;text/vnd.senx.warpscript&#x7f;application/vnd.shade-save-file&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.shootproof+json&#x7f;application/vnd.shopkick+json&#x7f;application/vnd.shp&#x7f;application/vnd.shx&#x7f;application/vnd.sigrok.session&#x7f;application/vnd.siren+json&#x7f;application/vnd.smaf&#x7f;application/vnd.smart.notebook&#x7f;application/vnd.smart.teacher&#x7f;application/vnd.snesdev-page-table&#x7f;application/vnd.software602.filler.form+xml&#x7f;application/vnd.software602.filler.form-xml-zip&#x7f;application/vnd.solent.sdkm+xml&#x7f;text/vnd.sosi&#x7f;application/vnd.spotfire.dxp&#x7f;application/vnd.spotfire.sfs&#x7f;application/vnd.sqlite3&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.stepmania.package&#x7f;application/vnd.stepmania.stepchart&#x7f;application/vnd.street-stream&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;application/vnd.sun.wadl+xml&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;image/vnd.svf&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml+xml&#x7f;application/vnd.syncml.dm+wbxml&#x7f;application/vnd.syncml.dm+xml&#x7f;application/vnd.syncml.dm.notification&#x7f;application/vnd.syncml.dmddf+wbxml&#x7f;application/vnd.syncml.dmddf+xml&#x7f;application/vnd.syncml.dmtnds+wbxml&#x7f;application/vnd.syncml.dmtnds+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.tableschema+json&#x7f;application/vnd.tao.intent-module-archive&#x7f;application/vnd.tcpdump.pcap&#x7f;image/vnd.tencent.tap&#x7f;application/vnd.think-cell.ppttc+json&#x7f;application/vnd.tmd.mediaflex.api+xml&#x7f;application/vnd.tml&#x7f;application/vnd.tmobile-livetv&#x7f;application/vnd.tri.onesource&#x7f;application/vnd.trid.tpt&#x7f;application/vnd.triscape.mxs&#x7f;text/vnd.trolltech.linguist&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ubisoft.webplayer&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.umajin&#x7f;application/vnd.unity&#x7f;application/vnd.uoml+xml&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.uri-map&#x7f;model/vnd.usdz+zip&#x7f;video/vnd.uvvu.mp4&#x7f;model/vnd.valve.source.compiled-map&#x7f;application/vnd.valve.source.material&#x7f;image/vnd.valve.source.texture&#x7f;application/vnd.vcx&#x7f;application/vnd.vd-study&#x7f;application/vnd.vectorworks&#x7f;application/vnd.vel+json&#x7f;application/vnd.verimatrix.vcas&#x7f;application/vnd.veryant.thin&#x7f;application/vnd.ves.encrypted&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;video/vnd.vivo&#x7f;audio/vnd.vmx.cvsd&#x7f;application/vnd.vsf&#x7f;model/vnd.vtu&#x7f;text/vnd.wap.si&#x7f;application/vnd.wap.sic&#x7f;text/vnd.wap.sl&#x7f;application/vnd.wap.slc&#x7f;image/vnd.wap.wbmp&#x7f;application/vnd.wap.wbxml&#x7f;text/vnd.wap.wml&#x7f;application/vnd.wap.wmlc&#x7f;text/vnd.wap.wmlscript&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wfa.p2p&#x7f;application/vnd.wfa.wsc&#x7f;message/vnd.wfa.wsc&#x7f;application/vnd.windows.devicepairing&#x7f;application/vnd.wmc&#x7f;application/vnd.wmf.bootstrap&#x7f;application/vnd.wolfram.mathematica&#x7f;application/vnd.wolfram.mathematica.package&#x7f;application/vnd.wolfram.player&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xacml+json&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.xfdl.webform&#x7f;image/vnd.xiff&#x7f;application/vnd.xmi+xml&#x7f;application/vnd.xmpie.cpkg&#x7f;application/vnd.xmpie.dpkg&#x7f;application/vnd.xmpie.plan&#x7f;application/vnd.xmpie.ppkg&#x7f;application/vnd.xmpie.xlim&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.openscoreformat&#x7f;application/vnd.yamaha.openscoreformat.osfpvg+xml&#x7f;application/vnd.yamaha.remote-setup&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yamaha.through-ngn&#x7f;application/vnd.yamaha.tunnel-udpencap&#x7f;application/vnd.yaoweme&#x7f;application/vnd.yellowriver-custom-menu&#x7f;video/vnd.youtube.yt&#x7f;image/vnd.zbrush.pcx&#x7f;application/vnd.zul&#x7f;application/vnd.zzazz.deck+xml&#x7f;multipart/voice-message&#x7f;application/voicexml+xml&#x7f;audio/vorbis&#x7f;audio/vorbis-config&#x7f;application/voucher-cms+json&#x7f;application/vq-rtcpxr&#x7f;model/vrml&#x7f;text/vtt&#x7f;application/watcherinfo+xml&#x7f;application/webpush-options+json&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/widget&#x7f;application/wita&#x7f;image/wmf&#x7f;font/woff&#x7f;font/woff2&#x7f;application/wordperfect5.1&#x7f;application/wsdl+xml&#x7f;application/wspolicy+xml&#x7f;multipart/x-mixed-replace&#x7f;application/x-pki-message&#x7f;application/x-www-form-urlencoded&#x7f;application/x-x509-ca-cert&#x7f;application/x-x509-ca-ra-cert&#x7f;application/x-x509-next-ca-cert&#x7f;model/x3d+fastinfoset&#x7f;model/x3d+xml&#x7f;model/x3d-vrml&#x7f;application/x400-bp&#x7f;application/xacml+xml&#x7f;application/xcap-att+xml&#x7f;application/xcap-caps+xml&#x7f;application/xcap-diff+xml&#x7f;application/xcap-el+xml&#x7f;application/xcap-error+xml&#x7f;application/xcap-ns+xml&#x7f;application/xcon-conference-info+xml&#x7f;application/xcon-conference-info-diff+xml&#x7f;application/xenc+xml&#x7f;application/xhtml+xml&#x7f;application/xliff+xml&#x7f;application/xml&#x7f;text/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;text/xml-external-parsed-entity&#x7f;application/xml-patch+xml&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/xslt+xml&#x7f;application/xv+xml&#x7f;application/yang&#x7f;application/yang-data+json&#x7f;application/yang-data+xml&#x7f;application/yang-patch+json&#x7f;application/yang-patch+xml&#x7f;application/yin+xml&#x7f;application/zip&#x7f;application/zlib&#x7f;application/zstd&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( contains('&#x7f;application/1d-interleaved-parityfec&#x7f;audio/1d-interleaved-parityfec&#x7f;text/1d-interleaved-parityfec&#x7f;video/1d-interleaved-parityfec&#x7f;audio/32kadpcm&#x7f;application/3gpdash-qoe-report+xml&#x7f;audio/3gpp&#x7f;video/3gpp&#x7f;application/3gpp-ims+xml&#x7f;video/3gpp-tt&#x7f;audio/3gpp2&#x7f;video/3gpp2&#x7f;model/3mf&#x7f;application/A2L&#x7f;application/AML&#x7f;audio/AMR&#x7f;audio/AMR-WB&#x7f;application/ATF&#x7f;application/ATFX&#x7f;audio/ATRAC-ADVANCED-LOSSLESS&#x7f;audio/ATRAC-X&#x7f;audio/ATRAC3&#x7f;application/ATXML&#x7f;video/BMPEG&#x7f;video/BT656&#x7f;audio/BV16&#x7f;audio/BV32&#x7f;application/CALS-1840&#x7f;application/CDFX+XML&#x7f;application/CEA&#x7f;audio/CN&#x7f;message/CPIM&#x7f;application/CSTAdata+xml&#x7f;video/CelB&#x7f;audio/DAT12&#x7f;application/DCD&#x7f;application/DII&#x7f;application/DIT&#x7f;audio/DV&#x7f;video/DV&#x7f;audio/DVI4&#x7f;application/EDI-X12&#x7f;application/EDI-consent&#x7f;application/EDIFACT&#x7f;audio/EVRC&#x7f;audio/EVRC-QCP&#x7f;audio/EVRC0&#x7f;audio/EVRC1&#x7f;audio/EVRCB&#x7f;audio/EVRCB0&#x7f;audio/EVRCB1&#x7f;audio/EVRCNW&#x7f;audio/EVRCNW0&#x7f;audio/EVRCNW1&#x7f;audio/EVRCWB&#x7f;audio/EVRCWB0&#x7f;audio/EVRCWB1&#x7f;audio/EVS&#x7f;application/EmergencyCallData.Comment+xml&#x7f;application/EmergencyCallData.Control+xml&#x7f;application/EmergencyCallData.DeviceInfo+xml&#x7f;application/EmergencyCallData.ProviderInfo+xml&#x7f;application/EmergencyCallData.ServiceInfo+xml&#x7f;application/EmergencyCallData.SubscriberInfo+xml&#x7f;application/EmergencyCallData.VEDS+xml&#x7f;application/EmergencyCallData.eCall.MSD&#x7f;audio/G711-0&#x7f;audio/G719&#x7f;audio/G722&#x7f;audio/G7221&#x7f;audio/G723&#x7f;audio/G726-16&#x7f;audio/G726-24&#x7f;audio/G726-32&#x7f;audio/G726-40&#x7f;audio/G728&#x7f;audio/G729&#x7f;audio/G7291&#x7f;audio/G729D&#x7f;audio/G729E&#x7f;audio/GSM&#x7f;audio/GSM-EFR&#x7f;audio/GSM-HR-08&#x7f;application/H224&#x7f;video/H261&#x7f;video/H263&#x7f;video/H263-1998&#x7f;video/H263-2000&#x7f;video/H264&#x7f;video/H264-RCDO&#x7f;video/H264-SVC&#x7f;video/H265&#x7f;application/IOTP&#x7f;application/ISUP&#x7f;video/JPEG&#x7f;audio/L16&#x7f;audio/L20&#x7f;audio/L24&#x7f;audio/L8&#x7f;audio/LPC&#x7f;application/LXF&#x7f;audio/MELP&#x7f;audio/MELP1200&#x7f;audio/MELP2400&#x7f;audio/MELP600&#x7f;application/MF4&#x7f;video/MP1S&#x7f;video/MP2P&#x7f;video/MP2T&#x7f;audio/MP4A-LATM&#x7f;video/MP4V-ES&#x7f;audio/MPA&#x7f;video/MPV&#x7f;application/ODA&#x7f;application/ODX&#x7f;audio/PCMA&#x7f;audio/PCMA-WB&#x7f;audio/PCMU&#x7f;audio/PCMU-WB&#x7f;application/PDX&#x7f;audio/QCELP&#x7f;application/QSIG&#x7f;audio/RED&#x7f;text/RED&#x7f;application/SGML&#x7f;text/SGML&#x7f;video/SMPTE292M&#x7f;audio/SMV&#x7f;audio/SMV-QCP&#x7f;audio/SMV0&#x7f;audio/TETRA_ACELP&#x7f;audio/TETRA_ACELP_BB&#x7f;application/TETRA_ISI&#x7f;audio/UEMCLIP&#x7f;audio/VDVI&#x7f;audio/VMR-WB&#x7f;video/VP8&#x7f;audio/aac&#x7f;audio/ac3&#x7f;image/aces&#x7f;application/activemessage&#x7f;application/activity+json&#x7f;multipart/alternative&#x7f;application/alto-costmap+json&#x7f;application/alto-costmapfilter+json&#x7f;application/alto-directory+json&#x7f;application/alto-endpointcost+json&#x7f;application/alto-endpointcostparams+json&#x7f;application/alto-endpointprop+json&#x7f;application/alto-endpointpropparams+json&#x7f;application/alto-error+json&#x7f;application/alto-networkmap+json&#x7f;application/alto-networkmapfilter+json&#x7f;application/alto-updatestreamcontrol+json&#x7f;application/alto-updatestreamparams+json&#x7f;audio/amr-wb+&#x7f;application/andrew-inset&#x7f;multipart/appledouble&#x7f;application/applefile&#x7f;audio/aptx&#x7f;audio/asc&#x7f;application/atom+xml&#x7f;application/atomcat+xml&#x7f;application/atomdeleted+xml&#x7f;application/atomicmail&#x7f;application/atomsvc+xml&#x7f;application/atsc-dwd+xml&#x7f;application/atsc-dynamic-event-message&#x7f;application/atsc-held+xml&#x7f;application/atsc-rdt+json&#x7f;application/atsc-rsat+xml&#x7f;application/auth-policy+xml&#x7f;image/avci&#x7f;image/avcs&#x7f;application/bacnet-xdd+zip&#x7f;audio/basic&#x7f;application/batch-SMTP&#x7f;application/beep+xml&#x7f;image/bmp&#x7f;multipart/byteranges&#x7f;text/cache-manifest&#x7f;text/calendar&#x7f;application/calendar+json&#x7f;application/calendar+xml&#x7f;application/call-completion&#x7f;application/cap+xml&#x7f;application/cbor&#x7f;application/cbor-seq&#x7f;application/cccex&#x7f;application/ccmp+xml&#x7f;application/ccxml+xml&#x7f;application/cdmi-capability&#x7f;application/cdmi-container&#x7f;application/cdmi-domain&#x7f;application/cdmi-object&#x7f;application/cdmi-queue&#x7f;application/cdni&#x7f;application/cea-2018+xml&#x7f;application/cellml+xml&#x7f;application/cfw&#x7f;image/cgm&#x7f;audio/clearmode&#x7f;application/clue+xml&#x7f;application/clue_info+xml&#x7f;application/cms&#x7f;application/cnrp+xml&#x7f;application/coap-group+json&#x7f;application/coap-payload&#x7f;font/collection&#x7f;application/commonground&#x7f;application/conference-info+xml&#x7f;application/cose&#x7f;application/cose-key&#x7f;application/cose-key-set&#x7f;application/cpl+xml&#x7f;application/csrattrs&#x7f;text/css&#x7f;application/csta+xml&#x7f;text/csv&#x7f;text/csv-schema&#x7f;application/csvm+json&#x7f;application/cwt&#x7f;application/cybercash&#x7f;application/dash+xml&#x7f;application/dashdelta&#x7f;application/davmount+xml&#x7f;application/dca-rft&#x7f;application/dec-dx&#x7f;message/delivery-status&#x7f;application/dialog-info+xml&#x7f;application/dicom&#x7f;application/dicom+json&#x7f;application/dicom+xml&#x7f;image/dicom-rle&#x7f;multipart/digest&#x7f;message/disposition-notification&#x7f;audio/dls&#x7f;application/dns&#x7f;text/dns&#x7f;application/dns+json&#x7f;application/dns-message&#x7f;application/dots+cbor&#x7f;application/dskpp+xml&#x7f;audio/dsr-es201108&#x7f;audio/dsr-es202050&#x7f;audio/dsr-es202211&#x7f;audio/dsr-es202212&#x7f;application/dssc+der&#x7f;application/dssc+xml&#x7f;application/dvcs&#x7f;audio/eac3&#x7f;application/ecmascript&#x7f;application/efi&#x7f;image/emf&#x7f;application/emma+xml&#x7f;application/emotionml+xml&#x7f;application/encaprtp&#x7f;audio/encaprtp&#x7f;text/encaprtp&#x7f;video/encaprtp&#x7f;multipart/encrypted&#x7f;text/enriched&#x7f;application/epp+xml&#x7f;application/epub+zip&#x7f;application/eshop&#x7f;application/example&#x7f;audio/example&#x7f;image/example&#x7f;message/example&#x7f;model/example&#x7f;multipart/example&#x7f;text/example&#x7f;video/example&#x7f;application/exi&#x7f;application/expect-ct-report+json&#x7f;message/external-body&#x7f;application/fastinfoset&#x7f;application/fastsoap&#x7f;application/fdt+xml&#x7f;message/feedback-report&#x7f;application/fhir+json&#x7f;application/fhir+xml&#x7f;application/fits&#x7f;image/fits&#x7f;application/flexfec&#x7f;audio/flexfec&#x7f;text/flexfec&#x7f;video/flexfec&#x7f;application/font-tdpfr&#x7f;multipart/form-data&#x7f;application/framework-attributes+xml&#x7f;audio/fwdred&#x7f;text/fwdred&#x7f;image/g3fax&#x7f;application/geo+json&#x7f;application/geo+json-seq&#x7f;application/geopackage+sqlite3&#x7f;application/geoxacml+xml&#x7f;image/gif&#x7f;message/global&#x7f;message/global-delivery-status&#x7f;message/global-disposition-notification&#x7f;message/global-headers&#x7f;model/gltf+json&#x7f;model/gltf-binary&#x7f;application/gltf-buffer&#x7f;application/gml+xml&#x7f;text/grammar-ref-list&#x7f;application/gzip&#x7f;multipart/header-set&#x7f;image/heic&#x7f;image/heic-sequence&#x7f;image/heif&#x7f;image/heif-sequence&#x7f;image/hej2k&#x7f;application/held+xml&#x7f;image/hsj2&#x7f;text/html&#x7f;application/http&#x7f;message/http&#x7f;application/hyperstudio&#x7f;audio/iLBC&#x7f;application/ibe-key-request+xml&#x7f;application/ibe-pkg-reply+xml&#x7f;application/ibe-pp-data&#x7f;image/ief&#x7f;application/iges&#x7f;model/iges&#x7f;application/im-iscomposing+xml&#x7f;message/imdn+xml&#x7f;application/index&#x7f;application/index.cmd&#x7f;application/index.obj&#x7f;application/index.response&#x7f;application/index.vnd&#x7f;application/inkml+xml&#x7f;audio/ip-mr_v2.5&#x7f;application/ipfix&#x7f;application/ipp&#x7f;video/iso.segment&#x7f;application/its+xml&#x7f;application/javascript&#x7f;text/jcr-cnd&#x7f;application/jf2feed+json&#x7f;image/jls&#x7f;application/jose&#x7f;application/jose+json&#x7f;image/jp2&#x7f;image/jpeg&#x7f;video/jpeg2000&#x7f;image/jph&#x7f;image/jphc&#x7f;image/jpm&#x7f;image/jpx&#x7f;application/jrd+json&#x7f;application/json&#x7f;application/json-patch+json&#x7f;application/json-seq&#x7f;application/jwk+json&#x7f;application/jwk-set+json&#x7f;application/jwt&#x7f;image/jxr&#x7f;image/jxrA&#x7f;image/jxrS&#x7f;image/jxs&#x7f;image/jxsc&#x7f;image/jxsi&#x7f;image/jxss&#x7f;application/kpml-request+xml&#x7f;application/kpml-response+xml&#x7f;image/ktx&#x7f;application/ld+json&#x7f;application/lgr+xml&#x7f;application/link-format&#x7f;application/load-control+xml&#x7f;application/lost+xml&#x7f;application/lostsync+xml&#x7f;application/lpf+zip&#x7f;application/mac-binhex40&#x7f;application/macwriteii&#x7f;application/mads+xml&#x7f;application/marc&#x7f;application/marcxml+xml&#x7f;text/markdown&#x7f;application/mathematica&#x7f;application/mathml+xml&#x7f;application/mathml-content+xml&#x7f;application/mathml-presentation+xml&#x7f;application/mbms-associated-procedure-description+xml&#x7f;application/mbms-deregister+xml&#x7f;application/mbms-envelope+xml&#x7f;application/mbms-msk+xml&#x7f;application/mbms-msk-response+xml&#x7f;application/mbms-protection-description+xml&#x7f;application/mbms-reception-report+xml&#x7f;application/mbms-register+xml&#x7f;application/mbms-register-response+xml&#x7f;application/mbms-schedule+xml&#x7f;application/mbms-user-service-description+xml&#x7f;application/mbox&#x7f;application/media-policy-dataset+xml&#x7f;application/media_control+xml&#x7f;application/mediaservercontrol+xml&#x7f;application/merge-patch+json&#x7f;model/mesh&#x7f;application/metalink4+xml&#x7f;application/mets+xml&#x7f;audio/mhas&#x7f;application/mikey&#x7f;application/mipc&#x7f;multipart/mixed&#x7f;text/mizar&#x7f;video/mj2&#x7f;application/mmt-aei+xml&#x7f;application/mmt-usd+xml&#x7f;audio/mobile-xmf&#x7f;application/mods+xml&#x7f;application/moss-keys&#x7f;application/moss-signature&#x7f;application/mosskey-data&#x7f;application/mosskey-request&#x7f;application/mp21&#x7f;application/mp4&#x7f;audio/mp4&#x7f;video/mp4&#x7f;audio/mpa-robust&#x7f;audio/mpeg&#x7f;video/mpeg&#x7f;application/mpeg4-generic&#x7f;audio/mpeg4-generic&#x7f;video/mpeg4-generic&#x7f;application/mpeg4-iod&#x7f;application/mpeg4-iod-xmt&#x7f;application/mrb-consumer+xml&#x7f;application/mrb-publish+xml&#x7f;application/msc-ivr+xml&#x7f;application/msc-mixer+xml&#x7f;application/msword&#x7f;model/mtl&#x7f;application/mud+json&#x7f;multipart/multilingual&#x7f;application/multipart-core&#x7f;application/mxf&#x7f;application/n-quads&#x7f;application/n-triples&#x7f;text/n3&#x7f;image/naplps&#x7f;application/nasdata&#x7f;application/news-checkgroups&#x7f;application/news-groupinfo&#x7f;application/news-transmission&#x7f;application/nlsml+xml&#x7f;application/node&#x7f;application/nss&#x7f;video/nv&#x7f;model/obj&#x7f;application/ocsp-request&#x7f;application/ocsp-response&#x7f;application/octet-stream&#x7f;application/odm+xml&#x7f;application/oebps-package+xml&#x7f;application/ogg&#x7f;audio/ogg&#x7f;video/ogg&#x7f;audio/opus&#x7f;application/oscore&#x7f;font/otf&#x7f;application/oxps&#x7f;application/p2p-overlay+xml&#x7f;multipart/parallel&#x7f;text/parameters&#x7f;application/parityfec&#x7f;audio/parityfec&#x7f;text/parityfec&#x7f;video/parityfec&#x7f;message/partial&#x7f;application/passport&#x7f;application/patch-ops-error+xml&#x7f;application/pdf&#x7f;application/pem-certificate-chain&#x7f;application/pgp-encrypted&#x7f;application/pgp-keys&#x7f;application/pgp-signature&#x7f;application/pidf+xml&#x7f;application/pidf-diff+xml&#x7f;application/pkcs10&#x7f;application/pkcs12&#x7f;application/pkcs7-mime&#x7f;application/pkcs7-signature&#x7f;application/pkcs8&#x7f;application/pkcs8-encrypted&#x7f;application/pkix-attr-cert&#x7f;application/pkix-cert&#x7f;application/pkix-crl&#x7f;application/pkix-pkipath&#x7f;application/pkixcmp&#x7f;text/plain&#x7f;application/pls+xml&#x7f;image/png&#x7f;application/poc-settings+xml&#x7f;video/pointer&#x7f;application/postscript&#x7f;application/ppsp-tracker+json&#x7f;application/problem+json&#x7f;application/problem+xml&#x7f;application/provenance+xml&#x7f;text/provenance-notation&#x7f;application/prs.alvestrand.titrax-sheet&#x7f;image/prs.btif&#x7f;application/prs.cww&#x7f;text/prs.fallenstein.rst&#x7f;application/prs.hpub+zip&#x7f;text/prs.lines.tag&#x7f;application/prs.nprend&#x7f;application/prs.plucker&#x7f;text/prs.prop.logic&#x7f;image/prs.pti&#x7f;application/prs.rdf-xml-crypt&#x7f;audio/prs.sid&#x7f;application/prs.xsf+xml&#x7f;application/pskc+xml&#x7f;application/pvd+json&#x7f;image/pwg-raster&#x7f;video/quicktime&#x7f;application/raptorfec&#x7f;audio/raptorfec&#x7f;text/raptorfec&#x7f;video/raptorfec&#x7f;video/raw&#x7f;application/rdap+json&#x7f;application/rdf+xml&#x7f;application/reginfo+xml&#x7f;multipart/related&#x7f;application/relax-ng-compact-syntax&#x7f;application/remote-printing&#x7f;multipart/report&#x7f;application/reputon+json&#x7f;application/resource-lists+xml&#x7f;application/resource-lists-diff+xml&#x7f;application/rfc+xml&#x7f;message/rfc822&#x7f;text/rfc822-headers&#x7f;text/richtext&#x7f;application/riscos&#x7f;application/rlmi+xml&#x7f;application/rls-services+xml&#x7f;application/route-apd+xml&#x7f;application/route-s-tsid+xml&#x7f;application/route-usd+xml&#x7f;application/rpki-ghostbusters&#x7f;application/rpki-manifest&#x7f;application/rpki-publication&#x7f;application/rpki-roa&#x7f;application/rpki-updown&#x7f;application/rtf&#x7f;text/rtf&#x7f;audio/rtp-enc-aescm128&#x7f;text/rtp-enc-aescm128&#x7f;video/rtp-enc-aescm128&#x7f;audio/rtp-midi&#x7f;application/rtploopback&#x7f;audio/rtploopback&#x7f;text/rtploopback&#x7f;video/rtploopback&#x7f;application/rtx&#x7f;audio/rtx&#x7f;text/rtx&#x7f;video/rtx&#x7f;message/s-http&#x7f;application/samlassertion+xml&#x7f;application/samlmetadata+xml&#x7f;application/sbe&#x7f;application/sbml+xml&#x7f;application/scaip+xml&#x7f;application/scim+json&#x7f;application/scvp-cv-request&#x7f;application/scvp-cv-response&#x7f;application/scvp-vp-request&#x7f;application/scvp-vp-response&#x7f;application/sdp&#x7f;application/secevent+jwt&#x7f;application/senml+cbor&#x7f;application/senml+json&#x7f;application/senml+xml&#x7f;application/senml-etch+cbor&#x7f;application/senml-etch+json&#x7f;application/senml-exi&#x7f;application/sensml+cbor&#x7f;application/sensml+json&#x7f;application/sensml+xml&#x7f;application/sensml-exi&#x7f;application/sep+xml&#x7f;application/sep-exi&#x7f;application/session-info&#x7f;application/set-payment&#x7f;application/set-payment-initiation&#x7f;application/set-registration&#x7f;application/set-registration-initiation&#x7f;font/sfnt&#x7f;application/sgml-open-catalog&#x7f;application/shf+xml&#x7f;application/sieve&#x7f;multipart/signed&#x7f;application/simple-filter+xml&#x7f;application/simple-message-summary&#x7f;application/simpleSymbolContainer&#x7f;message/sip&#x7f;application/sipc&#x7f;message/sipfrag&#x7f;application/slate&#x7f;application/smil+xml&#x7f;video/smpte291&#x7f;application/smpte336m&#x7f;application/soap+fastinfoset&#x7f;application/soap+xml&#x7f;audio/sp-midi&#x7f;application/sparql-query&#x7f;application/sparql-results+xml&#x7f;audio/speex&#x7f;application/spirits-event+xml&#x7f;application/sql&#x7f;application/srgs&#x7f;application/srgs+xml&#x7f;application/sru+xml&#x7f;application/ssml+xml&#x7f;application/stix+json&#x7f;model/stl&#x7f;text/strings&#x7f;image/svg+xml&#x7f;application/swid+xml&#x7f;text/t140&#x7f;audio/t140c&#x7f;audio/t38&#x7f;image/t38&#x7f;text/tab-separated-values&#x7f;application/tamp-apex-update&#x7f;application/tamp-apex-update-confirm&#x7f;application/tamp-community-update&#x7f;application/tamp-community-update-confirm&#x7f;application/tamp-error&#x7f;application/tamp-sequence-adjust&#x7f;application/tamp-sequence-adjust-confirm&#x7f;application/tamp-status-query&#x7f;application/tamp-status-response&#x7f;application/tamp-update&#x7f;application/tamp-update-confirm&#x7f;application/taxii+json&#x7f;application/td+json&#x7f;application/tei+xml&#x7f;audio/telephone-event&#x7f;application/thraud+xml&#x7f;image/tiff&#x7f;image/tiff-fx&#x7f;application/timestamp-query&#x7f;application/timestamp-reply&#x7f;application/timestamped-data&#x7f;application/tlsrpt+gzip&#x7f;application/tlsrpt+json&#x7f;application/tnauthlist&#x7f;audio/tone&#x7f;message/tracking-status&#x7f;application/trickle-ice-sdpfrag&#x7f;application/trig&#x7f;text/troff&#x7f;font/ttf&#x7f;application/ttml+xml&#x7f;text/turtle&#x7f;application/tve-trigger&#x7f;application/tzif&#x7f;application/tzif-leap&#x7f;application/ulpfec&#x7f;audio/ulpfec&#x7f;text/ulpfec&#x7f;video/ulpfec&#x7f;application/urc-grpsheet+xml&#x7f;application/urc-ressheet+xml&#x7f;application/urc-targetdesc+xml&#x7f;application/urc-uisocketdesc+xml&#x7f;text/uri-list&#x7f;audio/usac&#x7f;video/vc1&#x7f;video/vc2&#x7f;text/vcard&#x7f;application/vcard+json&#x7f;application/vcard+xml&#x7f;application/vemmi&#x7f;application/vnd.1000minds.decision-model+xml&#x7f;application/vnd.3M.Post-it-Notes&#x7f;application/vnd.3gpp-prose+xml&#x7f;application/vnd.3gpp-prose-pc3ch+xml&#x7f;application/vnd.3gpp-v2x-local-service-information&#x7f;application/vnd.3gpp.GMOP+xml&#x7f;application/vnd.3gpp.SRVCC-info+xml&#x7f;application/vnd.3gpp.access-transfer-events+xml&#x7f;application/vnd.3gpp.bsf+xml&#x7f;audio/vnd.3gpp.iufp&#x7f;application/vnd.3gpp.mc-signalling-ear&#x7f;application/vnd.3gpp.mcdata-affiliation-command+xml&#x7f;application/vnd.3gpp.mcdata-info+xml&#x7f;application/vnd.3gpp.mcdata-payload&#x7f;application/vnd.3gpp.mcdata-service-config+xml&#x7f;application/vnd.3gpp.mcdata-signalling&#x7f;application/vnd.3gpp.mcdata-ue-config+xml&#x7f;application/vnd.3gpp.mcdata-user-profile+xml&#x7f;application/vnd.3gpp.mcptt-affiliation-command+xml&#x7f;application/vnd.3gpp.mcptt-floor-request+xml&#x7f;application/vnd.3gpp.mcptt-info+xml&#x7f;application/vnd.3gpp.mcptt-location-info+xml&#x7f;application/vnd.3gpp.mcptt-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcptt-service-config+xml&#x7f;application/vnd.3gpp.mcptt-signed+xml&#x7f;application/vnd.3gpp.mcptt-ue-config+xml&#x7f;application/vnd.3gpp.mcptt-ue-init-config+xml&#x7f;application/vnd.3gpp.mcptt-user-profile+xml&#x7f;application/vnd.3gpp.mcvideo-affiliation-command+xml&#x7f;application/vnd.3gpp.mcvideo-info+xml&#x7f;application/vnd.3gpp.mcvideo-location-info+xml&#x7f;application/vnd.3gpp.mcvideo-mbms-usage-info+xml&#x7f;application/vnd.3gpp.mcvideo-service-config+xml&#x7f;application/vnd.3gpp.mcvideo-transmission-request+xml&#x7f;application/vnd.3gpp.mcvideo-ue-config+xml&#x7f;application/vnd.3gpp.mcvideo-user-profile+xml&#x7f;application/vnd.3gpp.mid-call+xml&#x7f;application/vnd.3gpp.pic-bw-large&#x7f;application/vnd.3gpp.pic-bw-small&#x7f;application/vnd.3gpp.pic-bw-var&#x7f;application/vnd.3gpp.sms&#x7f;application/vnd.3gpp.sms+xml&#x7f;application/vnd.3gpp.srvcc-ext+xml&#x7f;application/vnd.3gpp.state-and-event-info+xml&#x7f;application/vnd.3gpp.ussd+xml&#x7f;application/vnd.3gpp2.bcmcsinfo+xml&#x7f;application/vnd.3gpp2.sms&#x7f;application/vnd.3gpp2.tcap&#x7f;application/vnd.3lightssoftware.imagescal&#x7f;audio/vnd.4SB&#x7f;video/vnd.CCTV&#x7f;audio/vnd.CELP&#x7f;text/vnd.DMClientScript&#x7f;application/vnd.FloGraphIt&#x7f;application/vnd.HandHeld-Entertainment+xml&#x7f;text/vnd.IPTC.NITF&#x7f;text/vnd.IPTC.NewsML&#x7f;application/vnd.Kinar&#x7f;application/vnd.MFER&#x7f;application/vnd.Mobius.DAF&#x7f;application/vnd.Mobius.DIS&#x7f;application/vnd.Mobius.MBK&#x7f;application/vnd.Mobius.MQY&#x7f;application/vnd.Mobius.MSL&#x7f;application/vnd.Mobius.PLC&#x7f;application/vnd.Mobius.TXF&#x7f;application/vnd.Quark.QuarkXPress&#x7f;application/vnd.RenLearn.rlprint&#x7f;application/vnd.SimTech-MindMapper&#x7f;text/vnd.a&#x7f;text/vnd.abc&#x7f;application/vnd.accpac.simply.aso&#x7f;application/vnd.accpac.simply.imp&#x7f;application/vnd.acucobol&#x7f;application/vnd.acucorp&#x7f;application/vnd.adobe.flash.movie&#x7f;application/vnd.adobe.formscentral.fcdt&#x7f;application/vnd.adobe.fxp&#x7f;application/vnd.adobe.partial-upload&#x7f;image/vnd.adobe.photoshop&#x7f;application/vnd.adobe.xdp+xml&#x7f;application/vnd.adobe.xfdf&#x7f;application/vnd.aether.imp&#x7f;application/vnd.afpc.afplinedata&#x7f;application/vnd.afpc.afplinedata-pagedef&#x7f;application/vnd.afpc.foca-charset&#x7f;application/vnd.afpc.foca-codedfont&#x7f;application/vnd.afpc.foca-codepage&#x7f;application/vnd.afpc.modca&#x7f;application/vnd.afpc.modca-formdef&#x7f;application/vnd.afpc.modca-mediummap&#x7f;application/vnd.afpc.modca-objectcontainer&#x7f;application/vnd.afpc.modca-overlay&#x7f;application/vnd.afpc.modca-pagesegment&#x7f;application/vnd.ah-barcode&#x7f;application/vnd.ahead.space&#x7f;image/vnd.airzip.accelerator.azv&#x7f;application/vnd.airzip.filesecure.azf&#x7f;application/vnd.airzip.filesecure.azs&#x7f;application/vnd.amadeus+json&#x7f;application/vnd.amazon.mobi8-ebook&#x7f;application/vnd.americandynamics.acc&#x7f;application/vnd.amiga.ami&#x7f;application/vnd.amundsen.maze+xml&#x7f;application/vnd.android.ota&#x7f;application/vnd.anki&#x7f;application/vnd.anser-web-certificate-issue-initiation&#x7f;application/vnd.antix.game-component&#x7f;application/vnd.apache.thrift.binary&#x7f;application/vnd.apache.thrift.compact&#x7f;application/vnd.apache.thrift.json&#x7f;application/vnd.api+json&#x7f;application/vnd.aplextor.warrp+json&#x7f;application/vnd.apothekende.reservation+json&#x7f;application/vnd.apple.installer+xml&#x7f;application/vnd.apple.keynote&#x7f;application/vnd.apple.mpegurl&#x7f;application/vnd.apple.numbers&#x7f;application/vnd.apple.pages&#x7f;application/vnd.aristanetworks.swi&#x7f;application/vnd.artisan+json&#x7f;application/vnd.artsquare&#x7f;text/vnd.ascii-art&#x7f;application/vnd.astraea-software.iota&#x7f;application/vnd.audiograph&#x7f;audio/vnd.audiokoz&#x7f;application/vnd.autopackage&#x7f;application/vnd.avalon+json&#x7f;application/vnd.avistar+xml&#x7f;application/vnd.balsamiq.bmml+xml&#x7f;application/vnd.balsamiq.bmpr&#x7f;application/vnd.banana-accounting&#x7f;application/vnd.bbf.usp.error&#x7f;application/vnd.bbf.usp.msg&#x7f;application/vnd.bbf.usp.msg+json&#x7f;application/vnd.bekitzur-stech+json&#x7f;application/vnd.bint.med-content&#x7f;multipart/vnd.bint.med-plus&#x7f;application/vnd.biopax.rdf+xml&#x7f;application/vnd.blink-idb-value-wrapper&#x7f;application/vnd.blueice.multipass&#x7f;application/vnd.bluetooth.ep.oob&#x7f;application/vnd.bluetooth.le.oob&#x7f;application/vnd.bmi&#x7f;application/vnd.bpf&#x7f;application/vnd.bpf3&#x7f;application/vnd.businessobjects&#x7f;application/vnd.byu.uapi+json&#x7f;application/vnd.cab-jscript&#x7f;application/vnd.canon-cpdl&#x7f;application/vnd.canon-lips&#x7f;application/vnd.capasystems-pg+json&#x7f;application/vnd.cendio.thinlinc.clientconf&#x7f;application/vnd.century-systems.tcp_stream&#x7f;application/vnd.chemdraw+xml&#x7f;application/vnd.chess-pgn&#x7f;application/vnd.chipnuts.karaoke-mmd&#x7f;application/vnd.ciedi&#x7f;application/vnd.cinderella&#x7f;application/vnd.cirpack.isdn-ext&#x7f;audio/vnd.cisco.nse&#x7f;application/vnd.citationstyles.style+xml&#x7f;application/vnd.claymore&#x7f;application/vnd.cloanto.rp9&#x7f;application/vnd.clonk.c4group&#x7f;application/vnd.cluetrust.cartomobile-config&#x7f;application/vnd.cluetrust.cartomobile-config-pkg&#x7f;audio/vnd.cmles.radio-events&#x7f;audio/vnd.cns.anp1&#x7f;audio/vnd.cns.inf1&#x7f;image/vnd.cns.inf2&#x7f;application/vnd.coffeescript&#x7f;application/vnd.collabio.xodocuments.document&#x7f;application/vnd.collabio.xodocuments.document-template&#x7f;application/vnd.collabio.xodocuments.presentation&#x7f;application/vnd.collabio.xodocuments.presentation-template&#x7f;application/vnd.collabio.xodocuments.spreadsheet&#x7f;application/vnd.collabio.xodocuments.spreadsheet-template&#x7f;model/vnd.collada+xml&#x7f;application/vnd.collection+json&#x7f;application/vnd.collection.doc+json&#x7f;application/vnd.collection.next+json&#x7f;application/vnd.comicbook+zip&#x7f;application/vnd.comicbook-rar&#x7f;application/vnd.commerce-battelle&#x7f;application/vnd.commonspace&#x7f;application/vnd.contact.cmsg&#x7f;application/vnd.coreos.ignition+json&#x7f;application/vnd.cosmocaller&#x7f;application/vnd.crick.clicker&#x7f;application/vnd.crick.clicker.keyboard&#x7f;application/vnd.crick.clicker.palette&#x7f;application/vnd.crick.clicker.template&#x7f;application/vnd.crick.clicker.wordbank&#x7f;application/vnd.criticaltools.wbs+xml&#x7f;application/vnd.cryptii.pipe+json&#x7f;application/vnd.crypto-shade-file&#x7f;application/vnd.ctc-posml&#x7f;application/vnd.ctct.ws+xml&#x7f;application/vnd.cups-pdf&#x7f;application/vnd.cups-postscript&#x7f;application/vnd.cups-ppd&#x7f;application/vnd.cups-raster&#x7f;application/vnd.cups-raw&#x7f;application/vnd.curl&#x7f;text/vnd.curl&#x7f;application/vnd.cyan.dean.root+xml&#x7f;application/vnd.cybank&#x7f;application/vnd.d2l.coursepackage1p0+zip&#x7f;application/vnd.dart&#x7f;application/vnd.data-vision.rdz&#x7f;application/vnd.datapackage+json&#x7f;application/vnd.dataresource+json&#x7f;application/vnd.dbf&#x7f;application/vnd.debian.binary-package&#x7f;text/vnd.debian.copyright&#x7f;audio/vnd.dece.audio&#x7f;application/vnd.dece.data&#x7f;image/vnd.dece.graphic&#x7f;video/vnd.dece.hd&#x7f;video/vnd.dece.mobile&#x7f;video/vnd.dece.mp4&#x7f;video/vnd.dece.pd&#x7f;video/vnd.dece.sd&#x7f;application/vnd.dece.ttml+xml&#x7f;application/vnd.dece.unspecified&#x7f;video/vnd.dece.video&#x7f;application/vnd.dece.zip&#x7f;application/vnd.denovo.fcselayout-link&#x7f;application/vnd.desmume.movie&#x7f;audio/vnd.digital-winds&#x7f;application/vnd.dir-bi.plate-dl-nosuffix&#x7f;video/vnd.directv.mpeg&#x7f;video/vnd.directv.mpeg-tts&#x7f;image/vnd.djvu&#x7f;audio/vnd.dlna.adts&#x7f;video/vnd.dlna.mpeg-tts&#x7f;application/vnd.dm.delegation+xml&#x7f;application/vnd.dna&#x7f;application/vnd.document+json&#x7f;audio/vnd.dolby.heaac.1&#x7f;audio/vnd.dolby.heaac.2&#x7f;audio/vnd.dolby.mlp&#x7f;application/vnd.dolby.mobile.1&#x7f;application/vnd.dolby.mobile.2&#x7f;audio/vnd.dolby.mps&#x7f;audio/vnd.dolby.pl2&#x7f;audio/vnd.dolby.pl2x&#x7f;audio/vnd.dolby.pl2z&#x7f;audio/vnd.dolby.pulse.1&#x7f;application/vnd.doremir.scorecloud-binary-document&#x7f;application/vnd.dpgraph&#x7f;audio/vnd.dra&#x7f;application/vnd.dreamfactory&#x7f;application/vnd.drive+json&#x7f;application/vnd.dtg.local&#x7f;application/vnd.dtg.local.flash&#x7f;application/vnd.dtg.local.html&#x7f;audio/vnd.dts&#x7f;audio/vnd.dts.hd&#x7f;audio/vnd.dts.uhd&#x7f;application/vnd.dvb.ait&#x7f;application/vnd.dvb.dvbisl+xml&#x7f;application/vnd.dvb.dvbj&#x7f;application/vnd.dvb.esgcontainer&#x7f;audio/vnd.dvb.file&#x7f;video/vnd.dvb.file&#x7f;application/vnd.dvb.ipdcdftnotifaccess&#x7f;application/vnd.dvb.ipdcesgaccess&#x7f;application/vnd.dvb.ipdcesgaccess2&#x7f;application/vnd.dvb.ipdcesgpdd&#x7f;application/vnd.dvb.ipdcroaming&#x7f;application/vnd.dvb.iptv.alfec-base&#x7f;application/vnd.dvb.iptv.alfec-enhancement&#x7f;application/vnd.dvb.notif-aggregate-root+xml&#x7f;application/vnd.dvb.notif-container+xml&#x7f;application/vnd.dvb.notif-generic+xml&#x7f;application/vnd.dvb.notif-ia-msglist+xml&#x7f;application/vnd.dvb.notif-ia-registration-request+xml&#x7f;application/vnd.dvb.notif-ia-registration-response+xml&#x7f;application/vnd.dvb.notif-init+xml&#x7f;application/vnd.dvb.pfr&#x7f;application/vnd.dvb.service&#x7f;image/vnd.dvb.subtitle&#x7f;text/vnd.dvb.subtitle&#x7f;model/vnd.dwf&#x7f;image/vnd.dwg&#x7f;image/vnd.dxf&#x7f;application/vnd.dxr&#x7f;application/vnd.dynageo&#x7f;application/vnd.dzr&#x7f;application/vnd.easykaraoke.cdgdownload&#x7f;application/vnd.ecdis-update&#x7f;application/vnd.ecip.rlp&#x7f;application/vnd.ecowin.chart&#x7f;application/vnd.ecowin.filerequest&#x7f;application/vnd.ecowin.fileupdate&#x7f;application/vnd.ecowin.series&#x7f;application/vnd.ecowin.seriesrequest&#x7f;application/vnd.ecowin.seriesupdate&#x7f;application/vnd.efi.img&#x7f;application/vnd.efi.iso&#x7f;application/vnd.emclient.accessrequest+xml&#x7f;application/vnd.enliven&#x7f;application/vnd.enphase.envoy&#x7f;application/vnd.eprints.data+xml&#x7f;application/vnd.epson.esf&#x7f;application/vnd.epson.msf&#x7f;application/vnd.epson.quickanime&#x7f;application/vnd.epson.salt&#x7f;application/vnd.epson.ssf&#x7f;application/vnd.ericsson.quickcall&#x7f;text/vnd.esmertec.theme-descriptor&#x7f;application/vnd.espass-espass+zip&#x7f;application/vnd.eszigno3+xml&#x7f;application/vnd.etsi.aoc+xml&#x7f;application/vnd.etsi.asic-e+zip&#x7f;application/vnd.etsi.asic-s+zip&#x7f;application/vnd.etsi.cug+xml&#x7f;application/vnd.etsi.iptvcommand+xml&#x7f;application/vnd.etsi.iptvdiscovery+xml&#x7f;application/vnd.etsi.iptvprofile+xml&#x7f;application/vnd.etsi.iptvsad-bc+xml&#x7f;application/vnd.etsi.iptvsad-cod+xml&#x7f;application/vnd.etsi.iptvsad-npvr+xml&#x7f;application/vnd.etsi.iptvservice+xml&#x7f;application/vnd.etsi.iptvsync+xml&#x7f;application/vnd.etsi.iptvueprofile+xml&#x7f;application/vnd.etsi.mcid+xml&#x7f;application/vnd.etsi.mheg5&#x7f;application/vnd.etsi.overload-control-policy-dataset+xml&#x7f;application/vnd.etsi.pstn+xml&#x7f;application/vnd.etsi.sci+xml&#x7f;application/vnd.etsi.simservs+xml&#x7f;application/vnd.etsi.timestamp-token&#x7f;application/vnd.etsi.tsl+xml&#x7f;application/vnd.etsi.tsl.der&#x7f;application/vnd.eudora.data&#x7f;audio/vnd.everad.plj&#x7f;application/vnd.evolv.ecig.profile&#x7f;application/vnd.evolv.ecig.settings&#x7f;application/vnd.evolv.ecig.theme&#x7f;application/vnd.exstream-empower+zip&#x7f;application/vnd.exstream-package&#x7f;application/vnd.ezpix-album&#x7f;application/vnd.ezpix-package&#x7f;application/vnd.f-secure.mobile&#x7f;image/vnd.fastbidsheet&#x7f;application/vnd.fastcopy-disk-image&#x7f;application/vnd.fdf&#x7f;application/vnd.fdsn.mseed&#x7f;application/vnd.fdsn.seed&#x7f;application/vnd.ffsns&#x7f;application/vnd.ficlab.flb+zip&#x7f;text/vnd.ficlab.flt&#x7f;application/vnd.filmit.zfc&#x7f;application/vnd.fints&#x7f;application/vnd.firemonkeys.cloudcell&#x7f;model/vnd.flatland.3dml&#x7f;application/vnd.fluxtime.clip&#x7f;text/vnd.fly&#x7f;text/vnd.fmi.flexstor&#x7f;application/vnd.font-fontforge-sfd&#x7f;image/vnd.fpx&#x7f;application/vnd.framemaker&#x7f;application/vnd.frogans.fnc&#x7f;application/vnd.frogans.ltf&#x7f;application/vnd.fsc.weblaunch&#x7f;image/vnd.fst&#x7f;application/vnd.fujitsu.oasys&#x7f;application/vnd.fujitsu.oasys2&#x7f;application/vnd.fujitsu.oasys3&#x7f;application/vnd.fujitsu.oasysgp&#x7f;application/vnd.fujitsu.oasysprs&#x7f;application/vnd.fujixerox.ART-EX&#x7f;application/vnd.fujixerox.ART4&#x7f;application/vnd.fujixerox.HBPL&#x7f;application/vnd.fujixerox.ddd&#x7f;application/vnd.fujixerox.docuworks&#x7f;application/vnd.fujixerox.docuworks.binder&#x7f;application/vnd.fujixerox.docuworks.container&#x7f;image/vnd.fujixerox.edmics-mmr&#x7f;image/vnd.fujixerox.edmics-rlc&#x7f;application/vnd.fut-misnet&#x7f;application/vnd.futoin+cbor&#x7f;application/vnd.futoin+json&#x7f;application/vnd.fuzzysheet&#x7f;video/vnd.fvt&#x7f;model/vnd.gdl&#x7f;application/vnd.genomatix.tuxedo&#x7f;application/vnd.gentics.grd+json&#x7f;application/vnd.geogebra.file&#x7f;application/vnd.geogebra.tool&#x7f;application/vnd.geometry-explorer&#x7f;application/vnd.geonext&#x7f;application/vnd.geoplan&#x7f;application/vnd.geospace&#x7f;application/vnd.gerber&#x7f;image/vnd.globalgraphics.pgb&#x7f;application/vnd.globalplatform.card-content-mgt&#x7f;application/vnd.globalplatform.card-content-mgt-response&#x7f;text/vnd.gml&#x7f;application/vnd.google-earth.kml+xml&#x7f;application/vnd.google-earth.kmz&#x7f;application/vnd.gov.sk.e-form+xml&#x7f;application/vnd.gov.sk.e-form+zip&#x7f;application/vnd.gov.sk.xmldatacontainer+xml&#x7f;application/vnd.grafeq&#x7f;text/vnd.graphviz&#x7f;application/vnd.gridmp&#x7f;application/vnd.groove-account&#x7f;application/vnd.groove-help&#x7f;application/vnd.groove-identity-message&#x7f;application/vnd.groove-injector&#x7f;application/vnd.groove-tool-message&#x7f;application/vnd.groove-tool-template&#x7f;application/vnd.groove-vcard&#x7f;model/vnd.gs-gdl&#x7f;model/vnd.gtw&#x7f;application/vnd.hal+json&#x7f;application/vnd.hal+xml&#x7f;application/vnd.hbci&#x7f;application/vnd.hc+json&#x7f;application/vnd.hcl-bireports&#x7f;application/vnd.hdt&#x7f;application/vnd.heroku+json&#x7f;text/vnd.hgl&#x7f;application/vnd.hhe.lesson-player&#x7f;audio/vnd.hns.audio&#x7f;video/vnd.hns.video&#x7f;application/vnd.hp-HPGL&#x7f;application/vnd.hp-PCL&#x7f;application/vnd.hp-PCLXL&#x7f;application/vnd.hp-hpid&#x7f;application/vnd.hp-hps&#x7f;application/vnd.hp-jlyt&#x7f;application/vnd.httphone&#x7f;application/vnd.hydrostatix.sof-data&#x7f;application/vnd.hyper+json&#x7f;application/vnd.hyper-item+json&#x7f;application/vnd.hyperdrive+json&#x7f;application/vnd.hzn-3d-crossword&#x7f;application/vnd.ibm.MiniPay&#x7f;application/vnd.ibm.electronic-media&#x7f;application/vnd.ibm.rights-management&#x7f;application/vnd.ibm.secure-container&#x7f;application/vnd.iccprofile&#x7f;application/vnd.ieee.1905&#x7f;application/vnd.igloader&#x7f;application/vnd.imagemeter.folder+zip&#x7f;application/vnd.imagemeter.image+zip&#x7f;application/vnd.immervision-ivp&#x7f;application/vnd.immervision-ivu&#x7f;application/vnd.ims.imsccv1p1&#x7f;application/vnd.ims.imsccv1p2&#x7f;application/vnd.ims.imsccv1p3&#x7f;application/vnd.ims.lis.v2.result+json&#x7f;application/vnd.ims.lti.v2.toolconsumerprofile+json&#x7f;application/vnd.ims.lti.v2.toolproxy+json&#x7f;application/vnd.ims.lti.v2.toolproxy.id+json&#x7f;application/vnd.ims.lti.v2.toolsettings+json&#x7f;application/vnd.ims.lti.v2.toolsettings.simple+json&#x7f;text/vnd.in3d.3dml&#x7f;text/vnd.in3d.spot&#x7f;application/vnd.informedcontrol.rms+xml&#x7f;application/vnd.infotech.project&#x7f;application/vnd.infotech.project+xml&#x7f;application/vnd.innopath.wamp.notification&#x7f;application/vnd.insors.igm&#x7f;application/vnd.intercon.formnet&#x7f;application/vnd.intergeo&#x7f;application/vnd.intertrust.digibox&#x7f;application/vnd.intertrust.nncp&#x7f;application/vnd.intu.qbo&#x7f;application/vnd.intu.qfx&#x7f;application/vnd.iptc.g2.catalogitem+xml&#x7f;application/vnd.iptc.g2.conceptitem+xml&#x7f;application/vnd.iptc.g2.knowledgeitem+xml&#x7f;application/vnd.iptc.g2.newsitem+xml&#x7f;application/vnd.iptc.g2.newsmessage+xml&#x7f;application/vnd.iptc.g2.packageitem+xml&#x7f;application/vnd.iptc.g2.planningitem+xml&#x7f;video/vnd.iptvforum.1dparityfec-1010&#x7f;video/vnd.iptvforum.1dparityfec-2005&#x7f;video/vnd.iptvforum.2dparityfec-1010&#x7f;video/vnd.iptvforum.2dparityfec-2005&#x7f;video/vnd.iptvforum.ttsavc&#x7f;video/vnd.iptvforum.ttsmpeg2&#x7f;application/vnd.ipunplugged.rcprofile&#x7f;application/vnd.irepository.package+xml&#x7f;application/vnd.is-xpr&#x7f;application/vnd.isac.fcs&#x7f;application/vnd.iso11783-10+zip&#x7f;application/vnd.jam&#x7f;application/vnd.japannet-directory-service&#x7f;application/vnd.japannet-jpnstore-wakeup&#x7f;application/vnd.japannet-payment-wakeup&#x7f;application/vnd.japannet-registration&#x7f;application/vnd.japannet-registration-wakeup&#x7f;application/vnd.japannet-setstore-wakeup&#x7f;application/vnd.japannet-verification&#x7f;application/vnd.japannet-verification-wakeup&#x7f;application/vnd.jcp.javame.midlet-rms&#x7f;application/vnd.jisp&#x7f;application/vnd.joost.joda-archive&#x7f;application/vnd.jsk.isdn-ngn&#x7f;application/vnd.kahootz&#x7f;application/vnd.kde.karbon&#x7f;application/vnd.kde.kchart&#x7f;application/vnd.kde.kformula&#x7f;application/vnd.kde.kivio&#x7f;application/vnd.kde.kontour&#x7f;application/vnd.kde.kpresenter&#x7f;application/vnd.kde.kspread&#x7f;application/vnd.kde.kword&#x7f;application/vnd.kenameaapp&#x7f;application/vnd.kidspiration&#x7f;application/vnd.koan&#x7f;application/vnd.kodak-descriptor&#x7f;application/vnd.las&#x7f;application/vnd.las.las+json&#x7f;application/vnd.las.las+xml&#x7f;application/vnd.laszip&#x7f;text/vnd.latex-z&#x7f;application/vnd.leap+json&#x7f;application/vnd.liberty-request+xml&#x7f;application/vnd.llamagraphics.life-balance.desktop&#x7f;application/vnd.llamagraphics.life-balance.exchange+xml&#x7f;application/vnd.logipipe.circuit+zip&#x7f;application/vnd.loom&#x7f;application/vnd.lotus-1-2-3&#x7f;application/vnd.lotus-approach&#x7f;application/vnd.lotus-freelance&#x7f;application/vnd.lotus-notes&#x7f;application/vnd.lotus-organizer&#x7f;application/vnd.lotus-screencam&#x7f;application/vnd.lotus-wordpro&#x7f;audio/vnd.lucent.voice&#x7f;application/vnd.macports.portpkg&#x7f;application/vnd.mapbox-vector-tile&#x7f;application/vnd.marlin.drm.actiontoken+xml&#x7f;application/vnd.marlin.drm.conftoken+xml&#x7f;application/vnd.marlin.drm.license+xml&#x7f;application/vnd.marlin.drm.mdcf&#x7f;application/vnd.mason+json&#x7f;application/vnd.maxmind.maxmind-db&#x7f;application/vnd.mcd&#x7f;application/vnd.medcalcdata&#x7f;application/vnd.mediastation.cdkey&#x7f;application/vnd.meridian-slingshot&#x7f;application/vnd.mfmp&#x7f;application/vnd.micro+json&#x7f;application/vnd.micrografx.flo&#x7f;application/vnd.micrografx.igx&#x7f;image/vnd.microsoft.icon&#x7f;application/vnd.microsoft.portable-executable&#x7f;application/vnd.microsoft.windows.thumbnail-cache&#x7f;application/vnd.miele+json&#x7f;application/vnd.mif&#x7f;application/vnd.minisoft-hp3000-save&#x7f;application/vnd.mitsubishi.misty-guard.trustweb&#x7f;image/vnd.mix&#x7f;model/vnd.moml+xml&#x7f;application/vnd.mophun.application&#x7f;application/vnd.mophun.certificate&#x7f;application/vnd.motorola.flexsuite&#x7f;application/vnd.motorola.flexsuite.adsi&#x7f;application/vnd.motorola.flexsuite.fis&#x7f;application/vnd.motorola.flexsuite.gotap&#x7f;application/vnd.motorola.flexsuite.kmr&#x7f;application/vnd.motorola.flexsuite.ttc&#x7f;application/vnd.motorola.flexsuite.wem&#x7f;application/vnd.motorola.iprm&#x7f;text/vnd.motorola.reflex&#x7f;video/vnd.motorola.video&#x7f;video/vnd.motorola.videop&#x7f;image/vnd.mozilla.apng&#x7f;application/vnd.mozilla.xul+xml&#x7f;video/vnd.mpegurl&#x7f;application/vnd.ms-3mfdocument&#x7f;application/vnd.ms-PrintDeviceCapabilities+xml&#x7f;application/vnd.ms-PrintSchemaTicket+xml&#x7f;application/vnd.ms-artgalry&#x7f;application/vnd.ms-asf&#x7f;application/vnd.ms-cab-compressed&#x7f;application/vnd.ms-excel&#x7f;application/vnd.ms-excel.addin.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.binary.macroEnabled.12&#x7f;application/vnd.ms-excel.sheet.macroEnabled.12&#x7f;application/vnd.ms-excel.template.macroEnabled.12&#x7f;application/vnd.ms-fontobject&#x7f;application/vnd.ms-htmlhelp&#x7f;application/vnd.ms-ims&#x7f;application/vnd.ms-lrm&#x7f;text/vnd.ms-mediapackage&#x7f;image/vnd.ms-modi&#x7f;application/vnd.ms-office.activeX+xml&#x7f;application/vnd.ms-officetheme&#x7f;application/vnd.ms-playready.initiator+xml&#x7f;audio/vnd.ms-playready.media.pya&#x7f;video/vnd.ms-playready.media.pyv&#x7f;application/vnd.ms-powerpoint&#x7f;application/vnd.ms-powerpoint.addin.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.presentation.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slide.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.slideshow.macroEnabled.12&#x7f;application/vnd.ms-powerpoint.template.macroEnabled.12&#x7f;application/vnd.ms-project&#x7f;application/vnd.ms-tnef&#x7f;application/vnd.ms-windows.devicepairing&#x7f;application/vnd.ms-windows.nwprinting.oob&#x7f;application/vnd.ms-windows.printerpairing&#x7f;application/vnd.ms-windows.wsd.oob&#x7f;application/vnd.ms-wmdrm.lic-chlg-req&#x7f;application/vnd.ms-wmdrm.lic-resp&#x7f;application/vnd.ms-wmdrm.meter-chlg-req&#x7f;application/vnd.ms-wmdrm.meter-resp&#x7f;application/vnd.ms-word.document.macroEnabled.12&#x7f;application/vnd.ms-word.template.macroEnabled.12&#x7f;application/vnd.ms-works&#x7f;application/vnd.ms-wpl&#x7f;application/vnd.ms-xpsdocument&#x7f;application/vnd.msa-disk-image&#x7f;application/vnd.mseq&#x7f;application/vnd.msign&#x7f;model/vnd.mts&#x7f;application/vnd.multiad.creator&#x7f;application/vnd.multiad.creator.cif&#x7f;application/vnd.music-niff&#x7f;application/vnd.musician&#x7f;application/vnd.muvee.style&#x7f;application/vnd.mynfc&#x7f;application/vnd.ncd.control&#x7f;application/vnd.ncd.reference&#x7f;application/vnd.nearst.inv+json&#x7f;application/vnd.nervana&#x7f;image/vnd.net-fpx&#x7f;text/vnd.net2phone.commcenter.command&#x7f;application/vnd.netfpx&#x7f;application/vnd.neurolanguage.nlu&#x7f;application/vnd.nimn&#x7f;application/vnd.nintendo.nitro.rom&#x7f;application/vnd.nintendo.snes.rom&#x7f;application/vnd.nitf&#x7f;application/vnd.noblenet-directory&#x7f;application/vnd.noblenet-sealer&#x7f;application/vnd.noblenet-web&#x7f;application/vnd.nokia.catalogs&#x7f;application/vnd.nokia.conml+wbxml&#x7f;application/vnd.nokia.conml+xml&#x7f;application/vnd.nokia.iSDS-radio-presets&#x7f;video/vnd.nokia.interleaved-multimedia&#x7f;application/vnd.nokia.iptv.config+xml&#x7f;application/vnd.nokia.landmark+wbxml&#x7f;application/vnd.nokia.landmark+xml&#x7f;application/vnd.nokia.landmarkcollection+xml&#x7f;audio/vnd.nokia.mobile-xmf&#x7f;video/vnd.nokia.mp4vr&#x7f;application/vnd.nokia.n-gage.ac+xml&#x7f;application/vnd.nokia.n-gage.data&#x7f;application/vnd.nokia.ncd&#x7f;application/vnd.nokia.pcd+wbxml&#x7f;application/vnd.nokia.pcd+xml&#x7f;application/vnd.nokia.radio-preset&#x7f;application/vnd.nokia.radio-presets&#x7f;video/vnd.nokia.videovoip&#x7f;audio/vnd.nortel.vbk&#x7f;application/vnd.novadigm.EDM&#x7f;application/vnd.novadigm.EDX&#x7f;application/vnd.novadigm.EXT&#x7f;application/vnd.ntt-local.content-share&#x7f;application/vnd.ntt-local.file-transfer&#x7f;application/vnd.ntt-local.ogw_remote-access&#x7f;application/vnd.ntt-local.sip-ta_remote&#x7f;application/vnd.ntt-local.sip-ta_tcp_stream&#x7f;audio/vnd.nuera.ecelp4800&#x7f;audio/vnd.nuera.ecelp7470&#x7f;audio/vnd.nuera.ecelp9600&#x7f;application/vnd.oasis.opendocument.chart&#x7f;application/vnd.oasis.opendocument.chart-template&#x7f;application/vnd.oasis.opendocument.database&#x7f;application/vnd.oasis.opendocument.formula&#x7f;application/vnd.oasis.opendocument.formula-template&#x7f;application/vnd.oasis.opendocument.graphics&#x7f;application/vnd.oasis.opendocument.graphics-template&#x7f;application/vnd.oasis.opendocument.image&#x7f;application/vnd.oasis.opendocument.image-template&#x7f;application/vnd.oasis.opendocument.presentation&#x7f;application/vnd.oasis.opendocument.presentation-template&#x7f;application/vnd.oasis.opendocument.spreadsheet&#x7f;application/vnd.oasis.opendocument.spreadsheet-template&#x7f;application/vnd.oasis.opendocument.text&#x7f;application/vnd.oasis.opendocument.text-master&#x7f;application/vnd.oasis.opendocument.text-template&#x7f;application/vnd.oasis.opendocument.text-web&#x7f;video/vnd.objectvideo&#x7f;application/vnd.obn&#x7f;application/vnd.ocf+cbor&#x7f;application/vnd.oci.image.manifest.v1+json&#x7f;audio/vnd.octel.sbc&#x7f;application/vnd.oftn.l10n+json&#x7f;application/vnd.oipf.contentaccessdownload+xml&#x7f;application/vnd.oipf.contentaccessstreaming+xml&#x7f;application/vnd.oipf.cspg-hexbinary&#x7f;application/vnd.oipf.dae.svg+xml&#x7f;application/vnd.oipf.dae.xhtml+xml&#x7f;application/vnd.oipf.mippvcontrolmessage+xml&#x7f;application/vnd.oipf.pae.gem&#x7f;application/vnd.oipf.spdiscovery+xml&#x7f;application/vnd.oipf.spdlist+xml&#x7f;application/vnd.oipf.ueprofile+xml&#x7f;application/vnd.oipf.userprofile+xml&#x7f;application/vnd.olpc-sugar&#x7f;application/vnd.oma-scws-config&#x7f;application/vnd.oma-scws-http-request&#x7f;application/vnd.oma-scws-http-response&#x7f;application/vnd.oma.bcast.associated-procedure-parameter+xml&#x7f;application/vnd.oma.bcast.drm-trigger+xml&#x7f;application/vnd.oma.bcast.imd+xml&#x7f;application/vnd.oma.bcast.ltkm&#x7f;application/vnd.oma.bcast.notification+xml&#x7f;application/vnd.oma.bcast.provisioningtrigger&#x7f;application/vnd.oma.bcast.sgboot&#x7f;application/vnd.oma.bcast.sgdd+xml&#x7f;application/vnd.oma.bcast.sgdu&#x7f;application/vnd.oma.bcast.simple-symbol-container&#x7f;application/vnd.oma.bcast.smartcard-trigger+xml&#x7f;application/vnd.oma.bcast.sprov+xml&#x7f;application/vnd.oma.bcast.stkm&#x7f;application/vnd.oma.cab-address-book+xml&#x7f;application/vnd.oma.cab-feature-handler+xml&#x7f;application/vnd.oma.cab-pcc+xml&#x7f;application/vnd.oma.cab-subs-invite+xml&#x7f;application/vnd.oma.cab-user-prefs+xml&#x7f;application/vnd.oma.dcd&#x7f;application/vnd.oma.dcdc&#x7f;application/vnd.oma.dd2+xml&#x7f;application/vnd.oma.drm.risd+xml&#x7f;application/vnd.oma.group-usage-list+xml&#x7f;application/vnd.oma.lwm2m+json&#x7f;application/vnd.oma.lwm2m+tlv&#x7f;application/vnd.oma.pal+xml&#x7f;application/vnd.oma.poc.detailed-progress-report+xml&#x7f;application/vnd.oma.poc.final-report+xml&#x7f;application/vnd.oma.poc.groups+xml&#x7f;application/vnd.oma.poc.invocation-descriptor+xml&#x7f;application/vnd.oma.poc.optimized-progress-report+xml&#x7f;application/vnd.oma.push&#x7f;application/vnd.oma.scidm.messages+xml&#x7f;application/vnd.oma.xcap-directory+xml&#x7f;application/vnd.omads-email+xml&#x7f;application/vnd.omads-file+xml&#x7f;application/vnd.omads-folder+xml&#x7f;application/vnd.omaloc-supl-init&#x7f;application/vnd.onepager&#x7f;application/vnd.onepagertamp&#x7f;application/vnd.onepagertamx&#x7f;application/vnd.onepagertat&#x7f;application/vnd.onepagertatp&#x7f;application/vnd.onepagertatx&#x7f;application/vnd.openblox.game+xml&#x7f;application/vnd.openblox.game-binary&#x7f;application/vnd.openeye.oeb&#x7f;model/vnd.opengex&#x7f;application/vnd.openstreetmap.data+xml&#x7f;application/vnd.openxmlformats-officedocument.custom-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.customXmlProperties+xml&#x7f;application/vnd.openxmlformats-officedocument.drawing+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chart+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml&#x7f;application/vnd.openxmlformats-officedocument.extended-properties+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presProps+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation&#x7f;application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slide+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow&#x7f;application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.tags+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template&#x7f;application/vnd.openxmlformats-officedocument.presentationml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml&#x7f;application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml&#x7f;application/vnd.openxmlformats-officedocument.theme+xml&#x7f;application/vnd.openxmlformats-officedocument.themeOverride+xml&#x7f;application/vnd.openxmlformats-officedocument.vmlDrawing&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml&#x7f;application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml&#x7f;application/vnd.openxmlformats-package.core-properties+xml&#x7f;application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml&#x7f;application/vnd.openxmlformats-package.relationships+xml&#x7f;application/vnd.oracle.resource+json&#x7f;application/vnd.orange.indata&#x7f;application/vnd.osa.netdeploy&#x7f;application/vnd.osgeo.mapguide.package&#x7f;application/vnd.osgi.bundle&#x7f;application/vnd.osgi.dp&#x7f;application/vnd.osgi.subsystem&#x7f;application/vnd.otps.ct-kip+xml&#x7f;application/vnd.oxli.countgraph&#x7f;application/vnd.pagerduty+json&#x7f;application/vnd.palm&#x7f;application/vnd.panoply&#x7f;application/vnd.paos.xml&#x7f;model/vnd.parasolid.transmit.binary&#x7f;model/vnd.parasolid.transmit.text&#x7f;application/vnd.patentdive&#x7f;application/vnd.patientecommsdoc&#x7f;application/vnd.pawaafile&#x7f;application/vnd.pcos&#x7f;application/vnd.pg.format&#x7f;application/vnd.pg.osasli&#x7f;application/vnd.piaccess.application-licence&#x7f;application/vnd.picsel&#x7f;application/vnd.pmi.widget&#x7f;application/vnd.poc.group-advertisement+xml&#x7f;application/vnd.pocketlearn&#x7f;application/vnd.powerbuilder6&#x7f;application/vnd.powerbuilder6-s&#x7f;application/vnd.powerbuilder7&#x7f;application/vnd.powerbuilder7-s&#x7f;application/vnd.powerbuilder75&#x7f;application/vnd.powerbuilder75-s&#x7f;application/vnd.preminet&#x7f;audio/vnd.presonus.multitrack&#x7f;application/vnd.previewsystems.box&#x7f;application/vnd.proteus.magazine&#x7f;application/vnd.psfs&#x7f;application/vnd.publishare-delta-tree&#x7f;application/vnd.pvi.ptid1&#x7f;application/vnd.pwg-multiplexed&#x7f;application/vnd.pwg-xhtml-print+xml&#x7f;application/vnd.qualcomm.brew-app-res&#x7f;application/vnd.quarantainenet&#x7f;application/vnd.quobject-quoxdocument&#x7f;video/vnd.radgamettools.bink&#x7f;video/vnd.radgamettools.smacker&#x7f;image/vnd.radiance&#x7f;application/vnd.radisys.moml+xml&#x7f;application/vnd.radisys.msml+xml&#x7f;application/vnd.radisys.msml-audit+xml&#x7f;application/vnd.radisys.msml-audit-conf+xml&#x7f;application/vnd.radisys.msml-audit-conn+xml&#x7f;application/vnd.radisys.msml-audit-dialog+xml&#x7f;application/vnd.radisys.msml-audit-stream+xml&#x7f;text/vnd.radisys.msml-basic-layout&#x7f;application/vnd.radisys.msml-conf+xml&#x7f;application/vnd.radisys.msml-dialog+xml&#x7f;application/vnd.radisys.msml-dialog-base+xml&#x7f;application/vnd.radisys.msml-dialog-fax-detect+xml&#x7f;application/vnd.radisys.msml-dialog-fax-sendrecv+xml&#x7f;application/vnd.radisys.msml-dialog-group+xml&#x7f;application/vnd.radisys.msml-dialog-speech+xml&#x7f;application/vnd.radisys.msml-dialog-transform+xml&#x7f;application/vnd.rainstor.data&#x7f;application/vnd.rapid&#x7f;application/vnd.rar&#x7f;application/vnd.realvnc.bed&#x7f;application/vnd.recordare.musicxml&#x7f;application/vnd.recordare.musicxml+xml&#x7f;application/vnd.restful+json&#x7f;audio/vnd.rhetorex.32kadpcm&#x7f;application/vnd.rig.cryptonote&#x7f;audio/vnd.rip&#x7f;model/vnd.rosette.annotated-data-model&#x7f;application/vnd.route66.link66+xml&#x7f;application/vnd.rs-274x&#x7f;application/vnd.ruckus.download&#x7f;application/vnd.s3sms&#x7f;application/vnd.sailingtracker.track&#x7f;application/vnd.sar&#x7f;application/vnd.sbm.cid&#x7f;application/vnd.sbm.mid2&#x7f;application/vnd.scribus&#x7f;application/vnd.sealed.3df&#x7f;application/vnd.sealed.csf&#x7f;application/vnd.sealed.doc&#x7f;application/vnd.sealed.eml&#x7f;application/vnd.sealed.mht&#x7f;video/vnd.sealed.mpeg1&#x7f;video/vnd.sealed.mpeg4&#x7f;application/vnd.sealed.net&#x7f;image/vnd.sealed.png&#x7f;application/vnd.sealed.ppt&#x7f;video/vnd.sealed.swf&#x7f;application/vnd.sealed.tiff&#x7f;application/vnd.sealed.xls&#x7f;image/vnd.sealedmedia.softseal.gif&#x7f;application/vnd.sealedmedia.softseal.html&#x7f;image/vnd.sealedmedia.softseal.jpg&#x7f;video/vnd.sealedmedia.softseal.mov&#x7f;audio/vnd.sealedmedia.softseal.mpeg&#x7f;application/vnd.sealedmedia.softseal.pdf&#x7f;application/vnd.seemail&#x7f;application/vnd.sema&#x7f;application/vnd.semd&#x7f;application/vnd.semf&#x7f;text/vnd.senx.warpscript&#x7f;application/vnd.shade-save-file&#x7f;application/vnd.shana.informed.formdata&#x7f;application/vnd.shana.informed.formtemplate&#x7f;application/vnd.shana.informed.interchange&#x7f;application/vnd.shana.informed.package&#x7f;application/vnd.shootproof+json&#x7f;application/vnd.shopkick+json&#x7f;application/vnd.shp&#x7f;application/vnd.shx&#x7f;application/vnd.sigrok.session&#x7f;application/vnd.siren+json&#x7f;application/vnd.smaf&#x7f;application/vnd.smart.notebook&#x7f;application/vnd.smart.teacher&#x7f;application/vnd.snesdev-page-table&#x7f;application/vnd.software602.filler.form+xml&#x7f;application/vnd.software602.filler.form-xml-zip&#x7f;application/vnd.solent.sdkm+xml&#x7f;text/vnd.sosi&#x7f;application/vnd.spotfire.dxp&#x7f;application/vnd.spotfire.sfs&#x7f;application/vnd.sqlite3&#x7f;application/vnd.sss-cod&#x7f;application/vnd.sss-dtf&#x7f;application/vnd.sss-ntf&#x7f;application/vnd.stepmania.package&#x7f;application/vnd.stepmania.stepchart&#x7f;application/vnd.street-stream&#x7f;text/vnd.sun.j2me.app-descriptor&#x7f;application/vnd.sun.wadl+xml&#x7f;application/vnd.sus-calendar&#x7f;application/vnd.svd&#x7f;image/vnd.svf&#x7f;application/vnd.swiftview-ics&#x7f;application/vnd.syncml+xml&#x7f;application/vnd.syncml.dm+wbxml&#x7f;application/vnd.syncml.dm+xml&#x7f;application/vnd.syncml.dm.notification&#x7f;application/vnd.syncml.dmddf+wbxml&#x7f;application/vnd.syncml.dmddf+xml&#x7f;application/vnd.syncml.dmtnds+wbxml&#x7f;application/vnd.syncml.dmtnds+xml&#x7f;application/vnd.syncml.ds.notification&#x7f;application/vnd.tableschema+json&#x7f;application/vnd.tao.intent-module-archive&#x7f;application/vnd.tcpdump.pcap&#x7f;image/vnd.tencent.tap&#x7f;application/vnd.think-cell.ppttc+json&#x7f;application/vnd.tmd.mediaflex.api+xml&#x7f;application/vnd.tml&#x7f;application/vnd.tmobile-livetv&#x7f;application/vnd.tri.onesource&#x7f;application/vnd.trid.tpt&#x7f;application/vnd.triscape.mxs&#x7f;text/vnd.trolltech.linguist&#x7f;application/vnd.trueapp&#x7f;application/vnd.truedoc&#x7f;application/vnd.ubisoft.webplayer&#x7f;application/vnd.ufdl&#x7f;application/vnd.uiq.theme&#x7f;application/vnd.umajin&#x7f;application/vnd.unity&#x7f;application/vnd.uoml+xml&#x7f;application/vnd.uplanet.alert&#x7f;application/vnd.uplanet.alert-wbxml&#x7f;application/vnd.uplanet.bearer-choice&#x7f;application/vnd.uplanet.bearer-choice-wbxml&#x7f;application/vnd.uplanet.cacheop&#x7f;application/vnd.uplanet.cacheop-wbxml&#x7f;application/vnd.uplanet.channel&#x7f;application/vnd.uplanet.channel-wbxml&#x7f;application/vnd.uplanet.list&#x7f;application/vnd.uplanet.list-wbxml&#x7f;application/vnd.uplanet.listcmd&#x7f;application/vnd.uplanet.listcmd-wbxml&#x7f;application/vnd.uplanet.signal&#x7f;application/vnd.uri-map&#x7f;model/vnd.usdz+zip&#x7f;video/vnd.uvvu.mp4&#x7f;model/vnd.valve.source.compiled-map&#x7f;application/vnd.valve.source.material&#x7f;image/vnd.valve.source.texture&#x7f;application/vnd.vcx&#x7f;application/vnd.vd-study&#x7f;application/vnd.vectorworks&#x7f;application/vnd.vel+json&#x7f;application/vnd.verimatrix.vcas&#x7f;application/vnd.veryant.thin&#x7f;application/vnd.ves.encrypted&#x7f;application/vnd.vidsoft.vidconference&#x7f;application/vnd.visio&#x7f;application/vnd.visionary&#x7f;application/vnd.vividence.scriptfile&#x7f;video/vnd.vivo&#x7f;audio/vnd.vmx.cvsd&#x7f;application/vnd.vsf&#x7f;model/vnd.vtu&#x7f;text/vnd.wap.si&#x7f;application/vnd.wap.sic&#x7f;text/vnd.wap.sl&#x7f;application/vnd.wap.slc&#x7f;image/vnd.wap.wbmp&#x7f;application/vnd.wap.wbxml&#x7f;text/vnd.wap.wml&#x7f;application/vnd.wap.wmlc&#x7f;text/vnd.wap.wmlscript&#x7f;application/vnd.wap.wmlscriptc&#x7f;application/vnd.webturbo&#x7f;application/vnd.wfa.p2p&#x7f;application/vnd.wfa.wsc&#x7f;message/vnd.wfa.wsc&#x7f;application/vnd.windows.devicepairing&#x7f;application/vnd.wmc&#x7f;application/vnd.wmf.bootstrap&#x7f;application/vnd.wolfram.mathematica&#x7f;application/vnd.wolfram.mathematica.package&#x7f;application/vnd.wolfram.player&#x7f;application/vnd.wordperfect&#x7f;application/vnd.wqd&#x7f;application/vnd.wrq-hp3000-labelled&#x7f;application/vnd.wt.stf&#x7f;application/vnd.wv.csp+wbxml&#x7f;application/vnd.wv.csp+xml&#x7f;application/vnd.wv.ssp+xml&#x7f;application/vnd.xacml+json&#x7f;application/vnd.xara&#x7f;application/vnd.xfdl&#x7f;application/vnd.xfdl.webform&#x7f;image/vnd.xiff&#x7f;application/vnd.xmi+xml&#x7f;application/vnd.xmpie.cpkg&#x7f;application/vnd.xmpie.dpkg&#x7f;application/vnd.xmpie.plan&#x7f;application/vnd.xmpie.ppkg&#x7f;application/vnd.xmpie.xlim&#x7f;application/vnd.yamaha.hv-dic&#x7f;application/vnd.yamaha.hv-script&#x7f;application/vnd.yamaha.hv-voice&#x7f;application/vnd.yamaha.openscoreformat&#x7f;application/vnd.yamaha.openscoreformat.osfpvg+xml&#x7f;application/vnd.yamaha.remote-setup&#x7f;application/vnd.yamaha.smaf-audio&#x7f;application/vnd.yamaha.smaf-phrase&#x7f;application/vnd.yamaha.through-ngn&#x7f;application/vnd.yamaha.tunnel-udpencap&#x7f;application/vnd.yaoweme&#x7f;application/vnd.yellowriver-custom-menu&#x7f;video/vnd.youtube.yt&#x7f;image/vnd.zbrush.pcx&#x7f;application/vnd.zul&#x7f;application/vnd.zzazz.deck+xml&#x7f;multipart/voice-message&#x7f;application/voicexml+xml&#x7f;audio/vorbis&#x7f;audio/vorbis-config&#x7f;application/voucher-cms+json&#x7f;application/vq-rtcpxr&#x7f;model/vrml&#x7f;text/vtt&#x7f;application/watcherinfo+xml&#x7f;application/webpush-options+json&#x7f;application/whoispp-query&#x7f;application/whoispp-response&#x7f;application/widget&#x7f;application/wita&#x7f;image/wmf&#x7f;font/woff&#x7f;font/woff2&#x7f;application/wordperfect5.1&#x7f;application/wsdl+xml&#x7f;application/wspolicy+xml&#x7f;multipart/x-mixed-replace&#x7f;application/x-pki-message&#x7f;application/x-www-form-urlencoded&#x7f;application/x-x509-ca-cert&#x7f;application/x-x509-ca-ra-cert&#x7f;application/x-x509-next-ca-cert&#x7f;model/x3d+fastinfoset&#x7f;model/x3d+xml&#x7f;model/x3d-vrml&#x7f;application/x400-bp&#x7f;application/xacml+xml&#x7f;application/xcap-att+xml&#x7f;application/xcap-caps+xml&#x7f;application/xcap-diff+xml&#x7f;application/xcap-el+xml&#x7f;application/xcap-error+xml&#x7f;application/xcap-ns+xml&#x7f;application/xcon-conference-info+xml&#x7f;application/xcon-conference-info-diff+xml&#x7f;application/xenc+xml&#x7f;application/xhtml+xml&#x7f;application/xliff+xml&#x7f;application/xml&#x7f;text/xml&#x7f;application/xml-dtd&#x7f;application/xml-external-parsed-entity&#x7f;text/xml-external-parsed-entity&#x7f;application/xml-patch+xml&#x7f;application/xmpp+xml&#x7f;application/xop+xml&#x7f;application/xslt+xml&#x7f;application/xv+xml&#x7f;application/yang&#x7f;application/yang-data+json&#x7f;application/yang-data+xml&#x7f;application/yang-patch+json&#x7f;application/yang-patch+xml&#x7f;application/yin+xml&#x7f;application/zip&#x7f;application/zlib&#x7f;application/zstd&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'BinaryObjectMime-2.0 BinaryObjectMime-2.1 BinaryObjectMime-2.2 BinaryObjectMime-2.3 BinaryObjectMime-2.4' in the context '@mimeCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:AltitudeMeasure/@unitCode | cbc:BaseUnitMeasure/@unitCode | cbc:ChargeableWeightMeasure/@unitCode | cbc:ComparedValueMeasure/@unitCode | cbc:ConsumptionMeasure/@unitCode | cbc:DurationMeasure/@unitCode | cbc:EstimatedGeneratedUntilNextPortMeasure/@unitCode | cbc:FuelConsumptionMeasure/@unitCode | cbc:GrossMassMeasure/@unitCode | cbc:GrossTonnageMeasure/@unitCode | cbc:GrossVolumeMeasure/@unitCode | cbc:GrossWeightMeasure/@unitCode | cbc:LatitudeDegreesMeasure/@unitCode | cbc:LatitudeMinutesMeasure/@unitCode | cbc:LeadTimeMeasure/@unitCode | cbc:LoadingLengthMeasure/@unitCode | cbc:LongitudeDegreesMeasure/@unitCode | cbc:LongitudeMinutesMeasure/@unitCode | cbc:MaxDedicatedStorageCapacityMeasure/@unitCode | cbc:MaximumDataLossDurationMeasure/@unitCode | cbc:MaximumIncidentNotificationDurationMeasure/@unitCode | cbc:MaximumMeasure/@unitCode | cbc:MeanTimeToRecoverDurationMeasure/@unitCode | cbc:Measure/@unitCode | cbc:MinimumDownTimeScheduleDurationMeasure/@unitCode | cbc:MinimumMeasure/@unitCode | cbc:MinimumResponseTimeDurationMeasure/@unitCode | cbc:NetNetWeightMeasure/@unitCode | cbc:NetTonnageMeasure/@unitCode | cbc:NetVolumeMeasure/@unitCode | cbc:NetWeightMeasure/@unitCode | cbc:PostEventNotificationDurationMeasure/@unitCode | cbc:PreEventNotificationDurationMeasure/@unitCode | cbc:RateOfTurnMeasure/@unitCode | cbc:ResponseMeasure/@unitCode | cbc:RetainedOnBoardMeasure/@unitCode | cbc:SalinityMeasure/@unitCode | cbc:SeaHeightMeasure/@unitCode | cbc:SegregatedBallastMeasure/@unitCode | cbc:SourceValueMeasure/@unitCode | cbc:SpeedOverGroundMeasure/@unitCode | cbc:TareWeightMeasure/@unitCode | cbc:ToBeDeliveredMeasure/@unitCode | cbc:TotalBallastWaterCapacityMeasure/@unitCode | cbc:TotalBallastWaterOnBoardMeasure/@unitCode | cbc:ValueBaseMeasure/@unitCode | cbc:ValueMeasure/@unitCode | cbc:VolumeMeasure/@unitCode | cbc:WasteMeasure/@unitCode"
                 priority="21"
                 mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:AltitudeMeasure/@unitCode | cbc:BaseUnitMeasure/@unitCode | cbc:ChargeableWeightMeasure/@unitCode | cbc:ComparedValueMeasure/@unitCode | cbc:ConsumptionMeasure/@unitCode | cbc:DurationMeasure/@unitCode | cbc:EstimatedGeneratedUntilNextPortMeasure/@unitCode | cbc:FuelConsumptionMeasure/@unitCode | cbc:GrossMassMeasure/@unitCode | cbc:GrossTonnageMeasure/@unitCode | cbc:GrossVolumeMeasure/@unitCode | cbc:GrossWeightMeasure/@unitCode | cbc:LatitudeDegreesMeasure/@unitCode | cbc:LatitudeMinutesMeasure/@unitCode | cbc:LeadTimeMeasure/@unitCode | cbc:LoadingLengthMeasure/@unitCode | cbc:LongitudeDegreesMeasure/@unitCode | cbc:LongitudeMinutesMeasure/@unitCode | cbc:MaxDedicatedStorageCapacityMeasure/@unitCode | cbc:MaximumDataLossDurationMeasure/@unitCode | cbc:MaximumIncidentNotificationDurationMeasure/@unitCode | cbc:MaximumMeasure/@unitCode | cbc:MeanTimeToRecoverDurationMeasure/@unitCode | cbc:Measure/@unitCode | cbc:MinimumDownTimeScheduleDurationMeasure/@unitCode | cbc:MinimumMeasure/@unitCode | cbc:MinimumResponseTimeDurationMeasure/@unitCode | cbc:NetNetWeightMeasure/@unitCode | cbc:NetTonnageMeasure/@unitCode | cbc:NetVolumeMeasure/@unitCode | cbc:NetWeightMeasure/@unitCode | cbc:PostEventNotificationDurationMeasure/@unitCode | cbc:PreEventNotificationDurationMeasure/@unitCode | cbc:RateOfTurnMeasure/@unitCode | cbc:ResponseMeasure/@unitCode | cbc:RetainedOnBoardMeasure/@unitCode | cbc:SalinityMeasure/@unitCode | cbc:SeaHeightMeasure/@unitCode | cbc:SegregatedBallastMeasure/@unitCode | cbc:SourceValueMeasure/@unitCode | cbc:SpeedOverGroundMeasure/@unitCode | cbc:TareWeightMeasure/@unitCode | cbc:ToBeDeliveredMeasure/@unitCode | cbc:TotalBallastWaterCapacityMeasure/@unitCode | cbc:TotalBallastWaterOnBoardMeasure/@unitCode | cbc:ValueBaseMeasure/@unitCode | cbc:ValueMeasure/@unitCode | cbc:VolumeMeasure/@unitCode | cbc:WasteMeasure/@unitCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:AltitudeMeasure/@unitCode | cbc:BaseUnitMeasure/@unitCode | cbc:ChargeableWeightMeasure/@unitCode | cbc:ComparedValueMeasure/@unitCode | cbc:ConsumptionMeasure/@unitCode | cbc:DurationMeasure/@unitCode | cbc:EstimatedGeneratedUntilNextPortMeasure/@unitCode | cbc:FuelConsumptionMeasure/@unitCode | cbc:GrossMassMeasure/@unitCode | cbc:GrossTonnageMeasure/@unitCode | cbc:GrossVolumeMeasure/@unitCode | cbc:GrossWeightMeasure/@unitCode | cbc:LatitudeDegreesMeasure/@unitCode | cbc:LatitudeMinutesMeasure/@unitCode | cbc:LeadTimeMeasure/@unitCode | cbc:LoadingLengthMeasure/@unitCode | cbc:LongitudeDegreesMeasure/@unitCode | cbc:LongitudeMinutesMeasure/@unitCode | cbc:MaxDedicatedStorageCapacityMeasure/@unitCode | cbc:MaximumDataLossDurationMeasure/@unitCode | cbc:MaximumIncidentNotificationDurationMeasure/@unitCode | cbc:MaximumMeasure/@unitCode | cbc:MeanTimeToRecoverDurationMeasure/@unitCode | cbc:Measure/@unitCode | cbc:MinimumDownTimeScheduleDurationMeasure/@unitCode | cbc:MinimumMeasure/@unitCode | cbc:MinimumResponseTimeDurationMeasure/@unitCode | cbc:NetNetWeightMeasure/@unitCode | cbc:NetTonnageMeasure/@unitCode | cbc:NetVolumeMeasure/@unitCode | cbc:NetWeightMeasure/@unitCode | cbc:PostEventNotificationDurationMeasure/@unitCode | cbc:PreEventNotificationDurationMeasure/@unitCode | cbc:RateOfTurnMeasure/@unitCode | cbc:ResponseMeasure/@unitCode | cbc:RetainedOnBoardMeasure/@unitCode | cbc:SalinityMeasure/@unitCode | cbc:SeaHeightMeasure/@unitCode | cbc:SegregatedBallastMeasure/@unitCode | cbc:SourceValueMeasure/@unitCode | cbc:SpeedOverGroundMeasure/@unitCode | cbc:TareWeightMeasure/@unitCode | cbc:ToBeDeliveredMeasure/@unitCode | cbc:TotalBallastWaterCapacityMeasure/@unitCode | cbc:TotalBallastWaterOnBoardMeasure/@unitCode | cbc:ValueBaseMeasure/@unitCode | cbc:ValueMeasure/@unitCode | cbc:VolumeMeasure/@unitCode | cbc:WasteMeasure/@unitCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:AltitudeMeasure/@unitCode | cbc:BaseUnitMeasure/@unitCode | cbc:ChargeableWeightMeasure/@unitCode | cbc:ComparedValueMeasure/@unitCode | cbc:ConsumptionMeasure/@unitCode | cbc:DurationMeasure/@unitCode | cbc:EstimatedGeneratedUntilNextPortMeasure/@unitCode | cbc:FuelConsumptionMeasure/@unitCode | cbc:GrossMassMeasure/@unitCode | cbc:GrossTonnageMeasure/@unitCode | cbc:GrossVolumeMeasure/@unitCode | cbc:GrossWeightMeasure/@unitCode | cbc:LatitudeDegreesMeasure/@unitCode | cbc:LatitudeMinutesMeasure/@unitCode | cbc:LeadTimeMeasure/@unitCode | cbc:LoadingLengthMeasure/@unitCode | cbc:LongitudeDegreesMeasure/@unitCode | cbc:LongitudeMinutesMeasure/@unitCode | cbc:MaxDedicatedStorageCapacityMeasure/@unitCode | cbc:MaximumDataLossDurationMeasure/@unitCode | cbc:MaximumIncidentNotificationDurationMeasure/@unitCode | cbc:MaximumMeasure/@unitCode | cbc:MeanTimeToRecoverDurationMeasure/@unitCode | cbc:Measure/@unitCode | cbc:MinimumDownTimeScheduleDurationMeasure/@unitCode | cbc:MinimumMeasure/@unitCode | cbc:MinimumResponseTimeDurationMeasure/@unitCode | cbc:NetNetWeightMeasure/@unitCode | cbc:NetTonnageMeasure/@unitCode | cbc:NetVolumeMeasure/@unitCode | cbc:NetWeightMeasure/@unitCode | cbc:PostEventNotificationDurationMeasure/@unitCode | cbc:PreEventNotificationDurationMeasure/@unitCode | cbc:RateOfTurnMeasure/@unitCode | cbc:ResponseMeasure/@unitCode | cbc:RetainedOnBoardMeasure/@unitCode | cbc:SalinityMeasure/@unitCode | cbc:SeaHeightMeasure/@unitCode | cbc:SegregatedBallastMeasure/@unitCode | cbc:SourceValueMeasure/@unitCode | cbc:SpeedOverGroundMeasure/@unitCode | cbc:TareWeightMeasure/@unitCode | cbc:ToBeDeliveredMeasure/@unitCode | cbc:TotalBallastWaterCapacityMeasure/@unitCode | cbc:TotalBallastWaterOnBoardMeasure/@unitCode | cbc:ValueBaseMeasure/@unitCode | cbc:ValueMeasure/@unitCode | cbc:VolumeMeasure/@unitCode | cbc:WasteMeasure/@unitCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(../@unitCodeListVersionID!='Revision 4') ) and contains('&#x7f;04&#x7f;05&#x7f;08&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;53&#x7f;54&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;66&#x7f;69&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;76&#x7f;77&#x7f;78&#x7f;80&#x7f;81&#x7f;84&#x7f;85&#x7f;87&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;1A&#x7f;1B&#x7f;1C&#x7f;1D&#x7f;1E&#x7f;1F&#x7f;1G&#x7f;1H&#x7f;1I&#x7f;1J&#x7f;1K&#x7f;1L&#x7f;1M&#x7f;1X&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2V&#x7f;2W&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;3E&#x7f;3G&#x7f;3H&#x7f;3I&#x7f;4A&#x7f;4B&#x7f;4C&#x7f;4E&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5C&#x7f;5E&#x7f;5F&#x7f;5G&#x7f;5H&#x7f;5I&#x7f;5J&#x7f;5K&#x7f;5P&#x7f;5Q&#x7f;A1&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A25&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A50&#x7f;A51&#x7f;A52&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A57&#x7f;A58&#x7f;A6&#x7f;A60&#x7f;A61&#x7f;A62&#x7f;A63&#x7f;A64&#x7f;A65&#x7f;A66&#x7f;A67&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A77&#x7f;A78&#x7f;A79&#x7f;A8&#x7f;A80&#x7f;A81&#x7f;A82&#x7f;A83&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;AP&#x7f;APZ&#x7f;AQ&#x7f;AR&#x7f;ARE&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;ATT&#x7f;AV&#x7f;AW&#x7f;AY&#x7f;AZ&#x7f;B0&#x7f;B1&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B18&#x7f;B2&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B36&#x7f;B37&#x7f;B38&#x7f;B39&#x7f;B4&#x7f;B40&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B5&#x7f;B50&#x7f;B51&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B6&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B65&#x7f;B66&#x7f;B67&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B81&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B9&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BFT&#x7f;BG&#x7f;BH&#x7f;BHP&#x7f;BIL&#x7f;BJ&#x7f;BK&#x7f;BL&#x7f;BLD&#x7f;BLL&#x7f;BO&#x7f;BP&#x7f;BQL&#x7f;BR&#x7f;BT&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;BW&#x7f;BX&#x7f;BZ&#x7f;C0&#x7f;C1&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C2&#x7f;C20&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C38&#x7f;C39&#x7f;C4&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C5&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C6&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C75&#x7f;C76&#x7f;C77&#x7f;C78&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C98&#x7f;C99&#x7f;CA&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CH&#x7f;CJ&#x7f;CK&#x7f;CKG&#x7f;CL&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;CO&#x7f;COU&#x7f;CQ&#x7f;CR&#x7f;CS&#x7f;CT&#x7f;CTM&#x7f;CU&#x7f;CUR&#x7f;CV&#x7f;CWA&#x7f;CWI&#x7f;CY&#x7f;CZ&#x7f;D1&#x7f;D10&#x7f;D12&#x7f;D13&#x7f;D14&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D28&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D35&#x7f;D37&#x7f;D38&#x7f;D39&#x7f;D40&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D64&#x7f;D65&#x7f;D66&#x7f;D67&#x7f;D69&#x7f;D7&#x7f;D70&#x7f;D71&#x7f;D72&#x7f;D73&#x7f;D74&#x7f;D75&#x7f;D76&#x7f;D77&#x7f;D79&#x7f;D8&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D9&#x7f;D90&#x7f;D91&#x7f;D92&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;D96&#x7f;D97&#x7f;D98&#x7f;D99&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DC&#x7f;DD&#x7f;DE&#x7f;DEC&#x7f;DG&#x7f;DI&#x7f;DJ&#x7f;DLT&#x7f;DMK&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DQ&#x7f;DR&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DRM&#x7f;DS&#x7f;DT&#x7f;DTN&#x7f;DU&#x7f;DWT&#x7f;DX&#x7f;DY&#x7f;DZN&#x7f;DZP&#x7f;E2&#x7f;E3&#x7f;E4&#x7f;E5&#x7f;EA&#x7f;EB&#x7f;EC&#x7f;EP&#x7f;EQ&#x7f;EV&#x7f;F1&#x7f;F9&#x7f;FAH&#x7f;FAR&#x7f;FB&#x7f;FC&#x7f;FD&#x7f;FE&#x7f;FF&#x7f;FG&#x7f;FH&#x7f;FL&#x7f;FM&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G2&#x7f;G3&#x7f;G7&#x7f;GB&#x7f;GBQ&#x7f;GC&#x7f;GD&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GH&#x7f;GIA&#x7f;GII&#x7f;GJ&#x7f;GK&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GN&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GRT&#x7f;GT&#x7f;GV&#x7f;GW&#x7f;GWH&#x7f;GY&#x7f;GZ&#x7f;H1&#x7f;H2&#x7f;HA&#x7f;HAR&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HD&#x7f;HE&#x7f;HF&#x7f;HGM&#x7f;HH&#x7f;HI&#x7f;HIU&#x7f;HJ&#x7f;HK&#x7f;HL&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HN&#x7f;HO&#x7f;HP&#x7f;HPA&#x7f;HS&#x7f;HT&#x7f;HTZ&#x7f;HUR&#x7f;HY&#x7f;IA&#x7f;IC&#x7f;IE&#x7f;IF&#x7f;II&#x7f;IL&#x7f;IM&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;IP&#x7f;IT&#x7f;IU&#x7f;IV&#x7f;J2&#x7f;JB&#x7f;JE&#x7f;JG&#x7f;JK&#x7f;JM&#x7f;JO&#x7f;JOU&#x7f;JR&#x7f;K1&#x7f;K2&#x7f;K3&#x7f;K5&#x7f;K6&#x7f;KA&#x7f;KB&#x7f;KBA&#x7f;KD&#x7f;KEL&#x7f;KF&#x7f;KG&#x7f;KGM&#x7f;KGS&#x7f;KHZ&#x7f;KI&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KNI&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KS&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTM&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWT&#x7f;KX&#x7f;L2&#x7f;LA&#x7f;LBR&#x7f;LBT&#x7f;LC&#x7f;LD&#x7f;LE&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LI&#x7f;LJ&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUM&#x7f;LUX&#x7f;LX&#x7f;LY&#x7f;M0&#x7f;M1&#x7f;M4&#x7f;M5&#x7f;M7&#x7f;M9&#x7f;MA&#x7f;MAL&#x7f;MAM&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MF&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MK&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MON&#x7f;MPA&#x7f;MQ&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MT&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MV&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N2&#x7f;N3&#x7f;NA&#x7f;NAR&#x7f;NB&#x7f;NBB&#x7f;NC&#x7f;NCL&#x7f;ND&#x7f;NE&#x7f;NEW&#x7f;NF&#x7f;NG&#x7f;NH&#x7f;NI&#x7f;NIU&#x7f;NJ&#x7f;NL&#x7f;NMI&#x7f;NMP&#x7f;NN&#x7f;NPL&#x7f;NPR&#x7f;NPT&#x7f;NQ&#x7f;NR&#x7f;NRL&#x7f;NT&#x7f;NTT&#x7f;NU&#x7f;NV&#x7f;NX&#x7f;NY&#x7f;OA&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OP&#x7f;OT&#x7f;OZ&#x7f;OZA&#x7f;OZI&#x7f;P0&#x7f;P1&#x7f;P2&#x7f;P3&#x7f;P4&#x7f;P5&#x7f;P6&#x7f;P7&#x7f;P8&#x7f;P9&#x7f;PA&#x7f;PAL&#x7f;PB&#x7f;PD&#x7f;PE&#x7f;PF&#x7f;PG&#x7f;PGL&#x7f;PI&#x7f;PK&#x7f;PL&#x7f;PM&#x7f;PN&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PU&#x7f;PV&#x7f;PW&#x7f;PY&#x7f;PZ&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QD&#x7f;QH&#x7f;QK&#x7f;QR&#x7f;QT&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R4&#x7f;R9&#x7f;RA&#x7f;RD&#x7f;RG&#x7f;RH&#x7f;RK&#x7f;RL&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RS&#x7f;RT&#x7f;RU&#x7f;S3&#x7f;S4&#x7f;S5&#x7f;S6&#x7f;S7&#x7f;S8&#x7f;SA&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SD&#x7f;SE&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SHT&#x7f;SIE&#x7f;SK&#x7f;SL&#x7f;SMI&#x7f;SN&#x7f;SO&#x7f;SP&#x7f;SQ&#x7f;SR&#x7f;SS&#x7f;SST&#x7f;ST&#x7f;STI&#x7f;STN&#x7f;SV&#x7f;SW&#x7f;SX&#x7f;T0&#x7f;T1&#x7f;T3&#x7f;T4&#x7f;T5&#x7f;T6&#x7f;T7&#x7f;T8&#x7f;TA&#x7f;TAH&#x7f;TC&#x7f;TD&#x7f;TE&#x7f;TF&#x7f;TI&#x7f;TJ&#x7f;TK&#x7f;TL&#x7f;TN&#x7f;TNE&#x7f;TP&#x7f;TPR&#x7f;TQ&#x7f;TQD&#x7f;TR&#x7f;TRL&#x7f;TS&#x7f;TSD&#x7f;TSH&#x7f;TT&#x7f;TU&#x7f;TV&#x7f;TW&#x7f;TY&#x7f;U1&#x7f;U2&#x7f;UA&#x7f;UB&#x7f;UC&#x7f;UD&#x7f;UE&#x7f;UF&#x7f;UH&#x7f;UM&#x7f;VA&#x7f;VI&#x7f;VLT&#x7f;VQ&#x7f;VS&#x7f;W2&#x7f;W4&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WH&#x7f;WHR&#x7f;WI&#x7f;WM&#x7f;WR&#x7f;WSD&#x7f;WTT&#x7f;WW&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YL&#x7f;YRD&#x7f;YT&#x7f;Z1&#x7f;Z2&#x7f;Z3&#x7f;Z4&#x7f;Z5&#x7f;Z6&#x7f;Z8&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListVersionID!='8e') ) and contains('&#x7f;05&#x7f;06&#x7f;08&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;53&#x7f;54&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;66&#x7f;69&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;76&#x7f;77&#x7f;78&#x7f;80&#x7f;81&#x7f;84&#x7f;85&#x7f;87&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;1A&#x7f;1B&#x7f;1C&#x7f;1D&#x7f;1E&#x7f;1F&#x7f;1G&#x7f;1H&#x7f;1I&#x7f;1J&#x7f;1K&#x7f;1L&#x7f;1M&#x7f;1X&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2V&#x7f;2W&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;3E&#x7f;3G&#x7f;3H&#x7f;3I&#x7f;4A&#x7f;4B&#x7f;4C&#x7f;4E&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5C&#x7f;5E&#x7f;5F&#x7f;5G&#x7f;5H&#x7f;5I&#x7f;5J&#x7f;5K&#x7f;5P&#x7f;5Q&#x7f;A1&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A25&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A50&#x7f;A51&#x7f;A52&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A57&#x7f;A58&#x7f;A59&#x7f;A6&#x7f;A60&#x7f;A61&#x7f;A62&#x7f;A63&#x7f;A64&#x7f;A65&#x7f;A66&#x7f;A67&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A77&#x7f;A78&#x7f;A79&#x7f;A8&#x7f;A80&#x7f;A81&#x7f;A82&#x7f;A83&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;AP&#x7f;APZ&#x7f;AQ&#x7f;AR&#x7f;ARE&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;ATT&#x7f;AV&#x7f;AW&#x7f;AY&#x7f;AZ&#x7f;B0&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B2&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B36&#x7f;B37&#x7f;B38&#x7f;B39&#x7f;B4&#x7f;B40&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B5&#x7f;B50&#x7f;B51&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B6&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B65&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B9&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BFT&#x7f;BG&#x7f;BH&#x7f;BHP&#x7f;BIL&#x7f;BJ&#x7f;BK&#x7f;BL&#x7f;BLD&#x7f;BLL&#x7f;BO&#x7f;BP&#x7f;BQL&#x7f;BR&#x7f;BT&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;BW&#x7f;BX&#x7f;BZ&#x7f;C0&#x7f;C1&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C2&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C4&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C5&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C6&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C77&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C98&#x7f;C99&#x7f;CA&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CH&#x7f;CJ&#x7f;CK&#x7f;CKG&#x7f;CL&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;CO&#x7f;COU&#x7f;CQ&#x7f;CR&#x7f;CS&#x7f;CT&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CU&#x7f;CUR&#x7f;CV&#x7f;CWA&#x7f;CWI&#x7f;CY&#x7f;CZ&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D14&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D28&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D35&#x7f;D36&#x7f;D37&#x7f;D38&#x7f;D39&#x7f;D40&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D64&#x7f;D65&#x7f;D66&#x7f;D67&#x7f;D68&#x7f;D69&#x7f;D7&#x7f;D70&#x7f;D71&#x7f;D72&#x7f;D73&#x7f;D74&#x7f;D75&#x7f;D76&#x7f;D77&#x7f;D78&#x7f;D79&#x7f;D8&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D9&#x7f;D90&#x7f;D91&#x7f;D92&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;D96&#x7f;D97&#x7f;D98&#x7f;D99&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DC&#x7f;DD&#x7f;DE&#x7f;DEC&#x7f;DG&#x7f;DI&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DQ&#x7f;DR&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DRM&#x7f;DS&#x7f;DT&#x7f;DTN&#x7f;DU&#x7f;DWT&#x7f;DX&#x7f;DY&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E11&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E2&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E3&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E5&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EC&#x7f;EP&#x7f;EQ&#x7f;EV&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F1&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F9&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FB&#x7f;FBM&#x7f;FC&#x7f;FD&#x7f;FE&#x7f;FF&#x7f;FG&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FM&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G7&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GC&#x7f;GD&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GH&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GK&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GN&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GRT&#x7f;GT&#x7f;GV&#x7f;GW&#x7f;GWH&#x7f;GY&#x7f;GZ&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H1&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H2&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H78&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HAR&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HD&#x7f;HDW&#x7f;HE&#x7f;HEA&#x7f;HF&#x7f;HGM&#x7f;HH&#x7f;HI&#x7f;HIU&#x7f;HJ&#x7f;HK&#x7f;HKM&#x7f;HL&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HN&#x7f;HO&#x7f;HP&#x7f;HPA&#x7f;HS&#x7f;HT&#x7f;HTZ&#x7f;HUR&#x7f;HY&#x7f;IA&#x7f;IC&#x7f;IE&#x7f;IF&#x7f;II&#x7f;IL&#x7f;IM&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;IP&#x7f;ISD&#x7f;IT&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J89&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J94&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JB&#x7f;JE&#x7f;JG&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JO&#x7f;JOU&#x7f;JPS&#x7f;JR&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K24&#x7f;K25&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K5&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KD&#x7f;KDW&#x7f;KEL&#x7f;KF&#x7f;KG&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KS&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTM&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWO&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L61&#x7f;L62&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LC&#x7f;LD&#x7f;LE&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LI&#x7f;LJ&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LX&#x7f;LY&#x7f;M0&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MA&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MF&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MK&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQ&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MT&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MV&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N2&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NB&#x7f;NBB&#x7f;NC&#x7f;NCL&#x7f;ND&#x7f;NE&#x7f;NEW&#x7f;NF&#x7f;NG&#x7f;NH&#x7f;NI&#x7f;NIL&#x7f;NIU&#x7f;NJ&#x7f;NL&#x7f;NMI&#x7f;NMP&#x7f;NN&#x7f;NPL&#x7f;NPR&#x7f;NPT&#x7f;NQ&#x7f;NR&#x7f;NRL&#x7f;NT&#x7f;NTT&#x7f;NU&#x7f;NV&#x7f;NX&#x7f;NY&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OP&#x7f;OT&#x7f;OZ&#x7f;OZA&#x7f;OZI&#x7f;P0&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P3&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P4&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P6&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P7&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P8&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P9&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PA&#x7f;PAL&#x7f;PB&#x7f;PD&#x7f;PE&#x7f;PF&#x7f;PFL&#x7f;PG&#x7f;PGL&#x7f;PI&#x7f;PK&#x7f;PL&#x7f;PLA&#x7f;PM&#x7f;PN&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PU&#x7f;PV&#x7f;PW&#x7f;PY&#x7f;PZ&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QD&#x7f;QH&#x7f;QK&#x7f;QR&#x7f;QT&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R4&#x7f;R9&#x7f;RA&#x7f;RD&#x7f;RG&#x7f;RH&#x7f;RK&#x7f;RL&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RS&#x7f;RT&#x7f;RU&#x7f;S3&#x7f;S4&#x7f;S5&#x7f;S6&#x7f;S7&#x7f;S8&#x7f;SA&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SD&#x7f;SE&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SHT&#x7f;SIE&#x7f;SK&#x7f;SL&#x7f;SMI&#x7f;SN&#x7f;SO&#x7f;SP&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;SS&#x7f;SST&#x7f;ST&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SV&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T1&#x7f;T3&#x7f;T4&#x7f;T5&#x7f;T6&#x7f;T7&#x7f;T8&#x7f;TA&#x7f;TAH&#x7f;TAN&#x7f;TC&#x7f;TD&#x7f;TE&#x7f;TF&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TJ&#x7f;TK&#x7f;TKM&#x7f;TL&#x7f;TMS&#x7f;TN&#x7f;TNE&#x7f;TP&#x7f;TPR&#x7f;TQ&#x7f;TQD&#x7f;TR&#x7f;TRL&#x7f;TS&#x7f;TSD&#x7f;TSH&#x7f;TST&#x7f;TT&#x7f;TTS&#x7f;TU&#x7f;TV&#x7f;TW&#x7f;TY&#x7f;U1&#x7f;U2&#x7f;UA&#x7f;UB&#x7f;UC&#x7f;UD&#x7f;UE&#x7f;UF&#x7f;UH&#x7f;UM&#x7f;VA&#x7f;VI&#x7f;VLT&#x7f;VP&#x7f;VQ&#x7f;VS&#x7f;W2&#x7f;W4&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WH&#x7f;WHR&#x7f;WI&#x7f;WM&#x7f;WR&#x7f;WSD&#x7f;WTT&#x7f;WW&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YL&#x7f;YRD&#x7f;YT&#x7f;Z1&#x7f;Z11&#x7f;Z2&#x7f;Z3&#x7f;Z4&#x7f;Z5&#x7f;Z6&#x7f;Z8&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListVersionID!='12e_2016') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWO&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListVersionID!='12e_2016') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWN&#x7f;KWO&#x7f;KWS&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q41&#x7f;Q42&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListVersionID!='12e_2016') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWN&#x7f;KWO&#x7f;KWS&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q41&#x7f;Q42&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(../@unitCodeListVersionID!='Revision 4') ) and contains('&#x7f;04&#x7f;05&#x7f;08&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;53&#x7f;54&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;66&#x7f;69&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;76&#x7f;77&#x7f;78&#x7f;80&#x7f;81&#x7f;84&#x7f;85&#x7f;87&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;1A&#x7f;1B&#x7f;1C&#x7f;1D&#x7f;1E&#x7f;1F&#x7f;1G&#x7f;1H&#x7f;1I&#x7f;1J&#x7f;1K&#x7f;1L&#x7f;1M&#x7f;1X&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2V&#x7f;2W&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;3E&#x7f;3G&#x7f;3H&#x7f;3I&#x7f;4A&#x7f;4B&#x7f;4C&#x7f;4E&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5C&#x7f;5E&#x7f;5F&#x7f;5G&#x7f;5H&#x7f;5I&#x7f;5J&#x7f;5K&#x7f;5P&#x7f;5Q&#x7f;A1&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A25&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A50&#x7f;A51&#x7f;A52&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A57&#x7f;A58&#x7f;A6&#x7f;A60&#x7f;A61&#x7f;A62&#x7f;A63&#x7f;A64&#x7f;A65&#x7f;A66&#x7f;A67&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A77&#x7f;A78&#x7f;A79&#x7f;A8&#x7f;A80&#x7f;A81&#x7f;A82&#x7f;A83&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;AP&#x7f;APZ&#x7f;AQ&#x7f;AR&#x7f;ARE&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;ATT&#x7f;AV&#x7f;AW&#x7f;AY&#x7f;AZ&#x7f;B0&#x7f;B1&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B18&#x7f;B2&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B36&#x7f;B37&#x7f;B38&#x7f;B39&#x7f;B4&#x7f;B40&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B5&#x7f;B50&#x7f;B51&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B6&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B65&#x7f;B66&#x7f;B67&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B81&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B9&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BFT&#x7f;BG&#x7f;BH&#x7f;BHP&#x7f;BIL&#x7f;BJ&#x7f;BK&#x7f;BL&#x7f;BLD&#x7f;BLL&#x7f;BO&#x7f;BP&#x7f;BQL&#x7f;BR&#x7f;BT&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;BW&#x7f;BX&#x7f;BZ&#x7f;C0&#x7f;C1&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C2&#x7f;C20&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C38&#x7f;C39&#x7f;C4&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C5&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C6&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C75&#x7f;C76&#x7f;C77&#x7f;C78&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C98&#x7f;C99&#x7f;CA&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CH&#x7f;CJ&#x7f;CK&#x7f;CKG&#x7f;CL&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;CO&#x7f;COU&#x7f;CQ&#x7f;CR&#x7f;CS&#x7f;CT&#x7f;CTM&#x7f;CU&#x7f;CUR&#x7f;CV&#x7f;CWA&#x7f;CWI&#x7f;CY&#x7f;CZ&#x7f;D1&#x7f;D10&#x7f;D12&#x7f;D13&#x7f;D14&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D28&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D35&#x7f;D37&#x7f;D38&#x7f;D39&#x7f;D40&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D64&#x7f;D65&#x7f;D66&#x7f;D67&#x7f;D69&#x7f;D7&#x7f;D70&#x7f;D71&#x7f;D72&#x7f;D73&#x7f;D74&#x7f;D75&#x7f;D76&#x7f;D77&#x7f;D79&#x7f;D8&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D9&#x7f;D90&#x7f;D91&#x7f;D92&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;D96&#x7f;D97&#x7f;D98&#x7f;D99&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DC&#x7f;DD&#x7f;DE&#x7f;DEC&#x7f;DG&#x7f;DI&#x7f;DJ&#x7f;DLT&#x7f;DMK&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DQ&#x7f;DR&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DRM&#x7f;DS&#x7f;DT&#x7f;DTN&#x7f;DU&#x7f;DWT&#x7f;DX&#x7f;DY&#x7f;DZN&#x7f;DZP&#x7f;E2&#x7f;E3&#x7f;E4&#x7f;E5&#x7f;EA&#x7f;EB&#x7f;EC&#x7f;EP&#x7f;EQ&#x7f;EV&#x7f;F1&#x7f;F9&#x7f;FAH&#x7f;FAR&#x7f;FB&#x7f;FC&#x7f;FD&#x7f;FE&#x7f;FF&#x7f;FG&#x7f;FH&#x7f;FL&#x7f;FM&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G2&#x7f;G3&#x7f;G7&#x7f;GB&#x7f;GBQ&#x7f;GC&#x7f;GD&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GH&#x7f;GIA&#x7f;GII&#x7f;GJ&#x7f;GK&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GN&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GRT&#x7f;GT&#x7f;GV&#x7f;GW&#x7f;GWH&#x7f;GY&#x7f;GZ&#x7f;H1&#x7f;H2&#x7f;HA&#x7f;HAR&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HD&#x7f;HE&#x7f;HF&#x7f;HGM&#x7f;HH&#x7f;HI&#x7f;HIU&#x7f;HJ&#x7f;HK&#x7f;HL&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HN&#x7f;HO&#x7f;HP&#x7f;HPA&#x7f;HS&#x7f;HT&#x7f;HTZ&#x7f;HUR&#x7f;HY&#x7f;IA&#x7f;IC&#x7f;IE&#x7f;IF&#x7f;II&#x7f;IL&#x7f;IM&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;IP&#x7f;IT&#x7f;IU&#x7f;IV&#x7f;J2&#x7f;JB&#x7f;JE&#x7f;JG&#x7f;JK&#x7f;JM&#x7f;JO&#x7f;JOU&#x7f;JR&#x7f;K1&#x7f;K2&#x7f;K3&#x7f;K5&#x7f;K6&#x7f;KA&#x7f;KB&#x7f;KBA&#x7f;KD&#x7f;KEL&#x7f;KF&#x7f;KG&#x7f;KGM&#x7f;KGS&#x7f;KHZ&#x7f;KI&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KNI&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KS&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTM&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWT&#x7f;KX&#x7f;L2&#x7f;LA&#x7f;LBR&#x7f;LBT&#x7f;LC&#x7f;LD&#x7f;LE&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LI&#x7f;LJ&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUM&#x7f;LUX&#x7f;LX&#x7f;LY&#x7f;M0&#x7f;M1&#x7f;M4&#x7f;M5&#x7f;M7&#x7f;M9&#x7f;MA&#x7f;MAL&#x7f;MAM&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MF&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MK&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MON&#x7f;MPA&#x7f;MQ&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MT&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MV&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N2&#x7f;N3&#x7f;NA&#x7f;NAR&#x7f;NB&#x7f;NBB&#x7f;NC&#x7f;NCL&#x7f;ND&#x7f;NE&#x7f;NEW&#x7f;NF&#x7f;NG&#x7f;NH&#x7f;NI&#x7f;NIU&#x7f;NJ&#x7f;NL&#x7f;NMI&#x7f;NMP&#x7f;NN&#x7f;NPL&#x7f;NPR&#x7f;NPT&#x7f;NQ&#x7f;NR&#x7f;NRL&#x7f;NT&#x7f;NTT&#x7f;NU&#x7f;NV&#x7f;NX&#x7f;NY&#x7f;OA&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OP&#x7f;OT&#x7f;OZ&#x7f;OZA&#x7f;OZI&#x7f;P0&#x7f;P1&#x7f;P2&#x7f;P3&#x7f;P4&#x7f;P5&#x7f;P6&#x7f;P7&#x7f;P8&#x7f;P9&#x7f;PA&#x7f;PAL&#x7f;PB&#x7f;PD&#x7f;PE&#x7f;PF&#x7f;PG&#x7f;PGL&#x7f;PI&#x7f;PK&#x7f;PL&#x7f;PM&#x7f;PN&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PU&#x7f;PV&#x7f;PW&#x7f;PY&#x7f;PZ&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QD&#x7f;QH&#x7f;QK&#x7f;QR&#x7f;QT&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R4&#x7f;R9&#x7f;RA&#x7f;RD&#x7f;RG&#x7f;RH&#x7f;RK&#x7f;RL&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RS&#x7f;RT&#x7f;RU&#x7f;S3&#x7f;S4&#x7f;S5&#x7f;S6&#x7f;S7&#x7f;S8&#x7f;SA&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SD&#x7f;SE&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SHT&#x7f;SIE&#x7f;SK&#x7f;SL&#x7f;SMI&#x7f;SN&#x7f;SO&#x7f;SP&#x7f;SQ&#x7f;SR&#x7f;SS&#x7f;SST&#x7f;ST&#x7f;STI&#x7f;STN&#x7f;SV&#x7f;SW&#x7f;SX&#x7f;T0&#x7f;T1&#x7f;T3&#x7f;T4&#x7f;T5&#x7f;T6&#x7f;T7&#x7f;T8&#x7f;TA&#x7f;TAH&#x7f;TC&#x7f;TD&#x7f;TE&#x7f;TF&#x7f;TI&#x7f;TJ&#x7f;TK&#x7f;TL&#x7f;TN&#x7f;TNE&#x7f;TP&#x7f;TPR&#x7f;TQ&#x7f;TQD&#x7f;TR&#x7f;TRL&#x7f;TS&#x7f;TSD&#x7f;TSH&#x7f;TT&#x7f;TU&#x7f;TV&#x7f;TW&#x7f;TY&#x7f;U1&#x7f;U2&#x7f;UA&#x7f;UB&#x7f;UC&#x7f;UD&#x7f;UE&#x7f;UF&#x7f;UH&#x7f;UM&#x7f;VA&#x7f;VI&#x7f;VLT&#x7f;VQ&#x7f;VS&#x7f;W2&#x7f;W4&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WH&#x7f;WHR&#x7f;WI&#x7f;WM&#x7f;WR&#x7f;WSD&#x7f;WTT&#x7f;WW&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YL&#x7f;YRD&#x7f;YT&#x7f;Z1&#x7f;Z2&#x7f;Z3&#x7f;Z4&#x7f;Z5&#x7f;Z6&#x7f;Z8&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListVersionID!='8e') ) and contains('&#x7f;05&#x7f;06&#x7f;08&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;53&#x7f;54&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;66&#x7f;69&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;76&#x7f;77&#x7f;78&#x7f;80&#x7f;81&#x7f;84&#x7f;85&#x7f;87&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;1A&#x7f;1B&#x7f;1C&#x7f;1D&#x7f;1E&#x7f;1F&#x7f;1G&#x7f;1H&#x7f;1I&#x7f;1J&#x7f;1K&#x7f;1L&#x7f;1M&#x7f;1X&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2V&#x7f;2W&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;3E&#x7f;3G&#x7f;3H&#x7f;3I&#x7f;4A&#x7f;4B&#x7f;4C&#x7f;4E&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5C&#x7f;5E&#x7f;5F&#x7f;5G&#x7f;5H&#x7f;5I&#x7f;5J&#x7f;5K&#x7f;5P&#x7f;5Q&#x7f;A1&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A25&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A50&#x7f;A51&#x7f;A52&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A57&#x7f;A58&#x7f;A59&#x7f;A6&#x7f;A60&#x7f;A61&#x7f;A62&#x7f;A63&#x7f;A64&#x7f;A65&#x7f;A66&#x7f;A67&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A77&#x7f;A78&#x7f;A79&#x7f;A8&#x7f;A80&#x7f;A81&#x7f;A82&#x7f;A83&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;AP&#x7f;APZ&#x7f;AQ&#x7f;AR&#x7f;ARE&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;ATT&#x7f;AV&#x7f;AW&#x7f;AY&#x7f;AZ&#x7f;B0&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B2&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B36&#x7f;B37&#x7f;B38&#x7f;B39&#x7f;B4&#x7f;B40&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B5&#x7f;B50&#x7f;B51&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B6&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B65&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B9&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BFT&#x7f;BG&#x7f;BH&#x7f;BHP&#x7f;BIL&#x7f;BJ&#x7f;BK&#x7f;BL&#x7f;BLD&#x7f;BLL&#x7f;BO&#x7f;BP&#x7f;BQL&#x7f;BR&#x7f;BT&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;BW&#x7f;BX&#x7f;BZ&#x7f;C0&#x7f;C1&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C2&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C4&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C5&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C6&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C77&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C98&#x7f;C99&#x7f;CA&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CH&#x7f;CJ&#x7f;CK&#x7f;CKG&#x7f;CL&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;CO&#x7f;COU&#x7f;CQ&#x7f;CR&#x7f;CS&#x7f;CT&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CU&#x7f;CUR&#x7f;CV&#x7f;CWA&#x7f;CWI&#x7f;CY&#x7f;CZ&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D14&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D28&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D35&#x7f;D36&#x7f;D37&#x7f;D38&#x7f;D39&#x7f;D40&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D64&#x7f;D65&#x7f;D66&#x7f;D67&#x7f;D68&#x7f;D69&#x7f;D7&#x7f;D70&#x7f;D71&#x7f;D72&#x7f;D73&#x7f;D74&#x7f;D75&#x7f;D76&#x7f;D77&#x7f;D78&#x7f;D79&#x7f;D8&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D9&#x7f;D90&#x7f;D91&#x7f;D92&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;D96&#x7f;D97&#x7f;D98&#x7f;D99&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DC&#x7f;DD&#x7f;DE&#x7f;DEC&#x7f;DG&#x7f;DI&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DQ&#x7f;DR&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DRM&#x7f;DS&#x7f;DT&#x7f;DTN&#x7f;DU&#x7f;DWT&#x7f;DX&#x7f;DY&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E11&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E2&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E3&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E5&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EC&#x7f;EP&#x7f;EQ&#x7f;EV&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F1&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F9&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FB&#x7f;FBM&#x7f;FC&#x7f;FD&#x7f;FE&#x7f;FF&#x7f;FG&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FM&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G7&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GC&#x7f;GD&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GH&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GK&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GN&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GRT&#x7f;GT&#x7f;GV&#x7f;GW&#x7f;GWH&#x7f;GY&#x7f;GZ&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H1&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H2&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H78&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HAR&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HD&#x7f;HDW&#x7f;HE&#x7f;HEA&#x7f;HF&#x7f;HGM&#x7f;HH&#x7f;HI&#x7f;HIU&#x7f;HJ&#x7f;HK&#x7f;HKM&#x7f;HL&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HN&#x7f;HO&#x7f;HP&#x7f;HPA&#x7f;HS&#x7f;HT&#x7f;HTZ&#x7f;HUR&#x7f;HY&#x7f;IA&#x7f;IC&#x7f;IE&#x7f;IF&#x7f;II&#x7f;IL&#x7f;IM&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;IP&#x7f;ISD&#x7f;IT&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J89&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J94&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JB&#x7f;JE&#x7f;JG&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JO&#x7f;JOU&#x7f;JPS&#x7f;JR&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K24&#x7f;K25&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K5&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KD&#x7f;KDW&#x7f;KEL&#x7f;KF&#x7f;KG&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KS&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTM&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWO&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L61&#x7f;L62&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LC&#x7f;LD&#x7f;LE&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LI&#x7f;LJ&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LX&#x7f;LY&#x7f;M0&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MA&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MF&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MK&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQ&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MT&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MV&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N2&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NB&#x7f;NBB&#x7f;NC&#x7f;NCL&#x7f;ND&#x7f;NE&#x7f;NEW&#x7f;NF&#x7f;NG&#x7f;NH&#x7f;NI&#x7f;NIL&#x7f;NIU&#x7f;NJ&#x7f;NL&#x7f;NMI&#x7f;NMP&#x7f;NN&#x7f;NPL&#x7f;NPR&#x7f;NPT&#x7f;NQ&#x7f;NR&#x7f;NRL&#x7f;NT&#x7f;NTT&#x7f;NU&#x7f;NV&#x7f;NX&#x7f;NY&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OP&#x7f;OT&#x7f;OZ&#x7f;OZA&#x7f;OZI&#x7f;P0&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P3&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P4&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P6&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P7&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P8&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P9&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PA&#x7f;PAL&#x7f;PB&#x7f;PD&#x7f;PE&#x7f;PF&#x7f;PFL&#x7f;PG&#x7f;PGL&#x7f;PI&#x7f;PK&#x7f;PL&#x7f;PLA&#x7f;PM&#x7f;PN&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PU&#x7f;PV&#x7f;PW&#x7f;PY&#x7f;PZ&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QD&#x7f;QH&#x7f;QK&#x7f;QR&#x7f;QT&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R4&#x7f;R9&#x7f;RA&#x7f;RD&#x7f;RG&#x7f;RH&#x7f;RK&#x7f;RL&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RS&#x7f;RT&#x7f;RU&#x7f;S3&#x7f;S4&#x7f;S5&#x7f;S6&#x7f;S7&#x7f;S8&#x7f;SA&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SD&#x7f;SE&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SHT&#x7f;SIE&#x7f;SK&#x7f;SL&#x7f;SMI&#x7f;SN&#x7f;SO&#x7f;SP&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;SS&#x7f;SST&#x7f;ST&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SV&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T1&#x7f;T3&#x7f;T4&#x7f;T5&#x7f;T6&#x7f;T7&#x7f;T8&#x7f;TA&#x7f;TAH&#x7f;TAN&#x7f;TC&#x7f;TD&#x7f;TE&#x7f;TF&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TJ&#x7f;TK&#x7f;TKM&#x7f;TL&#x7f;TMS&#x7f;TN&#x7f;TNE&#x7f;TP&#x7f;TPR&#x7f;TQ&#x7f;TQD&#x7f;TR&#x7f;TRL&#x7f;TS&#x7f;TSD&#x7f;TSH&#x7f;TST&#x7f;TT&#x7f;TTS&#x7f;TU&#x7f;TV&#x7f;TW&#x7f;TY&#x7f;U1&#x7f;U2&#x7f;UA&#x7f;UB&#x7f;UC&#x7f;UD&#x7f;UE&#x7f;UF&#x7f;UH&#x7f;UM&#x7f;VA&#x7f;VI&#x7f;VLT&#x7f;VP&#x7f;VQ&#x7f;VS&#x7f;W2&#x7f;W4&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WH&#x7f;WHR&#x7f;WI&#x7f;WM&#x7f;WR&#x7f;WSD&#x7f;WTT&#x7f;WW&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YL&#x7f;YRD&#x7f;YT&#x7f;Z1&#x7f;Z11&#x7f;Z2&#x7f;Z3&#x7f;Z4&#x7f;Z5&#x7f;Z6&#x7f;Z8&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListVersionID!='12e_2016') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWO&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListVersionID!='12e_2016') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWN&#x7f;KWO&#x7f;KWS&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q41&#x7f;Q42&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListVersionID!='12e_2016') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWN&#x7f;KWO&#x7f;KWS&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q41&#x7f;Q42&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'UnitOfMeasure-2.0 UnitOfMeasure-2.1 UnitOfMeasure-2.2 UnitOfMeasure-2.3 UnitOfMeasure-2.4' in the context 'cbc:AltitudeMeasure/@unitCode | cbc:BaseUnitMeasure/@unitCode | cbc:ChargeableWeightMeasure/@unitCode | cbc:ComparedValueMeasure/@unitCode | cbc:ConsumptionMeasure/@unitCode | cbc:DurationMeasure/@unitCode | cbc:EstimatedGeneratedUntilNextPortMeasure/@unitCode | cbc:FuelConsumptionMeasure/@unitCode | cbc:GrossMassMeasure/@unitCode | cbc:GrossTonnageMeasure/@unitCode | cbc:GrossVolumeMeasure/@unitCode | cbc:GrossWeightMeasure/@unitCode | cbc:LatitudeDegreesMeasure/@unitCode | cbc:LatitudeMinutesMeasure/@unitCode | cbc:LeadTimeMeasure/@unitCode | cbc:LoadingLengthMeasure/@unitCode | cbc:LongitudeDegreesMeasure/@unitCode | cbc:LongitudeMinutesMeasure/@unitCode | cbc:MaxDedicatedStorageCapacityMeasure/@unitCode | cbc:MaximumDataLossDurationMeasure/@unitCode | cbc:MaximumIncidentNotificationDurationMeasure/@unitCode | cbc:MaximumMeasure/@unitCode | cbc:MeanTimeToRecoverDurationMeasure/@unitCode | cbc:Measure/@unitCode | cbc:MinimumDownTimeScheduleDurationMeasure/@unitCode | cbc:MinimumMeasure/@unitCode | cbc:MinimumResponseTimeDurationMeasure/@unitCode | cbc:NetNetWeightMeasure/@unitCode | cbc:NetTonnageMeasure/@unitCode | cbc:NetVolumeMeasure/@unitCode | cbc:NetWeightMeasure/@unitCode | cbc:PostEventNotificationDurationMeasure/@unitCode | cbc:PreEventNotificationDurationMeasure/@unitCode | cbc:RateOfTurnMeasure/@unitCode | cbc:ResponseMeasure/@unitCode | cbc:RetainedOnBoardMeasure/@unitCode | cbc:SalinityMeasure/@unitCode | cbc:SeaHeightMeasure/@unitCode | cbc:SegregatedBallastMeasure/@unitCode | cbc:SourceValueMeasure/@unitCode | cbc:SpeedOverGroundMeasure/@unitCode | cbc:TareWeightMeasure/@unitCode | cbc:ToBeDeliveredMeasure/@unitCode | cbc:TotalBallastWaterCapacityMeasure/@unitCode | cbc:TotalBallastWaterOnBoardMeasure/@unitCode | cbc:ValueBaseMeasure/@unitCode | cbc:ValueMeasure/@unitCode | cbc:VolumeMeasure/@unitCode | cbc:WasteMeasure/@unitCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:ActualTemperatureReductionQuantity/@unitCode | cbc:BackorderQuantity/@unitCode | cbc:BaseQuantity/@unitCode | cbc:BasicConsumedQuantity/@unitCode | cbc:BatchQuantity/@unitCode | cbc:ChargeableQuantity/@unitCode | cbc:ChildConsignmentQuantity/@unitCode | cbc:ConsignmentQuantity/@unitCode | cbc:ConsumerUnitQuantity/@unitCode | cbc:ConsumptionEnergyQuantity/@unitCode | cbc:ConsumptionWaterQuantity/@unitCode | cbc:ContentUnitQuantity/@unitCode | cbc:CreditedQuantity/@unitCode | cbc:CrewQuantity/@unitCode | cbc:CustomsTariffQuantity/@unitCode | cbc:DebitedQuantity/@unitCode | cbc:DeliveredQuantity/@unitCode | cbc:DifferenceTemperatureReductionQuantity/@unitCode | cbc:EmployeeQuantity/@unitCode | cbc:EstimatedConsumedQuantity/@unitCode | cbc:EstimatedOverallContractQuantity/@unitCode | cbc:ExpectedOperatorQuantity/@unitCode | cbc:ExpectedQuantity/@unitCode | cbc:GasPressureQuantity/@unitCode | cbc:InvoicedQuantity/@unitCode | cbc:LatestMeterQuantity/@unitCode | cbc:MaximumBackorderQuantity/@unitCode | cbc:MaximumOperatorQuantity/@unitCode | cbc:MaximumOrderQuantity/@unitCode | cbc:MaximumQuantity/@unitCode | cbc:MaximumVariantQuantity/@unitCode | cbc:MinimumBackorderQuantity/@unitCode | cbc:MinimumInventoryQuantity/@unitCode | cbc:MinimumOrderQuantity/@unitCode | cbc:MinimumQuantity/@unitCode | cbc:MultipleOrderQuantity/@unitCode | cbc:NormalTemperatureReductionQuantity/@unitCode | cbc:OperatingYearsQuantity/@unitCode | cbc:OutstandingQuantity/@unitCode | cbc:OversupplyQuantity/@unitCode | cbc:PackQuantity/@unitCode | cbc:PassengerQuantity/@unitCode | cbc:PerformanceValueQuantity/@unitCode | cbc:PreviousMeterQuantity/@unitCode | cbc:Quantity/@unitCode | cbc:ReceivedElectronicTenderQuantity/@unitCode | cbc:ReceivedForeignTenderQuantity/@unitCode | cbc:ReceivedQuantity/@unitCode | cbc:ReceivedTenderQuantity/@unitCode | cbc:RejectedQuantity/@unitCode | cbc:ResponseQuantity/@unitCode | cbc:ReturnableQuantity/@unitCode | cbc:SharesNumberQuantity/@unitCode | cbc:ShortQuantity/@unitCode | cbc:TanksExchangedQuantity/@unitCode | cbc:TanksInBallastQuantity/@unitCode | cbc:TanksNotExchangedQuantity/@unitCode | cbc:TargetInventoryQuantity/@unitCode | cbc:ThresholdQuantity/@unitCode | cbc:TimeDeltaDaysQuantity/@unitCode | cbc:TotalBallastTanksOnBoardQuantity/@unitCode | cbc:TotalConsumedQuantity/@unitCode | cbc:TotalDeadPersonQuantity/@unitCode | cbc:TotalDeliveredQuantity/@unitCode | cbc:TotalGoodsItemQuantity/@unitCode | cbc:TotalIllPersonQuantity/@unitCode | cbc:TotalMeteredQuantity/@unitCode | cbc:TotalPackageQuantity/@unitCode | cbc:TotalPackagesQuantity/@unitCode | cbc:TotalTransportHandlingUnitQuantity/@unitCode | cbc:ValueQuantity/@unitCode | cbc:VarianceQuantity/@unitCode"
                 priority="20"
                 mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:ActualTemperatureReductionQuantity/@unitCode | cbc:BackorderQuantity/@unitCode | cbc:BaseQuantity/@unitCode | cbc:BasicConsumedQuantity/@unitCode | cbc:BatchQuantity/@unitCode | cbc:ChargeableQuantity/@unitCode | cbc:ChildConsignmentQuantity/@unitCode | cbc:ConsignmentQuantity/@unitCode | cbc:ConsumerUnitQuantity/@unitCode | cbc:ConsumptionEnergyQuantity/@unitCode | cbc:ConsumptionWaterQuantity/@unitCode | cbc:ContentUnitQuantity/@unitCode | cbc:CreditedQuantity/@unitCode | cbc:CrewQuantity/@unitCode | cbc:CustomsTariffQuantity/@unitCode | cbc:DebitedQuantity/@unitCode | cbc:DeliveredQuantity/@unitCode | cbc:DifferenceTemperatureReductionQuantity/@unitCode | cbc:EmployeeQuantity/@unitCode | cbc:EstimatedConsumedQuantity/@unitCode | cbc:EstimatedOverallContractQuantity/@unitCode | cbc:ExpectedOperatorQuantity/@unitCode | cbc:ExpectedQuantity/@unitCode | cbc:GasPressureQuantity/@unitCode | cbc:InvoicedQuantity/@unitCode | cbc:LatestMeterQuantity/@unitCode | cbc:MaximumBackorderQuantity/@unitCode | cbc:MaximumOperatorQuantity/@unitCode | cbc:MaximumOrderQuantity/@unitCode | cbc:MaximumQuantity/@unitCode | cbc:MaximumVariantQuantity/@unitCode | cbc:MinimumBackorderQuantity/@unitCode | cbc:MinimumInventoryQuantity/@unitCode | cbc:MinimumOrderQuantity/@unitCode | cbc:MinimumQuantity/@unitCode | cbc:MultipleOrderQuantity/@unitCode | cbc:NormalTemperatureReductionQuantity/@unitCode | cbc:OperatingYearsQuantity/@unitCode | cbc:OutstandingQuantity/@unitCode | cbc:OversupplyQuantity/@unitCode | cbc:PackQuantity/@unitCode | cbc:PassengerQuantity/@unitCode | cbc:PerformanceValueQuantity/@unitCode | cbc:PreviousMeterQuantity/@unitCode | cbc:Quantity/@unitCode | cbc:ReceivedElectronicTenderQuantity/@unitCode | cbc:ReceivedForeignTenderQuantity/@unitCode | cbc:ReceivedQuantity/@unitCode | cbc:ReceivedTenderQuantity/@unitCode | cbc:RejectedQuantity/@unitCode | cbc:ResponseQuantity/@unitCode | cbc:ReturnableQuantity/@unitCode | cbc:SharesNumberQuantity/@unitCode | cbc:ShortQuantity/@unitCode | cbc:TanksExchangedQuantity/@unitCode | cbc:TanksInBallastQuantity/@unitCode | cbc:TanksNotExchangedQuantity/@unitCode | cbc:TargetInventoryQuantity/@unitCode | cbc:ThresholdQuantity/@unitCode | cbc:TimeDeltaDaysQuantity/@unitCode | cbc:TotalBallastTanksOnBoardQuantity/@unitCode | cbc:TotalConsumedQuantity/@unitCode | cbc:TotalDeadPersonQuantity/@unitCode | cbc:TotalDeliveredQuantity/@unitCode | cbc:TotalGoodsItemQuantity/@unitCode | cbc:TotalIllPersonQuantity/@unitCode | cbc:TotalMeteredQuantity/@unitCode | cbc:TotalPackageQuantity/@unitCode | cbc:TotalPackagesQuantity/@unitCode | cbc:TotalTransportHandlingUnitQuantity/@unitCode | cbc:ValueQuantity/@unitCode | cbc:VarianceQuantity/@unitCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:ActualTemperatureReductionQuantity/@unitCode | cbc:BackorderQuantity/@unitCode | cbc:BaseQuantity/@unitCode | cbc:BasicConsumedQuantity/@unitCode | cbc:BatchQuantity/@unitCode | cbc:ChargeableQuantity/@unitCode | cbc:ChildConsignmentQuantity/@unitCode | cbc:ConsignmentQuantity/@unitCode | cbc:ConsumerUnitQuantity/@unitCode | cbc:ConsumptionEnergyQuantity/@unitCode | cbc:ConsumptionWaterQuantity/@unitCode | cbc:ContentUnitQuantity/@unitCode | cbc:CreditedQuantity/@unitCode | cbc:CrewQuantity/@unitCode | cbc:CustomsTariffQuantity/@unitCode | cbc:DebitedQuantity/@unitCode | cbc:DeliveredQuantity/@unitCode | cbc:DifferenceTemperatureReductionQuantity/@unitCode | cbc:EmployeeQuantity/@unitCode | cbc:EstimatedConsumedQuantity/@unitCode | cbc:EstimatedOverallContractQuantity/@unitCode | cbc:ExpectedOperatorQuantity/@unitCode | cbc:ExpectedQuantity/@unitCode | cbc:GasPressureQuantity/@unitCode | cbc:InvoicedQuantity/@unitCode | cbc:LatestMeterQuantity/@unitCode | cbc:MaximumBackorderQuantity/@unitCode | cbc:MaximumOperatorQuantity/@unitCode | cbc:MaximumOrderQuantity/@unitCode | cbc:MaximumQuantity/@unitCode | cbc:MaximumVariantQuantity/@unitCode | cbc:MinimumBackorderQuantity/@unitCode | cbc:MinimumInventoryQuantity/@unitCode | cbc:MinimumOrderQuantity/@unitCode | cbc:MinimumQuantity/@unitCode | cbc:MultipleOrderQuantity/@unitCode | cbc:NormalTemperatureReductionQuantity/@unitCode | cbc:OperatingYearsQuantity/@unitCode | cbc:OutstandingQuantity/@unitCode | cbc:OversupplyQuantity/@unitCode | cbc:PackQuantity/@unitCode | cbc:PassengerQuantity/@unitCode | cbc:PerformanceValueQuantity/@unitCode | cbc:PreviousMeterQuantity/@unitCode | cbc:Quantity/@unitCode | cbc:ReceivedElectronicTenderQuantity/@unitCode | cbc:ReceivedForeignTenderQuantity/@unitCode | cbc:ReceivedQuantity/@unitCode | cbc:ReceivedTenderQuantity/@unitCode | cbc:RejectedQuantity/@unitCode | cbc:ResponseQuantity/@unitCode | cbc:ReturnableQuantity/@unitCode | cbc:SharesNumberQuantity/@unitCode | cbc:ShortQuantity/@unitCode | cbc:TanksExchangedQuantity/@unitCode | cbc:TanksInBallastQuantity/@unitCode | cbc:TanksNotExchangedQuantity/@unitCode | cbc:TargetInventoryQuantity/@unitCode | cbc:ThresholdQuantity/@unitCode | cbc:TimeDeltaDaysQuantity/@unitCode | cbc:TotalBallastTanksOnBoardQuantity/@unitCode | cbc:TotalConsumedQuantity/@unitCode | cbc:TotalDeadPersonQuantity/@unitCode | cbc:TotalDeliveredQuantity/@unitCode | cbc:TotalGoodsItemQuantity/@unitCode | cbc:TotalIllPersonQuantity/@unitCode | cbc:TotalMeteredQuantity/@unitCode | cbc:TotalPackageQuantity/@unitCode | cbc:TotalPackagesQuantity/@unitCode | cbc:TotalTransportHandlingUnitQuantity/@unitCode | cbc:ValueQuantity/@unitCode | cbc:VarianceQuantity/@unitCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:ActualTemperatureReductionQuantity/@unitCode | cbc:BackorderQuantity/@unitCode | cbc:BaseQuantity/@unitCode | cbc:BasicConsumedQuantity/@unitCode | cbc:BatchQuantity/@unitCode | cbc:ChargeableQuantity/@unitCode | cbc:ChildConsignmentQuantity/@unitCode | cbc:ConsignmentQuantity/@unitCode | cbc:ConsumerUnitQuantity/@unitCode | cbc:ConsumptionEnergyQuantity/@unitCode | cbc:ConsumptionWaterQuantity/@unitCode | cbc:ContentUnitQuantity/@unitCode | cbc:CreditedQuantity/@unitCode | cbc:CrewQuantity/@unitCode | cbc:CustomsTariffQuantity/@unitCode | cbc:DebitedQuantity/@unitCode | cbc:DeliveredQuantity/@unitCode | cbc:DifferenceTemperatureReductionQuantity/@unitCode | cbc:EmployeeQuantity/@unitCode | cbc:EstimatedConsumedQuantity/@unitCode | cbc:EstimatedOverallContractQuantity/@unitCode | cbc:ExpectedOperatorQuantity/@unitCode | cbc:ExpectedQuantity/@unitCode | cbc:GasPressureQuantity/@unitCode | cbc:InvoicedQuantity/@unitCode | cbc:LatestMeterQuantity/@unitCode | cbc:MaximumBackorderQuantity/@unitCode | cbc:MaximumOperatorQuantity/@unitCode | cbc:MaximumOrderQuantity/@unitCode | cbc:MaximumQuantity/@unitCode | cbc:MaximumVariantQuantity/@unitCode | cbc:MinimumBackorderQuantity/@unitCode | cbc:MinimumInventoryQuantity/@unitCode | cbc:MinimumOrderQuantity/@unitCode | cbc:MinimumQuantity/@unitCode | cbc:MultipleOrderQuantity/@unitCode | cbc:NormalTemperatureReductionQuantity/@unitCode | cbc:OperatingYearsQuantity/@unitCode | cbc:OutstandingQuantity/@unitCode | cbc:OversupplyQuantity/@unitCode | cbc:PackQuantity/@unitCode | cbc:PassengerQuantity/@unitCode | cbc:PerformanceValueQuantity/@unitCode | cbc:PreviousMeterQuantity/@unitCode | cbc:Quantity/@unitCode | cbc:ReceivedElectronicTenderQuantity/@unitCode | cbc:ReceivedForeignTenderQuantity/@unitCode | cbc:ReceivedQuantity/@unitCode | cbc:ReceivedTenderQuantity/@unitCode | cbc:RejectedQuantity/@unitCode | cbc:ResponseQuantity/@unitCode | cbc:ReturnableQuantity/@unitCode | cbc:SharesNumberQuantity/@unitCode | cbc:ShortQuantity/@unitCode | cbc:TanksExchangedQuantity/@unitCode | cbc:TanksInBallastQuantity/@unitCode | cbc:TanksNotExchangedQuantity/@unitCode | cbc:TargetInventoryQuantity/@unitCode | cbc:ThresholdQuantity/@unitCode | cbc:TimeDeltaDaysQuantity/@unitCode | cbc:TotalBallastTanksOnBoardQuantity/@unitCode | cbc:TotalConsumedQuantity/@unitCode | cbc:TotalDeadPersonQuantity/@unitCode | cbc:TotalDeliveredQuantity/@unitCode | cbc:TotalGoodsItemQuantity/@unitCode | cbc:TotalIllPersonQuantity/@unitCode | cbc:TotalMeteredQuantity/@unitCode | cbc:TotalPackageQuantity/@unitCode | cbc:TotalPackagesQuantity/@unitCode | cbc:TotalTransportHandlingUnitQuantity/@unitCode | cbc:ValueQuantity/@unitCode | cbc:VarianceQuantity/@unitCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(../@unitCodeListID!='UN/ECE rec 20') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;04&#x7f;05&#x7f;08&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;53&#x7f;54&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;66&#x7f;69&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;76&#x7f;77&#x7f;78&#x7f;80&#x7f;81&#x7f;84&#x7f;85&#x7f;87&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;1A&#x7f;1B&#x7f;1C&#x7f;1D&#x7f;1E&#x7f;1F&#x7f;1G&#x7f;1H&#x7f;1I&#x7f;1J&#x7f;1K&#x7f;1L&#x7f;1M&#x7f;1X&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2V&#x7f;2W&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;3E&#x7f;3G&#x7f;3H&#x7f;3I&#x7f;4A&#x7f;4B&#x7f;4C&#x7f;4E&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5C&#x7f;5E&#x7f;5F&#x7f;5G&#x7f;5H&#x7f;5I&#x7f;5J&#x7f;5K&#x7f;5P&#x7f;5Q&#x7f;A1&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A25&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A50&#x7f;A51&#x7f;A52&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A57&#x7f;A58&#x7f;A6&#x7f;A60&#x7f;A61&#x7f;A62&#x7f;A63&#x7f;A64&#x7f;A65&#x7f;A66&#x7f;A67&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A77&#x7f;A78&#x7f;A79&#x7f;A8&#x7f;A80&#x7f;A81&#x7f;A82&#x7f;A83&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;AP&#x7f;APZ&#x7f;AQ&#x7f;AR&#x7f;ARE&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;ATT&#x7f;AV&#x7f;AW&#x7f;AY&#x7f;AZ&#x7f;B0&#x7f;B1&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B18&#x7f;B2&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B36&#x7f;B37&#x7f;B38&#x7f;B39&#x7f;B4&#x7f;B40&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B5&#x7f;B50&#x7f;B51&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B6&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B65&#x7f;B66&#x7f;B67&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B81&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B9&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BFT&#x7f;BG&#x7f;BH&#x7f;BHP&#x7f;BIL&#x7f;BJ&#x7f;BK&#x7f;BL&#x7f;BLD&#x7f;BLL&#x7f;BO&#x7f;BP&#x7f;BQL&#x7f;BR&#x7f;BT&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;BW&#x7f;BX&#x7f;BZ&#x7f;C0&#x7f;C1&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C2&#x7f;C20&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C38&#x7f;C39&#x7f;C4&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C5&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C6&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C75&#x7f;C76&#x7f;C77&#x7f;C78&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C98&#x7f;C99&#x7f;CA&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CH&#x7f;CJ&#x7f;CK&#x7f;CKG&#x7f;CL&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;CO&#x7f;COU&#x7f;CQ&#x7f;CR&#x7f;CS&#x7f;CT&#x7f;CTM&#x7f;CU&#x7f;CUR&#x7f;CV&#x7f;CWA&#x7f;CWI&#x7f;CY&#x7f;CZ&#x7f;D1&#x7f;D10&#x7f;D12&#x7f;D13&#x7f;D14&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D28&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D35&#x7f;D37&#x7f;D38&#x7f;D39&#x7f;D40&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D64&#x7f;D65&#x7f;D66&#x7f;D67&#x7f;D69&#x7f;D7&#x7f;D70&#x7f;D71&#x7f;D72&#x7f;D73&#x7f;D74&#x7f;D75&#x7f;D76&#x7f;D77&#x7f;D79&#x7f;D8&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D9&#x7f;D90&#x7f;D91&#x7f;D92&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;D96&#x7f;D97&#x7f;D98&#x7f;D99&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DC&#x7f;DD&#x7f;DE&#x7f;DEC&#x7f;DG&#x7f;DI&#x7f;DJ&#x7f;DLT&#x7f;DMK&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DQ&#x7f;DR&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DRM&#x7f;DS&#x7f;DT&#x7f;DTN&#x7f;DU&#x7f;DWT&#x7f;DX&#x7f;DY&#x7f;DZN&#x7f;DZP&#x7f;E2&#x7f;E3&#x7f;E4&#x7f;E5&#x7f;EA&#x7f;EB&#x7f;EC&#x7f;EP&#x7f;EQ&#x7f;EV&#x7f;F1&#x7f;F9&#x7f;FAH&#x7f;FAR&#x7f;FB&#x7f;FC&#x7f;FD&#x7f;FE&#x7f;FF&#x7f;FG&#x7f;FH&#x7f;FL&#x7f;FM&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G2&#x7f;G3&#x7f;G7&#x7f;GB&#x7f;GBQ&#x7f;GC&#x7f;GD&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GH&#x7f;GIA&#x7f;GII&#x7f;GJ&#x7f;GK&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GN&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GRT&#x7f;GT&#x7f;GV&#x7f;GW&#x7f;GWH&#x7f;GY&#x7f;GZ&#x7f;H1&#x7f;H2&#x7f;HA&#x7f;HAR&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HD&#x7f;HE&#x7f;HF&#x7f;HGM&#x7f;HH&#x7f;HI&#x7f;HIU&#x7f;HJ&#x7f;HK&#x7f;HL&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HN&#x7f;HO&#x7f;HP&#x7f;HPA&#x7f;HS&#x7f;HT&#x7f;HTZ&#x7f;HUR&#x7f;HY&#x7f;IA&#x7f;IC&#x7f;IE&#x7f;IF&#x7f;II&#x7f;IL&#x7f;IM&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;IP&#x7f;IT&#x7f;IU&#x7f;IV&#x7f;J2&#x7f;JB&#x7f;JE&#x7f;JG&#x7f;JK&#x7f;JM&#x7f;JO&#x7f;JOU&#x7f;JR&#x7f;K1&#x7f;K2&#x7f;K3&#x7f;K5&#x7f;K6&#x7f;KA&#x7f;KB&#x7f;KBA&#x7f;KD&#x7f;KEL&#x7f;KF&#x7f;KG&#x7f;KGM&#x7f;KGS&#x7f;KHZ&#x7f;KI&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KNI&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KS&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTM&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWT&#x7f;KX&#x7f;L2&#x7f;LA&#x7f;LBR&#x7f;LBT&#x7f;LC&#x7f;LD&#x7f;LE&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LI&#x7f;LJ&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUM&#x7f;LUX&#x7f;LX&#x7f;LY&#x7f;M0&#x7f;M1&#x7f;M4&#x7f;M5&#x7f;M7&#x7f;M9&#x7f;MA&#x7f;MAL&#x7f;MAM&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MF&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MK&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MON&#x7f;MPA&#x7f;MQ&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MT&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MV&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N2&#x7f;N3&#x7f;NA&#x7f;NAR&#x7f;NB&#x7f;NBB&#x7f;NC&#x7f;NCL&#x7f;ND&#x7f;NE&#x7f;NEW&#x7f;NF&#x7f;NG&#x7f;NH&#x7f;NI&#x7f;NIU&#x7f;NJ&#x7f;NL&#x7f;NMI&#x7f;NMP&#x7f;NN&#x7f;NPL&#x7f;NPR&#x7f;NPT&#x7f;NQ&#x7f;NR&#x7f;NRL&#x7f;NT&#x7f;NTT&#x7f;NU&#x7f;NV&#x7f;NX&#x7f;NY&#x7f;OA&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OP&#x7f;OT&#x7f;OZ&#x7f;OZA&#x7f;OZI&#x7f;P0&#x7f;P1&#x7f;P2&#x7f;P3&#x7f;P4&#x7f;P5&#x7f;P6&#x7f;P7&#x7f;P8&#x7f;P9&#x7f;PA&#x7f;PAL&#x7f;PB&#x7f;PD&#x7f;PE&#x7f;PF&#x7f;PG&#x7f;PGL&#x7f;PI&#x7f;PK&#x7f;PL&#x7f;PM&#x7f;PN&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PU&#x7f;PV&#x7f;PW&#x7f;PY&#x7f;PZ&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QD&#x7f;QH&#x7f;QK&#x7f;QR&#x7f;QT&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R4&#x7f;R9&#x7f;RA&#x7f;RD&#x7f;RG&#x7f;RH&#x7f;RK&#x7f;RL&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RS&#x7f;RT&#x7f;RU&#x7f;S3&#x7f;S4&#x7f;S5&#x7f;S6&#x7f;S7&#x7f;S8&#x7f;SA&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SD&#x7f;SE&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SHT&#x7f;SIE&#x7f;SK&#x7f;SL&#x7f;SMI&#x7f;SN&#x7f;SO&#x7f;SP&#x7f;SQ&#x7f;SR&#x7f;SS&#x7f;SST&#x7f;ST&#x7f;STI&#x7f;STN&#x7f;SV&#x7f;SW&#x7f;SX&#x7f;T0&#x7f;T1&#x7f;T3&#x7f;T4&#x7f;T5&#x7f;T6&#x7f;T7&#x7f;T8&#x7f;TA&#x7f;TAH&#x7f;TC&#x7f;TD&#x7f;TE&#x7f;TF&#x7f;TI&#x7f;TJ&#x7f;TK&#x7f;TL&#x7f;TN&#x7f;TNE&#x7f;TP&#x7f;TPR&#x7f;TQ&#x7f;TQD&#x7f;TR&#x7f;TRL&#x7f;TS&#x7f;TSD&#x7f;TSH&#x7f;TT&#x7f;TU&#x7f;TV&#x7f;TW&#x7f;TY&#x7f;U1&#x7f;U2&#x7f;UA&#x7f;UB&#x7f;UC&#x7f;UD&#x7f;UE&#x7f;UF&#x7f;UH&#x7f;UM&#x7f;VA&#x7f;VI&#x7f;VLT&#x7f;VQ&#x7f;VS&#x7f;W2&#x7f;W4&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WH&#x7f;WHR&#x7f;WI&#x7f;WM&#x7f;WR&#x7f;WSD&#x7f;WTT&#x7f;WW&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YL&#x7f;YRD&#x7f;YT&#x7f;Z1&#x7f;Z2&#x7f;Z3&#x7f;Z4&#x7f;Z5&#x7f;Z6&#x7f;Z8&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListID!='UN/ECE rec 20') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;05&#x7f;06&#x7f;08&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;53&#x7f;54&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;66&#x7f;69&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;76&#x7f;77&#x7f;78&#x7f;80&#x7f;81&#x7f;84&#x7f;85&#x7f;87&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;1A&#x7f;1B&#x7f;1C&#x7f;1D&#x7f;1E&#x7f;1F&#x7f;1G&#x7f;1H&#x7f;1I&#x7f;1J&#x7f;1K&#x7f;1L&#x7f;1M&#x7f;1X&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2V&#x7f;2W&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;3E&#x7f;3G&#x7f;3H&#x7f;3I&#x7f;4A&#x7f;4B&#x7f;4C&#x7f;4E&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5C&#x7f;5E&#x7f;5F&#x7f;5G&#x7f;5H&#x7f;5I&#x7f;5J&#x7f;5K&#x7f;5P&#x7f;5Q&#x7f;A1&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A25&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A50&#x7f;A51&#x7f;A52&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A57&#x7f;A58&#x7f;A59&#x7f;A6&#x7f;A60&#x7f;A61&#x7f;A62&#x7f;A63&#x7f;A64&#x7f;A65&#x7f;A66&#x7f;A67&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A77&#x7f;A78&#x7f;A79&#x7f;A8&#x7f;A80&#x7f;A81&#x7f;A82&#x7f;A83&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;AP&#x7f;APZ&#x7f;AQ&#x7f;AR&#x7f;ARE&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;ATT&#x7f;AV&#x7f;AW&#x7f;AY&#x7f;AZ&#x7f;B0&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B2&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B36&#x7f;B37&#x7f;B38&#x7f;B39&#x7f;B4&#x7f;B40&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B5&#x7f;B50&#x7f;B51&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B6&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B65&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B9&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BFT&#x7f;BG&#x7f;BH&#x7f;BHP&#x7f;BIL&#x7f;BJ&#x7f;BK&#x7f;BL&#x7f;BLD&#x7f;BLL&#x7f;BO&#x7f;BP&#x7f;BQL&#x7f;BR&#x7f;BT&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;BW&#x7f;BX&#x7f;BZ&#x7f;C0&#x7f;C1&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C2&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C4&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C5&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C6&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C77&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C98&#x7f;C99&#x7f;CA&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CH&#x7f;CJ&#x7f;CK&#x7f;CKG&#x7f;CL&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;CO&#x7f;COU&#x7f;CQ&#x7f;CR&#x7f;CS&#x7f;CT&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CU&#x7f;CUR&#x7f;CV&#x7f;CWA&#x7f;CWI&#x7f;CY&#x7f;CZ&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D14&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D28&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D35&#x7f;D36&#x7f;D37&#x7f;D38&#x7f;D39&#x7f;D40&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D64&#x7f;D65&#x7f;D66&#x7f;D67&#x7f;D68&#x7f;D69&#x7f;D7&#x7f;D70&#x7f;D71&#x7f;D72&#x7f;D73&#x7f;D74&#x7f;D75&#x7f;D76&#x7f;D77&#x7f;D78&#x7f;D79&#x7f;D8&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D9&#x7f;D90&#x7f;D91&#x7f;D92&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;D96&#x7f;D97&#x7f;D98&#x7f;D99&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DC&#x7f;DD&#x7f;DE&#x7f;DEC&#x7f;DG&#x7f;DI&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DQ&#x7f;DR&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DRM&#x7f;DS&#x7f;DT&#x7f;DTN&#x7f;DU&#x7f;DWT&#x7f;DX&#x7f;DY&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E11&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E2&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E3&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E5&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EC&#x7f;EP&#x7f;EQ&#x7f;EV&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F1&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F9&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FB&#x7f;FBM&#x7f;FC&#x7f;FD&#x7f;FE&#x7f;FF&#x7f;FG&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FM&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G7&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GC&#x7f;GD&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GH&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GK&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GN&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GRT&#x7f;GT&#x7f;GV&#x7f;GW&#x7f;GWH&#x7f;GY&#x7f;GZ&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H1&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H2&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H78&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HAR&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HD&#x7f;HDW&#x7f;HE&#x7f;HEA&#x7f;HF&#x7f;HGM&#x7f;HH&#x7f;HI&#x7f;HIU&#x7f;HJ&#x7f;HK&#x7f;HKM&#x7f;HL&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HN&#x7f;HO&#x7f;HP&#x7f;HPA&#x7f;HS&#x7f;HT&#x7f;HTZ&#x7f;HUR&#x7f;HY&#x7f;IA&#x7f;IC&#x7f;IE&#x7f;IF&#x7f;II&#x7f;IL&#x7f;IM&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;IP&#x7f;ISD&#x7f;IT&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J89&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J94&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JB&#x7f;JE&#x7f;JG&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JO&#x7f;JOU&#x7f;JPS&#x7f;JR&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K24&#x7f;K25&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K5&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KD&#x7f;KDW&#x7f;KEL&#x7f;KF&#x7f;KG&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KS&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTM&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWO&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L61&#x7f;L62&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LC&#x7f;LD&#x7f;LE&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LI&#x7f;LJ&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LX&#x7f;LY&#x7f;M0&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MA&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MF&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MK&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQ&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MT&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MV&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N2&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NB&#x7f;NBB&#x7f;NC&#x7f;NCL&#x7f;ND&#x7f;NE&#x7f;NEW&#x7f;NF&#x7f;NG&#x7f;NH&#x7f;NI&#x7f;NIL&#x7f;NIU&#x7f;NJ&#x7f;NL&#x7f;NMI&#x7f;NMP&#x7f;NN&#x7f;NPL&#x7f;NPR&#x7f;NPT&#x7f;NQ&#x7f;NR&#x7f;NRL&#x7f;NT&#x7f;NTT&#x7f;NU&#x7f;NV&#x7f;NX&#x7f;NY&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OP&#x7f;OT&#x7f;OZ&#x7f;OZA&#x7f;OZI&#x7f;P0&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P3&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P4&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P6&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P7&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P8&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P9&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PA&#x7f;PAL&#x7f;PB&#x7f;PD&#x7f;PE&#x7f;PF&#x7f;PFL&#x7f;PG&#x7f;PGL&#x7f;PI&#x7f;PK&#x7f;PL&#x7f;PLA&#x7f;PM&#x7f;PN&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PU&#x7f;PV&#x7f;PW&#x7f;PY&#x7f;PZ&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QD&#x7f;QH&#x7f;QK&#x7f;QR&#x7f;QT&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R4&#x7f;R9&#x7f;RA&#x7f;RD&#x7f;RG&#x7f;RH&#x7f;RK&#x7f;RL&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RS&#x7f;RT&#x7f;RU&#x7f;S3&#x7f;S4&#x7f;S5&#x7f;S6&#x7f;S7&#x7f;S8&#x7f;SA&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SD&#x7f;SE&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SHT&#x7f;SIE&#x7f;SK&#x7f;SL&#x7f;SMI&#x7f;SN&#x7f;SO&#x7f;SP&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;SS&#x7f;SST&#x7f;ST&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SV&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T1&#x7f;T3&#x7f;T4&#x7f;T5&#x7f;T6&#x7f;T7&#x7f;T8&#x7f;TA&#x7f;TAH&#x7f;TAN&#x7f;TC&#x7f;TD&#x7f;TE&#x7f;TF&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TJ&#x7f;TK&#x7f;TKM&#x7f;TL&#x7f;TMS&#x7f;TN&#x7f;TNE&#x7f;TP&#x7f;TPR&#x7f;TQ&#x7f;TQD&#x7f;TR&#x7f;TRL&#x7f;TS&#x7f;TSD&#x7f;TSH&#x7f;TST&#x7f;TT&#x7f;TTS&#x7f;TU&#x7f;TV&#x7f;TW&#x7f;TY&#x7f;U1&#x7f;U2&#x7f;UA&#x7f;UB&#x7f;UC&#x7f;UD&#x7f;UE&#x7f;UF&#x7f;UH&#x7f;UM&#x7f;VA&#x7f;VI&#x7f;VLT&#x7f;VP&#x7f;VQ&#x7f;VS&#x7f;W2&#x7f;W4&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WH&#x7f;WHR&#x7f;WI&#x7f;WM&#x7f;WR&#x7f;WSD&#x7f;WTT&#x7f;WW&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YL&#x7f;YRD&#x7f;YT&#x7f;Z1&#x7f;Z11&#x7f;Z2&#x7f;Z3&#x7f;Z4&#x7f;Z5&#x7f;Z6&#x7f;Z8&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListID!='UNECE Recommendation N°. 20 - Codes for Units of Measure Used in International Trade') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWO&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListID!='UNECE Recommendation N°. 20 - Codes for Units of Measure Used in International Trade') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWN&#x7f;KWO&#x7f;KWS&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q41&#x7f;Q42&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListID!='UNECE Recommendation N°. 20 - Codes for Units of Measure Used in International Trade') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWN&#x7f;KWO&#x7f;KWS&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q41&#x7f;Q42&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(../@unitCodeListID!='UN/ECE rec 20') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;04&#x7f;05&#x7f;08&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;53&#x7f;54&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;66&#x7f;69&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;76&#x7f;77&#x7f;78&#x7f;80&#x7f;81&#x7f;84&#x7f;85&#x7f;87&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;1A&#x7f;1B&#x7f;1C&#x7f;1D&#x7f;1E&#x7f;1F&#x7f;1G&#x7f;1H&#x7f;1I&#x7f;1J&#x7f;1K&#x7f;1L&#x7f;1M&#x7f;1X&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2V&#x7f;2W&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;3E&#x7f;3G&#x7f;3H&#x7f;3I&#x7f;4A&#x7f;4B&#x7f;4C&#x7f;4E&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5C&#x7f;5E&#x7f;5F&#x7f;5G&#x7f;5H&#x7f;5I&#x7f;5J&#x7f;5K&#x7f;5P&#x7f;5Q&#x7f;A1&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A25&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A50&#x7f;A51&#x7f;A52&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A57&#x7f;A58&#x7f;A6&#x7f;A60&#x7f;A61&#x7f;A62&#x7f;A63&#x7f;A64&#x7f;A65&#x7f;A66&#x7f;A67&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A77&#x7f;A78&#x7f;A79&#x7f;A8&#x7f;A80&#x7f;A81&#x7f;A82&#x7f;A83&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;AP&#x7f;APZ&#x7f;AQ&#x7f;AR&#x7f;ARE&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;ATT&#x7f;AV&#x7f;AW&#x7f;AY&#x7f;AZ&#x7f;B0&#x7f;B1&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B18&#x7f;B2&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B36&#x7f;B37&#x7f;B38&#x7f;B39&#x7f;B4&#x7f;B40&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B5&#x7f;B50&#x7f;B51&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B6&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B65&#x7f;B66&#x7f;B67&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B81&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B9&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BFT&#x7f;BG&#x7f;BH&#x7f;BHP&#x7f;BIL&#x7f;BJ&#x7f;BK&#x7f;BL&#x7f;BLD&#x7f;BLL&#x7f;BO&#x7f;BP&#x7f;BQL&#x7f;BR&#x7f;BT&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;BW&#x7f;BX&#x7f;BZ&#x7f;C0&#x7f;C1&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C2&#x7f;C20&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C38&#x7f;C39&#x7f;C4&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C5&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C6&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C75&#x7f;C76&#x7f;C77&#x7f;C78&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C98&#x7f;C99&#x7f;CA&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CH&#x7f;CJ&#x7f;CK&#x7f;CKG&#x7f;CL&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;CO&#x7f;COU&#x7f;CQ&#x7f;CR&#x7f;CS&#x7f;CT&#x7f;CTM&#x7f;CU&#x7f;CUR&#x7f;CV&#x7f;CWA&#x7f;CWI&#x7f;CY&#x7f;CZ&#x7f;D1&#x7f;D10&#x7f;D12&#x7f;D13&#x7f;D14&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D28&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D35&#x7f;D37&#x7f;D38&#x7f;D39&#x7f;D40&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D64&#x7f;D65&#x7f;D66&#x7f;D67&#x7f;D69&#x7f;D7&#x7f;D70&#x7f;D71&#x7f;D72&#x7f;D73&#x7f;D74&#x7f;D75&#x7f;D76&#x7f;D77&#x7f;D79&#x7f;D8&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D9&#x7f;D90&#x7f;D91&#x7f;D92&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;D96&#x7f;D97&#x7f;D98&#x7f;D99&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DC&#x7f;DD&#x7f;DE&#x7f;DEC&#x7f;DG&#x7f;DI&#x7f;DJ&#x7f;DLT&#x7f;DMK&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DQ&#x7f;DR&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DRM&#x7f;DS&#x7f;DT&#x7f;DTN&#x7f;DU&#x7f;DWT&#x7f;DX&#x7f;DY&#x7f;DZN&#x7f;DZP&#x7f;E2&#x7f;E3&#x7f;E4&#x7f;E5&#x7f;EA&#x7f;EB&#x7f;EC&#x7f;EP&#x7f;EQ&#x7f;EV&#x7f;F1&#x7f;F9&#x7f;FAH&#x7f;FAR&#x7f;FB&#x7f;FC&#x7f;FD&#x7f;FE&#x7f;FF&#x7f;FG&#x7f;FH&#x7f;FL&#x7f;FM&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G2&#x7f;G3&#x7f;G7&#x7f;GB&#x7f;GBQ&#x7f;GC&#x7f;GD&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GH&#x7f;GIA&#x7f;GII&#x7f;GJ&#x7f;GK&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GN&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GRT&#x7f;GT&#x7f;GV&#x7f;GW&#x7f;GWH&#x7f;GY&#x7f;GZ&#x7f;H1&#x7f;H2&#x7f;HA&#x7f;HAR&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HD&#x7f;HE&#x7f;HF&#x7f;HGM&#x7f;HH&#x7f;HI&#x7f;HIU&#x7f;HJ&#x7f;HK&#x7f;HL&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HN&#x7f;HO&#x7f;HP&#x7f;HPA&#x7f;HS&#x7f;HT&#x7f;HTZ&#x7f;HUR&#x7f;HY&#x7f;IA&#x7f;IC&#x7f;IE&#x7f;IF&#x7f;II&#x7f;IL&#x7f;IM&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;IP&#x7f;IT&#x7f;IU&#x7f;IV&#x7f;J2&#x7f;JB&#x7f;JE&#x7f;JG&#x7f;JK&#x7f;JM&#x7f;JO&#x7f;JOU&#x7f;JR&#x7f;K1&#x7f;K2&#x7f;K3&#x7f;K5&#x7f;K6&#x7f;KA&#x7f;KB&#x7f;KBA&#x7f;KD&#x7f;KEL&#x7f;KF&#x7f;KG&#x7f;KGM&#x7f;KGS&#x7f;KHZ&#x7f;KI&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KNI&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KS&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTM&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWT&#x7f;KX&#x7f;L2&#x7f;LA&#x7f;LBR&#x7f;LBT&#x7f;LC&#x7f;LD&#x7f;LE&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LI&#x7f;LJ&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUM&#x7f;LUX&#x7f;LX&#x7f;LY&#x7f;M0&#x7f;M1&#x7f;M4&#x7f;M5&#x7f;M7&#x7f;M9&#x7f;MA&#x7f;MAL&#x7f;MAM&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MF&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MK&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MON&#x7f;MPA&#x7f;MQ&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MT&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MV&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N2&#x7f;N3&#x7f;NA&#x7f;NAR&#x7f;NB&#x7f;NBB&#x7f;NC&#x7f;NCL&#x7f;ND&#x7f;NE&#x7f;NEW&#x7f;NF&#x7f;NG&#x7f;NH&#x7f;NI&#x7f;NIU&#x7f;NJ&#x7f;NL&#x7f;NMI&#x7f;NMP&#x7f;NN&#x7f;NPL&#x7f;NPR&#x7f;NPT&#x7f;NQ&#x7f;NR&#x7f;NRL&#x7f;NT&#x7f;NTT&#x7f;NU&#x7f;NV&#x7f;NX&#x7f;NY&#x7f;OA&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OP&#x7f;OT&#x7f;OZ&#x7f;OZA&#x7f;OZI&#x7f;P0&#x7f;P1&#x7f;P2&#x7f;P3&#x7f;P4&#x7f;P5&#x7f;P6&#x7f;P7&#x7f;P8&#x7f;P9&#x7f;PA&#x7f;PAL&#x7f;PB&#x7f;PD&#x7f;PE&#x7f;PF&#x7f;PG&#x7f;PGL&#x7f;PI&#x7f;PK&#x7f;PL&#x7f;PM&#x7f;PN&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PU&#x7f;PV&#x7f;PW&#x7f;PY&#x7f;PZ&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QD&#x7f;QH&#x7f;QK&#x7f;QR&#x7f;QT&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R4&#x7f;R9&#x7f;RA&#x7f;RD&#x7f;RG&#x7f;RH&#x7f;RK&#x7f;RL&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RS&#x7f;RT&#x7f;RU&#x7f;S3&#x7f;S4&#x7f;S5&#x7f;S6&#x7f;S7&#x7f;S8&#x7f;SA&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SD&#x7f;SE&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SHT&#x7f;SIE&#x7f;SK&#x7f;SL&#x7f;SMI&#x7f;SN&#x7f;SO&#x7f;SP&#x7f;SQ&#x7f;SR&#x7f;SS&#x7f;SST&#x7f;ST&#x7f;STI&#x7f;STN&#x7f;SV&#x7f;SW&#x7f;SX&#x7f;T0&#x7f;T1&#x7f;T3&#x7f;T4&#x7f;T5&#x7f;T6&#x7f;T7&#x7f;T8&#x7f;TA&#x7f;TAH&#x7f;TC&#x7f;TD&#x7f;TE&#x7f;TF&#x7f;TI&#x7f;TJ&#x7f;TK&#x7f;TL&#x7f;TN&#x7f;TNE&#x7f;TP&#x7f;TPR&#x7f;TQ&#x7f;TQD&#x7f;TR&#x7f;TRL&#x7f;TS&#x7f;TSD&#x7f;TSH&#x7f;TT&#x7f;TU&#x7f;TV&#x7f;TW&#x7f;TY&#x7f;U1&#x7f;U2&#x7f;UA&#x7f;UB&#x7f;UC&#x7f;UD&#x7f;UE&#x7f;UF&#x7f;UH&#x7f;UM&#x7f;VA&#x7f;VI&#x7f;VLT&#x7f;VQ&#x7f;VS&#x7f;W2&#x7f;W4&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WH&#x7f;WHR&#x7f;WI&#x7f;WM&#x7f;WR&#x7f;WSD&#x7f;WTT&#x7f;WW&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YL&#x7f;YRD&#x7f;YT&#x7f;Z1&#x7f;Z2&#x7f;Z3&#x7f;Z4&#x7f;Z5&#x7f;Z6&#x7f;Z8&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListID!='UN/ECE rec 20') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;05&#x7f;06&#x7f;08&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;53&#x7f;54&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;66&#x7f;69&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;76&#x7f;77&#x7f;78&#x7f;80&#x7f;81&#x7f;84&#x7f;85&#x7f;87&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;1A&#x7f;1B&#x7f;1C&#x7f;1D&#x7f;1E&#x7f;1F&#x7f;1G&#x7f;1H&#x7f;1I&#x7f;1J&#x7f;1K&#x7f;1L&#x7f;1M&#x7f;1X&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2V&#x7f;2W&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;3E&#x7f;3G&#x7f;3H&#x7f;3I&#x7f;4A&#x7f;4B&#x7f;4C&#x7f;4E&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5C&#x7f;5E&#x7f;5F&#x7f;5G&#x7f;5H&#x7f;5I&#x7f;5J&#x7f;5K&#x7f;5P&#x7f;5Q&#x7f;A1&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A25&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A50&#x7f;A51&#x7f;A52&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A57&#x7f;A58&#x7f;A59&#x7f;A6&#x7f;A60&#x7f;A61&#x7f;A62&#x7f;A63&#x7f;A64&#x7f;A65&#x7f;A66&#x7f;A67&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A77&#x7f;A78&#x7f;A79&#x7f;A8&#x7f;A80&#x7f;A81&#x7f;A82&#x7f;A83&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;AP&#x7f;APZ&#x7f;AQ&#x7f;AR&#x7f;ARE&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;ATT&#x7f;AV&#x7f;AW&#x7f;AY&#x7f;AZ&#x7f;B0&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B2&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B36&#x7f;B37&#x7f;B38&#x7f;B39&#x7f;B4&#x7f;B40&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B5&#x7f;B50&#x7f;B51&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B6&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B65&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B9&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BFT&#x7f;BG&#x7f;BH&#x7f;BHP&#x7f;BIL&#x7f;BJ&#x7f;BK&#x7f;BL&#x7f;BLD&#x7f;BLL&#x7f;BO&#x7f;BP&#x7f;BQL&#x7f;BR&#x7f;BT&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;BW&#x7f;BX&#x7f;BZ&#x7f;C0&#x7f;C1&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C2&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C4&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C5&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C6&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C77&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C98&#x7f;C99&#x7f;CA&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CH&#x7f;CJ&#x7f;CK&#x7f;CKG&#x7f;CL&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;CO&#x7f;COU&#x7f;CQ&#x7f;CR&#x7f;CS&#x7f;CT&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CU&#x7f;CUR&#x7f;CV&#x7f;CWA&#x7f;CWI&#x7f;CY&#x7f;CZ&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D14&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D28&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D35&#x7f;D36&#x7f;D37&#x7f;D38&#x7f;D39&#x7f;D40&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D64&#x7f;D65&#x7f;D66&#x7f;D67&#x7f;D68&#x7f;D69&#x7f;D7&#x7f;D70&#x7f;D71&#x7f;D72&#x7f;D73&#x7f;D74&#x7f;D75&#x7f;D76&#x7f;D77&#x7f;D78&#x7f;D79&#x7f;D8&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D9&#x7f;D90&#x7f;D91&#x7f;D92&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;D96&#x7f;D97&#x7f;D98&#x7f;D99&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DC&#x7f;DD&#x7f;DE&#x7f;DEC&#x7f;DG&#x7f;DI&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DQ&#x7f;DR&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DRM&#x7f;DS&#x7f;DT&#x7f;DTN&#x7f;DU&#x7f;DWT&#x7f;DX&#x7f;DY&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E11&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E2&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E3&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E5&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EC&#x7f;EP&#x7f;EQ&#x7f;EV&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F1&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F9&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FB&#x7f;FBM&#x7f;FC&#x7f;FD&#x7f;FE&#x7f;FF&#x7f;FG&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FM&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G7&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GC&#x7f;GD&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GH&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GK&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GN&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GRT&#x7f;GT&#x7f;GV&#x7f;GW&#x7f;GWH&#x7f;GY&#x7f;GZ&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H1&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H2&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H78&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HAR&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HD&#x7f;HDW&#x7f;HE&#x7f;HEA&#x7f;HF&#x7f;HGM&#x7f;HH&#x7f;HI&#x7f;HIU&#x7f;HJ&#x7f;HK&#x7f;HKM&#x7f;HL&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HN&#x7f;HO&#x7f;HP&#x7f;HPA&#x7f;HS&#x7f;HT&#x7f;HTZ&#x7f;HUR&#x7f;HY&#x7f;IA&#x7f;IC&#x7f;IE&#x7f;IF&#x7f;II&#x7f;IL&#x7f;IM&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;IP&#x7f;ISD&#x7f;IT&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J89&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J94&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JB&#x7f;JE&#x7f;JG&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JO&#x7f;JOU&#x7f;JPS&#x7f;JR&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K24&#x7f;K25&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K5&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KD&#x7f;KDW&#x7f;KEL&#x7f;KF&#x7f;KG&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KS&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTM&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWO&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L61&#x7f;L62&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LC&#x7f;LD&#x7f;LE&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LI&#x7f;LJ&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LX&#x7f;LY&#x7f;M0&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MA&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MF&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MK&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQ&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MT&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MV&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N2&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NB&#x7f;NBB&#x7f;NC&#x7f;NCL&#x7f;ND&#x7f;NE&#x7f;NEW&#x7f;NF&#x7f;NG&#x7f;NH&#x7f;NI&#x7f;NIL&#x7f;NIU&#x7f;NJ&#x7f;NL&#x7f;NMI&#x7f;NMP&#x7f;NN&#x7f;NPL&#x7f;NPR&#x7f;NPT&#x7f;NQ&#x7f;NR&#x7f;NRL&#x7f;NT&#x7f;NTT&#x7f;NU&#x7f;NV&#x7f;NX&#x7f;NY&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OP&#x7f;OT&#x7f;OZ&#x7f;OZA&#x7f;OZI&#x7f;P0&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P3&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P4&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P6&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P7&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P8&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P9&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PA&#x7f;PAL&#x7f;PB&#x7f;PD&#x7f;PE&#x7f;PF&#x7f;PFL&#x7f;PG&#x7f;PGL&#x7f;PI&#x7f;PK&#x7f;PL&#x7f;PLA&#x7f;PM&#x7f;PN&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PU&#x7f;PV&#x7f;PW&#x7f;PY&#x7f;PZ&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QD&#x7f;QH&#x7f;QK&#x7f;QR&#x7f;QT&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R4&#x7f;R9&#x7f;RA&#x7f;RD&#x7f;RG&#x7f;RH&#x7f;RK&#x7f;RL&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RS&#x7f;RT&#x7f;RU&#x7f;S3&#x7f;S4&#x7f;S5&#x7f;S6&#x7f;S7&#x7f;S8&#x7f;SA&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SD&#x7f;SE&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SHT&#x7f;SIE&#x7f;SK&#x7f;SL&#x7f;SMI&#x7f;SN&#x7f;SO&#x7f;SP&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;SS&#x7f;SST&#x7f;ST&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SV&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T1&#x7f;T3&#x7f;T4&#x7f;T5&#x7f;T6&#x7f;T7&#x7f;T8&#x7f;TA&#x7f;TAH&#x7f;TAN&#x7f;TC&#x7f;TD&#x7f;TE&#x7f;TF&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TJ&#x7f;TK&#x7f;TKM&#x7f;TL&#x7f;TMS&#x7f;TN&#x7f;TNE&#x7f;TP&#x7f;TPR&#x7f;TQ&#x7f;TQD&#x7f;TR&#x7f;TRL&#x7f;TS&#x7f;TSD&#x7f;TSH&#x7f;TST&#x7f;TT&#x7f;TTS&#x7f;TU&#x7f;TV&#x7f;TW&#x7f;TY&#x7f;U1&#x7f;U2&#x7f;UA&#x7f;UB&#x7f;UC&#x7f;UD&#x7f;UE&#x7f;UF&#x7f;UH&#x7f;UM&#x7f;VA&#x7f;VI&#x7f;VLT&#x7f;VP&#x7f;VQ&#x7f;VS&#x7f;W2&#x7f;W4&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WH&#x7f;WHR&#x7f;WI&#x7f;WM&#x7f;WR&#x7f;WSD&#x7f;WTT&#x7f;WW&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YL&#x7f;YRD&#x7f;YT&#x7f;Z1&#x7f;Z11&#x7f;Z2&#x7f;Z3&#x7f;Z4&#x7f;Z5&#x7f;Z6&#x7f;Z8&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListID!='UNECE Recommendation N°. 20 - Codes for Units of Measure Used in International Trade') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWO&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListID!='UNECE Recommendation N°. 20 - Codes for Units of Measure Used in International Trade') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWN&#x7f;KWO&#x7f;KWS&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q41&#x7f;Q42&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(../@unitCodeListID!='UNECE Recommendation N°. 20 - Codes for Units of Measure Used in International Trade') ) and ( not(../@unitCodeListAgencyName!='United Nations Economic Commission for Europe') ) and ( not(../@unitCodeListAgencyID!='6') ) and contains('&#x7f;10&#x7f;11&#x7f;13&#x7f;14&#x7f;15&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;27&#x7f;28&#x7f;33&#x7f;34&#x7f;35&#x7f;37&#x7f;38&#x7f;40&#x7f;41&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;74&#x7f;77&#x7f;80&#x7f;81&#x7f;85&#x7f;87&#x7f;89&#x7f;91&#x7f;1I&#x7f;2A&#x7f;2B&#x7f;2C&#x7f;2G&#x7f;2H&#x7f;2I&#x7f;2J&#x7f;2K&#x7f;2L&#x7f;2M&#x7f;2N&#x7f;2P&#x7f;2Q&#x7f;2R&#x7f;2U&#x7f;2X&#x7f;2Y&#x7f;2Z&#x7f;3B&#x7f;3C&#x7f;4C&#x7f;4G&#x7f;4H&#x7f;4K&#x7f;4L&#x7f;4M&#x7f;4N&#x7f;4O&#x7f;4P&#x7f;4Q&#x7f;4R&#x7f;4T&#x7f;4U&#x7f;4W&#x7f;4X&#x7f;5A&#x7f;5B&#x7f;5E&#x7f;5J&#x7f;A10&#x7f;A11&#x7f;A12&#x7f;A13&#x7f;A14&#x7f;A15&#x7f;A16&#x7f;A17&#x7f;A18&#x7f;A19&#x7f;A2&#x7f;A20&#x7f;A21&#x7f;A22&#x7f;A23&#x7f;A24&#x7f;A26&#x7f;A27&#x7f;A28&#x7f;A29&#x7f;A3&#x7f;A30&#x7f;A31&#x7f;A32&#x7f;A33&#x7f;A34&#x7f;A35&#x7f;A36&#x7f;A37&#x7f;A38&#x7f;A39&#x7f;A4&#x7f;A40&#x7f;A41&#x7f;A42&#x7f;A43&#x7f;A44&#x7f;A45&#x7f;A47&#x7f;A48&#x7f;A49&#x7f;A5&#x7f;A53&#x7f;A54&#x7f;A55&#x7f;A56&#x7f;A59&#x7f;A6&#x7f;A68&#x7f;A69&#x7f;A7&#x7f;A70&#x7f;A71&#x7f;A73&#x7f;A74&#x7f;A75&#x7f;A76&#x7f;A8&#x7f;A84&#x7f;A85&#x7f;A86&#x7f;A87&#x7f;A88&#x7f;A89&#x7f;A9&#x7f;A90&#x7f;A91&#x7f;A93&#x7f;A94&#x7f;A95&#x7f;A96&#x7f;A97&#x7f;A98&#x7f;A99&#x7f;AA&#x7f;AB&#x7f;ACR&#x7f;ACT&#x7f;AD&#x7f;AE&#x7f;AH&#x7f;AI&#x7f;AK&#x7f;AL&#x7f;AMH&#x7f;AMP&#x7f;ANN&#x7f;APZ&#x7f;AQ&#x7f;AS&#x7f;ASM&#x7f;ASU&#x7f;ATM&#x7f;AWG&#x7f;AY&#x7f;AZ&#x7f;B1&#x7f;B10&#x7f;B11&#x7f;B12&#x7f;B13&#x7f;B14&#x7f;B15&#x7f;B16&#x7f;B17&#x7f;B18&#x7f;B19&#x7f;B20&#x7f;B21&#x7f;B22&#x7f;B23&#x7f;B24&#x7f;B25&#x7f;B26&#x7f;B27&#x7f;B28&#x7f;B29&#x7f;B3&#x7f;B30&#x7f;B31&#x7f;B32&#x7f;B33&#x7f;B34&#x7f;B35&#x7f;B4&#x7f;B41&#x7f;B42&#x7f;B43&#x7f;B44&#x7f;B45&#x7f;B46&#x7f;B47&#x7f;B48&#x7f;B49&#x7f;B50&#x7f;B52&#x7f;B53&#x7f;B54&#x7f;B55&#x7f;B56&#x7f;B57&#x7f;B58&#x7f;B59&#x7f;B60&#x7f;B61&#x7f;B62&#x7f;B63&#x7f;B64&#x7f;B66&#x7f;B67&#x7f;B68&#x7f;B69&#x7f;B7&#x7f;B70&#x7f;B71&#x7f;B72&#x7f;B73&#x7f;B74&#x7f;B75&#x7f;B76&#x7f;B77&#x7f;B78&#x7f;B79&#x7f;B8&#x7f;B80&#x7f;B81&#x7f;B82&#x7f;B83&#x7f;B84&#x7f;B85&#x7f;B86&#x7f;B87&#x7f;B88&#x7f;B89&#x7f;B90&#x7f;B91&#x7f;B92&#x7f;B93&#x7f;B94&#x7f;B95&#x7f;B96&#x7f;B97&#x7f;B98&#x7f;B99&#x7f;BAR&#x7f;BB&#x7f;BFT&#x7f;BHP&#x7f;BIL&#x7f;BLD&#x7f;BLL&#x7f;BP&#x7f;BPM&#x7f;BQL&#x7f;BTU&#x7f;BUA&#x7f;BUI&#x7f;C0&#x7f;C10&#x7f;C11&#x7f;C12&#x7f;C13&#x7f;C14&#x7f;C15&#x7f;C16&#x7f;C17&#x7f;C18&#x7f;C19&#x7f;C20&#x7f;C21&#x7f;C22&#x7f;C23&#x7f;C24&#x7f;C25&#x7f;C26&#x7f;C27&#x7f;C28&#x7f;C29&#x7f;C3&#x7f;C30&#x7f;C31&#x7f;C32&#x7f;C33&#x7f;C34&#x7f;C35&#x7f;C36&#x7f;C37&#x7f;C38&#x7f;C39&#x7f;C40&#x7f;C41&#x7f;C42&#x7f;C43&#x7f;C44&#x7f;C45&#x7f;C46&#x7f;C47&#x7f;C48&#x7f;C49&#x7f;C50&#x7f;C51&#x7f;C52&#x7f;C53&#x7f;C54&#x7f;C55&#x7f;C56&#x7f;C57&#x7f;C58&#x7f;C59&#x7f;C60&#x7f;C61&#x7f;C62&#x7f;C63&#x7f;C64&#x7f;C65&#x7f;C66&#x7f;C67&#x7f;C68&#x7f;C69&#x7f;C7&#x7f;C70&#x7f;C71&#x7f;C72&#x7f;C73&#x7f;C74&#x7f;C75&#x7f;C76&#x7f;C78&#x7f;C79&#x7f;C8&#x7f;C80&#x7f;C81&#x7f;C82&#x7f;C83&#x7f;C84&#x7f;C85&#x7f;C86&#x7f;C87&#x7f;C88&#x7f;C89&#x7f;C9&#x7f;C90&#x7f;C91&#x7f;C92&#x7f;C93&#x7f;C94&#x7f;C95&#x7f;C96&#x7f;C97&#x7f;C99&#x7f;CCT&#x7f;CDL&#x7f;CEL&#x7f;CEN&#x7f;CG&#x7f;CGM&#x7f;CKG&#x7f;CLF&#x7f;CLT&#x7f;CMK&#x7f;CMQ&#x7f;CMT&#x7f;CNP&#x7f;CNT&#x7f;COU&#x7f;CTG&#x7f;CTM&#x7f;CTN&#x7f;CUR&#x7f;CWA&#x7f;CWI&#x7f;D03&#x7f;D04&#x7f;D1&#x7f;D10&#x7f;D11&#x7f;D12&#x7f;D13&#x7f;D15&#x7f;D16&#x7f;D17&#x7f;D18&#x7f;D19&#x7f;D2&#x7f;D20&#x7f;D21&#x7f;D22&#x7f;D23&#x7f;D24&#x7f;D25&#x7f;D26&#x7f;D27&#x7f;D29&#x7f;D30&#x7f;D31&#x7f;D32&#x7f;D33&#x7f;D34&#x7f;D36&#x7f;D41&#x7f;D42&#x7f;D43&#x7f;D44&#x7f;D45&#x7f;D46&#x7f;D47&#x7f;D48&#x7f;D49&#x7f;D5&#x7f;D50&#x7f;D51&#x7f;D52&#x7f;D53&#x7f;D54&#x7f;D55&#x7f;D56&#x7f;D57&#x7f;D58&#x7f;D59&#x7f;D6&#x7f;D60&#x7f;D61&#x7f;D62&#x7f;D63&#x7f;D65&#x7f;D68&#x7f;D69&#x7f;D73&#x7f;D74&#x7f;D77&#x7f;D78&#x7f;D80&#x7f;D81&#x7f;D82&#x7f;D83&#x7f;D85&#x7f;D86&#x7f;D87&#x7f;D88&#x7f;D89&#x7f;D91&#x7f;D93&#x7f;D94&#x7f;D95&#x7f;DAA&#x7f;DAD&#x7f;DAY&#x7f;DB&#x7f;DD&#x7f;DEC&#x7f;DG&#x7f;DJ&#x7f;DLT&#x7f;DMA&#x7f;DMK&#x7f;DMO&#x7f;DMQ&#x7f;DMT&#x7f;DN&#x7f;DPC&#x7f;DPR&#x7f;DPT&#x7f;DRA&#x7f;DRI&#x7f;DRL&#x7f;DT&#x7f;DTN&#x7f;DWT&#x7f;DZN&#x7f;DZP&#x7f;E01&#x7f;E07&#x7f;E08&#x7f;E09&#x7f;E10&#x7f;E12&#x7f;E14&#x7f;E15&#x7f;E16&#x7f;E17&#x7f;E18&#x7f;E19&#x7f;E20&#x7f;E21&#x7f;E22&#x7f;E23&#x7f;E25&#x7f;E27&#x7f;E28&#x7f;E30&#x7f;E31&#x7f;E32&#x7f;E33&#x7f;E34&#x7f;E35&#x7f;E36&#x7f;E37&#x7f;E38&#x7f;E39&#x7f;E4&#x7f;E40&#x7f;E41&#x7f;E42&#x7f;E43&#x7f;E44&#x7f;E45&#x7f;E46&#x7f;E47&#x7f;E48&#x7f;E49&#x7f;E50&#x7f;E51&#x7f;E52&#x7f;E53&#x7f;E54&#x7f;E55&#x7f;E56&#x7f;E57&#x7f;E58&#x7f;E59&#x7f;E60&#x7f;E61&#x7f;E62&#x7f;E63&#x7f;E64&#x7f;E65&#x7f;E66&#x7f;E67&#x7f;E68&#x7f;E69&#x7f;E70&#x7f;E71&#x7f;E72&#x7f;E73&#x7f;E74&#x7f;E75&#x7f;E76&#x7f;E77&#x7f;E78&#x7f;E79&#x7f;E80&#x7f;E81&#x7f;E82&#x7f;E83&#x7f;E84&#x7f;E85&#x7f;E86&#x7f;E87&#x7f;E88&#x7f;E89&#x7f;E90&#x7f;E91&#x7f;E92&#x7f;E93&#x7f;E94&#x7f;E95&#x7f;E96&#x7f;E97&#x7f;E98&#x7f;E99&#x7f;EA&#x7f;EB&#x7f;EQ&#x7f;F01&#x7f;F02&#x7f;F03&#x7f;F04&#x7f;F05&#x7f;F06&#x7f;F07&#x7f;F08&#x7f;F10&#x7f;F11&#x7f;F12&#x7f;F13&#x7f;F14&#x7f;F15&#x7f;F16&#x7f;F17&#x7f;F18&#x7f;F19&#x7f;F20&#x7f;F21&#x7f;F22&#x7f;F23&#x7f;F24&#x7f;F25&#x7f;F26&#x7f;F27&#x7f;F28&#x7f;F29&#x7f;F30&#x7f;F31&#x7f;F32&#x7f;F33&#x7f;F34&#x7f;F35&#x7f;F36&#x7f;F37&#x7f;F38&#x7f;F39&#x7f;F40&#x7f;F41&#x7f;F42&#x7f;F43&#x7f;F44&#x7f;F45&#x7f;F46&#x7f;F47&#x7f;F48&#x7f;F49&#x7f;F50&#x7f;F51&#x7f;F52&#x7f;F53&#x7f;F54&#x7f;F55&#x7f;F56&#x7f;F57&#x7f;F58&#x7f;F59&#x7f;F60&#x7f;F61&#x7f;F62&#x7f;F63&#x7f;F64&#x7f;F65&#x7f;F66&#x7f;F67&#x7f;F68&#x7f;F69&#x7f;F70&#x7f;F71&#x7f;F72&#x7f;F73&#x7f;F74&#x7f;F75&#x7f;F76&#x7f;F77&#x7f;F78&#x7f;F79&#x7f;F80&#x7f;F81&#x7f;F82&#x7f;F83&#x7f;F84&#x7f;F85&#x7f;F86&#x7f;F87&#x7f;F88&#x7f;F89&#x7f;F90&#x7f;F91&#x7f;F92&#x7f;F93&#x7f;F94&#x7f;F95&#x7f;F96&#x7f;F97&#x7f;F98&#x7f;F99&#x7f;FAH&#x7f;FAR&#x7f;FBM&#x7f;FC&#x7f;FF&#x7f;FH&#x7f;FIT&#x7f;FL&#x7f;FOT&#x7f;FP&#x7f;FR&#x7f;FS&#x7f;FTK&#x7f;FTQ&#x7f;G01&#x7f;G04&#x7f;G05&#x7f;G06&#x7f;G08&#x7f;G09&#x7f;G10&#x7f;G11&#x7f;G12&#x7f;G13&#x7f;G14&#x7f;G15&#x7f;G16&#x7f;G17&#x7f;G18&#x7f;G19&#x7f;G2&#x7f;G20&#x7f;G21&#x7f;G23&#x7f;G24&#x7f;G25&#x7f;G26&#x7f;G27&#x7f;G28&#x7f;G29&#x7f;G3&#x7f;G30&#x7f;G31&#x7f;G32&#x7f;G33&#x7f;G34&#x7f;G35&#x7f;G36&#x7f;G37&#x7f;G38&#x7f;G39&#x7f;G40&#x7f;G41&#x7f;G42&#x7f;G43&#x7f;G44&#x7f;G45&#x7f;G46&#x7f;G47&#x7f;G48&#x7f;G49&#x7f;G50&#x7f;G51&#x7f;G52&#x7f;G53&#x7f;G54&#x7f;G55&#x7f;G56&#x7f;G57&#x7f;G58&#x7f;G59&#x7f;G60&#x7f;G61&#x7f;G62&#x7f;G63&#x7f;G64&#x7f;G65&#x7f;G66&#x7f;G67&#x7f;G68&#x7f;G69&#x7f;G70&#x7f;G71&#x7f;G72&#x7f;G73&#x7f;G74&#x7f;G75&#x7f;G76&#x7f;G77&#x7f;G78&#x7f;G79&#x7f;G80&#x7f;G81&#x7f;G82&#x7f;G83&#x7f;G84&#x7f;G85&#x7f;G86&#x7f;G87&#x7f;G88&#x7f;G89&#x7f;G90&#x7f;G91&#x7f;G92&#x7f;G93&#x7f;G94&#x7f;G95&#x7f;G96&#x7f;G97&#x7f;G98&#x7f;G99&#x7f;GB&#x7f;GBQ&#x7f;GDW&#x7f;GE&#x7f;GF&#x7f;GFI&#x7f;GGR&#x7f;GIA&#x7f;GIC&#x7f;GII&#x7f;GIP&#x7f;GJ&#x7f;GL&#x7f;GLD&#x7f;GLI&#x7f;GLL&#x7f;GM&#x7f;GO&#x7f;GP&#x7f;GQ&#x7f;GRM&#x7f;GRN&#x7f;GRO&#x7f;GV&#x7f;GWH&#x7f;H03&#x7f;H04&#x7f;H05&#x7f;H06&#x7f;H07&#x7f;H08&#x7f;H09&#x7f;H10&#x7f;H11&#x7f;H12&#x7f;H13&#x7f;H14&#x7f;H15&#x7f;H16&#x7f;H18&#x7f;H19&#x7f;H20&#x7f;H21&#x7f;H22&#x7f;H23&#x7f;H24&#x7f;H25&#x7f;H26&#x7f;H27&#x7f;H28&#x7f;H29&#x7f;H30&#x7f;H31&#x7f;H32&#x7f;H33&#x7f;H34&#x7f;H35&#x7f;H36&#x7f;H37&#x7f;H38&#x7f;H39&#x7f;H40&#x7f;H41&#x7f;H42&#x7f;H43&#x7f;H44&#x7f;H45&#x7f;H46&#x7f;H47&#x7f;H48&#x7f;H49&#x7f;H50&#x7f;H51&#x7f;H52&#x7f;H53&#x7f;H54&#x7f;H55&#x7f;H56&#x7f;H57&#x7f;H58&#x7f;H59&#x7f;H60&#x7f;H61&#x7f;H62&#x7f;H63&#x7f;H64&#x7f;H65&#x7f;H66&#x7f;H67&#x7f;H68&#x7f;H69&#x7f;H70&#x7f;H71&#x7f;H72&#x7f;H73&#x7f;H74&#x7f;H75&#x7f;H76&#x7f;H77&#x7f;H79&#x7f;H80&#x7f;H81&#x7f;H82&#x7f;H83&#x7f;H84&#x7f;H85&#x7f;H87&#x7f;H88&#x7f;H89&#x7f;H90&#x7f;H91&#x7f;H92&#x7f;H93&#x7f;H94&#x7f;H95&#x7f;H96&#x7f;H98&#x7f;H99&#x7f;HA&#x7f;HBA&#x7f;HBX&#x7f;HC&#x7f;HDW&#x7f;HEA&#x7f;HGM&#x7f;HH&#x7f;HIU&#x7f;HKM&#x7f;HLT&#x7f;HM&#x7f;HMQ&#x7f;HMT&#x7f;HPA&#x7f;HTZ&#x7f;HUR&#x7f;IA&#x7f;IE&#x7f;INH&#x7f;INK&#x7f;INQ&#x7f;ISD&#x7f;IU&#x7f;IV&#x7f;J10&#x7f;J12&#x7f;J13&#x7f;J14&#x7f;J15&#x7f;J16&#x7f;J17&#x7f;J18&#x7f;J19&#x7f;J2&#x7f;J20&#x7f;J21&#x7f;J22&#x7f;J23&#x7f;J24&#x7f;J25&#x7f;J26&#x7f;J27&#x7f;J28&#x7f;J29&#x7f;J30&#x7f;J31&#x7f;J32&#x7f;J33&#x7f;J34&#x7f;J35&#x7f;J36&#x7f;J38&#x7f;J39&#x7f;J40&#x7f;J41&#x7f;J42&#x7f;J43&#x7f;J44&#x7f;J45&#x7f;J46&#x7f;J47&#x7f;J48&#x7f;J49&#x7f;J50&#x7f;J51&#x7f;J52&#x7f;J53&#x7f;J54&#x7f;J55&#x7f;J56&#x7f;J57&#x7f;J58&#x7f;J59&#x7f;J60&#x7f;J61&#x7f;J62&#x7f;J63&#x7f;J64&#x7f;J65&#x7f;J66&#x7f;J67&#x7f;J68&#x7f;J69&#x7f;J70&#x7f;J71&#x7f;J72&#x7f;J73&#x7f;J74&#x7f;J75&#x7f;J76&#x7f;J78&#x7f;J79&#x7f;J81&#x7f;J82&#x7f;J83&#x7f;J84&#x7f;J85&#x7f;J87&#x7f;J90&#x7f;J91&#x7f;J92&#x7f;J93&#x7f;J95&#x7f;J96&#x7f;J97&#x7f;J98&#x7f;J99&#x7f;JE&#x7f;JK&#x7f;JM&#x7f;JNT&#x7f;JOU&#x7f;JPS&#x7f;JWL&#x7f;K1&#x7f;K10&#x7f;K11&#x7f;K12&#x7f;K13&#x7f;K14&#x7f;K15&#x7f;K16&#x7f;K17&#x7f;K18&#x7f;K19&#x7f;K2&#x7f;K20&#x7f;K21&#x7f;K22&#x7f;K23&#x7f;K26&#x7f;K27&#x7f;K28&#x7f;K3&#x7f;K30&#x7f;K31&#x7f;K32&#x7f;K33&#x7f;K34&#x7f;K35&#x7f;K36&#x7f;K37&#x7f;K38&#x7f;K39&#x7f;K40&#x7f;K41&#x7f;K42&#x7f;K43&#x7f;K45&#x7f;K46&#x7f;K47&#x7f;K48&#x7f;K49&#x7f;K50&#x7f;K51&#x7f;K52&#x7f;K53&#x7f;K54&#x7f;K55&#x7f;K58&#x7f;K59&#x7f;K6&#x7f;K60&#x7f;K61&#x7f;K62&#x7f;K63&#x7f;K64&#x7f;K65&#x7f;K66&#x7f;K67&#x7f;K68&#x7f;K69&#x7f;K70&#x7f;K71&#x7f;K73&#x7f;K74&#x7f;K75&#x7f;K76&#x7f;K77&#x7f;K78&#x7f;K79&#x7f;K80&#x7f;K81&#x7f;K82&#x7f;K83&#x7f;K84&#x7f;K85&#x7f;K86&#x7f;K87&#x7f;K88&#x7f;K89&#x7f;K90&#x7f;K91&#x7f;K92&#x7f;K93&#x7f;K94&#x7f;K95&#x7f;K96&#x7f;K97&#x7f;K98&#x7f;K99&#x7f;KA&#x7f;KAT&#x7f;KB&#x7f;KBA&#x7f;KCC&#x7f;KDW&#x7f;KEL&#x7f;KGM&#x7f;KGS&#x7f;KHY&#x7f;KHZ&#x7f;KI&#x7f;KIC&#x7f;KIP&#x7f;KJ&#x7f;KJO&#x7f;KL&#x7f;KLK&#x7f;KLX&#x7f;KMA&#x7f;KMH&#x7f;KMK&#x7f;KMQ&#x7f;KMT&#x7f;KNI&#x7f;KNM&#x7f;KNS&#x7f;KNT&#x7f;KO&#x7f;KPA&#x7f;KPH&#x7f;KPO&#x7f;KPP&#x7f;KR&#x7f;KSD&#x7f;KSH&#x7f;KT&#x7f;KTN&#x7f;KUR&#x7f;KVA&#x7f;KVR&#x7f;KVT&#x7f;KW&#x7f;KWH&#x7f;KWN&#x7f;KWO&#x7f;KWS&#x7f;KWT&#x7f;KX&#x7f;L10&#x7f;L11&#x7f;L12&#x7f;L13&#x7f;L14&#x7f;L15&#x7f;L16&#x7f;L17&#x7f;L18&#x7f;L19&#x7f;L2&#x7f;L20&#x7f;L21&#x7f;L23&#x7f;L24&#x7f;L25&#x7f;L26&#x7f;L27&#x7f;L28&#x7f;L29&#x7f;L30&#x7f;L31&#x7f;L32&#x7f;L33&#x7f;L34&#x7f;L35&#x7f;L36&#x7f;L37&#x7f;L38&#x7f;L39&#x7f;L40&#x7f;L41&#x7f;L42&#x7f;L43&#x7f;L44&#x7f;L45&#x7f;L46&#x7f;L47&#x7f;L48&#x7f;L49&#x7f;L50&#x7f;L51&#x7f;L52&#x7f;L53&#x7f;L54&#x7f;L55&#x7f;L56&#x7f;L57&#x7f;L58&#x7f;L59&#x7f;L60&#x7f;L63&#x7f;L64&#x7f;L65&#x7f;L66&#x7f;L67&#x7f;L68&#x7f;L69&#x7f;L70&#x7f;L71&#x7f;L72&#x7f;L73&#x7f;L74&#x7f;L75&#x7f;L76&#x7f;L77&#x7f;L78&#x7f;L79&#x7f;L80&#x7f;L81&#x7f;L82&#x7f;L83&#x7f;L84&#x7f;L85&#x7f;L86&#x7f;L87&#x7f;L88&#x7f;L89&#x7f;L90&#x7f;L91&#x7f;L92&#x7f;L93&#x7f;L94&#x7f;L95&#x7f;L96&#x7f;L98&#x7f;L99&#x7f;LA&#x7f;LAC&#x7f;LBR&#x7f;LBT&#x7f;LD&#x7f;LEF&#x7f;LF&#x7f;LH&#x7f;LK&#x7f;LM&#x7f;LN&#x7f;LO&#x7f;LP&#x7f;LPA&#x7f;LR&#x7f;LS&#x7f;LTN&#x7f;LTR&#x7f;LUB&#x7f;LUM&#x7f;LUX&#x7f;LY&#x7f;M1&#x7f;M10&#x7f;M11&#x7f;M12&#x7f;M13&#x7f;M14&#x7f;M15&#x7f;M16&#x7f;M17&#x7f;M18&#x7f;M19&#x7f;M20&#x7f;M21&#x7f;M22&#x7f;M23&#x7f;M24&#x7f;M25&#x7f;M26&#x7f;M27&#x7f;M29&#x7f;M30&#x7f;M31&#x7f;M32&#x7f;M33&#x7f;M34&#x7f;M35&#x7f;M36&#x7f;M37&#x7f;M38&#x7f;M39&#x7f;M4&#x7f;M40&#x7f;M41&#x7f;M42&#x7f;M43&#x7f;M44&#x7f;M45&#x7f;M46&#x7f;M47&#x7f;M48&#x7f;M49&#x7f;M5&#x7f;M50&#x7f;M51&#x7f;M52&#x7f;M53&#x7f;M55&#x7f;M56&#x7f;M57&#x7f;M58&#x7f;M59&#x7f;M60&#x7f;M61&#x7f;M62&#x7f;M63&#x7f;M64&#x7f;M65&#x7f;M66&#x7f;M67&#x7f;M68&#x7f;M69&#x7f;M7&#x7f;M70&#x7f;M71&#x7f;M72&#x7f;M73&#x7f;M74&#x7f;M75&#x7f;M76&#x7f;M77&#x7f;M78&#x7f;M79&#x7f;M80&#x7f;M81&#x7f;M82&#x7f;M83&#x7f;M84&#x7f;M85&#x7f;M86&#x7f;M87&#x7f;M88&#x7f;M89&#x7f;M9&#x7f;M90&#x7f;M91&#x7f;M92&#x7f;M93&#x7f;M94&#x7f;M95&#x7f;M96&#x7f;M97&#x7f;M98&#x7f;M99&#x7f;MAH&#x7f;MAL&#x7f;MAM&#x7f;MAR&#x7f;MAW&#x7f;MBE&#x7f;MBF&#x7f;MBR&#x7f;MC&#x7f;MCU&#x7f;MD&#x7f;MGM&#x7f;MHZ&#x7f;MIK&#x7f;MIL&#x7f;MIN&#x7f;MIO&#x7f;MIU&#x7f;MLD&#x7f;MLT&#x7f;MMK&#x7f;MMQ&#x7f;MMT&#x7f;MND&#x7f;MON&#x7f;MPA&#x7f;MQH&#x7f;MQS&#x7f;MSK&#x7f;MTK&#x7f;MTQ&#x7f;MTR&#x7f;MTS&#x7f;MVA&#x7f;MWH&#x7f;N1&#x7f;N10&#x7f;N11&#x7f;N12&#x7f;N13&#x7f;N14&#x7f;N15&#x7f;N16&#x7f;N17&#x7f;N18&#x7f;N19&#x7f;N20&#x7f;N21&#x7f;N22&#x7f;N23&#x7f;N24&#x7f;N25&#x7f;N26&#x7f;N27&#x7f;N28&#x7f;N29&#x7f;N3&#x7f;N30&#x7f;N31&#x7f;N32&#x7f;N33&#x7f;N34&#x7f;N35&#x7f;N36&#x7f;N37&#x7f;N38&#x7f;N39&#x7f;N40&#x7f;N41&#x7f;N42&#x7f;N43&#x7f;N44&#x7f;N45&#x7f;N46&#x7f;N47&#x7f;N48&#x7f;N49&#x7f;N50&#x7f;N51&#x7f;N52&#x7f;N53&#x7f;N54&#x7f;N55&#x7f;N56&#x7f;N57&#x7f;N58&#x7f;N59&#x7f;N60&#x7f;N61&#x7f;N62&#x7f;N63&#x7f;N64&#x7f;N65&#x7f;N66&#x7f;N67&#x7f;N68&#x7f;N69&#x7f;N70&#x7f;N71&#x7f;N72&#x7f;N73&#x7f;N74&#x7f;N75&#x7f;N76&#x7f;N77&#x7f;N78&#x7f;N79&#x7f;N80&#x7f;N81&#x7f;N82&#x7f;N83&#x7f;N84&#x7f;N85&#x7f;N86&#x7f;N87&#x7f;N88&#x7f;N89&#x7f;N90&#x7f;N91&#x7f;N92&#x7f;N93&#x7f;N94&#x7f;N95&#x7f;N96&#x7f;N97&#x7f;N98&#x7f;N99&#x7f;NA&#x7f;NAR&#x7f;NCL&#x7f;NEW&#x7f;NF&#x7f;NIL&#x7f;NIU&#x7f;NL&#x7f;NM3&#x7f;NMI&#x7f;NMP&#x7f;NPT&#x7f;NT&#x7f;NU&#x7f;NX&#x7f;OA&#x7f;ODE&#x7f;OHM&#x7f;ON&#x7f;ONZ&#x7f;OPM&#x7f;OT&#x7f;OZA&#x7f;OZI&#x7f;P1&#x7f;P10&#x7f;P11&#x7f;P12&#x7f;P13&#x7f;P14&#x7f;P15&#x7f;P16&#x7f;P17&#x7f;P18&#x7f;P19&#x7f;P2&#x7f;P20&#x7f;P21&#x7f;P22&#x7f;P23&#x7f;P24&#x7f;P25&#x7f;P26&#x7f;P27&#x7f;P28&#x7f;P29&#x7f;P30&#x7f;P31&#x7f;P32&#x7f;P33&#x7f;P34&#x7f;P35&#x7f;P36&#x7f;P37&#x7f;P38&#x7f;P39&#x7f;P40&#x7f;P41&#x7f;P42&#x7f;P43&#x7f;P44&#x7f;P45&#x7f;P46&#x7f;P47&#x7f;P48&#x7f;P49&#x7f;P5&#x7f;P50&#x7f;P51&#x7f;P52&#x7f;P53&#x7f;P54&#x7f;P55&#x7f;P56&#x7f;P57&#x7f;P58&#x7f;P59&#x7f;P60&#x7f;P61&#x7f;P62&#x7f;P63&#x7f;P64&#x7f;P65&#x7f;P66&#x7f;P67&#x7f;P68&#x7f;P69&#x7f;P70&#x7f;P71&#x7f;P72&#x7f;P73&#x7f;P74&#x7f;P75&#x7f;P76&#x7f;P77&#x7f;P78&#x7f;P79&#x7f;P80&#x7f;P81&#x7f;P82&#x7f;P83&#x7f;P84&#x7f;P85&#x7f;P86&#x7f;P87&#x7f;P88&#x7f;P89&#x7f;P90&#x7f;P91&#x7f;P92&#x7f;P93&#x7f;P94&#x7f;P95&#x7f;P96&#x7f;P97&#x7f;P98&#x7f;P99&#x7f;PAL&#x7f;PD&#x7f;PFL&#x7f;PGL&#x7f;PI&#x7f;PLA&#x7f;PO&#x7f;PQ&#x7f;PR&#x7f;PS&#x7f;PTD&#x7f;PTI&#x7f;PTL&#x7f;PTN&#x7f;Q10&#x7f;Q11&#x7f;Q12&#x7f;Q13&#x7f;Q14&#x7f;Q15&#x7f;Q16&#x7f;Q17&#x7f;Q18&#x7f;Q19&#x7f;Q20&#x7f;Q21&#x7f;Q22&#x7f;Q23&#x7f;Q24&#x7f;Q25&#x7f;Q26&#x7f;Q27&#x7f;Q28&#x7f;Q29&#x7f;Q30&#x7f;Q31&#x7f;Q32&#x7f;Q33&#x7f;Q34&#x7f;Q35&#x7f;Q36&#x7f;Q37&#x7f;Q38&#x7f;Q39&#x7f;Q40&#x7f;Q41&#x7f;Q42&#x7f;Q3&#x7f;QA&#x7f;QAN&#x7f;QB&#x7f;QR&#x7f;QTD&#x7f;QTI&#x7f;QTL&#x7f;QTR&#x7f;R1&#x7f;R9&#x7f;RH&#x7f;RM&#x7f;ROM&#x7f;RP&#x7f;RPM&#x7f;RPS&#x7f;RT&#x7f;S3&#x7f;S4&#x7f;SAN&#x7f;SCO&#x7f;SCR&#x7f;SEC&#x7f;SET&#x7f;SG&#x7f;SIE&#x7f;SM3&#x7f;SMI&#x7f;SQ&#x7f;SQR&#x7f;SR&#x7f;STC&#x7f;STI&#x7f;STK&#x7f;STL&#x7f;STN&#x7f;STW&#x7f;SW&#x7f;SX&#x7f;SYR&#x7f;T0&#x7f;T3&#x7f;TAH&#x7f;TAN&#x7f;TI&#x7f;TIC&#x7f;TIP&#x7f;TKM&#x7f;TMS&#x7f;TNE&#x7f;TP&#x7f;TPI&#x7f;TPR&#x7f;TQD&#x7f;TRL&#x7f;TST&#x7f;TTS&#x7f;U1&#x7f;U2&#x7f;UB&#x7f;UC&#x7f;VA&#x7f;VLT&#x7f;VP&#x7f;W2&#x7f;WA&#x7f;WB&#x7f;WCD&#x7f;WE&#x7f;WEB&#x7f;WEE&#x7f;WG&#x7f;WHR&#x7f;WM&#x7f;WSD&#x7f;WTT&#x7f;X1&#x7f;YDK&#x7f;YDQ&#x7f;YRD&#x7f;Z11&#x7f;ZP&#x7f;ZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'UnitOfMeasure-2.0 UnitOfMeasure-2.1 UnitOfMeasure-2.2 UnitOfMeasure-2.3 UnitOfMeasure-2.4' in the context 'cbc:ActualTemperatureReductionQuantity/@unitCode | cbc:BackorderQuantity/@unitCode | cbc:BaseQuantity/@unitCode | cbc:BasicConsumedQuantity/@unitCode | cbc:BatchQuantity/@unitCode | cbc:ChargeableQuantity/@unitCode | cbc:ChildConsignmentQuantity/@unitCode | cbc:ConsignmentQuantity/@unitCode | cbc:ConsumerUnitQuantity/@unitCode | cbc:ConsumptionEnergyQuantity/@unitCode | cbc:ConsumptionWaterQuantity/@unitCode | cbc:ContentUnitQuantity/@unitCode | cbc:CreditedQuantity/@unitCode | cbc:CrewQuantity/@unitCode | cbc:CustomsTariffQuantity/@unitCode | cbc:DebitedQuantity/@unitCode | cbc:DeliveredQuantity/@unitCode | cbc:DifferenceTemperatureReductionQuantity/@unitCode | cbc:EmployeeQuantity/@unitCode | cbc:EstimatedConsumedQuantity/@unitCode | cbc:EstimatedOverallContractQuantity/@unitCode | cbc:ExpectedOperatorQuantity/@unitCode | cbc:ExpectedQuantity/@unitCode | cbc:GasPressureQuantity/@unitCode | cbc:InvoicedQuantity/@unitCode | cbc:LatestMeterQuantity/@unitCode | cbc:MaximumBackorderQuantity/@unitCode | cbc:MaximumOperatorQuantity/@unitCode | cbc:MaximumOrderQuantity/@unitCode | cbc:MaximumQuantity/@unitCode | cbc:MaximumVariantQuantity/@unitCode | cbc:MinimumBackorderQuantity/@unitCode | cbc:MinimumInventoryQuantity/@unitCode | cbc:MinimumOrderQuantity/@unitCode | cbc:MinimumQuantity/@unitCode | cbc:MultipleOrderQuantity/@unitCode | cbc:NormalTemperatureReductionQuantity/@unitCode | cbc:OperatingYearsQuantity/@unitCode | cbc:OutstandingQuantity/@unitCode | cbc:OversupplyQuantity/@unitCode | cbc:PackQuantity/@unitCode | cbc:PassengerQuantity/@unitCode | cbc:PerformanceValueQuantity/@unitCode | cbc:PreviousMeterQuantity/@unitCode | cbc:Quantity/@unitCode | cbc:ReceivedElectronicTenderQuantity/@unitCode | cbc:ReceivedForeignTenderQuantity/@unitCode | cbc:ReceivedQuantity/@unitCode | cbc:ReceivedTenderQuantity/@unitCode | cbc:RejectedQuantity/@unitCode | cbc:ResponseQuantity/@unitCode | cbc:ReturnableQuantity/@unitCode | cbc:SharesNumberQuantity/@unitCode | cbc:ShortQuantity/@unitCode | cbc:TanksExchangedQuantity/@unitCode | cbc:TanksInBallastQuantity/@unitCode | cbc:TanksNotExchangedQuantity/@unitCode | cbc:TargetInventoryQuantity/@unitCode | cbc:ThresholdQuantity/@unitCode | cbc:TimeDeltaDaysQuantity/@unitCode | cbc:TotalBallastTanksOnBoardQuantity/@unitCode | cbc:TotalConsumedQuantity/@unitCode | cbc:TotalDeadPersonQuantity/@unitCode | cbc:TotalDeliveredQuantity/@unitCode | cbc:TotalGoodsItemQuantity/@unitCode | cbc:TotalIllPersonQuantity/@unitCode | cbc:TotalMeteredQuantity/@unitCode | cbc:TotalPackageQuantity/@unitCode | cbc:TotalPackagesQuantity/@unitCode | cbc:TotalTransportHandlingUnitQuantity/@unitCode | cbc:ValueQuantity/@unitCode | cbc:VarianceQuantity/@unitCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:AllowanceChargeReasonCode" priority="19" mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:AllowanceChargeReasonCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:AllowanceChargeReasonCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:AllowanceChargeReasonCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(@listName!='Adjustment Reason Description') ) and ( not(@listID!='UN/ECE 4465') ) and ( not(@listVersionID!='D03A') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/AllowanceChargeReasonCode-2.0.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Allowance Charge Reason Code') ) and ( not(@listID!='UN/ECE 3155') ) and ( not(@listVersionID!='D10B') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:codelist:standard:UNECE:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/AllowanceChargeReasonCode-2.1.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Allowance Charge Reason Code') ) and ( not(@listID!='UN/EDIFACT EDED 5189') ) and ( not(@listVersionID!='17B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.2/cl/gc/default/AllowanceChargeReasonCode-2.2.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;99&#x7f;100&#x7f;101&#x7f;102&#x7f;103&#x7f;104&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Allowance Charge Reason Code') ) and ( not(@listID!='UN/EDIFACT EDED 5189') ) and ( not(@listVersionID!='18B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/AllowanceChargeReasonCode-2.3.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;99&#x7f;100&#x7f;101&#x7f;102&#x7f;103&#x7f;104&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Allowance Charge Reason Code') ) and ( not(@listID!='UN/EDIFACT EDED 5189') ) and ( not(@listVersionID!='18B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/AllowanceChargeReasonCode-2.3.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;99&#x7f;100&#x7f;101&#x7f;102&#x7f;103&#x7f;104&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(@listName!='Adjustment Reason Description') ) and ( not(@listID!='UN/ECE 4465') ) and ( not(@listVersionID!='D03A') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/AllowanceChargeReasonCode-2.0.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Allowance Charge Reason Code') ) and ( not(@listID!='UN/ECE 3155') ) and ( not(@listVersionID!='D10B') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:codelist:standard:UNECE:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/AllowanceChargeReasonCode-2.1.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Allowance Charge Reason Code') ) and ( not(@listID!='UN/EDIFACT EDED 5189') ) and ( not(@listVersionID!='17B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.2/cl/gc/default/AllowanceChargeReasonCode-2.2.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;99&#x7f;100&#x7f;101&#x7f;102&#x7f;103&#x7f;104&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Allowance Charge Reason Code') ) and ( not(@listID!='UN/EDIFACT EDED 5189') ) and ( not(@listVersionID!='18B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/AllowanceChargeReasonCode-2.3.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;99&#x7f;100&#x7f;101&#x7f;102&#x7f;103&#x7f;104&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Allowance Charge Reason Code') ) and ( not(@listID!='UN/EDIFACT EDED 5189') ) and ( not(@listVersionID!='18B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:AllowanceChargeReasonCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/AllowanceChargeReasonCode-2.3.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;1&#x7f;2&#x7f;3&#x7f;4&#x7f;5&#x7f;6&#x7f;7&#x7f;8&#x7f;9&#x7f;10&#x7f;11&#x7f;12&#x7f;13&#x7f;14&#x7f;15&#x7f;16&#x7f;17&#x7f;18&#x7f;19&#x7f;20&#x7f;21&#x7f;22&#x7f;23&#x7f;24&#x7f;25&#x7f;26&#x7f;27&#x7f;28&#x7f;29&#x7f;30&#x7f;31&#x7f;32&#x7f;33&#x7f;34&#x7f;35&#x7f;36&#x7f;37&#x7f;38&#x7f;39&#x7f;40&#x7f;41&#x7f;42&#x7f;43&#x7f;44&#x7f;45&#x7f;46&#x7f;47&#x7f;48&#x7f;49&#x7f;50&#x7f;51&#x7f;52&#x7f;53&#x7f;54&#x7f;55&#x7f;56&#x7f;57&#x7f;58&#x7f;59&#x7f;60&#x7f;61&#x7f;62&#x7f;63&#x7f;64&#x7f;65&#x7f;66&#x7f;67&#x7f;68&#x7f;69&#x7f;70&#x7f;71&#x7f;72&#x7f;73&#x7f;74&#x7f;75&#x7f;76&#x7f;77&#x7f;78&#x7f;79&#x7f;80&#x7f;81&#x7f;82&#x7f;83&#x7f;84&#x7f;85&#x7f;86&#x7f;87&#x7f;88&#x7f;89&#x7f;90&#x7f;91&#x7f;92&#x7f;93&#x7f;94&#x7f;95&#x7f;96&#x7f;97&#x7f;98&#x7f;99&#x7f;100&#x7f;101&#x7f;102&#x7f;103&#x7f;104&#x7f;ZZZ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'AllowanceChargeReason-2.0 AllowanceChargeReason-2.1 AllowanceChargeReason-2.2 AllowanceChargeReason-2.3 AllowanceChargeReason-2.4' in the context 'cbc:AllowanceChargeReasonCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:ChannelCode" priority="18" mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:ChannelCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:ChannelCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:ChannelCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(@listName!='Communication Address Code Qualifier') ) and ( not(@listID!='UN/ECE 3155') ) and ( not(@listVersionID!='D03A') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChannelCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/ChannelCode-2.0.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Channel Code') ) and ( not(@listID!='') ) and ( not(@listVersionID!='D10B') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:codelist:standard:UNECE:CommunicationMeansTypeCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/ChannelCode-2.1.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AV&#x7f;AW&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Channel Code') ) and ( not(@listID!='UN/EDIFACT EDED 3155') ) and ( not(@listVersionID!='17B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChannelCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.2/cl/gc/default/ChannelCode-2.2.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AV&#x7f;AW&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Channel Code') ) and ( not(@listID!='UN/EDIFACT EDED 3155') ) and ( not(@listVersionID!='18B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChannelCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/ChannelCode-2.3.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AV&#x7f;AW&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Channel Code') ) and ( not(@listID!='UN/EDIFACT EDED 3155') ) and ( not(@listVersionID!='18B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChannelCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/ChannelCode-2.3.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AV&#x7f;AW&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(@listName!='Communication Address Code Qualifier') ) and ( not(@listID!='UN/ECE 3155') ) and ( not(@listVersionID!='D03A') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChannelCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/ChannelCode-2.0.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Channel Code') ) and ( not(@listID!='') ) and ( not(@listVersionID!='D10B') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:codelist:standard:UNECE:CommunicationMeansTypeCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/ChannelCode-2.1.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AV&#x7f;AW&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Channel Code') ) and ( not(@listID!='UN/EDIFACT EDED 3155') ) and ( not(@listVersionID!='17B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChannelCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.2/cl/gc/default/ChannelCode-2.2.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AV&#x7f;AW&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Channel Code') ) and ( not(@listID!='UN/EDIFACT EDED 3155') ) and ( not(@listVersionID!='18B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChannelCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/ChannelCode-2.3.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AV&#x7f;AW&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Channel Code') ) and ( not(@listID!='UN/EDIFACT EDED 3155') ) and ( not(@listVersionID!='18B') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChannelCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/ChannelCode-2.3.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AA&#x7f;AB&#x7f;AC&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AH&#x7f;AI&#x7f;AJ&#x7f;AK&#x7f;AL&#x7f;AM&#x7f;AN&#x7f;AO&#x7f;AP&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AV&#x7f;AW&#x7f;CA&#x7f;EI&#x7f;EM&#x7f;EX&#x7f;FT&#x7f;FX&#x7f;GM&#x7f;IE&#x7f;IM&#x7f;MA&#x7f;PB&#x7f;PS&#x7f;SW&#x7f;TE&#x7f;TG&#x7f;TL&#x7f;TM&#x7f;TT&#x7f;TX&#x7f;XF&#x7f;XG&#x7f;XH&#x7f;XI&#x7f;XJ&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'Channel-2.0 Channel-2.1 Channel-2.2 Channel-2.3 Channel-2.4' in the context 'cbc:ChannelCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:CardChipCode" priority="17" mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:CardChipCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:CardChipCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:CardChipCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(@listName!='Chip') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.0') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChipCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/ChipCode-2.0.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;Chip&#x7f;MagneticStripe&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(@listName!='Chip') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.0') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:ChipCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/ChipCode-2.0.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;Chip&#x7f;MagneticStripe&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'Chip-2.0' in the context 'cbc:CardChipCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:IdentificationCode" priority="16" mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:IdentificationCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:IdentificationCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:IdentificationCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(@listName!='Country') ) and ( not(@listID!='ISO3166-1') ) and ( not(@listVersionID!='0.3') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:CountryIdentificationCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/CountryIdentificationCode-2.0.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AF&#x7f;AL&#x7f;DZ&#x7f;AS&#x7f;AD&#x7f;AO&#x7f;AI&#x7f;AQ&#x7f;AG&#x7f;AR&#x7f;AM&#x7f;AW&#x7f;AU&#x7f;AT&#x7f;AZ&#x7f;BS&#x7f;BH&#x7f;BD&#x7f;BB&#x7f;BY&#x7f;BE&#x7f;BZ&#x7f;BJ&#x7f;BM&#x7f;BT&#x7f;BO&#x7f;BA&#x7f;BW&#x7f;BV&#x7f;BR&#x7f;IO&#x7f;BN&#x7f;BG&#x7f;BF&#x7f;BI&#x7f;KH&#x7f;CM&#x7f;CA&#x7f;CV&#x7f;KY&#x7f;CF&#x7f;TD&#x7f;CL&#x7f;CN&#x7f;CX&#x7f;CC&#x7f;CO&#x7f;KM&#x7f;CG&#x7f;CK&#x7f;CR&#x7f;CI&#x7f;HR&#x7f;CU&#x7f;CY&#x7f;CZ&#x7f;DK&#x7f;DJ&#x7f;DM&#x7f;DO&#x7f;TP&#x7f;EC&#x7f;EG&#x7f;SV&#x7f;GQ&#x7f;ER&#x7f;EE&#x7f;ET&#x7f;FK&#x7f;FO&#x7f;FJ&#x7f;FI&#x7f;FR&#x7f;FX&#x7f;GF&#x7f;PF&#x7f;TF&#x7f;GA&#x7f;GM&#x7f;GE&#x7f;DE&#x7f;GH&#x7f;GI&#x7f;GR&#x7f;GL&#x7f;GD&#x7f;GP&#x7f;GU&#x7f;GT&#x7f;GN&#x7f;GW&#x7f;GY&#x7f;HT&#x7f;HM&#x7f;HN&#x7f;HK&#x7f;HU&#x7f;IS&#x7f;IN&#x7f;ID&#x7f;IR&#x7f;IQ&#x7f;IE&#x7f;IL&#x7f;IT&#x7f;JM&#x7f;JP&#x7f;JO&#x7f;KZ&#x7f;KE&#x7f;KI&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KG&#x7f;LA&#x7f;LV&#x7f;LB&#x7f;LS&#x7f;LR&#x7f;LY&#x7f;LI&#x7f;LT&#x7f;LU&#x7f;MO&#x7f;MG&#x7f;MW&#x7f;MY&#x7f;MV&#x7f;ML&#x7f;MT&#x7f;MH&#x7f;MQ&#x7f;MR&#x7f;MU&#x7f;YT&#x7f;MX&#x7f;FM&#x7f;MD&#x7f;MC&#x7f;MN&#x7f;MS&#x7f;MA&#x7f;MZ&#x7f;MM&#x7f;NA&#x7f;NR&#x7f;NP&#x7f;AN&#x7f;NL&#x7f;NC&#x7f;NZ&#x7f;NI&#x7f;NE&#x7f;NG&#x7f;NU&#x7f;NF&#x7f;MP&#x7f;NO&#x7f;OM&#x7f;PK&#x7f;PW&#x7f;PA&#x7f;PG&#x7f;PY&#x7f;PE&#x7f;PH&#x7f;PN&#x7f;PL&#x7f;PT&#x7f;PR&#x7f;QA&#x7f;RE&#x7f;RO&#x7f;RU&#x7f;RW&#x7f;SH&#x7f;KN&#x7f;LC&#x7f;PM&#x7f;VC&#x7f;WS&#x7f;SM&#x7f;SA&#x7f;SN&#x7f;SC&#x7f;SL&#x7f;SG&#x7f;SK&#x7f;SI&#x7f;SB&#x7f;SO&#x7f;ZA&#x7f;GS&#x7f;ES&#x7f;LK&#x7f;SD&#x7f;SR&#x7f;SJ&#x7f;SZ&#x7f;SE&#x7f;CH&#x7f;SY&#x7f;ST&#x7f;TW&#x7f;TJ&#x7f;TZ&#x7f;TH&#x7f;MK&#x7f;TG&#x7f;TK&#x7f;TO&#x7f;TT&#x7f;TN&#x7f;TR&#x7f;TM&#x7f;TC&#x7f;TV&#x7f;UG&#x7f;UA&#x7f;AE&#x7f;GB&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VU&#x7f;VA&#x7f;VE&#x7f;VN&#x7f;VG&#x7f;VI&#x7f;WF&#x7f;EH&#x7f;YE&#x7f;YU&#x7f;ZR&#x7f;ZM&#x7f;ZW&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Country Identification Code') ) and ( not(@listID!='') ) and ( not(@listVersionID!='SecondEdition2006VI-12') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:identifierlist:standard:5:ISO316612A') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CountryIdentificationCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AI&#x7f;AL&#x7f;AM&#x7f;AO&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AW&#x7f;AX&#x7f;AZ&#x7f;BA&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BF&#x7f;BG&#x7f;BH&#x7f;BI&#x7f;BJ&#x7f;BM&#x7f;BN&#x7f;BO&#x7f;BQ&#x7f;BR&#x7f;BS&#x7f;BT&#x7f;BV&#x7f;BW&#x7f;BY&#x7f;BZ&#x7f;CA&#x7f;CC&#x7f;CD&#x7f;CF&#x7f;CG&#x7f;CH&#x7f;CI&#x7f;CK&#x7f;CL&#x7f;CM&#x7f;CN&#x7f;CO&#x7f;CR&#x7f;CU&#x7f;CV&#x7f;CW&#x7f;CX&#x7f;CY&#x7f;CZ&#x7f;DE&#x7f;DJ&#x7f;DK&#x7f;DM&#x7f;DO&#x7f;DZ&#x7f;EC&#x7f;EE&#x7f;EG&#x7f;EH&#x7f;ER&#x7f;ES&#x7f;ET&#x7f;FI&#x7f;FJ&#x7f;FK&#x7f;FM&#x7f;FO&#x7f;FR&#x7f;GA&#x7f;GB&#x7f;GD&#x7f;GE&#x7f;GF&#x7f;GG&#x7f;GH&#x7f;GI&#x7f;GL&#x7f;GM&#x7f;GN&#x7f;GP&#x7f;GQ&#x7f;GR&#x7f;GS&#x7f;GT&#x7f;GU&#x7f;GW&#x7f;GY&#x7f;HK&#x7f;HM&#x7f;HN&#x7f;HR&#x7f;HT&#x7f;HU&#x7f;ID&#x7f;IE&#x7f;IL&#x7f;IM&#x7f;IN&#x7f;IO&#x7f;IQ&#x7f;IR&#x7f;IS&#x7f;IT&#x7f;JE&#x7f;JM&#x7f;JO&#x7f;JP&#x7f;KE&#x7f;KG&#x7f;KH&#x7f;KI&#x7f;KM&#x7f;KN&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KY&#x7f;KZ&#x7f;LA&#x7f;LB&#x7f;LC&#x7f;LI&#x7f;LK&#x7f;LR&#x7f;LS&#x7f;LT&#x7f;LU&#x7f;LV&#x7f;LY&#x7f;MA&#x7f;MC&#x7f;MD&#x7f;ME&#x7f;MG&#x7f;MH&#x7f;MK&#x7f;ML&#x7f;MM&#x7f;MN&#x7f;MO&#x7f;MP&#x7f;MQ&#x7f;MR&#x7f;MS&#x7f;MT&#x7f;MU&#x7f;MV&#x7f;MW&#x7f;MX&#x7f;MY&#x7f;MZ&#x7f;NA&#x7f;NC&#x7f;NE&#x7f;NF&#x7f;NG&#x7f;NI&#x7f;NL&#x7f;NO&#x7f;NP&#x7f;NR&#x7f;NU&#x7f;NZ&#x7f;OM&#x7f;PA&#x7f;PE&#x7f;PF&#x7f;PG&#x7f;PH&#x7f;PK&#x7f;PL&#x7f;PM&#x7f;PN&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PW&#x7f;PY&#x7f;QA&#x7f;RE&#x7f;RO&#x7f;RS&#x7f;RU&#x7f;RW&#x7f;SA&#x7f;SB&#x7f;SC&#x7f;SD&#x7f;SE&#x7f;SG&#x7f;SH&#x7f;SI&#x7f;SJ&#x7f;SK&#x7f;SL&#x7f;SM&#x7f;SN&#x7f;SO&#x7f;SR&#x7f;SS&#x7f;ST&#x7f;SV&#x7f;SX&#x7f;SY&#x7f;SZ&#x7f;TC&#x7f;TD&#x7f;TF&#x7f;TG&#x7f;TH&#x7f;TJ&#x7f;TK&#x7f;TL&#x7f;TM&#x7f;TN&#x7f;TO&#x7f;TR&#x7f;TT&#x7f;TV&#x7f;TW&#x7f;TZ&#x7f;UA&#x7f;UG&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VA&#x7f;VC&#x7f;VE&#x7f;VG&#x7f;VI&#x7f;VN&#x7f;VU&#x7f;WF&#x7f;WS&#x7f;YE&#x7f;YT&#x7f;ZA&#x7f;ZM&#x7f;ZW&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Country Identification Code') ) and ( not(@listID!='ISO 3166') ) and ( not(@listVersionID!='2018-02-14') ) and ( not(@listSchemeURI!='urn:iso:std:iso:3166') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.2/cl/gc/default/CountryIdentificationCode-2.2.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AF&#x7f;AX&#x7f;AL&#x7f;DZ&#x7f;AS&#x7f;AD&#x7f;AO&#x7f;AI&#x7f;AQ&#x7f;AG&#x7f;AR&#x7f;AM&#x7f;AW&#x7f;AU&#x7f;AT&#x7f;AZ&#x7f;BS&#x7f;BH&#x7f;BD&#x7f;BB&#x7f;BY&#x7f;BE&#x7f;BZ&#x7f;BJ&#x7f;BM&#x7f;BT&#x7f;BO&#x7f;BQ&#x7f;BA&#x7f;BW&#x7f;BV&#x7f;BR&#x7f;IO&#x7f;BN&#x7f;BG&#x7f;BF&#x7f;BI&#x7f;CV&#x7f;KH&#x7f;CM&#x7f;CA&#x7f;KY&#x7f;CF&#x7f;TD&#x7f;CL&#x7f;CN&#x7f;CX&#x7f;CC&#x7f;CO&#x7f;KM&#x7f;CD&#x7f;CG&#x7f;CK&#x7f;CR&#x7f;CI&#x7f;HR&#x7f;CU&#x7f;CW&#x7f;CY&#x7f;CZ&#x7f;DK&#x7f;DJ&#x7f;DM&#x7f;DO&#x7f;EC&#x7f;EG&#x7f;SV&#x7f;GQ&#x7f;ER&#x7f;EE&#x7f;ET&#x7f;FK&#x7f;FO&#x7f;FJ&#x7f;FI&#x7f;FR&#x7f;GF&#x7f;PF&#x7f;TF&#x7f;GA&#x7f;GM&#x7f;GE&#x7f;DE&#x7f;GH&#x7f;GI&#x7f;GR&#x7f;GL&#x7f;GD&#x7f;GP&#x7f;GU&#x7f;GT&#x7f;GG&#x7f;GN&#x7f;GW&#x7f;GY&#x7f;HT&#x7f;HM&#x7f;VA&#x7f;HN&#x7f;HK&#x7f;HU&#x7f;IS&#x7f;IN&#x7f;ID&#x7f;IR&#x7f;IQ&#x7f;IE&#x7f;IM&#x7f;IL&#x7f;IT&#x7f;JM&#x7f;JP&#x7f;JE&#x7f;JO&#x7f;KZ&#x7f;KE&#x7f;KI&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KG&#x7f;LA&#x7f;LV&#x7f;LB&#x7f;LS&#x7f;LR&#x7f;LY&#x7f;LI&#x7f;LT&#x7f;LU&#x7f;MO&#x7f;MK&#x7f;MG&#x7f;MW&#x7f;MY&#x7f;MV&#x7f;ML&#x7f;MT&#x7f;MH&#x7f;MQ&#x7f;MR&#x7f;MU&#x7f;YT&#x7f;MX&#x7f;FM&#x7f;MD&#x7f;MC&#x7f;MN&#x7f;ME&#x7f;MS&#x7f;MA&#x7f;MZ&#x7f;MM&#x7f;NA&#x7f;NR&#x7f;NP&#x7f;NL&#x7f;NC&#x7f;NZ&#x7f;NI&#x7f;NE&#x7f;NG&#x7f;NU&#x7f;NF&#x7f;MP&#x7f;NO&#x7f;OM&#x7f;PK&#x7f;PW&#x7f;PS&#x7f;PA&#x7f;PG&#x7f;PY&#x7f;PE&#x7f;PH&#x7f;PN&#x7f;PL&#x7f;PT&#x7f;PR&#x7f;QA&#x7f;RE&#x7f;RO&#x7f;RU&#x7f;RW&#x7f;BL&#x7f;SH&#x7f;KN&#x7f;LC&#x7f;MF&#x7f;PM&#x7f;VC&#x7f;WS&#x7f;SM&#x7f;ST&#x7f;SA&#x7f;SN&#x7f;RS&#x7f;SC&#x7f;SL&#x7f;SG&#x7f;SX&#x7f;SK&#x7f;SI&#x7f;SB&#x7f;SO&#x7f;ZA&#x7f;GS&#x7f;SS&#x7f;ES&#x7f;LK&#x7f;SD&#x7f;SR&#x7f;SJ&#x7f;SZ&#x7f;SE&#x7f;CH&#x7f;SY&#x7f;TW&#x7f;TJ&#x7f;TZ&#x7f;TH&#x7f;TL&#x7f;TG&#x7f;TK&#x7f;TO&#x7f;TT&#x7f;TN&#x7f;TR&#x7f;TM&#x7f;TC&#x7f;TV&#x7f;UG&#x7f;UA&#x7f;AE&#x7f;GB&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VU&#x7f;VE&#x7f;VN&#x7f;VG&#x7f;VI&#x7f;WF&#x7f;EH&#x7f;YE&#x7f;ZM&#x7f;ZW&#x7f;AFG&#x7f;ALA&#x7f;ALB&#x7f;DZA&#x7f;ASM&#x7f;AND&#x7f;AGO&#x7f;AIA&#x7f;ATA&#x7f;ATG&#x7f;ARG&#x7f;ARM&#x7f;ABW&#x7f;AUS&#x7f;AUT&#x7f;AZE&#x7f;BHS&#x7f;BHR&#x7f;BGD&#x7f;BRB&#x7f;BLR&#x7f;BEL&#x7f;BLZ&#x7f;BEN&#x7f;BMU&#x7f;BTN&#x7f;BOL&#x7f;BES&#x7f;BIH&#x7f;BWA&#x7f;BVT&#x7f;BRA&#x7f;IOT&#x7f;BRN&#x7f;BGR&#x7f;BFA&#x7f;BDI&#x7f;CPV&#x7f;KHM&#x7f;CMR&#x7f;CAN&#x7f;CYM&#x7f;CAF&#x7f;TCD&#x7f;CHL&#x7f;CHN&#x7f;CXR&#x7f;CCK&#x7f;COL&#x7f;COM&#x7f;COD&#x7f;COG&#x7f;COK&#x7f;CRI&#x7f;CIV&#x7f;HRV&#x7f;CUB&#x7f;CUW&#x7f;CYP&#x7f;CZE&#x7f;DNK&#x7f;DJI&#x7f;DMA&#x7f;DOM&#x7f;ECU&#x7f;EGY&#x7f;SLV&#x7f;GNQ&#x7f;ERI&#x7f;EST&#x7f;ETH&#x7f;FLK&#x7f;FRO&#x7f;FJI&#x7f;FIN&#x7f;FRA&#x7f;GUF&#x7f;PYF&#x7f;ATF&#x7f;GAB&#x7f;GMB&#x7f;GEO&#x7f;DEU&#x7f;GHA&#x7f;GIB&#x7f;GRC&#x7f;GRL&#x7f;GRD&#x7f;GLP&#x7f;GUM&#x7f;GTM&#x7f;GGY&#x7f;GIN&#x7f;GNB&#x7f;GUY&#x7f;HTI&#x7f;HMD&#x7f;VAT&#x7f;HND&#x7f;HKG&#x7f;HUN&#x7f;ISL&#x7f;IND&#x7f;IDN&#x7f;IRN&#x7f;IRQ&#x7f;IRL&#x7f;IMN&#x7f;ISR&#x7f;ITA&#x7f;JAM&#x7f;JPN&#x7f;JEY&#x7f;JOR&#x7f;KAZ&#x7f;KEN&#x7f;KIR&#x7f;PRK&#x7f;KOR&#x7f;KWT&#x7f;KGZ&#x7f;LAO&#x7f;LVA&#x7f;LBN&#x7f;LSO&#x7f;LBR&#x7f;LBY&#x7f;LIE&#x7f;LTU&#x7f;LUX&#x7f;MAC&#x7f;MKD&#x7f;MDG&#x7f;MWI&#x7f;MYS&#x7f;MDV&#x7f;MLI&#x7f;MLT&#x7f;MHL&#x7f;MTQ&#x7f;MRT&#x7f;MUS&#x7f;MYT&#x7f;MEX&#x7f;FSM&#x7f;MDA&#x7f;MCO&#x7f;MNG&#x7f;MNE&#x7f;MSR&#x7f;MAR&#x7f;MOZ&#x7f;MMR&#x7f;NAM&#x7f;NRU&#x7f;NPL&#x7f;NLD&#x7f;NCL&#x7f;NZL&#x7f;NIC&#x7f;NER&#x7f;NGA&#x7f;NIU&#x7f;NFK&#x7f;MNP&#x7f;NOR&#x7f;OMN&#x7f;PAK&#x7f;PLW&#x7f;PSE&#x7f;PAN&#x7f;PNG&#x7f;PRY&#x7f;PER&#x7f;PHL&#x7f;PCN&#x7f;POL&#x7f;PRT&#x7f;PRI&#x7f;QAT&#x7f;REU&#x7f;ROU&#x7f;RUS&#x7f;RWA&#x7f;BLM&#x7f;SHN&#x7f;KNA&#x7f;LCA&#x7f;MAF&#x7f;SPM&#x7f;VCT&#x7f;WSM&#x7f;SMR&#x7f;STP&#x7f;SAU&#x7f;SEN&#x7f;SRB&#x7f;SYC&#x7f;SLE&#x7f;SGP&#x7f;SXM&#x7f;SVK&#x7f;SVN&#x7f;SLB&#x7f;SOM&#x7f;ZAF&#x7f;SGS&#x7f;SSD&#x7f;ESP&#x7f;LKA&#x7f;SDN&#x7f;SUR&#x7f;SJM&#x7f;SWZ&#x7f;SWE&#x7f;CHE&#x7f;SYR&#x7f;TWN&#x7f;TJK&#x7f;TZA&#x7f;THA&#x7f;TLS&#x7f;TGO&#x7f;TKL&#x7f;TON&#x7f;TTO&#x7f;TUN&#x7f;TUR&#x7f;TKM&#x7f;TCA&#x7f;TUV&#x7f;UGA&#x7f;UKR&#x7f;ARE&#x7f;GBR&#x7f;UMI&#x7f;USA&#x7f;URY&#x7f;UZB&#x7f;VUT&#x7f;VEN&#x7f;VNM&#x7f;VGB&#x7f;VIR&#x7f;WLF&#x7f;ESH&#x7f;YEM&#x7f;ZMB&#x7f;ZWE&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Country Identification Code') ) and ( not(@listID!='ISO 3166') ) and ( not(@listVersionID!='2020-04-17') ) and ( not(@listSchemeURI!='urn:iso:std:iso:3166') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/CountryIdentificationCode-2.3.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AF&#x7f;AL&#x7f;DZ&#x7f;AS&#x7f;AD&#x7f;AO&#x7f;AI&#x7f;AQ&#x7f;AG&#x7f;AR&#x7f;AM&#x7f;AW&#x7f;AU&#x7f;AT&#x7f;AZ&#x7f;BS&#x7f;BH&#x7f;BD&#x7f;BB&#x7f;BY&#x7f;BE&#x7f;BZ&#x7f;BJ&#x7f;BM&#x7f;BT&#x7f;BO&#x7f;BQ&#x7f;BA&#x7f;BW&#x7f;BV&#x7f;BR&#x7f;IO&#x7f;BN&#x7f;BG&#x7f;BF&#x7f;BI&#x7f;CV&#x7f;KH&#x7f;CM&#x7f;CA&#x7f;KY&#x7f;CF&#x7f;TD&#x7f;CL&#x7f;CN&#x7f;CX&#x7f;CC&#x7f;CO&#x7f;KM&#x7f;CD&#x7f;CG&#x7f;CK&#x7f;CR&#x7f;HR&#x7f;CU&#x7f;CW&#x7f;CY&#x7f;CZ&#x7f;CI&#x7f;DK&#x7f;DJ&#x7f;DM&#x7f;DO&#x7f;EC&#x7f;EG&#x7f;SV&#x7f;GQ&#x7f;ER&#x7f;EE&#x7f;SZ&#x7f;ET&#x7f;FK&#x7f;FO&#x7f;FJ&#x7f;FI&#x7f;FR&#x7f;GF&#x7f;PF&#x7f;TF&#x7f;GA&#x7f;GM&#x7f;GE&#x7f;DE&#x7f;GH&#x7f;GI&#x7f;GR&#x7f;GL&#x7f;GD&#x7f;GP&#x7f;GU&#x7f;GT&#x7f;GG&#x7f;GN&#x7f;GW&#x7f;GY&#x7f;HT&#x7f;HM&#x7f;VA&#x7f;HN&#x7f;HK&#x7f;HU&#x7f;IS&#x7f;IN&#x7f;ID&#x7f;IR&#x7f;IQ&#x7f;IE&#x7f;IM&#x7f;IL&#x7f;IT&#x7f;JM&#x7f;JP&#x7f;JE&#x7f;JO&#x7f;KZ&#x7f;KE&#x7f;KI&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KG&#x7f;LA&#x7f;LV&#x7f;LB&#x7f;LS&#x7f;LR&#x7f;LY&#x7f;LI&#x7f;LT&#x7f;LU&#x7f;MO&#x7f;MG&#x7f;MW&#x7f;MY&#x7f;MV&#x7f;ML&#x7f;MT&#x7f;MH&#x7f;MQ&#x7f;MR&#x7f;MU&#x7f;YT&#x7f;MX&#x7f;FM&#x7f;MD&#x7f;MC&#x7f;MN&#x7f;ME&#x7f;MS&#x7f;MA&#x7f;MZ&#x7f;MM&#x7f;NA&#x7f;NR&#x7f;NP&#x7f;NL&#x7f;NC&#x7f;NZ&#x7f;NI&#x7f;NE&#x7f;NG&#x7f;NU&#x7f;NF&#x7f;MK&#x7f;MP&#x7f;NO&#x7f;OM&#x7f;PK&#x7f;PW&#x7f;PS&#x7f;PA&#x7f;PG&#x7f;PY&#x7f;PE&#x7f;PH&#x7f;PN&#x7f;PL&#x7f;PT&#x7f;PR&#x7f;QA&#x7f;RO&#x7f;RU&#x7f;RW&#x7f;RE&#x7f;BL&#x7f;SH&#x7f;KN&#x7f;LC&#x7f;MF&#x7f;PM&#x7f;VC&#x7f;WS&#x7f;SM&#x7f;ST&#x7f;SA&#x7f;SN&#x7f;RS&#x7f;SC&#x7f;SL&#x7f;SG&#x7f;SX&#x7f;SK&#x7f;SI&#x7f;SB&#x7f;SO&#x7f;ZA&#x7f;GS&#x7f;SS&#x7f;ES&#x7f;LK&#x7f;SD&#x7f;SR&#x7f;SJ&#x7f;SE&#x7f;CH&#x7f;SY&#x7f;TW&#x7f;TJ&#x7f;TZ&#x7f;TH&#x7f;TL&#x7f;TG&#x7f;TK&#x7f;TO&#x7f;TT&#x7f;TN&#x7f;TR&#x7f;TM&#x7f;TC&#x7f;TV&#x7f;UG&#x7f;UA&#x7f;AE&#x7f;GB&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VU&#x7f;VE&#x7f;VN&#x7f;VG&#x7f;VI&#x7f;WF&#x7f;EH&#x7f;YE&#x7f;ZM&#x7f;ZW&#x7f;AX&#x7f;AFG&#x7f;ALB&#x7f;DZA&#x7f;ASM&#x7f;AND&#x7f;AGO&#x7f;AIA&#x7f;ATA&#x7f;ATG&#x7f;ARG&#x7f;ARM&#x7f;ABW&#x7f;AUS&#x7f;AUT&#x7f;AZE&#x7f;BHS&#x7f;BHR&#x7f;BGD&#x7f;BRB&#x7f;BLR&#x7f;BEL&#x7f;BLZ&#x7f;BEN&#x7f;BMU&#x7f;BTN&#x7f;BOL&#x7f;BES&#x7f;BIH&#x7f;BWA&#x7f;BVT&#x7f;BRA&#x7f;IOT&#x7f;BRN&#x7f;BGR&#x7f;BFA&#x7f;BDI&#x7f;CPV&#x7f;KHM&#x7f;CMR&#x7f;CAN&#x7f;CYM&#x7f;CAF&#x7f;TCD&#x7f;CHL&#x7f;CHN&#x7f;CXR&#x7f;CCK&#x7f;COL&#x7f;COM&#x7f;COD&#x7f;COG&#x7f;COK&#x7f;CRI&#x7f;HRV&#x7f;CUB&#x7f;CUW&#x7f;CYP&#x7f;CZE&#x7f;CIV&#x7f;DNK&#x7f;DJI&#x7f;DMA&#x7f;DOM&#x7f;ECU&#x7f;EGY&#x7f;SLV&#x7f;GNQ&#x7f;ERI&#x7f;EST&#x7f;SWZ&#x7f;ETH&#x7f;FLK&#x7f;FRO&#x7f;FJI&#x7f;FIN&#x7f;FRA&#x7f;GUF&#x7f;PYF&#x7f;ATF&#x7f;GAB&#x7f;GMB&#x7f;GEO&#x7f;DEU&#x7f;GHA&#x7f;GIB&#x7f;GRC&#x7f;GRL&#x7f;GRD&#x7f;GLP&#x7f;GUM&#x7f;GTM&#x7f;GGY&#x7f;GIN&#x7f;GNB&#x7f;GUY&#x7f;HTI&#x7f;HMD&#x7f;VAT&#x7f;HND&#x7f;HKG&#x7f;HUN&#x7f;ISL&#x7f;IND&#x7f;IDN&#x7f;IRN&#x7f;IRQ&#x7f;IRL&#x7f;IMN&#x7f;ISR&#x7f;ITA&#x7f;JAM&#x7f;JPN&#x7f;JEY&#x7f;JOR&#x7f;KAZ&#x7f;KEN&#x7f;KIR&#x7f;PRK&#x7f;KOR&#x7f;KWT&#x7f;KGZ&#x7f;LAO&#x7f;LVA&#x7f;LBN&#x7f;LSO&#x7f;LBR&#x7f;LBY&#x7f;LIE&#x7f;LTU&#x7f;LUX&#x7f;MAC&#x7f;MDG&#x7f;MWI&#x7f;MYS&#x7f;MDV&#x7f;MLI&#x7f;MLT&#x7f;MHL&#x7f;MTQ&#x7f;MRT&#x7f;MUS&#x7f;MYT&#x7f;MEX&#x7f;FSM&#x7f;MDA&#x7f;MCO&#x7f;MNG&#x7f;MNE&#x7f;MSR&#x7f;MAR&#x7f;MOZ&#x7f;MMR&#x7f;NAM&#x7f;NRU&#x7f;NPL&#x7f;NLD&#x7f;NCL&#x7f;NZL&#x7f;NIC&#x7f;NER&#x7f;NGA&#x7f;NIU&#x7f;NFK&#x7f;MKD&#x7f;MNP&#x7f;NOR&#x7f;OMN&#x7f;PAK&#x7f;PLW&#x7f;PSE&#x7f;PAN&#x7f;PNG&#x7f;PRY&#x7f;PER&#x7f;PHL&#x7f;PCN&#x7f;POL&#x7f;PRT&#x7f;PRI&#x7f;QAT&#x7f;ROU&#x7f;RUS&#x7f;RWA&#x7f;REU&#x7f;BLM&#x7f;SHN&#x7f;KNA&#x7f;LCA&#x7f;MAF&#x7f;SPM&#x7f;VCT&#x7f;WSM&#x7f;SMR&#x7f;STP&#x7f;SAU&#x7f;SEN&#x7f;SRB&#x7f;SYC&#x7f;SLE&#x7f;SGP&#x7f;SXM&#x7f;SVK&#x7f;SVN&#x7f;SLB&#x7f;SOM&#x7f;ZAF&#x7f;SGS&#x7f;SSD&#x7f;ESP&#x7f;LKA&#x7f;SDN&#x7f;SUR&#x7f;SJM&#x7f;SWE&#x7f;CHE&#x7f;SYR&#x7f;TWN&#x7f;TJK&#x7f;TZA&#x7f;THA&#x7f;TLS&#x7f;TGO&#x7f;TKL&#x7f;TON&#x7f;TTO&#x7f;TUN&#x7f;TUR&#x7f;TKM&#x7f;TCA&#x7f;TUV&#x7f;UGA&#x7f;UKR&#x7f;ARE&#x7f;GBR&#x7f;UMI&#x7f;USA&#x7f;URY&#x7f;UZB&#x7f;VUT&#x7f;VEN&#x7f;VNM&#x7f;VGB&#x7f;VIR&#x7f;WLF&#x7f;ESH&#x7f;YEM&#x7f;ZMB&#x7f;ZWE&#x7f;ALA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Country Identification Code') ) and ( not(@listID!='ISO 3166') ) and ( not(@listVersionID!='2020-04-17') ) and ( not(@listSchemeURI!='urn:iso:std:iso:3166') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/CountryIdentificationCode-2.3.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AF&#x7f;AL&#x7f;DZ&#x7f;AS&#x7f;AD&#x7f;AO&#x7f;AI&#x7f;AQ&#x7f;AG&#x7f;AR&#x7f;AM&#x7f;AW&#x7f;AU&#x7f;AT&#x7f;AZ&#x7f;BS&#x7f;BH&#x7f;BD&#x7f;BB&#x7f;BY&#x7f;BE&#x7f;BZ&#x7f;BJ&#x7f;BM&#x7f;BT&#x7f;BO&#x7f;BQ&#x7f;BA&#x7f;BW&#x7f;BV&#x7f;BR&#x7f;IO&#x7f;BN&#x7f;BG&#x7f;BF&#x7f;BI&#x7f;CV&#x7f;KH&#x7f;CM&#x7f;CA&#x7f;KY&#x7f;CF&#x7f;TD&#x7f;CL&#x7f;CN&#x7f;CX&#x7f;CC&#x7f;CO&#x7f;KM&#x7f;CD&#x7f;CG&#x7f;CK&#x7f;CR&#x7f;HR&#x7f;CU&#x7f;CW&#x7f;CY&#x7f;CZ&#x7f;CI&#x7f;DK&#x7f;DJ&#x7f;DM&#x7f;DO&#x7f;EC&#x7f;EG&#x7f;SV&#x7f;GQ&#x7f;ER&#x7f;EE&#x7f;SZ&#x7f;ET&#x7f;FK&#x7f;FO&#x7f;FJ&#x7f;FI&#x7f;FR&#x7f;GF&#x7f;PF&#x7f;TF&#x7f;GA&#x7f;GM&#x7f;GE&#x7f;DE&#x7f;GH&#x7f;GI&#x7f;GR&#x7f;GL&#x7f;GD&#x7f;GP&#x7f;GU&#x7f;GT&#x7f;GG&#x7f;GN&#x7f;GW&#x7f;GY&#x7f;HT&#x7f;HM&#x7f;VA&#x7f;HN&#x7f;HK&#x7f;HU&#x7f;IS&#x7f;IN&#x7f;ID&#x7f;IR&#x7f;IQ&#x7f;IE&#x7f;IM&#x7f;IL&#x7f;IT&#x7f;JM&#x7f;JP&#x7f;JE&#x7f;JO&#x7f;KZ&#x7f;KE&#x7f;KI&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KG&#x7f;LA&#x7f;LV&#x7f;LB&#x7f;LS&#x7f;LR&#x7f;LY&#x7f;LI&#x7f;LT&#x7f;LU&#x7f;MO&#x7f;MG&#x7f;MW&#x7f;MY&#x7f;MV&#x7f;ML&#x7f;MT&#x7f;MH&#x7f;MQ&#x7f;MR&#x7f;MU&#x7f;YT&#x7f;MX&#x7f;FM&#x7f;MD&#x7f;MC&#x7f;MN&#x7f;ME&#x7f;MS&#x7f;MA&#x7f;MZ&#x7f;MM&#x7f;NA&#x7f;NR&#x7f;NP&#x7f;NL&#x7f;NC&#x7f;NZ&#x7f;NI&#x7f;NE&#x7f;NG&#x7f;NU&#x7f;NF&#x7f;MK&#x7f;MP&#x7f;NO&#x7f;OM&#x7f;PK&#x7f;PW&#x7f;PS&#x7f;PA&#x7f;PG&#x7f;PY&#x7f;PE&#x7f;PH&#x7f;PN&#x7f;PL&#x7f;PT&#x7f;PR&#x7f;QA&#x7f;RO&#x7f;RU&#x7f;RW&#x7f;RE&#x7f;BL&#x7f;SH&#x7f;KN&#x7f;LC&#x7f;MF&#x7f;PM&#x7f;VC&#x7f;WS&#x7f;SM&#x7f;ST&#x7f;SA&#x7f;SN&#x7f;RS&#x7f;SC&#x7f;SL&#x7f;SG&#x7f;SX&#x7f;SK&#x7f;SI&#x7f;SB&#x7f;SO&#x7f;ZA&#x7f;GS&#x7f;SS&#x7f;ES&#x7f;LK&#x7f;SD&#x7f;SR&#x7f;SJ&#x7f;SE&#x7f;CH&#x7f;SY&#x7f;TW&#x7f;TJ&#x7f;TZ&#x7f;TH&#x7f;TL&#x7f;TG&#x7f;TK&#x7f;TO&#x7f;TT&#x7f;TN&#x7f;TR&#x7f;TM&#x7f;TC&#x7f;TV&#x7f;UG&#x7f;UA&#x7f;AE&#x7f;GB&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VU&#x7f;VE&#x7f;VN&#x7f;VG&#x7f;VI&#x7f;WF&#x7f;EH&#x7f;YE&#x7f;ZM&#x7f;ZW&#x7f;AX&#x7f;AFG&#x7f;ALB&#x7f;DZA&#x7f;ASM&#x7f;AND&#x7f;AGO&#x7f;AIA&#x7f;ATA&#x7f;ATG&#x7f;ARG&#x7f;ARM&#x7f;ABW&#x7f;AUS&#x7f;AUT&#x7f;AZE&#x7f;BHS&#x7f;BHR&#x7f;BGD&#x7f;BRB&#x7f;BLR&#x7f;BEL&#x7f;BLZ&#x7f;BEN&#x7f;BMU&#x7f;BTN&#x7f;BOL&#x7f;BES&#x7f;BIH&#x7f;BWA&#x7f;BVT&#x7f;BRA&#x7f;IOT&#x7f;BRN&#x7f;BGR&#x7f;BFA&#x7f;BDI&#x7f;CPV&#x7f;KHM&#x7f;CMR&#x7f;CAN&#x7f;CYM&#x7f;CAF&#x7f;TCD&#x7f;CHL&#x7f;CHN&#x7f;CXR&#x7f;CCK&#x7f;COL&#x7f;COM&#x7f;COD&#x7f;COG&#x7f;COK&#x7f;CRI&#x7f;HRV&#x7f;CUB&#x7f;CUW&#x7f;CYP&#x7f;CZE&#x7f;CIV&#x7f;DNK&#x7f;DJI&#x7f;DMA&#x7f;DOM&#x7f;ECU&#x7f;EGY&#x7f;SLV&#x7f;GNQ&#x7f;ERI&#x7f;EST&#x7f;SWZ&#x7f;ETH&#x7f;FLK&#x7f;FRO&#x7f;FJI&#x7f;FIN&#x7f;FRA&#x7f;GUF&#x7f;PYF&#x7f;ATF&#x7f;GAB&#x7f;GMB&#x7f;GEO&#x7f;DEU&#x7f;GHA&#x7f;GIB&#x7f;GRC&#x7f;GRL&#x7f;GRD&#x7f;GLP&#x7f;GUM&#x7f;GTM&#x7f;GGY&#x7f;GIN&#x7f;GNB&#x7f;GUY&#x7f;HTI&#x7f;HMD&#x7f;VAT&#x7f;HND&#x7f;HKG&#x7f;HUN&#x7f;ISL&#x7f;IND&#x7f;IDN&#x7f;IRN&#x7f;IRQ&#x7f;IRL&#x7f;IMN&#x7f;ISR&#x7f;ITA&#x7f;JAM&#x7f;JPN&#x7f;JEY&#x7f;JOR&#x7f;KAZ&#x7f;KEN&#x7f;KIR&#x7f;PRK&#x7f;KOR&#x7f;KWT&#x7f;KGZ&#x7f;LAO&#x7f;LVA&#x7f;LBN&#x7f;LSO&#x7f;LBR&#x7f;LBY&#x7f;LIE&#x7f;LTU&#x7f;LUX&#x7f;MAC&#x7f;MDG&#x7f;MWI&#x7f;MYS&#x7f;MDV&#x7f;MLI&#x7f;MLT&#x7f;MHL&#x7f;MTQ&#x7f;MRT&#x7f;MUS&#x7f;MYT&#x7f;MEX&#x7f;FSM&#x7f;MDA&#x7f;MCO&#x7f;MNG&#x7f;MNE&#x7f;MSR&#x7f;MAR&#x7f;MOZ&#x7f;MMR&#x7f;NAM&#x7f;NRU&#x7f;NPL&#x7f;NLD&#x7f;NCL&#x7f;NZL&#x7f;NIC&#x7f;NER&#x7f;NGA&#x7f;NIU&#x7f;NFK&#x7f;MKD&#x7f;MNP&#x7f;NOR&#x7f;OMN&#x7f;PAK&#x7f;PLW&#x7f;PSE&#x7f;PAN&#x7f;PNG&#x7f;PRY&#x7f;PER&#x7f;PHL&#x7f;PCN&#x7f;POL&#x7f;PRT&#x7f;PRI&#x7f;QAT&#x7f;ROU&#x7f;RUS&#x7f;RWA&#x7f;REU&#x7f;BLM&#x7f;SHN&#x7f;KNA&#x7f;LCA&#x7f;MAF&#x7f;SPM&#x7f;VCT&#x7f;WSM&#x7f;SMR&#x7f;STP&#x7f;SAU&#x7f;SEN&#x7f;SRB&#x7f;SYC&#x7f;SLE&#x7f;SGP&#x7f;SXM&#x7f;SVK&#x7f;SVN&#x7f;SLB&#x7f;SOM&#x7f;ZAF&#x7f;SGS&#x7f;SSD&#x7f;ESP&#x7f;LKA&#x7f;SDN&#x7f;SUR&#x7f;SJM&#x7f;SWE&#x7f;CHE&#x7f;SYR&#x7f;TWN&#x7f;TJK&#x7f;TZA&#x7f;THA&#x7f;TLS&#x7f;TGO&#x7f;TKL&#x7f;TON&#x7f;TTO&#x7f;TUN&#x7f;TUR&#x7f;TKM&#x7f;TCA&#x7f;TUV&#x7f;UGA&#x7f;UKR&#x7f;ARE&#x7f;GBR&#x7f;UMI&#x7f;USA&#x7f;URY&#x7f;UZB&#x7f;VUT&#x7f;VEN&#x7f;VNM&#x7f;VGB&#x7f;VIR&#x7f;WLF&#x7f;ESH&#x7f;YEM&#x7f;ZMB&#x7f;ZWE&#x7f;ALA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(@listName!='Country') ) and ( not(@listID!='ISO3166-1') ) and ( not(@listVersionID!='0.3') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:CountryIdentificationCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/CountryIdentificationCode-2.0.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AF&#x7f;AL&#x7f;DZ&#x7f;AS&#x7f;AD&#x7f;AO&#x7f;AI&#x7f;AQ&#x7f;AG&#x7f;AR&#x7f;AM&#x7f;AW&#x7f;AU&#x7f;AT&#x7f;AZ&#x7f;BS&#x7f;BH&#x7f;BD&#x7f;BB&#x7f;BY&#x7f;BE&#x7f;BZ&#x7f;BJ&#x7f;BM&#x7f;BT&#x7f;BO&#x7f;BA&#x7f;BW&#x7f;BV&#x7f;BR&#x7f;IO&#x7f;BN&#x7f;BG&#x7f;BF&#x7f;BI&#x7f;KH&#x7f;CM&#x7f;CA&#x7f;CV&#x7f;KY&#x7f;CF&#x7f;TD&#x7f;CL&#x7f;CN&#x7f;CX&#x7f;CC&#x7f;CO&#x7f;KM&#x7f;CG&#x7f;CK&#x7f;CR&#x7f;CI&#x7f;HR&#x7f;CU&#x7f;CY&#x7f;CZ&#x7f;DK&#x7f;DJ&#x7f;DM&#x7f;DO&#x7f;TP&#x7f;EC&#x7f;EG&#x7f;SV&#x7f;GQ&#x7f;ER&#x7f;EE&#x7f;ET&#x7f;FK&#x7f;FO&#x7f;FJ&#x7f;FI&#x7f;FR&#x7f;FX&#x7f;GF&#x7f;PF&#x7f;TF&#x7f;GA&#x7f;GM&#x7f;GE&#x7f;DE&#x7f;GH&#x7f;GI&#x7f;GR&#x7f;GL&#x7f;GD&#x7f;GP&#x7f;GU&#x7f;GT&#x7f;GN&#x7f;GW&#x7f;GY&#x7f;HT&#x7f;HM&#x7f;HN&#x7f;HK&#x7f;HU&#x7f;IS&#x7f;IN&#x7f;ID&#x7f;IR&#x7f;IQ&#x7f;IE&#x7f;IL&#x7f;IT&#x7f;JM&#x7f;JP&#x7f;JO&#x7f;KZ&#x7f;KE&#x7f;KI&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KG&#x7f;LA&#x7f;LV&#x7f;LB&#x7f;LS&#x7f;LR&#x7f;LY&#x7f;LI&#x7f;LT&#x7f;LU&#x7f;MO&#x7f;MG&#x7f;MW&#x7f;MY&#x7f;MV&#x7f;ML&#x7f;MT&#x7f;MH&#x7f;MQ&#x7f;MR&#x7f;MU&#x7f;YT&#x7f;MX&#x7f;FM&#x7f;MD&#x7f;MC&#x7f;MN&#x7f;MS&#x7f;MA&#x7f;MZ&#x7f;MM&#x7f;NA&#x7f;NR&#x7f;NP&#x7f;AN&#x7f;NL&#x7f;NC&#x7f;NZ&#x7f;NI&#x7f;NE&#x7f;NG&#x7f;NU&#x7f;NF&#x7f;MP&#x7f;NO&#x7f;OM&#x7f;PK&#x7f;PW&#x7f;PA&#x7f;PG&#x7f;PY&#x7f;PE&#x7f;PH&#x7f;PN&#x7f;PL&#x7f;PT&#x7f;PR&#x7f;QA&#x7f;RE&#x7f;RO&#x7f;RU&#x7f;RW&#x7f;SH&#x7f;KN&#x7f;LC&#x7f;PM&#x7f;VC&#x7f;WS&#x7f;SM&#x7f;SA&#x7f;SN&#x7f;SC&#x7f;SL&#x7f;SG&#x7f;SK&#x7f;SI&#x7f;SB&#x7f;SO&#x7f;ZA&#x7f;GS&#x7f;ES&#x7f;LK&#x7f;SD&#x7f;SR&#x7f;SJ&#x7f;SZ&#x7f;SE&#x7f;CH&#x7f;SY&#x7f;ST&#x7f;TW&#x7f;TJ&#x7f;TZ&#x7f;TH&#x7f;MK&#x7f;TG&#x7f;TK&#x7f;TO&#x7f;TT&#x7f;TN&#x7f;TR&#x7f;TM&#x7f;TC&#x7f;TV&#x7f;UG&#x7f;UA&#x7f;AE&#x7f;GB&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VU&#x7f;VA&#x7f;VE&#x7f;VN&#x7f;VG&#x7f;VI&#x7f;WF&#x7f;EH&#x7f;YE&#x7f;YU&#x7f;ZR&#x7f;ZM&#x7f;ZW&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Country Identification Code') ) and ( not(@listID!='') ) and ( not(@listVersionID!='SecondEdition2006VI-12') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:identifierlist:standard:5:ISO316612A') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CountryIdentificationCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AD&#x7f;AE&#x7f;AF&#x7f;AG&#x7f;AI&#x7f;AL&#x7f;AM&#x7f;AO&#x7f;AQ&#x7f;AR&#x7f;AS&#x7f;AT&#x7f;AU&#x7f;AW&#x7f;AX&#x7f;AZ&#x7f;BA&#x7f;BB&#x7f;BD&#x7f;BE&#x7f;BF&#x7f;BG&#x7f;BH&#x7f;BI&#x7f;BJ&#x7f;BM&#x7f;BN&#x7f;BO&#x7f;BQ&#x7f;BR&#x7f;BS&#x7f;BT&#x7f;BV&#x7f;BW&#x7f;BY&#x7f;BZ&#x7f;CA&#x7f;CC&#x7f;CD&#x7f;CF&#x7f;CG&#x7f;CH&#x7f;CI&#x7f;CK&#x7f;CL&#x7f;CM&#x7f;CN&#x7f;CO&#x7f;CR&#x7f;CU&#x7f;CV&#x7f;CW&#x7f;CX&#x7f;CY&#x7f;CZ&#x7f;DE&#x7f;DJ&#x7f;DK&#x7f;DM&#x7f;DO&#x7f;DZ&#x7f;EC&#x7f;EE&#x7f;EG&#x7f;EH&#x7f;ER&#x7f;ES&#x7f;ET&#x7f;FI&#x7f;FJ&#x7f;FK&#x7f;FM&#x7f;FO&#x7f;FR&#x7f;GA&#x7f;GB&#x7f;GD&#x7f;GE&#x7f;GF&#x7f;GG&#x7f;GH&#x7f;GI&#x7f;GL&#x7f;GM&#x7f;GN&#x7f;GP&#x7f;GQ&#x7f;GR&#x7f;GS&#x7f;GT&#x7f;GU&#x7f;GW&#x7f;GY&#x7f;HK&#x7f;HM&#x7f;HN&#x7f;HR&#x7f;HT&#x7f;HU&#x7f;ID&#x7f;IE&#x7f;IL&#x7f;IM&#x7f;IN&#x7f;IO&#x7f;IQ&#x7f;IR&#x7f;IS&#x7f;IT&#x7f;JE&#x7f;JM&#x7f;JO&#x7f;JP&#x7f;KE&#x7f;KG&#x7f;KH&#x7f;KI&#x7f;KM&#x7f;KN&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KY&#x7f;KZ&#x7f;LA&#x7f;LB&#x7f;LC&#x7f;LI&#x7f;LK&#x7f;LR&#x7f;LS&#x7f;LT&#x7f;LU&#x7f;LV&#x7f;LY&#x7f;MA&#x7f;MC&#x7f;MD&#x7f;ME&#x7f;MG&#x7f;MH&#x7f;MK&#x7f;ML&#x7f;MM&#x7f;MN&#x7f;MO&#x7f;MP&#x7f;MQ&#x7f;MR&#x7f;MS&#x7f;MT&#x7f;MU&#x7f;MV&#x7f;MW&#x7f;MX&#x7f;MY&#x7f;MZ&#x7f;NA&#x7f;NC&#x7f;NE&#x7f;NF&#x7f;NG&#x7f;NI&#x7f;NL&#x7f;NO&#x7f;NP&#x7f;NR&#x7f;NU&#x7f;NZ&#x7f;OM&#x7f;PA&#x7f;PE&#x7f;PF&#x7f;PG&#x7f;PH&#x7f;PK&#x7f;PL&#x7f;PM&#x7f;PN&#x7f;PR&#x7f;PS&#x7f;PT&#x7f;PW&#x7f;PY&#x7f;QA&#x7f;RE&#x7f;RO&#x7f;RS&#x7f;RU&#x7f;RW&#x7f;SA&#x7f;SB&#x7f;SC&#x7f;SD&#x7f;SE&#x7f;SG&#x7f;SH&#x7f;SI&#x7f;SJ&#x7f;SK&#x7f;SL&#x7f;SM&#x7f;SN&#x7f;SO&#x7f;SR&#x7f;SS&#x7f;ST&#x7f;SV&#x7f;SX&#x7f;SY&#x7f;SZ&#x7f;TC&#x7f;TD&#x7f;TF&#x7f;TG&#x7f;TH&#x7f;TJ&#x7f;TK&#x7f;TL&#x7f;TM&#x7f;TN&#x7f;TO&#x7f;TR&#x7f;TT&#x7f;TV&#x7f;TW&#x7f;TZ&#x7f;UA&#x7f;UG&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VA&#x7f;VC&#x7f;VE&#x7f;VG&#x7f;VI&#x7f;VN&#x7f;VU&#x7f;WF&#x7f;WS&#x7f;YE&#x7f;YT&#x7f;ZA&#x7f;ZM&#x7f;ZW&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Country Identification Code') ) and ( not(@listID!='ISO 3166') ) and ( not(@listVersionID!='2018-02-14') ) and ( not(@listSchemeURI!='urn:iso:std:iso:3166') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.2/cl/gc/default/CountryIdentificationCode-2.2.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AF&#x7f;AX&#x7f;AL&#x7f;DZ&#x7f;AS&#x7f;AD&#x7f;AO&#x7f;AI&#x7f;AQ&#x7f;AG&#x7f;AR&#x7f;AM&#x7f;AW&#x7f;AU&#x7f;AT&#x7f;AZ&#x7f;BS&#x7f;BH&#x7f;BD&#x7f;BB&#x7f;BY&#x7f;BE&#x7f;BZ&#x7f;BJ&#x7f;BM&#x7f;BT&#x7f;BO&#x7f;BQ&#x7f;BA&#x7f;BW&#x7f;BV&#x7f;BR&#x7f;IO&#x7f;BN&#x7f;BG&#x7f;BF&#x7f;BI&#x7f;CV&#x7f;KH&#x7f;CM&#x7f;CA&#x7f;KY&#x7f;CF&#x7f;TD&#x7f;CL&#x7f;CN&#x7f;CX&#x7f;CC&#x7f;CO&#x7f;KM&#x7f;CD&#x7f;CG&#x7f;CK&#x7f;CR&#x7f;CI&#x7f;HR&#x7f;CU&#x7f;CW&#x7f;CY&#x7f;CZ&#x7f;DK&#x7f;DJ&#x7f;DM&#x7f;DO&#x7f;EC&#x7f;EG&#x7f;SV&#x7f;GQ&#x7f;ER&#x7f;EE&#x7f;ET&#x7f;FK&#x7f;FO&#x7f;FJ&#x7f;FI&#x7f;FR&#x7f;GF&#x7f;PF&#x7f;TF&#x7f;GA&#x7f;GM&#x7f;GE&#x7f;DE&#x7f;GH&#x7f;GI&#x7f;GR&#x7f;GL&#x7f;GD&#x7f;GP&#x7f;GU&#x7f;GT&#x7f;GG&#x7f;GN&#x7f;GW&#x7f;GY&#x7f;HT&#x7f;HM&#x7f;VA&#x7f;HN&#x7f;HK&#x7f;HU&#x7f;IS&#x7f;IN&#x7f;ID&#x7f;IR&#x7f;IQ&#x7f;IE&#x7f;IM&#x7f;IL&#x7f;IT&#x7f;JM&#x7f;JP&#x7f;JE&#x7f;JO&#x7f;KZ&#x7f;KE&#x7f;KI&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KG&#x7f;LA&#x7f;LV&#x7f;LB&#x7f;LS&#x7f;LR&#x7f;LY&#x7f;LI&#x7f;LT&#x7f;LU&#x7f;MO&#x7f;MK&#x7f;MG&#x7f;MW&#x7f;MY&#x7f;MV&#x7f;ML&#x7f;MT&#x7f;MH&#x7f;MQ&#x7f;MR&#x7f;MU&#x7f;YT&#x7f;MX&#x7f;FM&#x7f;MD&#x7f;MC&#x7f;MN&#x7f;ME&#x7f;MS&#x7f;MA&#x7f;MZ&#x7f;MM&#x7f;NA&#x7f;NR&#x7f;NP&#x7f;NL&#x7f;NC&#x7f;NZ&#x7f;NI&#x7f;NE&#x7f;NG&#x7f;NU&#x7f;NF&#x7f;MP&#x7f;NO&#x7f;OM&#x7f;PK&#x7f;PW&#x7f;PS&#x7f;PA&#x7f;PG&#x7f;PY&#x7f;PE&#x7f;PH&#x7f;PN&#x7f;PL&#x7f;PT&#x7f;PR&#x7f;QA&#x7f;RE&#x7f;RO&#x7f;RU&#x7f;RW&#x7f;BL&#x7f;SH&#x7f;KN&#x7f;LC&#x7f;MF&#x7f;PM&#x7f;VC&#x7f;WS&#x7f;SM&#x7f;ST&#x7f;SA&#x7f;SN&#x7f;RS&#x7f;SC&#x7f;SL&#x7f;SG&#x7f;SX&#x7f;SK&#x7f;SI&#x7f;SB&#x7f;SO&#x7f;ZA&#x7f;GS&#x7f;SS&#x7f;ES&#x7f;LK&#x7f;SD&#x7f;SR&#x7f;SJ&#x7f;SZ&#x7f;SE&#x7f;CH&#x7f;SY&#x7f;TW&#x7f;TJ&#x7f;TZ&#x7f;TH&#x7f;TL&#x7f;TG&#x7f;TK&#x7f;TO&#x7f;TT&#x7f;TN&#x7f;TR&#x7f;TM&#x7f;TC&#x7f;TV&#x7f;UG&#x7f;UA&#x7f;AE&#x7f;GB&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VU&#x7f;VE&#x7f;VN&#x7f;VG&#x7f;VI&#x7f;WF&#x7f;EH&#x7f;YE&#x7f;ZM&#x7f;ZW&#x7f;AFG&#x7f;ALA&#x7f;ALB&#x7f;DZA&#x7f;ASM&#x7f;AND&#x7f;AGO&#x7f;AIA&#x7f;ATA&#x7f;ATG&#x7f;ARG&#x7f;ARM&#x7f;ABW&#x7f;AUS&#x7f;AUT&#x7f;AZE&#x7f;BHS&#x7f;BHR&#x7f;BGD&#x7f;BRB&#x7f;BLR&#x7f;BEL&#x7f;BLZ&#x7f;BEN&#x7f;BMU&#x7f;BTN&#x7f;BOL&#x7f;BES&#x7f;BIH&#x7f;BWA&#x7f;BVT&#x7f;BRA&#x7f;IOT&#x7f;BRN&#x7f;BGR&#x7f;BFA&#x7f;BDI&#x7f;CPV&#x7f;KHM&#x7f;CMR&#x7f;CAN&#x7f;CYM&#x7f;CAF&#x7f;TCD&#x7f;CHL&#x7f;CHN&#x7f;CXR&#x7f;CCK&#x7f;COL&#x7f;COM&#x7f;COD&#x7f;COG&#x7f;COK&#x7f;CRI&#x7f;CIV&#x7f;HRV&#x7f;CUB&#x7f;CUW&#x7f;CYP&#x7f;CZE&#x7f;DNK&#x7f;DJI&#x7f;DMA&#x7f;DOM&#x7f;ECU&#x7f;EGY&#x7f;SLV&#x7f;GNQ&#x7f;ERI&#x7f;EST&#x7f;ETH&#x7f;FLK&#x7f;FRO&#x7f;FJI&#x7f;FIN&#x7f;FRA&#x7f;GUF&#x7f;PYF&#x7f;ATF&#x7f;GAB&#x7f;GMB&#x7f;GEO&#x7f;DEU&#x7f;GHA&#x7f;GIB&#x7f;GRC&#x7f;GRL&#x7f;GRD&#x7f;GLP&#x7f;GUM&#x7f;GTM&#x7f;GGY&#x7f;GIN&#x7f;GNB&#x7f;GUY&#x7f;HTI&#x7f;HMD&#x7f;VAT&#x7f;HND&#x7f;HKG&#x7f;HUN&#x7f;ISL&#x7f;IND&#x7f;IDN&#x7f;IRN&#x7f;IRQ&#x7f;IRL&#x7f;IMN&#x7f;ISR&#x7f;ITA&#x7f;JAM&#x7f;JPN&#x7f;JEY&#x7f;JOR&#x7f;KAZ&#x7f;KEN&#x7f;KIR&#x7f;PRK&#x7f;KOR&#x7f;KWT&#x7f;KGZ&#x7f;LAO&#x7f;LVA&#x7f;LBN&#x7f;LSO&#x7f;LBR&#x7f;LBY&#x7f;LIE&#x7f;LTU&#x7f;LUX&#x7f;MAC&#x7f;MKD&#x7f;MDG&#x7f;MWI&#x7f;MYS&#x7f;MDV&#x7f;MLI&#x7f;MLT&#x7f;MHL&#x7f;MTQ&#x7f;MRT&#x7f;MUS&#x7f;MYT&#x7f;MEX&#x7f;FSM&#x7f;MDA&#x7f;MCO&#x7f;MNG&#x7f;MNE&#x7f;MSR&#x7f;MAR&#x7f;MOZ&#x7f;MMR&#x7f;NAM&#x7f;NRU&#x7f;NPL&#x7f;NLD&#x7f;NCL&#x7f;NZL&#x7f;NIC&#x7f;NER&#x7f;NGA&#x7f;NIU&#x7f;NFK&#x7f;MNP&#x7f;NOR&#x7f;OMN&#x7f;PAK&#x7f;PLW&#x7f;PSE&#x7f;PAN&#x7f;PNG&#x7f;PRY&#x7f;PER&#x7f;PHL&#x7f;PCN&#x7f;POL&#x7f;PRT&#x7f;PRI&#x7f;QAT&#x7f;REU&#x7f;ROU&#x7f;RUS&#x7f;RWA&#x7f;BLM&#x7f;SHN&#x7f;KNA&#x7f;LCA&#x7f;MAF&#x7f;SPM&#x7f;VCT&#x7f;WSM&#x7f;SMR&#x7f;STP&#x7f;SAU&#x7f;SEN&#x7f;SRB&#x7f;SYC&#x7f;SLE&#x7f;SGP&#x7f;SXM&#x7f;SVK&#x7f;SVN&#x7f;SLB&#x7f;SOM&#x7f;ZAF&#x7f;SGS&#x7f;SSD&#x7f;ESP&#x7f;LKA&#x7f;SDN&#x7f;SUR&#x7f;SJM&#x7f;SWZ&#x7f;SWE&#x7f;CHE&#x7f;SYR&#x7f;TWN&#x7f;TJK&#x7f;TZA&#x7f;THA&#x7f;TLS&#x7f;TGO&#x7f;TKL&#x7f;TON&#x7f;TTO&#x7f;TUN&#x7f;TUR&#x7f;TKM&#x7f;TCA&#x7f;TUV&#x7f;UGA&#x7f;UKR&#x7f;ARE&#x7f;GBR&#x7f;UMI&#x7f;USA&#x7f;URY&#x7f;UZB&#x7f;VUT&#x7f;VEN&#x7f;VNM&#x7f;VGB&#x7f;VIR&#x7f;WLF&#x7f;ESH&#x7f;YEM&#x7f;ZMB&#x7f;ZWE&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Country Identification Code') ) and ( not(@listID!='ISO 3166') ) and ( not(@listVersionID!='2020-04-17') ) and ( not(@listSchemeURI!='urn:iso:std:iso:3166') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/CountryIdentificationCode-2.3.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AF&#x7f;AL&#x7f;DZ&#x7f;AS&#x7f;AD&#x7f;AO&#x7f;AI&#x7f;AQ&#x7f;AG&#x7f;AR&#x7f;AM&#x7f;AW&#x7f;AU&#x7f;AT&#x7f;AZ&#x7f;BS&#x7f;BH&#x7f;BD&#x7f;BB&#x7f;BY&#x7f;BE&#x7f;BZ&#x7f;BJ&#x7f;BM&#x7f;BT&#x7f;BO&#x7f;BQ&#x7f;BA&#x7f;BW&#x7f;BV&#x7f;BR&#x7f;IO&#x7f;BN&#x7f;BG&#x7f;BF&#x7f;BI&#x7f;CV&#x7f;KH&#x7f;CM&#x7f;CA&#x7f;KY&#x7f;CF&#x7f;TD&#x7f;CL&#x7f;CN&#x7f;CX&#x7f;CC&#x7f;CO&#x7f;KM&#x7f;CD&#x7f;CG&#x7f;CK&#x7f;CR&#x7f;HR&#x7f;CU&#x7f;CW&#x7f;CY&#x7f;CZ&#x7f;CI&#x7f;DK&#x7f;DJ&#x7f;DM&#x7f;DO&#x7f;EC&#x7f;EG&#x7f;SV&#x7f;GQ&#x7f;ER&#x7f;EE&#x7f;SZ&#x7f;ET&#x7f;FK&#x7f;FO&#x7f;FJ&#x7f;FI&#x7f;FR&#x7f;GF&#x7f;PF&#x7f;TF&#x7f;GA&#x7f;GM&#x7f;GE&#x7f;DE&#x7f;GH&#x7f;GI&#x7f;GR&#x7f;GL&#x7f;GD&#x7f;GP&#x7f;GU&#x7f;GT&#x7f;GG&#x7f;GN&#x7f;GW&#x7f;GY&#x7f;HT&#x7f;HM&#x7f;VA&#x7f;HN&#x7f;HK&#x7f;HU&#x7f;IS&#x7f;IN&#x7f;ID&#x7f;IR&#x7f;IQ&#x7f;IE&#x7f;IM&#x7f;IL&#x7f;IT&#x7f;JM&#x7f;JP&#x7f;JE&#x7f;JO&#x7f;KZ&#x7f;KE&#x7f;KI&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KG&#x7f;LA&#x7f;LV&#x7f;LB&#x7f;LS&#x7f;LR&#x7f;LY&#x7f;LI&#x7f;LT&#x7f;LU&#x7f;MO&#x7f;MG&#x7f;MW&#x7f;MY&#x7f;MV&#x7f;ML&#x7f;MT&#x7f;MH&#x7f;MQ&#x7f;MR&#x7f;MU&#x7f;YT&#x7f;MX&#x7f;FM&#x7f;MD&#x7f;MC&#x7f;MN&#x7f;ME&#x7f;MS&#x7f;MA&#x7f;MZ&#x7f;MM&#x7f;NA&#x7f;NR&#x7f;NP&#x7f;NL&#x7f;NC&#x7f;NZ&#x7f;NI&#x7f;NE&#x7f;NG&#x7f;NU&#x7f;NF&#x7f;MK&#x7f;MP&#x7f;NO&#x7f;OM&#x7f;PK&#x7f;PW&#x7f;PS&#x7f;PA&#x7f;PG&#x7f;PY&#x7f;PE&#x7f;PH&#x7f;PN&#x7f;PL&#x7f;PT&#x7f;PR&#x7f;QA&#x7f;RO&#x7f;RU&#x7f;RW&#x7f;RE&#x7f;BL&#x7f;SH&#x7f;KN&#x7f;LC&#x7f;MF&#x7f;PM&#x7f;VC&#x7f;WS&#x7f;SM&#x7f;ST&#x7f;SA&#x7f;SN&#x7f;RS&#x7f;SC&#x7f;SL&#x7f;SG&#x7f;SX&#x7f;SK&#x7f;SI&#x7f;SB&#x7f;SO&#x7f;ZA&#x7f;GS&#x7f;SS&#x7f;ES&#x7f;LK&#x7f;SD&#x7f;SR&#x7f;SJ&#x7f;SE&#x7f;CH&#x7f;SY&#x7f;TW&#x7f;TJ&#x7f;TZ&#x7f;TH&#x7f;TL&#x7f;TG&#x7f;TK&#x7f;TO&#x7f;TT&#x7f;TN&#x7f;TR&#x7f;TM&#x7f;TC&#x7f;TV&#x7f;UG&#x7f;UA&#x7f;AE&#x7f;GB&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VU&#x7f;VE&#x7f;VN&#x7f;VG&#x7f;VI&#x7f;WF&#x7f;EH&#x7f;YE&#x7f;ZM&#x7f;ZW&#x7f;AX&#x7f;AFG&#x7f;ALB&#x7f;DZA&#x7f;ASM&#x7f;AND&#x7f;AGO&#x7f;AIA&#x7f;ATA&#x7f;ATG&#x7f;ARG&#x7f;ARM&#x7f;ABW&#x7f;AUS&#x7f;AUT&#x7f;AZE&#x7f;BHS&#x7f;BHR&#x7f;BGD&#x7f;BRB&#x7f;BLR&#x7f;BEL&#x7f;BLZ&#x7f;BEN&#x7f;BMU&#x7f;BTN&#x7f;BOL&#x7f;BES&#x7f;BIH&#x7f;BWA&#x7f;BVT&#x7f;BRA&#x7f;IOT&#x7f;BRN&#x7f;BGR&#x7f;BFA&#x7f;BDI&#x7f;CPV&#x7f;KHM&#x7f;CMR&#x7f;CAN&#x7f;CYM&#x7f;CAF&#x7f;TCD&#x7f;CHL&#x7f;CHN&#x7f;CXR&#x7f;CCK&#x7f;COL&#x7f;COM&#x7f;COD&#x7f;COG&#x7f;COK&#x7f;CRI&#x7f;HRV&#x7f;CUB&#x7f;CUW&#x7f;CYP&#x7f;CZE&#x7f;CIV&#x7f;DNK&#x7f;DJI&#x7f;DMA&#x7f;DOM&#x7f;ECU&#x7f;EGY&#x7f;SLV&#x7f;GNQ&#x7f;ERI&#x7f;EST&#x7f;SWZ&#x7f;ETH&#x7f;FLK&#x7f;FRO&#x7f;FJI&#x7f;FIN&#x7f;FRA&#x7f;GUF&#x7f;PYF&#x7f;ATF&#x7f;GAB&#x7f;GMB&#x7f;GEO&#x7f;DEU&#x7f;GHA&#x7f;GIB&#x7f;GRC&#x7f;GRL&#x7f;GRD&#x7f;GLP&#x7f;GUM&#x7f;GTM&#x7f;GGY&#x7f;GIN&#x7f;GNB&#x7f;GUY&#x7f;HTI&#x7f;HMD&#x7f;VAT&#x7f;HND&#x7f;HKG&#x7f;HUN&#x7f;ISL&#x7f;IND&#x7f;IDN&#x7f;IRN&#x7f;IRQ&#x7f;IRL&#x7f;IMN&#x7f;ISR&#x7f;ITA&#x7f;JAM&#x7f;JPN&#x7f;JEY&#x7f;JOR&#x7f;KAZ&#x7f;KEN&#x7f;KIR&#x7f;PRK&#x7f;KOR&#x7f;KWT&#x7f;KGZ&#x7f;LAO&#x7f;LVA&#x7f;LBN&#x7f;LSO&#x7f;LBR&#x7f;LBY&#x7f;LIE&#x7f;LTU&#x7f;LUX&#x7f;MAC&#x7f;MDG&#x7f;MWI&#x7f;MYS&#x7f;MDV&#x7f;MLI&#x7f;MLT&#x7f;MHL&#x7f;MTQ&#x7f;MRT&#x7f;MUS&#x7f;MYT&#x7f;MEX&#x7f;FSM&#x7f;MDA&#x7f;MCO&#x7f;MNG&#x7f;MNE&#x7f;MSR&#x7f;MAR&#x7f;MOZ&#x7f;MMR&#x7f;NAM&#x7f;NRU&#x7f;NPL&#x7f;NLD&#x7f;NCL&#x7f;NZL&#x7f;NIC&#x7f;NER&#x7f;NGA&#x7f;NIU&#x7f;NFK&#x7f;MKD&#x7f;MNP&#x7f;NOR&#x7f;OMN&#x7f;PAK&#x7f;PLW&#x7f;PSE&#x7f;PAN&#x7f;PNG&#x7f;PRY&#x7f;PER&#x7f;PHL&#x7f;PCN&#x7f;POL&#x7f;PRT&#x7f;PRI&#x7f;QAT&#x7f;ROU&#x7f;RUS&#x7f;RWA&#x7f;REU&#x7f;BLM&#x7f;SHN&#x7f;KNA&#x7f;LCA&#x7f;MAF&#x7f;SPM&#x7f;VCT&#x7f;WSM&#x7f;SMR&#x7f;STP&#x7f;SAU&#x7f;SEN&#x7f;SRB&#x7f;SYC&#x7f;SLE&#x7f;SGP&#x7f;SXM&#x7f;SVK&#x7f;SVN&#x7f;SLB&#x7f;SOM&#x7f;ZAF&#x7f;SGS&#x7f;SSD&#x7f;ESP&#x7f;LKA&#x7f;SDN&#x7f;SUR&#x7f;SJM&#x7f;SWE&#x7f;CHE&#x7f;SYR&#x7f;TWN&#x7f;TJK&#x7f;TZA&#x7f;THA&#x7f;TLS&#x7f;TGO&#x7f;TKL&#x7f;TON&#x7f;TTO&#x7f;TUN&#x7f;TUR&#x7f;TKM&#x7f;TCA&#x7f;TUV&#x7f;UGA&#x7f;UKR&#x7f;ARE&#x7f;GBR&#x7f;UMI&#x7f;USA&#x7f;URY&#x7f;UZB&#x7f;VUT&#x7f;VEN&#x7f;VNM&#x7f;VGB&#x7f;VIR&#x7f;WLF&#x7f;ESH&#x7f;YEM&#x7f;ZMB&#x7f;ZWE&#x7f;ALA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Country Identification Code') ) and ( not(@listID!='ISO 3166') ) and ( not(@listVersionID!='2020-04-17') ) and ( not(@listSchemeURI!='urn:iso:std:iso:3166') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/CountryIdentificationCode-2.3.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AF&#x7f;AL&#x7f;DZ&#x7f;AS&#x7f;AD&#x7f;AO&#x7f;AI&#x7f;AQ&#x7f;AG&#x7f;AR&#x7f;AM&#x7f;AW&#x7f;AU&#x7f;AT&#x7f;AZ&#x7f;BS&#x7f;BH&#x7f;BD&#x7f;BB&#x7f;BY&#x7f;BE&#x7f;BZ&#x7f;BJ&#x7f;BM&#x7f;BT&#x7f;BO&#x7f;BQ&#x7f;BA&#x7f;BW&#x7f;BV&#x7f;BR&#x7f;IO&#x7f;BN&#x7f;BG&#x7f;BF&#x7f;BI&#x7f;CV&#x7f;KH&#x7f;CM&#x7f;CA&#x7f;KY&#x7f;CF&#x7f;TD&#x7f;CL&#x7f;CN&#x7f;CX&#x7f;CC&#x7f;CO&#x7f;KM&#x7f;CD&#x7f;CG&#x7f;CK&#x7f;CR&#x7f;HR&#x7f;CU&#x7f;CW&#x7f;CY&#x7f;CZ&#x7f;CI&#x7f;DK&#x7f;DJ&#x7f;DM&#x7f;DO&#x7f;EC&#x7f;EG&#x7f;SV&#x7f;GQ&#x7f;ER&#x7f;EE&#x7f;SZ&#x7f;ET&#x7f;FK&#x7f;FO&#x7f;FJ&#x7f;FI&#x7f;FR&#x7f;GF&#x7f;PF&#x7f;TF&#x7f;GA&#x7f;GM&#x7f;GE&#x7f;DE&#x7f;GH&#x7f;GI&#x7f;GR&#x7f;GL&#x7f;GD&#x7f;GP&#x7f;GU&#x7f;GT&#x7f;GG&#x7f;GN&#x7f;GW&#x7f;GY&#x7f;HT&#x7f;HM&#x7f;VA&#x7f;HN&#x7f;HK&#x7f;HU&#x7f;IS&#x7f;IN&#x7f;ID&#x7f;IR&#x7f;IQ&#x7f;IE&#x7f;IM&#x7f;IL&#x7f;IT&#x7f;JM&#x7f;JP&#x7f;JE&#x7f;JO&#x7f;KZ&#x7f;KE&#x7f;KI&#x7f;KP&#x7f;KR&#x7f;KW&#x7f;KG&#x7f;LA&#x7f;LV&#x7f;LB&#x7f;LS&#x7f;LR&#x7f;LY&#x7f;LI&#x7f;LT&#x7f;LU&#x7f;MO&#x7f;MG&#x7f;MW&#x7f;MY&#x7f;MV&#x7f;ML&#x7f;MT&#x7f;MH&#x7f;MQ&#x7f;MR&#x7f;MU&#x7f;YT&#x7f;MX&#x7f;FM&#x7f;MD&#x7f;MC&#x7f;MN&#x7f;ME&#x7f;MS&#x7f;MA&#x7f;MZ&#x7f;MM&#x7f;NA&#x7f;NR&#x7f;NP&#x7f;NL&#x7f;NC&#x7f;NZ&#x7f;NI&#x7f;NE&#x7f;NG&#x7f;NU&#x7f;NF&#x7f;MK&#x7f;MP&#x7f;NO&#x7f;OM&#x7f;PK&#x7f;PW&#x7f;PS&#x7f;PA&#x7f;PG&#x7f;PY&#x7f;PE&#x7f;PH&#x7f;PN&#x7f;PL&#x7f;PT&#x7f;PR&#x7f;QA&#x7f;RO&#x7f;RU&#x7f;RW&#x7f;RE&#x7f;BL&#x7f;SH&#x7f;KN&#x7f;LC&#x7f;MF&#x7f;PM&#x7f;VC&#x7f;WS&#x7f;SM&#x7f;ST&#x7f;SA&#x7f;SN&#x7f;RS&#x7f;SC&#x7f;SL&#x7f;SG&#x7f;SX&#x7f;SK&#x7f;SI&#x7f;SB&#x7f;SO&#x7f;ZA&#x7f;GS&#x7f;SS&#x7f;ES&#x7f;LK&#x7f;SD&#x7f;SR&#x7f;SJ&#x7f;SE&#x7f;CH&#x7f;SY&#x7f;TW&#x7f;TJ&#x7f;TZ&#x7f;TH&#x7f;TL&#x7f;TG&#x7f;TK&#x7f;TO&#x7f;TT&#x7f;TN&#x7f;TR&#x7f;TM&#x7f;TC&#x7f;TV&#x7f;UG&#x7f;UA&#x7f;AE&#x7f;GB&#x7f;UM&#x7f;US&#x7f;UY&#x7f;UZ&#x7f;VU&#x7f;VE&#x7f;VN&#x7f;VG&#x7f;VI&#x7f;WF&#x7f;EH&#x7f;YE&#x7f;ZM&#x7f;ZW&#x7f;AX&#x7f;AFG&#x7f;ALB&#x7f;DZA&#x7f;ASM&#x7f;AND&#x7f;AGO&#x7f;AIA&#x7f;ATA&#x7f;ATG&#x7f;ARG&#x7f;ARM&#x7f;ABW&#x7f;AUS&#x7f;AUT&#x7f;AZE&#x7f;BHS&#x7f;BHR&#x7f;BGD&#x7f;BRB&#x7f;BLR&#x7f;BEL&#x7f;BLZ&#x7f;BEN&#x7f;BMU&#x7f;BTN&#x7f;BOL&#x7f;BES&#x7f;BIH&#x7f;BWA&#x7f;BVT&#x7f;BRA&#x7f;IOT&#x7f;BRN&#x7f;BGR&#x7f;BFA&#x7f;BDI&#x7f;CPV&#x7f;KHM&#x7f;CMR&#x7f;CAN&#x7f;CYM&#x7f;CAF&#x7f;TCD&#x7f;CHL&#x7f;CHN&#x7f;CXR&#x7f;CCK&#x7f;COL&#x7f;COM&#x7f;COD&#x7f;COG&#x7f;COK&#x7f;CRI&#x7f;HRV&#x7f;CUB&#x7f;CUW&#x7f;CYP&#x7f;CZE&#x7f;CIV&#x7f;DNK&#x7f;DJI&#x7f;DMA&#x7f;DOM&#x7f;ECU&#x7f;EGY&#x7f;SLV&#x7f;GNQ&#x7f;ERI&#x7f;EST&#x7f;SWZ&#x7f;ETH&#x7f;FLK&#x7f;FRO&#x7f;FJI&#x7f;FIN&#x7f;FRA&#x7f;GUF&#x7f;PYF&#x7f;ATF&#x7f;GAB&#x7f;GMB&#x7f;GEO&#x7f;DEU&#x7f;GHA&#x7f;GIB&#x7f;GRC&#x7f;GRL&#x7f;GRD&#x7f;GLP&#x7f;GUM&#x7f;GTM&#x7f;GGY&#x7f;GIN&#x7f;GNB&#x7f;GUY&#x7f;HTI&#x7f;HMD&#x7f;VAT&#x7f;HND&#x7f;HKG&#x7f;HUN&#x7f;ISL&#x7f;IND&#x7f;IDN&#x7f;IRN&#x7f;IRQ&#x7f;IRL&#x7f;IMN&#x7f;ISR&#x7f;ITA&#x7f;JAM&#x7f;JPN&#x7f;JEY&#x7f;JOR&#x7f;KAZ&#x7f;KEN&#x7f;KIR&#x7f;PRK&#x7f;KOR&#x7f;KWT&#x7f;KGZ&#x7f;LAO&#x7f;LVA&#x7f;LBN&#x7f;LSO&#x7f;LBR&#x7f;LBY&#x7f;LIE&#x7f;LTU&#x7f;LUX&#x7f;MAC&#x7f;MDG&#x7f;MWI&#x7f;MYS&#x7f;MDV&#x7f;MLI&#x7f;MLT&#x7f;MHL&#x7f;MTQ&#x7f;MRT&#x7f;MUS&#x7f;MYT&#x7f;MEX&#x7f;FSM&#x7f;MDA&#x7f;MCO&#x7f;MNG&#x7f;MNE&#x7f;MSR&#x7f;MAR&#x7f;MOZ&#x7f;MMR&#x7f;NAM&#x7f;NRU&#x7f;NPL&#x7f;NLD&#x7f;NCL&#x7f;NZL&#x7f;NIC&#x7f;NER&#x7f;NGA&#x7f;NIU&#x7f;NFK&#x7f;MKD&#x7f;MNP&#x7f;NOR&#x7f;OMN&#x7f;PAK&#x7f;PLW&#x7f;PSE&#x7f;PAN&#x7f;PNG&#x7f;PRY&#x7f;PER&#x7f;PHL&#x7f;PCN&#x7f;POL&#x7f;PRT&#x7f;PRI&#x7f;QAT&#x7f;ROU&#x7f;RUS&#x7f;RWA&#x7f;REU&#x7f;BLM&#x7f;SHN&#x7f;KNA&#x7f;LCA&#x7f;MAF&#x7f;SPM&#x7f;VCT&#x7f;WSM&#x7f;SMR&#x7f;STP&#x7f;SAU&#x7f;SEN&#x7f;SRB&#x7f;SYC&#x7f;SLE&#x7f;SGP&#x7f;SXM&#x7f;SVK&#x7f;SVN&#x7f;SLB&#x7f;SOM&#x7f;ZAF&#x7f;SGS&#x7f;SSD&#x7f;ESP&#x7f;LKA&#x7f;SDN&#x7f;SUR&#x7f;SJM&#x7f;SWE&#x7f;CHE&#x7f;SYR&#x7f;TWN&#x7f;TJK&#x7f;TZA&#x7f;THA&#x7f;TLS&#x7f;TGO&#x7f;TKL&#x7f;TON&#x7f;TTO&#x7f;TUN&#x7f;TUR&#x7f;TKM&#x7f;TCA&#x7f;TUV&#x7f;UGA&#x7f;UKR&#x7f;ARE&#x7f;GBR&#x7f;UMI&#x7f;USA&#x7f;URY&#x7f;UZB&#x7f;VUT&#x7f;VEN&#x7f;VNM&#x7f;VGB&#x7f;VIR&#x7f;WLF&#x7f;ESH&#x7f;YEM&#x7f;ZMB&#x7f;ZWE&#x7f;ALA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'CountryIdentification-2.0 CountryIdentification-2.1 CountryIdentification-2.2 CountryIdentification-2.3 CountryIdentification-2.4' in the context 'cbc:IdentificationCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:CurrencyCode | cbc:DocumentCurrencyCode | cbc:PaymentAlternativeCurrencyCode | cbc:PaymentCurrencyCode | cbc:PricingCurrencyCode | cbc:RequestedInvoiceCurrencyCode | cbc:SourceCurrencyCode | cbc:TargetCurrencyCode | cbc:TaxCurrencyCode | cbc:ValueCurrencyCode"
                 priority="15"
                 mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:CurrencyCode | cbc:DocumentCurrencyCode | cbc:PaymentAlternativeCurrencyCode | cbc:PaymentCurrencyCode | cbc:PricingCurrencyCode | cbc:RequestedInvoiceCurrencyCode | cbc:SourceCurrencyCode | cbc:TargetCurrencyCode | cbc:TaxCurrencyCode | cbc:ValueCurrencyCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:CurrencyCode | cbc:DocumentCurrencyCode | cbc:PaymentAlternativeCurrencyCode | cbc:PaymentCurrencyCode | cbc:PricingCurrencyCode | cbc:RequestedInvoiceCurrencyCode | cbc:SourceCurrencyCode | cbc:TargetCurrencyCode | cbc:TaxCurrencyCode | cbc:ValueCurrencyCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:CurrencyCode | cbc:DocumentCurrencyCode | cbc:PaymentAlternativeCurrencyCode | cbc:PaymentCurrencyCode | cbc:PricingCurrencyCode | cbc:RequestedInvoiceCurrencyCode | cbc:SourceCurrencyCode | cbc:TargetCurrencyCode | cbc:TaxCurrencyCode | cbc:ValueCurrencyCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(@listName!='Currency') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2001') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:codelist:specification:54217') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/cefact/CurrencyCode-2.0.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AWG&#x7f;AZM&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYR&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;CRC&#x7f;CUP&#x7f;CVE&#x7f;CYP&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EEK&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GEL&#x7f;GHC&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LTL&#x7f;LVL&#x7f;LYD&#x7f;MAD&#x7f;MDL&#x7f;MGF&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRO&#x7f;MTL&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MYR&#x7f;MZM&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;ROL&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDD&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SIT&#x7f;SKK&#x7f;SLL&#x7f;SOS&#x7f;SRG&#x7f;STD&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMM&#x7f;TND&#x7f;TOP&#x7f;TRL&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;UYU&#x7f;UZS&#x7f;VEB&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPT&#x7f;YER&#x7f;YUM&#x7f;ZAR&#x7f;ZMK&#x7f;ZWD&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Currency Code') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2012-01-12') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:codelist:standard:5:ISO42173A') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CurrencyCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYR&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LTL&#x7f;LVL&#x7f;LYD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRO&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STD&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USN&#x7f;USS&#x7f;UYI&#x7f;UYU&#x7f;UZS&#x7f;VEF&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XDR&#x7f;XFU&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZMK&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Currency Code') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2018-01-01') ) and ( not(@listSchemeURI!='urn:iso:std:iso:4217') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CurrencyCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UZS&#x7f;VEF&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Currency Code') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2018-08-29') ) and ( not(@listSchemeURI!='urn:iso:std:iso:4217') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CurrencyCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UYW&#x7f;UZS&#x7f;VES&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Currency Code') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2018-08-29') ) and ( not(@listSchemeURI!='urn:iso:std:iso:4217') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CurrencyCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UYW&#x7f;UZS&#x7f;VES&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(@listName!='Currency') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2001') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:codelist:specification:54217') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/cefact/CurrencyCode-2.0.gc') ) and ( not(@listAgencyName!='United Nations Economic Commission for Europe') ) and ( not(@listAgencyID!='6') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AWG&#x7f;AZM&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYR&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;CRC&#x7f;CUP&#x7f;CVE&#x7f;CYP&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EEK&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GEL&#x7f;GHC&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LTL&#x7f;LVL&#x7f;LYD&#x7f;MAD&#x7f;MDL&#x7f;MGF&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRO&#x7f;MTL&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MYR&#x7f;MZM&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;ROL&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDD&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SIT&#x7f;SKK&#x7f;SLL&#x7f;SOS&#x7f;SRG&#x7f;STD&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMM&#x7f;TND&#x7f;TOP&#x7f;TRL&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;UYU&#x7f;UZS&#x7f;VEB&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPT&#x7f;YER&#x7f;YUM&#x7f;ZAR&#x7f;ZMK&#x7f;ZWD&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Currency Code') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2012-01-12') ) and ( not(@listSchemeURI!='urn:un:unece:uncefact:codelist:standard:5:ISO42173A') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CurrencyCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYR&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LTL&#x7f;LVL&#x7f;LYD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRO&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STD&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USN&#x7f;USS&#x7f;UYI&#x7f;UYU&#x7f;UZS&#x7f;VEF&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XDR&#x7f;XFU&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZMK&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Currency Code') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2018-01-01') ) and ( not(@listSchemeURI!='urn:iso:std:iso:4217') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CurrencyCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UZS&#x7f;VEF&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Currency Code') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2018-08-29') ) and ( not(@listSchemeURI!='urn:iso:std:iso:4217') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CurrencyCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UYW&#x7f;UZS&#x7f;VES&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Currency Code') ) and ( not(@listID!='ISO 4217 Alpha') ) and ( not(@listVersionID!='2018-08-29') ) and ( not(@listSchemeURI!='urn:iso:std:iso:4217') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/CurrencyCode-2.1.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AED&#x7f;AFN&#x7f;ALL&#x7f;AMD&#x7f;ANG&#x7f;ANG&#x7f;AOA&#x7f;ARS&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AUD&#x7f;AWG&#x7f;AZN&#x7f;BAM&#x7f;BBD&#x7f;BDT&#x7f;BGN&#x7f;BHD&#x7f;BIF&#x7f;BMD&#x7f;BND&#x7f;BOB&#x7f;BOV&#x7f;BRL&#x7f;BSD&#x7f;BTN&#x7f;BWP&#x7f;BYN&#x7f;BZD&#x7f;CAD&#x7f;CDF&#x7f;CHE&#x7f;CHF&#x7f;CHF&#x7f;CHW&#x7f;CLF&#x7f;CLP&#x7f;CNY&#x7f;COP&#x7f;COU&#x7f;CRC&#x7f;CUC&#x7f;CUP&#x7f;CVE&#x7f;CZK&#x7f;DJF&#x7f;DKK&#x7f;DKK&#x7f;DKK&#x7f;DOP&#x7f;DZD&#x7f;EGP&#x7f;ERN&#x7f;ETB&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;EUR&#x7f;FJD&#x7f;FKP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GBP&#x7f;GEL&#x7f;GHS&#x7f;GIP&#x7f;GMD&#x7f;GNF&#x7f;GTQ&#x7f;GYD&#x7f;HKD&#x7f;HNL&#x7f;HRK&#x7f;HTG&#x7f;HUF&#x7f;IDR&#x7f;ILS&#x7f;INR&#x7f;INR&#x7f;IQD&#x7f;IRR&#x7f;ISK&#x7f;JMD&#x7f;JOD&#x7f;JPY&#x7f;KES&#x7f;KGS&#x7f;KHR&#x7f;KMF&#x7f;KPW&#x7f;KRW&#x7f;KWD&#x7f;KYD&#x7f;KZT&#x7f;LAK&#x7f;LBP&#x7f;LKR&#x7f;LRD&#x7f;LSL&#x7f;LYD&#x7f;MAD&#x7f;MAD&#x7f;MDL&#x7f;MGA&#x7f;MKD&#x7f;MMK&#x7f;MNT&#x7f;MOP&#x7f;MRU&#x7f;MUR&#x7f;MVR&#x7f;MWK&#x7f;MXN&#x7f;MXV&#x7f;MYR&#x7f;MZN&#x7f;NAD&#x7f;NGN&#x7f;NIO&#x7f;NOK&#x7f;NOK&#x7f;NOK&#x7f;NPR&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;NZD&#x7f;OMR&#x7f;PAB&#x7f;PEN&#x7f;PGK&#x7f;PHP&#x7f;PKR&#x7f;PLN&#x7f;PYG&#x7f;QAR&#x7f;RON&#x7f;RSD&#x7f;RUB&#x7f;RWF&#x7f;SAR&#x7f;SBD&#x7f;SCR&#x7f;SDG&#x7f;SEK&#x7f;SGD&#x7f;SHP&#x7f;SLL&#x7f;SOS&#x7f;SRD&#x7f;SSP&#x7f;STN&#x7f;SVC&#x7f;SYP&#x7f;SZL&#x7f;THB&#x7f;TJS&#x7f;TMT&#x7f;TND&#x7f;TOP&#x7f;TRY&#x7f;TTD&#x7f;TWD&#x7f;TZS&#x7f;UAH&#x7f;UGX&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USD&#x7f;USN&#x7f;UYI&#x7f;UYU&#x7f;UYW&#x7f;UZS&#x7f;VES&#x7f;VND&#x7f;VUV&#x7f;WST&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAF&#x7f;XAG&#x7f;XAU&#x7f;XBA&#x7f;XBB&#x7f;XBC&#x7f;XBD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XCD&#x7f;XDR&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XOF&#x7f;XPD&#x7f;XPF&#x7f;XPF&#x7f;XPF&#x7f;XPT&#x7f;XSU&#x7f;XTS&#x7f;XUA&#x7f;XXX&#x7f;YER&#x7f;ZAR&#x7f;ZAR&#x7f;ZAR&#x7f;ZMW&#x7f;ZWL&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'Currency-2.0 Currency-2.1 Currency-2.2 Currency-2.3 Currency-2.4' in the context 'cbc:CurrencyCode | cbc:DocumentCurrencyCode | cbc:PaymentAlternativeCurrencyCode | cbc:PaymentCurrencyCode | cbc:PricingCurrencyCode | cbc:RequestedInvoiceCurrencyCode | cbc:SourceCurrencyCode | cbc:TargetCurrencyCode | cbc:TaxCurrencyCode | cbc:ValueCurrencyCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:DocumentStatusCode" priority="14" mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:DocumentStatusCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:DocumentStatusCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:DocumentStatusCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(@listName!='Document Status') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.0') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:DocumentStatusCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/DocumentStatusCode-2.0.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;Cancelled&#x7f;Disputed&#x7f;NoStatus&#x7f;Revised&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Document Status Code') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.1') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:DocumentStatusCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/DocumentStatusCode-2.1.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;Cancelled&#x7f;Disputed&#x7f;NoStatus&#x7f;Revised&#x7f;Confirmed&#x7f;NotConfirmed&#x7f;Rejected&#x7f;Completed&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(@listName!='Document Status') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.0') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:DocumentStatusCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/DocumentStatusCode-2.0.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;Cancelled&#x7f;Disputed&#x7f;NoStatus&#x7f;Revised&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Document Status Code') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.1') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:DocumentStatusCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.1/cl/gc/default/DocumentStatusCode-2.1.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;Cancelled&#x7f;Disputed&#x7f;NoStatus&#x7f;Revised&#x7f;Confirmed&#x7f;NotConfirmed&#x7f;Rejected&#x7f;Completed&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'DocumentStatus-2.0 DocumentStatus-2.1' in the context 'cbc:DocumentStatusCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:LocaleCode | cbc:NoticeLanguageCode | cbc:PreferredLanguageLocaleCode | cbc:TenderLanguageLocaleCode"
                 priority="13"
                 mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:LocaleCode | cbc:NoticeLanguageCode | cbc:PreferredLanguageLocaleCode | cbc:TenderLanguageLocaleCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:LocaleCode | cbc:NoticeLanguageCode | cbc:PreferredLanguageLocaleCode | cbc:TenderLanguageLocaleCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:LocaleCode | cbc:NoticeLanguageCode | cbc:PreferredLanguageLocaleCode | cbc:TenderLanguageLocaleCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(@listName!='Language Code') ) and ( not(@listID!='ISO 639') ) and ( not(@listVersionID!='2018-02-14') ) and ( not(@listSchemeURI!='urn:iso:std:iso:639') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.2/cl/gc/default/LanguageCode-2.2.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AA&#x7f;AAR&#x7f;AB&#x7f;ABK&#x7f;ACE&#x7f;ACH&#x7f;ADA&#x7f;ADY&#x7f;AE&#x7f;AF&#x7f;AFA&#x7f;AFH&#x7f;AFR&#x7f;AIN&#x7f;AK&#x7f;AKA&#x7f;AKK&#x7f;ALB (B) SQI (T)&#x7f;ALB (B) SQI (T)&#x7f;ALE&#x7f;ALG&#x7f;ALT&#x7f;AM&#x7f;AMH&#x7f;AN&#x7f;ANG&#x7f;ANP&#x7f;APA&#x7f;AR&#x7f;ARA&#x7f;ARC&#x7f;ARG&#x7f;ARM (B) HYE (T)&#x7f;ARM (B) HYE (T)&#x7f;ARN&#x7f;ARP&#x7f;ART&#x7f;ARW&#x7f;AS&#x7f;ASM&#x7f;AST&#x7f;ATH&#x7f;AUS&#x7f;AV&#x7f;AVA&#x7f;AVE&#x7f;AWA&#x7f;AY&#x7f;AYM&#x7f;AZ&#x7f;AZE&#x7f;BA&#x7f;BAD&#x7f;BAI&#x7f;BAK&#x7f;BAL&#x7f;BAM&#x7f;BAN&#x7f;BAQ (B) EUS (T)&#x7f;BAQ (B) EUS (T)&#x7f;BAS&#x7f;BAT&#x7f;BE&#x7f;BEJ&#x7f;BEL&#x7f;BEM&#x7f;BEN&#x7f;BER&#x7f;BG&#x7f;BH&#x7f;BHO&#x7f;BI&#x7f;BIH&#x7f;BIK&#x7f;BIN&#x7f;BIS&#x7f;BLA&#x7f;BM&#x7f;BN&#x7f;BNT&#x7f;BO&#x7f;BO&#x7f;BOS&#x7f;BR&#x7f;BRA&#x7f;BRE&#x7f;BS&#x7f;BTK&#x7f;BUA&#x7f;BUG&#x7f;BUL&#x7f;BUR (B) MYA (T)&#x7f;BUR (B) MYA (T)&#x7f;BYN&#x7f;CA&#x7f;CAD&#x7f;CAI&#x7f;CAR&#x7f;CAT&#x7f;CAU&#x7f;CE&#x7f;CEB&#x7f;CEL&#x7f;CH&#x7f;CHA&#x7f;CHB&#x7f;CHE&#x7f;CHG&#x7f;CHI (B) ZHO (T)&#x7f;CHI (B) ZHO (T)&#x7f;CHK&#x7f;CHM&#x7f;CHN&#x7f;CHO&#x7f;CHP&#x7f;CHR&#x7f;CHU&#x7f;CHV&#x7f;CHY&#x7f;CMC&#x7f;CNR&#x7f;CO&#x7f;COP&#x7f;COR&#x7f;COS&#x7f;CPE&#x7f;CPF&#x7f;CPP&#x7f;CR&#x7f;CRE&#x7f;CRH&#x7f;CRP&#x7f;CS&#x7f;CS&#x7f;CSB&#x7f;CU&#x7f;CUS&#x7f;CV&#x7f;CY&#x7f;CY&#x7f;CZE (B) CES (T)&#x7f;CZE (B) CES (T)&#x7f;DA&#x7f;DAK&#x7f;DAN&#x7f;DAR&#x7f;DAY&#x7f;DE&#x7f;DE&#x7f;DEL&#x7f;DEN&#x7f;DGR&#x7f;DIN&#x7f;DIV&#x7f;DOI&#x7f;DRA&#x7f;DSB&#x7f;DUA&#x7f;DUM&#x7f;DUT (B) NLD (T)&#x7f;DUT (B) NLD (T)&#x7f;DV&#x7f;DYU&#x7f;DZ&#x7f;DZO&#x7f;EE&#x7f;EFI&#x7f;EGY&#x7f;EKA&#x7f;EL&#x7f;EL&#x7f;ELX&#x7f;EN&#x7f;ENG&#x7f;ENM&#x7f;EO&#x7f;EPO&#x7f;ES&#x7f;EST&#x7f;ET&#x7f;EU&#x7f;EU&#x7f;EWE&#x7f;EWO&#x7f;FA&#x7f;FA&#x7f;FAN&#x7f;FAO&#x7f;FAT&#x7f;FF&#x7f;FI&#x7f;FIJ&#x7f;FIL&#x7f;FIN&#x7f;FIU&#x7f;FJ&#x7f;FO&#x7f;FON&#x7f;FR&#x7f;FR&#x7f;FRE (B) FRA (T)&#x7f;FRE (B) FRA (T)&#x7f;FRM&#x7f;FRO&#x7f;FRR&#x7f;FRS&#x7f;FRY&#x7f;FUL&#x7f;FUR&#x7f;FY&#x7f;GA&#x7f;GAA&#x7f;GAY&#x7f;GBA&#x7f;GD&#x7f;GEM&#x7f;GEO (B) KAT (T)&#x7f;GEO (B) KAT (T)&#x7f;GER (B) DEU (T)&#x7f;GER (B) DEU (T)&#x7f;GEZ&#x7f;GIL&#x7f;GL&#x7f;GLA&#x7f;GLE&#x7f;GLG&#x7f;GLV&#x7f;GMH&#x7f;GN&#x7f;GOH&#x7f;GON&#x7f;GOR&#x7f;GOT&#x7f;GRB&#x7f;GRC&#x7f;GRE (B) ELL (T)&#x7f;GRE (B) ELL (T)&#x7f;GRN&#x7f;GSW&#x7f;GU&#x7f;GUJ&#x7f;GV&#x7f;GWI&#x7f;HA&#x7f;HAI&#x7f;HAT&#x7f;HAU&#x7f;HAW&#x7f;HE&#x7f;HEB&#x7f;HER&#x7f;HI&#x7f;HIL&#x7f;HIM&#x7f;HIN&#x7f;HIT&#x7f;HMN&#x7f;HMO&#x7f;HO&#x7f;HR&#x7f;HRV&#x7f;HSB&#x7f;HT&#x7f;HU&#x7f;HUN&#x7f;HUP&#x7f;HY&#x7f;HY&#x7f;HZ&#x7f;IA&#x7f;IBA&#x7f;IBO&#x7f;ICE (B) ISL (T)&#x7f;ICE (B) ISL (T)&#x7f;ID&#x7f;IDO&#x7f;IE&#x7f;IG&#x7f;II&#x7f;III&#x7f;IJO&#x7f;IK&#x7f;IKU&#x7f;ILE&#x7f;ILO&#x7f;INA&#x7f;INC&#x7f;IND&#x7f;INE&#x7f;INH&#x7f;IO&#x7f;IPK&#x7f;IRA&#x7f;IRO&#x7f;IS&#x7f;IS&#x7f;IT&#x7f;ITA&#x7f;IU&#x7f;JA&#x7f;JAV&#x7f;JBO&#x7f;JPN&#x7f;JPR&#x7f;JRB&#x7f;JV&#x7f;KA&#x7f;KA&#x7f;KAA&#x7f;KAB&#x7f;KAC&#x7f;KAL&#x7f;KAM&#x7f;KAN&#x7f;KAR&#x7f;KAS&#x7f;KAU&#x7f;KAW&#x7f;KAZ&#x7f;KBD&#x7f;KG&#x7f;KHA&#x7f;KHI&#x7f;KHM&#x7f;KHO&#x7f;KI&#x7f;KIK&#x7f;KIN&#x7f;KIR&#x7f;KJ&#x7f;KK&#x7f;KL&#x7f;KM&#x7f;KMB&#x7f;KN&#x7f;KO&#x7f;KOK&#x7f;KOM&#x7f;KON&#x7f;KOR&#x7f;KOS&#x7f;KPE&#x7f;KR&#x7f;KRC&#x7f;KRL&#x7f;KRO&#x7f;KRU&#x7f;KS&#x7f;KU&#x7f;KUA&#x7f;KUM&#x7f;KUR&#x7f;KUT&#x7f;KV&#x7f;KW&#x7f;KY&#x7f;LA&#x7f;LAD&#x7f;LAH&#x7f;LAM&#x7f;LAO&#x7f;LAT&#x7f;LAV&#x7f;LB&#x7f;LEZ&#x7f;LG&#x7f;LI&#x7f;LIM&#x7f;LIN&#x7f;LIT&#x7f;LN&#x7f;LO&#x7f;LOL&#x7f;LOZ&#x7f;LT&#x7f;LTZ&#x7f;LU&#x7f;LUA&#x7f;LUB&#x7f;LUG&#x7f;LUI&#x7f;LUN&#x7f;LUO&#x7f;LUS&#x7f;LV&#x7f;MAC (B) MKD (T)&#x7f;MAC (B) MKD (T)&#x7f;MAD&#x7f;MAG&#x7f;MAH&#x7f;MAI&#x7f;MAK&#x7f;MAL&#x7f;MAN&#x7f;MAO (B) MRI (T)&#x7f;MAO (B) MRI (T)&#x7f;MAP&#x7f;MAR&#x7f;MAS&#x7f;MAY (B) MSA (T)&#x7f;MAY (B) MSA (T)&#x7f;MDF&#x7f;MDR&#x7f;MEN&#x7f;MG&#x7f;MGA&#x7f;MH&#x7f;MI&#x7f;MI&#x7f;MIC&#x7f;MIN&#x7f;MIS&#x7f;MK&#x7f;MK&#x7f;MKH&#x7f;ML&#x7f;MLG&#x7f;MLT&#x7f;MN&#x7f;MNC&#x7f;MNI&#x7f;MNO&#x7f;MOH&#x7f;MON&#x7f;MOS&#x7f;MR&#x7f;MS&#x7f;MS&#x7f;MT&#x7f;MUL&#x7f;MUN&#x7f;MUS&#x7f;MWL&#x7f;MWR&#x7f;MY&#x7f;MY&#x7f;MYN&#x7f;MYV&#x7f;NA&#x7f;NAH&#x7f;NAI&#x7f;NAP&#x7f;NAU&#x7f;NAV&#x7f;NB&#x7f;NBL&#x7f;ND&#x7f;NDE&#x7f;NDO&#x7f;NDS&#x7f;NE&#x7f;NEP&#x7f;NEW&#x7f;NG&#x7f;NIA&#x7f;NIC&#x7f;NIU&#x7f;NL&#x7f;NL&#x7f;NN&#x7f;NNO&#x7f;NO&#x7f;NOB&#x7f;NOG&#x7f;NON&#x7f;NOR&#x7f;NQO&#x7f;NR&#x7f;NSO&#x7f;NUB&#x7f;NV&#x7f;NWC&#x7f;NY&#x7f;NYA&#x7f;NYM&#x7f;NYN&#x7f;NYO&#x7f;NZI&#x7f;OC&#x7f;OCI&#x7f;OJ&#x7f;OJI&#x7f;OM&#x7f;OR&#x7f;ORI&#x7f;ORM&#x7f;OS&#x7f;OSA&#x7f;OSS&#x7f;OTA&#x7f;OTO&#x7f;PA&#x7f;PAA&#x7f;PAG&#x7f;PAL&#x7f;PAM&#x7f;PAN&#x7f;PAP&#x7f;PAU&#x7f;PEO&#x7f;PER (B) FAS (T)&#x7f;PER (B) FAS (T)&#x7f;PHI&#x7f;PHN&#x7f;PI&#x7f;PL&#x7f;PLI&#x7f;POL&#x7f;PON&#x7f;POR&#x7f;PRA&#x7f;PRO&#x7f;PS&#x7f;PT&#x7f;PUS&#x7f;QAA-QTZ&#x7f;QU&#x7f;QUE&#x7f;RAJ&#x7f;RAP&#x7f;RAR&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RO&#x7f;ROA&#x7f;ROH&#x7f;ROM&#x7f;RU&#x7f;RUM (B) RON (T)&#x7f;RUM (B) RON (T)&#x7f;RUN&#x7f;RUP&#x7f;RUS&#x7f;RW&#x7f;SA&#x7f;SAD&#x7f;SAG&#x7f;SAH&#x7f;SAI&#x7f;SAL&#x7f;SAM&#x7f;SAN&#x7f;SAS&#x7f;SAT&#x7f;SC&#x7f;SCN&#x7f;SCO&#x7f;SD&#x7f;SE&#x7f;SEL&#x7f;SEM&#x7f;SG&#x7f;SGA&#x7f;SGN&#x7f;SHN&#x7f;SI&#x7f;SID&#x7f;SIN&#x7f;SIO&#x7f;SIT&#x7f;SK&#x7f;SK&#x7f;SL&#x7f;SLA&#x7f;SLO (B) SLK (T)&#x7f;SLO (B) SLK (T)&#x7f;SLV&#x7f;SM&#x7f;SMA&#x7f;SME&#x7f;SMI&#x7f;SMJ&#x7f;SMN&#x7f;SMO&#x7f;SMS&#x7f;SN&#x7f;SNA&#x7f;SND&#x7f;SNK&#x7f;SO&#x7f;SOG&#x7f;SOM&#x7f;SON&#x7f;SOT&#x7f;SPA&#x7f;SQ&#x7f;SQ&#x7f;SR&#x7f;SRD&#x7f;SRN&#x7f;SRP&#x7f;SRR&#x7f;SS&#x7f;SSA&#x7f;SSW&#x7f;ST&#x7f;SU&#x7f;SUK&#x7f;SUN&#x7f;SUS&#x7f;SUX&#x7f;SV&#x7f;SW&#x7f;SWA&#x7f;SWE&#x7f;SYC&#x7f;SYR&#x7f;TA&#x7f;TAH&#x7f;TAI&#x7f;TAM&#x7f;TAT&#x7f;TE&#x7f;TEL&#x7f;TEM&#x7f;TER&#x7f;TET&#x7f;TG&#x7f;TGK&#x7f;TGL&#x7f;TH&#x7f;THA&#x7f;TI&#x7f;TIB (B) BOD (T)&#x7f;TIB (B) BOD (T)&#x7f;TIG&#x7f;TIR&#x7f;TIV&#x7f;TK&#x7f;TKL&#x7f;TL&#x7f;TLH&#x7f;TLI&#x7f;TMH&#x7f;TN&#x7f;TO&#x7f;TOG&#x7f;TON&#x7f;TPI&#x7f;TR&#x7f;TS&#x7f;TSI&#x7f;TSN&#x7f;TSO&#x7f;TT&#x7f;TUK&#x7f;TUM&#x7f;TUP&#x7f;TUR&#x7f;TUT&#x7f;TVL&#x7f;TW&#x7f;TWI&#x7f;TY&#x7f;TYV&#x7f;UDM&#x7f;UG&#x7f;UGA&#x7f;UIG&#x7f;UK&#x7f;UKR&#x7f;UMB&#x7f;UND&#x7f;UR&#x7f;URD&#x7f;UZ&#x7f;UZB&#x7f;VAI&#x7f;VE&#x7f;VEN&#x7f;VI&#x7f;VIE&#x7f;VO&#x7f;VOL&#x7f;VOT&#x7f;WA&#x7f;WAK&#x7f;WAL&#x7f;WAR&#x7f;WAS&#x7f;WEL (B) CYM (T)&#x7f;WEL (B) CYM (T)&#x7f;WEN&#x7f;WLN&#x7f;WO&#x7f;WOL&#x7f;XAL&#x7f;XH&#x7f;XHO&#x7f;YAO&#x7f;YAP&#x7f;YI&#x7f;YID&#x7f;YO&#x7f;YOR&#x7f;YPK&#x7f;ZA&#x7f;ZAP&#x7f;ZBL&#x7f;ZEN&#x7f;ZGH&#x7f;ZH&#x7f;ZH&#x7f;ZHA&#x7f;ZND&#x7f;ZU&#x7f;ZUL&#x7f;ZUN&#x7f;ZXX&#x7f;ZZA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Language Code') ) and ( not(@listID!='ISO 639') ) and ( not(@listVersionID!='2020-04-17') ) and ( not(@listSchemeURI!='urn:iso:std:iso:639') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/LanguageCode-2.3.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AA&#x7f;AAR&#x7f;AB&#x7f;ABK&#x7f;ACE&#x7f;ACH&#x7f;ADA&#x7f;ADY&#x7f;AE&#x7f;AF&#x7f;AFA&#x7f;AFH&#x7f;AFR&#x7f;AIN&#x7f;AK&#x7f;AKA&#x7f;AKK&#x7f;ALB (B) SQI (T)&#x7f;ALB (B) SQI (T)&#x7f;ALE&#x7f;ALG&#x7f;ALT&#x7f;AM&#x7f;AMH&#x7f;AN&#x7f;ANG&#x7f;ANP&#x7f;APA&#x7f;AR&#x7f;ARA&#x7f;ARC&#x7f;ARG&#x7f;ARM (B) HYE (T)&#x7f;ARM (B) HYE (T)&#x7f;ARN&#x7f;ARP&#x7f;ART&#x7f;ARW&#x7f;AS&#x7f;ASM&#x7f;AST&#x7f;ATH&#x7f;AUS&#x7f;AV&#x7f;AVA&#x7f;AVE&#x7f;AWA&#x7f;AY&#x7f;AYM&#x7f;AZ&#x7f;AZE&#x7f;BA&#x7f;BAD&#x7f;BAI&#x7f;BAK&#x7f;BAL&#x7f;BAM&#x7f;BAN&#x7f;BAQ (B) EUS (T)&#x7f;BAQ (B) EUS (T)&#x7f;BAS&#x7f;BAT&#x7f;BE&#x7f;BEJ&#x7f;BEL&#x7f;BEM&#x7f;BEN&#x7f;BER&#x7f;BG&#x7f;BH&#x7f;BHO&#x7f;BI&#x7f;BIH&#x7f;BIK&#x7f;BIN&#x7f;BIS&#x7f;BLA&#x7f;BM&#x7f;BN&#x7f;BNT&#x7f;BO&#x7f;BO&#x7f;BOS&#x7f;BR&#x7f;BRA&#x7f;BRE&#x7f;BS&#x7f;BTK&#x7f;BUA&#x7f;BUG&#x7f;BUL&#x7f;BUR (B) MYA (T)&#x7f;BUR (B) MYA (T)&#x7f;BYN&#x7f;CA&#x7f;CAD&#x7f;CAI&#x7f;CAR&#x7f;CAT&#x7f;CAU&#x7f;CE&#x7f;CEB&#x7f;CEL&#x7f;CH&#x7f;CHA&#x7f;CHB&#x7f;CHE&#x7f;CHG&#x7f;CHI (B) ZHO (T)&#x7f;CHI (B) ZHO (T)&#x7f;CHK&#x7f;CHM&#x7f;CHN&#x7f;CHO&#x7f;CHP&#x7f;CHR&#x7f;CHU&#x7f;CHV&#x7f;CHY&#x7f;CMC&#x7f;CNR&#x7f;CO&#x7f;COP&#x7f;COR&#x7f;COS&#x7f;CPE&#x7f;CPF&#x7f;CPP&#x7f;CR&#x7f;CRE&#x7f;CRH&#x7f;CRP&#x7f;CS&#x7f;CS&#x7f;CSB&#x7f;CU&#x7f;CUS&#x7f;CV&#x7f;CY&#x7f;CY&#x7f;CZE (B) CES (T)&#x7f;CZE (B) CES (T)&#x7f;DA&#x7f;DAK&#x7f;DAN&#x7f;DAR&#x7f;DAY&#x7f;DE&#x7f;DE&#x7f;DEL&#x7f;DEN&#x7f;DGR&#x7f;DIN&#x7f;DIV&#x7f;DOI&#x7f;DRA&#x7f;DSB&#x7f;DUA&#x7f;DUM&#x7f;DUT (B) NLD (T)&#x7f;DUT (B) NLD (T)&#x7f;DV&#x7f;DYU&#x7f;DZ&#x7f;DZO&#x7f;EE&#x7f;EFI&#x7f;EGY&#x7f;EKA&#x7f;EL&#x7f;EL&#x7f;ELX&#x7f;EN&#x7f;ENG&#x7f;ENM&#x7f;EO&#x7f;EPO&#x7f;ES&#x7f;EST&#x7f;ET&#x7f;EU&#x7f;EU&#x7f;EWE&#x7f;EWO&#x7f;FA&#x7f;FA&#x7f;FAN&#x7f;FAO&#x7f;FAT&#x7f;FF&#x7f;FI&#x7f;FIJ&#x7f;FIL&#x7f;FIN&#x7f;FIU&#x7f;FJ&#x7f;FO&#x7f;FON&#x7f;FR&#x7f;FR&#x7f;FRE (B) FRA (T)&#x7f;FRE (B) FRA (T)&#x7f;FRM&#x7f;FRO&#x7f;FRR&#x7f;FRS&#x7f;FRY&#x7f;FUL&#x7f;FUR&#x7f;FY&#x7f;GA&#x7f;GAA&#x7f;GAY&#x7f;GBA&#x7f;GD&#x7f;GEM&#x7f;GEO (B) KAT (T)&#x7f;GEO (B) KAT (T)&#x7f;GER (B) DEU (T)&#x7f;GER (B) DEU (T)&#x7f;GEZ&#x7f;GIL&#x7f;GL&#x7f;GLA&#x7f;GLE&#x7f;GLG&#x7f;GLV&#x7f;GMH&#x7f;GN&#x7f;GOH&#x7f;GON&#x7f;GOR&#x7f;GOT&#x7f;GRB&#x7f;GRC&#x7f;GRE (B) ELL (T)&#x7f;GRE (B) ELL (T)&#x7f;GRN&#x7f;GSW&#x7f;GU&#x7f;GUJ&#x7f;GV&#x7f;GWI&#x7f;HA&#x7f;HAI&#x7f;HAT&#x7f;HAU&#x7f;HAW&#x7f;HE&#x7f;HEB&#x7f;HER&#x7f;HI&#x7f;HIL&#x7f;HIM&#x7f;HIN&#x7f;HIT&#x7f;HMN&#x7f;HMO&#x7f;HO&#x7f;HR&#x7f;HRV&#x7f;HSB&#x7f;HT&#x7f;HU&#x7f;HUN&#x7f;HUP&#x7f;HY&#x7f;HY&#x7f;HZ&#x7f;IA&#x7f;IBA&#x7f;IBO&#x7f;ICE (B) ISL (T)&#x7f;ICE (B) ISL (T)&#x7f;ID&#x7f;IDO&#x7f;IE&#x7f;IG&#x7f;II&#x7f;III&#x7f;IJO&#x7f;IK&#x7f;IKU&#x7f;ILE&#x7f;ILO&#x7f;INA&#x7f;INC&#x7f;IND&#x7f;INE&#x7f;INH&#x7f;IO&#x7f;IPK&#x7f;IRA&#x7f;IRO&#x7f;IS&#x7f;IS&#x7f;IT&#x7f;ITA&#x7f;IU&#x7f;JA&#x7f;JAV&#x7f;JBO&#x7f;JPN&#x7f;JPR&#x7f;JRB&#x7f;JV&#x7f;KA&#x7f;KA&#x7f;KAA&#x7f;KAB&#x7f;KAC&#x7f;KAL&#x7f;KAM&#x7f;KAN&#x7f;KAR&#x7f;KAS&#x7f;KAU&#x7f;KAW&#x7f;KAZ&#x7f;KBD&#x7f;KG&#x7f;KHA&#x7f;KHI&#x7f;KHM&#x7f;KHO&#x7f;KI&#x7f;KIK&#x7f;KIN&#x7f;KIR&#x7f;KJ&#x7f;KK&#x7f;KL&#x7f;KM&#x7f;KMB&#x7f;KN&#x7f;KO&#x7f;KOK&#x7f;KOM&#x7f;KON&#x7f;KOR&#x7f;KOS&#x7f;KPE&#x7f;KR&#x7f;KRC&#x7f;KRL&#x7f;KRO&#x7f;KRU&#x7f;KS&#x7f;KU&#x7f;KUA&#x7f;KUM&#x7f;KUR&#x7f;KUT&#x7f;KV&#x7f;KW&#x7f;KY&#x7f;LA&#x7f;LAD&#x7f;LAH&#x7f;LAM&#x7f;LAO&#x7f;LAT&#x7f;LAV&#x7f;LB&#x7f;LEZ&#x7f;LG&#x7f;LI&#x7f;LIM&#x7f;LIN&#x7f;LIT&#x7f;LN&#x7f;LO&#x7f;LOL&#x7f;LOZ&#x7f;LT&#x7f;LTZ&#x7f;LU&#x7f;LUA&#x7f;LUB&#x7f;LUG&#x7f;LUI&#x7f;LUN&#x7f;LUO&#x7f;LUS&#x7f;LV&#x7f;MAC (B) MKD (T)&#x7f;MAC (B) MKD (T)&#x7f;MAD&#x7f;MAG&#x7f;MAH&#x7f;MAI&#x7f;MAK&#x7f;MAL&#x7f;MAN&#x7f;MAO (B) MRI (T)&#x7f;MAO (B) MRI (T)&#x7f;MAP&#x7f;MAR&#x7f;MAS&#x7f;MAY (B) MSA (T)&#x7f;MAY (B) MSA (T)&#x7f;MDF&#x7f;MDR&#x7f;MEN&#x7f;MG&#x7f;MGA&#x7f;MH&#x7f;MI&#x7f;MI&#x7f;MIC&#x7f;MIN&#x7f;MIS&#x7f;MK&#x7f;MK&#x7f;MKH&#x7f;ML&#x7f;MLG&#x7f;MLT&#x7f;MN&#x7f;MNC&#x7f;MNI&#x7f;MNO&#x7f;MOH&#x7f;MON&#x7f;MOS&#x7f;MR&#x7f;MS&#x7f;MS&#x7f;MT&#x7f;MUL&#x7f;MUN&#x7f;MUS&#x7f;MWL&#x7f;MWR&#x7f;MY&#x7f;MY&#x7f;MYN&#x7f;MYV&#x7f;NA&#x7f;NAH&#x7f;NAI&#x7f;NAP&#x7f;NAU&#x7f;NAV&#x7f;NB&#x7f;NBL&#x7f;ND&#x7f;NDE&#x7f;NDO&#x7f;NDS&#x7f;NE&#x7f;NEP&#x7f;NEW&#x7f;NG&#x7f;NIA&#x7f;NIC&#x7f;NIU&#x7f;NL&#x7f;NL&#x7f;NN&#x7f;NNO&#x7f;NO&#x7f;NOB&#x7f;NOG&#x7f;NON&#x7f;NOR&#x7f;NQO&#x7f;NR&#x7f;NSO&#x7f;NUB&#x7f;NV&#x7f;NWC&#x7f;NY&#x7f;NYA&#x7f;NYM&#x7f;NYN&#x7f;NYO&#x7f;NZI&#x7f;OC&#x7f;OCI&#x7f;OJ&#x7f;OJI&#x7f;OM&#x7f;OR&#x7f;ORI&#x7f;ORM&#x7f;OS&#x7f;OSA&#x7f;OSS&#x7f;OTA&#x7f;OTO&#x7f;PA&#x7f;PAA&#x7f;PAG&#x7f;PAL&#x7f;PAM&#x7f;PAN&#x7f;PAP&#x7f;PAU&#x7f;PEO&#x7f;PER (B) FAS (T)&#x7f;PER (B) FAS (T)&#x7f;PHI&#x7f;PHN&#x7f;PI&#x7f;PL&#x7f;PLI&#x7f;POL&#x7f;PON&#x7f;POR&#x7f;PRA&#x7f;PRO&#x7f;PS&#x7f;PT&#x7f;PUS&#x7f;QAA-QTZ&#x7f;QU&#x7f;QUE&#x7f;RAJ&#x7f;RAP&#x7f;RAR&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RO&#x7f;ROA&#x7f;ROH&#x7f;ROM&#x7f;RU&#x7f;RUM (B) RON (T)&#x7f;RUM (B) RON (T)&#x7f;RUN&#x7f;RUP&#x7f;RUS&#x7f;RW&#x7f;SA&#x7f;SAD&#x7f;SAG&#x7f;SAH&#x7f;SAI&#x7f;SAL&#x7f;SAM&#x7f;SAN&#x7f;SAS&#x7f;SAT&#x7f;SC&#x7f;SCN&#x7f;SCO&#x7f;SD&#x7f;SE&#x7f;SEL&#x7f;SEM&#x7f;SG&#x7f;SGA&#x7f;SGN&#x7f;SHN&#x7f;SI&#x7f;SID&#x7f;SIN&#x7f;SIO&#x7f;SIT&#x7f;SK&#x7f;SK&#x7f;SL&#x7f;SLA&#x7f;SLO (B) SLK (T)&#x7f;SLO (B) SLK (T)&#x7f;SLV&#x7f;SM&#x7f;SMA&#x7f;SME&#x7f;SMI&#x7f;SMJ&#x7f;SMN&#x7f;SMO&#x7f;SMS&#x7f;SN&#x7f;SNA&#x7f;SND&#x7f;SNK&#x7f;SO&#x7f;SOG&#x7f;SOM&#x7f;SON&#x7f;SOT&#x7f;SPA&#x7f;SQ&#x7f;SQ&#x7f;SR&#x7f;SRD&#x7f;SRN&#x7f;SRP&#x7f;SRR&#x7f;SS&#x7f;SSA&#x7f;SSW&#x7f;ST&#x7f;SU&#x7f;SUK&#x7f;SUN&#x7f;SUS&#x7f;SUX&#x7f;SV&#x7f;SW&#x7f;SWA&#x7f;SWE&#x7f;SYC&#x7f;SYR&#x7f;TA&#x7f;TAH&#x7f;TAI&#x7f;TAM&#x7f;TAT&#x7f;TE&#x7f;TEL&#x7f;TEM&#x7f;TER&#x7f;TET&#x7f;TG&#x7f;TGK&#x7f;TGL&#x7f;TH&#x7f;THA&#x7f;TI&#x7f;TIB (B) BOD (T)&#x7f;TIB (B) BOD (T)&#x7f;TIG&#x7f;TIR&#x7f;TIV&#x7f;TK&#x7f;TKL&#x7f;TL&#x7f;TLH&#x7f;TLI&#x7f;TMH&#x7f;TN&#x7f;TO&#x7f;TOG&#x7f;TON&#x7f;TPI&#x7f;TR&#x7f;TS&#x7f;TSI&#x7f;TSN&#x7f;TSO&#x7f;TT&#x7f;TUK&#x7f;TUM&#x7f;TUP&#x7f;TUR&#x7f;TUT&#x7f;TVL&#x7f;TW&#x7f;TWI&#x7f;TY&#x7f;TYV&#x7f;UDM&#x7f;UG&#x7f;UGA&#x7f;UIG&#x7f;UK&#x7f;UKR&#x7f;UMB&#x7f;UND&#x7f;UR&#x7f;URD&#x7f;UZ&#x7f;UZB&#x7f;VAI&#x7f;VE&#x7f;VEN&#x7f;VI&#x7f;VIE&#x7f;VO&#x7f;VOL&#x7f;VOT&#x7f;WA&#x7f;WAK&#x7f;WAL&#x7f;WAR&#x7f;WAS&#x7f;WEL (B) CYM (T)&#x7f;WEL (B) CYM (T)&#x7f;WEN&#x7f;WLN&#x7f;WO&#x7f;WOL&#x7f;XAL&#x7f;XH&#x7f;XHO&#x7f;YAO&#x7f;YAP&#x7f;YI&#x7f;YID&#x7f;YO&#x7f;YOR&#x7f;YPK&#x7f;ZA&#x7f;ZAP&#x7f;ZBL&#x7f;ZEN&#x7f;ZGH&#x7f;ZH&#x7f;ZH&#x7f;ZHA&#x7f;ZND&#x7f;ZU&#x7f;ZUL&#x7f;ZUN&#x7f;ZXX&#x7f;ZZA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Language Code') ) and ( not(@listID!='ISO 639') ) and ( not(@listVersionID!='2020-04-17') ) and ( not(@listSchemeURI!='urn:iso:std:iso:639') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/LanguageCode-2.3.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AA&#x7f;AAR&#x7f;AB&#x7f;ABK&#x7f;ACE&#x7f;ACH&#x7f;ADA&#x7f;ADY&#x7f;AE&#x7f;AF&#x7f;AFA&#x7f;AFH&#x7f;AFR&#x7f;AIN&#x7f;AK&#x7f;AKA&#x7f;AKK&#x7f;ALB (B) SQI (T)&#x7f;ALB (B) SQI (T)&#x7f;ALE&#x7f;ALG&#x7f;ALT&#x7f;AM&#x7f;AMH&#x7f;AN&#x7f;ANG&#x7f;ANP&#x7f;APA&#x7f;AR&#x7f;ARA&#x7f;ARC&#x7f;ARG&#x7f;ARM (B) HYE (T)&#x7f;ARM (B) HYE (T)&#x7f;ARN&#x7f;ARP&#x7f;ART&#x7f;ARW&#x7f;AS&#x7f;ASM&#x7f;AST&#x7f;ATH&#x7f;AUS&#x7f;AV&#x7f;AVA&#x7f;AVE&#x7f;AWA&#x7f;AY&#x7f;AYM&#x7f;AZ&#x7f;AZE&#x7f;BA&#x7f;BAD&#x7f;BAI&#x7f;BAK&#x7f;BAL&#x7f;BAM&#x7f;BAN&#x7f;BAQ (B) EUS (T)&#x7f;BAQ (B) EUS (T)&#x7f;BAS&#x7f;BAT&#x7f;BE&#x7f;BEJ&#x7f;BEL&#x7f;BEM&#x7f;BEN&#x7f;BER&#x7f;BG&#x7f;BH&#x7f;BHO&#x7f;BI&#x7f;BIH&#x7f;BIK&#x7f;BIN&#x7f;BIS&#x7f;BLA&#x7f;BM&#x7f;BN&#x7f;BNT&#x7f;BO&#x7f;BO&#x7f;BOS&#x7f;BR&#x7f;BRA&#x7f;BRE&#x7f;BS&#x7f;BTK&#x7f;BUA&#x7f;BUG&#x7f;BUL&#x7f;BUR (B) MYA (T)&#x7f;BUR (B) MYA (T)&#x7f;BYN&#x7f;CA&#x7f;CAD&#x7f;CAI&#x7f;CAR&#x7f;CAT&#x7f;CAU&#x7f;CE&#x7f;CEB&#x7f;CEL&#x7f;CH&#x7f;CHA&#x7f;CHB&#x7f;CHE&#x7f;CHG&#x7f;CHI (B) ZHO (T)&#x7f;CHI (B) ZHO (T)&#x7f;CHK&#x7f;CHM&#x7f;CHN&#x7f;CHO&#x7f;CHP&#x7f;CHR&#x7f;CHU&#x7f;CHV&#x7f;CHY&#x7f;CMC&#x7f;CNR&#x7f;CO&#x7f;COP&#x7f;COR&#x7f;COS&#x7f;CPE&#x7f;CPF&#x7f;CPP&#x7f;CR&#x7f;CRE&#x7f;CRH&#x7f;CRP&#x7f;CS&#x7f;CS&#x7f;CSB&#x7f;CU&#x7f;CUS&#x7f;CV&#x7f;CY&#x7f;CY&#x7f;CZE (B) CES (T)&#x7f;CZE (B) CES (T)&#x7f;DA&#x7f;DAK&#x7f;DAN&#x7f;DAR&#x7f;DAY&#x7f;DE&#x7f;DE&#x7f;DEL&#x7f;DEN&#x7f;DGR&#x7f;DIN&#x7f;DIV&#x7f;DOI&#x7f;DRA&#x7f;DSB&#x7f;DUA&#x7f;DUM&#x7f;DUT (B) NLD (T)&#x7f;DUT (B) NLD (T)&#x7f;DV&#x7f;DYU&#x7f;DZ&#x7f;DZO&#x7f;EE&#x7f;EFI&#x7f;EGY&#x7f;EKA&#x7f;EL&#x7f;EL&#x7f;ELX&#x7f;EN&#x7f;ENG&#x7f;ENM&#x7f;EO&#x7f;EPO&#x7f;ES&#x7f;EST&#x7f;ET&#x7f;EU&#x7f;EU&#x7f;EWE&#x7f;EWO&#x7f;FA&#x7f;FA&#x7f;FAN&#x7f;FAO&#x7f;FAT&#x7f;FF&#x7f;FI&#x7f;FIJ&#x7f;FIL&#x7f;FIN&#x7f;FIU&#x7f;FJ&#x7f;FO&#x7f;FON&#x7f;FR&#x7f;FR&#x7f;FRE (B) FRA (T)&#x7f;FRE (B) FRA (T)&#x7f;FRM&#x7f;FRO&#x7f;FRR&#x7f;FRS&#x7f;FRY&#x7f;FUL&#x7f;FUR&#x7f;FY&#x7f;GA&#x7f;GAA&#x7f;GAY&#x7f;GBA&#x7f;GD&#x7f;GEM&#x7f;GEO (B) KAT (T)&#x7f;GEO (B) KAT (T)&#x7f;GER (B) DEU (T)&#x7f;GER (B) DEU (T)&#x7f;GEZ&#x7f;GIL&#x7f;GL&#x7f;GLA&#x7f;GLE&#x7f;GLG&#x7f;GLV&#x7f;GMH&#x7f;GN&#x7f;GOH&#x7f;GON&#x7f;GOR&#x7f;GOT&#x7f;GRB&#x7f;GRC&#x7f;GRE (B) ELL (T)&#x7f;GRE (B) ELL (T)&#x7f;GRN&#x7f;GSW&#x7f;GU&#x7f;GUJ&#x7f;GV&#x7f;GWI&#x7f;HA&#x7f;HAI&#x7f;HAT&#x7f;HAU&#x7f;HAW&#x7f;HE&#x7f;HEB&#x7f;HER&#x7f;HI&#x7f;HIL&#x7f;HIM&#x7f;HIN&#x7f;HIT&#x7f;HMN&#x7f;HMO&#x7f;HO&#x7f;HR&#x7f;HRV&#x7f;HSB&#x7f;HT&#x7f;HU&#x7f;HUN&#x7f;HUP&#x7f;HY&#x7f;HY&#x7f;HZ&#x7f;IA&#x7f;IBA&#x7f;IBO&#x7f;ICE (B) ISL (T)&#x7f;ICE (B) ISL (T)&#x7f;ID&#x7f;IDO&#x7f;IE&#x7f;IG&#x7f;II&#x7f;III&#x7f;IJO&#x7f;IK&#x7f;IKU&#x7f;ILE&#x7f;ILO&#x7f;INA&#x7f;INC&#x7f;IND&#x7f;INE&#x7f;INH&#x7f;IO&#x7f;IPK&#x7f;IRA&#x7f;IRO&#x7f;IS&#x7f;IS&#x7f;IT&#x7f;ITA&#x7f;IU&#x7f;JA&#x7f;JAV&#x7f;JBO&#x7f;JPN&#x7f;JPR&#x7f;JRB&#x7f;JV&#x7f;KA&#x7f;KA&#x7f;KAA&#x7f;KAB&#x7f;KAC&#x7f;KAL&#x7f;KAM&#x7f;KAN&#x7f;KAR&#x7f;KAS&#x7f;KAU&#x7f;KAW&#x7f;KAZ&#x7f;KBD&#x7f;KG&#x7f;KHA&#x7f;KHI&#x7f;KHM&#x7f;KHO&#x7f;KI&#x7f;KIK&#x7f;KIN&#x7f;KIR&#x7f;KJ&#x7f;KK&#x7f;KL&#x7f;KM&#x7f;KMB&#x7f;KN&#x7f;KO&#x7f;KOK&#x7f;KOM&#x7f;KON&#x7f;KOR&#x7f;KOS&#x7f;KPE&#x7f;KR&#x7f;KRC&#x7f;KRL&#x7f;KRO&#x7f;KRU&#x7f;KS&#x7f;KU&#x7f;KUA&#x7f;KUM&#x7f;KUR&#x7f;KUT&#x7f;KV&#x7f;KW&#x7f;KY&#x7f;LA&#x7f;LAD&#x7f;LAH&#x7f;LAM&#x7f;LAO&#x7f;LAT&#x7f;LAV&#x7f;LB&#x7f;LEZ&#x7f;LG&#x7f;LI&#x7f;LIM&#x7f;LIN&#x7f;LIT&#x7f;LN&#x7f;LO&#x7f;LOL&#x7f;LOZ&#x7f;LT&#x7f;LTZ&#x7f;LU&#x7f;LUA&#x7f;LUB&#x7f;LUG&#x7f;LUI&#x7f;LUN&#x7f;LUO&#x7f;LUS&#x7f;LV&#x7f;MAC (B) MKD (T)&#x7f;MAC (B) MKD (T)&#x7f;MAD&#x7f;MAG&#x7f;MAH&#x7f;MAI&#x7f;MAK&#x7f;MAL&#x7f;MAN&#x7f;MAO (B) MRI (T)&#x7f;MAO (B) MRI (T)&#x7f;MAP&#x7f;MAR&#x7f;MAS&#x7f;MAY (B) MSA (T)&#x7f;MAY (B) MSA (T)&#x7f;MDF&#x7f;MDR&#x7f;MEN&#x7f;MG&#x7f;MGA&#x7f;MH&#x7f;MI&#x7f;MI&#x7f;MIC&#x7f;MIN&#x7f;MIS&#x7f;MK&#x7f;MK&#x7f;MKH&#x7f;ML&#x7f;MLG&#x7f;MLT&#x7f;MN&#x7f;MNC&#x7f;MNI&#x7f;MNO&#x7f;MOH&#x7f;MON&#x7f;MOS&#x7f;MR&#x7f;MS&#x7f;MS&#x7f;MT&#x7f;MUL&#x7f;MUN&#x7f;MUS&#x7f;MWL&#x7f;MWR&#x7f;MY&#x7f;MY&#x7f;MYN&#x7f;MYV&#x7f;NA&#x7f;NAH&#x7f;NAI&#x7f;NAP&#x7f;NAU&#x7f;NAV&#x7f;NB&#x7f;NBL&#x7f;ND&#x7f;NDE&#x7f;NDO&#x7f;NDS&#x7f;NE&#x7f;NEP&#x7f;NEW&#x7f;NG&#x7f;NIA&#x7f;NIC&#x7f;NIU&#x7f;NL&#x7f;NL&#x7f;NN&#x7f;NNO&#x7f;NO&#x7f;NOB&#x7f;NOG&#x7f;NON&#x7f;NOR&#x7f;NQO&#x7f;NR&#x7f;NSO&#x7f;NUB&#x7f;NV&#x7f;NWC&#x7f;NY&#x7f;NYA&#x7f;NYM&#x7f;NYN&#x7f;NYO&#x7f;NZI&#x7f;OC&#x7f;OCI&#x7f;OJ&#x7f;OJI&#x7f;OM&#x7f;OR&#x7f;ORI&#x7f;ORM&#x7f;OS&#x7f;OSA&#x7f;OSS&#x7f;OTA&#x7f;OTO&#x7f;PA&#x7f;PAA&#x7f;PAG&#x7f;PAL&#x7f;PAM&#x7f;PAN&#x7f;PAP&#x7f;PAU&#x7f;PEO&#x7f;PER (B) FAS (T)&#x7f;PER (B) FAS (T)&#x7f;PHI&#x7f;PHN&#x7f;PI&#x7f;PL&#x7f;PLI&#x7f;POL&#x7f;PON&#x7f;POR&#x7f;PRA&#x7f;PRO&#x7f;PS&#x7f;PT&#x7f;PUS&#x7f;QAA-QTZ&#x7f;QU&#x7f;QUE&#x7f;RAJ&#x7f;RAP&#x7f;RAR&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RO&#x7f;ROA&#x7f;ROH&#x7f;ROM&#x7f;RU&#x7f;RUM (B) RON (T)&#x7f;RUM (B) RON (T)&#x7f;RUN&#x7f;RUP&#x7f;RUS&#x7f;RW&#x7f;SA&#x7f;SAD&#x7f;SAG&#x7f;SAH&#x7f;SAI&#x7f;SAL&#x7f;SAM&#x7f;SAN&#x7f;SAS&#x7f;SAT&#x7f;SC&#x7f;SCN&#x7f;SCO&#x7f;SD&#x7f;SE&#x7f;SEL&#x7f;SEM&#x7f;SG&#x7f;SGA&#x7f;SGN&#x7f;SHN&#x7f;SI&#x7f;SID&#x7f;SIN&#x7f;SIO&#x7f;SIT&#x7f;SK&#x7f;SK&#x7f;SL&#x7f;SLA&#x7f;SLO (B) SLK (T)&#x7f;SLO (B) SLK (T)&#x7f;SLV&#x7f;SM&#x7f;SMA&#x7f;SME&#x7f;SMI&#x7f;SMJ&#x7f;SMN&#x7f;SMO&#x7f;SMS&#x7f;SN&#x7f;SNA&#x7f;SND&#x7f;SNK&#x7f;SO&#x7f;SOG&#x7f;SOM&#x7f;SON&#x7f;SOT&#x7f;SPA&#x7f;SQ&#x7f;SQ&#x7f;SR&#x7f;SRD&#x7f;SRN&#x7f;SRP&#x7f;SRR&#x7f;SS&#x7f;SSA&#x7f;SSW&#x7f;ST&#x7f;SU&#x7f;SUK&#x7f;SUN&#x7f;SUS&#x7f;SUX&#x7f;SV&#x7f;SW&#x7f;SWA&#x7f;SWE&#x7f;SYC&#x7f;SYR&#x7f;TA&#x7f;TAH&#x7f;TAI&#x7f;TAM&#x7f;TAT&#x7f;TE&#x7f;TEL&#x7f;TEM&#x7f;TER&#x7f;TET&#x7f;TG&#x7f;TGK&#x7f;TGL&#x7f;TH&#x7f;THA&#x7f;TI&#x7f;TIB (B) BOD (T)&#x7f;TIB (B) BOD (T)&#x7f;TIG&#x7f;TIR&#x7f;TIV&#x7f;TK&#x7f;TKL&#x7f;TL&#x7f;TLH&#x7f;TLI&#x7f;TMH&#x7f;TN&#x7f;TO&#x7f;TOG&#x7f;TON&#x7f;TPI&#x7f;TR&#x7f;TS&#x7f;TSI&#x7f;TSN&#x7f;TSO&#x7f;TT&#x7f;TUK&#x7f;TUM&#x7f;TUP&#x7f;TUR&#x7f;TUT&#x7f;TVL&#x7f;TW&#x7f;TWI&#x7f;TY&#x7f;TYV&#x7f;UDM&#x7f;UG&#x7f;UGA&#x7f;UIG&#x7f;UK&#x7f;UKR&#x7f;UMB&#x7f;UND&#x7f;UR&#x7f;URD&#x7f;UZ&#x7f;UZB&#x7f;VAI&#x7f;VE&#x7f;VEN&#x7f;VI&#x7f;VIE&#x7f;VO&#x7f;VOL&#x7f;VOT&#x7f;WA&#x7f;WAK&#x7f;WAL&#x7f;WAR&#x7f;WAS&#x7f;WEL (B) CYM (T)&#x7f;WEL (B) CYM (T)&#x7f;WEN&#x7f;WLN&#x7f;WO&#x7f;WOL&#x7f;XAL&#x7f;XH&#x7f;XHO&#x7f;YAO&#x7f;YAP&#x7f;YI&#x7f;YID&#x7f;YO&#x7f;YOR&#x7f;YPK&#x7f;ZA&#x7f;ZAP&#x7f;ZBL&#x7f;ZEN&#x7f;ZGH&#x7f;ZH&#x7f;ZH&#x7f;ZHA&#x7f;ZND&#x7f;ZU&#x7f;ZUL&#x7f;ZUN&#x7f;ZXX&#x7f;ZZA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(@listName!='Language Code') ) and ( not(@listID!='ISO 639') ) and ( not(@listVersionID!='2018-02-14') ) and ( not(@listSchemeURI!='urn:iso:std:iso:639') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.2/cl/gc/default/LanguageCode-2.2.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AA&#x7f;AAR&#x7f;AB&#x7f;ABK&#x7f;ACE&#x7f;ACH&#x7f;ADA&#x7f;ADY&#x7f;AE&#x7f;AF&#x7f;AFA&#x7f;AFH&#x7f;AFR&#x7f;AIN&#x7f;AK&#x7f;AKA&#x7f;AKK&#x7f;ALB (B) SQI (T)&#x7f;ALB (B) SQI (T)&#x7f;ALE&#x7f;ALG&#x7f;ALT&#x7f;AM&#x7f;AMH&#x7f;AN&#x7f;ANG&#x7f;ANP&#x7f;APA&#x7f;AR&#x7f;ARA&#x7f;ARC&#x7f;ARG&#x7f;ARM (B) HYE (T)&#x7f;ARM (B) HYE (T)&#x7f;ARN&#x7f;ARP&#x7f;ART&#x7f;ARW&#x7f;AS&#x7f;ASM&#x7f;AST&#x7f;ATH&#x7f;AUS&#x7f;AV&#x7f;AVA&#x7f;AVE&#x7f;AWA&#x7f;AY&#x7f;AYM&#x7f;AZ&#x7f;AZE&#x7f;BA&#x7f;BAD&#x7f;BAI&#x7f;BAK&#x7f;BAL&#x7f;BAM&#x7f;BAN&#x7f;BAQ (B) EUS (T)&#x7f;BAQ (B) EUS (T)&#x7f;BAS&#x7f;BAT&#x7f;BE&#x7f;BEJ&#x7f;BEL&#x7f;BEM&#x7f;BEN&#x7f;BER&#x7f;BG&#x7f;BH&#x7f;BHO&#x7f;BI&#x7f;BIH&#x7f;BIK&#x7f;BIN&#x7f;BIS&#x7f;BLA&#x7f;BM&#x7f;BN&#x7f;BNT&#x7f;BO&#x7f;BO&#x7f;BOS&#x7f;BR&#x7f;BRA&#x7f;BRE&#x7f;BS&#x7f;BTK&#x7f;BUA&#x7f;BUG&#x7f;BUL&#x7f;BUR (B) MYA (T)&#x7f;BUR (B) MYA (T)&#x7f;BYN&#x7f;CA&#x7f;CAD&#x7f;CAI&#x7f;CAR&#x7f;CAT&#x7f;CAU&#x7f;CE&#x7f;CEB&#x7f;CEL&#x7f;CH&#x7f;CHA&#x7f;CHB&#x7f;CHE&#x7f;CHG&#x7f;CHI (B) ZHO (T)&#x7f;CHI (B) ZHO (T)&#x7f;CHK&#x7f;CHM&#x7f;CHN&#x7f;CHO&#x7f;CHP&#x7f;CHR&#x7f;CHU&#x7f;CHV&#x7f;CHY&#x7f;CMC&#x7f;CNR&#x7f;CO&#x7f;COP&#x7f;COR&#x7f;COS&#x7f;CPE&#x7f;CPF&#x7f;CPP&#x7f;CR&#x7f;CRE&#x7f;CRH&#x7f;CRP&#x7f;CS&#x7f;CS&#x7f;CSB&#x7f;CU&#x7f;CUS&#x7f;CV&#x7f;CY&#x7f;CY&#x7f;CZE (B) CES (T)&#x7f;CZE (B) CES (T)&#x7f;DA&#x7f;DAK&#x7f;DAN&#x7f;DAR&#x7f;DAY&#x7f;DE&#x7f;DE&#x7f;DEL&#x7f;DEN&#x7f;DGR&#x7f;DIN&#x7f;DIV&#x7f;DOI&#x7f;DRA&#x7f;DSB&#x7f;DUA&#x7f;DUM&#x7f;DUT (B) NLD (T)&#x7f;DUT (B) NLD (T)&#x7f;DV&#x7f;DYU&#x7f;DZ&#x7f;DZO&#x7f;EE&#x7f;EFI&#x7f;EGY&#x7f;EKA&#x7f;EL&#x7f;EL&#x7f;ELX&#x7f;EN&#x7f;ENG&#x7f;ENM&#x7f;EO&#x7f;EPO&#x7f;ES&#x7f;EST&#x7f;ET&#x7f;EU&#x7f;EU&#x7f;EWE&#x7f;EWO&#x7f;FA&#x7f;FA&#x7f;FAN&#x7f;FAO&#x7f;FAT&#x7f;FF&#x7f;FI&#x7f;FIJ&#x7f;FIL&#x7f;FIN&#x7f;FIU&#x7f;FJ&#x7f;FO&#x7f;FON&#x7f;FR&#x7f;FR&#x7f;FRE (B) FRA (T)&#x7f;FRE (B) FRA (T)&#x7f;FRM&#x7f;FRO&#x7f;FRR&#x7f;FRS&#x7f;FRY&#x7f;FUL&#x7f;FUR&#x7f;FY&#x7f;GA&#x7f;GAA&#x7f;GAY&#x7f;GBA&#x7f;GD&#x7f;GEM&#x7f;GEO (B) KAT (T)&#x7f;GEO (B) KAT (T)&#x7f;GER (B) DEU (T)&#x7f;GER (B) DEU (T)&#x7f;GEZ&#x7f;GIL&#x7f;GL&#x7f;GLA&#x7f;GLE&#x7f;GLG&#x7f;GLV&#x7f;GMH&#x7f;GN&#x7f;GOH&#x7f;GON&#x7f;GOR&#x7f;GOT&#x7f;GRB&#x7f;GRC&#x7f;GRE (B) ELL (T)&#x7f;GRE (B) ELL (T)&#x7f;GRN&#x7f;GSW&#x7f;GU&#x7f;GUJ&#x7f;GV&#x7f;GWI&#x7f;HA&#x7f;HAI&#x7f;HAT&#x7f;HAU&#x7f;HAW&#x7f;HE&#x7f;HEB&#x7f;HER&#x7f;HI&#x7f;HIL&#x7f;HIM&#x7f;HIN&#x7f;HIT&#x7f;HMN&#x7f;HMO&#x7f;HO&#x7f;HR&#x7f;HRV&#x7f;HSB&#x7f;HT&#x7f;HU&#x7f;HUN&#x7f;HUP&#x7f;HY&#x7f;HY&#x7f;HZ&#x7f;IA&#x7f;IBA&#x7f;IBO&#x7f;ICE (B) ISL (T)&#x7f;ICE (B) ISL (T)&#x7f;ID&#x7f;IDO&#x7f;IE&#x7f;IG&#x7f;II&#x7f;III&#x7f;IJO&#x7f;IK&#x7f;IKU&#x7f;ILE&#x7f;ILO&#x7f;INA&#x7f;INC&#x7f;IND&#x7f;INE&#x7f;INH&#x7f;IO&#x7f;IPK&#x7f;IRA&#x7f;IRO&#x7f;IS&#x7f;IS&#x7f;IT&#x7f;ITA&#x7f;IU&#x7f;JA&#x7f;JAV&#x7f;JBO&#x7f;JPN&#x7f;JPR&#x7f;JRB&#x7f;JV&#x7f;KA&#x7f;KA&#x7f;KAA&#x7f;KAB&#x7f;KAC&#x7f;KAL&#x7f;KAM&#x7f;KAN&#x7f;KAR&#x7f;KAS&#x7f;KAU&#x7f;KAW&#x7f;KAZ&#x7f;KBD&#x7f;KG&#x7f;KHA&#x7f;KHI&#x7f;KHM&#x7f;KHO&#x7f;KI&#x7f;KIK&#x7f;KIN&#x7f;KIR&#x7f;KJ&#x7f;KK&#x7f;KL&#x7f;KM&#x7f;KMB&#x7f;KN&#x7f;KO&#x7f;KOK&#x7f;KOM&#x7f;KON&#x7f;KOR&#x7f;KOS&#x7f;KPE&#x7f;KR&#x7f;KRC&#x7f;KRL&#x7f;KRO&#x7f;KRU&#x7f;KS&#x7f;KU&#x7f;KUA&#x7f;KUM&#x7f;KUR&#x7f;KUT&#x7f;KV&#x7f;KW&#x7f;KY&#x7f;LA&#x7f;LAD&#x7f;LAH&#x7f;LAM&#x7f;LAO&#x7f;LAT&#x7f;LAV&#x7f;LB&#x7f;LEZ&#x7f;LG&#x7f;LI&#x7f;LIM&#x7f;LIN&#x7f;LIT&#x7f;LN&#x7f;LO&#x7f;LOL&#x7f;LOZ&#x7f;LT&#x7f;LTZ&#x7f;LU&#x7f;LUA&#x7f;LUB&#x7f;LUG&#x7f;LUI&#x7f;LUN&#x7f;LUO&#x7f;LUS&#x7f;LV&#x7f;MAC (B) MKD (T)&#x7f;MAC (B) MKD (T)&#x7f;MAD&#x7f;MAG&#x7f;MAH&#x7f;MAI&#x7f;MAK&#x7f;MAL&#x7f;MAN&#x7f;MAO (B) MRI (T)&#x7f;MAO (B) MRI (T)&#x7f;MAP&#x7f;MAR&#x7f;MAS&#x7f;MAY (B) MSA (T)&#x7f;MAY (B) MSA (T)&#x7f;MDF&#x7f;MDR&#x7f;MEN&#x7f;MG&#x7f;MGA&#x7f;MH&#x7f;MI&#x7f;MI&#x7f;MIC&#x7f;MIN&#x7f;MIS&#x7f;MK&#x7f;MK&#x7f;MKH&#x7f;ML&#x7f;MLG&#x7f;MLT&#x7f;MN&#x7f;MNC&#x7f;MNI&#x7f;MNO&#x7f;MOH&#x7f;MON&#x7f;MOS&#x7f;MR&#x7f;MS&#x7f;MS&#x7f;MT&#x7f;MUL&#x7f;MUN&#x7f;MUS&#x7f;MWL&#x7f;MWR&#x7f;MY&#x7f;MY&#x7f;MYN&#x7f;MYV&#x7f;NA&#x7f;NAH&#x7f;NAI&#x7f;NAP&#x7f;NAU&#x7f;NAV&#x7f;NB&#x7f;NBL&#x7f;ND&#x7f;NDE&#x7f;NDO&#x7f;NDS&#x7f;NE&#x7f;NEP&#x7f;NEW&#x7f;NG&#x7f;NIA&#x7f;NIC&#x7f;NIU&#x7f;NL&#x7f;NL&#x7f;NN&#x7f;NNO&#x7f;NO&#x7f;NOB&#x7f;NOG&#x7f;NON&#x7f;NOR&#x7f;NQO&#x7f;NR&#x7f;NSO&#x7f;NUB&#x7f;NV&#x7f;NWC&#x7f;NY&#x7f;NYA&#x7f;NYM&#x7f;NYN&#x7f;NYO&#x7f;NZI&#x7f;OC&#x7f;OCI&#x7f;OJ&#x7f;OJI&#x7f;OM&#x7f;OR&#x7f;ORI&#x7f;ORM&#x7f;OS&#x7f;OSA&#x7f;OSS&#x7f;OTA&#x7f;OTO&#x7f;PA&#x7f;PAA&#x7f;PAG&#x7f;PAL&#x7f;PAM&#x7f;PAN&#x7f;PAP&#x7f;PAU&#x7f;PEO&#x7f;PER (B) FAS (T)&#x7f;PER (B) FAS (T)&#x7f;PHI&#x7f;PHN&#x7f;PI&#x7f;PL&#x7f;PLI&#x7f;POL&#x7f;PON&#x7f;POR&#x7f;PRA&#x7f;PRO&#x7f;PS&#x7f;PT&#x7f;PUS&#x7f;QAA-QTZ&#x7f;QU&#x7f;QUE&#x7f;RAJ&#x7f;RAP&#x7f;RAR&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RO&#x7f;ROA&#x7f;ROH&#x7f;ROM&#x7f;RU&#x7f;RUM (B) RON (T)&#x7f;RUM (B) RON (T)&#x7f;RUN&#x7f;RUP&#x7f;RUS&#x7f;RW&#x7f;SA&#x7f;SAD&#x7f;SAG&#x7f;SAH&#x7f;SAI&#x7f;SAL&#x7f;SAM&#x7f;SAN&#x7f;SAS&#x7f;SAT&#x7f;SC&#x7f;SCN&#x7f;SCO&#x7f;SD&#x7f;SE&#x7f;SEL&#x7f;SEM&#x7f;SG&#x7f;SGA&#x7f;SGN&#x7f;SHN&#x7f;SI&#x7f;SID&#x7f;SIN&#x7f;SIO&#x7f;SIT&#x7f;SK&#x7f;SK&#x7f;SL&#x7f;SLA&#x7f;SLO (B) SLK (T)&#x7f;SLO (B) SLK (T)&#x7f;SLV&#x7f;SM&#x7f;SMA&#x7f;SME&#x7f;SMI&#x7f;SMJ&#x7f;SMN&#x7f;SMO&#x7f;SMS&#x7f;SN&#x7f;SNA&#x7f;SND&#x7f;SNK&#x7f;SO&#x7f;SOG&#x7f;SOM&#x7f;SON&#x7f;SOT&#x7f;SPA&#x7f;SQ&#x7f;SQ&#x7f;SR&#x7f;SRD&#x7f;SRN&#x7f;SRP&#x7f;SRR&#x7f;SS&#x7f;SSA&#x7f;SSW&#x7f;ST&#x7f;SU&#x7f;SUK&#x7f;SUN&#x7f;SUS&#x7f;SUX&#x7f;SV&#x7f;SW&#x7f;SWA&#x7f;SWE&#x7f;SYC&#x7f;SYR&#x7f;TA&#x7f;TAH&#x7f;TAI&#x7f;TAM&#x7f;TAT&#x7f;TE&#x7f;TEL&#x7f;TEM&#x7f;TER&#x7f;TET&#x7f;TG&#x7f;TGK&#x7f;TGL&#x7f;TH&#x7f;THA&#x7f;TI&#x7f;TIB (B) BOD (T)&#x7f;TIB (B) BOD (T)&#x7f;TIG&#x7f;TIR&#x7f;TIV&#x7f;TK&#x7f;TKL&#x7f;TL&#x7f;TLH&#x7f;TLI&#x7f;TMH&#x7f;TN&#x7f;TO&#x7f;TOG&#x7f;TON&#x7f;TPI&#x7f;TR&#x7f;TS&#x7f;TSI&#x7f;TSN&#x7f;TSO&#x7f;TT&#x7f;TUK&#x7f;TUM&#x7f;TUP&#x7f;TUR&#x7f;TUT&#x7f;TVL&#x7f;TW&#x7f;TWI&#x7f;TY&#x7f;TYV&#x7f;UDM&#x7f;UG&#x7f;UGA&#x7f;UIG&#x7f;UK&#x7f;UKR&#x7f;UMB&#x7f;UND&#x7f;UR&#x7f;URD&#x7f;UZ&#x7f;UZB&#x7f;VAI&#x7f;VE&#x7f;VEN&#x7f;VI&#x7f;VIE&#x7f;VO&#x7f;VOL&#x7f;VOT&#x7f;WA&#x7f;WAK&#x7f;WAL&#x7f;WAR&#x7f;WAS&#x7f;WEL (B) CYM (T)&#x7f;WEL (B) CYM (T)&#x7f;WEN&#x7f;WLN&#x7f;WO&#x7f;WOL&#x7f;XAL&#x7f;XH&#x7f;XHO&#x7f;YAO&#x7f;YAP&#x7f;YI&#x7f;YID&#x7f;YO&#x7f;YOR&#x7f;YPK&#x7f;ZA&#x7f;ZAP&#x7f;ZBL&#x7f;ZEN&#x7f;ZGH&#x7f;ZH&#x7f;ZH&#x7f;ZHA&#x7f;ZND&#x7f;ZU&#x7f;ZUL&#x7f;ZUN&#x7f;ZXX&#x7f;ZZA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Language Code') ) and ( not(@listID!='ISO 639') ) and ( not(@listVersionID!='2020-04-17') ) and ( not(@listSchemeURI!='urn:iso:std:iso:639') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/LanguageCode-2.3.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AA&#x7f;AAR&#x7f;AB&#x7f;ABK&#x7f;ACE&#x7f;ACH&#x7f;ADA&#x7f;ADY&#x7f;AE&#x7f;AF&#x7f;AFA&#x7f;AFH&#x7f;AFR&#x7f;AIN&#x7f;AK&#x7f;AKA&#x7f;AKK&#x7f;ALB (B) SQI (T)&#x7f;ALB (B) SQI (T)&#x7f;ALE&#x7f;ALG&#x7f;ALT&#x7f;AM&#x7f;AMH&#x7f;AN&#x7f;ANG&#x7f;ANP&#x7f;APA&#x7f;AR&#x7f;ARA&#x7f;ARC&#x7f;ARG&#x7f;ARM (B) HYE (T)&#x7f;ARM (B) HYE (T)&#x7f;ARN&#x7f;ARP&#x7f;ART&#x7f;ARW&#x7f;AS&#x7f;ASM&#x7f;AST&#x7f;ATH&#x7f;AUS&#x7f;AV&#x7f;AVA&#x7f;AVE&#x7f;AWA&#x7f;AY&#x7f;AYM&#x7f;AZ&#x7f;AZE&#x7f;BA&#x7f;BAD&#x7f;BAI&#x7f;BAK&#x7f;BAL&#x7f;BAM&#x7f;BAN&#x7f;BAQ (B) EUS (T)&#x7f;BAQ (B) EUS (T)&#x7f;BAS&#x7f;BAT&#x7f;BE&#x7f;BEJ&#x7f;BEL&#x7f;BEM&#x7f;BEN&#x7f;BER&#x7f;BG&#x7f;BH&#x7f;BHO&#x7f;BI&#x7f;BIH&#x7f;BIK&#x7f;BIN&#x7f;BIS&#x7f;BLA&#x7f;BM&#x7f;BN&#x7f;BNT&#x7f;BO&#x7f;BO&#x7f;BOS&#x7f;BR&#x7f;BRA&#x7f;BRE&#x7f;BS&#x7f;BTK&#x7f;BUA&#x7f;BUG&#x7f;BUL&#x7f;BUR (B) MYA (T)&#x7f;BUR (B) MYA (T)&#x7f;BYN&#x7f;CA&#x7f;CAD&#x7f;CAI&#x7f;CAR&#x7f;CAT&#x7f;CAU&#x7f;CE&#x7f;CEB&#x7f;CEL&#x7f;CH&#x7f;CHA&#x7f;CHB&#x7f;CHE&#x7f;CHG&#x7f;CHI (B) ZHO (T)&#x7f;CHI (B) ZHO (T)&#x7f;CHK&#x7f;CHM&#x7f;CHN&#x7f;CHO&#x7f;CHP&#x7f;CHR&#x7f;CHU&#x7f;CHV&#x7f;CHY&#x7f;CMC&#x7f;CNR&#x7f;CO&#x7f;COP&#x7f;COR&#x7f;COS&#x7f;CPE&#x7f;CPF&#x7f;CPP&#x7f;CR&#x7f;CRE&#x7f;CRH&#x7f;CRP&#x7f;CS&#x7f;CS&#x7f;CSB&#x7f;CU&#x7f;CUS&#x7f;CV&#x7f;CY&#x7f;CY&#x7f;CZE (B) CES (T)&#x7f;CZE (B) CES (T)&#x7f;DA&#x7f;DAK&#x7f;DAN&#x7f;DAR&#x7f;DAY&#x7f;DE&#x7f;DE&#x7f;DEL&#x7f;DEN&#x7f;DGR&#x7f;DIN&#x7f;DIV&#x7f;DOI&#x7f;DRA&#x7f;DSB&#x7f;DUA&#x7f;DUM&#x7f;DUT (B) NLD (T)&#x7f;DUT (B) NLD (T)&#x7f;DV&#x7f;DYU&#x7f;DZ&#x7f;DZO&#x7f;EE&#x7f;EFI&#x7f;EGY&#x7f;EKA&#x7f;EL&#x7f;EL&#x7f;ELX&#x7f;EN&#x7f;ENG&#x7f;ENM&#x7f;EO&#x7f;EPO&#x7f;ES&#x7f;EST&#x7f;ET&#x7f;EU&#x7f;EU&#x7f;EWE&#x7f;EWO&#x7f;FA&#x7f;FA&#x7f;FAN&#x7f;FAO&#x7f;FAT&#x7f;FF&#x7f;FI&#x7f;FIJ&#x7f;FIL&#x7f;FIN&#x7f;FIU&#x7f;FJ&#x7f;FO&#x7f;FON&#x7f;FR&#x7f;FR&#x7f;FRE (B) FRA (T)&#x7f;FRE (B) FRA (T)&#x7f;FRM&#x7f;FRO&#x7f;FRR&#x7f;FRS&#x7f;FRY&#x7f;FUL&#x7f;FUR&#x7f;FY&#x7f;GA&#x7f;GAA&#x7f;GAY&#x7f;GBA&#x7f;GD&#x7f;GEM&#x7f;GEO (B) KAT (T)&#x7f;GEO (B) KAT (T)&#x7f;GER (B) DEU (T)&#x7f;GER (B) DEU (T)&#x7f;GEZ&#x7f;GIL&#x7f;GL&#x7f;GLA&#x7f;GLE&#x7f;GLG&#x7f;GLV&#x7f;GMH&#x7f;GN&#x7f;GOH&#x7f;GON&#x7f;GOR&#x7f;GOT&#x7f;GRB&#x7f;GRC&#x7f;GRE (B) ELL (T)&#x7f;GRE (B) ELL (T)&#x7f;GRN&#x7f;GSW&#x7f;GU&#x7f;GUJ&#x7f;GV&#x7f;GWI&#x7f;HA&#x7f;HAI&#x7f;HAT&#x7f;HAU&#x7f;HAW&#x7f;HE&#x7f;HEB&#x7f;HER&#x7f;HI&#x7f;HIL&#x7f;HIM&#x7f;HIN&#x7f;HIT&#x7f;HMN&#x7f;HMO&#x7f;HO&#x7f;HR&#x7f;HRV&#x7f;HSB&#x7f;HT&#x7f;HU&#x7f;HUN&#x7f;HUP&#x7f;HY&#x7f;HY&#x7f;HZ&#x7f;IA&#x7f;IBA&#x7f;IBO&#x7f;ICE (B) ISL (T)&#x7f;ICE (B) ISL (T)&#x7f;ID&#x7f;IDO&#x7f;IE&#x7f;IG&#x7f;II&#x7f;III&#x7f;IJO&#x7f;IK&#x7f;IKU&#x7f;ILE&#x7f;ILO&#x7f;INA&#x7f;INC&#x7f;IND&#x7f;INE&#x7f;INH&#x7f;IO&#x7f;IPK&#x7f;IRA&#x7f;IRO&#x7f;IS&#x7f;IS&#x7f;IT&#x7f;ITA&#x7f;IU&#x7f;JA&#x7f;JAV&#x7f;JBO&#x7f;JPN&#x7f;JPR&#x7f;JRB&#x7f;JV&#x7f;KA&#x7f;KA&#x7f;KAA&#x7f;KAB&#x7f;KAC&#x7f;KAL&#x7f;KAM&#x7f;KAN&#x7f;KAR&#x7f;KAS&#x7f;KAU&#x7f;KAW&#x7f;KAZ&#x7f;KBD&#x7f;KG&#x7f;KHA&#x7f;KHI&#x7f;KHM&#x7f;KHO&#x7f;KI&#x7f;KIK&#x7f;KIN&#x7f;KIR&#x7f;KJ&#x7f;KK&#x7f;KL&#x7f;KM&#x7f;KMB&#x7f;KN&#x7f;KO&#x7f;KOK&#x7f;KOM&#x7f;KON&#x7f;KOR&#x7f;KOS&#x7f;KPE&#x7f;KR&#x7f;KRC&#x7f;KRL&#x7f;KRO&#x7f;KRU&#x7f;KS&#x7f;KU&#x7f;KUA&#x7f;KUM&#x7f;KUR&#x7f;KUT&#x7f;KV&#x7f;KW&#x7f;KY&#x7f;LA&#x7f;LAD&#x7f;LAH&#x7f;LAM&#x7f;LAO&#x7f;LAT&#x7f;LAV&#x7f;LB&#x7f;LEZ&#x7f;LG&#x7f;LI&#x7f;LIM&#x7f;LIN&#x7f;LIT&#x7f;LN&#x7f;LO&#x7f;LOL&#x7f;LOZ&#x7f;LT&#x7f;LTZ&#x7f;LU&#x7f;LUA&#x7f;LUB&#x7f;LUG&#x7f;LUI&#x7f;LUN&#x7f;LUO&#x7f;LUS&#x7f;LV&#x7f;MAC (B) MKD (T)&#x7f;MAC (B) MKD (T)&#x7f;MAD&#x7f;MAG&#x7f;MAH&#x7f;MAI&#x7f;MAK&#x7f;MAL&#x7f;MAN&#x7f;MAO (B) MRI (T)&#x7f;MAO (B) MRI (T)&#x7f;MAP&#x7f;MAR&#x7f;MAS&#x7f;MAY (B) MSA (T)&#x7f;MAY (B) MSA (T)&#x7f;MDF&#x7f;MDR&#x7f;MEN&#x7f;MG&#x7f;MGA&#x7f;MH&#x7f;MI&#x7f;MI&#x7f;MIC&#x7f;MIN&#x7f;MIS&#x7f;MK&#x7f;MK&#x7f;MKH&#x7f;ML&#x7f;MLG&#x7f;MLT&#x7f;MN&#x7f;MNC&#x7f;MNI&#x7f;MNO&#x7f;MOH&#x7f;MON&#x7f;MOS&#x7f;MR&#x7f;MS&#x7f;MS&#x7f;MT&#x7f;MUL&#x7f;MUN&#x7f;MUS&#x7f;MWL&#x7f;MWR&#x7f;MY&#x7f;MY&#x7f;MYN&#x7f;MYV&#x7f;NA&#x7f;NAH&#x7f;NAI&#x7f;NAP&#x7f;NAU&#x7f;NAV&#x7f;NB&#x7f;NBL&#x7f;ND&#x7f;NDE&#x7f;NDO&#x7f;NDS&#x7f;NE&#x7f;NEP&#x7f;NEW&#x7f;NG&#x7f;NIA&#x7f;NIC&#x7f;NIU&#x7f;NL&#x7f;NL&#x7f;NN&#x7f;NNO&#x7f;NO&#x7f;NOB&#x7f;NOG&#x7f;NON&#x7f;NOR&#x7f;NQO&#x7f;NR&#x7f;NSO&#x7f;NUB&#x7f;NV&#x7f;NWC&#x7f;NY&#x7f;NYA&#x7f;NYM&#x7f;NYN&#x7f;NYO&#x7f;NZI&#x7f;OC&#x7f;OCI&#x7f;OJ&#x7f;OJI&#x7f;OM&#x7f;OR&#x7f;ORI&#x7f;ORM&#x7f;OS&#x7f;OSA&#x7f;OSS&#x7f;OTA&#x7f;OTO&#x7f;PA&#x7f;PAA&#x7f;PAG&#x7f;PAL&#x7f;PAM&#x7f;PAN&#x7f;PAP&#x7f;PAU&#x7f;PEO&#x7f;PER (B) FAS (T)&#x7f;PER (B) FAS (T)&#x7f;PHI&#x7f;PHN&#x7f;PI&#x7f;PL&#x7f;PLI&#x7f;POL&#x7f;PON&#x7f;POR&#x7f;PRA&#x7f;PRO&#x7f;PS&#x7f;PT&#x7f;PUS&#x7f;QAA-QTZ&#x7f;QU&#x7f;QUE&#x7f;RAJ&#x7f;RAP&#x7f;RAR&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RO&#x7f;ROA&#x7f;ROH&#x7f;ROM&#x7f;RU&#x7f;RUM (B) RON (T)&#x7f;RUM (B) RON (T)&#x7f;RUN&#x7f;RUP&#x7f;RUS&#x7f;RW&#x7f;SA&#x7f;SAD&#x7f;SAG&#x7f;SAH&#x7f;SAI&#x7f;SAL&#x7f;SAM&#x7f;SAN&#x7f;SAS&#x7f;SAT&#x7f;SC&#x7f;SCN&#x7f;SCO&#x7f;SD&#x7f;SE&#x7f;SEL&#x7f;SEM&#x7f;SG&#x7f;SGA&#x7f;SGN&#x7f;SHN&#x7f;SI&#x7f;SID&#x7f;SIN&#x7f;SIO&#x7f;SIT&#x7f;SK&#x7f;SK&#x7f;SL&#x7f;SLA&#x7f;SLO (B) SLK (T)&#x7f;SLO (B) SLK (T)&#x7f;SLV&#x7f;SM&#x7f;SMA&#x7f;SME&#x7f;SMI&#x7f;SMJ&#x7f;SMN&#x7f;SMO&#x7f;SMS&#x7f;SN&#x7f;SNA&#x7f;SND&#x7f;SNK&#x7f;SO&#x7f;SOG&#x7f;SOM&#x7f;SON&#x7f;SOT&#x7f;SPA&#x7f;SQ&#x7f;SQ&#x7f;SR&#x7f;SRD&#x7f;SRN&#x7f;SRP&#x7f;SRR&#x7f;SS&#x7f;SSA&#x7f;SSW&#x7f;ST&#x7f;SU&#x7f;SUK&#x7f;SUN&#x7f;SUS&#x7f;SUX&#x7f;SV&#x7f;SW&#x7f;SWA&#x7f;SWE&#x7f;SYC&#x7f;SYR&#x7f;TA&#x7f;TAH&#x7f;TAI&#x7f;TAM&#x7f;TAT&#x7f;TE&#x7f;TEL&#x7f;TEM&#x7f;TER&#x7f;TET&#x7f;TG&#x7f;TGK&#x7f;TGL&#x7f;TH&#x7f;THA&#x7f;TI&#x7f;TIB (B) BOD (T)&#x7f;TIB (B) BOD (T)&#x7f;TIG&#x7f;TIR&#x7f;TIV&#x7f;TK&#x7f;TKL&#x7f;TL&#x7f;TLH&#x7f;TLI&#x7f;TMH&#x7f;TN&#x7f;TO&#x7f;TOG&#x7f;TON&#x7f;TPI&#x7f;TR&#x7f;TS&#x7f;TSI&#x7f;TSN&#x7f;TSO&#x7f;TT&#x7f;TUK&#x7f;TUM&#x7f;TUP&#x7f;TUR&#x7f;TUT&#x7f;TVL&#x7f;TW&#x7f;TWI&#x7f;TY&#x7f;TYV&#x7f;UDM&#x7f;UG&#x7f;UGA&#x7f;UIG&#x7f;UK&#x7f;UKR&#x7f;UMB&#x7f;UND&#x7f;UR&#x7f;URD&#x7f;UZ&#x7f;UZB&#x7f;VAI&#x7f;VE&#x7f;VEN&#x7f;VI&#x7f;VIE&#x7f;VO&#x7f;VOL&#x7f;VOT&#x7f;WA&#x7f;WAK&#x7f;WAL&#x7f;WAR&#x7f;WAS&#x7f;WEL (B) CYM (T)&#x7f;WEL (B) CYM (T)&#x7f;WEN&#x7f;WLN&#x7f;WO&#x7f;WOL&#x7f;XAL&#x7f;XH&#x7f;XHO&#x7f;YAO&#x7f;YAP&#x7f;YI&#x7f;YID&#x7f;YO&#x7f;YOR&#x7f;YPK&#x7f;ZA&#x7f;ZAP&#x7f;ZBL&#x7f;ZEN&#x7f;ZGH&#x7f;ZH&#x7f;ZH&#x7f;ZHA&#x7f;ZND&#x7f;ZU&#x7f;ZUL&#x7f;ZUN&#x7f;ZXX&#x7f;ZZA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) or ( ( not(@listName!='Language Code') ) and ( not(@listID!='ISO 639') ) and ( not(@listVersionID!='2020-04-17') ) and ( not(@listSchemeURI!='urn:iso:std:iso:639') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.3/cl/gc/default/LanguageCode-2.3.gc') ) and ( not(@listAgencyName!='International Organization for Standardization') ) and ( not(@listAgencyID!='5') ) and contains('&#x7f;AA&#x7f;AAR&#x7f;AB&#x7f;ABK&#x7f;ACE&#x7f;ACH&#x7f;ADA&#x7f;ADY&#x7f;AE&#x7f;AF&#x7f;AFA&#x7f;AFH&#x7f;AFR&#x7f;AIN&#x7f;AK&#x7f;AKA&#x7f;AKK&#x7f;ALB (B) SQI (T)&#x7f;ALB (B) SQI (T)&#x7f;ALE&#x7f;ALG&#x7f;ALT&#x7f;AM&#x7f;AMH&#x7f;AN&#x7f;ANG&#x7f;ANP&#x7f;APA&#x7f;AR&#x7f;ARA&#x7f;ARC&#x7f;ARG&#x7f;ARM (B) HYE (T)&#x7f;ARM (B) HYE (T)&#x7f;ARN&#x7f;ARP&#x7f;ART&#x7f;ARW&#x7f;AS&#x7f;ASM&#x7f;AST&#x7f;ATH&#x7f;AUS&#x7f;AV&#x7f;AVA&#x7f;AVE&#x7f;AWA&#x7f;AY&#x7f;AYM&#x7f;AZ&#x7f;AZE&#x7f;BA&#x7f;BAD&#x7f;BAI&#x7f;BAK&#x7f;BAL&#x7f;BAM&#x7f;BAN&#x7f;BAQ (B) EUS (T)&#x7f;BAQ (B) EUS (T)&#x7f;BAS&#x7f;BAT&#x7f;BE&#x7f;BEJ&#x7f;BEL&#x7f;BEM&#x7f;BEN&#x7f;BER&#x7f;BG&#x7f;BH&#x7f;BHO&#x7f;BI&#x7f;BIH&#x7f;BIK&#x7f;BIN&#x7f;BIS&#x7f;BLA&#x7f;BM&#x7f;BN&#x7f;BNT&#x7f;BO&#x7f;BO&#x7f;BOS&#x7f;BR&#x7f;BRA&#x7f;BRE&#x7f;BS&#x7f;BTK&#x7f;BUA&#x7f;BUG&#x7f;BUL&#x7f;BUR (B) MYA (T)&#x7f;BUR (B) MYA (T)&#x7f;BYN&#x7f;CA&#x7f;CAD&#x7f;CAI&#x7f;CAR&#x7f;CAT&#x7f;CAU&#x7f;CE&#x7f;CEB&#x7f;CEL&#x7f;CH&#x7f;CHA&#x7f;CHB&#x7f;CHE&#x7f;CHG&#x7f;CHI (B) ZHO (T)&#x7f;CHI (B) ZHO (T)&#x7f;CHK&#x7f;CHM&#x7f;CHN&#x7f;CHO&#x7f;CHP&#x7f;CHR&#x7f;CHU&#x7f;CHV&#x7f;CHY&#x7f;CMC&#x7f;CNR&#x7f;CO&#x7f;COP&#x7f;COR&#x7f;COS&#x7f;CPE&#x7f;CPF&#x7f;CPP&#x7f;CR&#x7f;CRE&#x7f;CRH&#x7f;CRP&#x7f;CS&#x7f;CS&#x7f;CSB&#x7f;CU&#x7f;CUS&#x7f;CV&#x7f;CY&#x7f;CY&#x7f;CZE (B) CES (T)&#x7f;CZE (B) CES (T)&#x7f;DA&#x7f;DAK&#x7f;DAN&#x7f;DAR&#x7f;DAY&#x7f;DE&#x7f;DE&#x7f;DEL&#x7f;DEN&#x7f;DGR&#x7f;DIN&#x7f;DIV&#x7f;DOI&#x7f;DRA&#x7f;DSB&#x7f;DUA&#x7f;DUM&#x7f;DUT (B) NLD (T)&#x7f;DUT (B) NLD (T)&#x7f;DV&#x7f;DYU&#x7f;DZ&#x7f;DZO&#x7f;EE&#x7f;EFI&#x7f;EGY&#x7f;EKA&#x7f;EL&#x7f;EL&#x7f;ELX&#x7f;EN&#x7f;ENG&#x7f;ENM&#x7f;EO&#x7f;EPO&#x7f;ES&#x7f;EST&#x7f;ET&#x7f;EU&#x7f;EU&#x7f;EWE&#x7f;EWO&#x7f;FA&#x7f;FA&#x7f;FAN&#x7f;FAO&#x7f;FAT&#x7f;FF&#x7f;FI&#x7f;FIJ&#x7f;FIL&#x7f;FIN&#x7f;FIU&#x7f;FJ&#x7f;FO&#x7f;FON&#x7f;FR&#x7f;FR&#x7f;FRE (B) FRA (T)&#x7f;FRE (B) FRA (T)&#x7f;FRM&#x7f;FRO&#x7f;FRR&#x7f;FRS&#x7f;FRY&#x7f;FUL&#x7f;FUR&#x7f;FY&#x7f;GA&#x7f;GAA&#x7f;GAY&#x7f;GBA&#x7f;GD&#x7f;GEM&#x7f;GEO (B) KAT (T)&#x7f;GEO (B) KAT (T)&#x7f;GER (B) DEU (T)&#x7f;GER (B) DEU (T)&#x7f;GEZ&#x7f;GIL&#x7f;GL&#x7f;GLA&#x7f;GLE&#x7f;GLG&#x7f;GLV&#x7f;GMH&#x7f;GN&#x7f;GOH&#x7f;GON&#x7f;GOR&#x7f;GOT&#x7f;GRB&#x7f;GRC&#x7f;GRE (B) ELL (T)&#x7f;GRE (B) ELL (T)&#x7f;GRN&#x7f;GSW&#x7f;GU&#x7f;GUJ&#x7f;GV&#x7f;GWI&#x7f;HA&#x7f;HAI&#x7f;HAT&#x7f;HAU&#x7f;HAW&#x7f;HE&#x7f;HEB&#x7f;HER&#x7f;HI&#x7f;HIL&#x7f;HIM&#x7f;HIN&#x7f;HIT&#x7f;HMN&#x7f;HMO&#x7f;HO&#x7f;HR&#x7f;HRV&#x7f;HSB&#x7f;HT&#x7f;HU&#x7f;HUN&#x7f;HUP&#x7f;HY&#x7f;HY&#x7f;HZ&#x7f;IA&#x7f;IBA&#x7f;IBO&#x7f;ICE (B) ISL (T)&#x7f;ICE (B) ISL (T)&#x7f;ID&#x7f;IDO&#x7f;IE&#x7f;IG&#x7f;II&#x7f;III&#x7f;IJO&#x7f;IK&#x7f;IKU&#x7f;ILE&#x7f;ILO&#x7f;INA&#x7f;INC&#x7f;IND&#x7f;INE&#x7f;INH&#x7f;IO&#x7f;IPK&#x7f;IRA&#x7f;IRO&#x7f;IS&#x7f;IS&#x7f;IT&#x7f;ITA&#x7f;IU&#x7f;JA&#x7f;JAV&#x7f;JBO&#x7f;JPN&#x7f;JPR&#x7f;JRB&#x7f;JV&#x7f;KA&#x7f;KA&#x7f;KAA&#x7f;KAB&#x7f;KAC&#x7f;KAL&#x7f;KAM&#x7f;KAN&#x7f;KAR&#x7f;KAS&#x7f;KAU&#x7f;KAW&#x7f;KAZ&#x7f;KBD&#x7f;KG&#x7f;KHA&#x7f;KHI&#x7f;KHM&#x7f;KHO&#x7f;KI&#x7f;KIK&#x7f;KIN&#x7f;KIR&#x7f;KJ&#x7f;KK&#x7f;KL&#x7f;KM&#x7f;KMB&#x7f;KN&#x7f;KO&#x7f;KOK&#x7f;KOM&#x7f;KON&#x7f;KOR&#x7f;KOS&#x7f;KPE&#x7f;KR&#x7f;KRC&#x7f;KRL&#x7f;KRO&#x7f;KRU&#x7f;KS&#x7f;KU&#x7f;KUA&#x7f;KUM&#x7f;KUR&#x7f;KUT&#x7f;KV&#x7f;KW&#x7f;KY&#x7f;LA&#x7f;LAD&#x7f;LAH&#x7f;LAM&#x7f;LAO&#x7f;LAT&#x7f;LAV&#x7f;LB&#x7f;LEZ&#x7f;LG&#x7f;LI&#x7f;LIM&#x7f;LIN&#x7f;LIT&#x7f;LN&#x7f;LO&#x7f;LOL&#x7f;LOZ&#x7f;LT&#x7f;LTZ&#x7f;LU&#x7f;LUA&#x7f;LUB&#x7f;LUG&#x7f;LUI&#x7f;LUN&#x7f;LUO&#x7f;LUS&#x7f;LV&#x7f;MAC (B) MKD (T)&#x7f;MAC (B) MKD (T)&#x7f;MAD&#x7f;MAG&#x7f;MAH&#x7f;MAI&#x7f;MAK&#x7f;MAL&#x7f;MAN&#x7f;MAO (B) MRI (T)&#x7f;MAO (B) MRI (T)&#x7f;MAP&#x7f;MAR&#x7f;MAS&#x7f;MAY (B) MSA (T)&#x7f;MAY (B) MSA (T)&#x7f;MDF&#x7f;MDR&#x7f;MEN&#x7f;MG&#x7f;MGA&#x7f;MH&#x7f;MI&#x7f;MI&#x7f;MIC&#x7f;MIN&#x7f;MIS&#x7f;MK&#x7f;MK&#x7f;MKH&#x7f;ML&#x7f;MLG&#x7f;MLT&#x7f;MN&#x7f;MNC&#x7f;MNI&#x7f;MNO&#x7f;MOH&#x7f;MON&#x7f;MOS&#x7f;MR&#x7f;MS&#x7f;MS&#x7f;MT&#x7f;MUL&#x7f;MUN&#x7f;MUS&#x7f;MWL&#x7f;MWR&#x7f;MY&#x7f;MY&#x7f;MYN&#x7f;MYV&#x7f;NA&#x7f;NAH&#x7f;NAI&#x7f;NAP&#x7f;NAU&#x7f;NAV&#x7f;NB&#x7f;NBL&#x7f;ND&#x7f;NDE&#x7f;NDO&#x7f;NDS&#x7f;NE&#x7f;NEP&#x7f;NEW&#x7f;NG&#x7f;NIA&#x7f;NIC&#x7f;NIU&#x7f;NL&#x7f;NL&#x7f;NN&#x7f;NNO&#x7f;NO&#x7f;NOB&#x7f;NOG&#x7f;NON&#x7f;NOR&#x7f;NQO&#x7f;NR&#x7f;NSO&#x7f;NUB&#x7f;NV&#x7f;NWC&#x7f;NY&#x7f;NYA&#x7f;NYM&#x7f;NYN&#x7f;NYO&#x7f;NZI&#x7f;OC&#x7f;OCI&#x7f;OJ&#x7f;OJI&#x7f;OM&#x7f;OR&#x7f;ORI&#x7f;ORM&#x7f;OS&#x7f;OSA&#x7f;OSS&#x7f;OTA&#x7f;OTO&#x7f;PA&#x7f;PAA&#x7f;PAG&#x7f;PAL&#x7f;PAM&#x7f;PAN&#x7f;PAP&#x7f;PAU&#x7f;PEO&#x7f;PER (B) FAS (T)&#x7f;PER (B) FAS (T)&#x7f;PHI&#x7f;PHN&#x7f;PI&#x7f;PL&#x7f;PLI&#x7f;POL&#x7f;PON&#x7f;POR&#x7f;PRA&#x7f;PRO&#x7f;PS&#x7f;PT&#x7f;PUS&#x7f;QAA-QTZ&#x7f;QU&#x7f;QUE&#x7f;RAJ&#x7f;RAP&#x7f;RAR&#x7f;RM&#x7f;RN&#x7f;RO&#x7f;RO&#x7f;ROA&#x7f;ROH&#x7f;ROM&#x7f;RU&#x7f;RUM (B) RON (T)&#x7f;RUM (B) RON (T)&#x7f;RUN&#x7f;RUP&#x7f;RUS&#x7f;RW&#x7f;SA&#x7f;SAD&#x7f;SAG&#x7f;SAH&#x7f;SAI&#x7f;SAL&#x7f;SAM&#x7f;SAN&#x7f;SAS&#x7f;SAT&#x7f;SC&#x7f;SCN&#x7f;SCO&#x7f;SD&#x7f;SE&#x7f;SEL&#x7f;SEM&#x7f;SG&#x7f;SGA&#x7f;SGN&#x7f;SHN&#x7f;SI&#x7f;SID&#x7f;SIN&#x7f;SIO&#x7f;SIT&#x7f;SK&#x7f;SK&#x7f;SL&#x7f;SLA&#x7f;SLO (B) SLK (T)&#x7f;SLO (B) SLK (T)&#x7f;SLV&#x7f;SM&#x7f;SMA&#x7f;SME&#x7f;SMI&#x7f;SMJ&#x7f;SMN&#x7f;SMO&#x7f;SMS&#x7f;SN&#x7f;SNA&#x7f;SND&#x7f;SNK&#x7f;SO&#x7f;SOG&#x7f;SOM&#x7f;SON&#x7f;SOT&#x7f;SPA&#x7f;SQ&#x7f;SQ&#x7f;SR&#x7f;SRD&#x7f;SRN&#x7f;SRP&#x7f;SRR&#x7f;SS&#x7f;SSA&#x7f;SSW&#x7f;ST&#x7f;SU&#x7f;SUK&#x7f;SUN&#x7f;SUS&#x7f;SUX&#x7f;SV&#x7f;SW&#x7f;SWA&#x7f;SWE&#x7f;SYC&#x7f;SYR&#x7f;TA&#x7f;TAH&#x7f;TAI&#x7f;TAM&#x7f;TAT&#x7f;TE&#x7f;TEL&#x7f;TEM&#x7f;TER&#x7f;TET&#x7f;TG&#x7f;TGK&#x7f;TGL&#x7f;TH&#x7f;THA&#x7f;TI&#x7f;TIB (B) BOD (T)&#x7f;TIB (B) BOD (T)&#x7f;TIG&#x7f;TIR&#x7f;TIV&#x7f;TK&#x7f;TKL&#x7f;TL&#x7f;TLH&#x7f;TLI&#x7f;TMH&#x7f;TN&#x7f;TO&#x7f;TOG&#x7f;TON&#x7f;TPI&#x7f;TR&#x7f;TS&#x7f;TSI&#x7f;TSN&#x7f;TSO&#x7f;TT&#x7f;TUK&#x7f;TUM&#x7f;TUP&#x7f;TUR&#x7f;TUT&#x7f;TVL&#x7f;TW&#x7f;TWI&#x7f;TY&#x7f;TYV&#x7f;UDM&#x7f;UG&#x7f;UGA&#x7f;UIG&#x7f;UK&#x7f;UKR&#x7f;UMB&#x7f;UND&#x7f;UR&#x7f;URD&#x7f;UZ&#x7f;UZB&#x7f;VAI&#x7f;VE&#x7f;VEN&#x7f;VI&#x7f;VIE&#x7f;VO&#x7f;VOL&#x7f;VOT&#x7f;WA&#x7f;WAK&#x7f;WAL&#x7f;WAR&#x7f;WAS&#x7f;WEL (B) CYM (T)&#x7f;WEL (B) CYM (T)&#x7f;WEN&#x7f;WLN&#x7f;WO&#x7f;WOL&#x7f;XAL&#x7f;XH&#x7f;XHO&#x7f;YAO&#x7f;YAP&#x7f;YI&#x7f;YID&#x7f;YO&#x7f;YOR&#x7f;YPK&#x7f;ZA&#x7f;ZAP&#x7f;ZBL&#x7f;ZEN&#x7f;ZGH&#x7f;ZH&#x7f;ZH&#x7f;ZHA&#x7f;ZND&#x7f;ZU&#x7f;ZUL&#x7f;ZUN&#x7f;ZXX&#x7f;ZZA&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'Language-2.2 Language-2.3 Language-2.4' in the context 'cbc:LocaleCode | cbc:NoticeLanguageCode | cbc:PreferredLanguageLocaleCode | cbc:TenderLanguageLocaleCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:LatitudeDirectionCode" priority="12" mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:LatitudeDirectionCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:LatitudeDirectionCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:LatitudeDirectionCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(@listName!='Latitude Direction') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.0') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:LatitudeDirectionCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/LatitudeDirectionCode-2.0.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;North&#x7f;South&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(@listName!='Latitude Direction') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.0') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:LatitudeDirectionCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/LatitudeDirectionCode-2.0.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;North&#x7f;South&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'LatitudeDirection-2.0' in the context 'cbc:LatitudeDirectionCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl:if>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="($schxslt:patterns-matched, 'd14e64')"/>
            </xsl:next-match>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="cbc:LineStatusCode" priority="11" mode="d14e64">
      <xsl:param name="schxslt:patterns-matched" as="xs:string*"/>
      <xsl:choose>
         <xsl:when test="$schxslt:patterns-matched[. = 'd14e64']">
            <schxslt:rule pattern="d14e64">
               <xsl:comment xmlns:svrl="http://purl.oclc.org/dsdl/svrl">WARNING: Rule for context "cbc:LineStatusCode" shadowed by preceding rule</xsl:comment>
               <svrl:suppressed-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:LineStatusCode</xsl:attribute>
               </svrl:suppressed-rule>
            </schxslt:rule>
            <xsl:next-match>
               <xsl:with-param name="schxslt:patterns-matched"
                               as="xs:string*"
                               select="$schxslt:patterns-matched"/>
            </xsl:next-match>
         </xsl:when>
         <xsl:otherwise>
            <schxslt:rule pattern="d14e64">
               <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl">
                  <xsl:attribute name="context">cbc:LineStatusCode</xsl:attribute>
               </svrl:fired-rule>
               <xsl:if test="not(( false() or ( ( not(@listName!='Line Status') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.0') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:LineStatusCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/LineStatusCode-2.0.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;Added&#x7f;Cancelled&#x7f;Disputed&#x7f;NoStatus&#x7f;Revised&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) )">
                  <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                      location="{schxslt:location(.)}">
                     <xsl:attribute name="test">( false() or ( ( not(@listName!='Line Status') ) and ( not(@listID!='') ) and ( not(@listVersionID!='2.0') ) and ( not(@listSchemeURI!='urn:oasis:names:specification:ubl:codelist:gc:LineStatusCode') ) and ( not(@listURI!='http://docs.oasis-open.org/ubl/os-UBL-2.0-update/cl/gc/default/LineStatusCode-2.0.gc') ) and ( not(@listAgencyName!='OASIS Universal Business Language') ) and ( not(@listAgencyID!='UBL') ) and contains('&#x7f;Added&#x7f;Cancelled&#x7f;Disputed&#x7f;NoStatus&#x7f;Revised&#x7f;',concat('&#x7f;',.,'&#x7f;')) ) ) </xsl:attribute>
                     <svrl:text>Value supplied '<xsl:value-of select="."/>' is unacceptable for constraints identified by 'LineStatus-2.0' in the context 'cbc:LineStatusCode'</svrl:text>
                  </svrl:failed-assert>
               </xsl: