/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.parsers;

import com.nwalsh.parsers.XParseError;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlresolver.Resolver;

public class XJParser {
    private static final String XSD11 = "http://www.w3.org/XML/XMLSchema/v1.1";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String EXTERNAL_SCHEMA_LOCATION_PROPERTY_ID = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String EXTERNAL_NONS_SCHEMA_LOCATION_PROPERTY_ID = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private boolean valid = true;
    private boolean nsAware = true;
    private boolean dtdValidate = true;
    private boolean xsdValidate = true;
    private boolean xsd11 = false;
    private boolean fullChecking = false;
    private Collection<String> schemas = null;
    private XParseError errhandler = new XParseError();
    private Date startTime = null;
    private Date endTime = null;
    private Resolver resolver = null;

    public void setDtdValidate(boolean bl) {
        this.dtdValidate = bl;
    }

    public void setXsdValidate(boolean bl) {
        this.xsdValidate = bl;
    }

    public void setNamespaceAware(boolean bl) {
        this.nsAware = bl;
    }

    public void setFullChecking(boolean bl) {
        this.fullChecking = bl;
    }

    public void setSchemas(Collection<String> collection) {
        this.schemas = collection;
    }

    public void setXSD11(boolean bl) {
        this.xsd11 = bl;
    }

    public void setMaxMessages(int n) {
        this.errhandler.setMaxMessages(n);
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public int getErrorCount() {
        return this.errhandler.getErrorCount();
    }

    public boolean parse(String string) {
        if (this.xsdValidate) {
            return this.xsdParse(string);
        }
        return this.dtdParse(string);
    }

    private boolean xsdParse(String string) {
        Object object;
        Source[] sourceArray = null;
        if (this.schemas != null) {
            sourceArray = new StreamSource[this.schemas.size()];
            int n = 0;
            for (String object2 : this.schemas) {
                object = new StreamSource(object2);
                sourceArray[n] = object;
            }
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(this.xsd11 ? XSD11 : "http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver((LSResourceResolver)this.resolver);
            Object object3 = null;
            object3 = sourceArray == null ? schemaFactory.newSchema() : schemaFactory.newSchema(sourceArray);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(this.nsAware);
            sAXParserFactory.setValidating(this.dtdValidate);
            sAXParserFactory.setSchema((Schema)object3);
            sAXParserFactory.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, this.fullChecking);
            this.valid = true;
            object = sAXParserFactory.newSAXParser();
            this.startTime = new Date();
            ((SAXParser)object).parse(string, (DefaultHandler)new ParseHandler());
            this.endTime = new Date();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.valid;
    }

    public boolean dtdParse(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(this.nsAware);
            sAXParserFactory.setValidating(this.dtdValidate);
            this.valid = true;
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this.startTime = new Date();
            sAXParser.parse(string, (DefaultHandler)new ParseHandler());
            this.endTime = new Date();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.valid;
    }

    public void printParseStats() {
        long l = this.endTime.getTime() - this.startTime.getTime();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        if (l > 1000L) {
            l2 = l / 1000L;
            l %= 1000L;
        }
        if (l2 > 60L) {
            l3 = l2 / 60L;
            l2 %= 60L;
        }
        if (l3 > 60L) {
            l4 = l3 / 60L;
            l3 %= 60L;
        }
        if (this.errhandler.getMaxMessages() > 0) {
            System.out.print("Parse ");
            if (this.errhandler.getFatalCount() > 0) {
                System.out.print("failed ");
            } else {
                System.out.print("succeeded ");
                System.out.print("(");
                if (l4 > 0L) {
                    System.out.print(l4 + ":");
                }
                if (l4 > 0L || l3 > 0L) {
                    System.out.print(l3 + ":");
                }
                System.out.print(l2 + "." + l);
                System.out.print(") ");
            }
            System.out.print("with ");
            int n = this.errhandler.getErrorCount();
            int n2 = this.errhandler.getWarningCount();
            if (n > 0) {
                System.out.print(n + " error");
                System.out.print(n > 1 ? "s" : "");
                System.out.print(" and ");
            } else {
                System.out.print("no errors and ");
            }
            if (n2 > 0) {
                System.out.print(n2 + " warning");
                System.out.print(n2 > 1 ? "s" : "");
                System.out.print(".");
            } else {
                System.out.print("no warnings.");
            }
            System.out.println("");
        }
    }

    private class ParseHandler
    extends DefaultHandler {
        private ParseHandler() {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            XJParser.this.errhandler.fatalError(sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            XJParser.this.errhandler.error(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            XJParser.this.errhandler.warning(sAXParseException);
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            return XJParser.this.resolver.resolveEntity(string, string2);
        }
    }
}

